/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libmspub project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_SHAPETYPE_H
#define INCLUDED_SHAPETYPE_H

namespace libmspub
{
enum ShapeType
{
  UNKNOWN_SHAPE        = -1,
  NOT_PRIMITIVE        = 0,
  RECTANGLE            = 1,
  ROUND_RECTANGLE      = 2,
  ELLIPSE              = 3,
  DIAMOND              = 4,
  ISOCELES_TRIANGLE    = 5,
  RIGHT_TRIANGLE       = 6,
  PARALLELOGRAM        = 7,
  TRAPEZOID            = 8,
  HEXAGON              = 9,
  OCTAGON              = 10,
  PLUS                 = 11,
  STAR                 = 12,
  ARROW                = 13,
  HOME_PLATE           = 15,
  CUBE                 = 16,
  BALLOON              = 17,
  ARC_SHAPE            = 19,
  LINE                 = 20,
  PLAQUE               = 21,
  CAN                  = 22,
  DONUT                = 23,
  TEXT_SIMPLE          = 24,
  STRAIGHT_CONNECTOR_1 = 32,
  BENT_CONNECTOR_2     = 33,
  BENT_CONNECTOR_3     = 34,
  BENT_CONNECTOR_4     = 35,
  BENT_CONNECTOR_5     = 36,
  CURVED_CONNECTOR_2   = 37,
  CURVED_CONNECTOR_3   = 38,
  CURVED_CONNECTOR_4   = 39,
  CURVED_CONNECTOR_5   = 40,
  CALLOUT_1            = 41,
  CALLOUT_2            = 42,
  CALLOUT_3            = 43,
  RIBBON               = 53,
  RIBBON_2             = 54,
  CHEVRON              = 55,
  PENTAGON             = 56,
  NO_SMOKING           = 57,
  SEAL_8               = 58,
  SEAL_16              = 59,
  SEAL_32              = 60,
  WAVE                 = 64,
  FOLDED_CORNER        = 65,
  LEFT_ARROW           = 66,
  DOWN_ARROW           = 67,
  UP_ARROW             = 68,
  LEFT_RIGHT_ARROW     = 69,
  UP_DOWN_ARROW        = 70,
  IRREGULAR_SEAL_1     = 71,
  IRREGULAR_SEAL_2     = 72,
  LIGHTNING_BOLT       = 73,
  HEART                = 74,
  PICTURE_FRAME        = 75,
  QUAD_ARROW           = 76,
  BEVEL                = 84,
  LEFT_BRACKET         = 85,
  RIGHT_BRACKET        = 86,
  LEFT_BRACE           = 87,
  RIGHT_BRACE          = 88,
  LEFT_UP_ARROW        = 89,
  BENT_UP_ARROW        = 90,
  BENT_ARROW           = 91,
  SEAL_24              = 92,
  STRIPED_RIGHT_ARROW  = 93,
  NOTCHED_RIGHT_ARROW  = 94,
  BLOCK_ARC            = 95,
  SMILEY_FACE          = 96,
  VERTICAL_SCROLL      = 97,
  HORIZONTAL_SCROLL    = 98,
  CIRCULAR_ARROW       = 99,
  CUSTOM              = 100,
  U_TURN_ARROW         = 101,
  CURVED_RIGHT_ARROW   = 102,
  CURVED_LEFT_ARROW    = 103,
  CURVED_UP_ARROW      = 104,
  CURVED_DOWN_ARROW    = 105,
  FLOW_CHART_PROCESS   = 109,
  FLOW_CHART_DECISION  = 110,
  FLOW_CHART_IO        = 111,
  FLOW_CHART_PREDEFINED_PROCESS = 112,
  FLOW_CHART_INTERNAL_STORAGE   = 113,
  FLOW_CHART_DOCUMENT  = 114,
  FLOW_CHART_MULTI_DOCUMENT     = 115,
  FLOW_CHART_TERMINATOR         = 116,
  FLOW_CHART_PREPARATION        = 117,
  FLOW_CHART_MANUAL_INPUT       = 118,
  FLOW_CHART_MANUAL_OPERATION   = 119,
  FLOW_CHART_CONNECTOR          = 120,
  FLOW_CHART_PUNCHED_CARD       = 121,
  FLOW_CHART_PUNCHED_TAPE       = 122,
  FLOW_CHART_SUMMING_JUNCTION   = 123,
  FLOW_CHART_OR        = 124,
  FLOW_CHART_COLLATE   = 125,
  FLOW_CHART_SORT      = 126,
  FLOW_CHART_EXTRACT   = 127,
  FLOW_CHART_MERGE     = 128,
  FLOW_CHART_ONLINE_STORAGE     = 130,
  FLOW_CHART_MAGNETIC_TAPE      = 131,
  FLOW_CHART_MAGNETIC_DISK      = 132,
  FLOW_CHART_MAGNETIC_DRUM      = 133,
  FLOW_CHART_DISPLAY  = 134,
  FLOW_CHART_DELAY    = 135,
  TEXT_PLAIN_TEXT     = 136,
  TEXT_STOP           = 137,
  TEXT_TRIANGLE       = 138,
  TEXT_TRIANGLE_INVERTED        = 139,
  TEXT_CHEVRON        = 140,
  TEXT_CHEVRON_INVERTED         = 141,
  TEXT_RING_OUTSIDE   = 143,
  TEXT_ARCH_UP_CURVE  = 144,
  TEXT_ARCH_DOWN_CURVE          = 145,
  TEXT_CIRCLE_CURVE   = 146,
  TEXT_BUTTON_CURVE   = 147,
  TEXT_ARCH_UP_POUR   = 148,
  TEXT_ARCH_DOWN_POUR = 149,
  TEXT_CIRCLE_POUR    = 150,
  TEXT_BUTTON_POUR    = 151,
  TEXT_CURVE_UP       = 152,
  TEXT_CURVE_DOWN     = 153,
  TEXT_CASCADE_UP     = 154,
  TEXT_CASCADE_DOWN   = 155,
  TEXT_WAVE_1         = 156,
  TEXT_WAVE_2         = 157,
  TEXT_WAVE_3         = 158,
  TEXT_WAVE_4         = 159,
  TEXT_INFLATE        = 160,
  TEXT_DEFLATE        = 161,
  TEXT_INFLATE_BOTTOM = 162,
  TEXT_DEFLATE_BOTTOM = 163,
  TEXT_INFLATE_TOP    = 164,
  TEXT_DEFLATE_TOP    = 165,
  TEXT_DEFLATE_INFLATE          = 166,
  TEXT_DEFLATE_INFLATE_DEFLATE  = 167,
  TEXT_FADE_RIGHT     = 168,
  TEXT_FADE_LEFT      = 169,
  TEXT_FADE_UP        = 170,
  TEXT_FADE_DOWN      = 171,
  TEXT_SLANT_UP       = 172,
  TEXT_SLANT_DOWN     = 173,
  TEXT_CAN_UP         = 174,
  TEXT_CAN_DOWN       = 175,
  FLOW_CHART_ALTERNATE_PROCESS  = 176,
  FLOW_CHART_OFFPAGE_CONNECTOR  = 177,
  LEFT_RIGHT_UP_ARROW = 182,
  SUN                 = 183,
  MOON                = 184,
  BRACKET_PAIR        = 185,
  BRACE_PAIR          = 186,
  SEAL_4              = 187,
  DOUBLE_WAVE         = 188,
  ACTION_BUTTON_BLANK = 189,
  ACTION_BUTTON_HOME  = 190,
  ACTION_BUTTON_HELP  = 191,
  ACTION_BUTTON_INFORMATION     = 192,
  ACTION_BUTTON_FORWARD_NEXT    = 193,
  ACTION_BUTTON_BACK_PREVIOUS   = 194,
  ACTION_BUTTON_END   = 195,
  ACTION_BUTTON_BEGINNING       = 196,
  ACTION_BUTTON_RETURN          = 197,
  ACTION_BUTTON_DOCUMENT        = 198,
  ACTION_BUTTON_SOUND           = 199,
  ACTION_BUTTON_MOVIE           = 200,
  TEXT_BOX            = 202
};
} // libmspub
#endif /* INCLUDED_SHAPETYPE_H */
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
