/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_VCL_NOTEBOOKBARADDONSMERGER_HXX
#define INCLUDED_VCL_NOTEBOOKBARADDONSMERGER_HXX

#include <vcl/builder.hxx>
#include <vcl/window.hxx>
#include <vcl/image.hxx>
#include <vcl/menu.hxx>
#include <com/sun/star/beans/PropertyValue.hpp>
#include <com/sun/star/frame/XFrame.hpp>
#include <com/sun/star/uno/Sequence.h>
#include <vector>
#include <map>

class Menu;

struct NotebookBarAddonsItem
{
    Image aImage;
    std::vector<Image> aImageValues;
    std::vector<css::uno::Sequence<css::uno::Sequence<css::beans::PropertyValue>>> aAddonValues;
};

struct AddonsParams
{
    OUString sImageId;
    OUString sControlType;
    sal_uInt16 nWidth;
};

struct AddonNotebookBarItem
{
    OUString sCommandURL;
    OUString sLabel;
    OUString sImageIdentifier;
    OUString sTarget;
    OUString sContext;
    OUString sControlType;
    sal_uInt16 nWidth;
    OUString sStyle;
};

class NotebookBarAddonsMerger
{
public:
    NotebookBarAddonsMerger();
    ~NotebookBarAddonsMerger();
    static void MergeNotebookBarAddons(vcl::Window* pParent,
                                       const VclBuilder::customMakeWidget& pFunction,
                                       const css::uno::Reference<css::frame::XFrame>& rFrame,
                                       const NotebookBarAddonsItem& aNotebookBarAddonsItem,
                                       VclBuilder::stringmap& rVec);
    static void MergeNotebookBarMenuAddons(Menu* pPopupMenu, sal_Int16 nItemId,
                                           const OString& sItemIdName,
                                           NotebookBarAddonsItem& aNotebookBarAddonsItem);
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
