/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <swtypes.hxx>
#include "dbtablepreviewdialog.hxx"
#include <comphelper/processfactory.hxx>
#include <com/sun/star/frame/Frame.hpp>
#include <toolkit/helper/vclunohelper.hxx>

#include <unomid.h>

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;

SwDBTablePreviewDialog::SwDBTablePreviewDialog(weld::Window* pParent, uno::Sequence< beans::PropertyValue> const & rValues)
    : SfxDialogController(pParent, "modules/swriter/ui/tablepreviewdialog.ui", "TablePreviewDialog")
    , m_xDescriptionFI(m_xBuilder->weld_label("description"))
    , m_xBeamerWIN(m_xBuilder->weld_container("beamer"))
{
    Size aSize(m_xBeamerWIN->get_approximate_digit_width() * 80,
               m_xBeamerWIN->get_text_height() * 18);
    m_xBeamerWIN->set_size_request(aSize.Width(), aSize.Height());

    auto pValue = std::find_if(rValues.begin(), rValues.end(),
        [](const beans::PropertyValue& rValue) { return rValue.Name == "Command"; });
    if (pValue != rValues.end())
    {
        OUString sDescription = m_xDescriptionFI->get_label();
        OUString sTemp;
        pValue->Value >>= sTemp;
        m_xDescriptionFI->set_label(sDescription.replaceFirst("%1", sTemp));
    }

    try
    {
        // create a frame wrapper for myself
        m_xFrame = frame::Frame::create( comphelper::getProcessComponentContext() );
        m_xFrame->initialize(m_xBeamerWIN->CreateChildFrame());
    }
    catch (uno::Exception const &)
    {
        m_xFrame.clear();
    }
    if (m_xFrame.is())
    {
        util::URL aURL;
        aURL.Complete = ".component:DB/DataSourceBrowser";
        uno::Reference<frame::XDispatch> xD = m_xFrame->queryDispatch(aURL, "", 0x0C);
        if(xD.is())
        {
            xD->dispatch(aURL, rValues);
            m_xBeamerWIN->show();
        }
    }
}

SwDBTablePreviewDialog::~SwDBTablePreviewDialog()
{
    if(m_xFrame.is())
    {
        m_xFrame->setComponent(nullptr, nullptr);
        m_xFrame->dispose();
        m_xFrame.clear();
    }
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
