/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptContentTest
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$encryption$EncryptContentTest == null ? (class$org$apache$xml$security$test$encryption$EncryptContentTest = EncryptContentTest.class$("org.apache.xml.security.test.encryption.EncryptContentTest")) : class$org$apache$xml$security$test$encryption$EncryptContentTest).getName());
    private static final String DATA = "<users>\n  <user>\n    <firstname>Bugs</firstname>\n    <lastname>Bunny</lastname>\n    <age>34</age>\n    <serial>Y10</serial>\n  </user>\n</users>\n";
    private static final String MULTIPLE_USER_DATA = "<users>\n  <user>\n    <firstname>Bugs</firstname>\n    <lastname>Bunny</lastname>\n  </user>\n  <user>\n    <firstname>Daffy</firstname>\n    <lastname>Duck</lastname>\n  </user>\n</users>\n";
    private DocumentBuilder db;
    private SecretKey secretKey;
    private boolean haveISOPadding;
    static /* synthetic */ Class class$org$apache$xml$security$test$encryption$EncryptContentTest;

    public static Test suite() throws Exception {
        return new TestSuite(class$org$apache$xml$security$test$encryption$EncryptContentTest == null ? (class$org$apache$xml$security$test$encryption$EncryptContentTest = EncryptContentTest.class$("org.apache.xml.security.test.encryption.EncryptContentTest")) : class$org$apache$xml$security$test$encryption$EncryptContentTest);
    }

    public EncryptContentTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
        byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
        DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
        this.secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.newTransformer();
        this.haveISOPadding = false;
        String string = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        if (string != null) {
            try {
                if (Cipher.getInstance(string) != null) {
                    this.haveISOPadding = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
    }

    public void testContentRemoved() throws Exception {
        Node node;
        Node node2;
        if (!this.haveISOPadding) {
            log.warn((Object)"Test testContentRemoved skipped as necessary algorithms not available");
            return;
        }
        Document document = this.db.parse(new ByteArrayInputStream(DATA.getBytes("UTF8")));
        NodeList nodeList = document.getElementsByTagName("user");
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        xMLCipher.init(1, (Key)this.secretKey);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            xMLCipher.doFinal(document, (Element)nodeList.item(i), true);
        }
        Element element = (Element)nodeList.item(0);
        for (node2 = element.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        Element element2 = (Element)node2;
        if (!element2.getLocalName().equals("EncryptedData")) {
            throw new Exception("Element content not replaced");
        }
        for (node = element2.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node != null) {
            throw new Exception("Sibling element content not replaced");
        }
    }

    public void testMultipleKeyInfoElements() throws Exception {
        if (!this.haveISOPadding) {
            log.warn((Object)"Test testMultipleKeyInfoElements skipped as necessary algorithms not available");
            return;
        }
        Document document = this.db.parse(new ByteArrayInputStream(MULTIPLE_USER_DATA.getBytes("UTF8")));
        NodeList nodeList = document.getElementsByTagName("user");
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        xMLCipher.init(1, (Key)this.secretKey);
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.addKeyName("mykey");
        EncryptedData encryptedData = xMLCipher.getEncryptedData();
        encryptedData.setKeyInfo(keyInfo);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            xMLCipher.doFinal(document, (Element)nodeList.item(i), true);
        }
        NodeList nodeList2 = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        EncryptContentTest.assertEquals((int)nodeList2.getLength(), (int)2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

