//%includeGuardStart {
#ifndef MUSHGAMERENDER_H
#define MUSHGAMERENDER_H
//%includeGuardStart } XiswxIPXAt8y2emYXbfSKw
//%Header {
/*****************************************************************************
 *
 * File: src/MushGame/MushGameRender.h
 *
 * Author: Andy Southgate 2002-2007
 *
 * This file contains original work by Andy Southgate.  The author and his
 * employer (Mushware Limited) irrevocably waive all of their copyright rights
 * vested in this particular version of this file to the furthest extent
 * permitted.  The author and Mushware Limited also irrevocably waive any and
 * all of their intellectual property rights arising from said file and its
 * creation that would otherwise restrict the rights of any party to use and/or
 * distribute the use of, the techniques and methods used herein.  A written
 * waiver can be obtained via http://www.mushware.com/.
 *
 * This software carries NO WARRANTY of any kind.
 *
 ****************************************************************************/
//%Header } j77f8x0w++6HF2k9QIQj/w
/*
 * $Id: MushGameRender.h,v 1.7 2007/04/16 08:41:10 southa Exp $
 * $Log: MushGameRender.h,v $
 * Revision 1.7  2007/04/16 08:41:10  southa
 * Level and header mods
 *
 * Revision 1.6  2007/02/08 17:55:15  southa
 * Common routines in space generation
 *
 * Revision 1.5  2006/07/20 12:22:22  southa
 * Precache display
 *
 * Revision 1.4  2006/06/01 15:39:26  southa
 * DrawArray verification and fixes
 *
 * Revision 1.3  2005/08/01 20:23:18  southa
 * Backdrop and build fixes
 *
 * Revision 1.2  2005/07/02 00:42:38  southa
 * Conditioning tweaks
 *
 * Revision 1.1  2005/06/29 11:11:15  southa
 * Camera and rendering work
 *
 */

#include "MushGameStandard.h"

class MushGameCamera;
class MushGameLogic;

//:generate standard ostream xml1
class MushGameRender : public MushcoreVirtualObject
{
public:
    virtual ~MushGameRender() {}
    virtual void GroupingNameSet(const std::string& inName) { m_groupingName = inName; }

    virtual void PrecacheRender(MushGameLogic& ioLogic, const MushGameCamera& inCamera);
    virtual void FrameRender(MushGameLogic& ioLogic, const MushGameCamera& inCamera);
    
private:
    std::string m_groupingName; //:read

//%classPrototypes {
public:
    const std::string& GroupingName(void) const { return m_groupingName; }
    virtual const char *AutoName(void) const;
    virtual MushcoreVirtualObject *AutoClone(void) const;
    virtual MushcoreVirtualObject *AutoCreate(void) const;
    static MushcoreVirtualObject *AutoVirtualFactory(void);
    virtual void AutoPrint(std::ostream& ioOut) const;
    virtual bool AutoXMLDataProcess(MushcoreXMLIStream& ioIn, const std::string& inTagStr);
    virtual void AutoXMLPrint(MushcoreXMLOStream& ioOut) const;
//%classPrototypes } LwveyIxAwfx75093rFgjKg
};
//%inlineHeader {
inline std::ostream&
operator<<(std::ostream& ioOut, const MushGameRender& inObj)
{
    inObj.AutoPrint(ioOut);
    return ioOut;
}
//%inlineHeader } Sfh3sa00ACUii0SCfVWg5g
//%includeGuardEnd {
#endif
//%includeGuardEnd } hNb4yLSsimk5RFvFdUzHEw
