#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 18 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-updateDisplay-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardEntry$BirthdayData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/SnapshotTab$LoadData;-onPostExecute-(Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/HTML5VideoInline;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ProfileProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary$1;-onPostExecute-(Ljava/lang/Void;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/ActionBarController$4;-onLoaderReset-(Landroid/content/Loader;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/SingleSourceCorpus;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DataUsageSummary;-updateTabs-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;-onMeasure-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/CameraPreference$OnPreferenceChangedListener;-onCameraPickerClicked-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/CameraActivity;-notifyScreenNailChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onEndBatchInput-(Lcom/android/inputmethod/latin/InputPointers;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/worldclock/CitiesActivity$CityAdapter;-<init>-(Lcom/android/deskclock/worldclock/CitiesActivity; Landroid/content/Context; Ljava/util/HashMap; Landroid/view/LayoutInflater;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/soundrecorder/Recorder;-delete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/TextClock;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getMobileProvisioningUrl-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-addWindow-(Lcom/android/server/wm/Session; Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/settings/Settings$UserSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebView;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/SlideshowView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/content/SyncManager;-access$2100-(Lcom/android/server/content/SyncManager;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendSubmitPdu-(Lcom/android/internal/telephony/cdma/SmsMessage$SubmitPdu; Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/users/UserSettings$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.GET_ACCOUNTS'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/TetherSettings;-setUsbTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ApplicationThreadNative;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/music/MediaPlaybackService;-open-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/SuggestionsAdapter$SlowFilterTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/Launcher;-startSearch-(Ljava/lang/String; Z Landroid/os/Bundle; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/googlecode/mp4parser/authoring/builder/Mp4Builder;-build-(Lcom/googlecode/mp4parser/authoring/Movie;)Lcom/coremedia/iso/IsoFile;' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/CropFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor;-saveAndRegisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/server/wifi/WifiController$FullHighPerfLockHeldState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothGatt;-serverConnect-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoModule;-keepScreenOnAwhile-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/AccessibilityInjector;-isScriptInjectionEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MessageListFragment;-onLoadMoreMessages-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-mayEndBatchInput-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/launcher2/PagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/ActionBarController$Callback;-onUpPressed-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-access$100-(Lcom/android/settings/fuelgauge/PowerUsageSummary;)V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-onOpenAttachment-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-doKeyguardLaterLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/FrameSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/DragLayer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference$MyHandler;-handleSetVPResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/picasasource/PicasaSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/ManageConferenceUtils;-updateManageConferenceRow-(I Lcom/android/internal/telephony/Connection; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-getContactCount-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-notifyPageSwitched-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/os/IPowerManager;-setStayOnSetting-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/PopImapAuthenticatorService$PopImapAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-addAppWidget-(I I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Landroid/filterpacks/base/GLTextureSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/DownloadHandler;-onDownloadStart-(Landroid/app/Activity; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/common/list/ShortcutIntentBuilder$LoadingAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/RecipientsEditor;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processPlayTone-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-handleHeadsetHook-(Lcom/android/internal/telephony/Phone; Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-handleBackKey-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mms/data/WorkingMessage;-access$1400-(Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq; Ljava/util/HashMap;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/server/wm/Session;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/InCallScreen;-onStop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/PhotoPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/TextClock;-access$000-(Landroid/widget/TextClock;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallScreen;-isBluetoothAudioConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/UsimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-computeAddress-(Lcom/android/gallery3d/util/ReverseGeocoder$SetLatLong;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpaceBeforeWritingToFile-(I Ljava/lang/String; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/contacts/VoicemailStatusTable;-insert-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ShutterButton;-access$000-(Lcom/android/camera/ShutterButton; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/WifiService;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupDetailFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DockService;-access$100-(Lcom/android/settings/bluetooth/DockService; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DreamSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/UiModeManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/ActionBarController$4;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/MailService$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/IActivityManager;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/recent/RecentsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/settings/TetherSettings;-onStart-()V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhones-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-access$900-(Lcom/android/gallery3d/ui/MenuExecutor; I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel;-needsToShowImeSwitchOngoingNotification-(Landroid/view/inputmethod/InputMethodManager;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardware;-pauseGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/VoicemailContract$Status;-buildSourceUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/IBluetoothHeadset;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-agentErrorCleanup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/dialer/voicemail/VoicemailPlaybackPresenter;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoUI;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageListFragment$4;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/common/list/AccountFilterActivity$FilterLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$500-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/alerts/InitAlarmsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/common/widget/LayoutSuppressingQuickContactBadge;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/view/RotationPolicy;-isRotationLockToggleVisible-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager;-isKeyguardSecure-()Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-vibrate-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/UIControllerBase;-onRefresh-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/sip/SipSettings$2$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasOutboxService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/EmailConnectivityManager;-isAutoSyncAllowed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/TextClock;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/RadioInfo;-access$4400-(Lcom/android/settings/RadioInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideshowActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/dialer/dialpad/DialpadFragment;-onStart-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-computeSharingIntent-(Lcom/android/gallery3d/util/ThreadPool$JobContext; I)Landroid/content/Intent;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/PhotoModule;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Ljava/util/List; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebIconDatabaseClassic;-releaseIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/dialer/SpecialCharSequenceMgr;-showMEIDPanel-(Landroid/content/Context; Z Landroid/telephony/TelephonyManager;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/base/FrameSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$8;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-setSystemUiVisibility-(I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasSyncService;-canProvision-(Lcom/android/exchange/EasSyncService;)Lcom/android/exchange/adapter/ProvisionParser;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/VideoEditorActivity$23;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/power/PowerManagerService$1;-onProximityPositive-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendTouchExplorationGestureStartAndHoverEnterIfNeeded-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/gatt/GattService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/util/DraftCache;-access$000-(Lcom/android/mms/util/DraftCache;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/filtershow/ui/IconButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyServiceState-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$7300-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/camera/FocusOverlayManager;-onShutterUp-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/VolumePanel;-onRemoteVolumeChanged-(I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/NetworkTimeUpdateService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/CameraScreenNail;-access$001-(Lcom/android/camera/CameraScreenNail; Lcom/android/gallery3d/glrenderer/GLCanvas; I I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-writeDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/VibratorService;-startVibrationLocked-(Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/service/dreams/Sandman;-startDreamWhenDockedIfAppropriate-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/list/CustomContactListFilterActivity$CustomFilterConfigurationLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-refreshInterface-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/list/ContactListFilterController;-selectCustomFilter-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine;-access$1100-(Lcom/android/bluetooth/a2dp/A2dpStateMachine; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-removeDeletion-(Lcom/android/gallery3d/data/Path;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DreamSettings;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/common/list/ContactEntryListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parseResponse-()Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/ContactLoader;-loadGroupMetaData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/MessageViewFragment;-onMarkMessageAsRead-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller;-getExchangeEmailService-()Lcom/android/emailcommon/service/IEmailService;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/UrlInputView;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/VibratorService;-onInputDeviceRemoved-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-showBugreportDialog-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/gallery3d/data/DataManager;-delete-(Lcom/android/gallery3d/data/Path;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService;-removeBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/SlideshowPage;-showPendingBitmap-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/ProfileProvider;-enforceWritePermission-()V' : ['android.permission.WRITE_PROFILE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-requestChildRectangleOnScreen-(Landroid/view/View; Landroid/graphics/Rect; Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/MobileNetworkSettings$MyHandler;-resetNetworkModeToDefault-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions;-<init>-(Landroid/content/Context; Landroid/view/WindowManagerPolicy$WindowManagerFuncs;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView$1;-onRefreshCarrierInfo-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/OtaUtils;-onOtaCloseFailureNotice-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/launcher2/Launcher;-onSearchRequested-()Z' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-access$600-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/NetworkPolicyManager;-getNetworkPolicies-()[Landroid/net/NetworkPolicy;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3000-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/NullFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService$3;-processChld-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/SearchActivity;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IAccountService;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-handleOnRotationChanged-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$1500-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneInterfaceManager;-getNeighboringCellInfo-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stopSample-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/GoogleAccountLogin;-invalidateTokens-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/alarmclock/DigitalWidgetViewsFactory$RemoteWorldClockAdapter;-updateView-(Landroid/view/View; Lcom/android/deskclock/worldclock/CityObj;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/INetworkPolicyManager$Stub;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/WakeLockHoldingProgressListener;-onProgressStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfo-(Lcom/android/mms/data/Contact;)Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/NotificationManagerService;-rebindListenerServices-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/DayFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordFragment;-onResume-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopUserLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-access$300-(Lcom/android/server/InputMethodManagerService;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/SnapshotTab;-<init>-(Lcom/android/browser/WebViewController; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IRingtonePlayer$Stub;-stopAsync-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/PushReceiver;-access$000-(Landroid/content/Context; Lcom/google/android/mms/pdu/GenericPdu; I)J' : ['android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/StatusBarManager;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$2100-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator; Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager$ShowListener;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionUp-(Landroid/view/MotionEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-getRequestedPasswordQuality-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$3;-getCameraIntent-()Landroid/content/Intent;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity$BluetoothTransferContentObserver;-onChange-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$Listener;-onSingleTapUp-(F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/videosrc/MediaSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DigitalClock;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String; I Landroid/content/BroadcastReceiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-onBackPressed-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/CaptivePortalTracker;-<init>-(Landroid/content/Context; Landroid/net/IConnectivityManager;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager;-reconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-access$400-(Lcom/android/contacts/group/GroupBrowseListFragment;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onVisibilityChanged-(Z)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/SnailSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/ConnectivityService;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEventInternal-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/data/WorkingMessage;-syncWorkingRecipients-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-updateEF-(Lcom/android/internal/telephony/uicc/AdnRecord; I I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipEditor;-access$400-(Lcom/android/phone/sip/SipEditor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/CaptureAnimManager;-drawAnimation-(Lcom/android/gallery3d/glrenderer/GLCanvas; Lcom/android/camera/CameraScreenNail; Lcom/android/gallery3d/glrenderer/RawTexture; I I I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler;-getDeltaForAttachingPhotoToContact-()Lcom/android/contacts/model/RawContactDeltaList;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/PhotoModule$AutoFocusCallback;-onAutoFocus-(Z Landroid/hardware/Camera;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-setMessagePreferences-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/media/RingtoneManager;-getActualDefaultRingtoneUri-(Landroid/content/Context; I)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/input/InputManagerService;-start-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/UIControllerOnePane;-onActivityStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-access$3000-(Lcom/android/systemui/statusbar/phone/PhoneStatusBar;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/SecurityPolicy;-setActivePolicies-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-playSound-(I)I' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-setCurrentTab-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/service/ServiceProxy$ProxyRunnable;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordExpirationTimeout-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$3;-dismiss-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/WifiService;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$WindowManagerCallbacks;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformInitializeTask;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDisconnectionErrorCreatingConnection;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/CameraModule;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView$Listener;-pickSuggestionManually-(I Lcom/android/inputmethod/latin/SuggestedWords$SuggestedWordInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/CallbackProxy;-onJsPrompt-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/DayView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dialer/calllog/CallLogFragment;-fetchCalls-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-startRefresh-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/DateTimeSettings;-onTimeSet-(Landroid/widget/TimePicker; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$AccessibilityContentObserver;-<init>-(Lcom/android/server/accessibility/AccessibilityManagerService; Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5Audio;-pause-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/ControllerResultUiThreadWrapper$5;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothHeadset;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onStart-()V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetooth;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosrc/MediaSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/p2p/WifiP2pService;-enforceChangePermission-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/deskclock/DeskClock$TabsAdapter;-notifyPageChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-<init>-(Landroid/app/Activity; Landroid/os/Bundle; Landroid/app/FragmentManager; Lcom/android/contacts/widget/TransitionAnimationView; Landroid/view/View; Lcom/android/contacts/detail/ContactDetailFragment$Listener;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/preference/VolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/wifi/WifiSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragment;-showDetails-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/View$AttachInfo$Callbacks;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/editor/SplitContactConfirmationDialogFragment$Listener;-onSplitContactConfirmed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-bindChildView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/accounts/SyncSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/AccountsChangedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/VideoModule;-initializeRecorder-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/view/IInputMethodManager;-getEnabledInputMethodSubtypeList-(Landroid/view/inputmethod/InputMethodInfo; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-markAsDeleted-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I I)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/net/INetworkPolicyManager;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-access$200-(Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout; Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hid/HidService;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/settings/BrightnessController$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/FilmstripPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/IAudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/LocationBlacklist;-getStringArrayLocked-(Ljava/lang/String;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-getContactMethodType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$DevelopmentSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BluetoothManagerService;-disable-(Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$000-(Lcom/android/mms/transaction/SmsReceiverService; Landroid/content/Intent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/widget/CalendarView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/common/list/ContactListFilterControllerImpl;-setContactListFilter-(Lcom/android/contacts/common/list/ContactListFilter; Z Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-getInstance-(Landroid/content/Context;)Lcom/android/settings/bluetooth/LocalBluetoothManager;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/SmsReceiverService;-insertMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;-onResume-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/DigitalClock;-access$300-(Landroid/widget/DigitalClock;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/media/effect/FilterGraphEffect;-apply-(I I I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothDevice;-createInsecureRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/emailcommon/service/IEmailService;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/ContactStatusLoader;-getContactInfo-(Landroid/content/Context; Ljava/lang/String;)Lcom/android/email/activity/ContactStatusLoader$Result;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/app/ActivityManagerNative;-killApplicationWithAppId-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/deskclock/SetAlarm$6;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-onClose-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/ui/CountdownTimerPopup;-access$000-(Lcom/android/camera/ui/CountdownTimerPopup;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/Utils;-showError-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$NotificationAccessSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$200-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/Controller;-onProgressChanged-(Lcom/android/browser/Tab;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodPreference$6;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/VoicemailPermissions;-packageHasFullAccess-(Ljava/lang/String;)Z' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/phone/ManageConferenceUtils$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService;-performPollLocked-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/model/RawContact;-getAccountTypeManager-(Landroid/content/Context;)Lcom/android/contacts/common/model/AccountTypeManager;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/PhotoEditorView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wifi/WifiService;-checkAndStartWifi-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneGlobals;-handleSetTTYModeResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/AttachmentDownloadService;-canPrefetchForAccount-(Lcom/android/emailcommon/provider/Account; Ljava/io/File;)Z' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager;-requestRouteToHostAddress-(I [B)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/PickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/AudioAttachmentView;-onPlaybackError-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CryptKeeper;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-onResume-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/AnalogClock;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceRemoved-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/musicvis/vis1/Visualization1$CubeEngine;-attach-(Landroid/service/wallpaper/WallpaperService$IWallpaperEngineWrapper;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView$1;-onRefreshBatteryInfo-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor$BatteryStatus;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-invokeCodeInput-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-queryPin1State-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateFormat;-getTimeFormat-(Landroid/content/Context;)Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView$1;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/Connection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/CameraActivity;-onFullScreenChanged-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/inputmethodservice/KeyboardView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiNotificationController;-checkAndSetNotification-(Landroid/net/NetworkInfo; Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/ActionBarAdapter$MyNavigationListener;-onNavigationItemSelected-(I J)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/usb/UsbService;-systemReady-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordExpirationTimeout-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$CaptivePortalCheckState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofencePauseStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateFormat;-getDateFormatString-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/LocalSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/PhotoModule$CameraStartUpThread;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/XLargeUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/launcher2/DragController;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt;-sendResponse-(I Ljava/lang/String; I I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-createSubWindow-()Z' : ['android.permission.INTERNET'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertSettings-(Landroid/net/Uri; Landroid/content/ContentValues;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/display/DisplayManagerService$DisplayAdapterListener;-onDisplayDeviceEvent-(Lcom/android/server/display/DisplayDevice; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vpndialogs/ManageDialog;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/IAudioService;-startBluetoothSco-(Landroid/os/IBinder; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/launcher2/SmoothPagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ClassChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-executeNextState-(Lcom/android/server/BackupManagerService$BackupState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItems-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-doFinish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$WakeLock;-binderDied-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dialer/calllog/CallLogQueryHandler;-fetchCalls-(I I Z I)V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/app/AppBridge$Server;-notifyScreenNailChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/Phone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$7;-getCameraWidgetInfo-()Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher$CameraWidgetInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmClock$5;-doInBackground-([Lcom/android/deskclock/Alarm;)Ljava/lang/Void;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/ui/ActionModeHandler$2;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/TintFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoController;-onScreenSizeChanged-(I I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ActivityState;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CdmaSubscriptionListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityThread$ApplicationThread;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPreferredVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CredentialStorage;-onResume-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt;-writeCharacteristic-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/data/Conversation;-dumpSmsTable-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-addSecureAlbumItem-(Z I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccProvider;-loadFromEf-(I)Landroid/database/MatrixCursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings$TetherChangeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Settings$System;-getShowGTalkServiceStatusForUser-(Landroid/content/ContentResolver; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameStore;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-snapToPageWithVelocity-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/ResearchLogger;-commitCurrentLogUnitAsWord-(Ljava/lang/String; J Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothVisibilityTimeoutFragment;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea;-access$000-(Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/AlbumSlidingWindow;-onContentChanged-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/IAudioService$Stub;-reloadAudioSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/GlobalDismissManager$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/data/ClusterSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/effect/effects/TintEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage$7;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/SepiaEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/Switch;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupActivity;-isThisImeEnabled-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onClockVisibilityChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/Welcome$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2800-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPage-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-initialize-(Landroid/os/Bundle; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/btservice/ProfileService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller$LegacyListener;-synchronizeMailboxStarted-(J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onKey-(I [I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-clearPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/list/IndexerListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ApplicationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/tts/TextToSpeech;-getDefaultEngine-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-updateVoiceDetails-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/Filter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-handleSelectSyncedCalendarsClicked-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/UI;-onBackKey-()Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/InCallScreen$12;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/TetherSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-hideSearchPanel-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/sip/SipAudioCall;-transferToNewSession-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothA2dp;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/NullFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/coremedia/iso/IsoFile;-<init>-(Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hid/HidService;-getReport-(Landroid/bluetooth/BluetoothDevice; B B I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-handleTimeUpdate-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-handleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/launcher2/BubbleTextView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CallTracker;-handleRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onWindowFocusChanged-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallScreen;-access$800-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-usingBiometricWeak-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardEntry$PhotoData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneUtils;-separateCall-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/content/SyncManager;-access$1200-(Lcom/android/server/content/SyncManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/content/SyncManager;-scheduleLocalSync-(Landroid/accounts/Account; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/ConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/hardware/location/GeofenceHardware;-registerForMonitorStateChangeCallback-(I Landroid/hardware/location/GeofenceHardwareMonitorCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/Conversation$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/location/ILocationManager$Stub;-addTestProvider-(Ljava/lang/String; Lcom/android/internal/location/ProviderProperties;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/calendar/EventInfoFragment;-updateAttendees-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-downloadFinished-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-updateWidget-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-writeCharacteristic-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/google/common/io/MultiReader;-advance-()V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/ADNList;-reQuery-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-goToSleepNoUpdateLocked-(J I)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/WirelessSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-getIsGroupMmsEnabled-(Landroid/content/Context;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-getContactUriForPhoneNumber-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointers-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiController$StaEnabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onGenericMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/RetargetFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdatesLocked-(Landroid/location/LocationRequest; Lcom/android/server/LocationManagerService$Receiver; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/musicfx/ControlPanelEffect;-initEffectsPreferences-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/DevicePolicyManager;-getPasswordMinimumSymbols-(Landroid/content/ComponentName;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-doNotifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WiredAccessoryManager;-notifyWiredAccessoryChanged-(J I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager$2;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/ExtractButton;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/location/LocationFudger$1;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$NextAlarmObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/RefreshManager;-refreshMessageList-(J J Z)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processAnswerCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler$PhotoListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setProfileAutoConnectionPriority-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/CheckedTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/ADNList$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/ApnEditor;-mvnoDescription-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/GoogleAccountLogin;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointersOlderThan-(Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue$Element; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerTwoPane;-updateMessageOrderManager-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/speech/tts/TtsEngines;-getDefaultEngine-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/list/ContactListFilterController;-checkFilterValidity-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/VideoUtils;-writeMovieIntoFile-(Ljava/io/File; Lcom/googlecode/mp4parser/authoring/Movie;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/setup/MailboxSettings$LoadMailboxTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-updatePersistentConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/speech/tts/TtsEngines;-getV1Locale-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setNumberOfPairedDevices-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-addDescriptor-(I Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-handleCallKey-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-open-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/UndoBarView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/videosrc/MediaSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-readDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/Gallery;-startDefaultPage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/accounts/SyncSettings;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/systemui/power/PowerUI;-playLowBatterySound-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-updateDeviceName-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/AccessibilityInjector;-handleKeyEventIfNecessary-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-checkReadAccountsPermission-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/Context;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/AddressTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/DbModifierWithNotification;-notifyVoicemailChange-(Landroid/net/Uri; Ljava/util/Set; [Ljava/lang/String;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplayDensity-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-reportGpsGeofenceTransition-(I I D D D F F F J I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$System;-getInt-(Landroid/content/ContentResolver; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/TetherSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/HTML5VideoViewProxy;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BluetoothManagerService;-bluetoothStateChangeHandler-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-haveSomethingToCopyToSDCard-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoModule;-access$1900-(Lcom/android/camera/PhotoModule; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine$ConnectModeState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackActivity;-startPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService$2;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-onAttachedToWindow-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager;-show-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/app/MovieActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$OnChallengeScrolledListener;-onScrollStateChanged-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/location/LocationFudger;-loadCoarseAccuracy-()F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary$ConfirmLimitFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/ChooseLockSettingsHelper;-confirmPassword-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/InLineSettingMenu;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/SmsReceiverService;-handleSmsReceived-(Landroid/content/Intent; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiStateMachine;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/provider/Settings$Secure;-getStringForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleSwipe-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ISms;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-updateSecurityView-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask;-restoreOneFile-(Ljava/io/InputStream; [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$BugreportObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/widget/CompoundButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-access$2800-(Lcom/android/server/location/GpsLocationProvider;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/Recorder;-signalStateChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/TimerRingService;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothInputDevice;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/SearchActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager$Stub$Proxy;-clearForcedDisplaySize-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setBluetoothStateInt-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/PageDialogsHandler;-access$700-(Lcom/android/browser/PageDialogsHandler; Lcom/android/browser/Tab;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeUtil;-getInputMethodSubtypeSelected-(Landroid/content/ContentResolver;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/PickerActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-topAppWindowChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame$1;-onClockVisibilityChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/dialer/list/PhoneFavoriteFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/AlarmAlert;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BatteryStatsService;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/phone/PhoneGlobals;-dismissCallScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/telephony/SmsProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-onCameraLaunched-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-updateHeaderView-(Lcom/android/emailcommon/provider/EmailContent$Message;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/launcher2/InfoDropTarget;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-acquireWakeLock-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ApnEditor;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/SamplingProfilerService;-registerSettingObserver-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/inputmethod/InputMethodAndLanguageSettings$SettingsObserver;-resume-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/ChallengeLayout;-showChallenge-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/contacts/ContactsProvider2;-getType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/AllInOneActivity$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getGlobalProxyAdmin-(I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-access$1000-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/phone/Ringer;-stopRing-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onSingleTapUp-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-pauseAndDispatch-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-access$000-(Lcom/android/server/InputMethodManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothPan;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/research/Uploader;-hasWifiConnection-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-getKeyDescription-(Lcom/android/inputmethod/keyboard/Key;)Ljava/lang/String;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmReceiver;-access$000-(Lcom/android/deskclock/AlarmReceiver; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$ProvisionDiscoveryState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onPostExecute-(Ljava/lang/Void;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onTextInput-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService;-wakeUpFromNative-(J)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothInputDevice;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AddBookmarkPage;-onRootFolderFound-(J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/LocalePicker;-onLocaleSelected-(Ljava/util/Locale;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getAwakeTimePlugged-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onRefreshBatteryInfo-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor$BatteryStatus;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/ActionBarController$4;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/activity/TransactionSafeActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasAccountService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$13;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-handleTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/commands/am/Am;-runKillAll-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Landroid/net/ConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumNumeric-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleShift-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPage$4;-onSingleTapUp-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onOptionalFieldVisibilityChange-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-switchHoldingAndActive-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService$RunBackupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/TimeIntervalPopup;-updateInputState-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/location/fused/FusionEngine;-disableProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/PowerManagerService$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView$3;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment$3;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactsSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/Launcher;-exitSpringLoadedDragMode-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getBondedDevices-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessagesAdapter$MessagesCursorLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/data/MediaSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/ex/variablespeed/SingleThreadedMediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-bindView-(Landroid/view/View; Landroid/database/Cursor; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/GLView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactSaveService;-renameGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/pm/PackageManagerService;-access$4100-(Lcom/android/server/pm/PackageManagerService; Z Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/PhotoPage;-notifyScreenNailChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeechService;-access$400-(Landroid/speech/tts/TextToSpeechService;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-scanPackageLI-(Landroid/content/pm/PackageParser$Package; I I J Landroid/os/UserHandle;)Landroid/content/pm/PackageParser$Package;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/UiModeManagerService;-access$100-(Lcom/android/server/UiModeManagerService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DisplaySettings;-writeFontSizePreference-(Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-handleAccessPermissionResult-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/systemui/statusbar/phone/NavigationBarView;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/BatteryStatsImpl;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/DockService;-msgTypeDocked-(Landroid/bluetooth/BluetoothDevice; I I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onReplay-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/MailService$3;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/data/SnailAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/Gallery;-startGetContent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/ILockSettings;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/CryptKeeper$ValidationTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handleCdmaSubscriptionSource-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/CameraScreenNail;-directDraw-(Lcom/android/gallery3d/glrenderer/GLCanvas; I I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IActivityManager;-killApplicationWithAppId-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/noisefield/NoiseFieldView;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/bluetooth/IBluetooth;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/CameraModule;-onSingleTapUp-(Landroid/view/View; I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/Controller$ServiceCallbackWrapper;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/setup/DebugFragment;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/SlideViewInterface;-setAudio-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onProviderStatusChange-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DataUsageSummary;-updateDetailData-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-sendMessage-(J)Z' : ['android.permission.SEND_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-getDisabledFeatures-(Landroid/app/admin/DevicePolicyManager;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/RetargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/PhoneUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeUtil;-getEnabledInputMethodsAndSubtypeList-(Landroid/content/ContentResolver;)Ljava/util/HashMap;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-ensurePaired-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-access$200-(Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;)V' : ['android.permission.CAMERA'],
	'Lcom/android/email/EmailConnectivityManager;-getActiveNetworkType-(Landroid/net/ConnectivityManager;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageListFragment;-onSendPendingMessages-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3100-(Lcom/android/mms/ui/ComposeMessageActivity; J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothHeadset;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/StrokedTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/Controller;-openTabToHomePage-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService$BookmarkFactory;-loadBookmarks-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/common/list/ContactEntryListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiController$FullHighPerfLockHeldState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/worldclock/CitiesActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterGraph;-tearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/wifi/WifiManager;-isScanAlwaysAvailable-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/DhcpStateMachine$RunningState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TelephonyRegistry;-broadcastSignalStrengthChanged-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiController$DeviceInactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/applications/AppOpsCategory$AppListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryChart;-setStats-(Landroid/os/BatteryStats;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-getCachedBluetoothDevice-(Landroid/bluetooth/BluetoothDevice;)Lcom/android/settings/bluetooth/CachedBluetoothDevice;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-showAndStartWelcomeVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/AccessibilitySettings$ToggleGlobalGesturePreferenceFragment;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView$3;-onFinish-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasOutboxService;-sendPing-([B I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/colorpicker/ColorPickerSwatch$OnColorSelectedListener;-onColorSelected-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEvent-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/Recycler;-checkForThreadsOverLimit-(Landroid/content/Context;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/vcard/ImportVCardActivity$VCardScanThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallManager;-acceptCall-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/CallbackFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiService;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-loadAttachmentStatus-(J J I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-bailOutAfterErrorDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/data/DataManager$NotifyBroker;-onChange-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/ConnectivityService;-access$1100-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getEnabledInputMethodList-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/SipCallOptionHandler;-access$100-(Lcom/android/phone/SipCallOptionHandler;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/DockObserver;-access$000-(Lcom/android/server/DockObserver;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-stopBluetoothSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager;-setKeyguardDisabledFeatures-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmAlert;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/RespondViaSmsManager$PackageClickListener;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/server/pm/PackageManagerService$7;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/AudioService;-restoreMediaButtonReceiver-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/provider/Account;-isAutomaticSyncDisabledByRoaming-(Landroid/content/Context; J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$Handler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/IContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-refreshCache-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowSession;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/app/admin/DevicePolicyManager;-setMaximumTimeToLock-(Landroid/content/ComponentName; J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService$1$1;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment;-access$000-(Lcom/android/launcher2/WallpaperChooserDialogFragment; I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-onClickRecentButton-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/calendar/agenda/AgendaListView;-initView-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/widget/DialogTitle;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-startSync-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/webkit/WebViewProvider;-clearView-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetPhoneState;-listenForPhoneState-(Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-finish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/BroadcastQueue$AppNotResponding;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/ServiceWatcher$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingColors-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/providers/downloads/Helpers;-generateSaveFile-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I J Lcom/android/providers/downloads/StorageManager;)Ljava/lang/String;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/DayView;-access$4600-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ToggleButton;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DevicePolicyManagerService;-getPasswordMinimumSymbols-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/ButtonDropTarget;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DeleteEventHelper$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/MediaFormat;-runKeyguardConfirmation-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/HTML5VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UI;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/activity/ChipsAddressTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-updateAdnByIndex-(I Lcom/android/internal/telephony/uicc/AdnRecord; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-dialThreeWay-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServicePreferenceFragment;-onPreferenceToggled-(Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/VideoModule$5;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/SecureAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5800-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCustomRequest-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/browser/Controller;-onDownloadStart-(Lcom/android/browser/Tab; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/AccessibilityInjector;-injectJavaScript-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-setDeviceName-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/LocationBasedCountryDetector$1;-onLocationChanged-(Landroid/location/Location;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-access$300-(Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/wifi/WifiSettings;-onResume-()V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/ui/SlideshowView;-renderChild-(Lcom/android/gallery3d/glrenderer/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcActivatingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/location/fused/FusionEngine;-updateRequirements-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-changeVolumeBy-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarUtils$TimeZoneUtils;-getTimeZone-(Landroid/content/Context; Ljava/lang/Runnable;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-addNotificationViews-(Landroid/os/IBinder; Landroid/service/notification/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView; Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/ObjectSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/deviceinfo/UsbSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/PhoneGlobals;-updatePhoneState-(Lcom/android/internal/telephony/PhoneConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/Parser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage;-initializeData-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1700-(Lcom/android/bluetooth/opp/BluetoothOppService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/AccountsTester$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-endReliableWrite-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityStack;-activityPaused-(Landroid/os/IBinder; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processUnknownAt-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-refreshName-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/effect/effects/FillLightEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditText;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-finishState-(Lcom/android/gallery3d/app/ActivityState; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/UIControllerOnePane;-onBeforeMessageGone-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/MailService;-access$000-(Lcom/android/email/service/MailService; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/vcard/VCardComposer;-init-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvision-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-handleRuimRefresh-(Lcom/android/internal/telephony/uicc/IccRefreshResponse;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/ScreensaverActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothInputDevice;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/ChartSweepView$OnSweepListener;-onSweep-(Lcom/android/settings/widget/ChartSweepView; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/text/ToUpperCase;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventHelper;-saveEvent-(Lcom/android/calendar/CalendarEventModel; Lcom/android/calendar/CalendarEventModel; I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/net/sip/SipAudioCall;-releaseWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothGattCallback$Stub$Proxy;-onDescriptorWrite-(Ljava/lang/String; I I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/admin/DevicePolicyManager;-setKeyguardDisabledFeatures-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupDetailDisplayUtils;-bindGroupSourceView-(Landroid/content/Context; Landroid/view/View; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/CaptivePortalTracker;-isActiveNetwork-(Landroid/net/NetworkInfo;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView$1;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processHangupCall-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/ContactsContract$RawContacts$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/data/DataManager;-getMediaSet-(Ljava/lang/String;)Lcom/android/gallery3d/data/MediaSet;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/ActionBarController$AccountDropdownPopup$1;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/net/NetworkStatsService;-bootstrapStatsLocked-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commit-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-updateIncomingCallWidgetHint-(I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-changeIccFdnPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-acknowledgeLastIncomingCdmaSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/ContactsContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/browser/WallpaperHandler;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/dialer/calllog/PhoneNumberHelper;-getDisplayNumber-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)Ljava/lang/CharSequence;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/LocalBluetoothAdapter; Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager; Lcom/android/settings/bluetooth/BluetoothEventManager;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebIconDatabaseClassic;-retainIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-access$1800-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-performTransitions-(Lcom/android/internal/util/State; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/sip/SipEditor;-unregisterProfile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-updateManageConferencePanelIfNecessary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-handleEndOfStream-(Lcom/android/providers/downloads/DownloadThread$State;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetooth$Stub;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/common/list/ProfileAndContactsLoader;-loadProfile-()Landroid/database/MatrixCursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/DevicePolicyManagerService;-setPasswordMinimumNonLetter-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onDeviceAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/location/GpsLocationProvider;-handleInjectNtpTime-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$System;-getConfiguration-(Landroid/content/ContentResolver; Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetConfigure;-setChoosenAlbum-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/RecognitionManagerService;-access$000-(Lcom/android/server/RecognitionManagerService; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/ChooseLockPassword$ChooseLockPasswordFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onRemoveViewAnimationCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/shell/BugreportReceiver;-findSendToAccount-(Landroid/content/Context;)Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserWebViewFactory;-createWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Landroid/view/IWindowSession$Stub$Proxy;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$5;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/WorkingMessage;-asyncDeleteDraftSmsMessage-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/backup/IBackupManager;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-getSubscriptionInfoAndStartPollingThreads-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$2900-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallScreen;-onPhoneStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/ComboAlbum;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DataUsageSummary$DataUsageAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/SettingsPreferenceFragment$SettingsDialogFragment;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiService;-getWifiEnabledState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$PanStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/musicfx/ActivityMusic;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/monkey/Monkey;-main-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/media/effect/effects/SharpenEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-sendConnectionStateChange-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodAndSubtypeHashCodeListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/NumPadKey;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/preference/DisplayOrderPreference;-prepare-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/LocalSource;-naturalPrevious-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/LockdownVpnTracker;-onVpnStateChanged-(Landroid/net/NetworkInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-systemReady-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/RedEyeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/DigitalClock;-access$200-(Lcom/android/deskclock/DigitalClock;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/media/MediaProvider;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-delete-(Landroid/net/Uri; I J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine$DriverStartedState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$ConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GLView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/applications/ApplicationsProvider$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getOutgoingCallerIdDisplay-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController$EventHandler;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/model/RawContactModifier;-parseExtras-(Landroid/content/Context; Lcom/android/contacts/common/model/account/AccountType; Lcom/android/contacts/model/RawContactDelta; Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-onCreate-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri; I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMALTEPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-toggleRecentsActivity-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/exchange/EasSyncService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-setCurrentPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getCLIR-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/SingleSpellCheckerPreference$4;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordMinimumLowerCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-access$100-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor$BatteryStatus;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Controller;-reuseTab-(Lcom/android/browser/Tab; Lcom/android/browser/IntentHandler$UrlData;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/NsdService;-access$700-(Lcom/android/server/NsdService; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactPickerFragment;-finish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/ui/MoreSettingPopup;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-access$100-(Lcom/android/settings/DevelopmentSettings;)V' : ['android.permission.READ_EXTERNAL_STORAGE', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/PhotoModule;-onSingleTapUp-(Landroid/view/View; I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/Controller$Result;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/model/ContactLoader;-loadDirectoryMetaData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/OpenDownloadReceiver;-onReceiveAsync-(Landroid/content/Context; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/phone/RespondViaSmsManager;-sendTextAndExit-(Ljava/lang/String; Ljava/lang/String; Landroid/content/ComponentName; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/power/PowerManagerService$1;-onProximityNegative-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/calendar/DayView;-handleOnResume-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-readCharacteristic-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/UIControllerBase;-onMessageSetUnread-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-pullVcardEntry-([B Lcom/android/bluetooth/pbap/BluetoothPbapObexServer$AppParamValue; Ljavax/obex/Operation; Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/app/TrimVideo;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentSlide-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/SlideModel;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/Controller;-closeCurrentTab-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/Tab;-setController-(Lcom/android/browser/WebViewController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-updateHomeTime-()V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-onRecordLoaded-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/VideoView$6;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterState$OnState;-enter-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/gatt/GattService$ServerDeathRecipient;-binderDied-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneGlobals;-initForNewRadioTechnology-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/svox/pico/PicoService;-access$400-(Landroid/speech/tts/TextToSpeechService;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/debug/ContactsDumpActivity$DumpDbTask;-doInBackground-([Ljava/lang/Void;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView$OnTriggerListener;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MusicPicker;-stopMediaPlayer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WiredAccessoryManager$WiredAccessoryObserver;-updateStateLocked-(Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-verifyUnlockLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-delayedCleanupAfterDisconnect-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-showBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/AlertService;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Lcom/android/calendar/alerts/AlarmManagerInterface;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/http/RequestQueue;-enablePlatformNotifications-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/RefreshManager;-refreshMessageList-(J J Z Z)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/emailcommon/service/IEmailService;-loadAttachment-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-hideAndStopWelcomeVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyDialer;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getCurrentCalls-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-userSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/UIControllerBase;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ConfirmDialogListener;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceAdded-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService;-access$300-(Lcom/android/phone/BluetoothPhoneService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkPolicyManagerService$8;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-doStatusCallback-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage;-requestDeferredUpdate-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/PhoneUtils;-sendEmptyFlash-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/wfd/WifiDisplaySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-getAllThreads-(Landroid/content/Context;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-updateUIForCurrentPhoto-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/Workspace$2;-run-()V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/media/MediaPlayer;-access$300-(Landroid/media/MediaPlayer; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WiredAccessoryManager;-setDeviceStateLocked-(I I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.INTERNET'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$AccessibilityContentObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/GLTextureTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/systemui/media/RingtonePlayer$1;-playAsync-(Landroid/net/Uri; Landroid/os/UserHandle; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage;-completeOrCancelFolderNaming-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/transaction/Transaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppCrashLocked-(Lcom/android/server/am/ProcessRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-getSuggestions-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/String; Lcom/android/inputmethod/keyboard/ProximityInfo; Z)Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/view/IInputMethodManager;-getEnabledInputMethodList-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/webkit/AccessibilityInjector;-onPageFinished-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-endFile-(Landroid/media/MediaScanner$FileEntry; Z Z Z Z Z)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothInputDevice;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService;-resetSelectedInputMethodAndSubtypeLocked-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/PeopleActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/power/PowerManagerService$DisplayBlankerImpl;-blankAllDisplays-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-userSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ui/TimeIntervalPopup$Listener;-onListPrefChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/ui/PhotoView;-snapToNeighborImage-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/os/Vibrator;-vibrate-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-onWakeMotionWhenKeyguardShowingTq-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/MultiAutoCompleteTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/Filter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment; Landroid/widget/ProgressBar;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$SequentialSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/Chronometer;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/location/GeofenceManager;-scheduleUpdateFencesLocked-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/CryptKeeperSettings;-access$300-(Lcom/android/settings/CryptKeeperSettings; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/ShutdownThread$5;-run-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-isSpellCheckerEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothGattCallback$Stub$Proxy;-onClientRegistered-(I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-restartRadio-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentFailed-(J J J Lcom/android/emailcommon/mail/MessagingException; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine$UntetheringState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/users/ProfileUpdateReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebIconDatabaseClassic;-close-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/development/Connectivity;-onStartDelayedCycle-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/data/DataManager;-getContentUri-(Lcom/android/gallery3d/data/Path;)Landroid/net/Uri;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DockService;-msgTypeDisableBluetooth-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView$1;-onUserSwitchComplete-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-requestRemoveProviderInfoWithDelay-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-addSubtypeToHistory-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndActive-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/systemui/statusbar/policy/NetworkController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptFallback-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/VideoModule;-onUserInteraction-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Browser;-deleteFromHistory-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/IContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/content/SyncManager$ActiveSyncContext;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processKeyPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-cancelTransitionsInProgress-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine;-access$23200-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/speech/tts/TextToSpeech$2;-run-(Landroid/speech/tts/ITextToSpeechService;)Ljava/lang/Integer;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/MessagingController;-loadAttachment-(J J J J Lcom/android/email/MessagingListener; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab;-putInForeground-()V' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/AllInOneActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/EasSyncService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaPerformActivation-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/wm/InputMonitor;-notifyANR-(Lcom/android/server/input/InputApplicationHandle; Lcom/android/server/input/InputWindowHandle;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pPersistentGroupsChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/DevicePolicyManagerService;-getActiveAdminUncheckedLocked-(Landroid/content/ComponentName; I)Lcom/android/server/DevicePolicyManagerService$ActiveAdmin;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ActivityBase;-addSecureAlbumItemIfNeeded-(Z Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-checkIfSubtypeBelongsToImeAndEnabled-(Landroid/view/inputmethod/InputMethodInfo; Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardParserImpl_V30;-parseOneVCard-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-rescheduleMissedAlarms-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-albumShouldOpenInFilmstrip-(Lcom/android/gallery3d/data/MediaSet;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AsyncPlayer;-play-(Landroid/content/Context; Landroid/net/Uri; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlotView;-renderChild-(Lcom/android/gallery3d/glrenderer/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/Tab$3;-onRequestFocus-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/provider/Settings$System;-getIntForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-<init>-(Landroid/os/Handler; Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/latin/LatinIME;-restartSuggestionsOnWordTouchedByCursor-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SecuritySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$400-(Lcom/android/mms/ui/ComposeMessageActivity;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/TrimVideo$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getPhoneUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-sendMessage-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/settings/BrightnessController$BrightnessObserver;-<init>-(Lcom/android/systemui/settings/BrightnessController; Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/Controller$ControllerService$1;-loadAttachment-(J Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/AllowBindAppWidgetActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-load-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/PhotoPage;-onActionBarWanted-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/util/StateMachine$SmHandler$QuittingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccessibilitySettings$3;-onChange-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupEditorFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-notifyNoData-(Lcom/android/internal/telephony/dataconnection/DcFailCause; Lcom/android/internal/telephony/dataconnection/ApnContext;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothInputDevice;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/RadioInfo$12;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/base/ObjectSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/IMagnificationCallbacks$Stub$Proxy;-onUserContextChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-isSyncable-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-serverConnect-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipSettings$1;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/CredentialStorage;-ensureKeyGuard-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/ContactsProvider2;-getDefaultAccount-()Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-bindEditors-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TextClock;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService;-getHealthDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/TextView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/datepicker/DatePickerDialog;-<init>-(Landroid/content/Context; I Lcom/android/contacts/datepicker/DatePickerDialog$OnDateSetListener; I I I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-handleBatteryStateChangedLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/InCallScreen;-dontAddVoiceMailNumber-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-<init>-(Lcom/android/contacts/activities/PhotoSelectionActivity; Landroid/content/Context; Landroid/view/View; I Lcom/android/contacts/model/RawContactDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorUtils;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/wifi/WifiSettings$4;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$2;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-deleteSms-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ChangeIccPinScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPasswordView;-onFinishInflate-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-switchUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/RetargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/SlideViewInterface;-stopAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-bindEditorsForNewContact-(Lcom/android/contacts/common/model/account/AccountWithDataSet; Lcom/android/contacts/common/model/account/AccountType; Lcom/android/contacts/model/RawContactDelta; Lcom/android/contacts/common/model/account/AccountType;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.PROCESS_OUTGOING_CALLS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/common/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/wm/WindowManagerService;-clearForcedDisplayDensity-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/content/SyncManager;-access$1400-(Lcom/android/server/content/SyncManager; Lcom/android/server/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/research/ResearchLogger;-scrubWord-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/content/SyncStorageEngine;-setSyncAutomatically-(Landroid/accounts/Account; I Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/power/DisplayPowerState$PhotonicModulator$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService$3;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/ActivityBase;-onPreviewTextureCopied-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/Launcher;-onBackPressed-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleNonSpecialCharacter-(I I I I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/app/backup/IBackupManager$Stub;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$800-(Lcom/android/contacts/activities/ConfirmAddDetailActivity; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/emailcommon/Device;-getConsistentDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/selectcalendars/CalendarColorCache;-<init>-(Landroid/content/Context; Lcom/android/calendar/selectcalendars/CalendarColorCache$OnCalendarColorsLoadedListener;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/applications/RunningProcessesView$TimeTicker;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/Launcher;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/pm/PackageManagerService;-access$3600-(Lcom/android/server/pm/PackageManagerService; Ljava/lang/String; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-handleSimRefresh-(Lcom/android/internal/telephony/uicc/IccRefreshResponse;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertActivity$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/AccountManager;-getAccounts-()[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/speech/tts/ITextToSpeechService$Stub$Proxy;-synthesizeToFileDescriptor-(Landroid/os/IBinder; Ljava/lang/String; Landroid/os/ParcelFileDescriptor; Landroid/os/Bundle;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/ApplicationSettings;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/content/ISyncAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-readPairedDevices-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/FaceUnlock;-startUi-(Landroid/os/IBinder; I I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/Controller$LegacyListener;-checkMailFinished-(Landroid/content/Context; J J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/AlarmClock$AlarmItemAdapter;-expandAlarm-(Lcom/android/deskclock/AlarmClock$AlarmItemAdapter$ItemHolder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Preloader;-cancelSearchBoxPreload-(Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/Controller$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/MailService$5;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/power/DisplayPowerController$3;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-updatePersistentNetworks-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/DuotoneEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/JoinContactListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/hardware/location/IGeofenceHardware$Stub;-addCircularFence-(I I D D D I I I I Landroid/hardware/location/IGeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/dreams/phototable/PhotoSource;-naturalPrevious-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/sip/SipSettings;-access$800-(Lcom/android/phone/sip/SipSettings;)V' : ['android.permission.READ_PROFILE', 'android.permission.USE_SIP'],
	'Lcom/android/browser/Controller;-closeCurrentTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/IdleMaintenanceService;-sendIdleMaintenanceStartIntent-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-reportLocation-(I D D D F F F J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ContextImpl;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TextToSpeech;-runAction-(Landroid/speech/tts/TextToSpeech$Action; Ljava/lang/Object; Ljava/lang/String; Z Z)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/UrlInputView$UrlInputListener;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/view/IApplicationToken;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/DeleteEventHelper;-deleteRepeatingEvent-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/wm/WindowManagerService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageListFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-applyNewState-(Lcom/android/internal/telephony/dataconnection/ApnContext; Z Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-refreshDevice-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-broadcastIccStateChangedIntent-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/hardware/location/IGeofenceHardware$Stub$Proxy;-addCircularFence-(I I D D D I I I I Landroid/hardware/location/IGeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/util/Recycler;-deleteOldMessagesByThreadId-(Landroid/content/Context; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/AccountServiceProxy$6;-run-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/app/admin/DevicePolicyManager;-getPasswordHistoryLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDevice;-cancelBondProcess-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-resetMessage-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/HidProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothPreferences;-shouldShowDialogInForeground-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/dreams/phototable/FlipperDreamSettings;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/common/list/ContactListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/Controller$15;-loadAttachmentStatus-(J J I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/alerts/AlertAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerBase;-onBackPressed-(Z)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/Clustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/TextClock;-chooseFormat-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/PhotoUI;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncAdapter;-<init>-(Landroid/content/Context; Landroid/database/Cursor; Landroid/app/FragmentManager;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/wifi/WifiController;-updateBatteryWorkSource-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-addFence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; I I Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ComposeMessageActivity$36;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$NotificationAccessSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/DevicePolicyManagerService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-displayReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-refreshAccessPoints-(Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/PreloadRequestReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-showNextSecurityScreenOrFinish-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookOneVcard-(Ljavax/obex/Operation; I Z Ljava/lang/String; I)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-onDreamingStarted-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/IBatteryStats;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/users/UserSettings;-access$800-(Lcom/android/settings/users/UserSettings; Landroid/content/pm/UserInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-switchToState-(I F F)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onFinishInflate-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService$AudioHandler$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/dreams/phototable/LocalSource;-next-(Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestCursor;-runQuery-(Ljava/lang/CharSequence;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader;-startBackgroundThread-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/DayView;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onPhoneStateChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/UiController;-createNewSnapshotTab-(J Z)Lcom/android/browser/SnapshotTab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelWithoutUids-(Landroid/os/Parcel; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/location/GpsLocationProvider$3;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothHeadset;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallCard;-updatePhotoForCallState-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-addNotificationViews-(Landroid/os/IBinder; Landroid/service/notification/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.VIBRATE'],
	'Landroid/filterfw/core/FilterContext;-tearDown-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Utils;-getProfileDisplayName-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothAdapter;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/UiModeManagerService;-access$500-(Lcom/android/server/UiModeManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmClock$AlarmItemAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/location/fused/FusedLocationProvider;-<init>-(Landroid/content/Context;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentials-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accounts/AccountManagerService;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/gatt/GattService;-unregisterClient-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/SettingsPanelView;-updateResources-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-access$400-(Lcom/android/gallery3d/data/LocalAlbumSet; Lcom/android/gallery3d/data/DataManager; I Lcom/android/gallery3d/data/Path; I Ljava/lang/String;)Lcom/android/gallery3d/data/MediaSet;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/UIControllerBase;-showAccountSpecificWarning-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/ContactsContract$SyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-loadMessagesAndDraft-(I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/media/effect/effects/SepiaEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-access$100-(Lcom/android/dialer/calllog/CallLogAdapter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/Bookmarks;-addBookmark-(Landroid/content/Context; Z Ljava/lang/String; Ljava/lang/String; Landroid/graphics/Bitmap; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-access$1800-(Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$8;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService$5;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.REORDER_TASKS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.RESTART_PACKAGES', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/DuotoneEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-handleCpbsCommand-(Ljava/lang/String; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/email/activity/MessageViewFragment;-onResume-()V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startDisambiguationQuery-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab; Z)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$DevelopmentSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/InputMethodAndLanguageSettings;-updateActiveInputMethodsSummary-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calculator2/ColorButton;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/TintFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-setKeyboard-(Lcom/android/inputmethod/keyboard/Keyboard;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dialer/dialpad/DigitsEditText;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/CalendarContract$EventDays;-query-(Landroid/content/ContentResolver; I I [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$DeviceFoundHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-resetStateIfCurrentLocaleChangedLocked-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-access$000-(Lcom/android/settings/bluetooth/BluetoothNameDialogFragment; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccessibilitySettings$SettingsPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/CallerInfoCache;-init-(Landroid/content/Context;)Lcom/android/phone/CallerInfoCache;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/DeleteEventHelper;-access$900-(Lcom/android/calendar/DeleteEventHelper;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$23$1$3;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-getCarrierTextForSimState-(Lcom/android/internal/telephony/IccCardConstants$State; Ljava/lang/CharSequence; Ljava/lang/CharSequence;)Ljava/lang/CharSequence;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-activateSpeakerIfDocked-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/datetimepicker/date/TextViewWithCircularIndicator;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getReport-(Landroid/bluetooth/BluetoothDevice; B B I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onDataSetupCompleteError-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/VoiceInputOutputSettings;-populateRecognizerPreference-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-access$100-(Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/TileImageView;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onRefreshCarrierInfo-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-setPostDialState-(Lcom/android/internal/telephony/Connection$PostDialState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/EmailAddressAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-loadDictionaryAsyncForUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/Email;-onCreate-()V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$GroupCreatedState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPage$1;-getItemIndex-(Lcom/android/gallery3d/data/Path;)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/policy/BluetoothController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/CertBlacklister$BlacklistObserver;-getValue-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/soundrecorder/Recorder$OnStateChangedListener;-onStateChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/ChipsAddressTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyDownloadFailed-(Landroid/content/Context; J)V' : ['android.permission.READ_SMS'],
	'Lcom/android/server/accounts/AccountManagerService$4;-run-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-copyMedia-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/TabControl;-createNewWebView-()Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Lcom/android/phone/SimContacts;-isAirplaneModeOn-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/CameraActivity;-onPreviewTextureCopied-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/inputmethod/InputMethodPreference;-getSummaryString-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-reportFailedPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EmailSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-handleBatteryUpdate-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor$BatteryStatus;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/TetherSettings;-access$300-(Lcom/android/settings/TetherSettings;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$H$1;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onAttachedToWindow-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$900-(Lcom/android/gallery3d/ui/PhotoView; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-access$4600-(Lcom/android/internal/telephony/dataconnection/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$4;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/NetInitiatedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/browser/BaseUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageUtils$3$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-showBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/BlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/Launcher;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getProvisioningOrActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-virtualUnplug-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wifi/WifiService;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleBackspace-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/common/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I Landroid/content/DialogInterface$OnClickListener;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/TagClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$20;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephony;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/BaseCommands;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity$1;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/photos/AlbumFragment;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationsAtStartup-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/common/model/AccountTypeManagerImpl$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-saveRingtone-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompat;-performAction-(I I Landroid/os/Bundle;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.VIBRATE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-performSnooze-(Landroid/net/NetworkTemplate; I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/Alarms;-deleteAlarm-(Landroid/content/Context; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallScreen;-showPausePromptDialog-(Lcom/android/internal/telephony/Connection; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/RotationToggle;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$ToggleScreenMagnificationPreferenceFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-lockNow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/RadioInfo;-onPause-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterfw/core/SyncRunner;-performStep-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/common/list/PhoneNumberListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/wifi/WifiSettings;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/IAccountManager$Stub;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-sendConnectionStateChange-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/HttpUtils;-httpConnection-(Landroid/content/Context; J Ljava/lang/String; [B I Z Ljava/lang/String; I)[B' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-setupEditorForAccount-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-wakeWhenReadyTq-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/AccessibilityInjectorFallback;-<init>-(Landroid/webkit/WebViewClassic;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService$2;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/dialer/voicemail/VoicemailPlaybackFragment$PlaybackViewImpl;-setSpeakerPhoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-access$300-(Lcom/android/contacts/editor/ContactEditorFragment; Landroid/content/Context; Lcom/android/contacts/editor/RawContactEditorView;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneApp;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/accessibility/TouchExplorer;-handleMotionEventStateDragging-(Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/LauncherModel$PackageUpdatedTask$3;-run-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/common/preference/ContactsPreferences$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MessagesAdapter$SearchCursorLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontFromLaunchLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/test/ModelInterpreter;-<init>-(Ljava/net/InetSocketAddress;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-loadFromEF-(I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/mail/store/ServiceStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/filtershow/ui/IconButton;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/RadioInfo;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FieldPort;-setFieldFrame-(Landroid/filterfw/core/Frame; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-isDisabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/tts/ITextToSpeechService$Stub$Proxy;-getClientDefaultLanguage-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub$Proxy;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-setup-(Lcom/android/systemui/statusbar/policy/NetworkController; Lcom/android/systemui/statusbar/policy/BluetoothController; Lcom/android/systemui/statusbar/policy/BatteryController; Lcom/android/systemui/statusbar/policy/LocationController;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView$KeyTimerHandler;-startLongPressTimer-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/IIntentReceiver;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/ConnectivityService$CheckMp;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/dialer/CallDetailActivityQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/net/NetworkStatsService;-performPoll-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/dreams/phototable/PicasaSource;-naturalPrevious-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$10;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/Chronometer;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/CameraSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/alerts/AlertActivity;-onStop-()V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/CalendarViewAdapter;-buildWeekDate-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/location/LocationBlacklist;-reloadBlacklistLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ManageSimMessages$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/ExchangeService;-releaseMailbox-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-installSystemProviders-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MessageOrderManager$LoadMessageListTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$9;-run-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/view/WindowManagerPolicy;-applyPostLayoutPolicyLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManager$LayoutParams;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/SingleRunningTask;-runInternal-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/PhotoPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/commands/media/Media;-sendMediaKey-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$3200-(Lcom/android/gallery3d/ui/PhotoView; I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DreamSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/speech/tts/TextToSpeech;-runActionNoReconnect-(Landroid/speech/tts/TextToSpeech$Action; Ljava/lang/Object; Ljava/lang/String; Z)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-handleDocked-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/alerts/AlarmScheduler;-queryNextReminderAndSchedule-(Landroid/database/Cursor; Landroid/content/Context; Landroid/content/ContentResolver; Lcom/android/calendar/alerts/AlarmManagerInterface; I J)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-readRemoteRssi-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$5900-(Lcom/android/mms/ui/ComposeMessageActivity; Ljava/lang/String; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessages-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/providers/downloads/DownloadInfo$Reader;-newDownloadInfo-(Landroid/content/Context; Lcom/android/providers/downloads/SystemFacade; Lcom/android/providers/downloads/StorageManager; Lcom/android/providers/downloads/DownloadNotifier;)Lcom/android/providers/downloads/DownloadInfo;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/event/EditEventFragment;-onDestroy-()V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$DriverStoppedState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/timer/TimerFragment;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onCreate-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothManager;-getDevicesMatchingConnectionStates-(I [I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/AttachPhotoActivity$1;-onContactLoaded-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/FaceUnlock;-handleServiceConnected-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/AttachmentDownloadService$ServiceCallback;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-setSpeaker-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-stopScan-(I Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/NotificationMgr;-updateMwi-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/Notifier;-sendWakeUpBroadcast-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoModule;-onResumeAfterSuper-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/StateManager;-restoreFromState-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothGatt$1;-onDescriptorRead-(Ljava/lang/String; I I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleSeparator-(I I I I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-<init>-(Landroid/preference/VolumePreference; Landroid/content/Context; Landroid/widget/SeekBar; I Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/ime/Ime;-run-([Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/SetAlarm;-saveAlarm-(Lcom/android/deskclock/Alarm;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/UiModeManagerService;-updateLocked-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/alerts/AlertService;-generateAlerts-(Landroid/content/Context; Lcom/android/calendar/alerts/NotificationMgr; Lcom/android/calendar/alerts/AlarmManagerInterface; Landroid/content/SharedPreferences; Landroid/database/Cursor; J I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-findClockInHierarchy-(Landroid/view/View;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-serverDisconnect-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ActivityManager;-getRecentTasksForUser-(I I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/launcher2/DragController;-drop-(F F)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/StateManager;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/users/AppRestrictionsFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/IRingtonePlayer$Stub$Proxy;-playAsync-(Landroid/net/Uri; Landroid/os/UserHandle; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/Notifier$1;-onScreenOn-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageFileViewFragment;-addAttachment-(Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/socialwidget/SocialWidgetProvider;-access$000-(Landroid/content/Context; I Landroid/appwidget/AppWidgetManager; Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/setup/AccountCheckSettingsFragment$AccountCheckTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/contacts/debug/ContactsDumpActivity$DumpDbTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-inputDispatchingTimedOut-(Lcom/android/server/am/ProcessRecord; Lcom/android/server/am/ActivityRecord; Lcom/android/server/am/ActivityRecord; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForWatchdogToggle-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-isBiometricWeakLivelinessEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothAdapter;-closeProfileProxy-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/research/Uploader;-doUpload-()V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/DeviceAdminSettings;-updateList-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-access$1500-(Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/GlobalActions$4;-onItemLongClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/util/Recycler;-getAllThreads-(Landroid/content/Context;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/net/http/RequestQueue$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$KeyboardListener;-onKey-(Landroid/view/View; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/InCallScreen;-openDialpadInternal-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SettingsObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-clearAll-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/PagedViewIcon;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/transaction/TransactionService;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/ILockSettings;-getString-(Ljava/lang/String; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiService;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/model/SlideshowModel;-getPduBody-(Landroid/content/Context; Landroid/net/Uri;)Lcom/google/android/mms/pdu/PduBody;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/dreams/DreamManagerService;-getDreamComponentsForUser-(I)[Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppDiedLocked-(Lcom/android/server/am/ProcessRecord; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPairingConfirmation-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-setNetworkTemplateEnabled-(Landroid/net/NetworkTemplate; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/content/ContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkStatsService;-getNetworkStatsUidDetail-()Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayView;-switchViews-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephony;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/ListPrefSettingPopup;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/InputMethodManagerService$InputMethodAndSubtypeListManager;-getNextInputMethod-(Z Landroid/view/inputmethod/InputMethodInfo; Landroid/view/inputmethod/InputMethodSubtype;)Lcom/android/server/InputMethodManagerService$ImeSubtypeListItem;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-addCharacteristic-(I Landroid/os/ParcelUuid; I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/content/IContentService$Stub;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onConfirmDialogDismissed-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/TetherSettings;-startTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/AttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/email/AttachmentInfo;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getKeyguardDisabledFeatures-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-hapticAndAudioFeedback-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/PeopleActivity$ContactDetailLoaderFragmentListener$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-getTriState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-markMessagesAsRead-(Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$ShuffleSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/DnsPinger;-getCurrentLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView;-slideToNextPicture-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/DialogTitle;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/ExtractButton;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ConversationList;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/FrameSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoView;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-access$200-(Lcom/android/server/VibratorService;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAdbNotification-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavScreen;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/DataUsageSummary;-access$600-(Lcom/android/settings/DataUsageSummary; Z)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/wallpaper/RenderScriptScene;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-verifyPasswordAndUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageViewFragment;-onDelete-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/SlideshowEditActivity$SlideListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/SipCallOptionHandler;-access$300-(Lcom/android/phone/SipCallOptionHandler; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.USE_SIP', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodButton;-setImeWindowStatus-(Landroid/os/IBinder; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasAccountService;-sync-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-onUuidChanged-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/filtershow/ui/FilterIconButton;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-getPersistedDeviceName-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothPbap;-disconnect-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/common/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodButton;-setHardKeyboardStatus-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PreparePageFadeoutTexture;-onGLIdle-(Lcom/android/gallery3d/glrenderer/GLCanvas; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/AlertActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/input/InputManagerService;-registerPointerSpeedSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-unregisterClient-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ShutterButton$OnShutterButtonListener;-onShutterButtonFocus-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$Helper;-showBouncer-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/common/vcard/VCardImportExportListener;-onImportFinished-(Lcom/android/contacts/common/vcard/ImportRequest; I Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-update-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpace-(I Ljava/lang/String; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$UuidChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/IWindowManager;-clearForcedDisplayDensity-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/editor/ContactEditorFragment$JoinSuggestedContactDialogFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodsPanel;-openPanel-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/os/SystemVibrator;-vibrate-([J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-requestSelectionToScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/DayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/UrlInputView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/PhotoModule;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-call-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/wallpaper/nexus/NexusRS;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/SubSettings;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-isActivePasswordSufficient-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/VideoModule;-onError-(Landroid/media/MediaRecorder; I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-addEditableRawContact-(Landroid/content/Context; Lcom/android/contacts/model/RawContactDeltaList;)Lcom/android/contacts/model/RawContactDelta;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/common/list/DefaultContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-onWindowFocusChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/dialer/voicemail/VoicemailPlaybackPresenter;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getCurrentFailedPasswordAttempts-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/ProfileProvider;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/Launcher;-showFirstRunWorkspaceCling-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/telephony/SmsManager;-getAllMessagesFromIcc-()Ljava/util/ArrayList;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/SecuritySettings;-createPreferenceHierarchy-()Landroid/preference/PreferenceScreen;' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothManager;-disable-(Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onUserSwitching-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-dialRecipient-()V' : ['android.permission.CALL_PHONE'],
	'Landroid/app/admin/DevicePolicyManager;-setPasswordHistoryLength-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/DevicePolicyManager;-setCameraDisabled-(Landroid/content/ComponentName; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAccountView;-reset-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/StatusBarManagerService;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$KeyboardLayoutPickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/SecureSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-performActionForKey-(Lcom/android/inputmethod/keyboard/Key; I Landroid/os/Bundle;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/preference/YesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar$2;-onClickHandler-(Landroid/view/View; Landroid/app/PendingIntent; Landroid/content/Intent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-access$200-(Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/dialer/dialpad/DialpadImageButton;-simulateClickForAccessibility-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/tts/TextToSpeechSettings$2;-onInit-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/WifiDisplayController;-<init>-(Landroid/content/Context; Landroid/os/Handler; Lcom/android/server/display/WifiDisplayController$Listener;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onPause-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue$Element;-onPhantomUpEvent-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/ContactsContract$SyncState;-set-(Landroid/content/ContentProviderClient; Landroid/accounts/Account; [B)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getMediaItemFromPath-(Ljava/util/ArrayList; I I Lcom/android/gallery3d/data/DataManager;)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine;-setWifiApState-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-setCountryListener-(Landroid/location/CountryListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/SuggestionsAdapter;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/Workspace;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/app/ActivityManagerNative;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/email/Controller;-searchMore-(J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$3;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/DevicePolicyManagerService;-setMaximumTimeToLock-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/ITextToSpeechService;-synthesizeToFileDescriptor-(Landroid/os/IBinder; Ljava/lang/String; Landroid/os/ParcelFileDescriptor; Landroid/os/Bundle;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/VideoModule;-init-(Lcom/android/camera/CameraActivity; Landroid/view/View; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/googlecode/mp4parser/authoring/adaptivestreaming/FlatPackageWriterImpl;-write-(Lcom/googlecode/mp4parser/authoring/Movie;)V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/ui/DetailsHelper$DetailsViewContainer;-show-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/FilmstripPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/ActionBarController;-access$800-(Lcom/android/email/activity/ActionBarController; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/DragController;-dropOnFlingToDeleteTarget-(F F Landroid/graphics/PointF;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$2;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RadioButton;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$7;-getCameraIntent-()Landroid/content/Intent;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/PowerManagerService;-init-(Landroid/content/Context; Lcom/android/server/LightsService; Lcom/android/server/am/ActivityManagerService; Lcom/android/server/BatteryService; Lcom/android/internal/app/IBatteryStats; Lcom/android/server/display/DisplayManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/adapter/AccountSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/speech/SpeechRecognizer;-cancel-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/app/IAppOpsCallback$Stub$Proxy;-opChanged-(I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-hasContentChanged-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/NotificationMgr;-init-(Lcom/android/phone/PhoneGlobals;)Lcom/android/phone/NotificationMgr;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/filtershow/crop/CropActivity$BitmapIOTask;-doInBackground-([Landroid/graphics/Bitmap;)Ljava/lang/Boolean;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/data/SecureAlbum;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/settings/BrightnessDialog;-onStart-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager$BaseFutureTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine$Pending;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/nsd/INsdManager$Stub;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-access$300-(Lcom/android/internal/widget/multiwaveview/GlowPadView; I F F)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DockService;-hasOtherConnectedDevices-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipEditor;-access$600-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/CalendarContract$Instances;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; J J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/launcher2/Folder$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getDisabledSystemInputMethods-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getProvisioningOrActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getScanResults-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/view/RotationPolicy$RotationPolicyListener$1;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-onTextInput-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-validate-(Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteAlias-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-createNewRfcommSocketAndRecord-(Ljava/lang/String; Ljava/util/UUID; Z Z)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WpsDialog;-access$200-(Lcom/android/settings/wifi/WpsDialog; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-setRemoteAlias-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/app/admin/DevicePolicyManager;-setMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/TimerRingService;-startAlarm-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendVCards-(Ljavax/obex/Operation; Ljava/lang/String; Z Ljava/lang/String; Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryProvider;-getDictionaryWordListsForLocale-(Ljava/lang/String; Ljava/lang/String; Z)Ljava/util/Collection;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-resetState-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-reportSimUnlocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView$9$1$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/google/SearchBaseUrlHelper$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/detail/ContactDetailFragment$AddToMyContactsQuickFix;-execute-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiApConfigStore$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/IdleMaintenanceService;-updateIdleMaintenanceState-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wfd/WifiDisplaySettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPage-(I I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/CaptivePortalTracker;-isCaptivePortal-(Ljava/net/InetAddress;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/emailcommon/utility/Utility$ForEachAccount;-performAction-(J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/DevelopmentSettings;-updatePointerLocationOptions-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/google/common/io/Resources;-toString-(Ljava/net/URL; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-regenerateInstancesTable-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-setAudioMode-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;-performAppWidgetSizeCallbacksIfNecessary-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-hasPendingChanges-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-<init>-(Lcom/android/music/MediaPlaybackService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLView$OnClickListener;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-setupDataOnConnectableApns-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-disconnect-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/WebViewController;-onProgressChanged-(Lcom/android/browser/Tab;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-setViewStates-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-removeActiveAdmin-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/ChangeNotifier;-onChange-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/MediaSet;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/sip/SipEditor;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/deskclock/AlarmAlertFullScreen$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService$Vibration;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/power/DisplayPowerController$4;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/UIControllerOnePane;-onRespondedToInvite-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-getRemoteClass-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/LocationSettings;-onResume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/BatteryStatsImpl;-setOnBatteryLocked-(Z I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/test/mock/MockContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/setup/LauncherIconVisibilityManager;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateIncomingFileConfirmNotification-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-getLastLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/ContactsContract$Contacts;-getLookupUri-(J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5200-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; Ljava/lang/String;)V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setEnabled-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/common/HapticFeedback;-vibrate-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-startDeleteAll-(Lcom/android/mms/data/Conversation$ConversationQueryHandler; I Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Disconnected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-inputDispatchingTimedOut-(I Z)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DevicePolicyManagerService;-lockNow-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothGattServer;-registerCallback-(Landroid/bluetooth/BluetoothGattServerCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IActivityManager;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavigationBarBase;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/activities/JoinContactActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/policy/Clock;-updateClock-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/PanoramaModule$WaitProcessorTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserHistoryPage$ClearHistoryTask;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-getCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-<init>-(Lcom/android/contacts/activities/PhotoSelectionActivity; Landroid/content/Context; Landroid/view/View; I Lcom/android/contacts/model/RawContactDeltaList; Lcom/android/contacts/activities/PhotoSelectionActivity$1;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/FilterSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/Launcher;-onResume-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-queryExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-onHoldClick-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy;-enterFullScreenVideo-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/settings/BrightnessController;-access$000-(Lcom/android/systemui/settings/BrightnessController;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DevicePolicyManagerService;-saveSettingsLocked-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MessageViewFragment;-onMarkAsUnread-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothPhoneService;-handlePreciseCallStateChange-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/common/list/PinnedHeaderListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/DigitalClock;-onFinishInflate-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onUndoDeleteImage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothPhoneService;-access$400-(Lcom/android/phone/BluetoothPhoneService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EmergencyCallbackModeService;-showNotification-(J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getActiveAdmins-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-topAppWindowChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/users/UserSettings$8;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/google/common/io/Files;-toString-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothA2dp;-shouldSendVolumeKeys-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService$1$2;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView;-onResume-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/sip/SipPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/WebStorageSizeManager;-scheduleOutOfSpaceNotification-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-getSuggestionsWithSessionId-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/String; Lcom/android/inputmethod/keyboard/ProximityInfo; Z I)Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-checkPasswordHistory-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/MediaSetSource$CheckedMediaSetSource;-onContentDirty-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createConsentDialog-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;-delete-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-restorePmMetadata-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/BroadcastQueue;-broadcastTimeoutLocked-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/ExpandHelper;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/exchange/ExchangeService$ServiceCallbackWrapper;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/email/activity/UIControllerTwoPane$RefreshTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/common/vcard/ImportVCardActivity$VCardCacheThread;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-updateAutoSelectionCB-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-queryInternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity$3;-run-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager;-hasGrantedPolicy-(Landroid/content/ComponentName; I I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-pageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Controller;-start-(Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/EmailActivity;-onStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment$2;-onChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendMotionEvent-(Landroid/view/MotionEvent; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/provider/Settings$System;-getIntForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/RemoteDevices;-pinRequestCallback-([B [B I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/launcher2/DragSource;-onFlingToDeleteCompleted-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/camera/ui/CameraSwitcher;-access$000-(Lcom/android/camera/ui/CameraSwitcher; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/GLRoot;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine;-handleScreenStateChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$SettingsContentObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$LoaderTask;-onPostExecute-(Ljava/lang/Boolean;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/FaceUnlock;-handleCancel-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-access$500-(Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebIconDatabaseClassic;-bulkRequestIconForPageUrl-(Landroid/content/ContentResolver; Ljava/lang/String; Landroid/webkit/WebIconDatabase$IconListener;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/voicedialer/VoiceDialerActivity$3;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addImage-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/provider/BrowserProvider2;-updateBookmarksInTransaction-(Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/HidProfile;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/group/GroupEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onClockVisibilityChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/dialer/calllog/DefaultVoicemailNotifier$NameLookupQuery;-query-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-setRetryAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/sip/SipSettings$3;-run-()V' : ['android.permission.READ_PROFILE', 'android.permission.USE_SIP'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-updateSecurityViews-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/SimContacts;-displayProgress-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-checkAccessPermission-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothGatt;-removeService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-requestRouteToHostAddress-(I [B)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/bluetooth/hid/HidService;-broadcastConnectionState-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/InfoDropTarget;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/StateMachine$SmHandler$HaltingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActiveServices;-bringUpServiceLocked-(Lcom/android/server/am/ServiceRecord; I Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasSyncService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-addUserTiles-(Landroid/view/ViewGroup; Landroid/view/LayoutInflater;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/SimpleWeekView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasSyncService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/inputmethodservice/ExtractEditText;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-registerForNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/TrimVideo;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/telephony/SmsProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-loadPreferences-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/IConnectivityManager$Stub;-startLegacyVpn-(Lcom/android/internal/net/VpnProfile;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/XLargeUi;-onBackKey-()Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/GLRootView;-onDrawFrame-(Ljavax/microedition/khronos/opengles/GL10;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dialer/dialpad/DigitsEditText;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-removeBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/power/DisplayPowerController$Callbacks;-onProximityPositive-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/EventInfoFragment;-updateEvent-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/EmailServiceProxy;-<init>-(Landroid/content/Context; Landroid/content/Intent; Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiManager$MulticastLock;-release-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/contacts/util/NameConverter;-structuredNameToDisplayName-(Landroid/content/Context; Ljava/util/Map;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-changeIccLockPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaStartupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onCancelEvent-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/HTML5VideoView;-reprepareData-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/LogTag$1;-run-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/accounts/AccountManagerService$5;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothGatt$1;-onDescriptorWrite-(Ljava/lang/String; I I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothHealth;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-parsePingResult-(Ljava/io/InputStream; Landroid/content/ContentResolver; Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/MessageViewFragment;-performAttachmentSave-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)Ljava/io/File;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/base/GLTextureSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5700-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/SmsReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$4;-run-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/DTMFTwelveKeyDialer$DTMFKeyListener;-onKeyDown-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService;-restartPortMappingLifetimeMeasurement-(Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-updateClustersContents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/ExchangeService$1;-loadAttachmentStatus-(J J I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-asyncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/Suggest;-getSuggestedWordsForTypingInput-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/String; Lcom/android/inputmethod/keyboard/ProximityInfo; Z Z)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-setHoldScreenLocked-(Lcom/android/server/wm/Session;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-buildAppWidgetModel-(Landroid/content/Context; Landroid/database/Cursor; Ljava/lang/String;)Lcom/android/calendar/widget/CalendarAppWidgetModel;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parse-()Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/service/MailService;-refreshSyncReports-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/galaxy4/GalaxyView;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-updateLocalProfiles-([Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/ContactEditorAccountsChangedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewClassic;-setBaseLayer-(I Z Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/SmsStorageMonitor;-handleIccFull-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneInterfaceManager;-answerRingingCallInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager;-getWifiApEnabledState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-setLocaleFromCsim-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowSession$Stub;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$2;-onUserSwitched-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/location/ILocationManager$Stub;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/search/SearchManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getDrmMimeSavedStringRsrc-(J Z)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-addCachedDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmKlaxon;-play-(Lcom/android/deskclock/Alarm;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewManager;-onScreenTurnedOff-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodSubtypeMenu-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessagesInSameThreadAsMessage-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebIconDatabaseClassic$EventHandler;-postMessage-(Landroid/os/Message;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/deskclock/DigitalClock;-updateTime-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ConversationList$2;-run-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DockService;-connectIfEnabled-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/content/ContentService;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/gallery3d/app/StitchingChangeListener;-onStitchingResult-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/DownloadUtils;-requestDownload-(Lcom/android/gallery3d/util/ThreadPool$JobContext; Ljava/net/URL; Ljava/io/File;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-onSystemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompatJellyBean$1;-createAccessibilityNodeInfo-(I)Landroid/view/accessibility/AccessibilityNodeInfo;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/mms/util/Recycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveRingtone-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/WirelessSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/BroadcastQueue;-skipPendingBroadcastLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/settings/BrightnessController;-<init>-(Landroid/content/Context; Landroid/widget/ImageView; Lcom/android/systemui/settings/ToggleSlider;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/accounts/AccountSyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodsPanel;-getEnabledInputMethodAndSubtypeList-()Ljava/util/TreeMap;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavScreen;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/widget/DateTimeView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Landroid/webkit/AccessibilityInjector$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/sip/SipEditor;-deleteAndUnregisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/gsm/UsimDataDownloadHandler;-sendSmsAckForEnvelopeResponse-(Lcom/android/internal/telephony/uicc/IccIoResult; I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$1300-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/XLargeUi;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/DeviceStorageMonitorService;-clearCache-()V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/bluetooth/IBluetoothGatt;-registerServer-(Landroid/os/ParcelUuid; Landroid/bluetooth/IBluetoothGattServerCallback;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadsetPhone;-processChld-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPdus-([[B)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-savePhonebookPermissionChoice-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/DockService;-applyBtSettings-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/MessageStatusService;-updateMessageStatus-(Landroid/content/Context; Landroid/net/Uri; [B Ljava/lang/String;)Landroid/telephony/SmsMessage;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/list/LegacyPhoneNumberPickerFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/users/UserSettings;-hasLockscreenSecurity-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiService;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/CameraActivity;-openModule-(Lcom/android/camera/CameraModule; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordExpirationTimeout-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ChooseLockPattern$ChooseLockPatternFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onSingleTapUp-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-installIfNeverRequested-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/settings/DataUsageSummary$12;-onInspectRangeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/service/IEmailService;-autoDiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ComboAlbum;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ManageSimMessages;-access$000-(Lcom/android/mms/ui/ManageSimMessages;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/Controller;-onConfgurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/wifi/WifiApEnabler;-updateTetherState-([Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/MessagingController;-synchronizeMailboxSynchronous-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/ConnectivityManager;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Tab$SubWindowClient;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-buildEntries-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/DevicePolicyManager;-getCameraDisabled-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/DataManager;-getSupportedOperations-(Lcom/android/gallery3d/data/Path;)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastStickyIntent-(Landroid/content/Intent; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-isDrmRingtoneWithRights-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/AllInOneActivity;-updateSecondaryTitleFields-(J)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-acknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-determineScrollingStart-(Landroid/view/MotionEvent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/datetimepicker/AccessibleTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/DevicePolicyManager;-setPasswordMinimumNonLetter-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onDisconnectDcRetrying-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/KeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/app/backup/IRestoreSession$Stub;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmTimePickerDialogFragment$AlarmTimePickerDialogHandler;-onDialogTimeSet-(Lcom/android/deskclock/Alarm; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/bluetooth/gatt/GattService;-readDescriptor-(I Ljava/lang/String; I I Ljava/util/UUID; I Ljava/util/UUID; Ljava/util/UUID; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityRecord$Token;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$PersistTask;-doInBackground-([Lcom/android/contacts/model/RawContactDeltaList;)Ljava/lang/Integer;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActiveServices;-performServiceRestartLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressShift-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAccountView;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/AlarmKlaxon;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/filtershow/FilterShowActivity$6;-onExecute-(Lcom/android/gallery3d/filtershow/FilterShowActivity;)Landroid/graphics/Bitmap;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-sendAccessibilityEventForKey-(Lcom/android/inputmethod/keyboard/Key; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getRemoteClass-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordHistoryLength-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/VideoModule;-onCancelBgTraining-(Landroid/view/View;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowManagerService;-setUniverseTransformLocked-(Lcom/android/server/wm/WindowState; F F F F F F F)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/server/BluetoothA2dpService;-handleSinkStateChange-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDisconnectingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.RECORD_AUDIO'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/location/ILocationProvider$Stub;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onMessageNotExists-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$2;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEnded-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel;-onNextAlarmChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/backup/IObbBackupService$Stub;-backupObbs-(Ljava/lang/String; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/BluetoothManagerService;-access$1900-(Lcom/android/server/BluetoothManagerService; Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerTwoPane;-showAccountSpecificWarning-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/updates/CertPinInstallReceiver;-access$000-(Lcom/android/server/updates/ConfigUpdateInstallReceiver; Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$InnerTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/Controller;-getServiceForAccount-(J)Lcom/android/emailcommon/service/IEmailService;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView$4$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createMessageForEventId-(Landroid/content/Context; J I Ljava/lang/String; Lcom/android/emailcommon/provider/Account; Ljava/lang/String;)Lcom/android/emailcommon/provider/EmailContent$Message;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterfw/core/Filter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/WifiController$DeviceActiveState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/TintFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-userSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BatteryService;-access$200-(Lcom/android/server/BatteryService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/AddBookmarkPage;-getUriForFolder-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/LocationManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettings;-forget-()V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/exchange/ExchangeService;-done-(Lcom/android/exchange/AbstractSyncService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-showWeb-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/am/CoreSettingsObserver;-beginObserveCoreSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-handleSetHidden-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accounts/AccountManagerService;-getAccounts-(I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/CalendarEventModel;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/app/KeyguardManager;-isKeyguardSecure-()Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$6;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/Recorder;-setState-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/app/ActivityManagerNative;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthDeathRecipient;-binderDied-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pManager;-initialize-(Landroid/content/Context; Landroid/os/Looper; Landroid/net/wifi/p2p/WifiP2pManager$ChannelListener;)Landroid/net/wifi/p2p/WifiP2pManager$Channel;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/applications/AppOpsDetails;-refreshUi-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/webkit/GeolocationService;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/AccessibilitySettings$ToggleScreenMagnificationPreferenceFragment;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterfw/core/FilterFunction;-executeWithArgList-([Ljava/lang/Object;)Landroid/filterfw/core/Frame;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment;-access$000-(Lcom/android/contacts/detail/ContactDetailUpdatesFragment; Lcom/android/contacts/util/StreamItemEntry;)Lcom/android/contacts/common/model/account/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/MessageListAdapter$OnDataSetChangedListener;-onContentChanged-(Lcom/android/mms/ui/MessageListAdapter;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/SlideEditorActivity;-access$400-(Lcom/android/mms/ui/SlideEditorActivity;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-showAllAppsCling-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGatt;-sendNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onProgressComplete-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-restoreSelectedUri-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityModel;-isBiometricUnlockSuppressed-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-startCamera-()V' : ['android.permission.CAMERA'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getCurrentFailedPasswordAttempts-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-enforceChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity$4;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-<init>-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addVideo-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/common/HapticFeedback;-checkSystemSetting-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityViewFlipper;-reset-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/net/wifi/IWifiManager;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/contacts/group/GroupDetailFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/SecuritySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/BluetoothPhoneService;-handleListCurrentCalls-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageItem$PduLoadedCallback;-onPduLoaded-(Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/widget/NumberPicker$CustomEditText;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/MccTable;-setWifiCountryCodeFromMcc-(Landroid/content/Context; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/DayView;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnectedProfile-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AccountsChangedReceiver$DeleteRemovedAccounts;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/widget/LockPatternUtils;-getAppWidgets-()[I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavScreen;-access$000-(Lcom/android/browser/NavScreen; Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ViewInterface;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/Invert;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/PageDialogsHandler;-createSslCertificateDialog-(Landroid/net/http/SslCertificate; Landroid/net/http/SslError;)Landroid/app/AlertDialog$Builder;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/State;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$1900-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/gatt/GattService;-readRemoteRssi-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/WindowManagerService;-startAppFreezingScreenLocked-(Lcom/android/server/wm/AppWindowToken; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-deleteSms-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-startLongPressTimer-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-storeMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/email/activity/ContactStatusLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/AsyncQueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-access$300-(Lcom/android/contacts/activities/PeopleActivity;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onBeforeMessageGone-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/dreams/DreamManagerService;-startDream-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary$CycleItem;-<init>-(Landroid/content/Context; J J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/os/IHardwareService$Stub;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPan$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ConnectivityService$CheckMp;-printNetworkInfo-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LightsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/phone/PhoneUtils;-hangupHoldingCall-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplaySize-(I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/alerts/AlarmScheduler;-scheduleNextAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/BrowserWebView;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-onCreate-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/AccountManager;-hasFeatures-(Landroid/accounts/Account; [Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-showEmptyStateForTab-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/CalendarColorPickerDialog$QueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/PhoneProxy;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/PhoneUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/display/DisplayAdapter$2;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Landroid/content/Intent;)Ljava/lang/Void;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/settings/TrustedCredentialsSettings$1;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/BluetoothPhoneService;-onCreate-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/HTML5VideoView;-prepareDataCommon-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveDraft-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/widget/ChartSweepView;-dispatchOnSweep-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteType-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView$PageSwitchListener;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/util/JobLimiter$JobWrapper;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/QuickResponseActivity;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/TelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/gatt/GattService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerSession;-onGetSuggestionsInternal-(Landroid/view/textservice/TextInfo; I)Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.WRITE_CONTACTS', 'android.permission.INTERNET', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/provider/Browser;-addSearchUrl-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/VideoModule;-onEffectsUpdate-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getRequestedPasswordMinimumNonLetter-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BatteryService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/InputMonitor;-notifyLidSwitchChanged-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/DatePickerDialog;-<init>-(Landroid/content/Context; I Landroid/app/DatePickerDialog$OnDateSetListener; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-access$2500-(Lcom/android/server/location/GpsLocationProvider; I Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$Callbacks;-onCameraLaunchedSuccessfully-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPin-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/AccessibilityInjector;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dialer/dialpad/SmartDialLoaderTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MusicPicker;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-startStateForResult-(Ljava/lang/Class; I Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/PowerManagerService$BootCompletedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/MobileNetworkSettings;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$3;-getCameraWidgetInfo-()Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher$CameraWidgetInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/UiModeManagerService;-access$000-(Lcom/android/server/UiModeManagerService; Ljava/lang/String; I I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$12;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-postEventFromNative-(Ljava/lang/Object; I I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onDevicePreferenceClick-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processDisplayText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-onPopupItemClick-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarColorPickerDialog;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-showEmptyState-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodButton;-loadInputMethodSelectorVisibility-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LocationManagerService$4;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/RadioInfo;-access$3400-(Lcom/android/settings/RadioInfo;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/PhoneUtils;-mergeCalls-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothA2dpService;-checkSinkSuspendState-(I)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/TabControl;-createNewTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/transaction/TransactionService$ServiceHandler;-processTransaction-(Lcom/android/mms/transaction/Transaction;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/camera/VideoModule$1;-onMediaSaved-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/EasAccountService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/CalendarView;-access$900-(Landroid/widget/CalendarView; Landroid/widget/AbsListView; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/TabControl;-removeParentChildRelationShips-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/filtershow/tools/BitmapTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipService;-notifyProfileRemoved-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dialer/dialpad/DialpadFragment;-isVoicemailAvailable-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/common/model/AccountTypeManagerImpl;-findUsableInvitableAccountTypes-(Landroid/content/Context;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/input/InputManagerService;-showMissingKeyboardLayoutNotification-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$AppOpsSummaryActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-parseIntent-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/pm/PackageManagerService;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/deskclock/SetAlarm;-updatePrefs-(Lcom/android/deskclock/Alarm;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/contacts/common/list/ContactEntryListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-isSecure-()Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityRecord$Token;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/DevicePolicyManager;-getPasswordExpiration-(Landroid/content/ComponentName;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-onPressKey-(I Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-finishLoadAttachment-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accounts/AccountManagerService$Session;-run-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-updateCallLogContactInfoCache-(Ljava/lang/String; Ljava/lang/String; Lcom/android/dialer/calllog/ContactInfo; Lcom/android/dialer/calllog/ContactInfo;)V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-setKeyguardEnabled-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/AccessibleTextView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary;-access$100-(Lcom/android/settings/DataUsageSummary;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone; Landroid/telephony/CellInfo;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/ByteStreams;-getChecksum-(Lcom/google/common/io/InputSupplier; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothCallback$Stub$Proxy;-onBluetoothStateChange-(I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-loadAttachment-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onStart-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/DayFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPageWithVelocity-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy;-enterFullscreenForVideoLayer-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setMaximumTimeToLock-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$PersistTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-createAccessibilityEvent-(Lcom/android/inputmethod/keyboard/Key; I)Landroid/view/accessibility/AccessibilityEvent;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/ActivityBase;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/TintEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/ui/ActionModeHandler$2;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothHeadset;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebIconDatabaseClassic$EventHandler;-access$500-(Landroid/webkit/WebIconDatabaseClassic$EventHandler; Landroid/os/Message;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/dialer/DialtactsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/sip/SipEditor;-createSipProfile-()Landroid/net/sip/SipProfile;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-handleNotificationError-(Landroid/os/IBinder; Landroid/service/notification/StatusBarNotification; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/AppOpsManager$Callback;-opChanged-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarDebug$FetchInfoTask;-doInBackground-([Ljava/lang/Void;)Ljava/util/List;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/SmsReceiverService;-replaceMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/net/DataUsageMeteredSettings;-updateNetworks-(Landroid/content/Context;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView;-verifyPasswordAndUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/TransactionService$ConnectivityBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-access$400-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-checkAppWidgetConsistency-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService;-setOverscan-(I I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-snapToPage-(I I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/SnailAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dialer/list/PhoneFavoriteFragment$ContactsPreferenceChangeListener;-onChange-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/Controller$LegacyListener;-checkMailStarted-(Landroid/content/Context; J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/contacts/debug/DataExporter;-exportData-(Landroid/content/Context;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/commands/media/Media;-runDispatch-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-enter-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/ChooseLockGeneric$ChooseLockGenericFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService$UpdateThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-sendSettings-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-queueQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-updateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ClassZeroActivity$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/EmptyAlbumImage;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/photos/AlbumSetFragment;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CallFeaturesSetting;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/settings/SettingsHelper;-applyAudioSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/IConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/EventInfoFragment;-showContactInfo-(Lcom/android/calendar/CalendarEventModel$Attendee; Landroid/graphics/Rect;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V30;-handleNest-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-isSubtypeSelected-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/MediaSet$ItemConsumer;-consume-(I Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/dataconnection/DcTrackerBase;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-updateMessageOnIccEf-(Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/date/YearPickerView;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-modifyCalendarSubscription-(J Z)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/contacts/DatabaseModifier;-insert-(Landroid/content/ContentValues;)J' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralView;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onDisconnectDone-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHealth$Stub$Proxy;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getSelectedInputMethod-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mms/ui/RecipientsEditor;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothPan;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/Utils;-getDayOfWeekString-(I I J Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-confirmSendMessageIfNeeded-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/Connectivity$WifiScanReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-bindGroupView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor; I Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiService;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/ConnectivityService;-getProvisioningOrActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createUserEntryDialog-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-getClockFlags-(Landroid/widget/TextClock;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/location/ILocationProvider$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/text/method/TextKeyListener;-getPrefs-(Landroid/content/Context;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/sharedstoragebackup/ObbBackupService$1;-restoreObbFile-(Ljava/lang/String; Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView;-verifyPasswordAndUnlock-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/text/format/DateUtils;-getRelativeDateTimeString-(Landroid/content/Context; J J J I)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-acquireWakeLockAndExecute-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5400-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager;-wipeData-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmKlaxon;-startAlarm-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-bindQuickContact-(Lcom/android/contacts/common/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$RecipientsMenuClickListener;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterState$PendingCommandState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/DevelopmentSettings;-access$000-(Landroid/content/Context; Ljava/lang/String; Z)V' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicvis/vis1/Visualization1$CubeEngine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/BluetoothManagerService;-access$2900-(Lcom/android/server/BluetoothManagerService;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onCreate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterFunction;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onBindView-(Landroid/view/View;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onActionBarWanted-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine;-access$22000-(Landroid/net/wifi/WifiStateMachine; Ljava/util/ArrayList;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DevicePolicyManagerService;-updateMaximumTimeToLockLocked-(Lcom/android/server/DevicePolicyManagerService$DevicePolicyData;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/PageDialogsHandler$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/PhotoPage;-updateUIForCurrentPhoto-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/common/list/PhoneNumberListAdapter;-bindQuickContact-(Lcom/android/contacts/common/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-attach-(Landroid/service/wallpaper/WallpaperService$IWallpaperEngineWrapper;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-clearServices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/settings/ToggleSlider;-onStartTrackingTouch-(Landroid/widget/SeekBar;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DreamBackend;-getBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-updateMessageOrderManager-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onPause-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-getSelectedSpellChecker-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-internalSilenceRinger-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/camera/PhotoModule;-updatePreviewSize-(Lcom/android/camera/CameraScreenNail;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageViewFragment;-addAttachment-(Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/DownUpDetector;-setState-(Z Landroid/view/MotionEvent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadAttachmentsTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-prepareForSave-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-isDuplicateMessage-(Landroid/content/Context; Lcom/google/android/mms/pdu/RetrieveConf;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/PushReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-wakeWhenReadyTq-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/Transaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader$LoadEventsRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/group/GroupDetailFragment;-updateAccountType-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/speech/tts/TtsEngines;-getLocalePrefForEngine-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$DreamSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-rightButtonAction-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/GrayscaleEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/IccLockSettings;-tryChangePin-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ClearMissedCallsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/soundrecorder/SoundRecorder;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-startRfcommSocketListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/SnapshotTab;-postCapture-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/DataController$DataControllerHandler;-doLoadThumbnail-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/FlipFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-getCellLocation-()Landroid/telephony/CellLocation;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-closeDialpadInternal-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-access$2300-(Lcom/android/server/power/PowerManagerService; Lcom/android/server/power/PowerManagerService$WakeLock;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/event/EditEventView$TimeClickListener;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WaveView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/GlobalSearchSupport;-handleSearchShortcutRefresh-(Landroid/database/sqlite/SQLiteDatabase; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/CancellationSignal;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/ActivityController;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/coremedia/iso/IsoFile;-<init>-(Ljava/nio/channels/ReadableByteChannel;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onUserSwitchComplete-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoInline;-prepareDataCommon-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DevicePolicyManagerService;-systemReady-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/photos/shims/MediaSetLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/PrivacySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-onScreenTurnedOn-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-access$400-(Lcom/android/server/am/ActivityManagerService; Ljava/lang/String; I Z Z Z Z I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-updateLockScreenTimeout-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/research/MainLogBuffer;-publishLogUnitsAtFrontOfBuffer-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageUtils;-getTextMessageDetails-(Landroid/content/Context; Landroid/database/Cursor;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onUuidChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/renderscript/RSSurfaceView;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/downloads/DownloadThread;-runInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/alerts/AlertActivity;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/DatePickerDialog;-onDateChanged-(Landroid/widget/DatePicker; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth$Stub;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/ui/NoConfirmationSendService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountAdapter;-getChildrenCursor-(Landroid/database/Cursor;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/location/fused/FusedLocationService;-onUnbind-(Landroid/content/Intent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/dialer/dialpad/SmartDialTextView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcActivatingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/NavScreen$2;-onLayout-(I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/location/ILocationManager$Stub;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-unregisterServer-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-start-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/AddBookmarkPage$UpdateBookmarkTask;-doInBackground-([Landroid/content/ContentValues;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/util/IState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cat/CatService;-sendTerminalResponse-(Lcom/android/internal/telephony/cat/CommandDetails; Lcom/android/internal/telephony/cat/ResultCode; Z I Lcom/android/internal/telephony/cat/ResponseData;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$NextAlarmObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallTouchUi;-updateState-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ui/PieItem;-performClick-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-getCurrentSpellCheckerSubtype-(Ljava/lang/String; Z)Landroid/view/textservice/SpellCheckerSubtype;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CropFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings;-startSettingsActivity-(Landroid/content/Intent; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-packageHasActiveAdmins-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-processConnectOtherProfiles-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/AudioPreview;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ISyncAdapter;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService$3;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$30;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wm/WindowManagerService;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/AggregationSuggestionView;-handleItemClickEvent-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/GLTextureTarget;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateUtils;-formatDateTime-(Landroid/content/Context; J I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-setImeWindowStatus-(Landroid/os/IBinder; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothGattServer;-clearServices-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$4900-(Lcom/android/bluetooth/hfp/HeadsetStateMachine;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-requestTraversalLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-access$1700-(Lcom/android/gallery3d/app/AlbumSetPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/Controller;-sendPendingMessages-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/SlideViewInterface;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setKeyguardDisabledFeatures-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter$GattCallbackWrapper;-stopLeScan-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Phone;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary$8;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/calendar/CalendarProviderBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-launchDevicePicker-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/DevicePolicyManagerService;-wipeData-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-createDevicePreference-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-startLocationBasedDetector-(Landroid/location/CountryListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/HTML5VideoInline;-prepareDataAndDisplayMode-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/CallbackFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getIMEI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/DevicePolicyManager;-getPasswordMinimumNumeric-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/RecognitionManagerService;-systemReady-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$2600-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocationClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-clearForcedDisplaySize-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setRemoteAlias-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/event/EventInterpreter;-onEvent-(Lcom/android/inputmethod/event/Event;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/CallFeaturesSetting;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/JoinContactListFragment;-loadPreferences-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-execute-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/common/interactions/ImportExportDialogFragment$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/TetherSettings;-updateBluetoothState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/DhcpStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/Controller;-openTab-(Ljava/lang/String; Lcom/android/browser/Tab; Z Z)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-pageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/DeleteEventHelper;-delete-(J J J I Ljava/lang/Runnable;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-dismiss-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/TetherSettings;-updateState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/view/RotationPolicy;-registerRotationPolicyListener-(Landroid/content/Context; Lcom/android/internal/view/RotationPolicy$RotationPolicyListener; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/DataController$DataControllerHandler;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/DockService;-handleBluetoothStateOn-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/ExchangeService;-serviceRequest-(J J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DevicePolicyManagerService;-hasGrantedPolicy-(Landroid/content/ComponentName; I I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/nsd/NsdManager;-init-()V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactSaveService;-removeMembersFromGroup-(Landroid/content/ContentResolver; [J J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-getBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$UninitializedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/RotationToggle;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setFilter-(Lcom/android/contacts/common/list/ContactListFilter; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/AccessibilitySettings$ToggleSwitch;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/common/editor/SelectAccountDialogFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-reset-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/PhotoUI;-startCountDown-(I Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/DocumentaryEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/accounts/AccountManager;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-startGetCallerInfo-(Landroid/content/Context; Lcom/android/internal/telephony/Connection; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/phone/PhoneUtils$CallerInfoToken;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/text/StringLogger;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/PlaybackQueueItem;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/list/ContactEntryListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramFailureDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startLongPressTimer-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-startAction-(I I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/SpellChecker;-resetSession-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/IAccountService$Stub;-reconcileAccounts-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/contacts/ContactsProvider2$PipeMonitor;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/media/effect/effects/ColorTemperatureEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/RecognizerEngine;-recognize-(Lcom/android/voicedialer/RecognizerClient; Landroid/app/Activity; Ljava/io/File; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/dictionarypack/ActionBatch$StartDownloadAction;-execute-(Landroid/content/Context;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/LocationSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/preference/SortOrderPreference;-getSummary-()Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/settings/CurrentUserTracker;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/settings/ToggleSlider$Listener;-onChanged-(Lcom/android/systemui/settings/ToggleSlider; Z Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-scrollRight-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-removeTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/EventLoader$LoadEventDaysRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/content/SyncManager$SyncHandler;-closeActiveSyncContext-(Lcom/android/server/content/SyncManager$ActiveSyncContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/DebugFragment;-clearWebViewCache-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cat/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/CropEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/gatt/GattService;-beginServiceDeclaration-(I I I I Ljava/util/UUID;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/compat/UserDictionaryCompatUtils;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/phone/PhoneGlobals$NotificationBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-setContactData-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/SettingsPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothInputDevice;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService$VolumeStreamState;-<init>-(Landroid/media/AudioService; Ljava/lang/String; I Landroid/media/AudioService$1;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$5800-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEventInternal-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/SearchPanelView$1;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/power/PowerManagerService;-userActivityInternal-(J I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onPress-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/data/Contact$ContactsCache;-access$600-(Lcom/android/mms/data/Contact$ContactsCache; Lcom/android/mms/data/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-isForwardable-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/common/database/NoNullCursorAsyncQueryHandler;-onNotNullableQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/noisefield/NoiseFieldWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView;-onResume-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/MoviePlayer;-startVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewProvider$ViewDelegate;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getSelectedGroupPosition-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-access$600-(Lcom/android/voicedialer/VoiceDialerActivity; I)I' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/CryptKeeper;-access$600-(Lcom/android/settings/CryptKeeper;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BaseUi;-showWeb-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/WebViewController;-onDownloadStart-(Lcom/android/browser/Tab; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/am/ActivityStack;-updateTransitLocked-(I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wm/Session;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/settings/RadioInfo$20;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView;-onPause-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/AccountsTester$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/DevicePolicyManagerService;-getCameraDisabled-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getKeyguardDisabledFeatures-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-clearServices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-setRestrictBackground-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView$9;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getDrmMimeMenuStringRsrc-(J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/FrameStore;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/UIControllerTwoPane$RefreshTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-addAudio-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/AccessibilitySettings;-getEnabledServicesFromSettings-(Landroid/content/Context;)Ljava/util/Set;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/SimContacts;-access$100-(Lcom/android/phone/ADNList; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/ActionBarController;-access$500-(Lcom/android/email/activity/ActionBarController;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/event/EditEventView$DateListener;-onDateSet-(Lcom/android/datetimepicker/date/DatePickerDialog; I I I)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/SnailAlbum;-notifyChange-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateFromProvider-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onAction-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserBackupAgent;-addBookmark-(Lcom/android/browser/BrowserBackupAgent$Bookmark;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onCancelled-(Ljava/lang/Void;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/CameraActivity;-doChangeCamera-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/wifi/WifiEnabler;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth;-getRemoteAlias-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/SetAlarm;-onRestoreInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BreadCrumbView;-pop-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-getSuggestions-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/String; Lcom/android/inputmethod/keyboard/ProximityInfo; Z)Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/AccessibleTabView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/CameraModule;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/location/GpsNetInitiatedHandler;-handleNiNotification-(Lcom/android/internal/location/GpsNetInitiatedHandler$GpsNiNotification;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/MessageUtils;-formatTimeStampString-(Landroid/content/Context; J)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$AppOpsSummaryActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IAccountService$Stub$Proxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-releaseScheduleNextAlarmWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-animateCollapsePanels-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; Ljava/util/Collection; I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/wm/Wm;-run-([Ljava/lang/String;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/RingerVolumePreference;-onBindDialogView-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-dispatchHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/view/IWindowSession$Stub;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-systemReady-(Lcom/android/server/StatusBarManagerService;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/MuteVideo$1;-run-()V' : ['android.permission.INTERNET'],
	'Lcom/android/server/ServiceWatcher$2;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordFragment;-updateSpinner-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/email/service/MailService$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentRegionMedia-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/RegionMediaModel; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/EasSyncService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPageImmediately-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$200-(Lcom/android/bluetooth/pbap/BluetoothPbapService;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/UIControllerTwoPane;-switchAccount-(J Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/RotationToggle;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MessagesAdapter$MessagesCursorLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/adapter/Search;-searchMessages-(Landroid/content/Context; J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/list/ContactBrowseListFragment$ContactLookupTask;-onPostExecute-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/GalleryActionBar$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-<init>-(Landroid/content/Context; Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame$Callbacks; Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher; Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher$CameraWidgetInfo; Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/RawContactReadOnlyEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/Tab$3;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/editor/AggregationSuggestionEngine;-buildAggregationSuggestionUri-(Lcom/android/contacts/common/model/ValuesDelta;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/AccountManager$2;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/tts/compat/CompatTtsService;-access$600-(Landroid/speech/tts/TextToSpeechService;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiStateMachine$L2ConnectedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/text/format/DateUtils;-formatDateRange-(Landroid/content/Context; J J I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-addAppLocked-(Landroid/content/pm/ApplicationInfo; Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-clientConnect-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothGatt;-registerForNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothTetheringDataTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DisplaySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-switchWithCaptureAnimation-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/CameraScreenNail$1;-onDraw-(Lcom/android/gallery3d/glrenderer/GLCanvas; I I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-getResponseStatus-(J)I' : ['android.permission.READ_SMS'],
	'Lcom/android/vcard/VCardEntry$EntryElement;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothAdapter;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPairingConfirmation-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/common/list/CustomContactListFilterActivity$GroupDelta;-buildDiff-()Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-reloadDataAndSetSelectedUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPINView;-onWindowFocusChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/EventColorPickerDialog;-onColorSelected-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/NotificationPlayer$CreationAndCompletionThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/NotificationStation;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/SupplicantStateTracker$ScanState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$3;-launchCamera-(Landroid/os/Handler; Ljava/lang/Runnable;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/updates/SELinuxPolicyInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ClassZeroActivity;-access$200-(Lcom/android/mms/ui/ClassZeroActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordQuality-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/wallpaper/galaxy/GalaxyRS;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String; I Landroid/content/BroadcastReceiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processEventNotify-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/DeleteDropTarget;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Telephony$Sms$Inbox;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long; Z)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-doJoinSuggestedContact-([J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/FaceUnlock;-handleUnlock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getContactMethodUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-findMediaItem-(Lcom/android/gallery3d/data/MediaSet; I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/EdgeView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipService$SipKeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/SwipeHelper$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/dialer/SpecialCharSequenceMgr;-handleChars-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-determineScrollingStart-(Landroid/view/MotionEvent; F)V' : ['android.permission.WRITE_SETTINGS'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-execute-(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;' : ['android.permission.INTERNET'],
	'Lcom/android/server/wifi/WifiService;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/common/vcard/SelectAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage;-loadFromUri-(Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/ActivityManagerNative;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setHdmiPlugged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-main-(Landroid/content/Context; Lcom/android/server/pm/Installer; Z Z)Landroid/content/pm/IPackageManager;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/DateTimeSettings;-onDateSet-(Landroid/widget/DatePicker; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasOutboxService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingInsecureRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogEnabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/hdp/HealthService;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneGlobals;-handleOtaspEvent-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-refreshStats-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/BluetoothSocket;-initSocketNative-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/dialer/calllog/DefaultVoicemailNotifier$DefaultNewCallsQuery;-query-()[Lcom/android/dialer/calllog/DefaultVoicemailNotifier$NewCall;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/Controller;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/settings/Settings$HeaderAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-asyncDeleteDraftMmsMessage-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/ConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-reportSuccessfulPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-handleCaptivePortalTrackerCheck-(Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertStatusUpdate-(Landroid/content/ContentValues;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/TransactionService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/settings/LocationSettings;-updateLocationToggles-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl$SipKeepAlive;-onError-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onRemovePictureChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-getViewAt-(I)Landroid/widget/RemoteViews;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserBookmarksPage$OpenAllInTabsTask;-doInBackground-([Ljava/lang/Void;)Landroid/database/Cursor;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/GroupMemberLoader;-constructLoaderForGroupEditorQuery-(Landroid/content/Context; J)Lcom/android/contacts/GroupMemberLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE'],
	'Landroid/widget/TextClock$1;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-setCurrentPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-deleteSms-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setScanMode-(I I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingCalendars-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/common/list/AccountFilterActivity$FilterListAdapter;-<init>-(Landroid/content/Context; Ljava/util/List; Lcom/android/contacts/common/list/ContactListFilter;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/PhotoPage;-transitionFromAlbumPageIfNeeded-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/SmsUsageMonitor;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/provider/Contacts$People;-createPersonInMyContactsGroup-(Landroid/content/ContentResolver; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothHeadset;-disconnectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallCard;-updateCallStateWidgets-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/DayView;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/RespondViaSmsManager;-access$400-(Lcom/android/phone/RespondViaSmsManager; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/location/ILocationProvider;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-switchToNextInputSubtypeInThisIme-(Landroid/os/IBinder; Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.INTERNET', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/setup/AccountSettingsEditQuickResponsesFragment$QuickResponseFinder;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/DevicePolicyManagerService;-getCurrentFailedPasswordAttempts-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/browser/Bookmarks$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/TintFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-setAndPersistDeviceName-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/accounts/SyncSettings;-onStart-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/BaseRawContactEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompatJellyBean$AccessibilityNodeInfoBridge;-createAccessibilityNodeInfo-(I)Ljava/lang/Object;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-switchUser-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-removeService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumPage;-access$1200-(Lcom/android/gallery3d/app/AlbumPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/GeolocationService;-start-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AudioService;-dispatchMediaKeyEventForCalls-(Landroid/view/KeyEvent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerOnePane;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClientClassicExt;-doUpdateVisitedHistory-(Landroid/webkit/WebView; Ljava/lang/String; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/data/WorkingMessage;-send-(Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/PhoneUi;-showNavScreen-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Controller$Download;-saveDataUri-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeUtil;-getDisabledSystemIMEs-(Landroid/content/ContentResolver;)Ljava/util/HashSet;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DateTimeSettings;-is24Hour-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-bindEditorsForNewContact-(Lcom/android/contacts/common/model/account/AccountWithDataSet; Lcom/android/contacts/common/model/account/AccountType;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/vcard/VCardParser_V40;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cat/CatService;-handleRilMsg-(Lcom/android/internal/telephony/cat/RilMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-determineScrollingStart-(Landroid/view/MotionEvent; F)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine$Disconnected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/AddAccountSettings;-addAccount-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-addIncludedService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/PieController;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/Switch;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth;-fetchRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestionsExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-loadCallHistoryList-(I)Ljava/util/ArrayList;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/providers/applications/ApplicationsProvider$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onRegistrationFailed-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onPictureCenter-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hfp/HeadsetService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/widget/Button;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setSafeMode-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/dialer/dialpad/DialpadFragment;-fillDigitsIfNecessary-(Landroid/content/Intent;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetupCall-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/Tab$2;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/InCallScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readConfigurationForUserStateLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startRepeatKey-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/vcard/VCardImportExportListener;-onImportCanceled-(Lcom/android/contacts/common/vcard/ImportRequest; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/VoicemailCleanupService;-onHandleIntent-(Landroid/content/Intent;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserStop-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$NotificationStationActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/PhotoModule;-access$1300-(Lcom/android/camera/PhotoModule; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/inputmethodservice/KeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MailboxListFragment$FindParentMailboxTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onPageBeginMoving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DevelopmentSettings$ConfirmEnforceFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_EXTERNAL_STORAGE', 'android.permission.READ_PROFILE'],
	'Lcom/android/dialer/calllog/CallLogQueryHandler;-fetchVoicemailStatus-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager; Lcom/android/server/ConnectivityService$NetworkFactory;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MailboxFinder$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onActivityResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/AddressTextView;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasOutboxService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DevicePolicyManagerService;-updatePasswordExpirationsLocked-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setNotification-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/policy/Clock;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dialer/calllog/CallLogFragment;-setMenuVisibility-(Z)V' : ['android.permission.WRITE_CALL_LOG', 'android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/PhotoPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBondState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ui/CameraSwitcher;-onCameraSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiController$NoLockHeldState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/list/ContactListFilterControllerImpl;-setContactListFilter-(Lcom/android/contacts/common/list/ContactListFilter; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DevelopmentSettings;-resetDangerousOptions-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.READ_EXTERNAL_STORAGE'],
	'Landroid/widget/ToggleButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2900-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/IConnectivityManager$Stub;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/dialer/calllog/DefaultVoicemailNotifier$DefaultNameLookupQuery;-query-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/service/AccountService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/LatinIME$BatchInputUpdater;-getSuggestedWordsGestureLocked-(Lcom/android/inputmethod/latin/InputPointers;)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/base/FrameFetch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityInputFilter;-processBatchedEvents-(J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPage-(I I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/common/ContactPhotoManagerImpl$LoaderThread;-queryPhotosForPreload-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/backup/IRestoreSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PanoramaModule;-onResumeAfterSuper-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/PowerManagerService;-handleSandman-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentialsAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/dialer/dialpad/DialpadFragment;-initializeSmartDialingState-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/timezonepicker/TimeZoneInfo;-getGmtDisplayName-(Landroid/content/Context;)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/ScreensaverActivity;-layoutClockSaver-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-startActivityDismissingKeyguard-(Landroid/content/Intent; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/UIControllerOnePane;-switchAccount-(J Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$1;-onKeyguardVisibilityChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/DateTimeSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/AccessibleTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/MessagingController$11;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-isValidWord-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiService;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-animateCollapsePanels-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/TabControl;-createNewWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-init-(Landroid/content/Context;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothServerSocket;-<init>-(I Z Z I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-sendVcardListingXml-(I Ljavax/obex/Operation; I I Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/BluetoothGattServer;-removeService-(Landroid/bluetooth/BluetoothGattService;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/DevicePolicyManagerService;-isActivePasswordSufficient-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothEnabler;-<init>-(Landroid/content/Context; Landroid/widget/Switch;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-access$1100-(Lcom/android/server/location/GpsLocationProvider; I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-onDataSetChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/policy/Clock;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/VolumePanel;-onShowVolumeChanged-(I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-isLocationProviderEnabledForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/Notifier;-onWakeUpStarted-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-setKeyboardMode-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/pm/PackageManagerService;-deletePackageLI-(Ljava/lang/String; Landroid/os/UserHandle; Z [I [Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/File; Ljava/nio/charset/Charset;)V' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-generateBinaryDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readTouchExplorationGrantedAccessibilityServicesLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/NonPhoneActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Disconnected;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/graphics/Bitmap; I I Lcom/android/launcher2/DragSource; Ljava/lang/Object; I Landroid/graphics/Point; Landroid/graphics/Rect; F)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/month/MonthByWeekAdapter$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager;-isAdminActive-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/ISipService$Stub;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-renderChild-(Lcom/android/gallery3d/glrenderer/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/StateManager;-switchState-(Lcom/android/gallery3d/app/ActivityState; Ljava/lang/Class; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaListView;-goTo-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-doQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-processMsg-(Landroid/os/Message;)Lcom/android/internal/util/State;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/ContactsProvider2;-queryLocal-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; J Landroid/os/CancellationSignal;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/detail/ContactDetailFragment$MakeLocalCopyQuickFix;-execute-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/RecognitionManagerService$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-addPreferencesForActivity-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/IGeofenceHardware$Stub;-pauseGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator$1;-onPhoneStateChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-writeDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/MessagingNotification;-getDownloadFailedMessageCount-(Landroid/content/Context;)I' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateCurrentCarrierInProvider-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/wallpaper/RenderScriptWallpaper$RenderScriptEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView;-onWindowFocusChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/dreams/phototable/LocalSource;-fillQueue-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$400-(Lcom/android/mms/ui/ComposeMessageActivity;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/recent/RecentsPanelView;-dismissAndGoBack-()V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService$8;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/location/fused/FusionEngine;-<init>-(Landroid/content/Context; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/util/AccountPromptUtils;-launchAccountPrompt-(Landroid/app/Activity;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-userActivityFromNative-(J I I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/DevicePolicyManagerService;-setPasswordMinimumSymbols-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/FilterGraphEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadsetPhone$Stub;-processChld-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DateTimeSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/google/common/io/CharStreams$2;-getInput-()Ljava/io/InputStreamReader;' : ['android.permission.INTERNET'],
	'Lcom/android/server/am/ActivityManagerService$10;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-findClockInHierarchy-(Landroid/view/View;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothSocket;-bindListen-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/ConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/PostalAddressPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Ljava/lang/Appendable;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-loadInputMethodAndSubtypeHistoryLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/list/ProfileAndContactsLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/DragController;-onAppsRemoved-(Ljava/util/ArrayList; Landroid/content/Context;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebIconDatabaseClassic;-removeAllIcons-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/ConnectivityService;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onCreate-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Ljava/util/Map; Z)V' : ['android.permission.READ_PROFILE', 'android.permission.INTERNET'],
	'Lcom/android/settings/MasterClear;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothAdapter;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/power/PowerManagerService;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub$Proxy;-sendMessageStatus-(J Ljava/lang/String; I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$800-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-beginReliableWrite-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/admin/DevicePolicyManager;-getCameraDisabled-(Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoSource;-findImages-(I)Ljava/util/Collection;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/LoadingListener;-onLoadingFinished-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/StrokedTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/vcard/ExportProcessor;-doFinishNotification-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/AlertService;-postNotification-(Lcom/android/calendar/alerts/AlertService$NotificationInfo; Ljava/lang/String; Landroid/content/Context; Z Lcom/android/calendar/alerts/AlertService$NotificationPrefs; Lcom/android/calendar/alerts/NotificationMgr; I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z)J' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/Controller$15$1;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/model/RawContactDeltaList;-indexOfFirstWritableRawContact-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/gatt/GattService;-endReliableWrite-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.DISABLE_KEYGUARD', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-adjustOtherHeadsetPriorities-(Lcom/android/bluetooth/hfp/HeadsetService; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/hardware/location/GeofenceHardware;-addGeofence-(I I Landroid/hardware/location/GeofenceHardwareRequest; Landroid/hardware/location/GeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactSaveService$2;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/applications/InstalledAppDetails;-initDataButtons-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onPause-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/util/Recycler$SmsRecycler;-dumpMessage-(Landroid/database/Cursor; Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onScreenTurnedOff-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onFinishAction-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceResumeStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-getAudioSessionId-()I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/DragController;-onDeferredEndFling-(Lcom/android/launcher2/DropTarget$DragObject;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-requestUpdateBluetoothIndication-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/Utils;-setTimeZone-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/accounts/AccountManagerService$TestFeaturesSession;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/content/ContentService;-getSyncManager-()Lcom/android/server/content/SyncManager;' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IRingtonePlayer$Stub;-stop-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/server/location/GeofenceManager;-getFreshLocationLocked-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeech;-isLanguageAvailable-(Ljava/util/Locale;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiService;-reconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Contacts$Settings;-getSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/view/IWindowSession;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordMinimumNonLetter-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/VideoModule;-onCameraPickerClicked-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-startScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/SelectionManager;-getSelected-(Z)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$6;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/widget/CheckBox;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isBusy-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performAuditoryFeedbackForAccessibilityIfNeed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation$2;-run-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/inputmethod/InputMethodManager;-getEnabledInputMethodSubtypeList-(Landroid/view/inputmethod/InputMethodInfo; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiNotificationController;-setNotificationVisible-(Z I Z I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CalendarView;-goTo-(Ljava/util/Calendar; Z Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlideshowView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-executeAndWait-(Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-drawTopPanel-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$1700-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/polarclock/PolarClockWallpaper$ClockEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getRemoveWarning-(Landroid/content/ComponentName; Landroid/os/RemoteCallback; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/CalculatorEditText;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-onEndBatchInput-(Lcom/android/inputmethod/latin/InputPointers;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/phone/PhoneUtils;-restoreMuteState-()Ljava/lang/Boolean;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-endReliableWrite-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/group/GroupBrowseListFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setName-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/preference/VolumePreference;-onSampleStarting-(Landroid/preference/VolumePreference$SeekBarVolumizer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onMuteClick-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readDisplayMagnificationEnabledSettingLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-getEnabledInputMethodSubtypeList-(Landroid/view/inputmethod/InputMethodInfo; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getPhotoPickSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/phone/NotificationMgr;-updateCfi-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/OnAlarmListener;-onAlarm-(Lcom/android/launcher2/Alarm;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-showPhonebookDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumPage$4;-onLongTap-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/filtershow/ui/FilterIconButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService;-onInputDeviceChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/providers/downloads/DownloadThread;-transferData-(Lcom/android/providers/downloads/DownloadThread$State; Ljava/net/HttpURLConnection;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-animateChallengeTo-(I I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/filtershow/ui/IconButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothAdapter;-getConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/app/admin/DevicePolicyManager;-setPasswordMinimumNumeric-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/SecureAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageFileViewFragment;-access$1900-(Lcom/android/email/activity/MessageViewFragmentBase; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/MoviePlayer;-access$800-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/SlotView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/SearchActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/ui/ConversationListItem;-updateFromView-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SubSettings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/users/UserSettings;-access$1800-(Lcom/android/settings/users/UserSettings;)Landroid/content/pm/UserInfo;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumNumeric-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/tv/TvStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/updates/IntentFirewallInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-getInitialTransportState-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/voicedialer/RecognizerClient;-onMicrophoneStart-(Ljava/io/InputStream;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/research/Uploader;-isConvenientToUpload-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/photos/shims/MediaItemsLoader;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/common/vcard/SelectAccountActivity;-onCreateDialog-(I Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/Alarms;-formatTime-(Landroid/content/Context; Ljava/util/Calendar;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/SuggestedMemberListAdapter$SuggestedMemberFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/activities/PeopleActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryFacilityLock-(Ljava/lang/String; Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/list/ContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/SmsUsageMonitor;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/providers/downloads/DownloadReceiver$1;-run-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/email/SingleRunningTask;-run-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onBtClassChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/UIControllerTwoPane$ActionBarControllerCallback;-onAccountSelected-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/common/list/ContactListAdapter;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onRoamingOff-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactBrowseListFragment$ContactLookupTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/FdnSetting;-updatePINChangeState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/BondStateMachine$StableState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/tts/TextToSpeech$8;-run-(Landroid/speech/tts/ITextToSpeechService;)Ljava/util/Locale;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService;-connectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/Vibrator;-vibrate-(I Ljava/lang/String; [J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/UsageStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEvent-(I I J Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/quicksearchbox/util/JavaNetHttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$000-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelLocked-(Landroid/os/Parcel; Z I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-setUsbTethering-(Z)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/Button;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/input/InputManagerService;-updatePointerSpeedFromSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/MailboxListFragment$FindParentMailboxTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DisplaySettings$1;-onChange-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-deleteSystemPackageLI-(Lcom/android/server/pm/PackageSetting; [I [Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/widget/LockPatternView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/ComprehensiveCountryDetector$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/updates/TZInfoInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/MasterClear;-establishInitialState-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndHolding-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/dialer/dialpad/SmartDialCache$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/util/ContactBadgeUtil;-getSocialDate-(Lcom/android/contacts/util/StreamItemEntry; Landroid/content/Context;)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-writeSms-(I [B [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/net/NetworkStatsService;-access$1100-(Lcom/android/server/net/NetworkStatsService; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createView-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/DragState;-endDragLw-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/AccessibilitySettings$ToggleSwitch;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupActivity;-isThisImeCurrent-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringLogger;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionCallReceiverImpl;-access$1600-(Lcom/android/server/sip/SipSessionGroup$SipSessionImpl; Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/videosrc/MediaSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/common/contacts/DataUsageStatUpdater;-updateWithRfc822Address-(Ljava/util/Collection;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel;-addBrightnessTile-(Lcom/android/systemui/statusbar/phone/QuickSettingsTileView; Lcom/android/systemui/statusbar/phone/QuickSettingsModel$RefreshCallback;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavigationBarPhone;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-handleNest-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$4300-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccount-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-setNextDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/backup/IObbBackupService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetoothManager;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getReportItems-()Ljava/util/List;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothHealth$Stub$Proxy;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-onConnect-(Lcom/android/internal/telephony/dataconnection/DataConnection$ConnectionParams;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/CarrierLabel;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/WebViewController;-doUpdateVisitedHistory-(Lcom/android/browser/Tab; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfile;-getConnectionStatus-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onContactUriQueryFinished-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine;-access$16800-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager;-getStorageEncryption-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/settings/SettingsProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/location/provider/LocationProviderBase;-reportLocation-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy;-finishPostLayoutPolicyLw-()I' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/DhcpStateMachine$RunningState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/Alarms;-addAlarm-(Landroid/content/Context; Lcom/android/deskclock/Alarm;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/cdma/CdmaCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/TrimVideo;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LockSettingsService;-checkReadPermission-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$InactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/WallpaperTypeSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-initLoader-(Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-removeActiveAdmin-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ComposeMessageActivity$42;-onContentChanged-(Lcom/android/mms/ui/MessageListAdapter;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5000-(Lcom/android/mms/ui/ComposeMessageActivity;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-assignContactFromPhone-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-getMyEnabledInputMethodSubtypeList-(Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-clientDisconnect-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ConfirmDialogListener;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/ContactsContract$RawContacts$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/SmsStorageMonitor$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DevicePolicyManagerService;-setPasswordMinimumUpperCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/Context;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/AccessibilityInjector;-toggleFallbackAccessibilityInjector-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$HoneycombMR2ConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MailboxFinder$ControllerResults;-serviceCheckMailCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-configureQuickFix-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ActivityManagerNative;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary$AppDetailsFragment;-onStop-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/util/DownloadManager;-markState-(Landroid/net/Uri; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/accounts/SyncSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StopTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/vpn2/VpnSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-setCurrentPhotoByIntent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToRuim-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/dialer/dialpad/DialpadFragment;-keyPressed-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-enqueue-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/input/InputManagerService;-getShowTouchesSetting-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-addWordToUserDictionary-(Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterpacks/imageproc/BlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService$WindowManagerFuncs;-requestTraversal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startPhotoQuery-(J Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/ScreenNail;-draw-(Lcom/android/gallery3d/glrenderer/GLCanvas; I I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-hasMultipleEnabledIMEsOrSubtypes-(Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-showConnectionDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/photos/shims/MediaItemsLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/WallpaperManager;-clear-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothA2dp;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ConfirmLockPassword$ConfirmLockPasswordFragment;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ex/chips/RecipientEditTextView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/settings/SettingsUI;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallTouchUi$2;-onAnimationStart-(Landroid/animation/Animator;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserSwitch-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/downloads/DownloadReceiver;-access$000-(Lcom/android/providers/downloads/DownloadReceiver; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getContactUriForEmail-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/widget/DigitalClock;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onPause-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onRadioAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame$1;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage$SaveBookmarkRunnable;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/InputMethodManagerService;-access$1100-(Lcom/android/server/InputMethodManagerService;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$OnTimeSetListener;-onTimeSet-(Lcom/android/datetimepicker/time/RadialPickerLayout; I I)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/dialer/calllog/CallLogAdapter$CallFetcher;-fetchCalls-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/wifi/WifiNotificationController;-<init>-(Landroid/content/Context; Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BatteryService;-<init>-(Landroid/content/Context; Lcom/android/server/LightsService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Tab;-postCapture-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/dialer/CallDetailActivity$1UpdateContactDetailsTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-endReordering-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/TrafficStats;-stopDataProfiling-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/AudioService;-access$3100-(Landroid/media/AudioService; Landroid/os/Handler; I I I Ljava/lang/Object; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/updates/TZInfoInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAccountView;-onFinishInflate-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onRegistering-(Landroid/net/sip/ISipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onClicked-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView;-onCodeInput-(I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/SecureCameraActivity;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-access$000-(Lcom/android/contacts/activities/AttachPhotoActivity; Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/editor/EventFieldEditorView;-createDatePickerDialog-()Landroid/app/Dialog;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/model/ContactLoader;-loadInvitableAccountTypes-(Lcom/android/contacts/model/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-switchToState-(I F F)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-replaceSystemPackageLI-(Landroid/content/pm/PackageParser$Package; Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; [I [Z Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onActivityStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$5;-run-()V' : ['android.permission.REORDER_TASKS'],
	'Landroid/media/AudioService;-readPersistedSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;-maybeStartBiometricUnlock-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/view/IWindowSession$Stub;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/contacts/editor/LabeledEditorView;-onOptionalFieldVisibilityChange-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-startDataStallAlarm-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexServerSession;-onPut-(Ljavax/obex/Operation;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getVoiceRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/model/account/AccountTypeWithDataSet;-hasData-(Landroid/content/Context;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/common/list/CustomContactListFilterActivity$GroupDelta;-fromSettings-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Lcom/android/contacts/common/list/CustomContactListFilterActivity$GroupDelta;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService;-updateUserActivitySummaryLocked-(J I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/NotificationPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditText;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/Contact;-getPhoneUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/Utils;-getWeekNumberFromTime-(J Landroid/content/Context;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-stopScan-(I Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/research/ResearchLogger$6;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-notifySignalStrength-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/StateManager;-itemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/preference/ContactsPreferences;-getDisplayOrder-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/vpn2/VpnSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-createContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeech;-synthesizeToFile-(Ljava/lang/String; Ljava/util/HashMap; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-startTone-(C Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/MediaFormat$2;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/GroupEditorActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Ljava/net/HttpURLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/common/list/ContactListFilterControllerImpl;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/alarmclock/DigitalAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/WorkingMessage$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/speech/tts/TextToSpeechService$1;-speak-(Landroid/os/IBinder; Ljava/lang/String; I Landroid/os/Bundle;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/wifi/p2p/WifiP2pSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/ActionBarController$2;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/coremedia/iso/IsoFile;-createBoxParser-()Lcom/coremedia/iso/BoxParser;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/SmsUsageMonitor$SettingsObserverHandler;-<init>-(Landroid/content/Context; Ljava/util/concurrent/atomic/AtomicBoolean;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/text/ToUpperCase;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/bluetooth/PbapServerProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MailboxFinder$FindMailboxTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getBondedDevices-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/common/list/AccountFilterActivity;-access$100-(Landroid/content/Context;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DatePicker;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/EmailServiceUtils;-isExchangeAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService;-sendDisableMsg-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-startDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService$4;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-updateImplicitlyEnabledSubtypes-(Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-selectFirstFoundContactAfterDelay-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/HTML5Audio;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/widget/MmsWidgetService$MmsFactory;-queryUnreadCount-()I' : ['android.permission.READ_SMS'],
	'Lcom/android/dreams/phototable/PicasaSource;-getStream-(Lcom/android/dreams/phototable/PhotoSource$ImageData; I)Ljava/io/InputStream;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/mail/store/ExchangeStore;-checkSettings-()Landroid/os/Bundle;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-isKeyguardSecure-()Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/deviceinfo/Status;-setWifiStatus-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-initPreferences-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneGlobals;-updateInCallScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/DayFragment;-makeView-()Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-resetContactsDictionary-(Lcom/android/inputmethod/latin/ContactsBinaryDictionary;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-processSlidingKeyInput-(Lcom/android/inputmethod/keyboard/Key; I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/LatinIME$BatchInputUpdater;-onEndBatchInput-(Lcom/android/inputmethod/latin/InputPointers;)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/VibratorService;-doCancelVibrateLocked-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/content/SyncManager$SyncHandler;-scheduleReadyPeriodicSyncs-()J' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/ex/editstyledtext/EditStyledText;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/AlertActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothAdapter;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleModeChange-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/UrlHandler$RLZTask;-onPostExecute-(Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/timer/TimerReceiver;-showCollapsedNotification-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I Landroid/app/PendingIntent; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-stopScanning-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-applyPostLayoutPolicyLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManager$LayoutParams;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/GeolocationService;-registerForLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/InCallScreen;-access$1100-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/accounts/AccountManager$2;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasAccountService;-postAutodiscover-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-getBrightnessMode-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$4600-(Lcom/android/mms/ui/ComposeMessageActivity; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/sip/SipSessionGroup;-processIOException-(Ljavax/sip/IOExceptionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$7300-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/ServiceWatcher$2;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowManager$Stub;-setOverscan-(I I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub$Proxy;-startFreezingScreen-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/common/list/DefaultContactListAdapter;-bindQuickContact-(Lcom/android/contacts/common/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService;-updateSettingsLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-cleanup-()Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOffUpstreamMobileConnection-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5500-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/dialer/voicemail/VoicemailPlaybackPresenter;-access$700-(Lcom/android/dialer/voicemail/VoicemailPlaybackPresenter;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-tryVibrate-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/AudioAndHapticFeedbackManager;-vibrateInternal-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/dialer/calllog/CallLogAdapter;-access$300-(Lcom/android/dialer/calllog/CallLogAdapter; Ljava/lang/String; Ljava/lang/String; Lcom/android/dialer/calllog/ContactInfo;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/media/MediaProvider;-getThumb-(Lcom/android/providers/media/MediaProvider$DatabaseHelper; Landroid/database/sqlite/SQLiteDatabase; Ljava/lang/String; J Landroid/net/Uri;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.READ_EXTERNAL_STORAGE', 'android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/common/contacts/BaseEmailAddressAdapter$DirectoryPartitionFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/provider/DBHelper;-upgradeFromVersion21ToVersion22-(Landroid/database/sqlite/SQLiteDatabase; Landroid/content/Context;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/common/ContactPhotoManagerImpl$LoaderThread;-preloadPhotosInBackground-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/ExchangeService;-startManualSync-(J I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageViewFragmentBase$UpdatePreviewIconTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageFileViewFragment;-onSaveAttachment-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/IAlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-access$700-(Lcom/android/gallery3d/ui/ActionModeHandler; Lcom/android/gallery3d/util/ThreadPool$JobContext; I)Landroid/content/Intent;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSetupExchangeFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$ScreenNailJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onResume-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/dialer/SpecialCharSequenceMgr$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/IBluetoothManager;-unregisterStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/InputStreamSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-waitForKeyguard-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/DevicePolicyManagerService;-access$300-(Lcom/android/server/DevicePolicyManagerService; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onBackPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/media/MediaProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/FaceClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/PhoneUtils;-turnOnSpeaker-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/widget/Switch;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateNextButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-notifyScreenNailChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine;-isWifiTethered-(Ljava/util/ArrayList;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodButton;-needsToShowIMEButton-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService;-isMailboxSyncable-(Lcom/android/emailcommon/provider/Account; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-onResume-()V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$DayAdapterInfo;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/OtaUtils;-otaShowActivateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/PhoneGlobals;-updateBluetoothIndication-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary$ConfirmAutoSyncChangeFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/picasasource/PicasaSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/WorkingMessage;-access$300-(Lcom/android/mms/data/WorkingMessage; Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onBootCompleted-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/ManageConferenceUtils;-separateConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getGroupUriFromId-(J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/dialer/CallDetailActivity$6;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-updateNotification-(Landroid/os/IBinder; Landroid/service/notification/StatusBarNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/ConnectivityService;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/phone/sip/SipEditor;-access$500-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/internal/widget/WaveView;-waveUpdateFrame-(F F Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/list/DirectoryListLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/util/NameConverter;-displayNameToStructuredName-(Landroid/content/Context; Ljava/lang/String;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-updateResources-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeechService;-getSettingsLocale-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pStateChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallHelper;-onServiceStateChanged-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService;-chooseNewDefaultIMELocked-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dialer/CallDetailActivity$6;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-endInCallScreenSession-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/vcard/VCardEntry;-iterateAllData-(Lcom/android/vcard/VCardEntry$EntryElementIterator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/datepicker/DatePickerDialog$OnDateSetListener;-onDateSet-(Lcom/android/contacts/datepicker/DatePicker; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/MultiStateButton;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/FlipEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/VideoModule;-stopVideoRecording-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/LogTextBox;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/camera/VideoUI$3;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/LegacyPhoneNumberPickerFragment;-getPhoneUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/speech/tts/TextToSpeechService;-access$600-(Landroid/speech/tts/TextToSpeechService;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/Phone;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/CountryDetectorService$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/DevicePolicyManager;-getPasswordQuality-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmReceiver;-handleIntent-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/Dictionary;-isValidWord-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/util/HttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/DayView;-access$5100-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-invokeExitMethods-(Lcom/android/internal/util/StateMachine$SmHandler$StateInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/Launcher;-hideAppsCustomizeHelper-(Lcom/android/launcher2/Launcher$State; Z Z Ljava/lang/Runnable;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/Utils$UsabilityStudyLogUtils$2;-run-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/inputmethod/InputMethodPreference;-setChecked-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/UserDictionary$Words;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/calendar/DayFragment;-goTo-(Landroid/text/format/Time; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/transaction/TransactionService;-renewMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/settings/ToggleSlider;-onStopTrackingTouch-(Landroid/widget/SeekBar;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/SlideshowPresenter$5;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageViewFragment;-formatDate-(J Z)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/NumberPicker$AccessibilityNodeProviderImpl;-sendAccessibilityEventForVirtualText-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-startLongPressTimer-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/alarmclock/DigitalWidgetViewsFactory;-refreshAlarm-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/ShutdownThread;-access$000-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/SystemVibrator;-vibrate-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-setGrabbedState-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/EmailServiceProxy$12;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$24;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-setEntityDeltaList-(Lcom/android/contacts/model/RawContactDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/TimerSetupView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/PanProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/SecureCameraActivity;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothGatt;-discoverServices-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Tab$2;-onReceivedLoginRequest-(Landroid/webkit/WebView; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub$Proxy;-getCurrentSpellChecker-(Ljava/lang/String;)Landroid/view/textservice/SpellCheckerInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Connected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-disableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/common/list/ProfileAndContactsLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.USE_SIP'],
	'Lcom/android/internal/os/BatteryStatsImpl;-doPlugLocked-(J J J)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/TimerRingService;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$OngoingGroupRemovalState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityStack;-scheduleIdleLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/widget/CheckedTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/wifi/WifiStatusTest$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordQuality-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/tablet/InputMethodButton;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/ime/Ime;-main-([Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPage;-pickPhoto-(I Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/util/DownloadManager$4;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView;-onChildDismissed-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView;-processMotionEvent-(I I I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/media/NotificationPlayer;-access$800-(Lcom/android/systemui/media/NotificationPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceTransition-(I I D D D F F F J I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/CursorEntityIterator;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/Conversation;-sendReadReport-(Landroid/content/Context; J I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendCallLogVcards-(I Ljavax/obex/Operation; I I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-onScrubbingEnd-(I I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/settings/deviceinfo/Status;-onResume-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-addDescriptor-(I Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/event/EventInterpreter;-onSoftwareEvent-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onSetUserDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/NullFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/admin/DevicePolicyManager;-getPasswordQuality-(Landroid/content/ComponentName;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/os/IPowerManager$Stub;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/BrowserContract$Bookmarks;-buildFolderUri-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/hardware/location/GeofenceHardwareService;-access$200-(Landroid/hardware/location/GeofenceHardwareService; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/BroadcastQueue;-deliverToRegisteredReceiverLocked-(Lcom/android/server/am/BroadcastRecord; Lcom/android/server/am/BroadcastFilter; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onStart-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/content/ContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-makeWifiWatchdogStateMachine-(Landroid/content/Context;)Landroid/net/wifi/WifiWatchdogStateMachine;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/ExchangeService;-sendMessageRequest-(Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/SimFullReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-sendRequest-(I Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$QueryHandler$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserBookmarksPage$OpenAllInTabsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/wm/WindowManagerService;-handleAppTransitionReadyLocked-(Lcom/android/server/wm/WindowList;)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dialer/calllog/CallLogFragment;-callSelectedEntry-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/speech/IRecognitionService$Stub;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/settings/Settings$WifiDisplaySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/AbstractSyncService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/phone/EmergencyCallHelper;-scheduleRetryOrBailOut-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage;-access$1500-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/PhoneInterfaceManager;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/CalendarView;-setDate-(J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/deskclock/DeskClock;-createTabs-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onActionBarAllowed-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/common/vcard/ImportVCardActivity$VCardCacheThread;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/googlecode/mp4parser/authoring/container/mp4/MovieCreator;-build-(Ljava/nio/channels/ReadableByteChannel;)Lcom/googlecode/mp4parser/authoring/Movie;' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity$TestPinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-access$100-(Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-requestSync-(Lcom/android/emailcommon/provider/Mailbox; I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/view/BasePieView;-layout-(I I Z F I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-drawTopPanel-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$InnerTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-onFadeStart-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-update-(Lcom/android/internal/telephony/DriverCall;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-updateNowIfNotUpdatedInAVeryLongTime-(Landroid/content/Context;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/widget/LockPatternUtils;-getSalt-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoCarousel$PhotoLoadTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/dictionarypack/WordListPreference;-access$500-(Lcom/android/inputmethod/dictionarypack/WordListPreference;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getLong-(Ljava/lang/String; J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageItem;-interpretFrom-(Lcom/google/android/mms/pdu/EncodedStringValue; Landroid/net/Uri;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseOneVCard-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-getPersistedScale-()F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/Utils;-formatMonthYear-(Landroid/content/Context; Landroid/text/format/Time;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/preference/DisplayOrderPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/list/ShortcutIntentBuilder$PhoneNumberLoadingAsyncTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/btservice/JniCallbacks;-pinRequestCallback-([B [B I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IActivityManager;-killBackgroundProcesses-(Ljava/lang/String; I)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/browser/TabControl;-restoreState-(Landroid/os/Bundle; J Z Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/inputmethod/SingleSpellCheckerPreference;-onSubtypeButtonClicked-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService$SettingsObserver;-observe-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView$Model;-moveTo-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-access$400-(Lcom/android/bluetooth/opp/BluetoothOppTransfer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/KeyboardLayoutPickerFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/text/format/DateUtils;-formatDateRange-(Landroid/content/Context; Ljava/util/Formatter; J J I)Ljava/util/Formatter;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-buildQueryUri-(I I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/mms/ui/SearchActivity$TextViewSnippet;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/text/method/QwertyKeyListener;-onKeyDown-(Landroid/view/View; Landroid/text/Editable; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardStatusView;-refresh-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/ProfileService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/LocationListener; Landroid/os/Looper; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/google/common/io/Files;-readFirstLine-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/net/wifi/WifiStateMachine$TetheredState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/DragController;-cancelDrag-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/musicvis/RenderScriptWallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/content/ContextWrapper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/PointerSpeedPreference;-access$000-(Lcom/android/settings/PointerSpeedPreference;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumSymbols-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarViewAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService;-registerClient-(Ljava/util/UUID; Landroid/bluetooth/IBluetoothGattCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onStop-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-switchFromFullNameToStructuredName-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager$Stub;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/MediaSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$7;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/contacts/ContactSaveService;-updateGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/LatinIME;-access$200-(Lcom/android/inputmethod/latin/LatinIME;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ManageSimMessages;-init-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/launcher2/LauncherTransitionable;-onLauncherTransitionEnd-(Lcom/android/launcher2/Launcher; Z Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService$ScoClient;-incCount-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub$Proxy;-isRotationFrozen-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DockObserver;-systemReady-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/LocationClustering;-generateName-(Ljava/util/ArrayList; Lcom/android/gallery3d/util/ReverseGeocoder;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/widget/Switch;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setKeyguardDisabledFeatures-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventView;-access$300-(Lcom/android/calendar/event/EditEventView; Landroid/widget/TextView; J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/chips/RecipientEditTextView;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-get-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/ChooseLockPassword$ChooseLockPasswordFragment;-updateStage-(Lcom/android/settings/ChooseLockPassword$ChooseLockPasswordFragment$Stage;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothGatt;-disconnect-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifySendFailed-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/AppsCorpus;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/CorpusResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/RotarySelector;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/AccessibleTabView;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/WorkingMessage;-discard-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/StitchingChangeListener;-onStitchingQueued-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper$RenderScriptEngine;-doVisibilityChanged-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/mms/util/DraftCache;-rebuildCache-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/camera/SecureCameraActivity;-openModule-(Lcom/android/camera/CameraModule; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/detail/ContactLoaderFragment$1;-onLoadFinished-(Landroid/content/Loader; Lcom/android/contacts/model/Contact;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/DevicePolicyManager;-reportSuccessfulPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/PhotoPage;-setCurrentPhotoByIntent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wifi/WifiController;-registerForStayAwakeModeChange-(Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/DisplayPowerController$5;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/service/AccountService$1$1;-run-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/PhoneUtils;-setMuteInternal-(Lcom/android/internal/telephony/Phone; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub$Proxy;-prepareAppTransition-(I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfile;-setPreferred-(Landroid/bluetooth/BluetoothDevice; Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager$Stub;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-setCurrentKey-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumNumeric-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/TelephonyManager;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-enableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryList;-getUserDictionaryLocalesSet-(Landroid/app/Activity;)Ljava/util/TreeSet;' : ['android.permission.READ_USER_DICTIONARY'],
	'Landroid/text/format/DateUtils;-getRelativeTimeSpanString-(J J J I)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$10;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/timezonepicker/TimeZonePickerDialog;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DateTimeSettings;-getDateFormat-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/updates/SELinuxPolicyInstallReceiver;-access$000-(Lcom/android/server/updates/ConfigUpdateInstallReceiver; Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-setCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendDownForAllActiveNotInjectedPointers-(Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DevicePolicyManagerService;-reportSuccessfulPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityCallback;-showBackupSecurity-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-showDetails-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothGatt$1;-onClientRegistered-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-access$300-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/inputmethod/UserDictionaryList;-createUserDictSettings-(Landroid/preference/PreferenceGroup;)V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-initSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/screenshot/SaveImageInBackgroundTask;-<init>-(Landroid/content/Context; Lcom/android/systemui/screenshot/SaveImageInBackgroundData; Landroid/app/NotificationManager; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-killApplication-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/OwnerInfoSettings;-initView-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordExpirationTimeout-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-access$5600-(Landroid/media/AudioService;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/CredentialStorage$UnlockDialog;-onDismiss-(Landroid/content/DialogInterface;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/gallery3d/app/PickerActivity;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea;-update-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/CredentialStorage;-confirmKeyGuard-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$6600-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplaySizeLocked-(Lcom/android/server/wm/DisplayContent; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothGatt;-close-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen$14;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/dialer/dialpad/SmartDialTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/CallNotifier;-showIncomingCall-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/editor/LabeledEditorView;-rebuildValues-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/EmergencyCallHelper;-onDisconnect-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/wifi/WifiService;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/bluetooth/gatt/GattService;-addCharacteristic-(I Ljava/util/UUID; I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setCameraDisabled-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/AddBookmarkPage;-setupTopCrumb-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-enforcePreference-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-refreshWifiInfo-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-access$200-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/text/format/DateFormat;-getDateFormat-(Landroid/content/Context;)Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$HandshakeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaSystemSelectListPreference$MyHandler;-handleSetCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onWindowFocusChanged-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/util/IState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-parse-(Ljava/io/InputStream;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-handleConnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter$EasEmailSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/alarmclock/DigitalAppWidgetProvider;-onAppWidgetOptionsChanged-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;-access$200-(Lcom/android/internal/policy/impl/keyguard/KeyguardFaceUnlockView;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmAlert;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiService;-startScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/dreams/phototable/PicasaSource;-load-(Lcom/android/dreams/phototable/PhotoSource$ImageData; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/event/CreateEventDialogFragment$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$AppOpsSummaryActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$9;-onAnimationStart-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AccessibilitySettings;-handleDisplayMagnificationPreferenceScreenClick-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$3;-onTick-(J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-bindQuickContact-(Lcom/android/contacts/common/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-unregisterServer-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DevelopmentSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/systemui/statusbar/policy/Clock;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/camera/ui/PieRenderer$3;-onAnimationEnd-(Landroid/view/animation/Animation;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForSettingsChanges-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/SetAlarm;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup;-processTransactionTerminated-(Ljavax/sip/TransactionTerminatedEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WpsDialog$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-asyncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/UIControllerOnePane;-onRefresh-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/CertBlacklister;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onSurfaceRedrawNeeded-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-reloadUiFromMessage-(Lcom/android/emailcommon/provider/EmailContent$Message; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/effect/effects/VignetteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/DevicePolicyManagerService;-getUserData-(I)Lcom/android/server/DevicePolicyManagerService$DevicePolicyData;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$2400-(Lcom/android/bluetooth/hfp/HeadsetStateMachine;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/app/admin/IDevicePolicyManager;-setCameraDisabled-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardAbsKeyInputView;-onWindowFocusChanged-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$QuickResponseChecker;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/VideoView;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/DevicePolicyManagerService;-getPasswordExpiration-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IApplicationToken$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/systemui/media/NotificationPlayer;-startSound-(Lcom/android/systemui/media/NotificationPlayer$Command;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri; Z Z Z Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/WiredAccessoryManager;-bootCompleted-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$AudioHandler$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/GroupMessagingListener;-synchronizeMailboxFailed-(J J Ljava/lang/Exception;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGatt;-unregisterClient-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub;-getProviderProperties-(Ljava/lang/String;)Lcom/android/internal/location/ProviderProperties;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmClock$AlarmItemAdapter;-getRingToneTitle-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/RIL;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-access$1700-(Landroid/speech/tts/TextToSpeech;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/location/provider/LocationProviderBase;-onDisable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserSettings;-clearHistory-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/downloads/DownloadProvider;-checkInsertPermissions-(Landroid/content/ContentValues;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/Settings$VpnSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/widget/TextClock$1;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/browser/WebViewController;-showSslCertificateOnError-(Landroid/webkit/WebView; Landroid/webkit/SslErrorHandler; Landroid/net/http/SslError;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/textservice/ITextServicesManager;-getCurrentSpellCheckerSubtype-(Ljava/lang/String; Z)Landroid/view/textservice/SpellCheckerSubtype;' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$Secure;-getLong-(Landroid/content/ContentResolver; Ljava/lang/String;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/media/MediaScannerService;-access$100-(Lcom/android/providers/media/MediaScannerService; Ljava/lang/String; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService;-acquireWakeLock-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MusicPicker;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeech;-setLanguage-(Ljava/util/Locale;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-setFrequencyBand-(I Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/BackupManagerService$FullBackupObbConnection;-restoreObbFile-(Ljava/lang/String; Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/MasterClear;-runKeyguardConfirmation-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/util/DownloadManager;-getMessage-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$Helper;-setMessage-(I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onAttachedToWindow-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$1;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-processDtmf-(C)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-commandsParser-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/MessageListFragment;-access$2200-(Lcom/android/email/activity/MessageListFragment;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/SystemFacade;-isNetworkRoaming-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-startDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/PostalAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/gadget/MediaSetSource;-<init>-(Lcom/android/gallery3d/data/DataManager; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-access$400-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/LockPatternUtils;-isPatternEverChosen-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-handleMediaKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/DataManager;-onStitchingResult-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmInitReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/camera/SwitchAnimManager;-drawAnimation-(Lcom/android/gallery3d/glrenderer/GLCanvas; I I I I Lcom/android/camera/CameraScreenNail; Lcom/android/gallery3d/glrenderer/RawTexture;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/SplitAggregateView;-<init>-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-updateProgressbar-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$2;-onSimStateChanged-(Lcom/android/internal/telephony/IccCardConstants$State;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-createContact-(Lcom/android/contacts/common/model/account/AccountWithDataSet;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/research/ResearchLogger;-initSuggest-(Lcom/android/inputmethod/latin/Suggest;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/LocationManagerService;-getReceiverLocked-(Landroid/location/ILocationListener; I I Ljava/lang/String;)Lcom/android/server/LocationManagerService$Receiver;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/ResearchLogger;-onUserLoggingConsent-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/SupplicantStateTracker$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/wm/Session; Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/VibratorService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasOutboxService;-acknowledgeProvisionImpl-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-querySoundEffectsEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/fuelgauge/PowerUsageDetail;-checkForceStop-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onGenericMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/View;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/SlideshowAttachmentView;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-setCurrentView-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-createAccessibilityNodeInfo-(I)Landroid/support/v4/view/accessibility/AccessibilityNodeInfoCompat;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onDialerClose-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleInCallMmiCommands-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LocationManagerService;-removeUpdates-(Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/common/editor/SelectAccountDialogFragment$Listener;-onAccountChosen-(Lcom/android/contacts/common/model/account/AccountWithDataSet; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ContextImpl;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onDeleteImage-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/backup/IObbBackupService$Stub$Proxy;-backupObbs-(Ljava/lang/String; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-acquireAggregationSuggestions-(Landroid/content/Context; Lcom/android/contacts/editor/RawContactEditorView;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneProxy;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/common/list/PhoneNumberPickerFragment;-loadPreferences-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/RuimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getProfileProxy-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onPressKey-(I Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onResume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-setAddWidgetEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-cancelDiscovery-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/DevicePolicyManagerService;-getRemoveWarning-(Landroid/content/ComponentName; Landroid/os/RemoteCallback; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-handleHide-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/NumberPicker$CustomEditText;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/RecognitionService;-checkPermissions-(Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/systemui/media/NotificationPlayer$CmdThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-snapToPage-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/AccessibilityInjectorFallback;-ensureWebContentKeyBindings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/monkey/MonkeyNetworkMonitor;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/ConnectivityManager;-isActiveNetworkMetered-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pan/PanService;-enableTethering-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-readCharacteristic-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onStart-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/NsdService$NsdStateMachine;-<init>-(Lcom/android/server/NsdService; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Ljava/net/URL;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothPan;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BatteryService;-updateLocked-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/ControllerResultUiThreadWrapper$4;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/AccessibilitySettings$2;-register-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordContents;-delete-(Landroid/content/Context;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/gallery3d/ui/PhotoView;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/event/EditEventHelper;-saveRemindersWithBackRef-(Ljava/util/ArrayList; I Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumPage;-doCluster-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-access$2400-(Lcom/android/gallery3d/app/PhotoPage; Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/Conversation;-access$300-(Lcom/android/mms/data/Conversation; Landroid/content/Context; J I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/event/EditEventFragment;-access$800-(Lcom/android/calendar/event/EditEventFragment; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-beginBackup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/effect/effects/StraightenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onSetInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/AddBookmarkPage;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/calendar/CalendarReceiver;-removeScheduledAlarms-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/MessageUtils;-handleReadReport-(Landroid/content/Context; Ljava/util/Collection; I Ljava/lang/Runnable;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStoppingState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onMenuClicked-(Landroid/view/MenuItem; Ljava/lang/String; Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/NegativeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/OtherPreferences;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary;-isMobilePolicySplit-()Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerBase;-updateMessageOrderManager-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-dispatchDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-onScreenTurnedOn-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-addNmeaListener-(Landroid/location/GpsStatus$NmeaListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/editor/Editor;-setValues-(Lcom/android/contacts/common/model/dataitem/DataKind; Lcom/android/contacts/common/model/ValuesDelta; Lcom/android/contacts/model/RawContactDelta; Z Lcom/android/contacts/editor/ViewIdGenerator;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onLoadComplete-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-eventsChanged-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/webkit/AccessibilityInjector;-addTtsApis-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordHistoryLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/ClockView;-access$200-(Lcom/android/internal/policy/impl/keyguard/ClockView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler$PhotoListener;-onUseAsPrimaryChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/dialer/list/PhoneFavoriteFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/photos/shims/MediaSetLoader;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getOperator-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/BrightnessEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/RotationPolicy;-isRotationLocked-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/SmsUsageMonitor;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/display/DisplayManagerService;-setWindowManager-(Lcom/android/server/display/DisplayManagerService$WindowManagerFuncs;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumLowerCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-<init>-(Landroid/content/Context; Ljava/util/HashMap; Landroid/os/Handler;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/RadioInfo;-updateCellInfoListRate-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wifi/WifiService;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogDisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserBookmarksPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/ConnectivityManager;-startUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetoothPan;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/gatt/GattService;-sendNotification-(I Ljava/lang/String; I I Ljava/util/UUID; I Ljava/util/UUID; Z [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/location/GeofenceManager;-updateFences-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/GLRootView;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/PeopleActivity$ContactBrowserActionListener;-onFinishAction-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/view/WindowManagerPolicy;-isKeyguardSecure-()Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-access$100-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/CoreSettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getRemoteType-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/data/WorkingMessage;-sendMmsWorker-(Lcom/android/mms/data/Conversation; Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/service/dreams/Sandman;-isScreenSaverActivatedOnDock-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-handleCarrierInfoUpdate-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallCard;-displaySecondaryCallStatus-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-registerStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/location/ILocationManager$Stub;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.INTERNET'],
	'Landroid/net/sip/SipManager;-getSessionFor-(Landroid/content/Intent;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/calendar/agenda/AgendaFragment;-goTo-(Lcom/android/calendar/CalendarController$EventInfo; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterfw/core/SyncRunner;-step-()I' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/DreamSettings;-createWhenToDreamDialog-()Landroid/app/Dialog;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/UiccCard;-update-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/uicc/IccCardStatus;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoModule;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine;-access$22400-(Landroid/net/wifi/WifiStateMachine; Ljava/util/ArrayList;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-access$2400-(Lcom/android/gallery3d/app/PhotoPage; Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/PhoneGlobals;-access$900-(Lcom/android/phone/PhoneGlobals; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/TransactionService;-endMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-lockNow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-checkManageAccountsPermission-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$18;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-setValues-(Lcom/android/contacts/common/model/dataitem/DataKind; Lcom/android/contacts/common/model/ValuesDelta; Lcom/android/contacts/model/RawContactDelta; Z Lcom/android/contacts/editor/ViewIdGenerator;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/common/vcard/ImportProcessor;-readOneVCard-(Ljava/io/InputStream; I Ljava/lang/String; Lcom/android/vcard/VCardInterpreter; [I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/content/ContentService;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/DigitalClock;-initClock-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/TrafficStats;-getDataLayerSnapshotForUid-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/ui/Switch;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/LocationManagerService$Receiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-queueMsgUnderWakeLock-(Landroid/os/Handler; I I I Ljava/lang/Object; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DeviceInfoSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-cancelMmiCode-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DatePicker;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/tools/BitmapTask$Callbacks;-onExecute-(Ljava/lang/Object;)Landroid/graphics/Bitmap;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/Tab$3;-access$1700-(Lcom/android/browser/Tab$3; Z Landroid/os/Message;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-showChallenge-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/VolumePanel;-onVolumeChanged-(I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-endServiceDeclaration-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarProvider2;-verifyAccounts-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/dialer/voicemail/VoicemailPlaybackPresenter$PlaybackPositionListener;-onStopTrackingTouch-(Landroid/widget/SeekBar;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel;-updateResources-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/DeskClock$TabsAdapter;-registerPageChangedListener-(Lcom/android/deskclock/DeskClockFragment;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadBodyTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendEmergencyCallbackModeChange-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiSettings;-handleEvent-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$2500-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Utils;-getWifiIpAddresses-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/wifi/WifiApEnabler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterfw/core/FilterGraph;-closeFilters-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText$1;-onDevicePolicyManagerStateChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-systemReady-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/data/Conversation$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/widget/DateTimeView;-getDateFormat-()Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-sendResponse-(I Ljava/lang/String; I I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/location/ILocationProvider$Stub$Proxy;-disable-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageViewFragmentBase$1;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-doVisibilityChanged-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/CountdownTimerPopup;-updateInputState-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityRecord;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/launcher2/Launcher;-showAppsCustomizeHelper-(Z Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wifi/WifiService;-getDhcpInfo-()Landroid/net/DhcpInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-isDismissable-()Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/research/Uploader;-uploadFile-(Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Landroid/inputmethodservice/KeyboardView;-access$400-(Landroid/inputmethodservice/KeyboardView; Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-removeAllDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/vcard/VCardParser;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/dialer/calllog/CallLogFragment;-unregisterPhoneCallReceiver-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/users/UserSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/base/InputStreamSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/CameraActivity;-reuseCameraScreenNail-(Z)Lcom/android/gallery3d/ui/ScreenNail;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/voicedialer/VoiceDialerActivity$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary;-updatePolicy-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/AudioAttachmentView;-access$000-(Lcom/android/mms/ui/AudioAttachmentView;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoSource;-<init>-(Landroid/content/Context; Landroid/content/SharedPreferences;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/ComboAlbum;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/common/widget/CompositeCursorAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/alerts/AlertActivity;-dismissAlarm-(J J J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-onScrubbingStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-populateDayInfo-(I Landroid/text/format/Time;)Lcom/android/calendar/widget/CalendarAppWidgetModel$DayInfo;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/adapter/ItemOperationsParser;-parseResponse-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowSession$Stub$Proxy;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel$BrightnessObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/preferences/BandwidthPreferencesFragment;-onResume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onSingleTapUp-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-access$1000-(Lcom/android/phone/InCallScreen; Landroid/os/AsyncResult; C)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/TextServicesManagerService;-setCurrentSpellCheckerLocked-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/common/contacts/BaseEmailAddressAdapter$DefaultPartitionFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/data/WorkingMessage;-ensureThreadIdIfNeeded-(Lcom/android/mms/data/Conversation; Z)V' : ['android.permission.READ_SMS'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-getSelectedSpellCheckerSubtype-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumLowerCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Landroid/media/effect/effects/AutoFixEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/webkit/HTML5VideoFullScreen$1;-surfaceDestroyed-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-dispatchBroadcast-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/phone/EmergencyCallHelper;-startEmergencyCallFromAirplaneModeSequence-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Z)V' : ['android.permission.INTERNET'],
	'Landroid/media/AudioService$AudioHandler;-cleanupPlayer-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-handleUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/PhoneInterfaceManager;-enforceReadPermission-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/AlbumDataLoader$UpdateContent;-call-()Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DockService;-createDialog-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onAddView-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-getProfileConnectionState-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$24;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/policy/AutoRotateController;-updateState-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/VoiceInputOutputSettings;-onCreate-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/common/list/DefaultContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToPrevImage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/Suggest;-<init>-(Landroid/content/Context; Ljava/util/Locale; Lcom/android/inputmethod/latin/Suggest$SuggestInitializationListener;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readIapFileAndWait-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-registerForSuppServiceNotification-(Landroid/os/Handler; I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage$1;-doInBackground-([Ljava/lang/Void;)Landroid/util/Pair;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onSingleTapUp-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView$1;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/text/method/TextKeyListener$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-getAccountsForPackage-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calculator2/ColorButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateSettings-(Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-update-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/google/common/io/Files;-getDigest-(Ljava/io/File; Ljava/security/MessageDigest;)[B' : ['android.permission.INTERNET'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/TextServicesManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordActivity;-onClickConfirm-(Landroid/view/View;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothAdapter;-startLeScan-(Landroid/bluetooth/BluetoothAdapter$LeScanCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$19;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/keyguard/ChallengeLayout;-showBouncer-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-getBestProvider-(Landroid/location/Criteria; Z)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/MessageUtils;-getNotificationIndDetails-(Landroid/content/Context; Landroid/database/Cursor;)Ljava/lang/String;' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordContents;-getLocalesList-(Landroid/app/Activity;)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession;-start-(Landroid/os/Handler; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-loadFromThreadId-(J Z)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-update-(Lcom/android/internal/telephony/uicc/IccCardApplicationStatus; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/providers/downloads/DownloadThread;-readFromResponse-(Lcom/android/providers/downloads/DownloadThread$State; [B Ljava/io/InputStream;)I' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/IMediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-removeFence-(Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/FdnList;-isAirplaneModeOn-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/PieController$2;-onClick-(Lcom/android/camera/ui/PieItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DataUsageSummary$UidDetailTask;-bindView-(Lcom/android/settings/net/UidDetailProvider; Lcom/android/settings/DataUsageSummary$AppItem; Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/ISyncStatusObserver$Stub$Proxy;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-makeStatusBarView-()Landroid/view/View;' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Landroid/provider/Contacts$ContactMethods;-addPostalLocation-(Landroid/content/Context; J D D)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-delete-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PicasaSource;-next-(Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-changeCurrentSpellChecker-(Lcom/android/settings/inputmethod/SingleSpellCheckerPreference;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/IBackupAgent;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/MessagingController;-synchronizeMailbox-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox; Lcom/android/email/MessagingListener;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/EdgeView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-onYearSelected-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/NsdService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.INTERNET'],
	'Lcom/android/server/LockSettingsService;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/editor/ContactEditorFragment$EntityDeltaComparator;-compare-(Ljava/lang/Object; Ljava/lang/Object;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/app/IBatteryStats;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DataUsageSummary;-getActiveSubscriberId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getDeltaForAttachingPhotoToContact-()Lcom/android/contacts/model/RawContactDeltaList;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-access$000-(Lcom/android/providers/settings/SettingsBackupAgent; Z)I' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/InCallScreen;-internalAnswerCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-updateNetworkRulesLocked-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Landroid/bluetooth/BluetoothHealth;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/MailService;-setupAccountManagerAccount-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Z Z Z Landroid/accounts/AccountManagerCallback;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEvent-(Ljava/lang/Object; J J J J I I J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getRemoteType-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-access$200-(Lcom/android/contacts/activities/ContactDetailActivity;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/CredentialStorage;-access$700-(Lcom/android/settings/CredentialStorage;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onCodeInput-(I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/AudioPreview;-playPauseClicked-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$LoaderTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-wakeUpInternal-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar$NotificationClicker;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetUpIdleModeText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onSetInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePeople-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/ISipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/LocationSettings;-onToggleLocationAccess-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-beginServiceDeclaration-(I I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/RadioButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$2;-onRefreshBatteryInfo-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor$BatteryStatus;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DataUsageSummary$UidDetailTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DataUsageSummary;-buildLimitedNetworksList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/server/input/InputManagerService;-interceptKeyBeforeDispatching-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)J' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/RIL;-queryCLIP-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallTouchUi;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-outputRawContactsAsVCard-(Landroid/net/Uri; Ljava/io/OutputStream; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/InfoDropTarget;-access$300-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/GlobalActions$GlobalActionsDialog;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/content/IContentService;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/launcher2/Launcher;-onClickAllAppsButton-(Landroid/view/View;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewClassic;-performAccessibilityAction-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/VoiceInputOutputSettings;-populateOrRemoveRecognizerPrefs-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetFrame;-onDetachedFromWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/ApplicationPackageManager;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/deskclock/AlarmPreference;-onRestoreRingtone-()Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub;-setForcedDisplayDensity-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/alarmclock/DigitalWidgetViewsFactory$RemoteWorldClockAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(Lcom/android/inputmethod/keyboard/PointerTracker; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGatt;-writeDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$1;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/pm/PackageManagerService$10;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/IConnectivityManager$Stub;-getProvisioningOrActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/CameraActivity$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/editor/LabeledEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/SingleSpellCheckerPreference$2;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitor;-sendUpdates-(Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitorCallback;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-drawEvent-(Landroid/graphics/Canvas; Lcom/android/calendar/Event; I I I Z Z Z)I' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-access$800-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/BrowserContract$SyncState;-set-(Landroid/content/ContentProviderClient; Landroid/accounts/Account; [B)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/SecureAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/DeleteDropTarget$6;-run-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/AddressTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarController$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$AccountAnalyzer;-next-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/wifi/WifiAPITest$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/content/SyncStorageEngine;-requestSync-(Landroid/accounts/Account; I I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/contacts/CallLogProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/camera/ui/CountdownTimerPopup$Listener;-onListPrefChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/UIControllerOnePane;-doAutoAdvance-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/CameraWidgetFrame;-performAppWidgetSizeCallbacksIfNecessary-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserBackupAgent;-onRestore-(Landroid/app/backup/BackupDataInput; I Landroid/os/ParcelFileDescriptor;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity$1;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator$ViewMediatorCallback;-keyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-setPhoto-(J Landroid/graphics/Bitmap; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DateTimeSettings;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHeadsetPhone$Stub;-answerCall-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.VIBRATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getRemoveWarning-(Landroid/content/ComponentName; Landroid/os/RemoteCallback; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServicePreferenceFragment;-onResume-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onLongTap-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumNonLetter-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ActivityBase;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/BackupManagerService$PerformFullBackupTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask$RestoreFileRunnable;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/mail/store/ImapStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/widget/MmsWidgetService$MmsFactory;-onDataSetChanged-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/sip/SipSettings;-access$500-(Lcom/android/phone/sip/SipSettings; Landroid/net/sip/SipProfile;)V' : ['android.permission.READ_PROFILE', 'android.permission.USE_SIP'],
	'Lcom/android/gallery3d/ui/ScrollBarView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/AllInOneActivity;-initFragments-(J I Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-addVoiceMailNumberPanel-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/music/MusicUtils;-playAll-(Landroid/content/Context; [J I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/AddAccountSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/ExchangeService;-access$800-(Lcom/android/exchange/ExchangeService; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/RawContactEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothA2dp;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/AccessibilityInjector;-access$300-(Landroid/webkit/AccessibilityInjector;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt;-endReliableWrite-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhotoByDataId-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/camera/ui/InLineSettingItem;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dialer/CallDetailActivity$1UpdateContactDetailsTask;-doInBackground-([Ljava/lang/Void;)[Lcom/android/dialer/PhoneCallDetails;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/app/ResolverActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/camera/PhotoUI;-access$400-(Lcom/android/camera/PhotoUI;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/dreams/phototable/StockSource;-fillQueue-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ConfirmLockPattern$ConfirmLockPatternFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-restoreMasterVolume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/common/widget/GroupingListAdapter;-bindStandAloneView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/phone/RespondViaSmsManager;-onPostMessageSent-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity;-access$000-(Lcom/android/contacts/activities/PhotoSelectionActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-dialRecipient-()V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/WifiService;-getWifiServiceMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/SearchActivity$TextViewSnippet;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/AutofillHandler;-asyncLoadFromDb-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-refresh-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/PhoneApp;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-initialize-(Landroid/os/Bundle; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/ingest/IngestService;-onImportProgress-(I I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-addIncludedService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/shell/BugreportWarningActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView$4$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$900-(Lcom/android/contacts/activities/ConfirmAddDetailActivity; J Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/DevicePolicyManagerService;-syncDeviceCapabilitiesLocked-(Lcom/android/server/DevicePolicyManagerService$DevicePolicyData;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/DhcpStateMachine$WaitBeforeRenewalState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onResume-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/email/activity/MessageFileViewFragment;-reloadUiFromMessage-(Lcom/android/emailcommon/provider/EmailContent$Message; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/net/NetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-setupTitle-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/MessagingListener;-synchronizeMailboxFinished-(J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$2;-onRemoveViewAnimationCompleted-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavScreen$1;-onRemovePosition-(I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfoForSelf-()Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/CallbackProxy;-onSavePassword-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragment;-onPostLoadBody-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/AttachmentDownloadService;-watchdogAlarm-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/DateTimeView;-registerReceivers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageFileViewFragment;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/server/LocationManagerService;-access$300-(Lcom/android/server/LocationManagerService; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ConversationListItem;-access$000-(Lcom/android/mms/ui/ConversationListItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyOffApnsOfAvailability-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/InfoDropTarget;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/DialogCreatable;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/statusbar/phone/QuickSettingsModel;-onBrightnessLevelChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/ManageConferenceUtils$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/BluetoothManagerService;-registerStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MessageViewFragmentBase$Callback;-onMessageNotExists-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/users/AppRestrictionsFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/TrimControllerOverlay;-onScrubbingEnd-(I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerOnePane$ActionBarControllerCallback;-onUpPressed-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSharedPreferences;-isReceivingCallsEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeech$Connection$SetupConnectionAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-onMeasure-(I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/CharStreams;-readFirstLine-(Lcom/google/common/io/InputSupplier;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/server/location/GpsLocationProvider$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/MediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/InCallScreen;-requestCloseOtaFailureNotice-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-getRequestedPasswordMinimumLetters-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-tryVibrate-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/BaseCommand;-onRun-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewStateManager;-onPageSwitching-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetPager;-endReordering-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/dictionarypack/WordListPreference;-disableDict-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/MultiStateButton;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/MediaSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-onNegative-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-applyWakeLockFlagsOnAcquireLocked-(Lcom/android/server/power/PowerManagerService$WakeLock;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout;-setOnChallengeScrolledListener-(Lcom/android/internal/policy/impl/keyguard/SlidingChallengeLayout$OnChallengeScrolledListener;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/VideoModule$MyBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-onContentDirty-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/deskclock/AlarmKlaxon;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-removeTracksInternal-(I I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoModule;-init-(Lcom/android/camera/CameraActivity; Landroid/view/View; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/BluetoothEnabler;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHeadset;-startScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-setupService-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-processResponseHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Ljava/net/HttpURLConnection;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/server/wm/WindowAnimator$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-showSearchPanel-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/timezonepicker/TimeZoneData;-<init>-(Landroid/content/Context; Ljava/lang/String; J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/activities/JoinContactActivity;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/ex/chips/RecipientAlternatesAdapter;-getMatchingRecipients-(Landroid/content/Context; Ljava/util/ArrayList; Landroid/accounts/Account; Lcom/android/ex/chips/RecipientAlternatesAdapter$RecipientMatchCallback;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItems-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/content/IContentService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/common/model/AccountTypeManagerImpl;-onStatusChanged-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-onProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/event/AttendeesView;-access$100-(Lcom/android/calendar/event/AttendeesView; Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneGlobals;-updateProximitySensorMode-(Lcom/android/internal/telephony/PhoneConstants$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$2;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/data/ClusterAlbum$2;-consume-(I Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/browser/AddBookmarkPage$EditBookmarkInfoLoader;-loadInBackground-()Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/display/DisplayManagerService;-setInputManager-(Lcom/android/server/display/DisplayManagerService$InputManagerFuncs;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/event/EventColorPickerDialog;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$2800-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendActionDownAndUp-(Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-access$100-(Lcom/android/bluetooth/btservice/AdapterService; Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/data/SnailSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-verifyUnlock-(Landroid/view/WindowManagerPolicy$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-getWithUri-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)Landroid/util/Pair;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasSyncService;-messageMoveRequest-(Lcom/android/exchange/MessageMoveRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-showUnbondMessage-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-access$2000-(Lcom/android/server/BluetoothManagerService;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onProgressStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onInvalidSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wifi/WifiController;-initializeAndRegisterForSettingsChange-(Landroid/os/Looper;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavScreen;-openNewTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/app/PhotoPage$6;-onLoadingFinished-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/TrimTimeBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/CarrierText;-getCarrierHelpTextForSimState-(Lcom/android/internal/telephony/IccCardConstants$State; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/CharSequence;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/vcard/VCardParser_V21;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-autoConnectA2dp-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/ThumbnailManager$ThumbnailTask$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/DayView;-doSingleTapUp-(Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-writeDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/google/common/io/Files;-readLines-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/util/List;' : ['android.permission.INTERNET'],
	'Landroid/app/admin/DevicePolicyManager;-getKeyguardDisabledFeatures-(Landroid/content/ComponentName;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-initialize-(Landroid/os/Bundle; Lcom/android/contacts/list/ContactsRequest;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/musicvis/RenderScriptWallpaper$RenderScriptEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/email/MessagingController;-checkMail-(J J Lcom/android/email/MessagingListener;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEventWithExtraWithTitleWithCalendarId-(Ljava/lang/Object; J J J J I I J J Ljava/lang/String; J)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/LocationManager;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/launcher2/AppsCustomizeTabHost;-onLauncherTransitionEnd-(Lcom/android/launcher2/Launcher; Z Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/ObscureSpeechDelegate;-sendAccessibilityEvent-(Landroid/view/View; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-startScan-(I Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$AmsTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/EmailConnectivityManager;-waitForConnectivity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine$EnabledState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/display/DisplayManagerService;-access$1400-(Lcom/android/server/display/DisplayManagerService; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/VideoView$2;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ActivityBase$MyAppBridge;-access$200-(Lcom/android/camera/ActivityBase$MyAppBridge; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaListView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-setState-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/deskclock/AlarmClock;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/wifi/WifiApEnabler;-<init>-(Landroid/content/Context; Landroid/preference/CheckBoxPreference;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/QuickSettings$24;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/gadget/WidgetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView;-setLockPatternUtils-(Lcom/android/internal/widget/LockPatternUtils;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/Conversation;-ensureThreadId-()J' : ['android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-startUsingContactsDictionaryLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/LinkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$2;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/base/NullFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToHitPicture-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/gatt/GattService;-removeService-(I I I Ljava/util/UUID;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/dialer/SpecialCharSequenceMgr;-handleIMEIDisplay-(Landroid/content/Context; Ljava/lang/String; Z)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/ui/Switch;-access$900-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler$PhotoActionListener;-onRemovePictureChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-onBackPressed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoSourcePlexor;-<init>-(Landroid/content/Context; Landroid/content/SharedPreferences;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DataUsageSummary;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/model/ContactLoader;-postViewNotificationToSyncAdapter-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/setup/AccountSettingsEditQuickResponsesFragment$QuickResponseFinder;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-finalizeBackup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LightsService$1;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onContactUriQueryFinished-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/EmergencyButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/email/MessagingController;-searchMailbox-(J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/recurrencepicker/RecurrencePickerDialog;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardActivityLauncher;-getCameraIntent-()Landroid/content/Intent;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/common/editor/SelectAccountDialogFragment;-access$000-(Lcom/android/contacts/common/editor/SelectAccountDialogFragment; Lcom/android/contacts/common/model/account/AccountWithDataSet;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager;-setMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-deleteAndCreatePhone-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/webkit/HTML5VideoViewProxy;-pauseAndDispatch-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserSettings;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-getActivePasswordQuality-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressKey-(I Z I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/ActivityBase$MyAppBridge;-addSecureAlbumItem-(Z I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityCallback;-getFailedAttempts-()I' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$AdapterStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/phone/SettingsPanelView;-setImeWindowStatus-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-setCursor-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-handleMobileProvisioningAction-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupDetailFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-access$200-(Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/NsdService;-create-(Landroid/content/Context;)Lcom/android/server/NsdService;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/accounts/AccountManager$3;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardWidgetCarousel;-onAddView-(Landroid/view/View; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/IActivityManager;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-setParameter-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-access$2300-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-hideSearchPanel-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-setNavigationVisibility-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/tts/compat/CompatTtsService;-getSettingsLocale-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub;-dispatchMediaKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea;-hideMessage-(I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/PhotoController;-cancelAutoFocus-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/calendar/CalendarProvider2;-doUpdateTimezoneDependentFields-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-initSstIcc-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-sendDelayedMotionEvents-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/webkit/HTML5VideoView;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAudioSourceFunction-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/ChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardPatternView$3;-onFinish-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/FrameBranch;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodMenu-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/EventFieldEditorView;-rebuildValues-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$System;-getLong-(Landroid/content/ContentResolver; Ljava/lang/String;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BroadcastQueue;-setBroadcastTimeoutLocked-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchUnhandledKey-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.CALL_PHONE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/BatteryStatsService;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/data/WorkingMessage;-access$900-(Lcom/android/mms/data/WorkingMessage; Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/BackupManagerService;-bindToAgentSynchronous-(Landroid/content/pm/ApplicationInfo; I)Landroid/app/IBackupAgent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/effect/SizeChangeEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SendTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/AccessibilitySettings;-access$600-(Landroid/content/Context;)Ljava/util/Set;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/DevicePolicyManager;-hasGrantedPolicy-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-initializeHdmiState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-resumeGeofence-(I I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-unregisterForMonitorStateChangeCallback-(I Landroid/hardware/location/IGeofenceHardwareMonitorCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/accounts/IAccountManager;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/INotificationManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/test/mock/MockContentResolver;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/content/IContentService$Stub;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView;-verifyUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/EmergencyDialer;-keyPressed-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-readDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/SearchActivity;-onQueryTextSubmit-(Ljava/lang/String;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/transaction/MessagingNotification$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/IIntentReceiver$Stub;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/ILocationManager$Stub;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/Gallery;-initializeByIntent-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSettingsFragment;-onPause-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$VerifyingLinkState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackService;-reloadQueue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/Alarm;-run-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/net/LockdownVpnTracker;-reset-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/FilmstripPage;-refreshHidingMessage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccountsAsUser-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/SpellChecker;-<init>-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-access$2100-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/ui/PhotoFallbackEffect$PositionProvider;-getItemIndex-(Lcom/android/gallery3d/data/Path;)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardMessageArea$Helper;-setMessage-(Ljava/lang/CharSequence; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/DataManager;-rotate-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LocationManagerService;-removeUpdatesLocked-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewBase;-verifyUnlock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/Alarms;-get24HourMode-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/media/RingtonePlayer;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ILockSettings$Stub;-getString-(Ljava/lang/String; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasAccountService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumSymbols-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/contacts/ContactsUtils;-areContactWritableAccountsAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/IHardwareService;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/server/NativeDaemonConnector;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/ui/SlideshowView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/NavTabScroller;-onLayout-(Z I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/recent/RecentTasksLoader;-getFirstTask-()Lcom/android/systemui/recent/TaskDescription;' : ['android.permission.GET_TASKS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-discoverServices-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPinView;-resetState-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/BluetoothPbap;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/SearchPanelView$GlowPadTriggerListener;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/mms/ui/MessageListAdapter;-onContentChanged-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-generateBinaryDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ProxySelector;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/OutputStreamTarget;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateUtils;-getRelativeTimeSpanString-(J)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardViewMediator;-playSounds-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/ChooseLockPattern$ChooseLockPatternFragment;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mms/data/WorkingMessage;-deleteDraftSmsMessage-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/alerts/AlertReceiver;-getEventCursor-(Landroid/content/Context; J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-dispatchAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/EnableFdnScreen;-access$300-(Lcom/android/phone/EnableFdnScreen;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlarmScheduler;-scheduleNextAlarm-(Landroid/content/Context; Lcom/android/calendar/alerts/AlarmManagerInterface; I J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/ManageConferenceUtils;-endConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/bluetooth/pan/PanService;-handlePanDeviceStateChange-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String; I I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ConversationList;-createNewMessage-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageListItem;-setTimestamp-(J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-moveTo-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/PhoneUi;-hideNavScreen-(I Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/pm/PackageManagerService;-access$1800-(Lcom/android/server/pm/PackageManagerService; Lcom/android/server/pm/PackageManagerService$InstallArgs; Z Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/MediaSaveService$ImageSaveTask;-onPostExecute-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/worldclock/WorldClockAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/wifi/WifiSettings;-constructAccessPoints-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BaseUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/Suggest;-resetMainDict-(Landroid/content/Context; Ljava/util/Locale; Lcom/android/inputmethod/latin/Suggest$SuggestInitializationListener;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHealth;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-readChunked-(Ljava/io/InputStream; Ljava/io/OutputStream; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/MusicPicker;-setSelected-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-bindData-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-setProtocolMode-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/model/ImageModel;-loadThumbnailBitmap-(Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/InCallScreenShowActivation;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/BluetoothHealth;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub;-isScanAlwaysAvailable-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-doVibratorOn-(J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/wifi/WifiApEnabler;-setSoftapEnabled-(Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/WordListPreference$OnActionButtonClick;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/google/common/io/Files;-move-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/server/power/PowerManagerService;-access$1600-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiApConfigStore$InactiveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-access$100-(Landroid/hardware/location/GeofenceHardwareImpl;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-setCountryCode-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/launcher2/Launcher$7;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/event/EditEventView;-setTime-(Landroid/widget/TextView; J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardHostView$1;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-onVisibilityChanged-(Z)V' : ['android.permission.CAMERA'],
	'Lcom/android/email/Controller;-serviceLogging-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService;-switchToNextInputMethod-(Landroid/os/IBinder; Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/power/DisplayBlanker;-unblankAllDisplays-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/commands/svc/WifiCommand;-run-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmAlertWakeLock;-releaseCpuLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/TrimControllerOverlay;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/common/list/DefaultContactListAdapter;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageFileViewFragment;-onPostLoadBody-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Settings$System;-getLongForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSecurityCallback;-reportSuccessfulUnlockAttempt-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-onUserContextChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-requestStateChange-(Landroid/content/Context; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wfd/WifiDisplaySettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkTimeUpdateService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothGatt;-unregisterApp-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/group/GroupEditorFragment;-selectAccountAndCreateGroup-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/DevicePolicyManager;-getMaximumTimeToLock-(Landroid/content/ComponentName;)J' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothPbap;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/CalendarColorPickerDialog$OnCalendarColorSelectedListener;-onColorSelected-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/event/EditEventHelper$EditDoneRunnable;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyRepeatWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/am/ActivityManagerService$21;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/Controller;-createNewSnapshotTab-(J Z)Lcom/android/browser/SnapshotTab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackActivity;-cycleRepeat-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService$6;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/content/SyncStorageEngine;-init-(Landroid/content/Context;)V' : ['android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/MediaSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/text/StringSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/keyguard/PagedView;-snapToPageImmediately-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-sendScreenState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback;-syncMailboxStatus-(J I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/common/preference/ContactsPreferences$ChangeListener;-onChange-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getCurrentFailedPasswordAttempts-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSimPukView;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService;-access$1300-(Lcom/android/server/sip/SipService; Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/GeneralPreferences;-access$000-(Lcom/android/calendar/GeneralPreferences;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/ui/MenuExecutor$MediaOperation;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/IAudioService$Stub;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/inputmethod/research/ResearchLogger;-onWordFinished-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/pinyin/SkbContainer;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetoothGatt;-addCharacteristic-(I Landroid/os/ParcelUuid; I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$DeviceAdminSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-alarmExists-(Landroid/content/ContentResolver; J J J)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary$12;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-onPlayPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary$CycleChangeItem;-<init>-(Landroid/content/Context; J J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/location/LocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/service/PopImapSyncAdapterService$SyncAdapterImpl;-onPerformSync-(Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardSelectorView;-onFinishInflate-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/keyguard/KeyguardUpdateMonitorCallback;-onRefreshCarrierInfo-(Ljava/lang/CharSequence; Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/NsdService$NsdStateMachine$DisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/common/vcard/ExportProcessor;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PROFILE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/InputMethodManagerService$ImmsBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/UIControllerTwoPane$RefreshTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/photos/AlbumSetFragment;-getSubItemUrisForItem-(Ljava/lang/Object;)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onRegisterKey-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ChooseLockGeneric$ChooseLockGenericFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/datetimepicker/time/TimePickerDialog;-access$800-(Lcom/android/datetimepicker/time/TimePickerDialog; I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PROFILE'],
	'Lcom/android/dialer/calllog/CallLogFragment;-onDestroy-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/WorkingMessage;-preSendSmsWorker-(Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStoppingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeech;-playSilence-(J I Ljava/util/HashMap;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/contacts/common/list/CustomContactListFilterActivity$AccountDisplay;-buildDiff-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/ui/TileImageView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-assignContactFromPhone-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/data/WorkingMessage;-saveDraft-(Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/mms/data/WorkingMessage;-saveAsMms-(Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/email/activity/MessageOrderManager$LoadMessageListTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/WindowManagerGlobal;-addView-(Landroid/view/View; Landroid/view/ViewGroup$LayoutParams; Landroid/view/Display; Landroid/view/Window;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/exchange/ExchangeService$2;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/usb/UsbAccessoryUriActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-goTo-(J Z Z Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingApplication-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumSetDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-updateMessageOnIccEf-(Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/poli