/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:35:51 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import com.sshtools.j2ssh.io.ByteArrayReader;
import htsjdk.samtools.seekablestream.ByteArraySeekableStream;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableMemoryStream;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.variant.TabixReader;
import uk.ac.sanger.artemis.components.variant.VCFRecord;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class TabixReader_ESTest extends TabixReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      byte[] byteArray0 = new byte[14];
      byteArray0[1] = (byte) (-12);
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      TabixReader.readLine((InputStream) byteArraySeekableStream0);
      assertEquals(14L, byteArraySeekableStream0.position());
      assertTrue(byteArraySeekableStream0.eof());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      long long0 = TabixReader.readLong(seekableBufferedStream0);
      assertEquals(0L, long0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte)30;
      ByteArrayReader byteArrayReader0 = new ByteArrayReader(byteArray0);
      long long0 = TabixReader.readLong(byteArrayReader0);
      assertEquals(30L, long0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      byteArray0[3] = (byte)10;
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      String string0 = TabixReader.readLine((InputStream) byteArraySeekableStream0);
      assertEquals(4L, byteArraySeekableStream0.position());
      assertEquals("\u0000\u0000\u0000", string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      int int0 = TabixReader.readInt(byteArraySeekableStream0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      byteArray0[0] = (byte) (-36);
      SeekableMemoryStream seekableMemoryStream0 = new SeekableMemoryStream(byteArray0, "cbw% 2O2");
      int int0 = TabixReader.readInt(seekableMemoryStream0);
      assertEquals(220, int0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      byteArray0[3] = (byte) (-127);
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      TabixReader.readInt(byteArrayInputStream0);
      assertEquals(1, byteArrayInputStream0.available());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      SeekableHTTPStream seekableHTTPStream0 = new SeekableHTTPStream(uRL0);
      try { 
        TabixReader.readLong(seekableHTTPStream0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Could not find: www.someFakeButWellFormedURL.org
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        TabixReader.readLine((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.TabixReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      Path path0 = mockFile0.toPath();
      UnaryOperator<SeekableByteChannel> unaryOperator0 = UnaryOperator.identity();
      SeekablePathStream seekablePathStream0 = new SeekablePathStream(path0, unaryOperator0);
      DataInputStream dataInputStream0 = new DataInputStream(seekablePathStream0);
      SequenceInputStream sequenceInputStream0 = new SequenceInputStream(dataInputStream0, seekablePathStream0);
      try { 
        TabixReader.readLine((InputStream) sequenceInputStream0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      byteArraySeekableStream0.close();
      // Undeclared exception!
      try { 
        tabixReader0.readLine();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("htsjdk.samtools.seekablestream.ByteArraySeekableStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      // Undeclared exception!
      try { 
        TabixReader.readInt((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.TabixReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      MockFile mockFile0 = new MockFile((File) null, "Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
      try { 
        tabixReader0.readIndex((File) mockFile0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockRandomAccessFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "shared_id");
      TabixReader tabixReader0 = new TabixReader("");
      // Undeclared exception!
      try { 
        tabixReader0.query("A6+,:,#KU^");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      // Undeclared exception!
      try { 
        tabixReader0.query("Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \" java \"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      byte[] byteArray0 = new byte[7];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      TabixReader tabixReader0 = new TabixReader("");
      // Undeclared exception!
      try { 
        tabixReader0.query((int) (byte) (-128), 6, (int) (byte) (-58));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -128
         //
         verifyException("uk.ac.sanger.artemis.components.variant.TabixReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader((String) null, (URL) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/blast.tbi");
      FileSystemHandling.createFolder(evoSuiteFile0);
      URL uRL0 = MockURL.getHttpExample();
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader("blast", uRL0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.NativeMockedIO", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/|C8!S.tbi");
      FileSystemHandling.createFolder(evoSuiteFile0);
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader("|C8!S", byteArraySeekableStream0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.NativeMockedIO", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      byte[] byteArray0 = new byte[14];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader((String) null, byteArraySeekableStream0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockRandomAccessFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Premature end of file: java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi
         //
         verifyException("htsjdk.samtools.util.BlockCompressedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      FileSystemHandling.createFolder(evoSuiteFile0);
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader("");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.NativeMockedIO", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader("aD=");
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockRandomAccessFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      int[] intArray0 = tabixReader0.parseReg("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='");
      assertArrayEquals(new int[] {(-1), 0, Integer.MAX_VALUE}, intArray0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      Path path0 = mockFile0.toPath();
      SeekablePathStream seekablePathStream0 = new SeekablePathStream(path0);
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(seekablePathStream0, 4);
      try { 
        TabixReader.readInt(seekableBufferedStream0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      String string0 = tabixReader0.getFileName();
      assertEquals("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", string0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      byte[] byteArray0 = new byte[7];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      TabixReader tabixReader0 = new TabixReader("");
      tabixReader0.readIndex();
      assertEquals(0, tabixReader0.getSeqColumn());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      byte[] byteArray0 = new byte[7];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      TabixReader tabixReader0 = new TabixReader("");
      // Undeclared exception!
      try { 
        tabixReader0.query("");
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.components.variant.TabixReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      byteArray0[0] = (byte)10;
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      String string0 = TabixReader.readLine((InputStream) byteArraySeekableStream0);
      assertEquals(1L, byteArraySeekableStream0.position());
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      String string0 = tabixReader0.readLine();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "shared_id");
      TabixReader tabixReader0 = new TabixReader("");
      int int0 = tabixReader0.getStartColumn();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "shared_id");
      TabixReader tabixReader0 = new TabixReader("");
      int int0 = tabixReader0.getSeqColumn();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      byte[] byteArray0 = new byte[7];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      TabixReader tabixReader0 = new TabixReader("");
      try { 
        tabixReader0.readLine();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.NativeMockedIO", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      TabixReader tabixReader0 = null;
      try {
        tabixReader0 = new TabixReader("blast", uRL0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockRandomAccessFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      int int0 = tabixReader0.getEndColumn();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='.tbi");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "20!t=k'va,z.q4x!");
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0, 66);
      TabixReader tabixReader0 = new TabixReader("INSERT INTO feature_cvterm ( feature_cvterm_id, feature_id, cvterm_id, pub_id, rank, is_not ) VALUES ( nextval('feature_cvterm_feature_cvterm_id_seq'), (SELECT feature_id FROM feature WHERE uniquename='", seekableBufferedStream0);
      String[] stringArray0 = tabixReader0.getSeqNames();
      assertNotNull(stringArray0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "shared_id");
      TabixReader tabixReader0 = new TabixReader("");
      VCFRecord vCFRecord0 = tabixReader0.getNextRecord("", (-966), 685);
      assertNull(vCFRecord0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      // Undeclared exception!
      try { 
        TabixReader.readLong((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.TabixReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.tbi");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "shared_id");
      TabixReader tabixReader0 = new TabixReader("");
      char char0 = tabixReader0.getCommentChar();
      assertEquals('\u0000', char0);
  }
}
