/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.Configuration;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.Attribute;

public class ProgramElement {
    protected LinkedList<Attribute> attributes = new LinkedList();
    protected ConstantPool constantPool;
    protected short access_flags;
    protected static transient Configuration config = new Configuration();

    protected ProgramElement(ConstantPool constantPool) {
        this(constantPool, 0);
    }

    protected ProgramElement(ConstantPool constantPool, short access_flags) {
        this.constantPool = constantPool;
        this.access_flags = access_flags;
    }

    protected ProgramElement(ConstantPool constantPool, short access_flags, LinkedList<Attribute> attributes) {
        this.constantPool = constantPool;
        this.access_flags = access_flags;
        this.attributes = attributes;
    }

    public short getAccessFlags() {
        return this.access_flags;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    protected List<Attribute> readAttributes(DataInputStream dis) throws IOException {
        int attr_count = dis.readShort();
        for (int i = 0; i < attr_count; ++i) {
            Attribute a = Attribute.readAttribute(this.constantPool, dis);
            if (config.stripAttribute(a.getName())) continue;
            this.attributes.add(a);
        }
        return this.attributes;
    }

    protected void writeAttributes(DataOutputStream dos) throws IOException {
        dos.writeShort(this.attributes.size());
        for (Attribute a : this.attributes) {
            dos.writeShort(a.getAttributeNameIndex());
            byte[] bytes = a.getBytes();
            dos.writeInt(bytes.length);
            for (int j = 0; j < bytes.length; ++j) {
                dos.writeByte(bytes[j]);
            }
        }
    }
}

