/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserDetailPane;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.attributes.CodeAttributeDetailPane;

public class BrowserHistory {
    private static int MAX_HISTORY_ENTRIES = 50;
    private BrowserServices services;
    private LinkedList history = new LinkedList();
    private int historyPointer = -1;

    public BrowserHistory(BrowserServices browserServices) {
        this.services = browserServices;
    }

    public void clear() {
        this.history.clear();
        this.historyPointer = -1;
    }

    public void historyBackward() {
        if (this.historyPointer == 0) {
            return;
        }
        --this.historyPointer;
        this.syncWithHistory();
    }

    public void historyForward() {
        if (this.historyPointer == this.history.size() - 1) {
            return;
        }
        ++this.historyPointer;
        this.syncWithHistory();
    }

    public void updateActions() {
        if (this.services.getActionBackward() == null || this.services.getActionForward() == null) {
            return;
        }
        this.services.getActionBackward().setEnabled(this.historyPointer > 0);
        this.services.getActionForward().setEnabled(this.historyPointer < this.history.size() - 1);
    }

    public void updateHistory(TreePath treePath) {
        this.updateHistory(treePath, null);
    }

    public void updateHistory(TreePath treePath, Integer n) {
        BrowserHistoryEntry browserHistoryEntry = new BrowserHistoryEntry(treePath, n);
        if (!(this.checkForOffset(browserHistoryEntry) || this.historyPointer >= 0 && browserHistoryEntry.equals(this.history.get(this.historyPointer)))) {
            this.eliminateForwardEntries();
            if (this.historyPointer > MAX_HISTORY_ENTRIES) {
                this.history.removeFirst();
                --this.historyPointer;
            }
            this.history.add(browserHistoryEntry);
            ++this.historyPointer;
        }
        this.updateActions();
    }

    private boolean checkForOffset(BrowserHistoryEntry browserHistoryEntry) {
        BrowserHistoryEntry browserHistoryEntry2;
        if (this.historyPointer >= 0 && (browserHistoryEntry2 = (BrowserHistoryEntry)this.history.get(this.historyPointer)).getTreePath().equals(browserHistoryEntry.getTreePath())) {
            if (browserHistoryEntry.getOffset() == null) {
                return true;
            }
            if (browserHistoryEntry2.getOffset() == null) {
                this.eliminateForwardEntries();
                browserHistoryEntry2.setOffset(browserHistoryEntry.getOffset());
                return true;
            }
        }
        return false;
    }

    private void eliminateForwardEntries() {
        if (this.historyPointer < this.history.size() - 1) {
            ListIterator listIterator = this.history.listIterator(this.historyPointer + 1);
            while (listIterator.hasNext()) {
                listIterator.next();
                listIterator.remove();
            }
        }
    }

    private void syncWithHistory() {
        BrowserHistoryEntry browserHistoryEntry = (BrowserHistoryEntry)this.history.get(this.historyPointer);
        JTree jTree = this.services.getBrowserComponent().getTreePane().getTree();
        jTree.setSelectionPath(browserHistoryEntry.getTreePath());
        jTree.scrollPathToVisible(browserHistoryEntry.getTreePath());
        Integer n = browserHistoryEntry.getOffset();
        if (n != null) {
            BrowserDetailPane browserDetailPane = this.services.getBrowserComponent().getDetailPane();
            CodeAttributeDetailPane codeAttributeDetailPane = browserDetailPane.getAttributeDetailPane().getCodeAttributeDetailPane();
            codeAttributeDetailPane.selectByteCodeDetailPane();
            codeAttributeDetailPane.getCodeAttributeByteCodeDetailPane().scrollToOffset(n);
        }
        this.updateActions();
    }

    private class BrowserHistoryEntry {
        private TreePath treePath;
        private Integer offset;

        private BrowserHistoryEntry(TreePath treePath, Integer n) {
            this.treePath = treePath;
            this.offset = n;
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public Integer getOffset() {
            return this.offset;
        }

        public void setOffset(Integer n) {
            this.offset = n;
        }

        public boolean equals(Object object) {
            if (object == null && !(object instanceof BrowserHistoryEntry)) {
                return false;
            }
            BrowserHistoryEntry browserHistoryEntry = (BrowserHistoryEntry)object;
            return this.isEqual(this.offset, browserHistoryEntry.getOffset()) && this.isEqual(this.treePath, browserHistoryEntry.getTreePath());
        }

        public int hashCode() {
            return this.treePath.hashCode() ^ this.offset.hashCode();
        }

        private boolean isEqual(Object object, Object object2) {
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        public String toString() {
            return this.treePath.toString() + " / offset " + (this.offset == null ? "null" : this.offset.toString());
        }
    }
}

