// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SliceIncludes_h__
#define __SliceIncludes_h__

#include <set>
using std::set;
#include <map>
using std::map;
#include <string>
using std::string;

namespace Puma {
  class Unit;
  class CProject;
} // namespace Puma

using namespace Puma;

// this class manages all #includes that are need for introduced slice code

typedef set<Unit*> UnitSet;
typedef map<Unit*, UnitSet> UnitUnitSetMap;

class SliceIncludes : private UnitUnitSetMap {
  // generate the #include directive for a given target unit
  static string generate (CProject &project, Unit *iu);
public:
  
  // this function declares that a unit 'iu' depends on the unit 'si' in
  // which (a part of) a slice is defined
  void insert (Unit *iu, Unit *su);
  
  // interator type and functions to access the elements (only const access)
  typedef UnitUnitSetMap::const_iterator const_iterator;
  const_iterator begin () const { return UnitUnitSetMap::begin (); }
  const_iterator end () const   { return UnitUnitSetMap::end (); }

  // get the target unit associated with an entry
  Unit *unit (const_iterator entry) const { return (*entry).first; }
    
  // generate the #include directives for a given unit
  string generate (CProject &prj, const_iterator entry) const;
};

#endif // __SliceIncludes_h__
