/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.section;

import java.io.IOException;
import java.util.LinkedHashMap;
import yuku.alkitab.yes2.io.RandomInputStream;
import yuku.alkitab.yes2.io.RandomOutputStream;
import yuku.alkitab.yes2.section.base.SectionContent;
import yuku.bintex.BintexReader;
import yuku.bintex.BintexWriter;
import yuku.bintex.ValueMap;

public class VersionInfoSection
extends SectionContent
implements SectionContent.Writer {
    public String shortName;
    public String longName;
    public String description;
    public String locale;
    public int book_count;
    public int hasPericopes;
    public int textEncoding;
    public int buildTime;

    public VersionInfoSection() {
        super("versionInfo");
    }

    @Override
    public void write(RandomOutputStream output) throws IOException {
        BintexWriter bw = new BintexWriter(output);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("version", 3);
        if (this.shortName != null) {
            map.put("shortName", this.shortName);
        }
        if (this.longName != null) {
            map.put("longName", this.longName);
        }
        if (this.description != null) {
            map.put("description", this.description);
        }
        if (this.locale != null) {
            map.put("locale", this.locale);
        }
        if (this.buildTime != 0) {
            map.put("buildTime", this.buildTime);
        }
        map.put("book_count", this.book_count);
        map.put("hasPericopes", this.hasPericopes);
        map.put("textEncoding", this.textEncoding);
        bw.writeValueSimpleMap(map);
    }

    public static class Reader
    implements SectionContent.Reader<VersionInfoSection> {
        @Override
        public VersionInfoSection read(RandomInputStream input) throws Exception {
            BintexReader br = new BintexReader(input);
            ValueMap map = br.readValueSimpleMap();
            VersionInfoSection res = new VersionInfoSection();
            res.shortName = map.getString("shortName");
            res.longName = map.getString("longName");
            res.description = map.getString("description");
            res.locale = map.getString("locale");
            res.book_count = map.getInt("book_count");
            res.hasPericopes = map.getInt("hasPericopes", 0);
            res.textEncoding = map.getInt("textEncoding", 2);
            return res;
        }
    }
}

