//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      PyCore/Embed/PyCore.h
//! @brief     Includes python header and takes care of warnings.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_PYTHON
#error this header requires Python support
#endif
#ifdef SWIG
#error no need to expose this header to Swig
#endif
#ifndef BORNAGAIN_PYCORE_EMBED_PYCORE_H
#define BORNAGAIN_PYCORE_EMBED_PYCORE_H

#undef _POSIX_C_SOURCE
#undef _XOPEN_SOURCE

#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

#define PY_SSIZE_T_CLEAN
#include <Python.h>

#ifdef INCLUDE_NUMPY

#ifdef BORNAGAIN_PYTHON_API_SWIG

// NOTE: Using `PY_ARRAY_UNIQUE_SYMBOL` and `NO_IMPORT_ARRAY` one can use
// the Numpy Array API in multiple files for a single extension module.
#define PY_ARRAY_UNIQUE_SYMBOL BORNAGAIN_PYTHONAPI_ARRAY
#define NO_IMPORT_ARRAY

#endif // BORNAGAIN_PYTHON_API_SWIG

#define NPY_NO_DEPRECATED_API NPY_1_7_API_VERSION // to prevent spurious warning
#include <numpy/arrayobject.h>

#endif // INCLUDE_NUMPY

#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

#endif // BORNAGAIN_PYCORE_EMBED_PYCORE_H
