/** \file parms.h
 *
 *  System configuration and tuning
 */

// Copyright (C) 2014-2021 Sanford Rockowitz <rockowitz@minsoft.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#ifndef PARMS_H_
#define PARMS_H_

//
// *** Timeout values
//

// n. the DDC spec lists timeout values in milliseconds

#define DDC_TIMEOUT_MILLIS_DEFAULT                   50  ///< Normal timeout in DDC spec

#define DDC_TIMEOUT_MILLIS_BETWEEN_GETVCP_WRITE_READ 40   ///< Between DDC Get Feature Request and Get Feature Reply
#define DDC_TIMEOUT_MILLIS_POST_SETVCP_WRITE         50   ///< Following DDC Set VCP Feature command
#define DDC_TIMEOUT_MILLIS_POST_SAVE_SETTINGS              200   ///< Following DDC Save Settings
#define DDC_TIMEOUT_MILLIS_POST_NORMAL_COMMAND              50   ///< spec ambiguous
#define DDC_TIMEOUT_MILLIS_BETWEEN_CAP_TABLE_FRAGMENTS      50
#define DDC_TIMEOUT_MILLIS_POST_CAP_TABLE_COMMAND           50   ///< needed? spec ambiguous

#ifdef UNUSED
#define DDC_TIMEOUT_MILLIS_POST_CAPABILITIES_READ    50
#endif

// Timeouts not part of DDC spec
#define DDC_TIMEOUT_MILLIS_RETRY                    200  ///< Between retries
#define DDC_TIMEOUT_USE_DEFAULT                      -1  ///< Use the default timeout
#define DDC_TIMEOUT_NONE                              0  ///< No timeout
#define DDC_TIMEOUT_MILLIS_NULL_RESPONSE_INCREMENT  100  ///< Used for dynamic tuned sleep in case of DDC Null Message response


//
// *** Choose method of low level IC2 communication
//

// One of the following 2 defines must be enabled:
// #define DEFAULT_I2C_IO_STRATEGY  I2C_IO_STRATEGY_IOCTL ///< Use ioctl() calls
#define DEFAULT_I2C_IO_STRATEGY        I2C_IO_STRATEGY_FILEIO  ///< Use read() and write()
#define DEFAULT_I2C_READ_BYTEWISE      false                   ///< Use single byte reads
#define DEFAULT_EDID_WRITE_BEFORE_READ true
#define DEFAULT_EDID_READ_SIZE           0                     ///< 128, 256, 0=>dynamic
#define EDID_BUFFER_SIZE               256                     ///< always 256

#define DEFAULT_EDID_READ_USES_I2C_LAYER  false
#define DEFAULT_EDID_READ_BYTEWISE        false


// Strategy    Bytewise    read edid uses local i2c call                      read edid uses i2c layer
// FILEIO      false       ok                                                 ok
// FILEIO      true        on P2411h and Acer, reads byes 0. 2, 4 of response EDID ok, getvcp fails
// IOCTL       false       ok                                                 All ok
// IOCTL       true        on P2411h and Acer, returns corrupt data           EDID ok, getvcp fails

// Parms used only within testcase portion of code:

// #define DEFAULT_I2C_WRITE_MODE "write"
// #define DEFAULT_I2C_WRITE_MODE "ioctl_write"
//#define DEFAULT_I2C_WRITE_MODE  "i2c_smbus_write_i2c_block_data"

// #define DEFAULT_I2C_READ_MODE  "read"
// #define DEFAULT_I2C_READ_MODE  "ioctl_read"
// i2c_smbus_read_i2c_block_data can't handle capabilities fragments 32 bytes in size, since with
// "envelope" the packet exceeds the i2c_smbus_read_i2c_block_data 32 byte limit

// Notes on I2C IO strategies
//
// TODO: move comments re smbus problems to low level smbus functions (currently in i2c_base_io.c)
//
// Default settings in i2c_io.c
// valid write modes: "write", "ioctl_write", "i2c_smbus_write_i2c_block_data"
// valid read modes:  "read",  "ioctl_read",  "i2c_smbus_read_i2c_block_data"
// 11/2015: write modes "write" and "ioctl_write" both work
//          "i2c_smbus_write_i2c_block_data" returns ERRNO EINVAL, invalid argument
//          "read" and "ioctl_read" both work, appear comparable
//          fails: "i2c_smb_read_i2c_block_data"

//
// *** Retry Management ***
//

// Affects memory allocation in try_stats:
#define MAX_MAX_TRIES         15

// All MAX_..._TRIES values must be <= MAX_MAX_TRIES
#define INITIAL_MAX_WRITE_ONLY_EXCHANGE_TRIES     4
#define INITIAL_MAX_WRITE_READ_EXCHANGE_TRIES    10
#define INITIAL_MAX_MULTI_EXCHANGE_TRIES          8


//
// *** Miscellaneous
//

/** Maximum numbers of values on setvcp command */
#define MAX_SETVCP_VALUES    50

/** Maximum command arguments */
// #define MAX_ARGS (MAX_SETVCP_VALUES*2)   // causes CMDID_* undefined
#define MAX_ARGS 100        // hack

/** Parallelize display checks during initialization if at least this number of displays */
// on banner with 4 displays, async  detect: 1.7 sec, non-async 3.4 sec
#define DISPLAY_CHECK_ASYNC_NEVER    0xff
#define DISPLAY_CHECK_ASYNC_THRESHOLD_STANDARD  3
#define DISPLAY_CHECK_ASYNC_THRESHOLD_DEFAULT   DISPLAY_CHECK_ASYNC_NEVER

#define DEFAULT_SLEEP_LESS true

#ifdef USE_USB
#define DEFAULT_ENABLE_USB false
#else
#define DEFAULT_ENABLE_USB false
#endif

#define DEFAULT_ENABLE_CACHED_CAPABILITIES true
#define DEFAULT_ENABLE_UDF true


#endif /* PARMS_H_ */
