      INTEGER FUNCTION IZAMAX(N,ZX,INCX)
*     .. Scalar Arguments ..
      INTEGER INCX,N
*     ..
*     .. Array Arguments ..
      DOUBLE COMPLEX ZX(*)
*     ..
*
*  Purpose
*  =======
*
*     finds the index of element having max. absolute value.
*     jack dongarra, 1/15/85.
*     modified 3/93 to return if incx .le. 0.
*     modified 12/3/93, array(1) declarations changed to array(*)
*
*
*     .. Local Scalars ..
      DOUBLE PRECISION SMAX
      INTEGER I,IX
*     ..
*     .. External Functions ..
      DOUBLE PRECISION DCABS1
      EXTERNAL DCABS1
*     ..
      IZAMAX = 0
      IF (N.LT.1 .OR. INCX.LE.0) RETURN
      IZAMAX = 1
      IF (N.EQ.1) RETURN
      IF (INCX.EQ.1) GO TO 20
*
*        code for increment not equal to 1
*
      IX = 1
      SMAX = DCABS1(ZX(1))
      IX = IX + INCX
      DO 10 I = 2,N
          IF (DCABS1(ZX(IX)).LE.SMAX) GO TO 5
          IZAMAX = I
          SMAX = DCABS1(ZX(IX))
    5     IX = IX + INCX
   10 CONTINUE
      RETURN
*
*        code for increment equal to 1
*
   20 SMAX = DCABS1(ZX(1))
      DO 30 I = 2,N
          IF (DCABS1(ZX(I)).LE.SMAX) GO TO 30
          IZAMAX = I
          SMAX = DCABS1(ZX(I))
   30 CONTINUE
      RETURN
      END
