/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.elasticsearch.search.aggregations;

import org.elasticsearch.common.xcontent.ToXContent;

/**
 * Base structure for aggregation builders.
 */
public abstract class AbstractAggregationBuilder implements ToXContent {

    private final String name;
    protected final String type;

    /**
     * Sole constructor, typically used by sub-classes.
     */
    protected AbstractAggregationBuilder(String name, String type) {
        this.name = name;
        this.type = type;
    }

    /**
     * Return the name of the aggregation that is being built.
     */
    public String getName() {
        return name;
    }
}
