/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import java.util.Vector;

public abstract class CigarBase {
    protected int length = 0;
    protected int _inc_length = 10;
    protected char[] operation = null;
    protected int[] range = null;
    public static final char D = 'D';
    public static final char I = 'I';
    public static final char M = 'M';
    protected static final char _case_shift = ' ';

    public Object[] getSequenceAndDeletions(String reference, char GapChar) {
        int rlength = 0;
        Object deletions = new int[this.length][];
        Object trunc_deletions = null;
        StringBuffer sq = new StringBuffer();
        int cursor = 0;
        int alcursor = 0;
        int start = 0;
        int startpos = 0;
        int end = 0;
        int endpos = 0;
        int delcount = -1;
        boolean consecutive_del = false;
        if (this.length == 0) {
            return null;
        }
        if (reference != null) {
            rlength = reference.length();
        }
        boolean modstart = true;
        block5: for (int i = 0; i < this.length; ++i) {
            switch (this.operation[i]) {
                case 'D': {
                    if (!consecutive_del) {
                        deletions[++delcount] = new int[]{cursor, 0, alcursor};
                    }
                    deletions[delcount][1] = (cursor += this.range[i]) - 1;
                    consecutive_del = true;
                    continue block5;
                }
                case 'I': {
                    consecutive_del = false;
                    for (int r = 0; r < this.range[i]; ++r) {
                        sq.append(GapChar);
                        ++alcursor;
                    }
                    continue block5;
                }
                case 'M': {
                    consecutive_del = false;
                    if (modstart) {
                        start = cursor;
                        startpos = alcursor;
                        modstart = false;
                    }
                    if (reference != null) {
                        int sbend = cursor + this.range[i];
                        if (sbend > rlength) {
                            sq.append(reference.substring(cursor, rlength));
                            while (sbend-- >= rlength) {
                                sq.append(GapChar);
                            }
                        } else {
                            sq.append(reference.substring(cursor, sbend));
                        }
                    }
                    end = (cursor += this.range[i]) - 1;
                    endpos = alcursor += this.range[i];
                    continue block5;
                }
                default: {
                    throw new Error("Unknown SeqCigar operation '" + this.operation[i] + "'");
                }
            }
        }
        if (++delcount > 0) {
            trunc_deletions = new int[delcount][];
            System.arraycopy(deletions, 0, trunc_deletions, 0, delcount);
        }
        deletions = null;
        return new Object[]{reference != null ? sq.toString() : null, new int[]{start, startpos, end, endpos}, trunc_deletions};
    }

    protected void compact_operations() {
        int i = 1;
        if (this.operation == null) {
            return;
        }
        char last = this.operation[0];
        while (i < this.length) {
            if (last == this.operation[i]) {
                int n = i - 1;
                this.range[n] = this.range[n] + this.range[i];
                int r = this.length - i;
                if (r > 0) {
                    System.arraycopy(this.range, i + 1, this.range, i, r);
                    System.arraycopy(this.operation, i + 1, this.operation, i, r);
                }
                --this.length;
                continue;
            }
            last = this.operation[i++];
        }
    }

    public static Object[] parseCigarString(String cigarString) throws Exception {
        int ops = 0;
        int l = cigarString.length();
        for (int i = 0; i < l; ++i) {
            char c = cigarString.charAt(i);
            if (c != 'M' && c != '-' && c != 'I' && c != ')' && c != 'D' && c != '$') continue;
            ++ops;
        }
        char[] operation = new char[ops];
        int[] range = new int[ops];
        int op = 0;
        int i = 0;
        int l2 = cigarString.length();
        while (i < l2) {
            char c;
            int j = i;
            while ((c = cigarString.charAt(j++)) >= '0' && c <= '9' && j < l2) {
            }
            if (j >= l2 && c >= '0' && c <= '9') {
                throw new Exception("Unterminated cigar string.");
            }
            try {
                String rangeint = cigarString.substring(i, j - 1);
                range[op] = Integer.parseInt(rangeint);
                i = j;
            }
            catch (Exception e) {
                throw new Error("Implementation bug in parseCigarString");
            }
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if (c == 'M' || c == 'I' || c == 'D') {
                operation[op++] = c;
                continue;
            }
            throw new Exception("Unexpected operation '" + c + "' in cigar string (position " + i + " in '" + cigarString + "'");
        }
        return new Object[]{operation, range};
    }

    public void addOperation(char op, int range) {
        if (op >= 'a' && op <= 'z') {
            op = (char)(op - 32);
        }
        if (op != 'M' && op != 'D' && op != 'I') {
            throw new Error("Implementation error. Invalid operation string.");
        }
        if (range <= 0) {
            throw new Error("Invalid range string (must be non-zero positive number)");
        }
        boolean lngth = false;
        if (this.operation == null) {
            this.operation = new char[this._inc_length];
            this.range = new int[this._inc_length];
        }
        if (this.length + 1 == this.operation.length) {
            char[] ops = this.operation;
            this.operation = new char[this.length + 1 + this._inc_length];
            System.arraycopy(ops, 0, this.operation, 0, this.length);
            ops = null;
            int[] rng = this.range;
            this.range = new int[this.length + 1 + this._inc_length];
            System.arraycopy(rng, 0, this.range, 0, this.length);
            rng = null;
        }
        if (this.length > 0 && this.operation[this.length - 1] == op) {
            --this.length;
        } else {
            this.range[this.length] = 0;
        }
        this.operation[this.length] = op;
        int n = this.length++;
        this.range[n] = this.range[n] + range;
    }

    public int deleteRange(int start, int end) {
        int deleted = 0;
        if (this.length == 0) {
            return deleted;
        }
        if (start < 0 || start > end) {
            throw new Error("Implementation Error: deleteRange out of bounds: start must be non-negative and less than end.");
        }
        int cursor = 0;
        int rlength = 1 + end - start;
        int oldlen = this.length;
        int o = 0;
        boolean editing = false;
        char[] oldops = this.operation;
        int[] oldrange = this.range;
        this.length = 0;
        this.operation = null;
        this.range = null;
        this.compact_operations();
        while (o < oldlen && cursor <= end && rlength > 0) {
            if (oldops[o] == 'D') {
                this.addDeleted(oldrange[o++]);
                continue;
            }
            int remain = oldrange[o];
            if (!editing) {
                if (cursor + remain <= start) {
                    this.addOperation(oldops[o], oldrange[o]);
                    cursor += oldrange[o++];
                    continue;
                }
                editing = true;
                if (start - cursor > 0) {
                    this.addOperation(oldops[o], start - cursor);
                    remain -= start - cursor;
                }
            }
            if (o >= oldlen || !editing || rlength <= 0 || remain <= 0) continue;
            switch (oldops[o]) {
                case 'M': {
                    if (rlength > remain) {
                        this.addDeleted(remain);
                        deleted += remain;
                        break;
                    }
                    deleted += rlength;
                    this.addDeleted(rlength);
                    if (remain - rlength > 0) {
                        this.addOperation('M', remain - rlength);
                    }
                    rlength = 0;
                    remain = 0;
                    break;
                }
                case 'I': {
                    if (remain - rlength <= 0) break;
                    this.addInsertion(remain - rlength);
                    rlength = 0;
                    break;
                }
                case 'D': {
                    throw new Error("Implementation error.");
                }
                default: {
                    throw new Error("Implementation Error! Unknown operation '" + oldops[o] + "'");
                }
            }
            rlength -= remain;
            remain = oldrange[++o];
        }
        while (o < oldlen) {
            this.addOperation(oldops[o], oldrange[o++]);
        }
        return deleted;
    }

    public boolean hasDeletedRegions() {
        for (int i = 0; i < this.length; ++i) {
            if (this.operation[i] != 'D') continue;
            return true;
        }
        return false;
    }

    public int[] getDeletedRegions() {
        if (this.length == 0) {
            return null;
        }
        Vector<int[]> dr = new Vector<int[]>();
        int cursor = 0;
        int vcursor = 0;
        block5: for (int i = 0; i < this.length; ++i) {
            switch (this.operation[i]) {
                case 'M': {
                    cursor += this.range[i];
                }
                case 'I': {
                    vcursor += this.range[i];
                    continue block5;
                }
                case 'D': {
                    dr.addElement(new int[]{vcursor, cursor, this.range[i]});
                    cursor += this.range[i];
                }
            }
        }
        if (dr.size() == 0) {
            return null;
        }
        int[] delregions = new int[dr.size() * 3];
        int l = dr.size();
        for (int i = 0; i < l; ++i) {
            int[] reg = (int[])dr.elementAt(i);
            delregions[i * 3] = reg[0];
            delregions[i * 3 + 1] = reg[1];
            delregions[i * 3 + 2] = reg[2];
        }
        return delregions;
    }

    public int getFullWidth() {
        int w = 0;
        if (this.range != null) {
            for (int i = 0; i < this.length; ++i) {
                w += this.range[i];
            }
        }
        return w;
    }

    public int getWidth() {
        int w = 0;
        if (this.range != null) {
            for (int i = 0; i < this.length; ++i) {
                if (this.operation[i] != 'M' && this.operation[i] != 'I') continue;
                w += this.range[i];
            }
        }
        return w;
    }

    public void addInsertion(int range) {
        this.addOperation('I', range);
    }

    public void addDeleted(int range) {
        this.addOperation('D', range);
    }

    public String getCigarstring() {
        StringBuffer cigarString = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            cigarString.append("" + this.range[i]);
            cigarString.append(this.operation[i]);
        }
        return cigarString.toString();
    }
}

