-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-hostvariable-types.ads,v $
--  Description     : Ada Database Objects - Hostvariable                    --
--  Author          : Michael Erdmann                                        --
--  Created         : 29.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/02/14 20:46:59 $
--  Status          : $State: Exp $
--  Version         : $Revision: 1.1 $
--                                                                           --
--  Copyright (C) 2002 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This package contains all data types for the interface between the DBCS  --
--  and the application. Each type is derived from the host variable type    --
--  in order to privide the is_null indicator.                               --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;                  use Ada.Strings.Unbounded;

--* ADO
with GNU.DB.ADBC.Driver;
use  GNU.DB.ADBC;
use  GNU.DB;

package GNU.DB.ADBC.Hostvariable.Types  is

   --**************** --
   --** SQL_String ** --
   --**************** --
   type SQL_String  is new ADBC.Hostvariable.Object with private;

   procedure Value(
      This : in out SQL_String;
      V    : in String );

   function Value(
      This : in SQL_String ) return String;

   --***************** --
   --** SQL_Integer ** --
   --***************** --
   type SQL_Integer is new ADBC.Hostvariable.Object with null record;

   procedure Value(
      This : in out SQL_Integer;
      V    : in Integer );

   function Value(
      This : in SQL_Integer ) return Integer;

   --*************** --
   --** SQL_Float ** --
   --*************** --
   type SQL_Float   is new ADBC.Hostvariable.Object with null record;

   procedure Value(
      This : in out SQL_Float;
      V    : in Float );

   function Value(
      This : in SQL_Float ) return Float;

   -- ========================================================================= --
private

   type SQL_String  is new ADBC.Hostvariable.Object with record
         Str : Unbounded_String := Null_Unbounded_String;
      end record;

end GNU.DB.ADBC.Hostvariable.Types  ;

