// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst.Rtsp {

	using System;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class RTSPExtensionAdapter : GLib.GInterfaceAdapter, Gst.Rtsp.IRTSPExtension {

		[StructLayout (LayoutKind.Sequential)]
		struct GstRTSPExtensionInterface {
			public DetectServerNativeDelegate DetectServer;
			public BeforeSendNativeDelegate BeforeSend;
			public AfterSendNativeDelegate AfterSend;
			public ParseSdpNativeDelegate ParseSdp;
			public SetupMediaNativeDelegate SetupMedia;
			public ConfigureStreamNativeDelegate ConfigureStream;
			public GetTransportsNativeDelegate GetTransports;
			public StreamSelectNativeDelegate StreamSelect;
			IntPtr SendEvent;
			public ReceiveRequestNativeDelegate ReceiveRequest;
			[MarshalAs (UnmanagedType.ByValArray, SizeConst=4)]
			private IntPtr[] _gstGstReserved;
		}

		static GstRTSPExtensionInterface iface;

		static RTSPExtensionAdapter ()
		{
			GLib.GType.Register (_gtype, typeof (RTSPExtensionAdapter));
			iface.DetectServer = new DetectServerNativeDelegate (DetectServer_cb);
			iface.BeforeSend = new BeforeSendNativeDelegate (BeforeSend_cb);
			iface.AfterSend = new AfterSendNativeDelegate (AfterSend_cb);
			iface.ParseSdp = new ParseSdpNativeDelegate (ParseSdp_cb);
			iface.SetupMedia = new SetupMediaNativeDelegate (SetupMedia_cb);
			iface.ConfigureStream = new ConfigureStreamNativeDelegate (ConfigureStream_cb);
			iface.GetTransports = new GetTransportsNativeDelegate (GetTransports_cb);
			iface.StreamSelect = new StreamSelectNativeDelegate (StreamSelect_cb);
			iface.ReceiveRequest = new ReceiveRequestNativeDelegate (ReceiveRequest_cb);
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool DetectServerNativeDelegate (IntPtr inst, IntPtr resp);

		static bool DetectServer_cb (IntPtr inst, IntPtr resp)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				bool __result;
				__result = __obj.DetectServer (Gst.Rtsp.RTSPMessage.New (resp));
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int BeforeSendNativeDelegate (IntPtr inst, IntPtr req);

		static int BeforeSend_cb (IntPtr inst, IntPtr req)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.BeforeSend (Gst.Rtsp.RTSPMessage.New (req));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int AfterSendNativeDelegate (IntPtr inst, IntPtr req, IntPtr resp);

		static int AfterSend_cb (IntPtr inst, IntPtr req, IntPtr resp)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.AfterSend (Gst.Rtsp.RTSPMessage.New (req), Gst.Rtsp.RTSPMessage.New (resp));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int ParseSdpNativeDelegate (IntPtr inst, IntPtr sdp, IntPtr s);

		static int ParseSdp_cb (IntPtr inst, IntPtr sdp, IntPtr s)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.ParseSdp (sdp == IntPtr.Zero ? null : (Gst.Sdp.SDPMessage) GLib.Opaque.GetOpaque (sdp, typeof (Gst.Sdp.SDPMessage), false), s == IntPtr.Zero ? null : (Gst.Structure) GLib.Opaque.GetOpaque (s, typeof (Gst.Structure), false));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int SetupMediaNativeDelegate (IntPtr inst, IntPtr media);

		static int SetupMedia_cb (IntPtr inst, IntPtr media)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.SetupMedia (Gst.Sdp.SDPMedia.New (media));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool ConfigureStreamNativeDelegate (IntPtr inst, IntPtr caps);

		static bool ConfigureStream_cb (IntPtr inst, IntPtr caps)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				bool __result;
				__result = __obj.ConfigureStream (caps == IntPtr.Zero ? null : (Gst.Caps) GLib.Opaque.GetOpaque (caps, typeof (Gst.Caps), false));
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int GetTransportsNativeDelegate (IntPtr inst, int protocols, IntPtr transport);

		static int GetTransports_cb (IntPtr inst, int protocols, IntPtr transport)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.GetTransports ((Gst.Rtsp.RTSPLowerTrans) protocols, GLib.Marshaller.Utf8PtrToString (transport));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int StreamSelectNativeDelegate (IntPtr inst, IntPtr url);

		static int StreamSelect_cb (IntPtr inst, IntPtr url)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.StreamSelect (Gst.Rtsp.RTSPUrl.New (url));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int ReceiveRequestNativeDelegate (IntPtr inst, IntPtr req);

		static int ReceiveRequest_cb (IntPtr inst, IntPtr req)
		{
			try {
				IRTSPExtensionImplementor __obj = GLib.Object.GetObject (inst, false) as IRTSPExtensionImplementor;
				Gst.Rtsp.RTSPResult __result;
				__result = __obj.ReceiveRequest (Gst.Rtsp.RTSPMessage.New (req));
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		static int class_offset = 2 * IntPtr.Size;

		static void Initialize (IntPtr ptr, IntPtr data)
		{
			IntPtr ifaceptr = new IntPtr (ptr.ToInt64 () + class_offset);
			GstRTSPExtensionInterface native_iface = (GstRTSPExtensionInterface) Marshal.PtrToStructure (ifaceptr, typeof (GstRTSPExtensionInterface));
			native_iface.DetectServer = iface.DetectServer;
			native_iface.BeforeSend = iface.BeforeSend;
			native_iface.AfterSend = iface.AfterSend;
			native_iface.ParseSdp = iface.ParseSdp;
			native_iface.SetupMedia = iface.SetupMedia;
			native_iface.ConfigureStream = iface.ConfigureStream;
			native_iface.GetTransports = iface.GetTransports;
			native_iface.StreamSelect = iface.StreamSelect;
			native_iface.ReceiveRequest = iface.ReceiveRequest;
			Marshal.StructureToPtr (native_iface, ifaceptr, false);
		}

		GLib.Object implementor;

		public RTSPExtensionAdapter ()
		{
			InitHandler = new GLib.GInterfaceInitHandler (Initialize);
		}

		public RTSPExtensionAdapter (IRTSPExtensionImplementor implementor)
		{
			if (implementor == null)
				throw new ArgumentNullException ("implementor");
			else if (!(implementor is GLib.Object))
				throw new ArgumentException ("implementor must be a subclass of GLib.Object");
			this.implementor = implementor as GLib.Object;
		}

		public RTSPExtensionAdapter (IntPtr handle)
		{
			if (!_gtype.IsInstance (handle))
				throw new ArgumentException ("The gobject doesn't implement the GInterface of this adapter", "handle");
			implementor = GLib.Object.GetObject (handle);
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtsp_extension_get_type();

		private static GLib.GType _gtype = new GLib.GType (gst_rtsp_extension_get_type ());

		public static GLib.GType GType {
			get {
				return _gtype;
			}
		}

		public override GLib.GType GInterfaceGType {
			get {
				return _gtype;
			}
		}

		public override IntPtr Handle {
			get {
				return implementor.Handle;
			}
		}

		public IntPtr OwnedHandle {
			get {
				return implementor.OwnedHandle;
			}
		}

		public static IRTSPExtension GetObject (IntPtr handle, bool owned)
		{
			GLib.Object obj = GLib.Object.GetObject (handle, owned);
			return GetObject (obj);
		}

		public static IRTSPExtension GetObject (GLib.Object obj)
		{
			if (obj == null)
				return null;
			else if (obj is IRTSPExtensionImplementor)
				return new RTSPExtensionAdapter (obj as IRTSPExtensionImplementor);
			else if (obj as IRTSPExtension == null)
				return new RTSPExtensionAdapter (obj.Handle);
			else
				return obj as IRTSPExtension;
		}

		public IRTSPExtensionImplementor Implementor {
			get {
				return implementor as IRTSPExtensionImplementor;
			}
		}

		[GLib.Signal("send")]
		public event Gst.Rtsp.SendEventHandler SendEvent {
			add {
				GLib.Object.GetObject (Handle).AddSignalHandler ("send", value, typeof (Gst.Rtsp.SendEventArgs));
			}
			remove {
				GLib.Object.GetObject (Handle).RemoveSignalHandler ("send", value);
			}
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_after_send(IntPtr raw, IntPtr req, IntPtr resp);

		public Gst.Rtsp.RTSPResult AfterSend(Gst.Rtsp.RTSPMessage req, Gst.Rtsp.RTSPMessage resp) {
			IntPtr native_req = GLib.Marshaller.StructureToPtrAlloc (req);
			IntPtr native_resp = GLib.Marshaller.StructureToPtrAlloc (resp);
			int raw_ret = gst_rtsp_extension_after_send(Handle, native_req, native_resp);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			Marshal.FreeHGlobal (native_req);
			Marshal.FreeHGlobal (native_resp);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_before_send(IntPtr raw, IntPtr req);

		public Gst.Rtsp.RTSPResult BeforeSend(Gst.Rtsp.RTSPMessage req) {
			IntPtr native_req = GLib.Marshaller.StructureToPtrAlloc (req);
			int raw_ret = gst_rtsp_extension_before_send(Handle, native_req);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			Marshal.FreeHGlobal (native_req);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtsp_extension_configure_stream(IntPtr raw, IntPtr caps);

		public bool ConfigureStream(Gst.Caps caps) {
			bool raw_ret = gst_rtsp_extension_configure_stream(Handle, caps == null ? IntPtr.Zero : caps.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtsp_extension_detect_server(IntPtr raw, IntPtr resp);

		public bool DetectServer(Gst.Rtsp.RTSPMessage resp) {
			IntPtr native_resp = GLib.Marshaller.StructureToPtrAlloc (resp);
			bool raw_ret = gst_rtsp_extension_detect_server(Handle, native_resp);
			bool ret = raw_ret;
			Marshal.FreeHGlobal (native_resp);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_get_transports(IntPtr raw, int protocols, IntPtr transport);

		public Gst.Rtsp.RTSPResult GetTransports(Gst.Rtsp.RTSPLowerTrans protocols, string transport) {
			IntPtr native_transport = GLib.Marshaller.StringToPtrGStrdup (transport);
			int raw_ret = gst_rtsp_extension_get_transports(Handle, (int) protocols, native_transport);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			GLib.Marshaller.Free (native_transport);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_parse_sdp(IntPtr raw, IntPtr sdp, IntPtr s);

		public Gst.Rtsp.RTSPResult ParseSdp(Gst.Sdp.SDPMessage sdp, Gst.Structure s) {
			int raw_ret = gst_rtsp_extension_parse_sdp(Handle, sdp == null ? IntPtr.Zero : sdp.Handle, s == null ? IntPtr.Zero : s.Handle);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_receive_request(IntPtr raw, IntPtr req);

		public Gst.Rtsp.RTSPResult ReceiveRequest(Gst.Rtsp.RTSPMessage req) {
			IntPtr native_req = GLib.Marshaller.StructureToPtrAlloc (req);
			int raw_ret = gst_rtsp_extension_receive_request(Handle, native_req);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			Marshal.FreeHGlobal (native_req);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_send(IntPtr raw, IntPtr req, IntPtr resp);

		public Gst.Rtsp.RTSPResult Send(Gst.Rtsp.RTSPMessage req, Gst.Rtsp.RTSPMessage resp) {
			IntPtr native_req = GLib.Marshaller.StructureToPtrAlloc (req);
			IntPtr native_resp = GLib.Marshaller.StructureToPtrAlloc (resp);
			int raw_ret = gst_rtsp_extension_send(Handle, native_req, native_resp);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			Marshal.FreeHGlobal (native_req);
			Marshal.FreeHGlobal (native_resp);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_setup_media(IntPtr raw, IntPtr media);

		public Gst.Rtsp.RTSPResult SetupMedia(Gst.Sdp.SDPMedia media) {
			IntPtr native_media = GLib.Marshaller.StructureToPtrAlloc (media);
			int raw_ret = gst_rtsp_extension_setup_media(Handle, native_media);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			Marshal.FreeHGlobal (native_media);
			return ret;
		}

		[DllImport("gstrtsp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtsp_extension_stream_select(IntPtr raw, IntPtr url);

		public Gst.Rtsp.RTSPResult StreamSelect(Gst.Rtsp.RTSPUrl url) {
			IntPtr native_url = GLib.Marshaller.StructureToPtrAlloc (url);
			int raw_ret = gst_rtsp_extension_stream_select(Handle, native_url);
			Gst.Rtsp.RTSPResult ret = (Gst.Rtsp.RTSPResult) raw_ret;
			Marshal.FreeHGlobal (native_url);
			return ret;
		}

#endregion
	}
}
