#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "interface.h"
#include "support.h"
#include "main.h"
#include "callbacks.h"

void
rcm_clear_types_window ()
{
	GtkWidget *widget = NULL;
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesNameEntry");
	gtk_entry_set_text (GTK_ENTRY (widget), "");
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesCommandEntry");
	gtk_entry_set_text (GTK_ENTRY (widget), "");
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesArgumentsEntry");
	gtk_entry_set_text (GTK_ENTRY (widget), "");
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesTerminalChkBox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesIconEntry");
	gnome_icon_entry_set_filename (GNOME_ICON_ENTRY (widget), NULL);
}

gboolean
rcm_save_type (const ConnectionType type)
{
	ConnectionType *newtype = NULL;
	ConnectionTypesSListIsDirty = TRUE;
	if ((newtype =
	     rcm_find_type_by_name_in_list (type.Name,
					    ConnectionTypesSList)) != NULL)
	{
		memcpy (newtype, &type, sizeof (struct ConnectionType));
	}
	else
	{
		newtype =
			(ConnectionType *)
			malloc (sizeof (struct ConnectionType));
		g_return_val_if_fail (newtype != NULL, FALSE);
		memcpy (newtype, &type, sizeof (struct ConnectionType));
		ConnectionTypesSList =
			g_slist_append (ConnectionTypesSList, newtype);
	}
	return TRUE;
}

ConnectionType *
rcm_find_type_by_name_in_list (const gchar * name, GSList * list)
{
	gint i = 0;
	ConnectionType *type = NULL;
	gint len = g_slist_length (list);

	for (i = 0; i < len; i++)
	{
		type = g_slist_nth_data (list, i);
		if (strncmp (name, type->Name, NAMELEN) == 0)
			return type;
	}
	return NULL;
}

void
rcm_remove_type_from_list_by_name (const gchar * name)
{
	gint i = 0;
	ConnectionType *type = NULL;
	Connection* connection = NULL;
	gint len = 0;
	gint count = 0;
	gboolean type_is_in_use = FALSE;
	GString* msg = g_string_new(_("The Type you want to delete is in\nuse by the following Connections:\n"));
	
	len = g_slist_length (ConnectionsSList);
	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (ConnectionsSList, i);
		g_return_if_fail(connection != NULL);
		type = g_slist_nth_data(ConnectionTypesSList,connection->Type);
		if (strncmp (name, type->Name, NAMELEN) == 0)
		{
			type_is_in_use = TRUE;
			count++;
			if(count == 9)
			{
				g_string_append(msg,"...");
				break;
			}
			g_string_append(msg,connection->Name);
			g_string_append(msg,"\n");
		}
	}
	if(type_is_in_use)
	{
		rcm_warn(msg->str,ConnectionTypesWindow);
		g_string_free(msg,TRUE);
		return;
	}
	
	ConnectionTypesSListIsDirty = TRUE;
	len = g_slist_length (ConnectionTypesSList);
	for (i = 0; i < len; i++)
	{
		type = g_slist_nth_data (ConnectionTypesSList, i);
		if (strncmp (name, type->Name, NAMELEN) == 0)
		{
			ConnectionTypesSList =
				g_slist_remove (ConnectionTypesSList, type);
			return;
		}
	}
}

void
rcm_remove_all_types_from_disk ()
{
	GConfClient *gconf_client = NULL;
	gint i, len;
	gchar key[MAX_BUFFER_LENGTH];
	gboolean ret;

	gconf_client = gconf_client_get_default ();

	len = rcm_gconf_client_all_types_dirs (NULL);

	for (i = 0; i < len; i++)
	{
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Name",
			  GCONF_CONNECTION_TYPES_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Command",
			  GCONF_CONNECTION_TYPES_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Args",
			  GCONF_CONNECTION_TYPES_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Terminal",
			  GCONF_CONNECTION_TYPES_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Icon",
			  GCONF_CONNECTION_TYPES_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);
	}

	ConnectionTypesSListIsDirty = FALSE;
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	return;
}

gboolean
rcm_save_types_to_disk ()
{
	GConfClient *gconf_client = NULL;
	gint i, len;
	ConnectionType *type;
	gchar key[MAX_BUFFER_LENGTH];

	rcm_remove_all_types_from_disk ();
	len = g_slist_length (ConnectionTypesSList);

	if (len == 0)
		return TRUE;
	gconf_client = gconf_client_get_default ();

	len = g_slist_length (ConnectionTypesSList);
	for (i = 0; i < len; i++)
	{
		type = g_slist_nth_data (ConnectionTypesSList, i);
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Name",
			  GCONF_CONNECTION_TYPES_DIR, i);
		gconf_client_set_string (gconf_client, key, type->Name, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Command",
			  GCONF_CONNECTION_TYPES_DIR, i);
		gconf_client_set_string (gconf_client, key, type->Command,
					 NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Args",
			  GCONF_CONNECTION_TYPES_DIR, i);
		gconf_client_set_string (gconf_client, key, type->Arguments, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Terminal",
			  GCONF_CONNECTION_TYPES_DIR, i);
		gconf_client_set_bool (gconf_client, key, type->Terminal,
				       NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Icon",
			  GCONF_CONNECTION_TYPES_DIR, i);
		gconf_client_set_string (gconf_client, key, type->Icon, NULL);
	}

	ConnectionTypesSListIsDirty = FALSE;
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	return TRUE;
}

gboolean
rcm_load_types_from_disk ()
{
	GConfClient *gconf_client = NULL;
	gint i = 0;
	gchar key[MAX_BUFFER_LENGTH];
	gchar *tmp;
	ConnectionType *type;

	gconf_client = gconf_client_get_default ();
	g_slist_free (ConnectionTypesSList);
	ConnectionTypesSList = NULL;

	do
	{
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d",
			  GCONF_CONNECTION_TYPES_DIR, i);
		if (!gconf_client_dir_exists (gconf_client, key, NULL))
			break;
		type = (ConnectionType *)
			malloc (sizeof (struct ConnectionType));
		if (!type)
		{
			g_object_unref (gconf_client);
			ConnectionTypesSListIsDirty = TRUE;
			return FALSE;
		}
		memset (type, 0, sizeof (struct ConnectionType));

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Name",
			  GCONF_CONNECTION_TYPES_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		strncat (type->Name, tmp, MAX_BUFFER_LENGTH);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Command",
			  GCONF_CONNECTION_TYPES_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		strncat (type->Command, tmp, MAX_BUFFER_LENGTH);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Args",
			  GCONF_CONNECTION_TYPES_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		strncat (type->Arguments, tmp, MAX_BUFFER_LENGTH);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Terminal",
			  GCONF_CONNECTION_TYPES_DIR, i);
		type->Terminal =
			gconf_client_get_bool (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Icon",
			  GCONF_CONNECTION_TYPES_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		strncat (type->Icon, tmp, MAX_BUFFER_LENGTH);

		ConnectionTypesSList =
			g_slist_append (ConnectionTypesSList, type);
		i++;
	}
	while (TRUE);
	g_object_unref (gconf_client);
	ConnectionTypesSListIsDirty = FALSE;
	return TRUE;
}

void
rcm_update_connectiontypes_window_list ()
{
	gint i = 0;
	ConnectionType *type = NULL;
	GtkTreeIter iter;
	GtkListStore *store = NULL;
	GtkWidget *list;
	gint len = g_slist_length (ConnectionTypesSList);

	list = lookup_widget (ConnectionTypesWindow, "ConnectionTypesList");
	g_return_if_fail (list != NULL);
	store = GTK_LIST_STORE (gtk_tree_view_get_model
				(GTK_TREE_VIEW (list)));
	g_return_if_fail (store != NULL);
	gtk_list_store_clear (GTK_LIST_STORE (store));
	if (ConnectionTypesSList == NULL)
	{
		return;
	}

	for (i = 0; i < len; i++)
	{
		type = g_slist_nth_data (ConnectionTypesSList, i);
		gtk_list_store_append (store, &iter);
		gtk_list_store_set (store, &iter,
				    CONNECTION_TYPE_NAME_COLUMN, type->Name,
				    CONNECTION_TYPE_COMMAND_COLUMN,
				    type->Command,
				    CONNECTION_TYPE_ARGS_COLUMN, type->Arguments,
				    CONNECTION_TYPE_TERMINAL_COLUMN,
				    type->Terminal,
				    CONNECTION_TYPE_ICON_COLUMN, type->Icon,
				    -1);
	}
}

gint
rcm_gconf_client_all_types_dirs (GError ** err)
{
	GConfClient *gconf_client;
	gint i = 0;
	gchar key[MAX_BUFFER_LENGTH];
	GSList *list = NULL;

	gconf_client = gconf_client_get_default ();
	snprintf (key, MAX_BUFFER_LENGTH, "%s/0", GCONF_CONNECTION_TYPES_DIR);
	for (i = 0; i < INT_MAX; i++)
	{
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d",
			  GCONF_CONNECTION_TYPES_DIR, i);
		if (!gconf_client_dir_exists (gconf_client, key, err))
			break;
	}
	g_object_unref (gconf_client);
	return i;
}

void
rcm_select_type_by_name (gchar * name)
{
	GtkTreeIter iter;
	GtkListStore *store = NULL;
	GtkWidget *list;
	GValue *value;
	const gchar *name1;
	GtkTreeSelection *select;
	gchar path[10];
	gint i = 0;

	list = lookup_widget (ConnectionTypesWindow, "ConnectionTypesList");
	g_return_if_fail (list != NULL);

	store = GTK_LIST_STORE (gtk_tree_view_get_model
				(GTK_TREE_VIEW (list)));
	g_return_if_fail (store != NULL);

	snprintf (path, 10, "%d", i);
	while (gtk_tree_model_get_iter_from_string
	       (GTK_TREE_MODEL (store), &iter, path))
	{
		gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
				    CONNECTION_TYPE_NAME_COLUMN, &name1, -1);
		if (strcmp (name, name1) == 0)
		{
			select = gtk_tree_view_get_selection (GTK_TREE_VIEW
							      (list));
			g_return_if_fail (select != NULL);
			gtk_tree_selection_select_iter (select, &iter);
			return;
		}
		i++;
		snprintf (path, 10, "%d", i);
	}
}

gint
rcm_lookup_type_by_name (gchar * name)
{
	gint i = 0;
	gint len;
	ConnectionType *type;

	len = g_slist_length (ConnectionTypesSList);
	for (i = 0; i < len; i++)
	{
		type = g_slist_nth_data (ConnectionTypesSList, i);
		if (strcmp (type->Name, name) == 0)
			return i;
	}
	return -1;
}
