/* -*-Fundamental-*-

  $Header: /cvs/src/jbofihe/uncom.l,v 1.2 2000/12/04 23:47:52 richard Exp $

  Flex input file for removing comments from C, bison etc.

  A special case, the comment [* error *] (replace [ and ] by /
  obviously!) is left in, so that the action.perl file can avoid adding
  actions for rules where we use YYERROR ourselves and tag the rule with
  this comment.  We might extend this mechanism.

*/

/**********************************************************************
 * Copyright (C) Richard P. Curnow  1998-2001
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *********************************************************************/

%{
#ifndef yywrap
#define yywrap() 1
#endif

static int depth = 0;
%}

%x COMMENT

%%

<INITIAL>\/\*	{BEGIN COMMENT; depth = 1;}
<INITIAL>\/\*\ error\ \*\/ { ECHO; }
<INITIAL>\/\*\ ET\ [A-Zh]+\ \*\/ { ECHO; }
<COMMENT>\/\*   {depth++;}
<COMMENT>\*\/   {depth--; if (depth==0) {BEGIN INITIAL;}}
<COMMENT>.      { /* discard */ }
<COMMENT>\n     { /* discard */ }
<INITIAL>.      { ECHO; }
<INITIAL>\n     { ECHO; }

%%

int main() {
	yylex();
	return 0;
}
