/*****************************************************************************
 * 
 *  jsMath: Mathematics on the Web
 *  
 *  This jsMath package makes it possible to display mathematics in HTML pages
 *  that are viewable by a wide range of browsers on both the Mac and the IBM PC,
 *  including browsers that don't process MathML.  See
 *  
 *            http://www.math.union.edu/locate/jsMath
 *
 *  for the latest version, and for documentation on how to use jsMath.
 *
 *  Copyright 2004-2010 by Davide P. Cervone
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *****************************************************************************/

if (!window.jsMath) {jsMath = {}}
if (!jsMath.Script) {jsMath.Script = {}}

jsMath.Script.Uncompress = function (data) {
  for (var k = 0; k <  data.length; k++) {
    var d = data[k]; var n = d.length;
    for (var i = 0; i < n; i++) {if (typeof(d[i]) == 'number') {d[i] = d[d[i]]}}
    data[k] = d.join('');
  }
  eval(data.join(''));
}

//start = new Date().getTime();
jsMath.Script.Uncompress([
  ['if(!','window.','jsMath','||!',1,'jsMath.','loaded','){var ','jsMath_old','=',1,2,';',0,'document.','getElementById','||!',14,'childNodes||!',14,'createElement','){','alert("','The',' mathematics ','on this page requires W3C DOM support in its JavaScript. Unfortunately, your ','browser',' doesn\'t seem to have this.")}','else{',1,2,'={version:"3.6e",document:document,','window',':',32,',','platform',':(','navigator.',36,'.match(/','Mac/)?"mac":',38,36,40,'Win/)?"pc":"unix"),','sizes',':[50,60,70,85,100,120,144,173,207,249],styles:{".math','":{"font-family":"serif","font-style":"normal","font-weight":"normal','"},".typeset',48,'","line-height":"normal','","text-indent":"0px','","white-space":"','normal','"},".typeset .',54,48,'"},"div.','typeset','":{"text-align":"','center",margin:"1em 0px"},"span.',59,60,'left',49,' span',60,'left",border',':"0px",margin:"0px','",padding',':"0px"},"a .',59,' img, .',59,' a img','":{border:"0px','","border-bottom":"','1px solid',' blue;"},".',59,' .size0','":{"font-size":"','50','%"},".typeset .','size1',82,'60',84,'size2',82,'70',84,'size3',82,'85',84,'size4',82,'100',84,'size5',82,'120',84,'size6',82,'144',84,'size7',82,'173',84,'size8',82,'207',84,'size9',82,'249',84,'cmr10','":{"font-family":"jsMath-',121,', serif',55,'cmbx10',122,126,', ',2,'-cmr10',55,'cmti10',122,133,', ',2,131,55,'cmmi10',122,140,55,'cmsy10',122,144,55,'cmex10',122,148,55,'textit','":{"font-family":"','serif","','font-style":"italic',55,'textbf',153,'serif","font-weight":"bold',55,'link":{"','text-decoration":"none',55,'error',82,'90%","',155,'","background-color','":"#FFFFCC',70,':"1px','",border:"',78,' #CC0000',55,'blank','":{display:"','inline-block','",overflow:"','hidden',172,'0px none",width:"0px",height:"0px',55,'spacer',177,178,'"},"#','jsMath_hiddenSpan":{','visibility:"hidden",position:"absolute",','top:"0px",left:"0px',51,52,187,'jsMath_message','":{position:"fixed",bottom:"','1px",left:"2px',168,'":"#E6E6E6','",border:"solid 1px #959595",margin:"0px",padding:"','1px 8px','","z-index":"','102','",color:"black","font-size":"','small",width:"auto','"},"#jsMath_panel',195,'1.75em",right:"1.5em',70,':".8em 1.6em',168,'":"#DDDDDD',172,'outset 2px',201,'103",','width:"auto',203,'10pt","font-style":"',54,205,' .disabled":{color:"#888888',205,' .infoLink',82,'85%"},"#jsMath_panel *":{"','font-size":"inherit","font-style":"inherit","font-family":"inherit',51,205,' div":{"','background-color":"inherit",color:"inherit"},"#jsMath_panel ','span":{"',230,'td',76,70,69,'","',230,'tr',76,70,69,'","',230,'table',76,70,69,168,'":"inherit",color:"inherit",height:"auto",',216,187,'jsMath_button',195,'1px",right:"2px',168,'":"white',199,'0px 3px 1px 3px',201,'102",color:"black","',162,'","font-size":"x-',204,'",cursor:"hand"},"#',253,' *":{padding:"0px",border',69,51,'","',226,187,'jsMath_global":{"',155,187,'jsMath_noFont',' .message":{"text-align":"center",padding:".8em 1.6em",border:"3px solid #DD0000","background-color":"#FFF8F8",color:"#AA0000","font-size":"',204,187,'jsMath_noFont .link":{padding:"0px 5px 2px 5px',172,'2px outset',168,'":"#E8E8E8',203,'80%",',216,265,'jsMath_PrintWarning',277,'x-',204,'"},"@media print":{"#',253,177,'none',187,'jsMath_Warning',177,'none"}},"@media screen":{"#',289,177,'none"}}},Element',':function(','a){','return ',5,14,15,'("jsMath_"+a)},BBoxFor',304,'a','){this.','hidden.innerHTML','=\'<nobr><','span class="',59,'"><',316,'scale">\'+a+"</span></span></nobr>";var b=(',5,'Browser.','msieBBoxBug?this.','hidden.firstChild','.firstChild',':this.hidden',');var c={w:','b.offsetWidth',',h',326,'.offsetHeight','};this.',314,'="";',306,'c},EmBoxFor',304,'b){var a=',5,'Global.cache','.R;',0,'a[this.em',']){',343,']={}}',0,343,'][b]){','var c=','this.BBoxFor','(b);',343,'][b]={w:c.w/this.em,h:c.h/this.em}}',306,343,'][b]},Init',':function(){','if(',5,'Setup.inited','!=1){',0,5,361,'){',5,'Setup.','Body()}if(',5,361,'!=1){if(',5,361,'==-100','){return}',22,'It looks like ',2,' failed to set up properly (error code "+',5,361,'+").  I will try to keep going, but it could get ugly.");',5,361,'=1}}this.em=this.CurrentEm();','var a=',5,340,'.B;',0,343,']){',343,']={};',343,'].bb=',351,'("x");',350,343,'].bb.h;',343,'].d=',351,'("x"+',5,'HTML.Strut','(c/this.em)).h-c}',5,322,'italicCorrection=',343,'].ic;var g=',343,'].bb;var e=g.h;var f=',343,'].d;this.h=(e-f)/this.em;this.d=f/this.em;this.hd=this.h+','this.d;this.',368,'TeXfonts','();var b=this.EmBoxFor(\'<',316,121,'">M</span>\').w/2;this.TeX.M_height=b*(26/14);this.TeX.h=this.h;this.TeX.d=',419,'TeX.hd=this.hd;this.Img.Scale();',0,'this.initialized',313,368,'Sizes','();this.','Img.UpdateFonts()}this.p_height=(','this.TeX.cmex10[0].','h+',435,'d)/0.85;',429,'=1},ReInit',358,'if(this.','em!=this.CurrentEm()){this.Init()}},CurrentEm',358,387,351,'(\'<span style="\'+',5,322,'block+\';width:27em;height:1em','"></span>\').','w/27;if(a>0){',306,'a}',306,351,'(\'<img src="\'+',5,176,'+\'" style="width:13em;height:1em" />\').w/13},Loaded',358,'if(',8,7,'b=["Process","ProcessBeforeShowing","ProcessElement","ConvertTeX","ConvertTeX2","ConvertLaTeX","ConvertCustom","CustomSearch","Synchronize","Macro","document"];','for(var a=0;a<','b','.length;a++){','if(',8,'[b[a]]){','delete ',8,'[b[a]]}}}if(',8,'){this.Insert(',2,',',8,')}',8,'=null;',5,6,'=1},Add',304,'c,a){for(var b in a){','c[b]=a[b]}},Insert',304,487,'if(c[b]&&typeof(a[b])=="object"&&(','typeof(c[b])=="','object"||',492,'function")){this.Insert(c[b],a[b])}',28,'c[b]=a[b]}}},Package',304,'b,a',476,'b.prototype,a)}};',5,'Global={isLocal:1,cache:{','T:{},D:{},R:{},B',':{}},ClearCache',358,5,340,'={',504,':{}}},GoGlobal',304,338,'String(',5,1,'location',');var d=(',5,'isCHMmode','?"#":"?");if(b){a=a.replace(/\\?.*/,"")+"?"+b}',5,'Controls.','Reload(',5,'root+"',2,'-global.html"+d+escape(a))},Init',358,'if(',5,'Controls.cookie.','global=="always"&&!',5,'noGoGlobal','){if(',38,'accentColorName',376,0,5,32,'){',5,32,'=',32,'}',5,523,6,'=1;',5,523,'defaults.hiddenGlobal=null;this.GoGlobal(',5,523,'SetCookie(2))}},Register',358,387,5,1,'parent;',0,5,520,'){',5,520,'=(',5,1,517,'.protocol','=="mk:")}try{',0,5,520,313,'Domain()}if(a.',2,'&&a.',5,'isGlobal){a.',5,'Register(',5,32,')}}catch(b){',5,535,'=1}},Domain',358,'if(',38,'appName=="Microsoft Internet Explorer"&&',5,36,'=="mac"&&',38,'userProfile','!=null',376,'if(',5,14,'all&&!',5,1,'opera',376,'if(',32,'==parent',376,'var b=',5,14,'domain',';try{while(true){try{if(parent.',14,'title',602,'){return}}','catch(a){}',0,14,619,'.match(/\\..*\\./)){break}',5,14,619,'=',5,14,619,'.replace(/^[^.]*\\./,"")}}',625,5,14,619,'=b}};',5,'Script={request:null,Init',358,'if(!(',5,532,'asynch&&',5,532,'progress',')){if(',1,'XMLHttpRequest','){try{','this.request','=new ',655,'}catch(c){}if(',657,'&&',5,'root.match','(/^file:\\/\\//)){try{',657,'.open("GET",',5,526,5,'js",false);',657,'.send(null)}catch(','c){',657,'=null;if(',1,'postMessage&&',1,'addEventListener',313,'mustPost','=1;',5,1,680,'("message",',5,'Post.','Listener,false)}}}}',0,657,'&&',1,'ActiveXObject','&&!this.',682,7,'a=["MSXML2.XMLHTTP.6','.0","MSXML2.XMLHTTP','.5',700,'.4',700,'.3',700,'","Microsoft.XMLHTTP"];','for(var b=0;b<','a.length&&!',657,';b++){try{',657,658,695,'(a[b])}catch(c){}}}}',0,657,'||',5,368,'domainChanged',313,'Load=this.delayedLoad;this.needsBody=1}},Load',304,'b,a){','if(a){',5,'Message.Set("Loading "+','b);',5,'Script.','Delay(1);',5,'Script.Push(','this,"xmlRequest",b',');',5,734,5,'Message',',"Clear")}',28,5,734,735,')}},xmlRequest',304,'url){','this.blocking','=1;try{',657,667,'url,false);',657,673,'err){',749,'=0;if(',5,'Translate.','restart&&',5,'Translate.asynchronous){return""}throw Error("jsMath can\'t load the file \'"+url+"\'\\','nMessage: "+err.message)}if(',657,'.status',602,'&&(',657,766,'>=400||',657,766,'<0)){',749,'=0;if(',5,760,'restart&&',5,763,'nError status: "+',657,766,')}',0,'url','.match(/\\.js$/)){','return(',657,'.responseText',')}var tmpQueue','=this.queue;this.queue','=[];',5,1,'eval(',657,791,');',749,'=0;','this.queue=this.queue.','concat(','tmpQueue);this.Process();return""},cancelTimeout:30*1000,blocking:0,cancelTimer:null,needsBody:0,queue:[],Synchronize',304,'a,b','){if(typeof(','a)!="string"){',5,734,'null,a,b)}',28,5,734,5,32,',"eval",a)}},Push',304,'a,c,b',313,'queue[','this.queue.length',']=[a,c,b];if(!(',749,'||(this.needsBody&&!',5,14,'body','))){this.Process()}},Process',358,'while(',823,'&&!',749,7,'c=this.queue[0];',803,'slice(1);',387,'this.SaveQueue();var b=c[0];var e=c[1];var d=c[2];if(b){b[e](d)}',28,'if(e){e(d)}}this.','RestoreQueue','(a)}},SaveQueue',358,'var a',793,'=[];',306,'a},',844,304,'a){',803,804,'a)},delayedLoad',304,'a',313,'Push(','this,"','startLoad','",a)},',863,304,'a',7,'b=',5,14,20,'("iframe");b','.style.visibility="',180,'";b.style.','position="absolute";','b','.style.width="','0px";b','.style.height="','0px";if(',5,14,829,325,'){',5,14,829,'.insertBefore(','b,',5,14,829,325,')}',28,5,14,829,'.appendChild(','b)}',749,'=1;this.','url=a;if(a','.substr(0,',5,'root.length',')==',5,'root){a=a.substr(',5,909,')}',5,728,'a);this.cancelTimer=setTimeout("',5,731,'cancelLoad','()",this.cancelTimeout);',442,682,'){','b.src=',5,689,863,'(a,b)}',28,'if(a',788,926,5,526,2,'-loader.html"}',28,926,'this.url}}},','endLoad',304,'a){if(this.cancelTimer){clearTimeout(this.cancelTimer);this.cancelTimer=null}',5,689,942,'();',5,740,'.Clear();if(a!="cancel"){',749,'=0;this.Process','()}},Start',358,'this.tmpQueue',793,'=[]},End',358,803,804,956,');',472,956,'},',921,304,'b,',944,'if(b==null){b','="Can\'t load file"}if(a==null){a=2000}',5,740,'.Set(b);setTimeout(\'',5,731,942,'("cancel")\',a)},Delay',304,'a){',749,'=1;setTimeout("',5,731,'endDelay','()",a)},',986,358,749,953,'()},','imageCount',':0,WaitForImage',304,'b){',749,905,993,'++;',442,'img==null',313,'img=[]}',387,'new Image',433,'img[this.img.length]=a;a.onload=function(){if(--',5,731,993,'==0){',5,731,986,'()}};a.onerror=a.onload;a.onabort=a.onload;a.src=b},Uncompress',304,'data){for(var k=0;k<data.length;k++){var d=data[k];var n=d.length;for(var i=0;i<n;i++){if(typeof(d[i])=="number"){d[i]=d[d[i]]}}data[k]=d.join("")}',1,'eval(data.join(""))}};',5,'Post={',32,':null,Listener',304,'d){if(d.source!=',5,689,32,376,'var e=d.origin','.replace(/^file:\\/\\//,"");',387,14,619,1032,'if(e==null||e==""||e=="null"){e','="localhost"}if(','a==null||a==""||a=="null"){a',1038,'e!=a||!','d.data.substr(','0,6).match(/jsM(CP|LD|AL):/)){return}var b=',1042,'6,3).replace(/ /g,"");',350,1042,'10);if(',5,'Post.Commands[b',']){(',5,1050,'])(c)}},Commands:{SCR',304,'message){',5,1,'eval(message)},ERR',304,'a){',5,731,921,'(a,3000)},BGN',304,'a){',5,731,'Start()},END',304,'a){',726,5,731,'End()}',5,731,942,'()}},',863,304,'a,b',313,32,'=b.contentWindow;',0,'a',788,306,5,'root+a}',306,5,526,2,'-loader-post.html?"+a},',942,358,'this.',32,'=null}};',5,740,'={',176,':null,message:null,text:null,clear:null,Init',358,0,5,14,829,'||!',5,532,652,376,'this.message','=',5,'Element("message");',0,1118,'){if(',5,368,'stylesReady){',1118,'=',5,'Setup.DIV("','message",{visibility:"',180,'"},',5,'fixedDiv',')}',28,1118,'=',5,1131,'message",{',189,'bottom:"',196,'",','backgroundColor',':"#E6E6E6',199,200,'",zIndex:102,color:"black",fontSize:"',204,'"},',5,1136,')}}','this.text','=',5,14,'createTextNode','("");',1118,902,1158,');',1118,'.onmousedown=',5,760,'Cancel},Set',304,725,'if(this.clear){clearTimeout(this.clear',');this.clear=null}if(',5,532,652,'){',0,1158,313,'Init();',0,1158,624,'if(',5,322,'textNodeBug','){',1118,'.innerHTML','=b}',28,1158,'.nodeValue','=b}',1118,874,'visible";',726,1118,'.style.cursor','="pointer";',0,1118,1205,'){',1118,1205,'="hand"}',1118,'.title=" Cancel Processing of Math "}',28,1118,1205,'="";',1118,'.title=""}}',28,'if(b',907,'8)!="Loading "){',5,1,'status=b}}},Clear',358,1175,')}this.clear=setTimeout("',5,740,'.doClear()",1000)},doClear',358,442,'clear',313,'clear=null;',5,1,'status="";if(',1158,'){',1158,1198,'=""}if(',1118,'){',1118,874,180,'"}}},Blank',358,'if(','this.blank','||!',5,14,829,376,1256,'=',5,1131,176,'",{position',':(',5,322,'msiePositionFixedBug','?"absolute":"fixed"),',190,'",bottom:"0px",right:"0px",zIndex:101,',1148,':"white"},',5,1136,');if(',5,322,'msieBlankBug){',1256,1194,'="&nbsp;";',1256,879,'110%";',1256,881,'110%"}},UnBlank',358,'if(',1256,'){',5,14,829,'.removeChild(',1256,')}',1256,'=null}};',5,'Setup={',6,':[],DIV',304,'e,c,b){',971,'=',5,14,829,'}var d=',5,14,20,'("div");d.id="jsMath_"+e;','for(var a in c){','d.style[a]=c[a]}',0,'b.hasChildNodes){b',902,'d)}',28,'b',891,'d,b',325,')}',306,'d},Script',304,725,442,6,'[b]){return}',28,'this.',6,'[b]=1}',0,'b.match("^([a-zA-Z]+:/?)?/")){b=',5,'root+b}',5,731,'Load(b,a)},Hidden',358,5,180,'=this.DIV("Hidden",{',189,'top:0,left:0,border:0,padding:0,margin:0});',5,'hiddenTop=',5,180,';return},Source',358,'if(',5,'Autoload&&',5,'Autoload.root','){',5,'root=',5,1366,'}',28,5,'root="";',387,5,14,'getElementsByTagName("','script");',726,708,'a.','length;b++){','var d=a[b].src;if(d&&d.match("(^|/|\\\\\\\\)',5,'js$")){',5,1369,'d.replace','(/',5,'js$/,"");break}}}}if(',5,'root.charAt(','0)=="\\\\"){',5,1369,5,'root.replace','(/\\\\/g,"/")}if(',5,1395,'0)=="/"){if(',5,1395,'1)!="/"){',5,'root="//"+',5,14,517,'.host+',5,'root}',5,1369,5,14,517,574,'+',5,1415,28,0,5,664,'(/^[a-z]+:/i)){var d=','new String(',5,14,517,');',350,'new RegExp("/[^/]*/\\\\.\\\\./");',5,1369,1390,'(new RegExp("[^/]*$"),"")+',5,'root;while(',5,664,'(c)){',5,1369,5,1400,'(c,"/")}}}',5,'Img.',1369,5,526,'fonts/";',5,176,'=',5,526,176,'.gif";this.Domain()},Domain',358,'try{',5,14,619,'}catch(d',376,'var c="";',387,5,14,619,';if(',5,664,'("://([^/]*)/")){c=RegExp.$1}c=c.replace(/:\\d+$/,"");if(c==""||c==a',376,'if(',38,'appName=="Microsoft Internet Explorer"&&',5,36,'=="mac"&&',38,'onLine&&',38,601,'&&',5,14,'all',376,'c=c.split(/\\./);a=a.split(/\\./);if(c.length<2||a.length<2||','c[c.length-','1',']!=a[a.length-','1]||',1497,'2',1499,'2]){this.','DomainWarning','();return}var e=',1497,'2]+"."+',1497,'1];for(var b=3;b<=c.length&&b<=a.',1384,'if(',1497,'b',1499,'b]){break}e=',1497,'b]+"."+e}',5,14,619,'=e;this.',721,'=1},',1505,358,22,'In order for ',2,' to be able to load the additional components that it may need, the ',5,'js file must be ',6,' from a server in the same ',619,' as the page that contains it.  Because that is not the case for this page, the',24,'displayed here may not appear correctly.")},','EncodeFont',304,'c',7,'b=',5,'TeX[c];if(b[0].c',602,376,466,'128;a++){var d=b[a];b[a]=d[3];if(b[a]==null){b[a]={}}b[a].w=d[0];b[a].h=d[1];if(d[2]!=null){b[a].d=d[2]}b[a].c=',5,'TeX.encoding[a]}},Fonts',358,708,5,'TeX.fam','.',1384,387,5,1555,'[b];if(a',313,1539,'(a)}}},TeXfont',304,338,5,'TeX[b];if(a==null',376,'a.hd=',5,'EmBoxFor(\'<span class="\'+b+\'">\'+a[65].c','+"</span>").h;a.d=',5,1572,'+',5,408,'(a.hd)+"</span>").h-a.hd;a.h=a.hd-a.d;','if(b=="',140,'"){a.skewchar=','127}',28,1580,144,1582,'48}}},',421,358,466,5,1555,468,'if(',5,1555,'[a]){this.TeXfont(',5,1555,'[a])}}},Sizes',358,5,'TeXparams','=[];var b;var a;for(a=0;a<',5,46,468,5,1604,'[a]={}}for(b in ',5,'TeX',808,5,'TeX[b])!="object"){for(a=0;a<',5,46,468,5,1604,'[a][b]=',5,46,'[a]*',5,'TeX[b]/100}}}},Styles',304,'a){',0,'a){a=',5,'styles;a[".',59,' .scale"]={"font-size":',5,532,'scale+"%"};this.stylesReady=1}',5,734,862,'AddStyleSheet','",a);if(',5,322,'styleChangeDelay','){',5,734,5,'Script,"Delay",1)}},StyleString',304,'e',7,'a={},f;for(f in e){if(typeof e[f]==="string"){a[f]=e[f]}',28,'if(f',907,'1)==="@"){a[f]=','this.StyleString(','e[f])}',28,'if(e[f]!=null',7,'d=[];for(var c in e[f]){if(e[f][c]!=null){d[d.length]=c+": "+e[f][c]}}a[f]=d.join("; ")}}}}var b="";for(f in a){b+=f+" {"+a[f]+"}\\n"}',306,'b},',1642,304,'d',7,'b=',5,14,1379,'head")[0];if(',338,1660,'d);if(',5,14,'createStyleSheet){b.insertAdjacentHTML("beforeEnd",\'<','span style="display:','none">x</span><style type="text/css">\'+a+"</style>")}',28,350,5,14,20,'("style");c.type="text/css";c',902,5,14,1162,'(a));b',902,'c)}}',28,0,5,'noHEAD){',5,'noHEAD=1;',22,'Document is missing its <HEAD> section.  Style sheet can\'t be created without it.")}}},Body',358,442,'inited',376,'this.inited=-','1;',5,368,'Hidden();',1710,'2;',5,322,1184,1710,'3;if(',5,532,176,'){',5,740,'.Blank()}',1710,'4;',5,368,'Styles();',1710,'5;',5,523,1184,1710,'6;',5,734,5,'Setup,"User","pre-font");',1710,'7;',5,734,5,'Font,"Check");if(',5,'Font.register.length){',5,734,5,'Font,"LoadRegistered")}this.inited=1},User',304,'a){if(',5,'Setup.UserEvent[a',']){(',5,1760,'])()}},UserEvent:{"pre-font":null,onload:null}};',5,'Update={',421,304,'d){for(var a in d){for(var b in d[a]){for(var c in d[a',349,5,'TeX[a][b][c]=d[a][b][c]}}}},TeXfontCodes',304,'c){',1320,708,'c[a].',1384,5,'TeX[a][b].c=c[a][b]}}}};',5,'Browser={allowAbsolute:1,allowAbsoluteDelim:0,','separateSkips',':0,valignBug:0,operaHiddenFix:"",','msieCenterBugFix',':"",','msieInlineBlockFix',':"",msieSpaceFix:"",imgScale:1,renameOK:1,',1646,':0,delay:1,','processAtOnce',':16,version:0,','TestSpanHeight',358,5,314,'=\'<span><','span style="\'+this.block','+\';height:2em',';width:1px','"></span>x','</span>\';var b=',5,324,';',387,'b',325,';this.spanHeightVaries=(b',331,'>=a',331,'&&b',331,'>0);this.spanHeightTooBig=(b',331,'>a',331,');',5,314,'=""},','TestInlineBlock',358,'this.block="display',':-','moz-inline-box";','this.hasInlineBlock','=',5,'BBoxFor(\'<span style="\'+this.block','+\';width:10px;height:5px"></span>\').w>0;if','(',1828,'){',5,'styles[".typeset',' .',176,'"].display="-',1827,472,5,1837,' .spacer"].display','}',28,1825,':',178,'";',1828,'=',5,1831,1832,'(!',1828,624,'this.block+=";overflow:',180,'";var d=',5,'BBoxFor("x").h;this.mozInlineBlockBug=',5,1831,'+";height:"+d+\'px;width:1px',1801,'<',1798,'+";height:"+d+"px',1800,';vertical-align:-"+d+\'px',451,'h>2*d;this.widthAddsBorder=',5,1831,'+\';overflow:',180,';height:1px;width:10px',';border-left:','10px solid',451,'w>10;',350,5,1831,1867,1801,'\').h,b=',5,1831,1867,1881,78,1801,'\').h,a=',5,1831,1799,451,'h;this.msieBlockDepthBug=(c==d);','this.msieRuleDepthBug','=(b==d',');this.blankWidthBug=(','a==0)},','TestRenameOK',358,5,314,'="<span></span>";',387,5,324,';a.setAttribute("name","','jsMath_test','");this.renameOK=(',5,14,'getElementsByName("',1916,'").length>0);',5,314,1822,'TestStyleChange',358,5,314,'=\'<span ID="',1916,'">x</span>\';var b=',5,324,';',387,328,';',5,368,1642,'({"#',1916,'":"font-size:200%"});this.',1646,'=(',328,'==a);',5,314,1822,'VersionAtLeast',304,338,1430,'this.version',').split(".");','b=',1430,'b',1957,'if(b[1]==null){b[1]="0"}',306,'a[0]>b[0]||(a[0]==b[0]&&a[1]>=b[1])},Init',358,5,26,'="unknown";this.',1823,433,1793,433,1907,433,1926,433,'MSIE',433,'Mozilla',433,'Opera',433,'OmniWeb',433,'Safari',433,'Konqueror();if(','this.allowAbsoluteDelim','){',5,'Box.DelimExtend=',5,'Box.DelimExtendAbsolute;',5,'Box.Layout=',5,'Box.LayoutAbsolute}',28,5,'Box.DelimExtend=',5,'Box.DelimExtendRelative;',5,'Box.Layout=',5,'Box.LayoutRelative}',442,1783,'){',5,'HTML.Place=',5,'HTML.','PlaceSeparateSkips',';',5,'Typeset.prototype.','Place=',5,2017,2014,'}},MSIE',358,'if(',5,'BBoxFor("<!--[if ','IE]>IE','<![endif]-->").w','){',5,26,'="MSIE";if(',5,36,'=="pc"){this.','IE7=(',1,655,'!=null);this.','IE8=(',5,2026,'gte IE 8]>IE8',2028,'>0);','this.isReallyIE8','=(',5,14,'documentMode',2039,'quirks=(',5,14,'compatMode=="BackCompat");','this.msieMode','=(',5,14,2050,'||(this.quirks?5:7));this.msieStandard6=!this.quirks&&!this.IE7;',1988,905,1783,'=1',';this.buttonCheck=1;this.','msieBlankBug=1;this.','msieAccentBug',905,'msieRelativeClipBug','=1;this.msieDivWidthBug=1;this.',1271,905,'msieIntegralBug',905,'waitForImages',905,'msieAlphaBug','=!this.IE7;this.','alphaPrintBug',2079,1785,'="position:relative; ";this.',1787,'=" display:',178,';";this.msie8HeightBug=this.msieBBoxBug=(',2056,'==8',1905,2056,'!=8);this.msieSpaceFix=(',2046,'?\'<',1683,178,'; ','margin-right:-1px; width:1px"></span','>\':\'<span style="',2098,'>\');',5,'Macro("','joinrel','","\\\\mathrel{\\\\','kern-5mu}"),',5,'Parser.prototype.mathchardef.','mapstocharOrig','=',5,2108,'mapstochar;',472,5,2108,2113,5,2103,'mapstochar","\\\\','rlap{\\\\',2109,'\\\\,}\\\\kern1mu"),',5,1837,' .arial"]={"font-family":"\'Arial unicode MS\'"};',0,'this.IE7||this.quirks){',5,'styles["#jsMath_message"].',877,472,5,2130,'width;',5,'styles["#jsMath_panel"].',877,472,5,2137,'width;',5,'styles["#jsMath_button"].','width="1px";',5,2144,877,472,5,2144,'width;',5,1136,'=',5,1131,1136,1267,':"absolute",zIndex:101});',5,1,'attachEvent("','onscroll",',5,'Controls.MoveButton',');',5,1,2163,'onresize",',5,2166,');',5,2166,'()}',5,'styles["#jsMath_noFont .link"].','display="',178,'";',472,5,1837,1845,';',5,'styles[".tex2math_div','"]={};',5,'Add(',5,2189,'"],',5,'styles["div.',59,'"]);',5,2189,'"].width="100%";',5,2189,'"].',2180,178,'";',5,1837,'"]["letter-spacing"]="0";if(','screen.deviceXDPI','&&','screen.logicalXDPI','&&',2212,'!=',2214,313,'imgScale*=',2214,'/',2212,';',5,532,'alpha=0}if(',1903,'){',5,408,'=',5,'HTML.msieStrut}}',28,'if(',5,36,'=="mac"){this.msieAbsoluteBug',905,'msieButtonBug',2071,2067,'quirks=1;',5,368,'Script("',2,'-msie-mac.js");',5,'Parser.prototype.macros.angle=["Replace","ord",\'<font face="Symbol">&#x8B;</font>\',"',54,'"];',5,2137,'width="42em";',5,532,'printwarn=0}}this.',1791,'=Math.max(Math.floor((this.',1791,'+1)/2),1);',5,2103,'not',2105,2121,'kern3mu/}}");',5,'Macro("angle","\\\\raise1.','84pt','{\\\\kern2.5mu\\\\rlap{\\\\scriptstyle/}\\\\','kern.5pt\\\\','rule{.4em}{-','1.5pt}{1.84pt}\\\\kern2.5mu}")}},',1979,358,'if(',5,180,'.ATTRIBUTE_NODE&&',5,1,'directories){',5,26,'="',1979,'";if(',5,36,2035,2080,'=1}',1988,'=1;',5,2144,'cursor=',5,2179,'cursor="pointer",',5,2103,'not',2105,2121,'kern3mu/}}");',5,2271,'34pt',2273,2275,'1pt}{1.34pt}\\\\kern2.5mu}");if(',38,'vendor=="Firefox"){',1956,'=',38,'vendorSub}',28,'if(',38,'userAgent.match(" Firefox/([0-9.]+)([a-z ]|$)")){',1956,'=RegExp.$1}}',442,1952,'("3.0")){this.mozImageSizeBug=this.lineBreakBug=1}}},',1983,358,'if(',38,'accentColorName){',5,26,'="',1983,'";','this.allowAbsolute','=',1828,';',1988,'=',2341,';this.valignBug=!',2341,2066,1191,'=1;',5,'noChangeGlobal=1;',0,1828,'){',5,368,'Scri'],
  ['pt("','jsMath','-old-browsers.js','")}}},Opera',':function(){','if(this.','spanHeightTooBig){',1,'.browser="','Opera";','var b=','navigator.userAgent.match','("Opera 7");','this.allowAbsolute=0;this.','delay=10;this.operaHiddenFix="[Processing]";if(b){',1,'.Setup.','Script','("',1,2,'")}','var a=','navigator.appVersion.match','(/^(\\d+\\.\\d+)/);if(a){','this.version=a','[1]}else{this.vesion=0}this.operaAbsoluteWidthBug=this.operaLineHeightBug=(a[1]>=9.5&&a[1]<9.6)}},Safari',4,'if(',23,'(/Safari\\//)){',1,8,'Safari";if(navigator.vendor','.match(/','Google/)){',1,8,'Chrome"}',22,11,'("Safari/([0-9]+)");a=(a)?a[1]:400;',25,';',1,'.TeX.','axis_height','+=0.05;this.','allowAbsoluteDelim=','a>=125;this.safariIFRAMEbug=a>=312&&a<412;this.safariButtonBug=a<412;this.safariImgBug=1;this.textNodeBug=1;this.lineBreakBug=a>=526;this.buttonCheck=a<500;this.styleChangeDelay=1;',1,'.Macro("not","\\\\mathrel{\\\\rlap{\\\\kern3.25mu/}}")}},','Konqueror',4,'if(','navigator.product','&&',55,'.match("',52,'")){',1,8,52,'";',13,48,'0;if(',11,'(/',52,'\\/(\\d+)\\.(\\d+)/)){if(RegExp.$1<3||(RegExp.$1==3&&RegExp.$2<3)){this.separateSkips=1;this.valignBug=1;',1,16,17,'("',1,2,'")}}',1,'.Add(',1,'.styles,{".typeset .cmr10":"','font-family: ',1,'-','cmr10, ',1,' cmr10',', serif','",".typeset .','cmbx10":"',83,1,'-cmbx10, ',1,' cmbx10, ',1,'-',86,1,88,90,'cmti10":"',83,1,'-cmti10, ',1,' cmti10, ',1,'-',86,1,88,90,'cmmi10":"',83,1,'-cmmi10, ',1,' cmmi10',90,'cmsy10":"',83,1,'-cmsy10, ',1,' cmsy10',90,'cmex10":"',83,1,'-cmex10',', ',1,' cmex10"});',1,'.Font.testFont','="',1,132,', ',1,' cmex10"}}};',1,'.Font={testFont:"',1,132,'",fallback:"symbol",register:[],message:"<b>No ',1,' TeX fonts ','found</b> -- using',' image fonts instead','.<br/>\\nThese may be slow and might not print well.<br/>\\nUse the ',1,' control panel to get additional information','.",','extra_message',':\'Extra',150,'not found: <b><span id="jsMath_ExtraFonts"></span></b><br/>Using',152,'.  This may be slow and might not print well.<br/>\\nUse the ',1,155,'.\',','print_message',':"To print higher-resolution math symbols, click the<br/>\\n<b>Hi-Res Fonts for Printing</b> button on the ',1,' control panel.<br/>\\n",','alpha_message',':"If the math symbols print as black boxes, turn off <b>image alpha channels</b><br/>\\nusing the <B>Options</B> pane of the ',1,169,'Test1',':function(','c,','f,d,e){if(f==null){f=124}if(d==null){d=2}if(e==null){e=""}var b=jsMath.BBoxFor(\'<span style="font-family: \'+e+c+\', serif">\'+jsMath.TeX[c][f].c+"</span>");var a=jsMath.BBoxFor(\'<span style="font-family: serif">\'+jsMath.TeX[c][f].c+"</span>");return(','b.w>d*a.w&&b.h!=0)},Test2',175,'c,',177,'a.w>d*b.w&&b.h!=0)},CheckTeX',4,22,1,'.BBoxFor(\'<span ','style="font-family',': \'+',1,137,'+\', serif">\'+',1,45,'cmex10[1].c+"</span>");',1,'.nofonts','=((a.w*3>a.h||a.h==0)&&!this.Test1("cmr10",null,null,"',1,'-"));if(!',1,196,'){return}},Check',4,22,1,'.Controls.','cookie;this.CheckTeX();if(',1,196,'){if(a.autofont||a','.font=="tex"){','a.font=this.fallback;if(a.warn){',1,'.nofontMessage=1;a.warn=0;',1,206,'SetCookie(0);if','(',1,'.window.NoFontMessage','){',1,220,'()}else{','this.Message(this.','message)}}}}else{if(a.autofont){a.font="tex"}if(a',211,'return}}if(',1,'.noImgFonts){','a.font="unicode"}if(a','.font=="unicode','"){',1,16,17,'("',1,'-fallback','-"+',1,'.platform+".js");',1,'.Box.TeXnonfallback=',1,'.Box.TeX',';',1,246,'=',1,'.Box.TeXfallback;return}','if(!a.print&&a.printwarn){this.','PrintMessage','((',1,'.Browser.','alphaPrintBug&&',1,206,'cookie.alpha)?this.',166,'+this.',170,':this.',166,')}if(',1,257,'waitForImages){',1,'.Script.','Push(',1,'.',17,',"WaitForImage",',1,'.blank)}if(a.font=="symbol"){',1,16,17,'("',1,239,'-symbols.js");',1,'.Box.TeXnonfallback=',1,246,';',1,246,'=',1,252,1,'.Img.SetFont','({cmr10:["all"],cmmi10:["all"],cmsy10:["all"],cmex10:["all"],cmbx10:["all"],cmti10:["all"]});',1,'.Img.LoadFont','("cm-fonts")},Message',175,'a){if(',1,'.Element("Warning',60,'return}',10,1,16,'DIV("Warning','",{});b.innerHTML=\'<center><table><tr><td><div ','id="jsMath_noFont"><div ','class="message">\'+a','+\'<div style="text-align:left"><span style="float:left; margin: 8px 0px 0px 20px"><span onclick="',1,206,'Panel()" ','title=" Open ','the ',1,' Control Panel',' " class="link">',1,323,'</span></span','><span style="margin: 8px 20px 0px 0px; float:right"><span onclick="',1,'.Font.','HideMessage','()" title=" Remove this font warning message',324,'Hide this Message',327,'></div><div style="height:6px"></div><br clear="all"/></div></','div><div style="width:22em; height:1px"></div></td></tr></table></center><hr/>\'},',331,4,22,1,306,'");if(a','){a.style.display="none"}},',254,175,304,1,'.Element','("PrintWarning',60,308,10,1,16,'DIV',350,313,315,'+\'</',337,'Register',175,'h,b){if(typeof(h)=="string"){h={name:h}}if(!',1,16,'inited&&!b){','this.register','[',368,'.length]=h;',308,'var i=h.name;',22,'i.replace(/10$/,"");var f=',1,45,'fam.length;if(h.prefix==null){h.prefix=""}if(!h.style){h.',187,': "+h.prefix+i+", serif"}if(!h.styles){h.styles={}}if(!h.macros){h.macros={}}',1,45,'fam[f]=i;',1,45,'famName[i]=f;h.macros[a]=["HandleFont",f];',1,80,1,'.Parser.prototype.macros,h.macros);h.styles[".typeset ."+i]=h.style;',1,16,'Styles(h.styles);if(',1,'.initialized){',1,272,'Push(',1,'.Setup,"TeXfont",i)}var c=',1,206,'cookie;var e=!',1,196,'&&h.test(i,h.testChar,h.testFactor,h.prefix);if(e&&c',211,'if(h.tex){h.tex(i,f,h)}',308,'if(!e&&c.warn&&c.font=="tex"&&!',1,196,'){if(!c.fonts.match("/"+i+"/")){c.fonts+=i+"/";',1,206,217,'(!',1,306,60,225,157,')}var g=',1,'.Element("ExtraFonts");if(g){if(g','.innerHTML','!=""){g',426,'+=","}g',426,'+=" "+h.prefix+i}}}if(c',232,'"||',1,230,'if(h.fallback){h.fallback(i,f,h)}',308,'var d={};if(c.font=="symbol"&&h.symbol!=null){d[i]=h.symbol(i,f,h)}else{d[i]=["all"]}',1,298,'(d);',1,301,'(i);if(',1,'.initialized){',1,272,'Push(',1,'.Img,"Scale");',1,272,'Push(',1,'.Img,"UpdateFonts")}},LoadRegistered',4,22,'0;while(a<',368,'.length){this.Register(',368,'[a++],1)}',368,'=[]},Load',175,'a){',1,16,17,'(this.URL(a))},URL',175,'a){','return ',1,'.Img.root+a+"/def.js"}};',1,'.Controls={cookie:{scale:100,font:"tex",autofont:1,scaleImg:0,alpha:1,warn:1,fonts:"/",printwarn:1,stayhires:0,button:1,progress:1,asynch:0,blank:0,print:0,keep:"0D",global:"auto",hiddenGlobal:1},','cookiePath',':"/",','noCookiePattern',':/^(file|mk):$/,Init',4,'this.panel=',1,16,'DIV("panel",{display:"none"},',1,'.fixedDiv);','if(!',1,257,'msieButtonBug){this.Button',224,'setTimeout("',1,206,'Button()",500)}},Panel',4,1,'.Translate.Cancel();',5,'loaded){this.Main',224,1,272,'delayedLoad(',1,'.root+"',1,'-controls.html")}},Button',4,22,1,16,'DIV("button",{},',1,489,'a.',320,1,323,' ";a',426,'=\'<span onclick="',1,206,'Panel()">',1,'</span>\';if(!',1,'.Global.','isLocal&&!',1,'.noShowGlobal){a',426,'+=\'<span id="jsMath_global" ',320,1,' Global Panel " onclick="',1,532,'Show(1)">Global&nbsp;</span>\'}if(a.offsetWidth<30){a.style.width="auto"}if(!','this.cookie','.button',344,'MoveButton',4,'var a=(',1,257,'quirks?document.body:document.documentElement);',1,'.fixedDiv.style.','left=a.scrollLeft+"px";',1,554,'top=a.scrollTop+a.clientHeight+"px";',1,554,'width=a.clientWidth+"px"},GetCookie',4,'if(','this.defaults','==null){',564,'={}}',1,80,564,',',544,');this.userSet={};var c=',1,'.document.cookie',';if(',1,'.window.location','.protocol.match(this.',481,')){c=this.','localGetCookie','();this.','isLocalCookie','=1}if(c',34,1,'=([^;]+)/)){var d=unescape(RegExp.$1).split(/,/);for(',10,'0;b<d.length;b++){',22,'d[b].match(/(.*):(.*)/);if(a[2].match(/^\\d+$/)){a[2]=1*a[2]}',544,'[a[1]]=a[2];this.userSet[a[1]]=1}}},',582,4,474,1,578,'.search.substr(1)},SetCookie',175,'f){var b=[];for(var e in ',544,'){if(',564,'[e]==null||',544,'[e]!=',564,'[e]){b[b.length]=e+":"+',544,'[e]}}b=b.join(",");',5,584,'){if(f==2){return"',1,'="+escape(b)}','this.','localSetCookie','(b,f)}else{b=escape(b);if(b==""){f=0}',5,479,'){b+="; path="+this.',479,'}',5,'cookieDomain','){b+="; domain="+this.',627,'}if(',544,'.keep!="0D"){var a={D',':1000*60*60*24',',W',633,'*7,M',633,'*30,Y',633,'*365};var d=new Date;d.setTime(d.getTime()+',544,'.keep.substr(','0,1)*a[',544,642,'1,1)]);b+="; expires="+d.toGMTString()}if(b!=""){',1,575,'="',1,'="+b;var c=',1,575,';if(f&&!c',34,1,'=/)){alert("Cookies must be enabled in order to save ',1,' options")}}}',474,'null},',619,175,'b,c){if(!c){',308,22,'String(',1,578,').replace(/\\?.*/,"");if(b!=""){a+="?',1,617,'if(a!=',1,578,'.href){this.Reload(a)}},Reload',175,'a){if(!this.loaded){',308,'this.loaded=0;',1,16,'inited=-100;',1,532,'ClearCache();if(a){',1,578,'.replace(a)}else{',1,578,'.reload()}}};',1,'.Click={CheckClick',175,'a){if(!a){a=',1,'.window.event}if','(a.altKey){',1,206,'Panel()}},CheckDblClick',175,'b){if(!b){b=',1,698,'(!',1,'.Click.DblClick){',1,'.Extension.Require("double-click",1);',22,'b;b={};for(var c in a){b[c]=a[c]}}',1,272,'Push(',1,'.Click,"DblClick",[b,this.alt])}};',1,'.TeX={thinmuskip:3/18,medmuskip:4/18,thickmuskip:5/18,x_height:0.430554,quad:1,num1:0.676508,num2:0.393732,num3:0.44373,denom1:0.685951,denom2:0.344841,sup1:0.412892,sup2:0.362892,sup3:0.288888,sub1:0.15,sub2:0.247217,sup_drop:0.386108,sub_drop:0.05,delim1:2.39,delim2:1,',46,':0.25,default_rule_thickness:0.06,big_op_spacing1:0.111111,big_op_spacing2:0.166666,big_op_spacing3:0.2,big_op_spacing4:0.6,big_op_spacing5:0.1,integer:6553.6,scriptspace:0.05,nulldelimiterspace:0.12,delimiterfactor:901,delimitershortfall:0.5,scale:1,atom:["ord","op","bin","rel","open","close","punct","ord"],fam:["cmr10","cmmi10","cmsy10","cmex10","cmti10","","cmbx10",""],famName:{cmr10:0,cmmi10:1,cmsy10:2,cmex10:3,cmti10:4,cmbx10:6},encoding:["&#xC0;","&#xC1;","&#xC2;","&#xC3;","&#xC4;","&#xC5;","&#xC6;","&#xC7;","&#xC8;","&#xC9;","&#xCA;","&#xCB;","&#xCC;","&#xCD;","&#xCE;","&#xCF;","&#xB0;","&#xD1;","&#xD2;","&#xD3;","&#xD4;","&#xD5;","&#xD6;","&#xB7;","&#xD8;","&#xD9;","&#xDA;","&#xDB;","&#xDC;","&#xB5;","&#xB6;","&#xDF;","&#xEF;","!","&#x22;","#","$","%","&#x26;","&#x27;","(",")","*","+",",","-",".","/","0","1","2","3","4","5","6","7","8","9",":",";","&#x3C;","=","&#x3E;","?","@","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","[","&#x5C;","]","^","_","`","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","{","|","}","&#x7E;","&#xFF;"],cmr10:[[0.625',',0.683],[0.','833',723,'778',723,'694',723,'667',723,'75',723,'722',723,'778',723,'722',723,'778',723,'722',723,'583',',0.694,0,{ic:0.0778,krn:{"39":0.0778,"63":0.0778,"33":0.0778,"41":0.0778,"93":0.0778},lig:{"105":','14,"108":15}}],[0.556',',0.694],[0.','556',747,'833',747,'833',747,'278',',0.431],[0.','306',',0.431,0.194],[0.','5',747,'5',747,'5,0.628],[0.5',747,'5,0.568],[0.75',747,'444,0,0.17],[0.5',747,'722',755,'778',755,'5,0.528,0.0972],[0.903,0.683],[1.01',723,'778,0.732,0.0486],[0.278',',0.431,0,{','krn:{"108":-0.278,"76":-0.319}}],[0.278',',0.694,0,{','lig:{"96":','60}}],[0.5',747,'833',',0.694,0.194],[','0.5',',0.75,0.0556],[0.','833',784,'778',747,'278',777,'krn:{"63":0.111,"33":0.111},lig:{"39":34}}],[0.389',',0.75,0.25],[0.','389',792,'5,0.75],[','0.778,0.583,0.0833],[','0.278,0.106',',0.194],[0.','333',775,'lig:{"45":','123}}],[',797,'],[0.5',792,'5,0.644','],[0.5,0.644],[0.5,0.','644',807,'644',807,'644',807,'644],[0.5,0.644],[0.278',755,'278',757,'278,0.5',798,'778',',0.367,-0.133],[','0.472,0.5',798,'472',777,778,'62}}],[0.778',747,'75',',0.683,0,{krn:{"','116','":-0.0278,"','67',832,'79',832,'71',832,'85',832,'81',832,'84":-0.0833,"89":-0.0833,"86":-0.111,"87":-0.111}}],[0.','708',723,'722',723,'764',830,'88',832,'87',832,'65',832,'86',832,'89":-','0.0278}}],[0.','681',723,'653',',0.683,0,{','krn:{"111":-0.0833,"101":-0.0833,"117":-0.0833,"114":-0.0833,"97":-0.0833,"65":-0.111,"79":-0.0278,"67":-0.0278,"71":-0.0278,"81":-0.0278}}],[','0.785',723,'75',723,'361',830,'73":',859,'514',723,'778',830,'79',832,'67',832,'71',832,'81":-',859,'625',830,843,'917',723,'75',723,'778',830,'88',832,'87',832,'65',832,'86',832,'89":-',859,'681',830,'65','":-0.0833,"','111',832,'101',832,'97',832,'46',907,'44":-0.','0833}}],[0.','778,0.683',798,'736',830,'116',832,'67',832,'79',832,'71',832,'85',832,'81',832,843,'556',723,'722',830,'121',832,'101',907,'111',907,'114',907,'97',907,'65',907,'117":-0.',917,'75',723,'75',',0.683,0,{ic:0.','0139,',864,'1.03',956,'0139,',864,'0.75',830,'79',832,'67',832,'71',832,'81":-',859,'75',956,'025,krn:{"101',907,'111',907,'114',907,'97',907,'65',907,951,917,'611',723,'278',792,'5',747,'278',792,'5',747,'278,0.668],[0.','278',777,778,'92}}],[0.5',775,'krn:{"118',832,'106":0.0556,"121',832,'119":-',859,'556,0.','694,0',',{krn:{"101":0.0278,"111":0.0278,"120":-0.0278,"100":0.0278,"99":0.0278,"113":0.0278,"118":-0.0278,"106":0.0556,"121":-0.0278,"119":-0.0278}}],[0.','444',775,'krn:{"104',832,'107":-',859,'556',747,'444',755,'306',745,'12,"102":11,"108":13}}],[0.5',',0.431,0.194,{','ic:0.','0139,krn:{"','106":',859,'556',777,'krn:{"116',832,'117',832,'98',832,'121',832,'118',832,'119":-',859,997,'306,0.668',798,'528',777,'krn:{"97','":-0.0556,"','101',832,'97',832,'111',832,'99":-',859,'278',747,'833',775,'krn:{"116',832,'117',832,'98',832,'121',832,'118',832,'119":-',859,'556',775,'krn:{"116',832,'117',832,'98',832,'121',832,'118',832,'119":-',859,'5,0.431,0',1011,1009,'431,0.194',1011,'528',757,'392',755,'394',755,'389,0.615,0,{krn:{"121',832,'119":-',859,'556',775,'krn:{"119":-',859,'528',',0.431,0,{ic:0.',1027,'97',1050,'101',832,'97',832,'111',832,'99":-',859,'722',1109,1027,'101',832,'97',832,'111',832,'99":-',859,'528',755,'528',1025,'ic:0.',1027,'111',832,'101',832,'97',832,'46',907,'44":-0.',917,'444',755,'5',1109,'0278,',801,'124}}],[1',1109,'0278}],[0.','5',747,'5,0.668],[0.5,0.668]],cmmi10:[[0.615',956,'139',',krn:{"61":-0.0556,"59":-0.111,"58":-0.111,"127":0.',917,'833',830,'127":0.167}}],[0.','763',956,1152,'krn:{"127":0.0833}}],[0.','694',830,1166,'742',956,'0757,',1170,'831',956,'0812,krn:{"61',1050,'59":-0.0556,"58":-0.0556,"127":0.','0556}}],[0.','78',956,'0576,',1170,'583',956,'139',1162,1183,'667',863,1170,'612',956,'11,krn:{"61',1050,1182,1183,'772',956,'0502,',1170,'64',1109,'0037,','krn:{"127":',859,'566',',0.694,0.194,{ic:0.','0528,',1170,'518',1025,'ic:0.0556','}],[0.444',777,'ic:0.0378,krn:{"',1182,1183,'406',775,'krn:{"127":0.0556}}],[0.','438',1212,'0738,',1170,'497',1025,'ic:0.0359',',',1225,'469',777,'ic:0.',1152,1170,'354',775,1225,'576',755,'583',747,'603',1025,1209,859,'494',1109,'0637,krn:{"',1182,'0278}}],[0.','438',1212,'046,',1209,'0.111}}],[0.','57',1109,'0359}],[0.','517',1025,1170,'571',1109,'0359,krn:{"59',1050,'58":-0.',1183,'437',1109,'113,krn:{"',1182,1255,'54',1109,'0359,',1209,859,'596,0.694,0.194,{',1170,'626',1025,1225,'651',1212,'0359,',1209,1260,'622',1109,1263,'466',775,1170,'591',777,1170,'828',1109,1156,'517',1025,1170,'363,0.431,0.0972,{ic:0.0799,',1170,'654',1025,1209,'0.0833}}],[1',821,'1',821,'1',821,'1',821,'0.278',',0.464,-0.0363],[','0.278',1322,'0.5,0.465,-0.0347],[',1325,'0.5',755,'5',755,'5',755,'5',757,'5',757,'5,0.',1092,807,1092,807,'431',798,'278,0.106],[',797,798,'778',',0.539,0.0391],[','0.5,0.75,0.25,{krn:{"1',1050,'65',1050,'77',1050,'78',1050,'89":0.0556,"90":-0.',1183,'778',1348,1325,'0.531',777,1217,',',1170,'75',830,'127":','0.','139}}],[0.','759',956,'0502,',1170,'715',956,'0715,krn:{"61',832,1182,917,'828',956,1152,1225,'738',956,'0576,',1170,'643',956,'139',1162,917,'786',863,1170,'831',956,'0812,krn:{"61',1050,1182,1183,'44',956,'0785,',1209,1260,'555',956,'0962',1162,'167}}],[0.','849',956,'0715,krn:{"61',1050,1182,1183,'681',830,1369,859,'97',956,'109,krn:{"','61',1050,1182,917,'803',956,1426,'61',907,'61',832,1182,917,'763',956,1152,1170,'642',956,'139',1162,917,'791,0.683,0.194,{',1170,'759',956,'00773,',1170,'613',956,'0576,krn:{"61',1050,1182,917,'584',956,'139,krn:{"61',832,1182,917,'683',956,1426,'59":-0.111,"',1271,'111,"61',1050,1369,859,'583',956,'222',',krn:{"59":-0.167,"58":-0.167,"61":-0.111}}],[0.','944',956,'139',1479,'828',956,'0785,krn:{"61',907,'61',832,1182,917,'581',956,'222',1479,'683',956,'0715,krn:{"61',1050,1182,917,'389,0.75],[0.389',782,'0.389',782,'1,0.358,-0.142],[',1506,'0.417',777,1209,1260,'529',755,'429',747,'433',775,1225,'52',777,'krn:{"89":0.0556,"90',1050,'106":-0.111,"102":-0.167,"',1166,'466',775,1225,'49',1212,'108,krn:{"',1182,1413,'477',1025,1232,',',1209,859,'576',777,'krn:{"127":-',859,'345,0.66],[0.412,0.66,0.194,{ic:0.0572,krn:{"59',1050,1271,1183,'521',777,'ic:0.0315}],[0.298',777,'ic:0.0197,',1170,'878',755,'6',755,'485',775,1225,'503',1025,1170,'446',1025,1232,',',1170,'451',1109,1152,'krn:{"',1182,1183,'469',775,1225,'361,0.615,0,{',1170,'572',775,1209,859,'485',1109,'0359,',1209,859,'716',1109,'0269,',1170,'572',775,1209,859,'49',1025,1232,',',1225,'465',1109,'044,',1225,'322',775,1209,859,'384',1025,1170,'636',1025,1209,1260,'5,0.714,0,{ic:0.154}],[0.278',777,'ic:0.399}]],cmsy10:[[',796,'0.278,0.444,-0.0556],[',796,1325,796,'0.5,0.444,-0.0556],[',796,796,796,796,796,796,796,'1',782,1624,1624,'0.778',1322,'0.778,0.464,-0.0363','],[0.778,0.636,0.136',1639,1639,1639,1639,1639,'],[0.778',821,'0.778,0.483,-0.0169],[0.778',1348,'0.778',1348,'1',1348,'1',1348,'0.778',1348,'0.778',1348,'1',821,'1',821,'0.5',782,'0.5',782,'1',821,'1',782,'1',782,'0.778',1322,'1',821,'1',821,'0.611',782,'0.611',782,'1',821,'1',782,'1',782,'0.778',755,'275,0.556],[1',755,'667',1348,'0.667',1348,'0.889',782,'0.889',782,'0',782,'0',821,'0.556',747,'556',747,'667',755,'5',784,'722',747,'722',747,'778',747,'778',747,'611',747,'798',830,'48":0.','194}}],[0.657',956,'0304',',krn:{"48":0.',1371,'527',956,'0583',1729,1371,'771',956,'0278',1729,917,'528',956,'0894',1729,'111}}],[0.','719',956,'0993',1729,1745,'595',',0.683,0.0972,{ic:0.','0593',1729,1745,'845',956,'00965',1729,1745,'545',956,'0738,krn:{"48":',859,'678',1752,'185',1729,1413,'762',956,'0144',1729,1183,'69',830,1725,'139}}],[1.2',830,1725,1371,'82',956,'147',1729,917,'796',956,1738,1729,1745,'696',956,'0822',1729,917,'817,0.683,0.0972,{krn:{"48":',1260,'848',830,1725,917,'606',956,'075',1729,1371,'545',956,'254,krn:{"48":',859,'626',956,'0993',1729,917,'613',956,'0822,krn:{"48":',859,'988',956,'0822',1729,917,'713',956,'146',1729,1371,'668',1752,'0822',1729,917,'725',956,'0794',1729,1371,'667,0.556],[0.',1841,1841,1841,1841,'611',747,'611',747,'444',792,'444',792,'444',792,'444',792,'5',792,'5',792,'389',792,'389',792,'278',792,'5',792,'5',792,'611',792,'5',792,'278',782,'0.833,0.04,0.96],[0.75',723,'833',723,'417',1212,'111}],[0.',1841,'667,0.556',1639,1639,'],[0.444',782,'0.444',782,'0.444',782,'0.611',782,'0.778,0.694,0.13','],[',1897,'],[',1897,'],[',1897,']],cmex10:[[0.458',',0.04,1.16,{n:','16}],[0.458',1905,'17}],[0.417',1905,'104}],[0.417',1905,'105','}],[0.472,0.04,1.16,{n:','106',1913,'107',1913,'108',1913,'109}],[0.583',1905,'110}],[0.583',1905,'111',1913,'68',1913,'69}],[0.333',',0,0.6,{delim:{rep:','12}}],[0.556',1929,'13}}],[0.578',1905,'46}],[0.578',1905,'47}],[0.597',',0.04,1.76,{n:','18}],[0.597',1937,'19}],[0.736',',0.04,2.36,{n:','32}],[0.736',1941,'33}],[0.528',1941,'34}],[0.528',1941,'35}],[0.583',1941,'36}],[0.583',1941,'37}],[0.583',1941,'38}],[0.583',1941,'39}],[0.75',1941,'40}],[0.75',1941,'41}],[0.75',1941,'42}],[0.75',1941,'43}],[1.04',1941,'44}],[1.04',1941,'45}],[0.792',',0.04,2.96,{n:','48}],[0.792',1969,'49}],[0.583',1969,'50}],[0.583',1969,'51}],[0.639',1969,'52}],[0.639',1969,'53}],[0.639',1969,'54}],[0.639',1969,'55}],[0.806',1969,'56}],[0.806',1969,'57}],[0.806',',0.04,2.96],[','0.806',1989,'1.28',1989,'1.28',1989,'0.811',1937,'30}],[0.811',1937,'31}],[0.875',',0.04,1.76,{delim:{top:','48,bot:64,rep:66}}],[0.875',2001,'49,bot:65,rep:67}}],[0.667',2001,'50,bot:52,rep:54}}],[0.667',2001,'51,bot:53,rep:55','}}],[0.667,0.04,1.76,{delim:{bot:','52,rep:54',2009,'53,rep:55','}}],[0.667,0,0.6,{delim:{top:','50,rep:54',2013,'51,rep:55','}}],[0.889,0,0.9,{delim:{top:','56,mid:60,bot:58,rep:62',2017,'57,mid:61,bot:59,rep:62',2017,'56,bot:58,rep:62',2017,'57,bot:59,rep:62','}}],[0.889,0,1.8,{delim:{rep:','63',2025,'119}}],[0.889,0,0.3,{delim:{rep:62',2013,'120,bot:121,rep:63}}],[0.875',2001,'56,bot:59,rep:62}}],[0.875',2001,'57,bot:58,rep:62}}],[0.875',1929,'66}}],[0.875',1929,'67}}],[0.611',1937,'28}],[0.611',1937,'29','}],[0.833,0,1,{n:','71}],[1.11',',0.1,1.5],[','0.472,0,1.11,{ic:0.194,n:','73}],[','0.556,0,2.22,{ic:0.444}],[1.11,0',',1,{n:75}],[1.51,0','.1,1.5],[1.11,0',',1,{n:77}],[1.51,0',2050,',1,{n:79}],[1.51',2045,'1.06,0,1,{n:88}],[0.944,0,1,{n:89}],[',2046,'90',2043,'91',2043,'92',2043,'93',2043,'94',2043,'95}],[1.44',2045,'1.28',2045,2048,2050,2050,2050,2050,'.1,1.5],[0.944,0,1,{n:97}],[1.28',2045,'0.556,0.722,0,{n:','99','}],[1,0.75,0,{n:','100}],[1.44,0.75],[',2078,'102',2080,'103}],[1.44,0.75],[0.472',1937,'20}],[0.472',1937,'21}],[0.528',1937,'22}'],
  ['],[0.','528',',0.04,1.76,{n:','23}],[0.528',2,'24}],[0.528',2,'25}],[0.667',2,'26}],[0.667',2,'27','}],[1,0.04,','1.16,{n:113}],[1',2,'114',12,'2.36,{n:115',12,'2.96,{n:116}],[1.06,0,1.8,{delim:{top:118,bot:116,rep:117}}],[1.06,0,0.6],[1.06,0.04,0.56',0,'778',',0,0.6,{delim:{','top:126,','bot:127,rep:119','}}],[0.667',22,'top:120,rep:63}}],[0.667',22,'bot:121,rep:63}}],[0','.45,0.12],[0',30,30,30,'.778',22,23,'rep:119}}],[0.778',22,24,'}}]],cmti10:[[0.627',',0.683,0,{ic:0.','133}],[0.818,0.683',0,'767',41,'094}],[0.','692,0.683',0,'664',41,'153}],[0.743',41,'164}],[0.','716',41,'12}],[0.','767',41,'111}],[0.716',41,'0599}],[0.767',41,'111}],[0.716',41,'103}],[0.','613',',0.694',',0.194,{ic:0.','212,krn:{"39":0.104,"63":0.104,"33":0.104,"41":0.104,"93":0.104},lig:{"105":','14,"108":15}}],[0.','562',67,68,65,'588',67,68,65,'882',67,68,65,'894',67,68,65,'307',',0.431,0,{ic:0.','0767}],[0.','332,0.431',68,'0374}],[0.511',',0.694],[0.','511',',0.694,0,{ic:0.','0969','}],[0.511,0.','628',',0,{ic:0.','083}],[0.511',95,'108',97,'562',99,65,'831',93,'46,0,0.17',0,'537',67,68,'105}],[0.','716',88,'0751','}],[0.716',88,117,97,'528,0.0972,{ic:0.0919}],[0.883',41,56,'985',41,56,'767,0.732,0.0486,{ic:0.',46,'256,0.431,0,{krn:{"108":-0.256,"76":-0.321}}],[0.307',95,'124,lig:{"96":','60}}],[0.','514',95,'0696}],[0.818',67,68,'0662}],[0.769',93,'818',',0.75,0.0556',',{ic:0.136}],[0.','767',95,'0969}],[0.307',95,'124',',krn:{"','63":0.102,"33":0.102','},lig:{"39":34}}],[0.','409',',0.75,0.25,{ic:0.','162}],[0.409',153,'0369',97,'75',99,'149}],[0.767,0.562,0.0567,{ic:0.0369','}],[0.307,0.','106',',0.194],[0.','358',88,'0283,','lig:{"45":123}}],[0.','307,0.106',0,'511',153,'162',97,'644,0',',{ic:0.136}],[0.511,0.644,0',175,175,175,'.194',175,175,175,179,175,175,143,'307',88,'0582',161,'431',68,'0582',161,'5',68,'0756}],[0.767,0.367,-0.133,{ic:0.0662',97,'5',163,'511',95,'122,lig:{"96":62}}],[0.767',95,'096}],[0.743,0.683,0,{','krn:{"110":-0.0256,"108":-0.0256,"114":-0.0256,"117":-0.0256,"109":-0.0256,"116":-0.0256,"105":-0.0256,"67":-0.0256,"79":-0.0256,"71":-0.0256,"104":-0.0256,"98":-0.0256,"85":-0.0256,"107":-0.0256,"118":-0.0256,"119":-0.0256,"81":-','0.0256,"84','":-0.0767,"','89',208,'86','":-0.102,"','87',212,'101":-0.0511,"97":-0.0511,"111":-0.0511,"100":-0.0511,"99":-0.0511,"103":-0.0511,"113":-0.0511}}],[0.','704',41,65,'716',41,'145}],[0.','755',41,'094',149,'88','":-0.0256,"','87',227,'65',227,'86',227,'89','":-0.0256}}],[0.','678',41,56,'653',41,'133',149,'111',208,'101',208,'117','":-0.0767,"114":-0.0767,"97":-0.0767,"','65',212,'79":-0.0256,"67":-0.0256,"71":-0.0256,"81":-0.0256}}],[0.','774',41,'0872}],[0.743',41,53,'386',41,'158}],[0.525',41,'14}],[0.769',41,'145',149,251,'627,0.683,0,{krn:{"84',208,'89',208,'86',212,'87',212,215,'897',41,53,'743',41,53,'767',41,'094',149,'88',227,'87',227,'65',227,'86',227,'89',235,'678',41,'103',149,'65":-0.0767}}],[0.','767,0.683',68,46,'729',41,'0387,',206,'0.0256,"84',208,'89',208,'86',212,'87',212,215,'562',41,56,'716',41,'133',149,'121',208,'101',208,'111',248,'117',208,299,'743',41,53,'743',41,'184',149,'111',208,'101',208,'117',248,'65',212,251,'999',41,'184',149,299,'743',41,'158',149,251,'743',41,'194',149,'101',208,'111',248,'117',208,299,'613',41,221,'307',153,'188}],[0.514',95,'169}],[0.307',153,114,'511',95,'0665',161,'668',99,'118}],[0.307',95,132,'92}}],[0.','511',88,89,'46',95,'0631',149,215,'46',88,'0565',149,215,'511',95,'103',',krn:{"108":0.0511}}],[0.','46',88,117,149,215,'307',67,68,69,'12,"102":11,"108":13}}],[0.','46,0.431',68,'0885}],[0.','511',95,89,'307,0.655',99,'102',161,'655',68,221,'46',95,'108}],[0.','256',95,'103',405,'818',88,89,'562',88,'0767',149,'39":-0.102}}],[0.511',88,'0631',149,215,'511,0.431',68,'0631',149,215,'46,0.431',68,418,'422',88,'108',149,215,'409',88,'0821}],[0.332,0.615',99,'0949}],[0.537',88,89,'46',88,431,'664',88,'108',405,'464',88,56,'486,0.431',68,418,'409',88,'123}],[0.511',88,'0921',',lig:{"45":124}}],[1.','02',88,'0921}],[0.511',95,'122',97,'668',99,'116',97,'668',99,'105}]],cmbx10:[[0.692',',0.686],[0.','958',500,'894',500,'806',500,'767',500,'9',500,'831',500,'894',500,'831',500,'894',500,'831',500,'671',95,'109,krn:{"39":0.109,"63":0.109,"33":0.109,"41":0.109,"93":0.109},lig:{"105":',70,'639',93,'639',93,'958',93,'958',93,'319',',0.444],[0.','351,0.444',163,'575',93,'575',93,'575,0.','632',0,'575',93,541,'596',0,'869',93,'511,0,0.17',0,'597',93,'831',534,'894',534,541,'542,0.0972],[1.04,0.686],[1.17',500,'894,0.735,0.0486',0,'319',',0.444,0,{krn:{"','108":-0.319,"76":-0.378}}],[0.35',',0.694,0,{lig:{"96":',133,'603',93,'958',67,163,'575',142,0,'958',142,0,'894',93,'319',',0.694,0,{krn:{"','63":0.128,"33":0.128',151,'447',',0.75,0.25],[0.','447',587,541,'75',0,'894,0.633,0.133',0,'319,0.156',163,'383,0.444,0,{',167,595,0,'575',587,541,'644','],[0.575,0.644],[0.575,0.644',605,605,605,0,541,'644',0,'319',534,'319,0.444',163,'35,0.5',163,'894,0.391,-0.109',0,'543,0.5',163,'543',567,'62}}],[0.894',93,'869',',0.686,0,{krn:{"','116','":-0.0319,"','67',630,'79',630,'71',630,'85',630,'81',630,'84":-0.0958,"89":-0.0958,"86":-0.128,"87":-0.128}}],[','0.818',500,'831',500,'882',628,'88',630,'87',630,'65',630,'86',630,'89','":-0.0319}}],[0.','756',500,'724,0.686,0,{','krn:{"111":-0.0958,"101":-0.0958,"117":-0.0958,"114":-0.0958,"97":-0.0958,"65":-0.128,"79":-0.0319,"67":-0.0319,"71":-0.0319,"81":-0.0319}}],[','0.904',500,'9',500,'436',628,'73','":0.0319}}],[0.','594',500,'901',628,'79',630,'67',630,'71',630,'81',657,'692',628,641,'1.09',500,'9',500,'864',628,'88',630,'87',630,'65',630,'86',630,'89',657,'786',628,'65":-0.0958,"111',630,'101',630,'97',630,'46":-0.0958,"44":-0.0958}}],[0.','864,0.686',163,'862',628,'116',630,'67',630,'79',630,'71',630,'85',630,'81',630,641,'0.639',500,'8',628,'121',630,'101":-0.0958,"111":-0.0958,"114":-0.0958,"97":-0.0958,"65":-0.0958,"117":-0.0958}}],[0.','885',500,'869,0.686',99,'016,',661,'1.19,0.686',99,'016,',661,'0.869',628,'79',630,'67',630,'71',630,'81',657,'869,0.686',99,'0287',149,733,'703',500,'319',587,'603',93,'319',587,'575',93,'319',93,'319',567,388,'559',565,'118',630,'106":0.0639,"121',630,'119',657,'639',67,',0',',{krn:{"101":0.0319,"111":0.0319,"120":-0.0319,"100":0.0319,"99":0.0319,"113":0.0319,"118":-0.0319,"106":0.0639,"121":-0.0319,"119":-0.0319}}],[0.','511',565,'104',630,'107',657,'639',93,'527',534,'351',95,523,415,541,'444',68,'016',149,'106',669,'639',583,'116',630,'117',630,'98',630,'121',630,'118',630,'119',657,'319',93,'351',67,163,'607',583,'97":-0.0639,"101',630,'97',630,'111',630,'99',657,'319',93,'958',565,'116',630,'117',630,'98',630,'121',630,'118',630,'119',657,'639',565,'116',630,'117',630,'98',630,'121',630,'118',630,'119',657,541,'444,0',785,'639,0.444,0',179,785,'607,0.444',163,'474',534,'454',534,'447,0.635,0,{krn:{"121',630,'119',657,'639',565,'119',657,872,99,'016',149,'97":-0.0639,"101',630,'97',630,'111',630,'99',657,'831,0.444',99,'016',149,'101',630,'97',630,'111',630,'99',657,'607',534,872,68,'016',149,'111',630,'101',630,'97',630,709,'511',534,541,'444',99,'0319',486,'15,0.444',99,'0319}],[0.575',93,'575',93,'575',67,']]};','jsMath.Img','={fonts:[50,60,70,85,100,120,144,173,207,249,298,358,430],w:{"50":6.9,"60":8.3,"70":9.7,"85":11.8,"100":13.9,"120":16.7,"144":20,"173":24,"207":28.8,"249":34.6,"298":41.4,"358":49.8,"430":59.8},best:4,update:{},factor:1,loaded:0,SetFont',':function(','b){for(var a in b){if(!','this.update','[a]){',943,'[a]=[]}',943,'[a]=',943,'[a].concat(b[a])}},AddFont',941,'a,b){if(!',939,944,939,'[a]={}}jsMath.Add(',939,'[a],b)},UpdateFonts',':function(){','var e=',943,';','if(!this.loaded){','return}for(var a in e){for(var b=0;b<e[a].length;b++){var d=e[a][b];if(d=="all"){for(d in ','jsMath.TeX[','a]){',965,'a][d].img','={}}}else{',965,968,'={}}}}',943,'={}},BestSize',959,'var b=jsMath.em*this.factor;var a=','this.w[this.fonts[','0]];for(var c=1;c<this.fonts.length;c++){if(b<(',977,'c]]+2*a)/3){return c-1}a=',977,'c]]}return c-1},Scale',959,963,'return}this.best=this.BestSize();this.em=',939,'.w[this.fonts[this.best]];','this.scale','=(jsMath.em/this.em);','if(Math.abs(',988,'-1)<0.12){',988,'=1}},URL',941,'a,b,d){var c=(','jsMath.Controls.cookie.','alpha)?"/alpha/":"/plain/";if(d','==null){d','="def.js"}else{d="char"+d+".png"}if(b!=""){b+="/"}','return this.','root+a+c+b+d},LoadFont',941,'a){',963,'this.Init()}jsMath.Setup.Script(this.URL(a,""))},Init',959,'if(',997,'print||',997,'stayhires','){',997,'print=',997,1012,';this.factor*=3;if(!','jsMath.Controls.','isLocalCookie||!jsMath.Global.isLocal){',1019,'SetCookie(0)}if(','jsMath.Browser.','alphaPrintBug){',997,'alpha=0}}var b="0123456789ABCDEF";this.HexCode=[];for(var c=0;c<128;c++){var d=Math.floor(c/16);var a=c-16*d;this.HexCode[c]=b.charAt(d)+b.charAt(a)}this.loaded=1}};jsMath.HTML={Em',941,'a){',990,'a)<0.000001){a=0}var b=String(a);b=b.replace(/(\\.\\d\\d\\d).+/,"$1");return b+"em"},Spacer',941,'a){if(a==0){return""}return ',1023,'msieSpaceFix+\'<','span class="spacer" style="margin-','left:\'+this.Em(','a)+\'"></span>\'},Blank',941,'b,f,i,g){var a','="";var e="";','if(g){e+="border-left',':"+this.Em(','b)+" solid;";if(',1023,'widthAddsBorder){b=0}}if(b==0){if(',1023,'blankWidthBug){if(',1023,'quirks','){e+="width:1px',';";a=\'<',1035,'right:-1px"></span>\'}else{if(!g',1050,';margin-right:-1px;"}}}}else{e+="width',1042,'b)+";"}if(i==null){i=0}if(f){var c=this.Em(f+i);if(g&&f*jsMath.em<=1.5){c="1.5px";f=1.5/jsMath.em}e+="height:"+c+";"}if(',1023,'mozInlineBlockBug){i=-f}if(',1023,'msieBlockDepthBug','&&!g){i-=jsMath.d}if(i){e+="','vertical-align:"+','this.Em(-i)}return a+\'<span class="blank" ','style="\'+','e+\'"></span>\'},Rule',941,'a,b){if(b==null){b','=jsMath.TeX.default_rule_thickness}',1001,'Blank(a,b,0,1)},Strut',941,'a){',1001,'Blank(1,a,0,1)},msieStrut',941,'a){return','\'<img style="width:1px; height:\'+this.Em(a)+\'"/>\'},Class',941,'a,b){return\'<span class="\'+a','+\'">\'+b+"</span','>"},Place',941,'b,a,d){',990,'a)<0.0001){a=0}',990,'d)<0.0001){d=0}if(a||d){var c=\'<','span style="position',': relative',';\';if(a){c+=" margin-left',1042,'a)+";"}if(d){c+=" top:"+this.Em(-d)+";"}b=c',1081,'>"}return b},PlaceSeparateSkips',941,'e',',g,f,i,a,h){if(Math.abs(g)<0.0001){g=0}if(Math.abs(f)<0.0001){f=0}','if(f){var d=0;var c=0;','var b="";if(','i!=null){c=','a-h;d=i;b=" width',1042,'a-i)+";"}e=','this.Spacer','(d-c)+\'<',1089,1090,'; top:\'+this.Em(-f)+";left',1042,'c',')+";"+b+\'">\'+',1105,'(-d)+e+',1105,'(c)+"</span>"}if(g){e=',1105,'(g)+e}return e},PlaceAbsolute',941,'d',1098,'var c',1040,1100,1023,'msieRelativeClipBug&&',1101,1105,'(-i);g+=i;e=',1105,'(a-h)}if(',1023,'operaAbsoluteWidthBug){b=" width: "+this.Em(h+2)}d=\'<',1089,':absolute; ',1036,'g)+"; top',1042,'f',1112,'c+d+e+"&nbsp;</span>";','return d},','Absolute',941,'b,a,c,e,f){if(f!="none"){',990,'f)<0.0001){f=0}b=\'<',1089,1135,'top:\'+','jsMath.HTML.','Em(f)+\'; left:0em;">\'+b+"&nbsp;</span>"}if(e=="none"){e=0}b+=this.Blank((',1023,'lineBreakBug','?0:a),c-e,e);if(',1023,'msieAbsoluteBug){b=\'<',1089,':relative',';">\'+b+"</span>"}b=\'<',1089,1159,';\'+',1023,'msieInlineBlockFix',1081,'>";if(',1023,1154,'){b=\'<span style="display:inline-block; width:\'+',1151,'Em(a)+\'">\'+b+"</span>"}return b}};jsMath.Box=function(c,f,a,b,e){','if(e==null){','e=jsMath.d}this.type="typeset";this.w=a;this.h=b;this.d=e;this.bh=b;this.bd=e;this.x=0;this.y=0;this.mw=0;this.Mw=a;this.html=f;this.format=c};jsMath.Add(jsMath.Box,{defaultH:0,Null',959,'return ','new jsMath.Box("','null","",0,0,0)},Text',941,'l,k,b,m,j,i){var g=','jsMath.Typeset.AddClass(','k,l);g=','jsMath.Typeset.','AddStyle(','b,m,g);var c','=jsMath.EmBoxFor(','g);',960,1183,'TeX(b,m);var h=((k=="cmsy10"||k=="cmex10")?c.h-e.h:e.d*c.h/e.hd);var f=',1177,'text",l,c.w,c.h-h,h);f.style=b;f.size=m;f.tclass=k;if(i!=null){f.d=i*e.scale}else{f.d=0}if(j==null||j==1){f.h=0.9*e.M_height}else{f.h=1.1*e.x_height+e.scale*j}return f},TeX',941,'g,a,d,b){var h=',965,'a][g];if(h.d==null){h.d=0}if(h.h==null){h.h=0}if(h.img!=null&&h.c!=""){this.TeXIMG(a,g,',1183,'StyleSize(d,b))}var f=',1183,'TeX(d,b).scale;',960,1177,'text",h.c,h.w*f,h.h*f,h.d*f);e.style=d;e.size=b;if(h.tclass){e.tclass=h.tclass;if(h.img){e.bh=h.img.bh;e.bd=h.img.bd}else{e.bh=f*jsMath.h;e.bd=f*jsMath.d}}else{e.tclass=a;e.bh=f*',965,'a].h;e.bd=f*',965,'a].d;if(',1023,'msieFontBug&&','e','.html.match(/&#/)){','e','.html+=\'<span style="display:none">x</span','>\'}}return e},TeXfallback',941,'b,f,e,o){var m=',965,'f][b];if(!m.tclass){m.tclass=f}if(m.img!=null){',1001,'TeXnonfallback(b,f,e,o)}if(m.h!=null&&m.a==null){m.a=m.h-1.1*jsMath.TeX.x_height}var n=m.a;var l=m.d;var k=this.Text(m.c,m.tclass,e,o,n,l);var g=',1183,'TeX(e,o).scale;if(m.bh!=null){k.bh=m.bh*g;k.bd=m.bd*g}else{var j=k.bd+k.bh;var i=',1181,'k.tclass,k.html);i=',1183,1184,'e,o,i);k.bd',1186,'i+',1151,'Strut(j)).h-j;k.bh=j-k.bd;if(g==1){m.bh=k.bh;m.bd=k.bd}}if(jsMath.',1209,'k',1211,'k',1213,'>\'}return k},TeXIMG',941,'f,a,t){var o=',965,'f][a];if(o.img.size!=null&&o.img.size==t&&o.img.best!=null&&o.img.best==','jsMath.Img.best','){return}var g=(',939,'.scale!=1);var b=',1242,'+t-4;if(b<0){b=0;g=1','}else{if(','b>=','jsMath.Img.fonts','.length){','b=',1250,'.length-1',';g=1}}var s=',939,'[',1250,'[b]];var k=s[f][a];var i=1/',939,'.w[',1250,'[b]];if(b!=',1242,'+t-4){if(o.w!=null){i=o.w/k[0]}else{i*=',1250,'[t]/',1250,'[4]*',1250,'[',1242,']/',1250,'[b]}}var p=k[0]*i;var l=k[1]*i;var n=-k[2]*i;var q;var j=(o.w==null||Math.abs(o.w-p)<0.01)?"":" margin-right:"+',1151,'Em(o.w-p)+";";var e="";a=',939,'.HexCode[a];if(!g&&!',997,'scaleImg){if(',1023,'mozImageSizeBug||2*p<l||(',1023,'msieAlphaBug&&',997,'alpha)){e="height',':"+(k[1]*',1023,'imgScale',')+"px;"}e+=" width:"+(k[0]*',1023,1290,')+"px;";q=-k[2]+"px"}else{if(',1023,'mozImageSizeBug||2*p<l||(',1023,'msieAlphaBug&&',997,1287,':"+',1151,'Em(l*',1023,1290,')+";"}e+=" width:"+',1151,'Em(p*',1023,1290,')+";";q=',1151,'Em(n)}var r=(Math.abs(n)<0.01&&!',1023,'valignBug)?"":" ',1063,'q+";";var m=',939,'.URL(f,',1250,'[b],a);if(',1023,'msieAlphaBug&&',997,'alpha){','o.c=\'<img src="\'+','jsMath.blank+\'" ',1065,1023,'msieCenterBugFix+e+r+j','+" filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\'"+m+"\', sizingMethod=\'scale\');\\" />"}else{',1326,'m+\'" ',1065,1023,1330,'+\'" />\'}o.tclass="normal";o.img.bh=l+n;o.img.bd=-n;o.img.size=t;o.img.best=',1242,'},Space',941,1077,' ','new jsMath.Box("html",',1151,'Spacer(a),a,0,0)},Rule',941,'a,c){if(c==null){c',1069,'var b=',1151,'Rule(a,c);return ',1343,'b,a,c,0)},GetChar',941,'b,a){var d=',965,'a][b];','if(d.img!=null){this.TeXIMG(a,b',',4)}if(d.tclass',999,'.tclass=a}if(!d.computedW){d.w',1186,1181,'d.tclass,d.c)).w',';if(d.h',999,'.h=jsMath.Box.defaultH}if(','d.d',999,'.d=0}d.computedW=1}',1142,'DelimBestFit',941,'e,j,d,g){if(j==0&&d==0){return null}var i;var f;d','=jsMath.TeX.fam[','d];var a=(g.charAt(1)=="S");var b=(g.charAt(0)=="S");while(j!=null){i=',965,'d][j];if(i.h==null){i',1367,'i.d==null){i.d=0}f=i.h+i.d;if(i.delim','){return[j,d',',"",e]}if(a&&0.5*f>=e',1381,',"SS",0.5*f]}if(b&&0.7*f>=e',1381,',"S",0.7*f]}if(f>=e||i.n==null',1381,',"T",f]}j=i.n}return null},DelimExtendRelative',941,'k,x,r,A,e){var s=',965,'r][x];var q','=this.GetChar(s.delim.','top?s','.delim.top',':s.delim.rep,r);var ','b',1393,'rep,r);var p',1393,'bot?s','.delim.bot',1396,'f=',1181,'b.tclass,b.c);','var l=b.w;var v=b.h+b.d;var g;var d;var m;var o;var u;var t;if(s','.delim.mid){var ','z',1393,'mid,r);t','=Math.ceil((k-(','q.h+q.d)-(','z.h+z.d)-(p.h+p.d))/(2*(b.h+b.d',')));k=2*','t*(b.h+b.d)+(q.h+q.d)+(','z.h+z.d)+(p.h+p.d);if(e){g=0}else{g=k/2+A}d=g;m=',1151,'Place(',1181,'q.tclass,q.c),0,g-q.h',')+',1151,1419,1181,'p.tclass,p.c),-(','q.w+p.w)/2,g-(k-p.d))+',1151,1419,1181,'z.tclass,z.c),-(p.w+z.w)/2,g-(k+z.h-z.d)/2);o=(l-z','.w)/2;if(Math.abs(o)<0.0001){o=0}if(o){m+=jsMath.HTML.Spacer(o)}g-=q.h+q.d+b.h;for(u=0;u<t;u++){m+=jsMath.HTML.Place(f,-l,g-u*v)}','g-=k/2-b.h/2;for(u=0;u<t;u++){m+=',1151,1419,'f,-l,g-u*v)}}else{t',1412,1413,'p.h+p.d))/(b.h+b.d));if(q.h+q.d<0.9*(b.h+b.d)){t=Math.max(1,t)}k=',1416,'p.h+p.d);if(e){g=0}else{g=k/2+A}d=g;m=',1151,1419,1181,1421,');o=(l-q',1432,'m+=',1151,1419,1181,1426,'l+p.w)/2,d-(k-p.d))}if(e){v=q.h}else{v=k/2+A}var j=',1343,'m,b.w,v,k-v);j.bh=',965,'r].h;j.bd=',965,'r].d;return j},DelimExtendAbsolute',941,'k,v,p,z,d){var u=',965,'p];var q=u[v];var l;var o','=this.GetChar(q.delim.','top?q',1395,':q.delim.rep,p);var ','b',1464,'rep,p);var m',1464,'bot?q',1402,1467,'r;var t;var f;var e;var s;if(q',1408,'x',1464,'mid,p);r',1412,'o.h+o.d)-(','x.h+x.d-0.05',')-(','m.h+m.d-0.05','))/(2*(','b.h+b.d-0.05',1415,'r*(b.h+b.d-0.05)+(o.h+o.d)+(',1482,')+(',1484,');l=','jsMath.HTML.PlaceAbsolute(',1181,'o.tclass,o.c),0,0);t=',1486,';f=o.d-0.05+b.h;e=',1181,1406,'for(s=0;s<r;s++){l+=',1493,'e,0,f+s*t)}l+=',1493,1181,'x.tclass,x.c),0,f+r*t-b.h+x.h);f+=r*t+',1482,';for(s=0;s<r;s++){l+=',1493,'e,0,f+s*t)}l+=',1493,1181,'m.tclass,m.c),0,f+r*t-b.h+m.h)}','else{r',1412,1481,1484,'))/(',1486,'));k=',1488,1484,');l=',1493,1181,'o.tclass,o.c),0,0);t=',1486,';f=o.d-0.05+b.h;e=',1181,1406,'for(s=0;s<r;s++){l+=',1493,'e,0,f+s*t)}l+=',1493,1181,1512,'var j=o.w;if(d){t=o.h;f=0}else{t=k/2+z;f=t-o.h}if(',997,'font==="unicode"){if(',1023,'msie8HeightBug){','f-=jsMath.hd',1248,1023,1061,'){f+=jsMath.d}}}l=',1151,1143,'(l,j,u.h,"none",-f);var g=',1343,'l,b.w,t,k-t);g.bh=',965,'p].h;g.bd=',965,'p].d;return g},Delimiter',941,'b,h,c,g){var a=4;var f=',1183,'TeX(c,a);if(!h){',1001,'Space(f.nulldelimiterspace)}','var ','e=this.DelimBestFit(b,h[','2],h[1],c);if(e==null||e[3]<b){',1562,'4],h[3],c)}',1173,1001,1560,'if(e[2]==""){',1001,'DelimExtend(b,e[0],e[1],f.axis_height,g)}var d=jsMath.Box.TeX(e[0],e[1],e[2],a).Styled();if(!g){d.y=-((d.h+d.d)/2-d.d-f.axis_height)}',990,'d.y)<0.0001){d.y=0}if(d.y){d','=jsMath.Box.SetList','([d],e[2],a)}',1142,'GetCharCode',941,'b){var a',1375,'b[0]];',960,965,'a];var d=e[b[1]];',1358,'[1],4)}if(d.w',999,'.w',1186,1181,1364,'}if(d.font',999,'.font=a}',1142,'AddClass',941,'b,c,a){if(b==null){b=a}return ',1181,'b,c)},LayoutRelative',941,'z,J,B,k,l,p,G,A){if(B==null){B=[]}if(k==null){k=[]}if(l==null){l=[]}if(G==null){G=1}if(A==null){A=1}var L=jsMath.sizes[z]/100;var g=[];var v=[];var x=[];var e=-1000;var f=e;var m=e;var E;var C;var o',';for(E=0;E<J.length;E++){','if(l[E]==null){l[E]=0}o=J[E];v[E]=G*jsMath.h*L;x[E]=G*jsMath.d*L;for(C=0;C<o.length;C++){o[C]=o[C','].Remeasured();if(','o[C].h>v[E]){v[E]=o[C].h}if(o[C].d>x[E]){x[E]=o[C].d}if(C>=g',1251,'g[C]=o[C].w',1248,'o[C].w>g[C]){',1608,'}}if(o[C].bh>f){f=o[C].bh}if(o[C].bd>m){m=o[C].bd}}}if(l[J','.length]==null){','l[J.length]=0}if(f==e){f=0}if(m==e){m=0}var a=G','*(jsMath.hd-0.01)*','L;var u=(p||1)*L/6;var t="";var n=0;var I=0;var s;var F;var q;var r;var c;var b;for(C=0;C<g.length;C++){c=[];q=-v[0]-l[0];n=0',1603,'b=J[E][C','];if(b&&b.format!="null"){if(','B[C]=="l"){s=0',1248,'B[C]=="r"){s=g[C]-b.w}else{s=(g[C]-b.w)/2}}b.x=s-n;n=b.w+s;b.y=q;c[c.length]=b}if(E+1<J',1251,'q-=Math.max(a,x[E]+v[E+1])+u+l[E+1]}}if(k[C]==null){k[C]=L}if(c.length>0){r',1574,'(c,"T",z);t+=',1151,1419,'r.html,I,0);I=g[C]-r.w+k[C]}else{I+=k[C]}}s=-k[g',1254,'];q=(v',1254,')*u+l[0];for(E=0;E<g.length;E++){s+=g[E]+k[E]}for(E=0;E<v.length;E++){q','+=Math.max(a,','v[E]+x[E])+l[E+1]}F=q','/2+jsMath.TeX.axis_height;var ','K=q-F;t+=',1151,'Spacer(I-k[g',1254,']+A*L/6);t=',1151,1419,'t,A*L/6,F);r=',1343,'t,s+A*L/3,F,K);r.bh=f;r.bd=m;return r},LayoutAbsolute',941,'t,E,z,e,f,k,B,u){if(z==null){z=[]}',1173,'e=[]}if(f==null){f=[]}if(B==null){B=1}if(u==null){u=1}var G=jsMath.sizes[t]/100;var a=B',1615,'G;var p=(k||1)*G/6;var c=[];var q=[];var s=[];var r=0;var C;var n;var l;var A;var v;var g;','for(A=0;A<E.length;A++){','if(f[A]==null){f[A]=0}g=E[A];q[A]=B*jsMath.h*G;s[A]=B*jsMath.d*G;for(v=0;v<g.length;v++){g[v]=g[v',1605,'g[v].h>q[A]){q[A]=g[v].h}if(g[v].d>s[A]){s[A]=g[v].d}if(v>=c',1251,'c[v]=g[v].w',1248,'g[v].w>c[v]){',1658,'}}}}if(f[E',1613,'f[E.length]=0}l=(q',1254,')*p+f[0];for(A=0;A<q.length;A++){l',1634,'q[A]+s[A])+f[A+1]}C=l',1636,'F=l-C;var o="";var b;r=u*G/6;for(v=0;v<c.length;v++){l=q[0]-C+f[0];',1653,'b=E[A][v',1619,'z[v]&&z[v]=="','l"){n=0',1248,1674,'r"){n=c[v]-b.w}else{n=(c[v]-b.w)/2}}o+=',1493,'b.html,r+n,l-Math.max(0,b.bh-jsMath.h*G),b.mw,b.Mw,b.w)}if(A+1<E',1251,'l',1634,'s[A]+q[A+1])+p+f[A+1]}}if(e[v]==null){e[v]=G}r+=c[v]+e[v]}r=-e[c',1254,']+u*G/3;for(A=0;A<c.length;A++){r+=c[A]+e[A]}o=',1151,'Spacer(u*G/6',')+o+',1151,1688,');if(',1023,'spanHeightVaries){l=C-jsMath.h}else{l=0}if(',1023,1540,'l=F-jsMath.d}o=',1151,1143,'(o,r,C+F,F,l);var m=',1343,'o,r+u*G/3,C,F);return m},InternalMath',941,'h,l){if(!jsMath.safeHBoxes){h=h.replace(/@\\(([^)]*)\\)/g,"<$1>")}if(!h.match(/\\$|\\\\\\(/)){',1001,'Text(this.safeHTML(h),"normal","T",l).Styled()}',960,'0;var d=0;var g;var f="";var a=[];var b,j;while(e<h',1251,'g=h.charAt(e++);if(g','=="$"){if(f=="$"){','b=jsMath.Parse(h.slice(d,e-','1','),null,l);if(b.error){a[a.length]=this.Text(b.error,"error","T",l,1,0.2)}else{b.Atomize();a[a.length]=b.mlist.Typeset("T",l).Styled()}f="";d=e','}else{','j=this.safeHTML(h.slice(d',',e-1','));a[a.length]=this.Text(j,"normal","T",l,1,0.2);','f="$";d=e}}else{if(g=="\\\\"){',1710,'=="("&&f==""){',1716,',e-2',1718,'f=")";d=e',1248,'g==")"&&f==")"){',1712,'2',1714,'}}}}}',1716,1718,1001,'Set'],
  ['List(a,"T",l)},safeHTML',':function(','a){if(','jsMath.','safeHBoxes){a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}','return ','a},Set',1,'c,b,a',',d){if(','c&&c.type){if(c','.type=="','typeset"){',5,'c}if(c',11,'mlist"){c.mlist.','Atomize','(b,a);',5,'c.mlist','.Typeset(','b,a)}if(c',11,'text"){c=this.Text(c.text,c.tclass,b,a,c.ascend||null,c.descend||null);if(d!=0){c','.Styled()}',5,'c}c=this','.TeX(','c.c,c.font,b,a);if(d!=0){c',25,5,'c}',5,3,'Box.Null','()},SetList',1,'d,f,c){var a=[];var g;','for(var b=0;b<','d.length;b++){g=d[b];if(g',11,12,'g=','jsMath.mItem',21,'g)}a[a','.length]=','g}var e=new ','jsMath.Typeset','(a);',5,'e',21,'f,c)}});',3,'Package(',3,'Box,{Styled',':function(){','if(this.','format=="text"){','this.html','=',49,'.AddClass(','this.tclass',',',62,');',62,'=',49,'.AddStyle(','this.style',',this.size,',62,');delete ',66,';delete ',74,';this.format="html"}',5,'this},Remeasured',59,60,'w>0){var a=this.w;this.w=',3,'EmBoxFor(',62,').w;',60,'w','>this.Mw){this.Mw=this.w','}a=this.w/a;if(Math.abs(a-1)>0.05){this.h*=a;this.d*=a}}',5,'this}});',44,'=function(a',',b','){this.type','=a;',3,'Add(this,b)};',3,'Add(',44,',{Atom',1,'b,a){',5,'new ',44,'(b,{atom:1,nuc',':a})},TextAtom',1,'e,h,c,b,g','){var f=','new ',44,'(e,{atom:1,nuc:{type:"text",text:h,tclass:c}});if(b','!=null){f.nuc.','ascend=b}if(g',121,'descend=g}',5,'f},TeXAtom',1,'b,d,a){',5,'new ',44,113,':{type:"TeX",c:d,font:a}})},Fraction',1,'b,a,f,d,e,c){',5,'new ',44,'("fraction",{from:b,num:a,den:f,','thickness',':d,left:e,right:c})},Space',1,'a){',5,'new ',44,'("space",{w:a})},','Typeset',1,'a){',5,'new ',44,'("ord",{atom:1,nuc:a})},HTML',1,'a){',5,'new ',44,'("html",{html:a})}});',3,'mList','=function(d,a,b,c){','if(d){','this.mlist','=d}else{',165,'=[]}','if(c==null){c','="T"}if(b==null){b=4}','this.data','={openI:null,overI:null,overF:null,font:a,','size:b,style:c','};this.init={',173,'}};',3,'Package(',3,162,',{Add',1,'a){return(',165,'[','this.mlist.length',']=a)},Get',1,'a){',5,165,'[a]},Length',59,5,186,'},Last',59,'if(',186,'==0){',5,'null}',5,165,'[',186,'-1]},Range',1,'b,',2,'a==null){a=',186,'}',5,'new ',3,162,'(',165,'.slice(b,a+1))},Delete',1,'d,c){',169,'=d}if(',165,'.splice){',165,'.splice(d,c-d+1)}else{var a=[];',39,186,';b++){if(b<d||b>c){a[a',47,165,'[b]}}',165,'=a}},Open',1,'d){var c=this.Add(new ',44,'("boundary",{','data:',171,'}));var a=',171,';',171,'={};for(var b in a){',171,'[b]=a[b]}delete ',171,'.overI',79,171,'.overF;',171,'.openI=',186,'-1;if(d!=null){c.left=d}',5,'c},Close',1,'c){if(c!=null){c=new ',44,240,'right:c})}var e;var b=',171,'.openI;var f=',171,'.overI;var ','g=',171,254,171,'=',165,'[b].data;if(f){e=',44,'.Fraction(','g.name,{','type:"mlist",mlist:this.Range(','b+1,f-1)},{',280,'f)},g.',140,',g.left,g.right);if(c){var a=new ',3,162,'([',165,'[b],e,c]);e=',44,'.Atom("inner",{type:"mlist",mlist:a})}}else{var d=b+1;if(c){this.Add(c);d--}e=',44,'.Atom((c)?"inner":"ord",{',280,'d)})}this.Delete(b,this.Length());',5,'this.Add(e)},Over',59,'var b=',171,269,'c=',171,254,'var a=',44,278,'c.name,{',280,'open+1,b-1)},{',280,'b)},c.',140,',c.left,c.right);',165,'=[a]},',17,1,222,'var a;var e="";',74,'=d;this.size=c;',39,186,';b++){a=',165,'[b];a.delta=0;if(a',11,'choice"){',165,'=this.',17,'.choice(',74,',a,b,',165,');b--}else{',60,17,'[a.type]){var g=this.',17,'[a.type];g(',74,75,'a,e,this,b)}}e=a}if(a&&a',11,'bin"){a','.type="ord"}','if(',186,'>=2&&a',11,'boundary"&&',165,'[0].type=="boundary"){this.','AddDelimiters','(d,c)}},',357,1,'b,q){var p=-10000;var g=p;var k=p;for(var f=0;f<',186,';f++){var j=',165,'[f];if(j.atom||j',11,'box"){g','=Math.max(','g,j.nuc.h+j.nuc.y);k',368,'k,j.nuc.d-j.nuc.y)}}var e=',3,'TeX;var l=',49,28,'b,q).','axis_height',';var o',368,'g-l,k+l);var n',368,'Math.floor(e.integer*o/500)*e.delimiterfactor,e.integer*(2*o-e.delimitershortfall))/e.integer;var c=',165,'[0];var m=',165,'[',186,'-1];c.nuc=',3,'Box.Delimiter(','n,c.left,b);m.nuc=',3,390,'n,m.right,b);c.type="open";c.atom=1',79,'c.left;m.type="close";m.atom=1',79,'m.right},',148,1,'c,a){var b=new ',49,'(',165,');',5,'b',21,'c,a)}});',3,'Add(',3,162,'.prototype.',17,',{style',1,'d,c,a,e,b){b.','style=a.style},size',1,418,'size=a.size},phantom',1,8,'){var d=','a.nuc','=jsMath.Box.Set(','a.phantom',',c,b);if(a.h){d.','Remeasured();','d.html=',3,'HTML.Spacer','(d.w)}else{d.html="",d.w=d.Mw=d.mw=0}if(!a.v){','d.h=d.d=0','}d.bd=d.bh=0',79,428,';a.type="box"},','smash',1,8,425,'a.nuc',427,'a.smash',',c,b).',430,435,79,446,439,'raise',1,8,'){a.nuc',427,'a.nuc,c,b);var ','d=a.raise;','a.nuc.html','=',3,'HTML.Place(',460,',0,d,a.nuc.mw,a.nuc.Mw,a.nuc.w);a.nuc.h+=d;a.nuc.d-=d;a','.type="ord";','a.atom=1},lap',1,'d,c,a){var ','e',427,'a.nuc,','d,c).',430,'var b=[e];if(a.lap=="llap"){e.x=-e.w}','else{if(a.lap=="','rlap"){b[1]=',44,'.Space(-e.w)}',476,'ulap"){e.y=e.d;e.h=e.d=0}',476,'dlap"){e.y=-e.h;e.h=e.d=0}}}}a','.nuc=jsMath.Box.SetList','(b,d,c);if(a.lap=="ulap"||a.lap=="dlap"){a.nuc.h=a.nuc.d=0}a.type="box";delete a.atom},bin',1,'d,b,a,e){if(e&&e.type){var c=e.type;if(c=="bin"||c=="op"||c=="rel"||c=="open"||c=="punct"||c==""||(c=="',354,'e.left!="")){a.type="ord"}}else{a',349,'jsMath.mList.prototype.Atomize.SupSub(','d,b,a)},rel',1,8,9,'d.type&&','d',11,'bin"){d',349,491,8,')},close',1,8,9,496,'d',11,'bin"){d',349,491,8,')},punct',1,8,9,496,'d',11,'bin"){d',349,491,8,')},open',1,8,'){',491,8,')},inner',1,8,'){',491,8,')},','vcenter',1,8,'){var d',427,458,'e=',49,28,'c,b);d.y=e.',377,'-(d.h-d.d)/2;a.nuc=d;a',466,491,8,')},','overline',1,469,'g=',49,28,'d,c);var e',427,472,49,'.PrimeStyle(d),c).Remeasured();var b=g.default_rule_thickness;var f=jsMath.Box.Rule(e.w,b);f.x=-f.w;f.y','=e.h+3*b;a',484,'([e,f],d,c);a.nuc.','h+=b;a',466,491,'d,c,a)},','underline',1,469,'g=',49,28,'d,c);var e',427,472,49,564,'=-e.d-3*b-b;a',484,567,'d+=b;a',466,491,571,'radical',1,'b,m,g',425,49,28,'b,m);var k=',49,'.PrimeStyle(b);var ','f',427,'g.nuc,k,m).',430,'var l=d','.default_rule_thickness',';var c=l;if(b=="D"||b=="D\'"){c=d.x_height}var a=l+c/4;var e=',3,390,'f.h+f.d+a+l,[0,2,112,3,112],b,1);if(e.d>f.h+f.d+a){a=(a+e.d-f.h-f.d)/2}e.y=f.h+a;var j=',3,'Box.Rule(','f.w,l);j.y=e.y-l/2;j.h+=3*l/2;f.x=-f.w;var i=',49,'.UpStyle(',49,613,'b));var h',427,'g.root||null,i,m).',430,'if(g.root){h.y=0.55*(f.h+f.d+3*l+a)-f.d;e.x',368,'h.w-(11/18)*e.w,0);j.x=(7/18)*e.w;h.x=-(h.w+j.x)}g',484,'([e,h,j,f],b,m);g',466,491,'b,m,g)},accent',1,'b,q,j',117,49,28,'b,q);var m=',49,598,'i',427,'j.nuc,m,q);var o=i.w;var p;var k;var d=0;if(j.nuc',11,'TeX"){k=',3,'TeX[j.nuc.font];if(k[j.nuc.c].krn&&k.skewchar){p=k[j.nuc.c].krn[k.skewchar]}d=k[j.nuc.c].ic;if(d==null){d=0}}if(p==null){p=0}var l=j.accent[2];var e=',3,'TeX.fam[j.accent[1]];k=',3,'TeX[e];while(k[l].n&&k[k[l].n].w<=o){l=k[l].n}var n=Math.min(i.h,f.x_height);if(j.nuc',11,'TeX"){var ','h=',44,'.Atom("ord",j.nuc);h.sup=j.sup;h.sub=j.sub;h.delta=0;',491,'b,q,h);n+=(h.nuc.h-i.h);i=j.nuc=h.nuc',79,'j.sup',79,'j.sub}var g=',3,'Box',28,'l,e,b,q);g.y=i.h-n;g.x=-i.w+p+(o-g.w)/2;if(',3,'Browser.msieAccentBug){g.html+=',3,433,'(0.1);g.w+=0.1;g.Mw+=0.1}if(k[l].ic||d){g.x+=(d-(k[l].ic||0))*f.scale}j',484,'([i,g],b,q);if(j.nuc.w!=i.w){var a=',44,'.Space(','i.w-j.nuc.w);j',484,'([j.nuc,a],b,q)}j',466,491,'b,q,j)},op',1,'c,n,i',117,49,28,'c,n);var h;i.delta=0;var m=(c','.charAt(0)=="','D");if(i.limits==null&&m){i.limits=1}if(i.nuc',11,648,'b=',3,'TeX[i.nuc.font][','i.nuc.c];if(m&&b.n){i.nuc.c=b.n;b=',3,689,'b.n]}h=i.nuc',427,'i.nuc,c,n',');if(b.ic){i.delta=b.ic*f.scale;if(i.limits||!i.sub||',3,'Browser.msieIntegralBug','){h=i',484,'([h,',44,670,'i.delta)],c,n)}}h.y=-((h.h+h.d)/2-h.d-f.',377,');if(Math.abs(h.y)<0.0001){h.y=0}}if(!h){h=i.nuc',427,695,').Remeasured()}if(i.limits){var e=h.w;var k=h.w;var d=[h];var j=0;var l=0;if(i.sup){var g',427,'i.sup,',49,613,'c),n).',430,'g.x=((h.w-g.w)/2+i.delta/2)-k;j=f.big_op_spacing5;e',368,'e,g.w);k+=g.x+g.w;g.y=h.h+g.d+h.y+Math.max(f.big_op_spacing1,f.big_op_spacing3-g.d);d[d',47,'g',79,'i.sup}if(i.sub){var a',427,'i.sub,',49,'.DownStyle(','c),n).',430,'a.x=((h.w-a.w)/2-i.delta/2)-k;l=f.big_op_spacing5;e',368,'e,a.w);k+=a.x+a.w;a.y=-h.d-a.h+h.y-Math.max(f.big_op_spacing2,f.big_op_spacing4-a.h);d[d',47,'a',79,'i.sub}if(e>h.w){h.x=(e-h.w)/2;k+=h.x}if(k<e){d[d',47,44,670,'e-k)}i',484,'(d,c,n);i.nuc.h+=j;i.nuc.d+=l','}else{if(',3,698,'&&i.sub&&b&&b.ic){i',484,'([h,',3,'Box.Space(-b.ic*f.scale)],c,n)}else{if(h.y){i',484,'([h],c,n)}}',491,'c,n,i)}},ord',1,'a,j,g,b,f,e){if(g.nuc',11,'TeX"&&!g.sup&&!g.sub',425,'f.mlist[e+1];if(d&&d.atom&&d.type&&(d',11,'ord"||d',11,'op"||d',11,'bin"||d',11,'rel"||d',11,'open"||d',11,'close"||d',11,'punct")){if(d.nuc',11,'TeX"&&d.nuc.font==g.nuc.font){g.textsymbol=1;var h=',3,'TeX[g.nuc.font][g.nuc.c].krn;h*=',49,28,'a,j).scale;if(h&&h[d.nuc.c]){for(var c=f.mlist.length-1;c>e;c--){f.mlist[c+1]=f.mlist[c]}f.mlist[e+1]=',44,670,'h[d.nuc.c])}}}}',491,'a,j,g)},fraction',1,'x,n,c){var A=',49,28,'x,n);var l=0;if(c.',140,'!=null){l=c.',140,742,'c.from.match(/over/)){l=A',604,'}}var s=(x',683,'D");var g=(x=="D")?"T":(x=="D\'")?"T\'":',49,613,'x);var q=(s)?"T\'":',49,726,'x);var f',427,'c.num,g,n).',430,'var e',427,'c.den,q,n).',430,'var k;var j;var i;var o;var m;var h=(s)?A.delim1:A.delim2;var b=[',3,390,'h,c.left,x)];var y=',3,390,'h,c.right,x);if(f.w<e.w){f.x=(e.w-f.w)/2;e.x=-(f.w+f.x);i=e.w;b[1]=f;b[2]=e}else{e.x=(f.w-e.w)/2;f.x=-(e.w+e.x);i=f.w;b[1]=e;b[2]=f}if(s){k=A.num1;j=A.denom1}else{k=(l!=0)?A.num2:A.num3;j=A.denom2}if(l==0){o=(s)?7*A',604,':3*A',604,';m=(k-f.d',')-(e.h-j);if(m<o){','k+=(o-m)/2;j+=(o-m)/2}}else{o=(s)?3*l:l;var z=A.',377,';m=(k-f.d)-(z+l/2);if(m<o){k+=o-m}m=(z-l/2',824,'j+=o-m}var d=',3,610,'i,l);d.x=-i;d.y=z-l/2;b[b',47,'d}f.y=k;e.y=-j;b[b',47,'y;c',484,'(b,x,n);c',466,'c.atom=1',79,'c.num',79,'c.den;',491,'x,n,c)},SupSub',1,'e,w,k){var g=',49,28,'e,w);var o=k.nuc;var j=k.nuc',427,'k.nuc,e,w,0);if(j.format=="null"){j=k.nuc=',3,'Box.Text("","normal",e,w)}if(o',11,'TeX"){if(!k.textsymbol',425,3,'TeX[o.font][o.c];if(d.ic){k.delta=d.ic*g.scale;if(!k.sub){j=k',484,'([j,',3,'Box',670,'k.delta)],e,w);k.delta=0}}}else{k.delta=0}}if(!k.sup&&!k.sub){return}k.nuc.Styled();var h=',49,726,'e);var l=',49,613,'e);var c=',49,28,'l,w).sup_drop;var b=',49,28,'h,w).sub_drop;var n=0;var m=0;var f;if(o.type&&o.type!="text"&&o.type!="TeX"&&o.type!="null"){n=j.h-c;m=j.d+b}if(k.sub){var a',427,'k.sub,h,w);a=',3,'Box.SetList([','a,',44,'.Space(g.scriptspace)],e,w',')}if(!k.sup){a.y=-Math.max(m,g.sub1,a.h-(4/5)*',49,28,'h,w).x_height);k',484,'([j,a],e,w).Styled();delete k.sub;return}var i',427,'k.sup,l,w);i=',3,882,'i,',44,885,');if(e=="D"){f=g.sup1',742,'e','.charAt(','e','.length-1)=="\'"){','f=g.sup3}else{f=g.sup2}}n',368,'n,f,i.d+',49,28,'l,w).x_height/4);if(!k.sub){i.y=n;k',484,'([j,i],e,w',77,'k.sup;return}m',368,'m,',49,28,'h,w).sub2);var s=g',604,';if((n-i.d)-(a.h-m)<4*s){m=4*s+a.h-(n-i.d);f=(4/5)*g.x_height-(n-i.d);if(f>0){n+=f;m-=f}}i.',430,'a.',430,'i.y=n;a.y=-m;i.x=k.delta;if(i.w+i.x>a.w){i.x-=a.w;k',484,'([j,a,i],e,w)}else{a.x-=(i.w+i.x);k',484,'([j,i,a],e,w)}delete k.sup',79,'k.sub}});',49,98,100,'="typeset";',165,'=a};',3,'Add(',49,',{upStyle:{D:"S",T:"S","','D\'":"S\'","T\'":"S\'",S:"SS','",SS:"SS","','S\'":"SS\'","SS\'":"SS\'"},','downStyle:{D:"S\'",T:"S\'","',942,'\'",SS:"SS\'","',944,'UpStyle',1,'a){',5,'this.upStyle[a]},DownStyle',1,'a){',5,'this.downStyle[a]},PrimeStyle',1,2,'a',902,'a',904,5,'a}',5,'a+"\'"},StyleValue',1,'b,',2,'b=="S"||b=="S\'"){',5,'0.7*a}if(b=="SS"||b=="SS\'"){',5,'0.5*a}',5,'a},StyleSize',1,'b,a){if(b=="S"||b=="S\'"){a=Math.max(0,a-2)}else{if(b=="SS"||b=="SS\'"){a=Math.max(0,a-4)}}return ','a},TeX',1,979,3,'TeXparams[a]},AddStyle',1,8,'){if(c=="S"||c=="S\'"){b',368,'0,b-2)}else{if(c=="SS"||c=="SS\'"){b',368,'0,b-4)}}if(b!=4){a=\'<span class="size\'+b+\'">\'+a+"</span>"}',5,'a},AddClass',1,'a,b){if(a!=""&&a!="normal"){b=',3,'HTML.Class(a,b)}',5,'b}});',3,'Package(',49,',{DTsep:{ord',':{op:1,bin:2,rel:3,inner:1},','op',':{ord:1,op:1',',rel:3,inner:1},bin:{ord:2,op:2,open:2,inner:2},rel:{ord:3,op:3,open:3,inner:3},open:{},close',1004,'punct',1006,',rel:1,open:1,close',':1,punct:1,inner:1','},inner',1006,',bin:2,rel:3,open',1012,'}},SSsep:{ord:{op:1},op',1006,'},bin:{},rel:{},open:{},close:{op:1},punct:{},inner:{op:1}},sepW:["","thinmuskip","medmuskip","thickmuskip"],','GetSeparation',1,'a,d,b){if(a&&a.atom&&d.atom){var c=this.DTsep;if(b',683,'S"){c=this.SSsep}var e=c[a.type];if(e&&e[d.type]!=null){',5,3,'TeX[this.sepW[e[d.type]]]}}',5,'0},',148,1,222,74,323,'var g=-10000;this.w=0;this.mw=0;this.Mw=0;this.h=g;this.d=g;this.bh=this.h;this.bd=this.d;this.tbuf="";this.tx=0;',66,'="";','this.cbuf','="";this.hbuf="";this.hx=0;var a=null;var f;this.x=0;','this.dx=0;',39,186,';b++){f=a;a=',165,'[b];switch(a.type){case"size":','this.FlushClassed();','this.size=a.size;','a=f;break;case"','style":',1046,'if(',74,902,74,904,74,'=a.style+"\'"}else{',74,'=a.style}',1048,'space":if(typeof(a.w)=="object"){if(',74,902,'1)=="S"){a.w=0.5*a.w[0]/18',742,74,683,'S"){a.w=0.7*a.w[0]/18}else{a.w=a.w[0]/18}}}this.dx+=a.w-0;',1048,'html":',1046,'if(this.hbuf==""){this.hx=this.','x}','this.hbuf+=','a.html;a=f;break;default:if(!a.atom&&a.type!="box"){break}a.nuc.x+=this.dx+this.',1020,'(f,a,',74,');','if(a.nuc.x||a.nuc.y){','a.nuc',25,1040,'this.x=this.x+this.w;',60,'x','+a.nuc.x+a.nuc.','mw','<this.mw){this.mw=this.','x',1087,'mw}',60,'w',1087,'Mw',93,1087,'Mw}this.w+=a.nuc.w+a.nuc.x;if(a.nuc.',61,'if(',66,'!=a.nuc.tclass&&',66,'!=""){','this.FlushText','()}',60,'tbuf==""&&',1038,'==""){this.tx=this.x}this.tbuf+=',460,';',66,'=a.nuc.tclass}else{',1046,1080,'this.Place(a.nuc)}',1072,'x}',1074,460,'}this.h',368,'this.h,a.nuc.h+a.nuc.y);this.bh',368,'this.bh,a.nuc.bh);this.d',368,'this.d,a.nuc.d-a.nuc.y);this.bd',368,'this.bd,a.nuc.bd);break}}',1046,60,'dx){',1074,3,433,'(this.dx);this.w+=this.dx;',60,'w',93,'}',60,'w',1089,'w}}',60,'hbuf==""){',5,3,35,'()}',60,'h==g){this.h=0}',60,'d==g){this.d=0}var e=new ',3,'Box("html",this.hbuf,this.w,this.h,this.d);e.bh=this.bh;e.bd=this.bd;e.mw=this.mw;e.Mw=this.Mw;',5,'e},FlushText',59,60,'tbuf','==""){return}',1038,'+=',49,'.AddClass(',66,',this.tbuf);this.tbuf="";',66,'=""},FlushClassed',59,1106,'();',60,'cbuf',1164,1072,'tx}',1074,49,'.AddStyle(',74,75,1038,');',1038,'=""},Place',1,'b){var a=\'<','span style="position: relative',';\';if(b.x){a+=" margin-left:"+',3,'HTML.Em','(b.x)+";"}if(b.y){a+=" top:"+',3,1195,'(-b.y)+";"}b.html=a+\'">\'+b.html+"</span>";','b.h+=b.y;b.d-=b.y;b.x=0;b.y=0','},PlaceSeparateSkips',1,'b){if(b.y',425,'b.Mw-b.w;var c=b.mw;var a=b.Mw-b.mw;b.html=',3,433,'(c-d)+\'<',1192,'; top:\'+',3,1195,'(-b.y)+"; left:"+',3,1195,'(d)+"; width:"+',3,1195,'(a)+\';">\'+',3,433,'(-c)+b.html+',3,433,'(d)+"</span>"}if(b.x){b.html=',3,433,'(b.x)+b.html}',1200,'}});',3,'Parse',163,'var e=new ',3,'Parser','(d,a,b,c);e.Parse();',5,'e};',3,1236,163,'this.string=d;this.i=0;',165,'=new ',3,162,'(null,a,b,c)};',3,'Package(',3,1236,',{cmd:"\\\\",open:"{",close:"}",letter:/[a-z]/i,number:/[0-9]/,scriptargs:/^((math|text)..|mathcal|[hm]box)$/,mathchar:{"!":[5,0,33],"(":[4,0,40],")":[5,0,41],"*":[2,2,3],"+":[2,0,43],",":[6,1,59],"-":[2,2,0],".":[0,1,58],"/":[0,1,61],":":[3,0,58],";":[6,0,59],"<":[3,1,60],"=":[3,0,61],">":[3,1,62],"?":[5,0,63],"[":[4,0,91],"]":[5,0,93],"|":[0,2,106]},special:{"~":"Tilde","^":"HandleSuperscript",_:"HandleSubscript"," ":"Space","\\01','":"Space","\\','t',1254,'r',1254,'n":"Space","\'":"Prime","%":"HandleComment","&":"HandleEntry","#":"Hash"},mathchardef:{braceld:[0,3,122],bracerd:[0,3,123],bracelu:[0,3,124],braceru:[0,3,125],alpha:[0,1,11],beta:[0,1,12],gamma:[0,1,13],delta:[0,1,14],epsilon:[0,1,15],zeta:[0,1,16],eta:[0,1,17],theta:[0,1,18],iota:[0,1,19],kappa:[0,1,20],lambda:[0,1,21],mu:[0,1,22],nu:[0,1,23],xi:[0,1,24],pi:[0,1,25],rho:[0,1,26],sigma:[0,1,27],tau:[0,1,28],upsilon:[0,1,29],phi:[0,1,30],chi:[0,1,31],psi:[0,1,32],omega:[0,1,33],varepsilon:[0,1,34],vartheta:[0,1,35],varpi:[0,1,36],varrho:[0,1,37],varsigma:[0,1,38],varphi:[0,1,39],Gamma:[7,0,0],Delta:[7,0,1],Theta:[7,0,2],Lambda:[7,0,3],Xi:[7,0,4],Pi:[7,0,5],Sigma:[7,0,6],Upsilon:[7,0,7],Phi:[7,0,8],Psi:[7,0,9],Omega:[7,0,10],aleph:[0,2,64],imath:[0,1,123],jmath:[0,1,124],ell:[0,1,96],wp:[0,1,125],Re:[0,2,60],Im:[0,2,61],partial:[0,1,64],infty:[0,2,49],prime:[0,2,48],emptyset:[0,2,59],nabla:[0,2,114],surd:[1,2,112],top:[0,2,62],bot:[0,2,63],triangle:[0,2,52],forall:[0,2,56],exists:[0,2,57],neg:[0,2,58],lnot:[0,2,58],flat:[0,1,91],natural:[0,1,92],sharp:[0,1,93],clubsuit:[0,2,124],diamondsuit:[0,2,125],heartsuit:[0,2,126],spadesuit:[0,2,127],coprod:[1,3,96],bigvee:[1,3,87],bigwedge:[1,3,86],biguplus:[1,3,85],bigcap:[1,3,84],bigcup:[1,3,83],intop:[1,3,82],prod:[1,3,81],sum:[1,3,80],bigotimes:[1,3,78],bigoplus:[1,3,76],bigodot:[1,3,74],ointop:[1,3,72],bigsqcup:[1,3,70],smallint:[1,2,115],triangleleft:[2,1,47],triangleright:[2,1,46],bigtriangleup:[2,2,52],bigtriangledown:[2,2,53],wedge:[2,2,94],land:[2,2,94],vee:[2,2,95],lor:[2,2,95],cap:[2,2,92],cup:[2,2,91],ddagger:[2,2,122],dagger:[2,2,121],sqcap:[2,2,117],sqcup:[2,2,116],uplus:[2,2,93],amalg:[2,2,113],diamond:[2,2,5],bullet:[2,2,15],wr:[2,2,111],div:[2,2,4],odot:[2,2,12],oslash:[2,2,11],otimes:[2,2,10],ominus:[2,2,9],oplus:[2,2,8],mp:[2,2,7],pm:[2,2,6],circ:[2,2,14],bigcirc:[2,2,13],setminus:[2,2,110],cdot:[2,2,1],ast:[2,2,3],times:[2,2,2],star:[2,1,63],propto:[3,2,47],sqsubseteq:[3,2,118],sqsupseteq:[3,2,119],parallel:[3,2,107],mid:[3,2,106],dashv:[3,2,97],vdash:[3,2,96],leq:[3,2,20],le:[3,2,20],geq:[3,2,21],ge:[3,2,21],lt:[3,1,60],gt:[3,1,62],succ:[3,2,31],prec:[3,2,30],approx:[3,2,25],succeq:[3,2,23],preceq:[3,2,22],supset:[3,2,27],subset:[3,2,26],supseteq:[3,2,19],subseteq:[3,2,18],"in":[3,2,50],ni:[3,2,51],owns:[3,2,51],gg:[3,2,29],ll:[3,2,28],not:[3,2,54],sim:[3,2,24],simeq:[3,2,39],perp:[3,2,63],equiv:[3,2,17],asymp:[3,2,16],smile:[3,1,94],frown:[3,1,95],Leftrightarrow:[3,2,44],Leftarrow:[3,2,40],Rightarrow:[3,2,41],leftrightarrow:[3,2,36],leftarrow:[3,2,32],gets:[3,2,32],rightarrow:[3,2,33],to:[3,2,33],mapstochar:[3,2,55],leftharpoonup:[3,1,40],leftharpoondown:[3,1,41],rightharpoonup:[3,1,42],rightharpoondown:[3,1,43],nearrow:[3,2,37],searrow:[3,2,38],nwarrow:[3,2,45],swarrow:[3,2,46],minuschar:[3,2,0],hbarchar:[0,0,22],lhook:[3,1,44],rhook:[3,1,45],ldotp:[6,1,58],cdotp:[6,2,1],colon:[6,0,58],"#":[7,0,35],"$":[7,0,36],"%":[7,0,37],"&":[7,0,38]},delimiter:{"(":[0,0,40,3,0],")":[0,0,41,3,1],"[":[0,0,91,3,2],"]":[0,0,93,3,3],"<":[0,2,104,3,10],">":[0',',2,105,3,11],"\\\\','lt":[0',',2,104,3,10],"\\\\','gt":[0,2,105,3,11],"/":[0,0,47,3,14],"|":[0,2,106,3,12],".":[0,0,0,0,0],"\\\\":[','0,2,110,3,15],"\\\\','lmoustache":[4,3,122,3,64],"\\\\rmoustache":[5,3,123,3,65],"\\\\lgroup":[4,6,40,3,58],"\\\\rgroup":[5,6,41,3,59],"\\\\arrowvert','":[0,2,106,3,','60],"\\\\Arrowvert":[0,2,107,3,61],"\\\\bracevert',1266,'62],"\\\\Vert":[0,2,107,3,13],"\\\\|":[0,2,107,3,13],"\\\\vert',1266,'12],"\\\\uparrow":[3,2,34,3,120],"\\\\downarrow":[3,2,35,3,121],"\\\\updownarrow":[3,2,108,3,63],"\\\\Uparrow":[3,2,42,3,126],"\\\\Downarrow":[3,2,43,3,127],"\\\\Updownarrow":[3,2,109,3,119],"\\\\backslash":[',1264,'rangle":[5',1260,'langle":[4',1262,'rbrace":[5,2,103,3,9],"\\\\lbrace":[4,2,102,3,8],"\\\\}":[5,2,103,3,9],"\\\\{":[4,2,102,3,8],"\\\\rceil":[5,2,101,3,7],"\\\\lceil":[4,2,100,3,6],"\\\\rfloor":[5,2,99,3,5],"\\\\lfloor":[4,2,98,3,4],"\\\\lbrack":[0,0,91,3,2],"\\\\rbrack":[0,0,93,3,3]},macros:{displaystyle',':["HandleStyle","','D"],textstyle',1278,'T"],scriptstyle',1278,'S"],scriptscriptstyle',1278,'SS"],rm',':["HandleFont",','0],mit',1286,'1],oldstyle',1286,'1],cal',1286,'2],it',1286,'4],bf',1286,'6],font',':["Extension","','font"],left:"HandleLeft",right:"HandleRight",arcsin',':["NamedOp",0],','arccos',1300,'arctan',1300,'arg',1300,'cos',1300,'cosh',1300,'cot',1300,'coth',1300,'csc',1300,'deg',1300,'det',':"NamedOp",','dim',1300,'exp',1300,'gcd',1320,'hom',1300,'inf',1320,'ker',1300,'lg',1300,'lim',1320,'liminf',':["NamedOp",null,\'lim<span style="margin-left: \'+1/6+\'em"></span>','inf\'],limsup',1338,'sup\'],ln',1300,'log',1300,'max',1320,'min',1320,'Pr',1320,'sec',1300,'sin',1300,'sinh',1300,'sup',1320,'tan',1300,'tanh',1300,538,':["HandleAtom","',538,'"],',554,1364,554,'"],',572,1364,572,'"],over',':"HandleOver",','overwithdelims',1375,'atop',1375,'atopwithdelims',1375,'above',1375,'abovewithdelims',1375,'brace',':["HandleOver','","\\\\{","\\\\}"],brack',1387,'","[","]"],choose',1387,'","(",")"],overbrace',':["Extension","leaders"],','underbrace',1393,'overrightarrow',1393,'underrightarrow',1393,'overleftarrow',1393,'underleftarrow',1393,'overleftrightarrow',1393,'underleftrightarrow',1393,'overset',':["Extension","underset-overset"],','underset',1409,'llap',':"HandleLap",','rlap',1413,'ulap',1413,'dlap',1413,'raise:"RaiseLower",lower:"RaiseLower",moveleft',':"MoveLeftRight",','moveright',1421,'frac:"Frac",root:"Root",sqrt:"Sqrt",hbar',':["Macro","\\\\','hbarchar\\\\kern-.5em h"],ne',1425,'not="],neq',1425,'not="],notin',1425,'mathrel{\\\\','rlap{\\\\kern2mu/}}\\\\in"],cong',1425,1432,'lower2mu{\\\\mathrel{{\\\\rlap{=}\\\\raise6mu\\\\sim}}}}"],bmod',1425,'mathbin{\\\\rm mod}"],pmod',1425,'kern 18mu ({\\\\rm mod}\\\\,\\\\,#1)",1],"int":["Macro","\\\\intop\\\\nolimits"],oint',1425,'ointop\\\\nolimits"],doteq',1425,'buildrel\\\\textstyle.\\\\over="],ldots',1425,'mathinner{\\\\','ldotp\\\\ldotp\\\\ldotp}"],cdots',1425,1446,'cdotp\\\\cdotp\\\\cdotp}"],vdots',1425,1446,'rlap{\\\\raise8pt{.\\\\rule 0pt 6pt 0pt}}\\\\rlap{\\\\raise4pt{.}}.}"],ddots',1425,1446,'kern1mu\\\\raise7pt{\\\\rule 0pt 7pt 0pt .}\\\\kern2mu\\\\raise4pt{.}\\\\kern2mu\\\\raise1pt{.}\\\\kern1mu}"],joinrel',1425,1432,'kern-4mu}"],relbar',1425,1432,'smash-}"],Relbar',1425,'mathrel="],bowtie',1425,'mathrel\\\\triangleright\\\\joinrel\\\\mathrel\\\\triangleleft"],models',1425,'mathrel|\\\\joinrel="],mapsto',1425,1432,'mapstochar\\\\','rightarrow}"],rightleftharpoons',1425,538,'{\\\\',1432,'rlap{\\\\raise3mu{\\\\rightharpoonup}}}\\\\leftharpoondown}"],hookrightarrow',1425,'lhook','\\\\joinrel\\\\rightarrow','"],hookleftarrow',1425,'leftarrow\\\\joinrel\\\\','rhook"],Longrightarrow',1425,'Relbar\\\\joinrel\\\\','Rightarrow"],','longrightarrow',1425,'relbar',1480,'"],longleftarrow',1425,1483,'relbar"],Longleftarrow',1425,'Leftarrow\\\\joinrel\\\\','Relbar"],longmapsto',1425,1432,1471,'minuschar',1480,'}"],longleftrightarrow',1425,'leftarrow',1480,'"],','Longleftrightarrow',1425,1497,1487,'iff:["Macro","\\\\;\\\\',1509,'\\\\;"],mathcal',':["Macro","{\\\\','cal #1}",1],mathrm',1516,'rm #1}",1],mathbf',1516,'bf #1}",1],','mathbb',1516,1521,'mathit',1516,'it #1}",1],textrm',1425,'mathord{\\\\hbox{#1}}",1],textit',1425,'mathord{\\\\class{','textit','}{\\\\hbox{#1}}}",1],','textbf',1425,1531,1534,1533,'pmb',1425,'rlap{#1}\\\\kern1px{#1}",1],TeX:["Macro","T\\\\kern-.1667em\\\\lower.5ex{E}\\\\kern-.125em X"],limits:["Limits",1],nolimits:["Limits",0],",":["Spacer",1/6],":":["Spacer",1/6],">":["Spacer",2/9],";":["Spacer",5/18],"!":["Spacer",-1/6],enspace:["Spacer",1/2],quad:["Spacer",1],qquad:["Spacer",2],thinspace:["Spacer",1/6],negthinspace:["Spacer",-1/6],hskip:"Hskip",kern:"Hskip",rule:["Rule","colored"],space:["Rule","blank"],big',':["MakeBig","','ord",0.85],Big',1542,'ord",1.15],bigg',1542,'ord",1.45],Bigg',1542,'ord",1.75],bigl',1542,'open",0.85],Bigl',1542,'open",1.','15],biggl',1542,1553,'45],Biggl',1542,1553,'75],bigr',1542,'close",0.85],Bigr',1542,'close",1.','15],biggr',1542,1564,'45],Biggr',1542,1564,'75],bigm',1542,'rel",0.85],Bigm',1542,'rel",1.15],biggm',1542,'rel",1.45],Biggm',1542,'rel",1.75],mathord',1364,'ord"],mathop',1364,'op"],mathopen',1364,'open"],mathclose',1364,'close"],mathbin',1364,'bin"],mathrel',1364,'rel"],mathpunct',1364,'punct"],mathinner',1364,'inner"],','mathchoice',1298,1596,'"],buildrel:"BuildRel",hbox:"HBox",text:"HBox",mbox:"HBox",fbox',1298,'fbox"],strut:"Strut",mathstrut',1425,'vphantom{(}"],phantom:["Phantom",1,1],vphantom:["Phantom",1,0],hphantom:["Phantom",0,1],smash:"Smash",acute:["MathAccent",[7,0,19]],grave:["MathAccent",'],
  ['[','7,0,','18]],ddot',':["MathAccent",[',1,'127]],tilde',3,1,'126]],bar',3,1,'22]],breve',3,1,'21]],check',3,1,'20]],hat',3,1,'94]],vec',3,'0,1,126]],dot',3,1,'95]],widetilde',3,'0,3,101]],widehat',3,'0,3,98]],_:["Replace","ord","_","normal",-0.4,0.1]," ":["Replace","','ord","&nbsp;","normal','"],angle:["Macro","\\\\kern2.5mu\\\\raise1.54pt{\\\\rlap{\\\\scriptstyle \\\\char{cmsy10}{54}}\\\\kern1pt\\\\rule{.45em}{-1.2pt}{1.54pt}\\\\kern2.5mu}"],matrix:"Matrix",array:"Matrix",pmatrix:["Matrix','","(",")","c"],','cases:["Matrix","\\\\{",".",["l","l"],null,2],eqalign',':["Matrix",null,null,["','r","l"],[5/18],3,"D"],displaylines',34,'c"],null,3,"D"],cr:"','HandleRow','","\\\\":"',38,'",newline:"',38,'",noalign:"','HandleNoAlign','",eqalignno',34,'r","l","r"],[5/8,3],3,"D"],','leqalignno',34,47,'begin:"Begin",end:"End",tiny',':["HandleSize",','0],Tiny',52,'1],scriptsize',52,'2],small',52,'3],normalsize',52,'4],large',52,'5],Large',52,'6],LARGE',52,'7],huge',52,'8],Huge',52,'9],dots:["Macro","\\\\ldots"],','newcommand',':["Extension","',72,'"],newenvironment',73,72,'"],def',73,72,'"],color',73,'HTML"],','href',73,'HTML"],"class":["','Extension','","',83,'style',73,83,'cssId',73,83,'unicode',73,83,'bbox',73,'bbox"],require:"Require","char":"Char"},','environments',':{array:"Array",matrix',':["Array','",null,null,"c"],pmatrix',104,32,'bmatrix',104,'","[","]","c"],Bmatrix',104,'","\\\\{","\\\\}","c"],vmatrix',104,'","\\\\vert","\\\\vert","c"],Vmatrix',104,'","\\\\Vert","\\\\Vert","c"],cases',104,'","\\\\{",".","ll",null,2],eqnarray:["','Array",null,null,"rcl",[5/18,5/18],3,"D','"],"eqnarray*":["',119,'"],equation:"Equation","equation*":"Equation",align',73,'AMSmath','"],"align','*":["Extension","AMSmath"],','aligned',73,124,'"],','multline',73,124,'"],"',131,126,'split',73,124,'"],gather',73,124,'"],"gather',126,'gathered',73,124,'"]},AddSpecial',':function(','a){for(var b in a){','jsMath.Parser.prototype','.special[',151,'[b]]=a[b]}},Error',149,'a){this.i=','this.string','.length;','if(a','.error){this.error=a','.error}','else{if(!','this',160,'}}},nextIsSpace',':function(){','return ','this.string.charAt(this.i',').match(/[ \\n\\r\\t]/)},trimSpaces',149,'a){if(typeof(a)!="string"){',167,'a}',167,'a.replace(/^\\s+|\\s+$/g',',"")},','Process',149,'a){var ','c=','this.mlist.data',';a','=jsMath.Parse(','a,c.font,c.size,c.style);if(a','.error){this.Error(','a);','return null','}if(a.mlist.Length()==','0){',187,188,'1','){var b=','a.mlist.','Last();if(','b.atom&&b.type=="ord"&&b.nuc&&!b.sub&&!b.sup&&(b.nuc.type=="text"||b.nuc.type=="TeX")){',167,'b.nuc}}return{type:"mlist",mlist:a.mlist}},GetCommand',':function(){var ','a=/^([a-z]+|.) ?/i;var b=a.exec(','this.string.slice(this.i','));if(b){this.i+=b[1].length;',167,'b[1]}','this.i++;','return" "},GetArgument',149,'b,d){while','(this.nextIsSpace()){this.i','++}','if(this.','i>=',157,'.length){','if(!d){','this.Error("','Missing',' argument for "+b)}',187,'}if(',168,')==this.close){',215,216,'Extra close brace','")}',187,'}if(',168,')==this.cmd){',205,167,'this.cmd+','this.GetCommand','()}if(',168,')!=this.open){',167,168,'++)}var a=++this.i;var e=1;var f="";','while(this.i<this.string.length){','f=',168,'++);if(f','==this.cmd){this.i++}else{if(','f==this.open){e++}else{if(f==this.close){','if(e==0){',216,225,'");',187,'}if(--e==0){',167,157,'.slice(a,this.i-1)}}}}}',216,'Missing close brace','");',187,'},','ProcessArg',149,'b){var ','a=','this.GetArgument(','b);','if(this.error){return',' null}','return this.Process(a)},','ProcessScriptArg',149,'c){','var a=',265,'c);',267,268,'if(a.charAt(0)==this.cmd',193,'a.substr(1);if(b=="frac"){a+="{"+',265,'b)+"}";',267,268,'a+="{"+',265,'b)+"}";',267,' null}}else{if(b','=="sqrt"){a+="["+','this.GetBrackets(','b)+"]";',267,268,'a+="{"+',265,'b)+"}";',267,289,'.match(this.scriptargs)){a+="{"+',265,'b)+"}";',267,' null}}}}}',269,'GetDelimiter',149,'a){while',209,'++}var b=',168,');',211,'i<',157,214,205,'if(b','==this.cmd){','b="\\\\"+',234,'(a);',267,' null}}','if(','this.delimiter[','b]!=null){',167,326,'b]}}',216,217,' or unrecognized delimiter for "+a);',187,'},GetDimen',149,'a,d){var ','b;var c=0;if',209,'++}if(',168,')=="{"){b=',265,'a)}else{b=',201,');c=1}',167,'this.ParseDimen(','b,a,c,d)},ParseDimen',149,'c,b,e,f){',273,'c.match(/^\\s*([-+]?(\\.\\d+|\\d+(\\.\\d*)?))(pt|em|ex|mu|px)/);if(!a){',216,217,' dimension or its units for "+b);',187,'}if(e){this.i+=a[0].length;if',209,'++}}var g=a[1]-0;if(a[4]=="px"){g/=jsMath.em','}else{if(a[4]=="','pt"){g/=10',361,'ex"){g*=','jsMath.TeX','.x_height',361,'mu"){if(f){g=g/18}else{g=[g,"mu"]}}}}}',167,'g},GetNext',166,'while',209,'++}',167,168,')},GetBrackets',149,179,'e','=this.GetNext();if(','e!="["){return""}var d=++this.i;var b=0;',241,'e=',168,'++);if(e=="{"){b++}else{if(e=="}"){','if(b==0){',216,225,' while looking for',' \']\'");',187,'}b--}else{if(e',245,'e=="]"){',387,167,157,'.slice(d,this.i-1)}}}}}}',216,'Couldn\'t find',' closing \']\' for argument to',' "+this.cmd','+a);',187,'},GetUpto',149,'b,d){while',209,'++}var g=this.i;var e=0;',241,'var f=',168,244,'=="{"){e++}else{if(f=="}"){',247,216,225,390,403,'+d);',187,'}e--}else{if(f',319,'if(',201,',this.i+','5)=="begin"){e++;this.i+=4}else{if(',201,427,'3)=="end"){if(e>0){e--;this.i+=2}}}',247,'if(',201,427,'d.length)==d){f=',168,'+d','.length);','if(f.match(/[^a-z]/i)||!d.match(/[a-z]/i)){',273,157,'.slice(g,this.i-1);this.i+=d',158,167,'a}}}this.i++}}}}',216,401,403,'+d+" for "+b);',187,'},','ProcessUpto',149,'b,c){var ','a=this.GetUpto(b,c);',267,268,269,'GetEnd',149,'c){var a="";var b="";while(b!=c){a+=this.GetUpto("begin{"+c+"}","end");',267,268,'b=','this.GetArgument(this.cmd','+"end");',267,324,167,'a},Space',':function(){},','Prime',149,'d',193,'this.mlist.',195,'b==null||(!b.atom&&b','.type!="box"&&','b','.type!="frac")){','b=','this.mlist.Add(jsMath.mItem.','Atom("ord",{type:null}))}','if(b.sup){',216,'Prime causes double exponent',': use braces to clarify");return','}var a','="";while(d=="\'"){a+=this.cmd+"prime";d',381,'d=="\'"){this.i++}}b.sup=this.',177,'(a);b.sup.isPrime=1},RaiseLower',149,179,'b','=this.GetDimen(this.cmd+','a,1);',267,'}var c','=this.ProcessScriptArg','(',233,'a);',267,'}if(a=="lower"){b=-b}','this.mlist.Add(new jsMath.mItem("','raise",{nuc:c,raise:b}))},MoveLeftRight',149,263,'a',499,'b,1);',267,'}var c',503,'(',233,'b);',267,'}if(b=="moveleft"){a=-a}',484,'Space(a','));',484,'Atom("ord",c));',484,'Space(-a))},Require',149,179,'b=',466,404,267,'}b=','jsMath.Extension','.URL(b);if(','jsMath.Setup.','loaded[b]){return}','this.Extension(null,[','b])},',87,149,'a,b){','jsMath.Translate','.restart=1;if(a','!=null){','delete ',151,'[b[1]||"macros"][a]}',538,'.Require(b[0],',547,'.asynchronous',');throw"restart"},Frac',149,263,'a','=this.ProcessArg(this.cmd+','b);',267,'}var c',561,'b);',267,'}',484,'Fraction("over",a,c))},Sqrt',149,263,'d=',291,233,'b);',267,490,561,'b);',267,'}var c=jsMath.mItem.Atom("','radical",a);','if(d!=""){c.root=this.',177,'(d);',267,'}}',477,'Add(c)},','Root',149,263,'d=this.',453,'(',233,'b,"of");',267,490,561,'b);',267,582,583,'c.root=d;',477,590,'BuildRel',149,179,'b=this.',453,'(',233,'a,"over");',267,'}var d',561,'a);',267,582,'op",d);c.limits=1;c.sup=b;',477,590,'MakeBig',149,337,'c=d[0];var b=d[1]*jsMath.p_height;var e','=this.GetDelimiter(this.cmd+','a);',267,'}',484,'Atom(c,','jsMath.Box.Delimiter(','b,e,"T")))},Char',149,263,'a=',466,'+b);',267,'}var c=',466,'+b);',267,'}if(!',365,'[a]){',365,'[a]=[];',542,'jsMath.Font.URL(a',')])}else{',484,'Typeset(','jsMath.Box.TeX(c-0,a,',181,'.style,',181,'.size)))}},Matrix',149,'b,h){var e=',181,';var a=',466,'+b);',267,'}var g=','new jsMath.','Parser(a','+this.cmd+"\\\\",null,','e.size,h[5]||"T");g.matrix=b;g.row=[];g.table=[];g.rspacing=[];g.Parse();if(g',185,'g);return}g.',38,'(',515,'var d','=jsMath.Box.','Layout(e.size,g.table,h[2]||null,h[3]||null,g.rspacing,h[4]||null);if(h[0]&&h[1]){',412,636,'d.h+d','.d-jsMath.hd/4,this.delimiter[','h[0]],"T");var c=',636,'d.h+d',686,'h[1]],"T");d',681,'SetList([','f,d,c],e.style,e.size)}',484,'Atom((h','[0]?"inner":"ord"),','d))},HandleEntry',149,'b){if(!this.matrix){this.Error(b','+" can only appear in a matrix or array");return}if(',181,'.openI',549,273,477,'Get(',181,'.openI);if','(a.left){',216,217,403,'+"right','")}else{',216,257,'")}}if(',181,'.overI',549,477,'Over()}var d=',181,';',477,'Atomize(','d.style,d.size);','var c=',477,657,728,'c.entry=d.entry;delete d.entry;if(!c.entry){c.entry={}}this.row[','this.row.length',']=c;this.mlist=',671,'mList(null,null,d.size,d.style)},',38,149,'a,c){var b;if(!this.matrix){','this.Error(this.cmd+a',701,'a=="\\\\"){b=',291,233,'a);',267,'}if(b){b=',348,'b,',233,'a,0,1)}}this.HandleEntry(a);if(!c||',734,'>1||this.row[0].format!="null"){this.table[this.table.length]=this.row}if(b){','this.rspacing[this.table.length',']=b}this.row=[]},',44,149,263,'a=',466,'+b);',267,644,'a.replace(/^.*(vskip|vspace)([^a-z])/i,"$2");if(c.length==a',214,'return}var ','e=',348,'c,',233,'RegExp.$1,0,1);',267,'}',755,']=(',755,']||0)+e},Array',149,455,'e=c[2];var i=c[3];if(!e){e=',466,'+"begin{"+b+"}");',267,'}}e=e.replace(/[^clr]/g,"");e=e.split("");var g=',181,666,'c[5]||"T";var k=this.GetEnd(b);',267,'}',412,671,'Parser(k',673,'g.size,a);f.matrix=b;f.row=[];f.table=[];f.rspacing=[];f.Parse();if(f',185,'f);return}f.',38,'(',515,'var h',681,'Layout(g.size,f.table,e,i,f.rspacing,c[4],c[6],c[7]);if(c[0]&&c[1]){var d=',636,'h.h+h',686,'c[0]],"T");var j=',636,'h.h+h',686,'c[1]],"T");h',681,693,'d,h,j],g.style,g.size)}',484,'Atom((c',697,'h))},Begin',149,179,'b=',466,404,267,'}if(b.match(/[^a-z*]/i)){this.Error(\'Invalid environment name "\'+b+\'"\');return}if(!this.',102,'[b]){this.Error(\'Unknown environment "\'+b+\'"\');return',644,'this.',102,'[b];if(typeof(','c',')=="string"){','c=[c]}this[c[0]](b,c.slice(1))},End',149,179,'b=',466,404,267,'}',741,'+"{"+b+"} without matching',403,'+"begin")},Equation',149,263,'a=this.GetEnd(b);',267,'}',157,'=a+',201,');this.i=0},Spacer',149,'b,a){',484,525,'-0))},Hskip',149,263,'a',499,'b);',267,'}',484,525,'))},HBox',149,179,'c=',466,404,267,'}var b',681,'InternalMath(c,',181,'.size);',484,657,'b))},Rule',149,'b,f){var a',499,515,267,'}var e',499,515,267,'}var g',499,515,267,'}e+=g;var c;if(e!=0){e=Math.max(1.05/jsMath.em,e)}if(e==0||a==0||f=="blank"){c=','jsMath.HTML.','Blank(a,e)}else{c=',898,'Rule(a,e)}if(g){c=\'<span style="vertical-align:\'+',898,'Em(-g)+\'">\'+c','+"</span>"}',484,657,671,'Box("html",c,a,e-g,g)))},Strut',199,'a=',181,'.size;var b',681,'Text("","normal","T",a).Styled();b.bh=b.bd=0;b.h=0.8;b.d=0.3;b.w=b.Mw=0;',484,657,'b))},Phantom',149,455,'a',561,'b);',267,'}',509,'phantom",{phantom:a,v:c[0],h:c[1]}))},Smash',149,455,'a',561,'b);',267,'}',509,'smash",{smash:a}))},MathAccent',149,'b,',179,'e',561,'b);',267,'}var d','=jsMath.mItem.','Atom("accent",e);d.accent=a[0];',477,'Add(d)},NamedOp',149,'c,f){var b=(c.match(/[^acegm-su-z]/))?1:0;var g=(c.match(/[gjpqy]/))?0.2:0;if(f[1]){c=f[1]}var e',944,'TextAtom("','op",c,',365,'.fam[0],b,g);if(f[0]!=null){e.limits=f[0]}',477,'Add(e)},Limits',149,'a,c',193,477,'Last();if(!b||b.type!="op"){',741,'+" is allowed only on operators");return}b.limits=c[0]},Macro',149,'b,d){var e=d[0];if(d[1]){var a=[];','for(var c=0;c<','d[1];c++){a[a.length]=',466,'+b);',267,'}}e=this.','SubstituteArgs','(a,e)}',157,'=','this.AddArgs(e,',201,'));this.i=0},',972,149,'b,',179,'f="";var e="";var g;var d=0;while(d<a',214,'g=a.charAt(d++);if(g',319,'f+=g+a.charAt(d++)}else{if(g=="#"){',985,'=="#"){f+=g}',162,'g.match(/[1-9]/)||g>b',214,216,'Illegal ','macro parameter ','reference");',187,'}e=this.AddArgs(',976,'f),b[g-1]);f=""}}else{f+=g}}}',167,976,'f)},AddArgs',149,856,'if(a.match','(/^[a-z]/i)&&b.match(/(^|[^\\\\])(\\\\\\\\)*\\\\[a-z]+$/i)){b+=" "}',167,'b+a},Replace',149,546,484,'TextAtom(','b[0],b[1],b[2','],b[3]))},Hash',149,'a){',216,'You can\'t use \'',995,'character #\' in math mode")},Tilde',149,'a){',484,951,30,'"))},HandleLap',149,179,612,261,'();',267,'}b=',509,'lap",{nuc:b,lap:a}))},HandleAtom',149,455,'a',561,'b);',267,'}',484,'Atom(c[0],a))},HandleMathCode',149,'a,b','){this.HandleTeXchar(',1014,'])},HandleTeXchar',149,'b,a,c){if(b==7&&',181,'.font',549,'a=',181,'.font}a=',365,'.fam[a];if(!',365,'[a]){',365,'[a]=[];',542,654,')])}else{',484,'TeXAtom(',365,'.atom[b],c,a))}},','HandleVariable',149,'a',1048,'7,1,','a.charCodeAt(0))},','HandleNumber',149,'a',1048,1,1077,'HandleOther',149,'a){',484,951,'ord",a,"normal"))},HandleComment',199,'a;',241,'a=',168,'++);if(a=="\\r"||a=="\\n"){return}}},HandleStyle',149,546,181,'.style=b[0];',509,'style",{style:b[0]}))},HandleSize',149,546,181,'.size=b[0];',509,'size",{size:b[0]}))},HandleFont',149,856,181,'.font=a[0]},HandleCS',199,'b=',234,'();',267,'}',211,'macros[b]){',273,'this','.macros',831,'a',833,'a=[a]}this[a[0]](b,a.slice(1','));return}',211,'mathchardef','[','b]){this.HandleMathCode(b,this.',1129,'[b]);return}if(',326,233,1131,'delimiter[',233,'b].slice(0,3',1127,216,'Unknown control sequence \'"+',233,'b+"\'")},HandleOpen',166,477,'Open()},HandleClose',166,'if(',181,703,'==null){',216,225,'");',767,'a=',477,'Get(',181,709,'(!a||a.left',1152,477,'Close()}else{',216,225,' or missing',403,714,'");return}},HandleLeft',149,179,'b',630,'a);',267,'}',477,'Open(b)},HandleRight',149,263,'c',630,'b);',267,490,'=',477,'Get(',181,709,'(a&&a.left',549,477,'Close(c)}else{',216,'Extra open brace or missing',403,'+"left")}},HandleOver',149,546,'if(',181,720,549,216,'Ambiguous use of',403,404,'return}',181,720,'=',477,'Length();',181,'.overF={name:a};if(b.length>0){',181,'.overF.','left=',326,'b[0]];',181,1220,'right=',326,'b[1]]}else{',1006,'(/withdelims$/)){',181,1220,'left',630,'a);',267,'}',181,1220,'right',630,'a);',267,'}}else{',181,1220,'left=null;',181,1220,1226,'null}}',1006,'(/^above/)){',181,1220,'thickness',499,'a,1);',267,1244,181,1220,'thickness=null}},HandleSuperscript',199,'a=',477,195,181,720,'==',477,'Length()){a=null}','if(a==null','||(!a.atom&&a',480,'a',482,'a=',484,485,'if(a.sup){if(a.sup.isPrime){a=',484,485,'else{',216,'Double exponent',489,'}}a.sup',503,'("superscript");',267,'}},HandleSubscript',199,'a=',477,195,181,720,'==',477,'Length()){a=null}',1273,'||(!a.atom&&a',480,'a',482,'a=',484,485,'if(a.sub){',216,'Double subscripts',489,'}a.sub',503,'("subscript");',267,'}},Parse',199,'b;',241,'b=',168,'++);',211,'mathchar[',1131,'mathchar[b])}else{',211,'special[b]){this[this',152,'b]](b)}else{',211,'letter','.test(b)){this.',1072,'(b)}else{',211,'number',1335,1078,1337,'this.',1084,'(b)}}}}}if(',181,703,549,273,477,'Get(',181,709,'(a.left){',216,217,403,714,715,216,257,'")}}if(',181,720,549,477,'Over()}},Atomize',199,'a=',477,'init;if(!this.error){',477,727,'a.style,a.size)}},Typeset',199,'f=',477,'init;var ',594,'typeset=',477,657,'f.style,f',880,267,'\'<span class="error">\'+this.error',904,'if(d.format=="null"){return""}d.Styled().Remeasured();var e=0;var c=0;if(d.bh>d.h&&','d.bh>jsMath.h+0.001','){e=1}if(d.bd>d.d&&d.bd>jsMath.d+0.001){e=1}if(d.h>jsMath.h||d.d>jsMath.d){c=1}var b=d.html;if(e){if(','jsMath.Browser.','allowAbsolute){var g=(',1389,'?jsMath.h-d.bh:0);b=',898,'Absolute(b,d.w,jsMath.h,0,g)}else{if(',1391,'valignBug){','b=\'<span style="line-height:\'+jsMath.HTML.Em(jsMath.d',')+\';">\'+b',904,162,1391,'operaLineHeightBug){',273,898,'Em(Math.max(0,d.bd-jsMath.hd)/3);',1399,')+"; position:relative; top:"+a+"; vertical-align:"+a+\'">\'+b+"</span>"}}}c=1}if(c){b+=',898,'Blank(0,d.h+0.05,d.d+0.05)}return\'<nobr><span class="scale">\'+b+"</span></nobr>"}});',151,'.AddSpecial({cmd:"HandleCS",open:"HandleOpen",close:"HandleClose"});','jsMath.Add(jsMath,{','Macro',149,179,'c=',151,1122,';c[a]=["Macro"];for(var b=1;b<arguments',158,'b++){c[a][c[a].length]=arguments[b]}}});',538,'={safeRequire:1,Macro',149,'a,',263,'c=',151,1122,';if(b',1152,'b=a}c[a]=["',87,'",b]},LaTeX',149,'b,',179,'c=',151,'.',102,';c[b]=["Extension",','a,"',102,'"]},Font',149,856,1273,'){a=b+"10"}var c=',151,1122,1444,654,')]},MathChar',149,'d,',179,'e=',365,'.famName[d','];if(e',1152,'e=',365,'.fam',158,365,'.fam[e]=d;',365,1462,']=e}var b=',151,'.',1129,';for(var f in a){b[f]=[a[f][0],e,a[f][1]]}},Require',149,856,211,'safeRequire&&(b.match(/\\.\\.\\/|[^-a-z0-9.\\/:_+=%~]/i)||(b.match(/:/)&&b.substr(0,jsMath.root.length)!=jsMath.root))){',540,'loaded[b]=1;return}',540,'Script(this.URL(b),a)},URL',149,'a){a=',175,',"");if(!a.match(/^([a-z]+:|\\/|fonts|extensions\\/)/i)){a="extensions/"+a}if(!a.match(/\\.js$/)){a+=".js"}',167,'a}};',1414,177,149,'a){',540,'Body();','jsMath.Script.','Push(',547,',"','Asynchronous','",a)},','ProcessBeforeShowing',149,'a){',540,1497,'var b=(','jsMath.Controls.cookie.','asynch?"',1502,'":"','Synchronous','");',1498,1499,547,',b,a)},','ProcessElement',149,'a){',540,1497,1498,1499,547,',"ProcessOne",a)}});',547,'={element:[],cancel:0,Parse',149,'d,c,',179,'b=','jsMath.Global.','cache[d];if(!','b[jsMath.em',']){',1537,']={}}',412,1537,'][c];if(!f||',179,'e',183,'c,null,null,d);e.Atomize();f=e.Typeset();if(!a){',1537,'][c]=f}}',167,'f},TextMode',149,'b,a){this.Parse("','T",b,a)},DisplayMode',149,1553,'D",b,a)},','GetElementText',149,'b){if(','b.childNodes.length','==1&&','b.childNodes[','0].nodeName==="#','comment"){',273,1563,'0].nodeValue.match(/^\\[CDATA\\[(.*)\\]\\]$/);if(a',549,167,'a[1]}}var c=this.','recursiveElementText','(b);b.alt=c;if(c.search("&")>=0){','c=c.replace(/&','lt;/g,"<");',1574,'gt;/g,">");',1574,'quot;/g,\'"\');',1574,'amp;/g,"&")}',167,'c},',1572,149,1560,'b.nodeValue',549,'if(b.nodeName!=="#',1565,167,1587,'}',167,1587,'.replace(/^\\[CDATA\\[((.|\\n)*)\\]\\]$/,"$1")}if(',1561,'===0){return" "}var c="";for(',273,'0;a<',1561,';a++){c+=this.',1572,'(',1563,'a])}',167,'c},ResetHidden',149,'a){a.innerHTML=\'<span id="jsMath_hiddenSpan" style="position:absolute"></span>\'+',1391,'operaHiddenFix;a','.className','="";','jsMath.hidden','=a.firstChild;if(!jsMath.BBoxFor("x").w){','jsMath.hidden=jsMath.hiddenTop','}jsMath.ReInit()},ConvertMath',149,'c,b,',179,594,1558,'(b);this.ResetHidden(b);if(d.match(/^\\s*\\\\nocache([^a-zA-Z])/)){a=true;d=d.replace(/\\s*\\\\nocache/,"")}',594,'Parse(c,d,a);b',1613,'="typeset";b.innerHTML=d},',1520,149,'c){this.restart=0;if(!c',1613,'.match(/(^| )math( |$)/)){',767,'a=(c',1613,'.toLowerCase','().match(/(^| )nocache( |$)/)!=null);try{var d=(c.tagName',1637,'()=="div"?"D":"T");this.ConvertMath(d,c,a);c.onclick=jsMath.Click.CheckClick;c.ondblclick=jsMath.Click.CheckDblClick}catch(e){if(c.alt',193,'c.alt;b=b.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");c.innerHTML=b;c',1613,'="math";if(a){c',1613,'+=" nocache"}}',1617,'}},','ProcessElements',149,'b){',1498,'blocking=','1;',966,1391,'processAtOnce;c++,b++){if(b>=','this.element','.length||this.cancel){this.','ProcessComplete','();',211,'cancel){','jsMath.Message.','Set("',177,' Math: Canceled");',1664,'Clear()}',1498,1653,'0;',1498,177,'();return}','else{',273,1498,'SaveQueue();','this.ProcessElement(this.element[','b]);',211,'restart){',1498,1499,'this,"',1649,'",b);',1498,'RestoreQueue(a);',1498,1653,'0;setTimeout("',1498,177,'()",',1391,'delay);return}}}',1498,1690,'var d=Math.floor(100*b/',1658,439,'jsMath.Message.Set("Processing Math',': "+d+"%");setTimeout("',547,'.',1649,'("+b+")",',1391,'delay)},',1502,149,'a','){if(!jsMath.initialized){jsMath.Init()}this.element','=this.GetMathElements(','a);',1498,1653,'1;this.cancel=0;this',556,'=1;',1704,': 0%",1);setTimeout("',547,'.',1649,'(0)",',1391,1711,1514,149,856,1273,1715,1716,'b);a=0}this',556,'=0;while(a<',1658,214,1680,'a]);',211,'restart){','jsMath.Synchronize','("',547,'.',1514,'(null,"+a+")");',1498,177,1675,'a++}this.',1660,'(1)},ProcessOne',149,'a',1715,'=[a];this.',1514,'(null,0)},GetMathElements',149,'d){var b=[];var a;',215,'d=','jsMath.document','}if(typeof(d',833,'d=',1768,'.getElementById(d)}if(!','d.getElementsByTagName','){',187,644,1774,'("div','");for(a=0;a<c.length;a++){if(c[a].className&&c[a].className.match(/(^| )math( |$)/)){if(jsMath.Browser.renameOK&&d.getElementsByName){c[a].setAttribute("name","_jsMath_")}else{b[b.length]=c[a]}}}','c=',1774,'("span',1780,'if(',1391,'renameOK','&&d','.getElementsByName','){b=d',1789,'("_jsMath_',715,'if(',1615,'.sourceIndex','){b.sort(function(f,e){',167,'f',1796,'-e',1796,'})}}',167,'b},',1660,149,'c){if(',1391,1787,193,1768,1789,1792,'");for(',273,'b.length-1;a>=0;a--){b[a].removeAttribute("name")}}',1617,';',1658,'=[];this.restart=null;if(!c){',1704,': Done");',1664,'Clear()}',1664,'UnBlank();if(',1391,'safariImgBug&&(',1510,'font=="symbol"||',1510,'font=="image")){',211,'timeout){clearTimeout(this.timeout)}this.timeout=setTimeout("','jsMath.window.resizeBy','(-1,0); ',1836,'(1,0); ',547,'.timeout = null",2000)}},Cancel',166,547,'.cancel=1;if(',1498,'cancelTimer){',1498,'cancelLoad()}}};',1414,'ConvertTeX',149,'a){',1498,'Push(jsMath.tex2math,"',1850,1503,'ConvertTeX2',149,'a){',1498,1854,1857,1503,'ConvertLaTeX',149,'a){',1498,1854,1864,1503,'ConvertCustom',149,'a){',1498,1854,1871,1503,'CustomSearch',149,'c,b,a,d){',1498,1499,'null,function(){jsMath.tex2math.',1878,'(c,b,a,d)})},tex2math:{',1850,472,1857,472,1864,472,1871,472,1878,':function(){}}});',1746,'=',1498,'Synchronize;try{if(','window.parent','!=window&&window.jsMathAutoload){',1900,'.jsMath=jsMath;',1768,'=',1900,'.document;jsMath.window=',1900,'}}catch(err){}',1535,'Register();jsMath.Loaded();jsMath.Controls.GetCookie();',540,'Source();',1535,'Init();',1498,'Init();',540,'Fonts();if(',1768,'.body){',540,'Body()}',540,'User("onload")}};']

]);
//end = new Date().getTime();
//alert(end-start);
