/**
 * Copyright (c) FOM-Nikhef 2014-
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *  Authors:
 *  2014-
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl>
 *
 */

#ifndef LCMAPS_GRIDMAPFILE_H
#define LCMAPS_GRIDMAPFILE_H


/************************************************************************
 * Gridlist matching options
 ************************************************************************/

#define MATCH_WILD_CHARS          (1<<0)  /* match DN/FQAN as path */
#define MATCH_ONLY_DN             (1<<1)  /* match only DN/FQAN part */

#define MATCH_INCLUDE             (1<<2)  /* match start string */
#define MATCH_EXACT               (1<<3)  /* match total string */

#define REQUIRE_MAPFILE           (1<<4)  /* (default) mapfile must exist */

#ifndef SECURITY_DIR
# define SECURITY_DIR	"/etc/grid-security/"	/* default for files/dir */
#endif


/************************************************************************
 * Function prototypes
 ************************************************************************/

/* Using a grid-mapfile (globusidfile) it looks for a DN or FQAN (globusidp).
 * When options does not contain MATCH_ONLY_DN, it will then look for a mapping
 * which matches searchstr and upon success put the resulting mapping in
 * useridp.
 * When grid-mapfile is unset, a default grid-mapfile is obtained using
 * get_default_mapfile().The default file location is based on environment
 * variables and/or users passwd/ldap entry:
 * 1) GRIDMAP, GLOBUSMAP, globusmap or GlobusMap when set
 * 2a) normal users:
 *  i) users homedir followed by .gridmap 
 *  ii) .gridmap by itself
 * 2b) setuid or root users:
 *  /etc/grid-security/grid-mapfile
 * If the default file does not exist *and* the calling process is non-setuid
 * and non-root, the calling real user account is returned. 
 * return 1 on success, 0 on no match or no mapping and -1 on error. */
int lcmaps_gridmapfile(const char *globusidfile, const char *globusidp,
		       const char *searchstr, int options, char **useridp);


/* Find the properly prefixed mapfile or gridmapdir for relative filenames: when
 * normal user: use directly. If not normal user: use /etc/grid-security/
 * The resulting file will be checked for existence using stat
 * prefixed_file needs to be freed.
 * return 0 on success, -1 on error */
int lcmaps_get_prefixed_file(const char *file, char **prefixed_file);

#endif /* LCMAPS_GRIDMAPFILE_H */



