; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define i1 @reduce_and_self(<8 x i1> %x) {
; CHECK-LABEL: @reduce_and_self(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x i1> [[X:%.*]] to i8
; CHECK-NEXT:    [[RES:%.*]] = icmp eq i8 [[TMP1]], -1
; CHECK-NEXT:    ret i1 [[RES]]
;
  %res = call i1 @llvm.vector.reduce.and.v8i32(<8 x i1> %x)
  ret i1 %res
}

define i32 @reduce_and_sext(<4 x i1> %x) {
; CHECK-LABEL: @reduce_and_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i1> [[X:%.*]] to i4
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i4 [[TMP1]], -1
; CHECK-NEXT:    [[RES:%.*]] = sext i1 [[TMP2]] to i32
; CHECK-NEXT:    ret i32 [[RES]]
;
  %sext = sext <4 x i1> %x to <4 x i32>
  %res = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %sext)
  ret i32 %res
}

define i64 @reduce_and_zext(<8 x i1> %x) {
; CHECK-LABEL: @reduce_and_zext(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x i1> [[X:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], -1
; CHECK-NEXT:    [[RES:%.*]] = zext i1 [[TMP2]] to i64
; CHECK-NEXT:    ret i64 [[RES]]
;
  %zext = zext <8 x i1> %x to <8 x i64>
  %res = call i64 @llvm.vector.reduce.and.v8i64(<8 x i64> %zext)
  ret i64 %res
}

define i16 @reduce_and_sext_same(<16 x i1> %x) {
; CHECK-LABEL: @reduce_and_sext_same(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <16 x i1> [[X:%.*]] to i16
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i16 [[TMP1]], -1
; CHECK-NEXT:    [[RES:%.*]] = sext i1 [[TMP2]] to i16
; CHECK-NEXT:    ret i16 [[RES]]
;
  %sext = sext <16 x i1> %x to <16 x i16>
  %res = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %sext)
  ret i16 %res
}

define i8 @reduce_and_zext_long(<128 x i1> %x) {
; CHECK-LABEL: @reduce_and_zext_long(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <128 x i1> [[X:%.*]] to i128
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i128 [[TMP1]], -1
; CHECK-NEXT:    [[RES:%.*]] = sext i1 [[TMP2]] to i8
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sext = sext <128 x i1> %x to <128 x i8>
  %res = call i8 @llvm.vector.reduce.and.v128i8(<128 x i8> %sext)
  ret i8 %res
}

@glob = external global i8, align 1
define i8 @reduce_and_zext_long_external_use(<128 x i1> %x) {
; CHECK-LABEL: @reduce_and_zext_long_external_use(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <128 x i1> [[X:%.*]] to i128
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i128 [[TMP1]], -1
; CHECK-NEXT:    [[RES:%.*]] = sext i1 [[TMP2]] to i8
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <128 x i1> [[X]], i64 0
; CHECK-NEXT:    [[EXT:%.*]] = sext i1 [[TMP3]] to i8
; CHECK-NEXT:    store i8 [[EXT]], ptr @glob, align 1
; CHECK-NEXT:    ret i8 [[RES]]
;
  %sext = sext <128 x i1> %x to <128 x i8>
  %res = call i8 @llvm.vector.reduce.and.v128i8(<128 x i8> %sext)
  %ext = extractelement <128 x i8> %sext, i32 0
  store i8 %ext, ptr @glob, align 1
  ret i8 %res
}

@glob1 = external global i64, align 8
define i64 @reduce_and_zext_external_use(<8 x i1> %x) {
; CHECK-LABEL: @reduce_and_zext_external_use(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x i1> [[X:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], -1
; CHECK-NEXT:    [[RES:%.*]] = zext i1 [[TMP2]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x i1> [[X]], i64 0
; CHECK-NEXT:    [[EXT:%.*]] = zext i1 [[TMP3]] to i64
; CHECK-NEXT:    store i64 [[EXT]], ptr @glob1, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %zext = zext <8 x i1> %x to <8 x i64>
  %res = call i64 @llvm.vector.reduce.and.v8i64(<8 x i64> %zext)
  %ext = extractelement <8 x i64> %zext, i32 0
  store i64 %ext, ptr @glob1, align 8
  ret i64 %res
}

define i1 @reduce_and_pointer_cast(ptr %arg, ptr %arg1) {
; CHECK-LABEL: @reduce_and_pointer_cast(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[LHS1:%.*]] = load i64, ptr [[ARG1:%.*]], align 8
; CHECK-NEXT:    [[RHS2:%.*]] = load i64, ptr [[ARG:%.*]], align 8
; CHECK-NEXT:    [[ALL_EQ:%.*]] = icmp eq i64 [[LHS1]], [[RHS2]]
; CHECK-NEXT:    ret i1 [[ALL_EQ]]
;
bb:
  %lhs = load <8 x i8>, ptr %arg1
  %rhs = load <8 x i8>, ptr %arg
  %cmp = icmp eq <8 x i8> %lhs, %rhs
  %all_eq = call i1 @llvm.vector.reduce.and.v8i32(<8 x i1> %cmp)
  ret i1 %all_eq
}

define i1 @reduce_and_pointer_cast_wide(ptr %arg, ptr %arg1) {
; CHECK-LABEL: @reduce_and_pointer_cast_wide(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[LHS:%.*]] = load <8 x i16>, ptr [[ARG1:%.*]], align 16
; CHECK-NEXT:    [[RHS:%.*]] = load <8 x i16>, ptr [[ARG:%.*]], align 16
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <8 x i16> [[LHS]], [[RHS]]
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i1> [[CMP]] to i8
; CHECK-NEXT:    [[ALL_EQ:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    ret i1 [[ALL_EQ]]
;
bb:
  %lhs = load <8 x i16>, ptr %arg1
  %rhs = load <8 x i16>, ptr %arg
  %cmp = icmp eq <8 x i16> %lhs, %rhs
  %all_eq = call i1 @llvm.vector.reduce.and.v8i32(<8 x i1> %cmp)
  ret i1 %all_eq
}

define i1 @reduce_and_pointer_cast_ne(ptr %arg, ptr %arg1) {
; CHECK-LABEL: @reduce_and_pointer_cast_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[LHS1:%.*]] = load i64, ptr [[ARG1:%.*]], align 8
; CHECK-NEXT:    [[RHS2:%.*]] = load i64, ptr [[ARG:%.*]], align 8
; CHECK-NEXT:    [[ALL_EQ:%.*]] = icmp ne i64 [[LHS1]], [[RHS2]]
; CHECK-NEXT:    ret i1 [[ALL_EQ]]
;
bb:
  %lhs = load <8 x i8>, ptr %arg1
  %rhs = load <8 x i8>, ptr %arg
  %cmp = icmp eq <8 x i8> %lhs, %rhs
  %all_eq = call i1 @llvm.vector.reduce.and.v8i32(<8 x i1> %cmp)
  %any_ne = xor i1 %all_eq, 1
  ret i1 %any_ne
}

define i1 @reduce_and_pointer_cast_ne_wide(ptr %arg, ptr %arg1) {
; CHECK-LABEL: @reduce_and_pointer_cast_ne_wide(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[LHS:%.*]] = load <8 x i16>, ptr [[ARG1:%.*]], align 16
; CHECK-NEXT:    [[RHS:%.*]] = load <8 x i16>, ptr [[ARG:%.*]], align 16
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <8 x i16> [[LHS]], [[RHS]]
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i1> [[CMP]] to i8
; CHECK-NEXT:    [[ALL_EQ:%.*]] = icmp ne i8 [[TMP0]], 0
; CHECK-NEXT:    ret i1 [[ALL_EQ]]
;
bb:
  %lhs = load <8 x i16>, ptr %arg1
  %rhs = load <8 x i16>, ptr %arg
  %cmp = icmp eq <8 x i16> %lhs, %rhs
  %all_eq = call i1 @llvm.vector.reduce.and.v8i32(<8 x i1> %cmp)
  %any_ne = xor i1 %all_eq, 1
  ret i1 %any_ne
}

declare i1 @llvm.vector.reduce.and.v8i32(<8 x i1> %a)
declare i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %a)
declare i64 @llvm.vector.reduce.and.v8i64(<8 x i64> %a)
declare i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %a)
declare i8 @llvm.vector.reduce.and.v128i8(<128 x i8> %a)
