/* This file is auto-generated from "transaction.xml" by the typemaker
   tool of Gwenhywfar. 
   Do not edit this file -- all changes will be lost! */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "transaction_p.h"
#include <gwenhywfar/misc.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/debug.h>
#include <assert.h>
#include <stdlib.h>
#include <strings.h>

#include <gwenhywfar/types.h>
#include <gwenhywfar/gwentime.h>
#include <gwenhywfar/gwendate.h>
#include <gwenhywfar/stringlist.h>
#include <aqbanking/value.h>
#include <aqbanking/transactionlimits.h>
#include <aqbanking/transactionfns.h>


GWEN_INHERIT_FUNCTIONS(AB_TRANSACTION)
GWEN_LIST_FUNCTIONS(AB_TRANSACTION, AB_Transaction)
GWEN_LIST2_FUNCTIONS(AB_TRANSACTION, AB_Transaction)


AB_TRANSACTION_PERIOD AB_Transaction_Period_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "none")==0)
      return AB_Transaction_PeriodNone;
    else if (strcasecmp(s, "monthly")==0)
      return AB_Transaction_PeriodMonthly;
    else if (strcasecmp(s, "weekly")==0)
      return AB_Transaction_PeriodWeekly;
  }
  return AB_Transaction_PeriodUnknown;
}


const char *AB_Transaction_Period_toString(AB_TRANSACTION_PERIOD v) {
  switch(v) {
    case AB_Transaction_PeriodNone:
      return "none";

    case AB_Transaction_PeriodMonthly:
      return "monthly";

    case AB_Transaction_PeriodWeekly:
      return "weekly";

    default:
      return "unknown";
  } /* switch */
} 


AB_TRANSACTION_TYPE AB_Transaction_Type_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "transaction")==0)
      return AB_Transaction_TypeTransaction;
    else if (strcasecmp(s, "transfer")==0)
      return AB_Transaction_TypeTransfer;
    else if (strcasecmp(s, "debitNote")==0)
      return AB_Transaction_TypeDebitNote;
    else if (strcasecmp(s, "euTransfer")==0)
      return AB_Transaction_TypeEuTransfer;
    else if (strcasecmp(s, "sepaTransfer")==0)
      return AB_Transaction_TypeSepaTransfer;
    else if (strcasecmp(s, "sepaDebitNote")==0)
      return AB_Transaction_TypeSepaDebitNote;
    else if (strcasecmp(s, "internalTransfer")==0)
      return AB_Transaction_TypeInternalTransfer;
  }
  return AB_Transaction_TypeUnknown;
}


const char *AB_Transaction_Type_toString(AB_TRANSACTION_TYPE v) {
  switch(v) {
    case AB_Transaction_TypeTransaction:
      return "transaction";

    case AB_Transaction_TypeTransfer:
      return "transfer";

    case AB_Transaction_TypeDebitNote:
      return "debitNote";

    case AB_Transaction_TypeEuTransfer:
      return "euTransfer";

    case AB_Transaction_TypeSepaTransfer:
      return "sepaTransfer";

    case AB_Transaction_TypeSepaDebitNote:
      return "sepaDebitNote";

    case AB_Transaction_TypeInternalTransfer:
      return "internalTransfer";

    default:
      return "unknown";
  } /* switch */
} 


AB_TRANSACTION_SUBTYPE AB_Transaction_SubType_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "none")==0)
      return AB_Transaction_SubTypeNone;
    else if (strcasecmp(s, "standard")==0)
      return AB_Transaction_SubTypeStandard;
    else if (strcasecmp(s, "check")==0)
      return AB_Transaction_SubTypeCheck;
    else if (strcasecmp(s, "bookedDebitNote")==0)
      return AB_Transaction_SubTypeBookedDebitNote;
    else if (strcasecmp(s, "drawnDebitNote")==0)
      return AB_Transaction_SubTypeDrawnDebitNote;
    else if (strcasecmp(s, "standingOrder")==0)
      return AB_Transaction_SubTypeStandingOrder;
    else if (strcasecmp(s, "loan")==0)
      return AB_Transaction_SubTypeLoan;
    else if (strcasecmp(s, "euStandard")==0)
      return AB_Transaction_SubTypeEuStandard;
    else if (strcasecmp(s, "euASAP")==0)
      return AB_Transaction_SubTypeEuASAP;
    else if (strcasecmp(s, "buy")==0)
      return AB_Transaction_SubTypeBuy;
    else if (strcasecmp(s, "sell")==0)
      return AB_Transaction_SubTypeSell;
    else if (strcasecmp(s, "reinvest")==0)
      return AB_Transaction_SubTypeReinvest;
    else if (strcasecmp(s, "dividend")==0)
      return AB_Transaction_SubTypeDividend;
  }
  return AB_Transaction_SubTypeUnknown;
}


const char *AB_Transaction_SubType_toString(AB_TRANSACTION_SUBTYPE v) {
  switch(v) {
    case AB_Transaction_SubTypeNone:
      return "none";

    case AB_Transaction_SubTypeStandard:
      return "standard";

    case AB_Transaction_SubTypeCheck:
      return "check";

    case AB_Transaction_SubTypeBookedDebitNote:
      return "bookedDebitNote";

    case AB_Transaction_SubTypeDrawnDebitNote:
      return "drawnDebitNote";

    case AB_Transaction_SubTypeStandingOrder:
      return "standingOrder";

    case AB_Transaction_SubTypeLoan:
      return "loan";

    case AB_Transaction_SubTypeEuStandard:
      return "euStandard";

    case AB_Transaction_SubTypeEuASAP:
      return "euASAP";

    case AB_Transaction_SubTypeBuy:
      return "buy";

    case AB_Transaction_SubTypeSell:
      return "sell";

    case AB_Transaction_SubTypeReinvest:
      return "reinvest";

    case AB_Transaction_SubTypeDividend:
      return "dividend";

    default:
      return "unknown";
  } /* switch */
} 


AB_TRANSACTION_STATUS AB_Transaction_Status_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "none")==0)
      return AB_Transaction_StatusNone;
    else if (strcasecmp(s, "accepted")==0)
      return AB_Transaction_StatusAccepted;
    else if (strcasecmp(s, "rejected")==0)
      return AB_Transaction_StatusRejected;
    else if (strcasecmp(s, "pending")==0)
      return AB_Transaction_StatusPending;
    else if (strcasecmp(s, "sending")==0)
      return AB_Transaction_StatusSending;
    else if (strcasecmp(s, "autoReconciled")==0)
      return AB_Transaction_StatusAutoReconciled;
    else if (strcasecmp(s, "manuallyReconciled")==0)
      return AB_Transaction_StatusManuallyReconciled;
    else if (strcasecmp(s, "revoked")==0)
      return AB_Transaction_StatusRevoked;
    else if (strcasecmp(s, "aborted")==0)
      return AB_Transaction_StatusAborted;
  }
  return AB_Transaction_StatusUnknown;
}


const char *AB_Transaction_Status_toString(AB_TRANSACTION_STATUS v) {
  switch(v) {
    case AB_Transaction_StatusNone:
      return "none";

    case AB_Transaction_StatusAccepted:
      return "accepted";

    case AB_Transaction_StatusRejected:
      return "rejected";

    case AB_Transaction_StatusPending:
      return "pending";

    case AB_Transaction_StatusSending:
      return "sending";

    case AB_Transaction_StatusAutoReconciled:
      return "autoReconciled";

    case AB_Transaction_StatusManuallyReconciled:
      return "manuallyReconciled";

    case AB_Transaction_StatusRevoked:
      return "revoked";

    case AB_Transaction_StatusAborted:
      return "aborted";

    default:
      return "unknown";
  } /* switch */
} 


AB_TRANSACTION_CHARGE AB_Transaction_Charge_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "Nobody")==0)
      return AB_Transaction_ChargeNobody;
    else if (strcasecmp(s, "local")==0)
      return AB_Transaction_ChargeLocal;
    else if (strcasecmp(s, "remote")==0)
      return AB_Transaction_ChargeRemote;
    else if (strcasecmp(s, "share")==0)
      return AB_Transaction_ChargeShare;
  }
  return AB_Transaction_ChargeUnknown;
}


const char *AB_Transaction_Charge_toString(AB_TRANSACTION_CHARGE v) {
  switch(v) {
    case AB_Transaction_ChargeNobody:
      return "Nobody";

    case AB_Transaction_ChargeLocal:
      return "local";

    case AB_Transaction_ChargeRemote:
      return "remote";

    case AB_Transaction_ChargeShare:
      return "share";

    default:
      return "unknown";
  } /* switch */
} 


AB_TRANSACTION_SEQUENCETYPE AB_Transaction_SequenceType_fromString(const char *s) {
  if (s) {
    if (strcasecmp(s, "once")==0)
      return AB_Transaction_SequenceTypeOnce;
    else if (strcasecmp(s, "first")==0)
      return AB_Transaction_SequenceTypeFirst;
    else if (strcasecmp(s, "following")==0)
      return AB_Transaction_SequenceTypeFollowing;
    else if (strcasecmp(s, "final")==0)
      return AB_Transaction_SequenceTypeFinal;
  }
  return AB_Transaction_SequenceTypeUnknown;
}


const char *AB_Transaction_SequenceType_toString(AB_TRANSACTION_SEQUENCETYPE v) {
  switch(v) {
    case AB_Transaction_SequenceTypeOnce:
      return "once";

    case AB_Transaction_SequenceTypeFirst:
      return "first";

    case AB_Transaction_SequenceTypeFollowing:
      return "following";

    case AB_Transaction_SequenceTypeFinal:
      return "final";

    default:
      return "unknown";
  } /* switch */
} 




AB_TRANSACTION *AB_Transaction_new(void) {
  AB_TRANSACTION *st;

  GWEN_NEW_OBJECT(AB_TRANSACTION, st)
  st->_usage=1;
  GWEN_INHERIT_INIT(AB_TRANSACTION, st)
  GWEN_LIST_INIT(AB_TRANSACTION, st)
  st->remoteName=GWEN_StringList_new();
  st->purpose=GWEN_StringList_new();
  st->category=GWEN_StringList_new();
  return st;
}


void AB_Transaction_free(AB_TRANSACTION *st) {
  if (st) {
    assert(st->_usage);
    if (--(st->_usage)==0) {
  GWEN_INHERIT_FINI(AB_TRANSACTION, st)
  if (st->localCountry)
    free(st->localCountry);
  if (st->localBankCode)
    free(st->localBankCode);
  if (st->localBranchId)
    free(st->localBranchId);
  if (st->localAccountNumber)
    free(st->localAccountNumber);
  if (st->localSuffix)
    free(st->localSuffix);
  if (st->localIban)
    free(st->localIban);
  if (st->localName)
    free(st->localName);
  if (st->localBic)
    free(st->localBic);
  if (st->remoteCountry)
    free(st->remoteCountry);
  if (st->remoteBankName)
    free(st->remoteBankName);
  if (st->remoteBankLocation)
    free(st->remoteBankLocation);
  if (st->remoteBankCode)
    free(st->remoteBankCode);
  if (st->remoteBranchId)
    free(st->remoteBranchId);
  if (st->remoteAccountNumber)
    free(st->remoteAccountNumber);
  if (st->remoteSuffix)
    free(st->remoteSuffix);
  if (st->remoteIban)
    free(st->remoteIban);
  if (st->remoteName)
    GWEN_StringList_free(st->remoteName);
  if (st->remoteBic)
    free(st->remoteBic);
  if (st->valutaDate)
    GWEN_Time_free(st->valutaDate);
  if (st->date)
    GWEN_Time_free(st->date);
  if (st->value)
    AB_Value_free(st->value);
  if (st->fees)
    AB_Value_free(st->fees);
  if (st->transactionKey)
    free(st->transactionKey);
  if (st->customerReference)
    free(st->customerReference);
  if (st->bankReference)
    free(st->bankReference);
  if (st->endToEndReference)
    free(st->endToEndReference);
  if (st->originatorIdentifier)
    free(st->originatorIdentifier);
  if (st->transactionText)
    free(st->transactionText);
  if (st->primanota)
    free(st->primanota);
  if (st->fiId)
    free(st->fiId);
  if (st->purpose)
    GWEN_StringList_free(st->purpose);
  if (st->category)
    GWEN_StringList_free(st->category);
  if (st->firstExecutionDate)
    GWEN_Time_free(st->firstExecutionDate);
  if (st->lastExecutionDate)
    GWEN_Time_free(st->lastExecutionDate);
  if (st->nextExecutionDate)
    GWEN_Time_free(st->nextExecutionDate);
  if (st->remoteAddrStreet)
    free(st->remoteAddrStreet);
  if (st->remoteAddrZipcode)
    free(st->remoteAddrZipcode);
  if (st->remoteAddrCity)
    free(st->remoteAddrCity);
  if (st->remotePhone)
    free(st->remotePhone);
  if (st->unitId)
    free(st->unitId);
  if (st->unitIdNameSpace)
    free(st->unitIdNameSpace);
  if (st->units)
    AB_Value_free(st->units);
  if (st->unitPrice)
    AB_Value_free(st->unitPrice);
  if (st->commission)
    AB_Value_free(st->commission);
  if (st->creditorSchemeId)
    free(st->creditorSchemeId);
  if (st->mandateId)
    free(st->mandateId);
  if (st->mandateDate)
    GWEN_Date_free(st->mandateDate);
  if (st->mandateDebitorName)
    free(st->mandateDebitorName);
  if (st->originalCreditorSchemeId)
    free(st->originalCreditorSchemeId);
  if (st->originalMandateId)
    free(st->originalMandateId);
  if (st->originalCreditorName)
    free(st->originalCreditorName);
  GWEN_LIST_FINI(AB_TRANSACTION, st)
  GWEN_FREE_OBJECT(st);
    }
  }

}


AB_TRANSACTION *AB_Transaction_dup(const AB_TRANSACTION *d) {
  AB_TRANSACTION *st;

  assert(d);
  st=AB_Transaction_new();
  if (d->localCountry)
    st->localCountry=strdup(d->localCountry);
  if (d->localBankCode)
    st->localBankCode=strdup(d->localBankCode);
  if (d->localBranchId)
    st->localBranchId=strdup(d->localBranchId);
  if (d->localAccountNumber)
    st->localAccountNumber=strdup(d->localAccountNumber);
  if (d->localSuffix)
    st->localSuffix=strdup(d->localSuffix);
  if (d->localIban)
    st->localIban=strdup(d->localIban);
  if (d->localName)
    st->localName=strdup(d->localName);
  if (d->localBic)
    st->localBic=strdup(d->localBic);
  if (d->remoteCountry)
    st->remoteCountry=strdup(d->remoteCountry);
  if (d->remoteBankName)
    st->remoteBankName=strdup(d->remoteBankName);
  if (d->remoteBankLocation)
    st->remoteBankLocation=strdup(d->remoteBankLocation);
  if (d->remoteBankCode)
    st->remoteBankCode=strdup(d->remoteBankCode);
  if (d->remoteBranchId)
    st->remoteBranchId=strdup(d->remoteBranchId);
  if (d->remoteAccountNumber)
    st->remoteAccountNumber=strdup(d->remoteAccountNumber);
  if (d->remoteSuffix)
    st->remoteSuffix=strdup(d->remoteSuffix);
  if (d->remoteIban)
    st->remoteIban=strdup(d->remoteIban);
  if (d->remoteName)
    st->remoteName=GWEN_StringList_dup(d->remoteName);
  if (d->remoteBic)
    st->remoteBic=strdup(d->remoteBic);
  st->uniqueId=d->uniqueId;
  st->idForApplication=d->idForApplication;
  st->groupId=d->groupId;
  if (d->valutaDate)
    st->valutaDate=GWEN_Time_dup(d->valutaDate);
  if (d->date)
    st->date=GWEN_Time_dup(d->date);
  if (d->value)
    st->value=AB_Value_dup(d->value);
  if (d->fees)
    st->fees=AB_Value_dup(d->fees);
  st->textKey=d->textKey;
  st->textKeyExt=d->textKeyExt;
  if (d->transactionKey)
    st->transactionKey=strdup(d->transactionKey);
  if (d->customerReference)
    st->customerReference=strdup(d->customerReference);
  if (d->bankReference)
    st->bankReference=strdup(d->bankReference);
  if (d->endToEndReference)
    st->endToEndReference=strdup(d->endToEndReference);
  if (d->originatorIdentifier)
    st->originatorIdentifier=strdup(d->originatorIdentifier);
  st->transactionCode=d->transactionCode;
  if (d->transactionText)
    st->transactionText=strdup(d->transactionText);
  if (d->primanota)
    st->primanota=strdup(d->primanota);
  if (d->fiId)
    st->fiId=strdup(d->fiId);
  if (d->purpose)
    st->purpose=GWEN_StringList_dup(d->purpose);
  if (d->category)
    st->category=GWEN_StringList_dup(d->category);
  st->period=d->period;
  st->cycle=d->cycle;
  st->executionDay=d->executionDay;
  if (d->firstExecutionDate)
    st->firstExecutionDate=GWEN_Time_dup(d->firstExecutionDate);
  if (d->lastExecutionDate)
    st->lastExecutionDate=GWEN_Time_dup(d->lastExecutionDate);
  if (d->nextExecutionDate)
    st->nextExecutionDate=GWEN_Time_dup(d->nextExecutionDate);
  st->type=d->type;
  st->subType=d->subType;
  st->status=d->status;
  st->charge=d->charge;
  if (d->remoteAddrStreet)
    st->remoteAddrStreet=strdup(d->remoteAddrStreet);
  if (d->remoteAddrZipcode)
    st->remoteAddrZipcode=strdup(d->remoteAddrZipcode);
  if (d->remoteAddrCity)
    st->remoteAddrCity=strdup(d->remoteAddrCity);
  if (d->remotePhone)
    st->remotePhone=strdup(d->remotePhone);
  if (d->unitId)
    st->unitId=strdup(d->unitId);
  if (d->unitIdNameSpace)
    st->unitIdNameSpace=strdup(d->unitIdNameSpace);
  if (d->units)
    st->units=AB_Value_dup(d->units);
  if (d->unitPrice)
    st->unitPrice=AB_Value_dup(d->unitPrice);
  if (d->commission)
    st->commission=AB_Value_dup(d->commission);
  if (d->creditorSchemeId)
    st->creditorSchemeId=strdup(d->creditorSchemeId);
  if (d->mandateId)
    st->mandateId=strdup(d->mandateId);
  if (d->mandateDate)
    st->mandateDate=GWEN_Date_dup(d->mandateDate);
  if (d->mandateDebitorName)
    st->mandateDebitorName=strdup(d->mandateDebitorName);
  if (d->originalCreditorSchemeId)
    st->originalCreditorSchemeId=strdup(d->originalCreditorSchemeId);
  if (d->originalMandateId)
    st->originalMandateId=strdup(d->originalMandateId);
  if (d->originalCreditorName)
    st->originalCreditorName=strdup(d->originalCreditorName);
  st->sequenceType=d->sequenceType;
  return st;
}


int AB_Transaction_toDb(const AB_TRANSACTION *st, GWEN_DB_NODE *db) {
  assert(st);
  assert(db);
  if (st->localCountry)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localCountry", st->localCountry))
      return -1;
  if (st->localBankCode)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localBankCode", st->localBankCode))
      return -1;
  if (st->localBranchId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localBranchId", st->localBranchId))
      return -1;
  if (st->localAccountNumber)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localAccountNumber", st->localAccountNumber))
      return -1;
  if (st->localSuffix)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localSuffix", st->localSuffix))
      return -1;
  if (st->localIban)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localIban", st->localIban))
      return -1;
  if (st->localName)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localName", st->localName))
      return -1;
  if (st->localBic)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "localBic", st->localBic))
      return -1;
  if (st->remoteCountry)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteCountry", st->remoteCountry))
      return -1;
  if (st->remoteBankName)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBankName", st->remoteBankName))
      return -1;
  if (st->remoteBankLocation)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBankLocation", st->remoteBankLocation))
      return -1;
  if (st->remoteBankCode)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBankCode", st->remoteBankCode))
      return -1;
  if (st->remoteBranchId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBranchId", st->remoteBranchId))
      return -1;
  if (st->remoteAccountNumber)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAccountNumber", st->remoteAccountNumber))
      return -1;
  if (st->remoteSuffix)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteSuffix", st->remoteSuffix))
      return -1;
  if (st->remoteIban)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteIban", st->remoteIban))
      return -1;
  if (st->remoteName)
    {
      GWEN_STRINGLISTENTRY *se;

      GWEN_DB_DeleteVar(db, "remoteName");
      se=GWEN_StringList_FirstEntry(st->remoteName);
      while(se) {
        const char *s;

        s=GWEN_StringListEntry_Data(se);
        assert(s);
        if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT, "remoteName", s))
          return -1;
        se=GWEN_StringListEntry_Next(se);
      } /* while */
    }
  if (st->remoteBic)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteBic", st->remoteBic))
      return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "uniqueId", st->uniqueId))
    return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "idForApplication", st->idForApplication))
    return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "groupId", st->groupId))
    return -1;
  if (st->valutaDate)
    if (GWEN_Time_toDb(st->valutaDate, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "valutaDate")))
      return -1;
  if (st->date)
    if (GWEN_Time_toDb(st->date, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "date")))
      return -1;
  if (st->value)
    if (AB_Value_toDb(st->value, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "value")))
      return -1;
  if (st->fees)
    if (AB_Value_toDb(st->fees, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "fees")))
      return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "textKey", st->textKey))
    return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "textKeyExt", st->textKeyExt))
    return -1;
  if (st->transactionKey)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "transactionKey", st->transactionKey))
      return -1;
  if (st->customerReference)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "customerReference", st->customerReference))
      return -1;
  if (st->bankReference)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankReference", st->bankReference))
      return -1;
  if (st->endToEndReference)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "endToEndReference", st->endToEndReference))
      return -1;
  if (st->originatorIdentifier)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originatorIdentifier", st->originatorIdentifier))
      return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "transactionCode", st->transactionCode))
    return -1;
  if (st->transactionText)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "transactionText", st->transactionText))
      return -1;
  if (st->primanota)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "primanota", st->primanota))
      return -1;
  if (st->fiId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "fiId", st->fiId))
      return -1;
  if (st->purpose)
    {
      GWEN_STRINGLISTENTRY *se;

      GWEN_DB_DeleteVar(db, "purpose");
      se=GWEN_StringList_FirstEntry(st->purpose);
      while(se) {
        const char *s;

        s=GWEN_StringListEntry_Data(se);
        assert(s);
        if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT, "purpose", s))
          return -1;
        se=GWEN_StringListEntry_Next(se);
      } /* while */
    }
  if (st->category)
    {
      GWEN_STRINGLISTENTRY *se;

      GWEN_DB_DeleteVar(db, "category");
      se=GWEN_StringList_FirstEntry(st->category);
      while(se) {
        const char *s;

        s=GWEN_StringListEntry_Data(se);
        assert(s);
        if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT, "category", s))
          return -1;
        se=GWEN_StringListEntry_Next(se);
      } /* while */
    }
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "period", AB_Transaction_Period_toString(st->period))) 
    return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "cycle", st->cycle))
    return -1;
  if (GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "executionDay", st->executionDay))
    return -1;
  if (st->firstExecutionDate)
    if (GWEN_Time_toDb(st->firstExecutionDate, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "firstExecutionDate")))
      return -1;
  if (st->lastExecutionDate)
    if (GWEN_Time_toDb(st->lastExecutionDate, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "lastExecutionDate")))
      return -1;
  if (st->nextExecutionDate)
    if (GWEN_Time_toDb(st->nextExecutionDate, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "nextExecutionDate")))
      return -1;
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "type", AB_Transaction_Type_toString(st->type))) 
    return -1;
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "subType", AB_Transaction_SubType_toString(st->subType))) 
    return -1;
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "status", AB_Transaction_Status_toString(st->status))) 
    return -1;
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "charge", AB_Transaction_Charge_toString(st->charge))) 
    return -1;
  if (st->remoteAddrStreet)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrStreet", st->remoteAddrStreet))
      return -1;
  if (st->remoteAddrZipcode)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrZipcode", st->remoteAddrZipcode))
      return -1;
  if (st->remoteAddrCity)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remoteAddrCity", st->remoteAddrCity))
      return -1;
  if (st->remotePhone)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "remotePhone", st->remotePhone))
      return -1;
  if (st->unitId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "unitId", st->unitId))
      return -1;
  if (st->unitIdNameSpace)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "unitIdNameSpace", st->unitIdNameSpace))
      return -1;
  if (st->units)
    if (AB_Value_toDb(st->units, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "units")))
      return -1;
  if (st->unitPrice)
    if (AB_Value_toDb(st->unitPrice, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "unitPrice")))
      return -1;
  if (st->commission)
    if (AB_Value_toDb(st->commission, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "commission")))
      return -1;
  if (st->creditorSchemeId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "creditorSchemeId", st->creditorSchemeId))
      return -1;
  if (st->mandateId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "mandateId", st->mandateId))
      return -1;
  if (st->mandateDate)
    if (GWEN_Date_toDb(st->mandateDate, GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT, "mandateDate")))
      return -1;
  if (st->mandateDebitorName)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "mandateDebitorName", st->mandateDebitorName))
      return -1;
  if (st->originalCreditorSchemeId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originalCreditorSchemeId", st->originalCreditorSchemeId))
      return -1;
  if (st->originalMandateId)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originalMandateId", st->originalMandateId))
      return -1;
  if (st->originalCreditorName)
    if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "originalCreditorName", st->originalCreditorName))
      return -1;
  if (GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS, "sequenceType", AB_Transaction_SequenceType_toString(st->sequenceType))) 
    return -1;
  return 0;
}


int AB_Transaction_ReadDb(AB_TRANSACTION *st, GWEN_DB_NODE *db) {
  assert(st);
  assert(db);
  AB_Transaction_SetLocalCountry(st, GWEN_DB_GetCharValue(db, "localCountry", 0, 0));
  AB_Transaction_SetLocalBankCode(st, GWEN_DB_GetCharValue(db, "localBankCode", 0, 0));
  AB_Transaction_SetLocalBranchId(st, GWEN_DB_GetCharValue(db, "localBranchId", 0, 0));
  AB_Transaction_SetLocalAccountNumber(st, GWEN_DB_GetCharValue(db, "localAccountNumber", 0, 0));
  AB_Transaction_SetLocalSuffix(st, GWEN_DB_GetCharValue(db, "localSuffix", 0, 0));
  AB_Transaction_SetLocalIban(st, GWEN_DB_GetCharValue(db, "localIban", 0, 0));
  AB_Transaction_SetLocalName(st, GWEN_DB_GetCharValue(db, "localName", 0, 0));
  AB_Transaction_SetLocalBic(st, GWEN_DB_GetCharValue(db, "localBic", 0, 0));
  AB_Transaction_SetRemoteCountry(st, GWEN_DB_GetCharValue(db, "remoteCountry", 0, 0));
  AB_Transaction_SetRemoteBankName(st, GWEN_DB_GetCharValue(db, "remoteBankName", 0, 0));
  AB_Transaction_SetRemoteBankLocation(st, GWEN_DB_GetCharValue(db, "remoteBankLocation", 0, 0));
  AB_Transaction_SetRemoteBankCode(st, GWEN_DB_GetCharValue(db, "remoteBankCode", 0, 0));
  AB_Transaction_SetRemoteBranchId(st, GWEN_DB_GetCharValue(db, "remoteBranchId", 0, 0));
  AB_Transaction_SetRemoteAccountNumber(st, GWEN_DB_GetCharValue(db, "remoteAccountNumber", 0, 0));
  AB_Transaction_SetRemoteSuffix(st, GWEN_DB_GetCharValue(db, "remoteSuffix", 0, 0));
  AB_Transaction_SetRemoteIban(st, GWEN_DB_GetCharValue(db, "remoteIban", 0, 0));
  if (1) {
    int i;

    for (i=0; ; i++) {
      const char *s;

      s=GWEN_DB_GetCharValue(db, "remoteName", i, 0);
      if (!s)
        break;
      AB_Transaction_AddRemoteName(st, s, 0);
    } /* for */
  }
  AB_Transaction_SetRemoteBic(st, GWEN_DB_GetCharValue(db, "remoteBic", 0, 0));
  AB_Transaction_SetUniqueId(st, GWEN_DB_GetIntValue(db, "uniqueId", 0, 0));
  AB_Transaction_SetIdForApplication(st, GWEN_DB_GetIntValue(db, "idForApplication", 0, 0));
  AB_Transaction_SetGroupId(st, GWEN_DB_GetIntValue(db, "groupId", 0, 0));
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "valutaDate");
    if (dbT) {
  if (st->valutaDate)
    GWEN_Time_free(st->valutaDate);
  st->valutaDate=GWEN_Time_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "date");
    if (dbT) {
  if (st->date)
    GWEN_Time_free(st->date);
  st->date=GWEN_Time_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "value");
    if (dbT) {
  if (st->value)
    AB_Value_free(st->value);
  st->value=AB_Value_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "fees");
    if (dbT) {
  if (st->fees)
    AB_Value_free(st->fees);
  st->fees=AB_Value_fromDb(dbT);
}
  }
  AB_Transaction_SetTextKey(st, GWEN_DB_GetIntValue(db, "textKey", 0, 0));
  AB_Transaction_SetTextKeyExt(st, GWEN_DB_GetIntValue(db, "textKeyExt", 0, 0));
  AB_Transaction_SetTransactionKey(st, GWEN_DB_GetCharValue(db, "transactionKey", 0, 0));
  AB_Transaction_SetCustomerReference(st, GWEN_DB_GetCharValue(db, "customerReference", 0, 0));
  AB_Transaction_SetBankReference(st, GWEN_DB_GetCharValue(db, "bankReference", 0, 0));
  AB_Transaction_SetEndToEndReference(st, GWEN_DB_GetCharValue(db, "endToEndReference", 0, 0));
  AB_Transaction_SetOriginatorIdentifier(st, GWEN_DB_GetCharValue(db, "originatorIdentifier", 0, 0));
  AB_Transaction_SetTransactionCode(st, GWEN_DB_GetIntValue(db, "transactionCode", 0, 0));
  AB_Transaction_SetTransactionText(st, GWEN_DB_GetCharValue(db, "transactionText", 0, 0));
  AB_Transaction_SetPrimanota(st, GWEN_DB_GetCharValue(db, "primanota", 0, 0));
  AB_Transaction_SetFiId(st, GWEN_DB_GetCharValue(db, "fiId", 0, 0));
  if (1) {
    int i;

    for (i=0; ; i++) {
      const char *s;

      s=GWEN_DB_GetCharValue(db, "purpose", i, 0);
      if (!s)
        break;
      AB_Transaction_AddPurpose(st, s, 0);
    } /* for */
  }
  if (1) {
    int i;

    for (i=0; ; i++) {
      const char *s;

      s=GWEN_DB_GetCharValue(db, "category", i, 0);
      if (!s)
        break;
      AB_Transaction_AddCategory(st, s, 0);
    } /* for */
  }
  AB_Transaction_SetPeriod(st, AB_Transaction_Period_fromString(GWEN_DB_GetCharValue(db, "period", 0, 0)));
  AB_Transaction_SetCycle(st, GWEN_DB_GetIntValue(db, "cycle", 0, 0));
  AB_Transaction_SetExecutionDay(st, GWEN_DB_GetIntValue(db, "executionDay", 0, 0));
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "firstExecutionDate");
    if (dbT) {
  if (st->firstExecutionDate)
    GWEN_Time_free(st->firstExecutionDate);
  st->firstExecutionDate=GWEN_Time_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "lastExecutionDate");
    if (dbT) {
  if (st->lastExecutionDate)
    GWEN_Time_free(st->lastExecutionDate);
  st->lastExecutionDate=GWEN_Time_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "nextExecutionDate");
    if (dbT) {
  if (st->nextExecutionDate)
    GWEN_Time_free(st->nextExecutionDate);
  st->nextExecutionDate=GWEN_Time_fromDb(dbT);
}
  }
  AB_Transaction_SetType(st, AB_Transaction_Type_fromString(GWEN_DB_GetCharValue(db, "type", 0, 0)));
  AB_Transaction_SetSubType(st, AB_Transaction_SubType_fromString(GWEN_DB_GetCharValue(db, "subType", 0, 0)));
  AB_Transaction_SetStatus(st, AB_Transaction_Status_fromString(GWEN_DB_GetCharValue(db, "status", 0, 0)));
  AB_Transaction_SetCharge(st, AB_Transaction_Charge_fromString(GWEN_DB_GetCharValue(db, "charge", 0, 0)));
  AB_Transaction_SetRemoteAddrStreet(st, GWEN_DB_GetCharValue(db, "remoteAddrStreet", 0, 0));
  AB_Transaction_SetRemoteAddrZipcode(st, GWEN_DB_GetCharValue(db, "remoteAddrZipcode", 0, 0));
  AB_Transaction_SetRemoteAddrCity(st, GWEN_DB_GetCharValue(db, "remoteAddrCity", 0, 0));
  AB_Transaction_SetRemotePhone(st, GWEN_DB_GetCharValue(db, "remotePhone", 0, 0));
  AB_Transaction_SetUnitId(st, GWEN_DB_GetCharValue(db, "unitId", 0, 0));
  AB_Transaction_SetUnitIdNameSpace(st, GWEN_DB_GetCharValue(db, "unitIdNameSpace", 0, 0));
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "units");
    if (dbT) {
  if (st->units)
    AB_Value_free(st->units);
  st->units=AB_Value_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "unitPrice");
    if (dbT) {
  if (st->unitPrice)
    AB_Value_free(st->unitPrice);
  st->unitPrice=AB_Value_fromDb(dbT);
}
  }
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "commission");
    if (dbT) {
  if (st->commission)
    AB_Value_free(st->commission);
  st->commission=AB_Value_fromDb(dbT);
}
  }
  AB_Transaction_SetCreditorSchemeId(st, GWEN_DB_GetCharValue(db, "creditorSchemeId", 0, 0));
  AB_Transaction_SetMandateId(st, GWEN_DB_GetCharValue(db, "mandateId", 0, 0));
  if (1) { /* for local vars */
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "mandateDate");
    if (dbT) {
  if (st->mandateDate)
    GWEN_Date_free(st->mandateDate);
  st->mandateDate=GWEN_Date_fromDb(dbT);
}
  }
  AB_Transaction_SetMandateDebitorName(st, GWEN_DB_GetCharValue(db, "mandateDebitorName", 0, 0));
  AB_Transaction_SetOriginalCreditorSchemeId(st, GWEN_DB_GetCharValue(db, "originalCreditorSchemeId", 0, 0));
  AB_Transaction_SetOriginalMandateId(st, GWEN_DB_GetCharValue(db, "originalMandateId", 0, 0));
  AB_Transaction_SetOriginalCreditorName(st, GWEN_DB_GetCharValue(db, "originalCreditorName", 0, 0));
  AB_Transaction_SetSequenceType(st, AB_Transaction_SequenceType_fromString(GWEN_DB_GetCharValue(db, "sequenceType", 0, 0)));
  return 0;
}


AB_TRANSACTION *AB_Transaction_fromDb(GWEN_DB_NODE *db) {
  AB_TRANSACTION *st;

  assert(db);
  st=AB_Transaction_new();
  AB_Transaction_ReadDb(st, db);
  st->_modified=0;
  return st;
}




const char *AB_Transaction_GetLocalCountry(const AB_TRANSACTION *st) {
  assert(st);
  return st->localCountry;
}


void AB_Transaction_SetLocalCountry(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localCountry)
    free(st->localCountry);
  if (d && *d)
    st->localCountry=strdup(d);
  else
    st->localCountry=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalBankCode(const AB_TRANSACTION *st) {
  assert(st);
  return st->localBankCode;
}


void AB_Transaction_SetLocalBankCode(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localBankCode)
    free(st->localBankCode);
  if (d && *d)
    st->localBankCode=strdup(d);
  else
    st->localBankCode=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalBranchId(const AB_TRANSACTION *st) {
  assert(st);
  return st->localBranchId;
}


void AB_Transaction_SetLocalBranchId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localBranchId)
    free(st->localBranchId);
  if (d && *d)
    st->localBranchId=strdup(d);
  else
    st->localBranchId=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalAccountNumber(const AB_TRANSACTION *st) {
  assert(st);
  return st->localAccountNumber;
}


void AB_Transaction_SetLocalAccountNumber(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localAccountNumber)
    free(st->localAccountNumber);
  if (d && *d)
    st->localAccountNumber=strdup(d);
  else
    st->localAccountNumber=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalSuffix(const AB_TRANSACTION *st) {
  assert(st);
  return st->localSuffix;
}


void AB_Transaction_SetLocalSuffix(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localSuffix)
    free(st->localSuffix);
  if (d && *d)
    st->localSuffix=strdup(d);
  else
    st->localSuffix=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalIban(const AB_TRANSACTION *st) {
  assert(st);
  return st->localIban;
}


void AB_Transaction_SetLocalIban(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localIban)
    free(st->localIban);
  if (d && *d)
    st->localIban=strdup(d);
  else
    st->localIban=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalName(const AB_TRANSACTION *st) {
  assert(st);
  return st->localName;
}


void AB_Transaction_SetLocalName(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localName)
    free(st->localName);
  if (d && *d)
    st->localName=strdup(d);
  else
    st->localName=0;
  st->_modified=1;
}




const char *AB_Transaction_GetLocalBic(const AB_TRANSACTION *st) {
  assert(st);
  return st->localBic;
}


void AB_Transaction_SetLocalBic(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->localBic)
    free(st->localBic);
  if (d && *d)
    st->localBic=strdup(d);
  else
    st->localBic=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteCountry(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteCountry;
}


void AB_Transaction_SetRemoteCountry(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteCountry)
    free(st->remoteCountry);
  if (d && *d)
    st->remoteCountry=strdup(d);
  else
    st->remoteCountry=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteBankName(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteBankName;
}


void AB_Transaction_SetRemoteBankName(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteBankName)
    free(st->remoteBankName);
  if (d && *d)
    st->remoteBankName=strdup(d);
  else
    st->remoteBankName=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteBankLocation(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteBankLocation;
}


void AB_Transaction_SetRemoteBankLocation(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteBankLocation)
    free(st->remoteBankLocation);
  if (d && *d)
    st->remoteBankLocation=strdup(d);
  else
    st->remoteBankLocation=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteBankCode(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteBankCode;
}


void AB_Transaction_SetRemoteBankCode(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteBankCode)
    free(st->remoteBankCode);
  if (d && *d)
    st->remoteBankCode=strdup(d);
  else
    st->remoteBankCode=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteBranchId(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteBranchId;
}


void AB_Transaction_SetRemoteBranchId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteBranchId)
    free(st->remoteBranchId);
  if (d && *d)
    st->remoteBranchId=strdup(d);
  else
    st->remoteBranchId=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteAccountNumber(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteAccountNumber;
}


void AB_Transaction_SetRemoteAccountNumber(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteAccountNumber)
    free(st->remoteAccountNumber);
  if (d && *d)
    st->remoteAccountNumber=strdup(d);
  else
    st->remoteAccountNumber=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteSuffix(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteSuffix;
}


void AB_Transaction_SetRemoteSuffix(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteSuffix)
    free(st->remoteSuffix);
  if (d && *d)
    st->remoteSuffix=strdup(d);
  else
    st->remoteSuffix=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteIban(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteIban;
}


void AB_Transaction_SetRemoteIban(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteIban)
    free(st->remoteIban);
  if (d && *d)
    st->remoteIban=strdup(d);
  else
    st->remoteIban=0;
  st->_modified=1;
}




const GWEN_STRINGLIST *AB_Transaction_GetRemoteName(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteName;
}


void AB_Transaction_SetRemoteName(AB_TRANSACTION *st, const GWEN_STRINGLIST *d) {
  assert(st);
  if (st->remoteName)
    GWEN_StringList_free(st->remoteName);
  if (d)
    st->remoteName=GWEN_StringList_dup(d);
  else
    st->remoteName=0;
  st->_modified=1;
}




void AB_Transaction_AddRemoteName(AB_TRANSACTION *st, const char *d, int chk){
  assert(st);
  assert(d);
  if (GWEN_StringList_AppendString(st->remoteName, d, 0, chk))
    st->_modified=1;
}


void AB_Transaction_RemoveRemoteName(AB_TRANSACTION *st, const char *d) {
  if (GWEN_StringList_RemoveString(st->remoteName, d))
    st->_modified=1;
}


void AB_Transaction_ClearRemoteName(AB_TRANSACTION *st) {
  if (GWEN_StringList_Count(st->remoteName)) {
    GWEN_StringList_Clear(st->remoteName);
    st->_modified=1;
  }
}


int AB_Transaction_HasRemoteName(const AB_TRANSACTION *st, const char *d) {
  return GWEN_StringList_HasString(st->remoteName, d);
}




const char *AB_Transaction_GetRemoteBic(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteBic;
}


void AB_Transaction_SetRemoteBic(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteBic)
    free(st->remoteBic);
  if (d && *d)
    st->remoteBic=strdup(d);
  else
    st->remoteBic=0;
  st->_modified=1;
}




uint32_t AB_Transaction_GetUniqueId(const AB_TRANSACTION *st) {
  assert(st);
  return st->uniqueId;
}


void AB_Transaction_SetUniqueId(AB_TRANSACTION *st, uint32_t d) {
  assert(st);
  st->uniqueId=d;
  st->_modified=1;
}




uint32_t AB_Transaction_GetIdForApplication(const AB_TRANSACTION *st) {
  assert(st);
  return st->idForApplication;
}


void AB_Transaction_SetIdForApplication(AB_TRANSACTION *st, uint32_t d) {
  assert(st);
  st->idForApplication=d;
  st->_modified=1;
}




uint32_t AB_Transaction_GetGroupId(const AB_TRANSACTION *st) {
  assert(st);
  return st->groupId;
}


void AB_Transaction_SetGroupId(AB_TRANSACTION *st, uint32_t d) {
  assert(st);
  st->groupId=d;
  st->_modified=1;
}




const GWEN_TIME *AB_Transaction_GetValutaDate(const AB_TRANSACTION *st) {
  assert(st);
  return st->valutaDate;
}


void AB_Transaction_SetValutaDate(AB_TRANSACTION *st, const GWEN_TIME *d) {
  assert(st);
  if (st->valutaDate)
    GWEN_Time_free(st->valutaDate);
  if (d)
    st->valutaDate=GWEN_Time_dup(d);
  else
    st->valutaDate=0;
  st->_modified=1;
}




const GWEN_TIME *AB_Transaction_GetDate(const AB_TRANSACTION *st) {
  assert(st);
  return st->date;
}


void AB_Transaction_SetDate(AB_TRANSACTION *st, const GWEN_TIME *d) {
  assert(st);
  if (st->date)
    GWEN_Time_free(st->date);
  if (d)
    st->date=GWEN_Time_dup(d);
  else
    st->date=0;
  st->_modified=1;
}




const AB_VALUE *AB_Transaction_GetValue(const AB_TRANSACTION *st) {
  assert(st);
  return st->value;
}


void AB_Transaction_SetValue(AB_TRANSACTION *st, const AB_VALUE *d) {
  assert(st);
  if (st->value)
    AB_Value_free(st->value);
  if (d)
    st->value=AB_Value_dup(d);
  else
    st->value=0;
  st->_modified=1;
}




const AB_VALUE *AB_Transaction_GetFees(const AB_TRANSACTION *st) {
  assert(st);
  return st->fees;
}


void AB_Transaction_SetFees(AB_TRANSACTION *st, const AB_VALUE *d) {
  assert(st);
  if (st->fees)
    AB_Value_free(st->fees);
  if (d)
    st->fees=AB_Value_dup(d);
  else
    st->fees=0;
  st->_modified=1;
}




int AB_Transaction_GetTextKey(const AB_TRANSACTION *st) {
  assert(st);
  return st->textKey;
}


void AB_Transaction_SetTextKey(AB_TRANSACTION *st, int d) {
  assert(st);
  st->textKey=d;
  st->_modified=1;
}




int AB_Transaction_GetTextKeyExt(const AB_TRANSACTION *st) {
  assert(st);
  return st->textKeyExt;
}


void AB_Transaction_SetTextKeyExt(AB_TRANSACTION *st, int d) {
  assert(st);
  st->textKeyExt=d;
  st->_modified=1;
}




const char *AB_Transaction_GetTransactionKey(const AB_TRANSACTION *st) {
  assert(st);
  return st->transactionKey;
}


void AB_Transaction_SetTransactionKey(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->transactionKey)
    free(st->transactionKey);
  if (d && *d)
    st->transactionKey=strdup(d);
  else
    st->transactionKey=0;
  st->_modified=1;
}




const char *AB_Transaction_GetCustomerReference(const AB_TRANSACTION *st) {
  assert(st);
  return st->customerReference;
}


void AB_Transaction_SetCustomerReference(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->customerReference)
    free(st->customerReference);
  if (d && *d)
    st->customerReference=strdup(d);
  else
    st->customerReference=0;
  st->_modified=1;
}




const char *AB_Transaction_GetBankReference(const AB_TRANSACTION *st) {
  assert(st);
  return st->bankReference;
}


void AB_Transaction_SetBankReference(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->bankReference)
    free(st->bankReference);
  if (d && *d)
    st->bankReference=strdup(d);
  else
    st->bankReference=0;
  st->_modified=1;
}




const char *AB_Transaction_GetEndToEndReference(const AB_TRANSACTION *st) {
  assert(st);
  return st->endToEndReference;
}


void AB_Transaction_SetEndToEndReference(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->endToEndReference)
    free(st->endToEndReference);
  if (d && *d)
    st->endToEndReference=strdup(d);
  else
    st->endToEndReference=0;
  st->_modified=1;
}




const char *AB_Transaction_GetOriginatorIdentifier(const AB_TRANSACTION *st) {
  assert(st);
  return st->originatorIdentifier;
}


void AB_Transaction_SetOriginatorIdentifier(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->originatorIdentifier)
    free(st->originatorIdentifier);
  if (d && *d)
    st->originatorIdentifier=strdup(d);
  else
    st->originatorIdentifier=0;
  st->_modified=1;
}




int AB_Transaction_GetTransactionCode(const AB_TRANSACTION *st) {
  assert(st);
  return st->transactionCode;
}


void AB_Transaction_SetTransactionCode(AB_TRANSACTION *st, int d) {
  assert(st);
  st->transactionCode=d;
  st->_modified=1;
}




const char *AB_Transaction_GetTransactionText(const AB_TRANSACTION *st) {
  assert(st);
  return st->transactionText;
}


void AB_Transaction_SetTransactionText(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->transactionText)
    free(st->transactionText);
  if (d && *d)
    st->transactionText=strdup(d);
  else
    st->transactionText=0;
  st->_modified=1;
}




const char *AB_Transaction_GetPrimanota(const AB_TRANSACTION *st) {
  assert(st);
  return st->primanota;
}


void AB_Transaction_SetPrimanota(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->primanota)
    free(st->primanota);
  if (d && *d)
    st->primanota=strdup(d);
  else
    st->primanota=0;
  st->_modified=1;
}




const char *AB_Transaction_GetFiId(const AB_TRANSACTION *st) {
  assert(st);
  return st->fiId;
}


void AB_Transaction_SetFiId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->fiId)
    free(st->fiId);
  if (d && *d)
    st->fiId=strdup(d);
  else
    st->fiId=0;
  st->_modified=1;
}




const GWEN_STRINGLIST *AB_Transaction_GetPurpose(const AB_TRANSACTION *st) {
  assert(st);
  return st->purpose;
}


void AB_Transaction_SetPurpose(AB_TRANSACTION *st, const GWEN_STRINGLIST *d) {
  assert(st);
  if (st->purpose)
    GWEN_StringList_free(st->purpose);
  if (d)
    st->purpose=GWEN_StringList_dup(d);
  else
    st->purpose=0;
  st->_modified=1;
}




void AB_Transaction_AddPurpose(AB_TRANSACTION *st, const char *d, int chk){
  assert(st);
  assert(d);
  if (GWEN_StringList_AppendString(st->purpose, d, 0, chk))
    st->_modified=1;
}


void AB_Transaction_RemovePurpose(AB_TRANSACTION *st, const char *d) {
  if (GWEN_StringList_RemoveString(st->purpose, d))
    st->_modified=1;
}


void AB_Transaction_ClearPurpose(AB_TRANSACTION *st) {
  if (GWEN_StringList_Count(st->purpose)) {
    GWEN_StringList_Clear(st->purpose);
    st->_modified=1;
  }
}


int AB_Transaction_HasPurpose(const AB_TRANSACTION *st, const char *d) {
  return GWEN_StringList_HasString(st->purpose, d);
}




const GWEN_STRINGLIST *AB_Transaction_GetCategory(const AB_TRANSACTION *st) {
  assert(st);
  return st->category;
}


void AB_Transaction_SetCategory(AB_TRANSACTION *st, const GWEN_STRINGLIST *d) {
  assert(st);
  if (st->category)
    GWEN_StringList_free(st->category);
  if (d)
    st->category=GWEN_StringList_dup(d);
  else
    st->category=0;
  st->_modified=1;
}




void AB_Transaction_AddCategory(AB_TRANSACTION *st, const char *d, int chk){
  assert(st);
  assert(d);
  if (GWEN_StringList_AppendString(st->category, d, 0, chk))
    st->_modified=1;
}


void AB_Transaction_RemoveCategory(AB_TRANSACTION *st, const char *d) {
  if (GWEN_StringList_RemoveString(st->category, d))
    st->_modified=1;
}


void AB_Transaction_ClearCategory(AB_TRANSACTION *st) {
  if (GWEN_StringList_Count(st->category)) {
    GWEN_StringList_Clear(st->category);
    st->_modified=1;
  }
}


int AB_Transaction_HasCategory(const AB_TRANSACTION *st, const char *d) {
  return GWEN_StringList_HasString(st->category, d);
}




AB_TRANSACTION_PERIOD AB_Transaction_GetPeriod(const AB_TRANSACTION *st) {
  assert(st);
  return st->period;
}


void AB_Transaction_SetPeriod(AB_TRANSACTION *st, AB_TRANSACTION_PERIOD d) {
  assert(st);
  st->period=d;
  st->_modified=1;
}




int AB_Transaction_GetCycle(const AB_TRANSACTION *st) {
  assert(st);
  return st->cycle;
}


void AB_Transaction_SetCycle(AB_TRANSACTION *st, int d) {
  assert(st);
  st->cycle=d;
  st->_modified=1;
}




int AB_Transaction_GetExecutionDay(const AB_TRANSACTION *st) {
  assert(st);
  return st->executionDay;
}


void AB_Transaction_SetExecutionDay(AB_TRANSACTION *st, int d) {
  assert(st);
  st->executionDay=d;
  st->_modified=1;
}




const GWEN_TIME *AB_Transaction_GetFirstExecutionDate(const AB_TRANSACTION *st) {
  assert(st);
  return st->firstExecutionDate;
}


void AB_Transaction_SetFirstExecutionDate(AB_TRANSACTION *st, const GWEN_TIME *d) {
  assert(st);
  if (st->firstExecutionDate)
    GWEN_Time_free(st->firstExecutionDate);
  if (d)
    st->firstExecutionDate=GWEN_Time_dup(d);
  else
    st->firstExecutionDate=0;
  st->_modified=1;
}




const GWEN_TIME *AB_Transaction_GetLastExecutionDate(const AB_TRANSACTION *st) {
  assert(st);
  return st->lastExecutionDate;
}


void AB_Transaction_SetLastExecutionDate(AB_TRANSACTION *st, const GWEN_TIME *d) {
  assert(st);
  if (st->lastExecutionDate)
    GWEN_Time_free(st->lastExecutionDate);
  if (d)
    st->lastExecutionDate=GWEN_Time_dup(d);
  else
    st->lastExecutionDate=0;
  st->_modified=1;
}




const GWEN_TIME *AB_Transaction_GetNextExecutionDate(const AB_TRANSACTION *st) {
  assert(st);
  return st->nextExecutionDate;
}


void AB_Transaction_SetNextExecutionDate(AB_TRANSACTION *st, const GWEN_TIME *d) {
  assert(st);
  if (st->nextExecutionDate)
    GWEN_Time_free(st->nextExecutionDate);
  if (d)
    st->nextExecutionDate=GWEN_Time_dup(d);
  else
    st->nextExecutionDate=0;
  st->_modified=1;
}




AB_TRANSACTION_TYPE AB_Transaction_GetType(const AB_TRANSACTION *st) {
  assert(st);
  return st->type;
}


void AB_Transaction_SetType(AB_TRANSACTION *st, AB_TRANSACTION_TYPE d) {
  assert(st);
  st->type=d;
  st->_modified=1;
}




AB_TRANSACTION_SUBTYPE AB_Transaction_GetSubType(const AB_TRANSACTION *st) {
  assert(st);
  return st->subType;
}


void AB_Transaction_SetSubType(AB_TRANSACTION *st, AB_TRANSACTION_SUBTYPE d) {
  assert(st);
  st->subType=d;
  st->_modified=1;
}




AB_TRANSACTION_STATUS AB_Transaction_GetStatus(const AB_TRANSACTION *st) {
  assert(st);
  return st->status;
}


void AB_Transaction_SetStatus(AB_TRANSACTION *st, AB_TRANSACTION_STATUS d) {
  assert(st);
  st->status=d;
  st->_modified=1;
}




AB_TRANSACTION_CHARGE AB_Transaction_GetCharge(const AB_TRANSACTION *st) {
  assert(st);
  return st->charge;
}


void AB_Transaction_SetCharge(AB_TRANSACTION *st, AB_TRANSACTION_CHARGE d) {
  assert(st);
  st->charge=d;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteAddrStreet(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteAddrStreet;
}


void AB_Transaction_SetRemoteAddrStreet(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteAddrStreet)
    free(st->remoteAddrStreet);
  if (d && *d)
    st->remoteAddrStreet=strdup(d);
  else
    st->remoteAddrStreet=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteAddrZipcode(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteAddrZipcode;
}


void AB_Transaction_SetRemoteAddrZipcode(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteAddrZipcode)
    free(st->remoteAddrZipcode);
  if (d && *d)
    st->remoteAddrZipcode=strdup(d);
  else
    st->remoteAddrZipcode=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemoteAddrCity(const AB_TRANSACTION *st) {
  assert(st);
  return st->remoteAddrCity;
}


void AB_Transaction_SetRemoteAddrCity(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remoteAddrCity)
    free(st->remoteAddrCity);
  if (d && *d)
    st->remoteAddrCity=strdup(d);
  else
    st->remoteAddrCity=0;
  st->_modified=1;
}




const char *AB_Transaction_GetRemotePhone(const AB_TRANSACTION *st) {
  assert(st);
  return st->remotePhone;
}


void AB_Transaction_SetRemotePhone(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->remotePhone)
    free(st->remotePhone);
  if (d && *d)
    st->remotePhone=strdup(d);
  else
    st->remotePhone=0;
  st->_modified=1;
}




const char *AB_Transaction_GetUnitId(const AB_TRANSACTION *st) {
  assert(st);
  return st->unitId;
}


void AB_Transaction_SetUnitId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->unitId)
    free(st->unitId);
  if (d && *d)
    st->unitId=strdup(d);
  else
    st->unitId=0;
  st->_modified=1;
}




const char *AB_Transaction_GetUnitIdNameSpace(const AB_TRANSACTION *st) {
  assert(st);
  return st->unitIdNameSpace;
}


void AB_Transaction_SetUnitIdNameSpace(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->unitIdNameSpace)
    free(st->unitIdNameSpace);
  if (d && *d)
    st->unitIdNameSpace=strdup(d);
  else
    st->unitIdNameSpace=0;
  st->_modified=1;
}




const AB_VALUE *AB_Transaction_GetUnits(const AB_TRANSACTION *st) {
  assert(st);
  return st->units;
}


void AB_Transaction_SetUnits(AB_TRANSACTION *st, const AB_VALUE *d) {
  assert(st);
  if (st->units)
    AB_Value_free(st->units);
  if (d)
    st->units=AB_Value_dup(d);
  else
    st->units=0;
  st->_modified=1;
}




const AB_VALUE *AB_Transaction_GetUnitPrice(const AB_TRANSACTION *st) {
  assert(st);
  return st->unitPrice;
}


void AB_Transaction_SetUnitPrice(AB_TRANSACTION *st, const AB_VALUE *d) {
  assert(st);
  if (st->unitPrice)
    AB_Value_free(st->unitPrice);
  if (d)
    st->unitPrice=AB_Value_dup(d);
  else
    st->unitPrice=0;
  st->_modified=1;
}




const AB_VALUE *AB_Transaction_GetCommission(const AB_TRANSACTION *st) {
  assert(st);
  return st->commission;
}


void AB_Transaction_SetCommission(AB_TRANSACTION *st, const AB_VALUE *d) {
  assert(st);
  if (st->commission)
    AB_Value_free(st->commission);
  if (d)
    st->commission=AB_Value_dup(d);
  else
    st->commission=0;
  st->_modified=1;
}




const char *AB_Transaction_GetCreditorSchemeId(const AB_TRANSACTION *st) {
  assert(st);
  return st->creditorSchemeId;
}


void AB_Transaction_SetCreditorSchemeId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->creditorSchemeId)
    free(st->creditorSchemeId);
  if (d && *d)
    st->creditorSchemeId=strdup(d);
  else
    st->creditorSchemeId=0;
  st->_modified=1;
}




const char *AB_Transaction_GetMandateId(const AB_TRANSACTION *st) {
  assert(st);
  return st->mandateId;
}


void AB_Transaction_SetMandateId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->mandateId)
    free(st->mandateId);
  if (d && *d)
    st->mandateId=strdup(d);
  else
    st->mandateId=0;
  st->_modified=1;
}




const GWEN_DATE *AB_Transaction_GetMandateDate(const AB_TRANSACTION *st) {
  assert(st);
  return st->mandateDate;
}


void AB_Transaction_SetMandateDate(AB_TRANSACTION *st, const GWEN_DATE *d) {
  assert(st);
  if (st->mandateDate)
    GWEN_Date_free(st->mandateDate);
  if (d)
    st->mandateDate=GWEN_Date_dup(d);
  else
    st->mandateDate=0;
  st->_modified=1;
}




const char *AB_Transaction_GetMandateDebitorName(const AB_TRANSACTION *st) {
  assert(st);
  return st->mandateDebitorName;
}


void AB_Transaction_SetMandateDebitorName(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->mandateDebitorName)
    free(st->mandateDebitorName);
  if (d && *d)
    st->mandateDebitorName=strdup(d);
  else
    st->mandateDebitorName=0;
  st->_modified=1;
}




const char *AB_Transaction_GetOriginalCreditorSchemeId(const AB_TRANSACTION *st) {
  assert(st);
  return st->originalCreditorSchemeId;
}


void AB_Transaction_SetOriginalCreditorSchemeId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->originalCreditorSchemeId)
    free(st->originalCreditorSchemeId);
  if (d && *d)
    st->originalCreditorSchemeId=strdup(d);
  else
    st->originalCreditorSchemeId=0;
  st->_modified=1;
}




const char *AB_Transaction_GetOriginalMandateId(const AB_TRANSACTION *st) {
  assert(st);
  return st->originalMandateId;
}


void AB_Transaction_SetOriginalMandateId(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->originalMandateId)
    free(st->originalMandateId);
  if (d && *d)
    st->originalMandateId=strdup(d);
  else
    st->originalMandateId=0;
  st->_modified=1;
}




const char *AB_Transaction_GetOriginalCreditorName(const AB_TRANSACTION *st) {
  assert(st);
  return st->originalCreditorName;
}


void AB_Transaction_SetOriginalCreditorName(AB_TRANSACTION *st, const char *d) {
  assert(st);
  if (st->originalCreditorName)
    free(st->originalCreditorName);
  if (d && *d)
    st->originalCreditorName=strdup(d);
  else
    st->originalCreditorName=0;
  st->_modified=1;
}




AB_TRANSACTION_SEQUENCETYPE AB_Transaction_GetSequenceType(const AB_TRANSACTION *st) {
  assert(st);
  return st->sequenceType;
}


void AB_Transaction_SetSequenceType(AB_TRANSACTION *st, AB_TRANSACTION_SEQUENCETYPE d) {
  assert(st);
  st->sequenceType=d;
  st->_modified=1;
}




int AB_Transaction_IsModified(const AB_TRANSACTION *st) {
  assert(st);
  return st->_modified;
}


void AB_Transaction_SetModified(AB_TRANSACTION *st, int i) {
  assert(st);
  st->_modified=i;
}


void AB_Transaction_Attach(AB_TRANSACTION *st) {
  assert(st);
  st->_usage++;
}
AB_TRANSACTION *AB_Transaction_List2__freeAll_cb(AB_TRANSACTION *st, void *user_data) {
  AB_Transaction_free(st);
return 0;
}


void AB_Transaction_List2_freeAll(AB_TRANSACTION_LIST2 *stl) {
  if (stl) {
    AB_Transaction_List2_ForEach(stl, AB_Transaction_List2__freeAll_cb, 0);
    AB_Transaction_List2_free(stl); 
  }
}


AB_TRANSACTION_LIST *AB_Transaction_List_dup(const AB_TRANSACTION_LIST *stl) {
  if (stl) {
    AB_TRANSACTION_LIST *nl;
    AB_TRANSACTION *e;

    nl=AB_Transaction_List_new();
    e=AB_Transaction_List_First(stl);
    while(e) {
      AB_TRANSACTION *ne;

      ne=AB_Transaction_dup(e);
      assert(ne);
      AB_Transaction_List_Add(ne, nl);
      e=AB_Transaction_List_Next(e);
    } /* while (e) */
    return nl;
  }
  else
    return 0;
}




