/* effectUtil.cc
 */
#include "osl/effect_util/effectUtil.h"
#include "osl/effect_util/effectUtil.tcc"
#include "osl/eval/pieceEval.h"
#include "osl/eval/progressEval.h"
#include "osl/eval/ml/openMidEndingEval.h"
#include "osl/state/numEffectState.h"

void
osl::effect_util::EffectUtil::
findEffect(Player P, const NumEffectState& state, Square target,
	   PieceVector& out)
{
  effect_action::StorePiece store(&out);
  forEachEffect(P, state, target, store);
}

#ifndef DFPNSTATONE
namespace osl
{
  template Piece 
  EffectUtil::safeCaptureNotByKing<BLACK>(NumEffectState const&, Square, Piece);
  template Piece 
  EffectUtil::safeCaptureNotByKing<WHITE>(NumEffectState const&, Square, Piece);
}
#endif


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
