--- status: DRAFT
--- author(s): blasiak, kummini
--- notes: 

document { 
     Key => {(minors,ZZ,Matrix),
	  minors,
	  [minors,First],
	  [minors,Limit]},
     Headline => "ideal generated by minors",
     Usage => "minors(n,M)",
     Inputs => {
		   "n" => ZZ => "order of the minor",
		   "M" => Matrix => "a map between free modules",
		   First => List => "if given, should be a list of two integer lists, which will be the
		   first minor computed",
		   Limit => ZZ => "the maximum number of minors to find"
	  },
	Outputs => {
		   {"the ideal generated by the ", TT "n", " by ", TT "n", " minors
		   of the matrix ", TT "M"}
	},
	"Minors are generated in the same order as that used by ", 
	TO (subsets,ZZ,ZZ), ".",
     EXAMPLE lines ///
     R = ZZ[a..f];
     M = matrix{{a,b,c},{d,e,f}}
     minors(2,M)
     minors(2,M,Limit=>1)
     ///,
     PARA {
	  "When ", TT "n", " is negative, the unit ideal is returned, to preserve the expected ordering 
	  among the resulting ideals."
	  },
     EXAMPLE lines ///
     minors(1,M)
     minors(0,M)
     minors(-1,M)
     ///,
     SeeAlso => {"exteriorPower", "det"}
     }
