C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

	PROGRAM GRAF01
C
C	PROGRAM TO DEMONSTRATE GRAPH PLOTTING.
C	SEVEN ROUTINES EACH DISPLAYING A DIFFERENT FEATURE.
C
	CALL POPEN
      CALL PARSE_COMMAND_LINE ('graf01')
      CALL psetc("page_id_line", "off")

	CALL PSETC ('PAGE_ID_LINE_USER_TEXT','TESTS/GRAF01')
C
C   CURVE PLOTTING WITH SYMBOLS
C
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','graf01')
	CALL GRAF01_ONE
	CALL PNEW ('PAGE')
C
C   AREA CURVE PLOTTING
C
	CALL GRAF01_TWO
	CALL PNEW ('PAGE')
C
C   BAR CHART PLOTTING
C
	CALL GRAF01_THREE
	CALL PNEW ('PAGE')
C
C	MISSING DATA - IGNORED
C
	CALL GRAF01_FOUR
	CALL PNEW ('PAGE')
C
C	MISSING DATA - JOINED
C
	CALL GRAF01_FIVE
	CALL PNEW ('PAGE')
C
C	MISSING DATA - DROPPED
C
	CALL GRAF01_SIX


	CALL PCLOSE
	STOP
	END
	SUBROUTINE GRAF01_ONE
C
C	PLOT SIMPLE CURVE WITH SYMBOLS
C
	DIMENSION X(11),Y(11)
	DATA X/0.0,1.,2.,3.,4.,5.,6.,7.,8.,9.,10./
	DATA Y/0.0,4.,6.,8.,10.,15.,20.,30.,20.,10.,5./
C
C	SET UP AXIS SYSTEM
C
	CALL PSETC ('SUBPAGE_MAP_PROJECTION','NONE')  
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',40.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',5.0)
	CALL PAXIS
C
C	SET GRAPH PARAMETERS
C
	CALL PSETC ('GRAPH_TYPE','CURVE')
	CALL PSETC ('GRAPH_SYMBOL','ON')
	CALL PSETI ('GRAPH_SYMBOL_MARKER_INDEX',18)
	CALL PSETC ('GRAPH_LINE_COLOUR','RED')
	CALL PSET1R ('GRAPH_CURVE_X_VALUES',X,11)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',Y,11)
	CALL PGRAPH
C
C	PLOT TEXT
C
	CALL PSETC ('TEXT_LINE_1','Graph Plotting in '//
     x             'CURVE mode with SYMBOLS')
	CALL PTEXT
	CALL PSETC ('GRAPH_SYMBOL','OFF')
	RETURN
C
	END
	SUBROUTINE GRAF01_TWO
C
C	PLOT AREA CURVE
C
	DIMENSION X1(11),X2(11),Y1(11),Y2(11)
	DATA X1/1.,2.,3.,4.,5.,6.,7.,8.,9.,10.,11.0/
	DATA Y1/4.5,5.,6.,7.,9.,9.5,9.8,8.,7.,6.5,5.0/
	DATA X2/1.,2.,3.,4.,5.,6.,7.,8.,9.,10.,11.0/
	DATA Y2/2.5,2.,3.,2.,1.,2.5,3.8,6.,2.,3.5,4.5/
C
C	SET UP AXIS SYSTEM
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',11.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	SET GRAPH PARAMETERS FOR AREA CURVE WITH GREEN DOT SHADING
C
	CALL PSETC ('GRAPH_TYPE','AREA')
	CALL PSETC ('GRAPH_SHADE','ON')
	CALL PSETC ('GRAPH_SHADE_STYLE','HATCH')
	CALL PSETC ('GRAPH_SHADE_COLOUR','GREEN')
	CALL PSET1R ('GRAPH_CURVE_X_VALUES',X1,11)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',Y1,11)
	CALL PSET1R ('GRAPH_CURVE2_X_VALUES',X2,11)
	CALL PSET1R ('GRAPH_CURVE2_Y_VALUES',Y2,11)
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','Graph Plotting in '//
     x             'AREA CURVE mode')
	CALL PTEXT
	RETURN
C
	END
	SUBROUTINE GRAF01_THREE
C
C	PLOT BAR CHART
C
	DIMENSION X(11),YL(11),YU(11)
	DATA X/1.,2.,3.,4.,5.,6.,7.,8.,9.,10.,11.0/
	DATA YL /11*0.0/
	DATA YU/3.0,5.,9.,1.,2.,10.,9.,8.,0.,3.,10./
C
C	SET UP AXIS SYSTEM
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',12.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	SET GRAPH PARAMETERS FOR BAR CHART WITH SOLID RED BARS
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETC ('GRAPH_SHADE','ON')
	CALL PSETC ('GRAPH_SHADE_STYLE','AREA_FILL')
cCALL PSETC ('GRAPH_SHADE_STYLE','DOT')
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,11)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL,11)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU,11)
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','Graph Plotting in '//
     x             'BAR mode')
	CALL PTEXT
	RETURN
C
	END
	SUBROUTINE GRAF01_FOUR
C
C	MISSING DATA IN CURVE PLOTTING
C
	DIMENSION X(11),Y(11)
	DATA X/0.0,1.,2.,3.,4.,5.,6.,7.,8.,9.,10./
	DATA Y/5.0,10.,33.,50.,-999.,-999.,35.,30.,20.,10.,5./
C
C	SET UP AXIS SYSTEM
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',70.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',5.0)
	CALL PAXIS
C
C	CURVE WITH MISSING DATA IGNORED (DEFAULT)
C
	CALL PSETC ('GRAPH_TYPE','CURVE')
	CALL PSETC ('GRAPH_LINE_COLOUR','RED')
	CALL PSET1R ('GRAPH_CURVE_X_VALUES',X,11)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',Y,11)
	CALL PSETR ('GRAPH_Y_MISSING_VALUE',-999.)
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','CURVE Plotting with '//
     x    ' MISSING_DATA_MODE = IGNORE')
	CALL PTEXT
	RETURN
	END
	SUBROUTINE GRAF01_FIVE
	DIMENSION X(11),Y(11)
	DATA X/0.0,1.,2.,3.,4.,5.,6.,7.,8.,9.,10./
	DATA Y/5.0,10.,33.,50.,-999.,-999.,35.,30.,20.,10.,5./
C
C	SET UP AXIS SYSTEM
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',70.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',5.0)
	CALL PAXIS
C
C	CURVE WITH MISSING DATA JOINED
C
	CALL PSETC ('GRAPH_MISSING_DATA_MODE','JOIN')
	CALL PSETC ('GRAPH_TYPE','CURVE')
	CALL PSETC ('GRAPH_LINE_COLOUR','RED')
	CALL PSET1R ('GRAPH_CURVE_X_VALUES',X,11)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',Y,11)
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','CURVE Plotting with '//
     x    ' MISSING_DATA_MODE = JOIN')
	CALL PTEXT
	RETURN
	END
	SUBROUTINE GRAF01_SIX
	DIMENSION X(11),Y(11)
	DATA X/0.0,1.,2.,3.,4.,5.,6.,7.,8.,9.,10./
	DATA Y/5.0,10.,33.,50.,-999.,-999.,35.,30.,20.,10.,5./
C
C	SET UP AXIS SYSTEM    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')       
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',70.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',5.0) 
	CALL PAXIS
C
C	CURVE WITH MISSING DATA DROPPED
C
	CALL PSETC ('GRAPH_MISSING_DATA_MODE','DROP')
	CALL PSETC ('GRAPH_TYPE','CURVE')    
	CALL PSETC ('GRAPH_LINE_COLOUR','BLUE')
	CALL PSET1R ('GRAPH_CURVE_X_VALUES',X,11)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',Y,11)
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','CURVE Plotting with '//
     x    ' MISSING_DATA_MODE = DROP')
	CALL PTEXT 
	RETURN    
C
	END



C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END
