/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_LOGGINGSINK_H
#define MEDIASCANNER_LOGGINGSINK_H

// C++ Standard Library
#include <string>

// Media Scanner Library
#include "mediascanner/logging.h"

namespace mediascanner {

class LoggingSink {
    class Private;
public:
    explicit LoggingSink(logging::Domain *level = logging::trace());
    ~LoggingSink();

    void reset();

    std::string get() const;
    std::string take();

    void ignore(const std::string &domain,
                const std::string &pattern);

private:
    Private *const d;
};

} // namespace mediascanner

#endif // MEDIASCANNER_LOGGINGSINK_H
