/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File TextLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef TextLine_H
#define TextLine_H

#include "UITextLine.h"
#include "RequestPanelLine.h"

class TextLine : public XRequestPanelLine<UITextLine_c> {
public:

// -- Contructors

	TextLine(RequestPanel&,const Parameter&);

// -- Destructor

	virtual ~TextLine(); 

private:

// No copy allowed

	TextLine(const TextLine&);
	TextLine& operator=(const TextLine&);

// -- Members
	
	bool changed_;

// -- Overridden methods

	// From XD

	virtual void activateCB(Widget,XtPointer);
	virtual void changedCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void refresh(const vector<string>&);
	virtual void apply();
	virtual void set(Request&);
	virtual void update();

};

#endif
