/*******************************************************************************
*                                                                              *
*   (C) 1997-2014 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

/****************************************************************************
 * We now include this header file if it was not included before.
 ****************************************************************************/
#ifndef fac_test_dat256_included
#define fac_test_dat256_included

	#include "types.h"

	struct testFac256{
		char p[80];
		char q[80];
	};

	/* 256-bit Factors are easier to give in character-string form: */
	/* EWM: These are from my April 2006 shakedown runs of the P4WORD functionality -
	ran ??? 64-65-digit test exponents up to k = 10^10; ??? had factors below this bound,
	compared to ??? predicted by theory (Dickman's function).
	*/
	static const struct testFac256 fac256[] =
	{
		{"1000000000000000000000000000000000000000000000000000000001059"			,"40000000000000000000000000000000000000000000000000000000042361"					},	/* k =          20 */
		{"12160287649628674460477464915995054973742562690104903778198683593"		,"543592246870442485937175551111623340804481341938942752102988291735322287319"		},	/* k = 22351126163 */
		{"20992192221842725502542568876717904946016534668049886272327917860857843"	,"41984384443685451005085137753435809892033069336099772544655835721715687"			},	/* k =           1 */
		{"24247014121478057345510500801908699603302763478708108175450119307"		,"2079083331892761004876676951418337621569030224230467189523407626117207889809"		},	/* k = 42872976472 */
		{"3082533446850352619311881710100031378387528865875332083814206171"			,"6165066893700705238623763420200062756775057731750664167628412343"					},	/* k =           1 */
		{"32046927906821207388377814233562823608963208068222468012248261177"		,"192281567440927244330266885401376941653779248409334808073489567063"				},	/* k =           3 */
		{"32046927906821207388377814233562823608963208068222468012248261177"		,"7261513394406617382132528927183000201554973316178529026895333500096431"			},	/* k =      113295 */
		{"3444030707469211201913020330380197621101100449293215160842444859637669"	,"53389364027187712052055641161553823522309259164943421423379580214103144839"		},	/* k =        7751 */
		{"3600113305305488204665213841469519415116094330572703657595919530921861"	,"1605650534166247739280685373295405659141778071435425831287780110791150007"		},	/* k =         223 */
		{"3852254995466672782398645659611635488623057745649803559363456817432411"	,"22788707831582286845380020155651359827337650244785629920055214225748565104481"	},	/* k =     2957840 */
		{"3873455283316355076479185358932261854896321329330898570642046752590709"	,"2921297999392661936999377930740968974773127205440094407601101388055871276457"		},	/* k =      377092 */
		{"4088350865739177150968288747826569959957449066175834413752239709"			,"532990125664685046817433867476654272539732719859211180852051986382913"			},	/* k =       65184 */
		{"41927056387293174872332083760112302991136793862708943879936201629"		,"586978789422104448212649172641572241875915114077925214319106822807"				},	/* k =           7 */
		{"53710507922796892589235420199561121290219608640344181598136297747713099"	,"107421015845593785178470840399122242580439217280688363196272595495426199"			},	/* k =           1 */
		{"54973742562690104903778198683593814657412680492564879855614537234786733"	,"769632395877661468652894781570313405203777526895908317978603521287014263"			},	/* k =           7 */
		{"5509792592309907965473761255176567513575178296664547791745011299"			,"742776869444172678136618913571387191947269048779332840473151581151737887"			},	/* k =    67405157 */
		{"570658748822569815793678976697422057505968344086973502014102067"			,"322107495328491256282531776450837995333351643082236449882652963072723913"			},	/* k =   282224268 */
		{"62735676303544776280350450777235547105859548702790814356240145171"		,"19573531006705970199469340642497490697028179195270734079146925293353"				},	/* k =         156 */
		{"62749567351885752724891227938183011949129833673362440656643086021"		,"6902452408707432799738035073200131314404281704069868472230739462311"				},	/* k =          55 */
		{"6402474964732639141992726042699227967823547816360093417216412199"			,"59547637466852043611708058111909725657028150812842162510646420336832110759"		},	/* k =  4650360821 */
		{"7195429162991930645537799140373404328752628889639958794757291746426357"	,"957164768977838582192020192849031737427989705415465878713793977276619713569"		},	/* k =       66512 */
		{"7095890455635792122103334669749923563025494780249011419521238281"			,"93538027986191011753566157616643492407802072193242468532128963020143"				},	/* k =        6591 */
		{"83011949129833673362440656643086021394946395224737190702179860943"		,"2473258012374264464160556924024104921441032899325819859780746776935743"			},	/* k =       14897 */
		{"85102283345085048608250393021332197155184306354550076682829493041"		,"23658434769933643513093609259930350809141237166564921317826599065399"				},	/* k =         139 */
		{"9104140792886215078424516709087000699282120660418371806535567252532567"	,"207009953348646758453216660931220221900276859576592938137005728188085508447"		},	/* k =       11369 */
		{"9729971208443357326548938239119325974636673058360414281388303203"			,"215547993800818444194894669517580993600170370441819907413109392526239783"			},	/* k =    11076497 */
		{""	,""		},	/* k =             */
		{""	,""		},	/* k =             */
		{""	,""		},	/* k =             */
		{""	,""		},	/* k =             */
		{""	,""		},	/* k =             */
		{""	,""		},	/* k =             */
		{""	,""		},	/* k =             */
		{"",""}
	};

#endif	/* #ifndef fac_test_dat256_included */
