require 'gem2deb/rake/spectask'
require 'gem2deb/rake/testtask'

EXCLUDED_TESTS=['nanoc/test/filters/test_markaby.rb',
                'nanoc/test/filters/test_rainpress.rb']

Gem2Deb::Rake::TestTask.new(:test_nanoc) do |t|
  t.libs = ['nanoc/test', 'nanoc/lib', 'nanoc-core/lib', 'nanoc-cli/lib', 'nanoc-spec/lib']
  t.test_files = FileList['nanoc/test/**/*_spec.rb'] + FileList['nanoc/test/**/test_*.rb']-EXCLUDED_TESTS
end
task default: :test_nanoc

ENV["RUBYLIB"] ||= ""
ENV["RUBYLIB"] += ":" + File.expand_path(File.dirname(__FILE__) + "/../nanoc-spec/lib")


%w[
  nanoc
  nanoc-core
  nanoc-cli
  nanoc-live
  nanoc-external
  nanoc-checking
  nanoc-deploying
].each do |subproject|
  task "spec-#{subproject}" do
    Dir.chdir(subproject) do |dir|
      puts "======= entering ./#{dir}/"
      puts
      begin
        mv 'lib',  'lib.off'
        ruby "-S", "rspec", "--exclude-pattern=spec/**/{gem,meta,manifest}_spec.rb"
      ensure
        mv 'lib.off',  'lib'
        puts
        puts "======= exiting ./#{dir}/"
      end
    end
  end
  task default: "spec-#{subproject}"
end
