/*
 * Decompiled with CFR 0.152.
 */
package ptbgui;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckListRenderer
extends JCheckBox
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private SortedSet<String> m_undefSel;

    public void setUndefinedSelection(SortedSet<String> undefSel) {
        if (this.m_undefSel == null) {
            this.m_undefSel = new TreeSet<String>();
        } else {
            this.m_undefSel.clear();
        }
        this.m_undefSel.addAll(undefSel);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        JCheckBox b = (JCheckBox)value;
        String s = b.getText();
        this.setText(s);
        boolean selected = b.isSelected();
        this.setSelected(selected);
        if (selected) {
            this.setBackground(SystemColor.textHighlight);
            this.setForeground(SystemColor.textHighlightText);
        } else if (this.m_undefSel != null && this.m_undefSel.contains(s)) {
            Color n = list.getBackground();
            SystemColor h = SystemColor.textHighlight;
            Color u = new Color((n.getRed() + h.getRed()) / 2, (n.getGreen() + h.getGreen()) / 2, (n.getBlue() + h.getBlue()) / 2);
            this.setBackground(u);
            this.setForeground(list.getForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }
}

