/* This is part of the netCDF package. Copyright 2005 University
   Corporation for Atmospheric Research/Unidata See COPYRIGHT file for
   conditions of use. See www.unidata.ucar.edu for more info.

   Test libcf file stuff.

   $Id: tst_files.c,v 1.1.1.1 2009/07/06 15:06:30 ed Exp $
*/

#include <config.h>
#include <libcf.h>
#include <netcdf.h>
#include <nc_tests.h>

#define FILE_NAME "tst_files.nc"

int
main(int argc, char **argv)
{
   printf("\n*** Testing libcf file stuff.\n");
   printf("*** testing file convention...");
   {
      int ncid;
      int cf_convention;

      /* Create a file and indicate it follows CF conventions. */
      if (nc_create(FILE_NAME, 0, &ncid)) ERR;

      if (nccf_inq_convention(ncid, &cf_convention)) ERR;
      if (cf_convention) ERR;

      if (nccf_def_convention(ncid)) ERR;

      /* Check it. */
      if (nccf_inq_convention(ncid, &cf_convention)) ERR;
      if (!cf_convention) ERR;

      if (nc_close(ncid)) ERR;
      if (nc_open(FILE_NAME, 0, &ncid)) ERR;

      /* Check it. */
      if (nccf_inq_convention(ncid, &cf_convention)) ERR;
      if (!cf_convention) ERR;

      if (nc_close(ncid)) ERR;

   }
   SUMMARIZE_ERR;

#define C_STRING "Gaal_Dornick"
   printf("*** testing file convention append...");
   {
      int ncid;
      int cf_convention;

      /* Create a file with an attribute called "Convention". */
      if (nc_create(FILE_NAME, 0, &ncid)) ERR;
      if (nc_put_att_text(ncid, NC_GLOBAL, CF_CONVENTIONS, strlen(C_STRING), 
			  C_STRING)) ERR;
      if (nccf_def_convention(ncid)) ERR;
      if (nc_close(ncid)) ERR;

      if (nc_open(FILE_NAME, 0, &ncid)) ERR;
      if (nccf_inq_convention(ncid, &cf_convention)) ERR;
      if (!cf_convention) ERR;
      if (nc_close(ncid)) ERR;

   }
   SUMMARIZE_ERR;

#define TITLE "The_Complete_Works_of_Edward_James_Hartnett"
#define HISTORY "This file was generated by a grant from the Obscurity Foundation"

   printf("*** testing file annotation...");
   {
      int ncid;
      int cf_convention;
      size_t tlen, hlen;
      char *history_in, *title_in;

      /* CReate a file and use nccd_def_file to annotate it. */
      if (nc_create(FILE_NAME, 0, &ncid)) ERR;
      if (nccf_def_file(ncid, TITLE, HISTORY)) ERR;

      /* Check the file. */
      if (nccf_inq_convention(ncid, &cf_convention)) ERR;
      if (!cf_convention) ERR;
      if (nccf_inq_file(ncid, &tlen, NULL, &hlen, NULL)) ERR;
      if (tlen != strlen(TITLE) + 1 || hlen != strlen(HISTORY) + 20) ERR;
      if (!(history_in = malloc(hlen))) ERR;
      if (!(title_in = malloc(tlen))) ERR;
      if (nccf_inq_file(ncid, NULL, title_in, NULL, history_in)) ERR;
      if (strncmp(title_in, TITLE, tlen) || 
	  strncmp(history_in + 18, HISTORY, strlen(HISTORY))) ERR;

      if (nc_close(ncid)) ERR;

      if (nc_open(FILE_NAME, 0, &ncid)) ERR;

      /* Check the file. */
      if (nccf_inq_convention(ncid, &cf_convention)) ERR;
      if (!cf_convention) ERR;
      if (nccf_inq_file(ncid, &tlen, NULL, &hlen, NULL)) ERR;
      if (tlen != strlen(TITLE) + 1 || hlen != strlen(HISTORY) + 20) ERR;
      if (!(history_in = malloc(hlen))) ERR;
      if (!(title_in = malloc(tlen))) ERR;
      if (nccf_inq_file(ncid, NULL, title_in, NULL, history_in)) ERR;
      if (strncmp(title_in, TITLE, tlen) || 
	  strncmp(history_in + 18, HISTORY, strlen(HISTORY))) ERR;

      if (nc_close(ncid)) ERR;

   }
   SUMMARIZE_ERR;

#define INSTITUTION "Unidata Asylum for Hopelessly Insane Programmers"
#define SOURCE "These data were generated from the feverish imagination of a diseased mind."
#define COMMENT "I think that lawn mowers smell like grass."
#define REFERENCES "References will be fabricated upon request."
#define MAX_LEN 200

   printf("*** testing file notes...");
   {
      int ncid;
      size_t ilen, slen, clen, rlen;
      char inst_in[MAX_LEN], source_in[MAX_LEN];
      char comment_in[MAX_LEN], ref_in[MAX_LEN];

      /* CReate a file and use nccd_def_file to annotate it. */
      if (nc_create(FILE_NAME, 0, &ncid)) ERR;
      if (nccf_def_notes(ncid, NC_GLOBAL, INSTITUTION, SOURCE, 
			 COMMENT, REFERENCES)) ERR;

      /* Check the file. */
      if (nccf_inq_notes(ncid, NC_GLOBAL, &ilen, inst_in, &slen, source_in,
			 &clen, comment_in, &rlen, ref_in)) ERR;
      if (ilen != strlen(INSTITUTION) + 1 || slen != strlen(SOURCE) + 1 ||
	  clen != strlen(COMMENT) + 1 || rlen != strlen(REFERENCES) + 1) ERR;
      if (strncmp(inst_in, INSTITUTION, ilen) || 
	  strncmp(source_in, SOURCE, slen) || 
	  strncmp(comment_in, COMMENT, clen) || 
	  strncmp(ref_in, REFERENCES, rlen)) ERR;

      if (nc_close(ncid)) ERR;

      if (nc_open(FILE_NAME, 0, &ncid)) ERR;

      /* Check the file. */
      if (nccf_inq_notes(ncid, NC_GLOBAL, &ilen, inst_in, &slen, source_in,
			 &clen, comment_in, &rlen, ref_in)) ERR;
      if (ilen != strlen(INSTITUTION) + 1 || slen != strlen(SOURCE) + 1 ||
	  clen != strlen(COMMENT) + 1 || rlen != strlen(REFERENCES) + 1) ERR;
      if (strncmp(inst_in, INSTITUTION, ilen) || 
	  strncmp(source_in, SOURCE, slen) || 
	  strncmp(comment_in, COMMENT, clen) || 
	  strncmp(ref_in, REFERENCES, rlen)) ERR;

      if (nc_close(ncid)) ERR;

   }
   SUMMARIZE_ERR;

   FINAL_RESULTS;
}

