/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.javafx.experiments.dukepad.chess.client3d;

import java.util.*;
import javafx.util.Duration;
import javafx.animation.*;
import javafx.scene.*;
import javafx.scene.paint.*;
import javafx.scene.image.*;
import javafx.scene.shape.*;
import javafx.scene.transform.*;

public class Duke3DModel {
    private static Node NODE_0,NODE_1,NODE_2,NODE_3,NODE_4,NODE_5,NODE_6,NODE_7,NODE_8,NODE_9,NODE_10,NODE_11,NODE_12;
    private static TriangleMesh MESH_0,MESH_1,MESH_2,MESH_3,MESH_4,MESH_5,MESH_6,MESH_7,MESH_8,MESH_9,MESH_10,MESH_11;
    public static final MeshView[] MESHVIEWS = new MeshView[]{ new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView()};
    public static final Node ROOT;
    public static final Map<String,MeshView> MESHVIEW_MAP;
    // ======== NODE CODE ===============
    private static void method0(){
        NODE_1 = MESHVIEWS[0];
        MESHVIEWS[0].setId("hat_pawn");
        MESHVIEWS[0].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_0 = new PhongMaterial();
        MATERIAL_0.setDiffuseColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_0.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_0.setSpecularPower(18.0);
        MESHVIEWS[0].setMaterial(MATERIAL_0);
        MESH_0 = new TriangleMesh();
        MESHVIEWS[0].setMesh(MESH_0);
        MESH_0.getPoints().ensureCapacity(1062);
        MESH_0.getPoints().addAll(-0.0f,54.997025f,-1.0E-5f,2.147521f,54.628864f,0.889522f,2.32446f,54.628864f,-1.0E-5f,1.643641f,54.628864f,1.643631f,0.889532f,54.628864f,2.147511f,-0.0f,54.628864f,2.324449f,-0.889533f,54.628864f,2.14751f,-1.643641f,54.628864f,1.643631f,-2.147521f,54.628864f,0.889521f,-2.32446f,54.628864f,-1.1E-5f,-2.14752f,54.628864f,-0.889543f,-1.64364f,54.628864f,-1.643652f,-0.889531f,54.628864f,-2.147531f,1.0E-6f,54.62887f,-2.324469f,0.889533f,54.628864f,-2.14753f,1.643642f,54.628864f,-1.64365f,2.147521f,54.628864f,-0.889541f,4.084826f,53.560432f,1.691981f,4.421384f,53.560432f,-1.0E-5f,3.12639f,53.560432f,3.126381f,1.69199f,53.560432f,4.084817f,-1.0E-6f,53.560432f,4.421374f,-1.691991f,53.560432f,4.084816f,-3.126392f,53.560432f,3.12638f,-4.084827f,53.560432f,1.691979f,-4.421384f,53.560432f,-1.2E-5f,-4.084826f,53.560432f,-1.692002f,-3.12639f,53.560432f,-3.126402f,-1.691989f,53.560432f,-4.084837f,2.0E-6f,53.560432f,-4.421394f,1.691993f,53.560432f,-4.084836f,3.126392f,53.560432f,-3.126399f,4.084828f,53.560432f,-1.691998f,5.622281f,51.896297f,2.328815f,6.085514f,51.896297f,-1.0E-5f,4.303108f,51.896297f,4.303098f,2.328825f,51.896297f,5.622272f,-1.0E-6f,51.896297f,6.085504f,-2.328826f,51.896297f,5.622271f,-4.303109f,51.896297f,4.303096f,-5.622282f,51.896297f,2.328813f,-6.085514f,51.896297f,-1.2E-5f,-5.62228f,51.896297f,-2.328838f,-4.303106f,51.896297f,-4.30312f,-2.328823f,51.896297f,-5.622293f,3.0E-6f,51.896297f,-6.085524f,2.328828f,51.896297f,-5.62229f,4.30311f,51.896297f,-4.303115f,5.622283f,51.896297f,-2.328832f,6.609388f,49.79937f,2.737688f,7.153951f,49.79937f,-1.0E-5f,5.058607f,49.79937f,5.058597f,2.737697f,49.79937f,6.609378f,-1.0E-6f,49.79937f,7.15394f,-2.737699f,49.79937f,6.609378f,-5.058608f,49.79937f,5.058595f,-6.609389f,49.79937f,2.737686f,-7.153951f,49.79937f,-1.3E-5f,-6.609387f,49.79937f,-2.737711f,-5.058605f,49.79937f,-5.05862f,-2.737695f,49.79937f,-6.609399f,4.0E-6f,49.79937f,-7.153961f,2.737702f,49.79937f,-6.609396f,5.05861f,49.79937f,-5.058614f,6.60939f,49.79937f,-2.737704f,6.949521f,47.47492f,2.878576f,7.522109f,47.47492f,-1.0E-5f,5.318933f,47.47492f,5.318924f,2.878585f,47.47492f,6.949513f,-1.0E-6f,47.474915f,7.522098f,-2.878587f,47.474915f,6.949511f,-5.318935f,47.474915f,5.318922f,-6.949523f,47.474915f,2.878574f,-7.522109f,47.474915f,-1.3E-5f,-6.949521f,47.474915f,-2.878599f,-5.318931f,47.474915f,-5.318946f,-2.878583f,47.474915f,-6.949533f,4.0E-6f,47.474915f,-7.522118f,2.87859f,47.474915f,-6.94953f,5.318936f,47.474915f,-5.31894f,6.949523f,47.474915f,-2.878592f,6.609388f,45.15045f,2.737688f,7.153951f,45.15045f,-1.0E-5f,5.058607f,45.15045f,5.058597f,2.737697f,45.15045f,6.609378f,-1.0E-6f,45.15045f,7.15394f,-2.737699f,45.15045f,6.609378f,-5.058608f,45.15045f,5.058595f,-6.609389f,45.15045f,2.737686f,-7.153951f,45.15045f,-1.3E-5f,-6.609388f,45.15045f,-2.737711f,-5.058604f,45.15045f,-5.05862f,-2.737695f,45.15045f,-6.609399f,4.0E-6f,45.15045f,-7.15396f,2.737702f,45.15045f,-6.609396f,5.05861f,45.15045f,-5.058614f,6.60939f,45.15045f,-2.737704f,6.085514f,43.053535f,-1.0E-5f,5.622281f,43.053535f,2.328815f,4.914556f,42.24214f,2.035666f,5.319477f,42.24214f,-1.0E-5f,4.303107f,43.053535f,4.303097f,3.761438f,42.24214f,3.761428f,2.328825f,43.053535f,5.622272f,2.035676f,42.24214f,4.914546f,-1.0E-6f,43.053535f,6.085504f,-0.0f,42.24214f,5.319467f,-2.328827f,43.053535f,5.622271f,-2.035676f,42.24214f,4.914546f,-4.303109f,43.053535f,4.303097f,-3.761438f,42.24214f,3.761428f,-5.622281f,43.053535f,2.328813f,-4.914556f,42.24214f,2.035666f,-6.085514f,43.053535f,-1.2E-5f,-5.319477f,42.24214f,-1.0E-5f,-5.622281f,43.053535f,-2.328838f,-4.914556f,42.24214f,-2.035686f,-4.303106f,43.053535f,-4.30312f,-3.761438f,42.24214f,-3.761448f,-2.328823f,43.053535f,-5.622292f,-2.035676f,42.24214f,-4.914566f,3.0E-6f,43.053535f,-6.085523f,-0.0f,42.24214f,-5.319487f,2.328829f,43.053535f,-5.62229f,2.035676f,42.24214f,-4.914566f,4.30311f,43.053535f,-4.303116f,3.761438f,42.24214f,-3.761448f,5.622282f,43.053535f,-2.328832f,4.914556f,42.24214f,-2.035686f,5.138859f,41.945183f,2.128575f,5.562262f,41.945183f,-1.0E-5f,3.933113f,41.945183f,3.933103f,2.128585f,41.945183f,5.138849f,-0.0f,41.945183f,5.562251f,-2.128585f,41.945183f,5.138849f,-3.933113f,41.945183f,3.933103f,-5.138859f,41.945183f,2.128575f,-5.562262f,41.945183f,-1.0E-5f,-5.138859f,41.945183f,-2.128595f,-3.933113f,41.945183f,-3.933123f,-2.128585f,41.945183f,-5.138869f,-0.0f,41.945183f,-5.562272f,2.128585f,41.945183f,-5.138869f,3.933113f,41.945183f,-3.933123f,5.138859f,41.945183f,-2.128595f,5.616264f,41.583633f,2.326323f,6.079001f,41.583633f,-1.0E-5f,4.298502f,41.583633f,4.298492f,2.326333f,41.583633f,5.616254f,-0.0f,41.583633f,6.078991f,-2.326333f,41.583633f,5.616254f,-4.298502f,41.583633f,4.298492f,-5.616264f,41.583633f,2.326323f,-6.079001f,41.583633f,-1.0E-5f,-5.616264f,41.583633f,-2.326343f,-4.298502f,41.583633f,-4.298512f,-2.326333f,41.583633f,-5.616274f,-0.0f,41.583633f,-6.079011f,2.326333f,41.583633f,-5.616274f,4.298502f,41.583633f,-4.298512f,5.616264f,41.583633f,-2.326343f,5.616264f,41.02081f,2.326323f,6.079001f,41.02081f,-1.0E-5f,4.298502f,41.02081f,4.298492f,2.326333f,41.02081f,5.616254f,-0.0f,41.02081f,6.078991f,-2.326333f,41.02081f,5.616254f,-4.298502f,41.02081f,4.298492f,-5.616264f,41.02081f,2.326323f,-6.079001f,41.02081f,-1.0E-5f,-5.616264f,41.02081f,-2.326343f,-4.298502f,41.02081f,-4.298512f,-2.326333f,41.02081f,-5.616274f,-0.0f,41.02081f,-6.079011f,2.326333f,41.02081f,-5.616274f,4.298502f,41.02081f,-4.298512f,5.616264f,41.02081f,-2.326343f,5.049409f,40.61489f,2.091524f,5.465441f,40.61489f,-1.0E-5f,3.86465f,40.61489f,3.86464f,2.091534f,40.61489f,5.049399f,-0.0f,40.61489f,5.465431f,-2.091534f,40.61489f,5.049399f,-3.86465f,40.61489f,3.86464f,-5.049409f,40.61489f,2.091524f,-5.465441f,40.61489f,-1.0E-5f,-5.049409f,40.61489f,-2.091544f,-3.86465f,40.61489f,-3.86466f,-2.091534f,40.61489f,-5.049419f,-0.0f,40.61489f,-5.465451f,2.091534f,40.61489f,-5.049419f,3.86465f,40.61489f,-3.86466f,5.049409f,40.61489f,-2.091544f,4.622763f,39.818157f,1.914801f,5.003642f,39.818157f,-1.0E-5f,3.53811f,39.818157f,3.5381f,1.914811f,39.818157f,4.622753f,-0.0f,39.818157f,5.003632f,-1.914811f,39.818157f,4.622753f,-3.53811f,39.818157f,3.5381f,-4.622763f,39.818157f,1.914801f,-5.003642f,39.818157f,-1.0E-5f,-4.622763f,39.818157f,-1.914821f,-3.53811f,39.818157f,-3.53812f,-1.914811f,39.818157f,-4.622773f,-0.0f,39.818157f,-5.003652f,1.914811f,39.818157f,-4.622773f,3.53811f,39.818157f,-3.53812f,4.622763f,39.818157f,-1.914821f,4.993624f,38.62181f,2.068417f,5.40506f,38.62181f,-1.0E-5f,3.821954f,38.62181f,3.821944f,2.068427f,38.62181f,4.993614f,-0.0f,38.62181f,5.40505f,-2.068427f,38.62181f,4.993614f,-3.821954f,38.62181f,3.821944f,-4.993624f,38.62181f,2.068417f,-5.40506f,38.62181f,-1.0E-5f,-4.993624f,38.62181f,-2.068437f,-3.821954f,38.62181f,-3.821965f,-2.068427f,38.62181f,-4.993634f,-0.0f,38.62181f,-5.40507f,2.068427f,38.62181f,-4.993634f,3.821954f,38.62181f,-3.821965f,4.993624f,38.62181f,-2.068437f,6.752098f,38.192097f,2.796801f,7.308418f,38.192097f,-1.0E-5f,5.167833f,38.192097f,5.167823f,2.796811f,38.192097f,6.752088f,-0.0f,38.192097f,7.308408f,-2.796811f,38.192097f,6.752088f,-5.167833f,38.192097f,5.167823f,-6.752098f,38.192097f,2.796801f,-7.308418f,38.192097f,-1.0E-5f,-6.752098f,38.192097f,-2.796821f,-5.167833f,38.192097f,-5.167843f,-2.796811f,38.192097f,-6.752108f,-0.0f,38.192097f,-7.308428f,2.796811f,38.192097f,-6.752108f,5.167833f,38.192097f,-5.167843f,6.752098f,38.192097f,-2.796821f,7.071821f,37.814346f,2.929234f,7.654484f,37.814346f,-1.0E-5f,5.412537f,37.814346f,5.412527f,2.929244f,37.814346f,7.071811f,-0.0f,37.814346f,7.654474f,-2.929244f,37.814346f,7.071811f,-5.412537f,37.814346f,5.412527f,-7.071821f,37.814346f,2.929234f,-7.654484f,37.814346f,-1.0E-5f,-7.071821f,37.814346f,-2.929254f,-5.412537f,37.814346f,-5.412547f,-2.929244f,37.814346f,-7.071831f,-0.0f,37.814346f,-7.654494f,2.929244f,37.814346f,-7.071831f,5.412537f,37.814346f,-5.412547f,7.071821f,37.814346f,-2.929254f,6.917257f,37.237564f,2.865212f,7.487185f,37.237564f,-1.0E-5f,5.294239f,37.237564f,5.294229f,2.865222f,37.237564f,6.917247f,-0.0f,37.237564f,7.487175f,-2.865222f,37.237564f,6.917247f,-5.294239f,37.237564f,5.294229f,-6.917257f,37.237564f,2.865212f,-7.487185f,37.237564f,-1.0E-5f,-6.917257f,37.237564f,-2.865232f,-5.294239f,37.237564f,-5.294249f,-2.865222f,37.237564f,-6.917267f,-0.0f,37.237564f,-7.487195f,2.865222f,37.237564f,-6.917267f,5.294239f,37.237564f,-5.294249f,6.917257f,37.237564f,-2.865232f,6.00608f,36.77614f,2.48779f,6.500933f,36.77614f,-1.0E-5f,4.596855f,36.77614f,4.596845f,2.4878f,36.77614f,6.00607f,-0.0f,36.77614f,6.500923f,-2.4878f,36.77614f,6.00607f,-4.596855f,36.77614f,4.596845f,-6.00608f,36.77614f,2.48779f,-6.500933f,36.77614f,-1.0E-5f,-6.00608f,36.77614f,-2.48781f,-4.596855f,36.77614f,-4.596865f,-2.4878f,36.77614f,-6.00609f,-0.0f,36.77614f,-6.500943f,2.4878f,36.77614f,-6.00609f,4.596855f,36.77614f,-4.596865f,6.00608f,36.77614f,-2.48781f,7.671594f,36.543106f,3.177668f,8.303674f,36.543106f,-1.0E-5f,5.871585f,36.543106f,5.871575f,3.177678f,36.543106f,7.671584f,-0.0f,36.543106f,8.303664f,-3.177678f,36.543106f,7.671584f,-5.871585f,36.543106f,5.871575f,-7.671594f,36.543106f,3.177668f,-8.303674f,36.543106f,-1.0E-5f,-7.671594f,36.543106f,-3.177688f,-5.871585f,36.543106f,-5.871595f,-3.177678f,36.543106f,-7.671604f,-0.0f,36.543106f,-8.303684f,3.177678f,36.543106f,-7.671604f,5.871585f,36.543106f,-5.871595f,7.671594f,36.543106f,-3.177688f,8.037991f,36.084023f,3.329435f,8.70026f,36.084023f,-1.0E-5f,6.152011f,36.084023f,6.152001f,3.329445f,36.084023f,8.037981f,-0.0f,36.084023f,8.70025f,-3.329445f,36.084023f,8.037981f,-6.152011f,36.084023f,6.152001f,-8.037991f,36.084023f,3.329435f,-8.70026f,36.084023f,-1.0E-5f,-8.037991f,36.084023f,-3.329455f,-6.152011f,36.084023f,-6.152021f,-3.329445f,36.084023f,-8.038001f,-0.0f,36.084023f,-8.70027f,3.329445f,36.084023f,-8.038001f,6.152011f,36.084023f,-6.152021f,8.037991f,36.084023f,-3.329455f,8.23182f,35.0f,3.40972f,8.910056f,35.0f,-1.0E-5f,6.300362f,35.0f,6.300352f,3.40973f,35.0f,8.23181f,-0.0f,35.0f,8.910046f,-3.40973f,35.0f,8.23181f,-6.300362f,35.0f,6.300352f,-8.23182f,35.0f,3.40972f,-8.910056f,35.0f,-1.0E-5f,-8.23182f,35.0f,-3.40974f,-6.300362f,35.0f,-6.300372f,-3.40973f,35.0f,-8.23183f,-0.0f,35.0f,-8.910066f,3.40973f,35.0f,-8.23183f,6.300362f,35.0f,-6.300372f,8.23182f,35.0f,-3.40974f,8.141868f,35.000004f,3.372461f,8.8127f,35.000004f,-1.0E-5f,6.231518f,35.000004f,6.231508f,3.372471f,35.000004f,8.141858f,-0.0f,35.000004f,8.81269f,-3.372471f,35.000004f,8.141858f,-6.231518f,35.000004f,6.231508f,-8.141868f,35.000004f,3.372461f,-8.8127f,35.000004f,-1.0E-5f,-8.141868f,35.000004f,-3.372481f,-6.231518f,35.000004f,-6.231528f,-3.372471f,35.000004f,-8.141878f,-0.0f,35.000004f,-8.81271f,3.372471f,35.000004f,-8.141878f,6.231518f,35.000004f,-6.231528f,8.141868f,35.000004f,-3.372481f,-0.0f,35.000004f,-1.0E-5f);
    }
    private static void method1(){
        MESH_0.getTexCoords().ensureCapacity(752);
        MESH_0.getTexCoords().addAll(0.02544f,0.49611998f,0.04062f,0.914923f,0.04062f,0.974752f,0.04062f,0.855094f,0.04062f,0.795265f,0.04062f,0.73543596f,0.04062f,0.67560697f,0.04062f,0.61577797f,0.04062f,0.555949f,0.04062f,0.49611998f,0.04062f,0.43629098f,0.04062f,0.37646198f,0.04062f,0.316634f,0.04062f,0.256805f,0.04062f,0.196975f,0.04062f,0.13714701f,0.04062f,0.07731801f,0.04062f,0.017489016f,0.051385f,0.914923f,0.051385f,0.974752f,0.051385f,0.855094f,0.051385f,0.795265f,0.051385f,0.73543596f,0.051385f,0.67560697f,0.051385f,0.61577797f,0.051385f,0.555949f,0.051385f,0.49611998f,0.051385f,0.43629098f,0.051385f,0.37646198f,0.051385f,0.316634f,0.051385f,0.256805f,0.051385f,0.196975f,0.051385f,0.13714701f,0.051385f,0.07731801f,0.051385f,0.017489016f,0.059643f,0.914923f,0.059643f,0.974752f,0.059643f,0.855094f,0.059643f,0.795265f,0.059643f,0.73543596f,0.059643f,0.67560697f,0.059643f,0.61577797f,0.059643f,0.555949f,0.059643f,0.49611998f,0.059643f,0.43629098f,0.059643f,0.37646198f,0.059643f,0.316634f,0.059643f,0.256805f,0.059643f,0.196975f,0.059643f,0.13714701f,0.059643f,0.07731801f,0.059643f,0.017489016f,0.069097f,0.914923f,0.069097f,0.974752f,0.069097f,0.855094f,0.069097f,0.795265f,0.069097f,0.73543596f,0.069097f,0.67560697f,0.069097f,0.61577797f,0.069097f,0.555949f,0.069097f,0.49611998f,0.069097f,0.43629098f,0.069097f,0.37646198f,0.069097f,0.316634f,0.069097f,0.256805f,0.069097f,0.196975f,0.069097f,0.13714701f,0.069097f,0.07731801f,0.069097f,0.017489016f,0.243724f,0.914923f,0.243724f,0.974752f,0.243724f,0.855094f,0.243724f,0.795265f,0.243724f,0.73543596f,0.243724f,0.67560697f,0.243724f,0.61577797f,0.243724f,0.555949f,0.243724f,0.49611998f,0.243724f,0.43629098f,0.243724f,0.37646198f,0.243724f,0.316634f,0.243724f,0.256805f,0.243724f,0.196975f,0.243724f,0.13714701f,0.243724f,0.07731801f,0.243724f,0.017489016f,0.266664f,0.914923f,0.266664f,0.974752f,0.266664f,0.855094f,0.266664f,0.795265f,0.266664f,0.73543596f,0.266664f,0.67560697f,0.266664f,0.61577797f,0.266664f,0.555949f,0.266664f,0.49611998f,0.266664f,0.43629098f,0.266664f,0.37646198f,0.266664f,0.316634f,0.266664f,0.256805f,0.266664f,0.196975f,0.266664f,0.13714701f,0.266664f,0.07731801f,0.266664f,0.017489016f,0.287381f,0.974752f,0.287381f,0.914923f,0.331038f,0.914923f,0.331038f,0.974752f,0.287381f,0.855094f,0.331038f,0.855094f,0.287381f,0.795265f,0.331038f,0.795265f,0.287381f,0.73543596f,0.331038f,0.73543596f,0.287381f,0.67560697f,0.331038f,0.67560697f,0.287381f,0.61577797f,0.331038f,0.61577797f,0.287381f,0.555949f,0.331038f,0.555949f,0.287381f,0.49611998f,0.331038f,0.49611998f,0.287381f,0.43629098f,0.331038f,0.43629098f,0.287381f,0.37646198f,0.331038f,0.37646198f,0.287381f,0.316634f,0.331038f,0.316634f,0.287381f,0.256805f,0.331038f,0.256805f,0.287381f,0.196975f,0.331038f,0.196975f,0.287381f,0.13714701f,0.331038f,0.13714701f,0.287381f,0.07731801f,0.331038f,0.07731801f,0.287381f,0.017489016f,0.331038f,0.017489016f,0.374695f,0.914923f,0.374695f,0.974752f,0.374695f,0.855094f,0.374695f,0.795265f,0.374695f,0.73543596f,0.374695f,0.67560697f,0.374695f,0.61577797f,0.374695f,0.555949f,0.374695f,0.49611998f,0.374695f,0.43629098f,0.374695f,0.37646198f,0.374695f,0.316634f,0.374695f,0.256805f,0.374695f,0.196975f,0.374695f,0.13714701f,0.374695f,0.07731801f,0.374695f,0.017489016f,0.418351f,0.914923f,0.418351f,0.974752f,0.418351f,0.855094f,0.418351f,0.795265f,0.418351f,0.73543596f,0.418351f,0.67560697f,0.418351f,0.61577797f,0.418351f,0.555949f,0.418351f,0.49611998f,0.418351f,0.43629098f,0.418351f,0.37646198f,0.418351f,0.316634f,0.418351f,0.256805f,0.418351f,0.196975f,0.418351f,0.13714701f,0.418351f,0.07731801f,0.418351f,0.017489016f,0.462008f,0.914923f,0.462008f,0.974752f,0.462008f,0.855094f,0.462008f,0.795265f,0.462008f,0.73543596f,0.462008f,0.67560697f,0.462008f,0.61577797f,0.462008f,0.555949f,0.462008f,0.49611998f,0.462008f,0.43629098f,0.462008f,0.37646198f,0.462008f,0.316634f,0.462008f,0.256805f,0.462008f,0.196975f,0.462008f,0.13714701f,0.462008f,0.07731801f,0.462008f,0.017489016f,0.505665f,0.914923f,0.505665f,0.974752f,0.505665f,0.855094f,0.505665f,0.795265f,0.505665f,0.73543596f,0.505665f,0.67560697f,0.505665f,0.61577797f,0.505665f,0.555949f,0.505665f,0.49611998f,0.505665f,0.43629098f,0.505665f,0.37646198f,0.505665f,0.316634f,0.505665f,0.256805f,0.505665f,0.196975f,0.505665f,0.13714701f,0.505665f,0.07731801f,0.505665f,0.017489016f,0.549322f,0.914923f,0.549322f,0.974752f,0.549322f,0.855094f,0.549322f,0.795265f,0.549322f,0.73543596f,0.549322f,0.67560697f,0.549322f,0.61577797f,0.549322f,0.555949f,0.549322f,0.49611998f,0.549322f,0.43629098f,0.549322f,0.37646198f,0.549322f,0.316634f,0.549322f,0.256805f,0.549322f,0.196975f,0.549322f,0.13714701f,0.549322f,0.07731801f,0.549322f,0.017489016f,0.592979f,0.914923f,0.592979f,0.974752f,0.592979f,0.855094f,0.592979f,0.795265f,0.592979f,0.73543596f,0.592979f,0.67560697f,0.592979f,0.61577797f,0.592979f,0.555949f,0.592979f,0.49611998f,0.592979f,0.43629098f,0.592979f,0.37646198f,0.592979f,0.316634f,0.592979f,0.256805f,0.592979f,0.196975f,0.592979f,0.13714701f,0.592979f,0.07731801f,0.592979f,0.017489016f,0.636635f,0.914923f,0.636635f,0.974752f,0.636635f,0.855094f,0.636635f,0.795265f,0.636635f,0.73543596f,0.636635f,0.67560697f,0.636635f,0.61577797f,0.636635f,0.555949f,0.636635f,0.49611998f,0.636635f,0.43629098f,0.636635f,0.37646198f,0.636635f,0.316634f,0.636635f,0.256805f,0.636635f,0.196975f,0.636635f,0.13714701f,0.636635f,0.07731801f,0.636635f,0.017489016f,0.680292f,0.914923f,0.680292f,0.974752f,0.680292f,0.855094f,0.680292f,0.795265f,0.680292f,0.73543596f,0.680292f,0.67560697f,0.680292f,0.61577797f,0.680292f,0.555949f,0.680292f,0.49611998f,0.680292f,0.43629098f,0.680292f,0.37646198f,0.680292f,0.316634f,0.680292f,0.256805f,0.680292f,0.196975f,0.680292f,0.13714701f,0.680292f,0.07731801f,0.680292f,0.017489016f,0.723949f,0.914923f,0.723949f,0.974752f,0.723949f,0.855094f,0.723949f,0.795265f,0.723949f,0.73543596f,0.723949f,0.67560697f,0.723949f,0.61577797f,0.723949f,0.555949f,0.723949f,0.49611998f,0.723949f,0.43629098f,0.723949f,0.37646198f,0.723949f,0.316634f,0.723949f,0.256805f,0.723949f,0.196975f,0.723949f,0.13714701f,0.723949f,0.07731801f,0.723949f,0.017489016f,0.767606f,0.914923f,0.767606f,0.974752f,0.767606f,0.855094f,0.767606f,0.795265f,0.767606f,0.73543596f,0.767606f,0.67560697f,0.767606f,0.61577797f,0.767606f,0.555949f,0.767606f,0.49611998f,0.767606f,0.43629098f,0.767606f,0.37646198f,0.767606f,0.316634f,0.767606f,0.256805f,0.767606f,0.196975f,0.767606f,0.13714701f,0.767606f,0.07731801f,0.767606f,0.017489016f,0.811263f,0.914923f,0.811263f,0.974752f,0.811263f,0.855094f,0.811263f,0.795265f,0.811263f,0.73543596f,0.811263f,0.67560697f,0.811263f,0.61577797f,0.811263f,0.555949f,0.811263f,0.49611998f,0.811263f,0.43629098f,0.811263f,0.37646198f,0.811263f,0.316634f,0.811263f,0.256805f,0.811263f,0.196975f,0.811263f,0.13714701f,0.811263f,0.07731801f,0.811263f,0.017489016f,0.854919f,0.914923f,0.854919f,0.974752f,0.854919f,0.855094f,0.854919f,0.795265f,0.854919f,0.73543596f,0.854919f,0.67560697f,0.854919f,0.61577797f,0.854919f,0.555949f,0.854919f,0.49611998f,0.854919f,0.43629098f,0.854919f,0.37646198f,0.854919f,0.316634f,0.854919f,0.256805f,0.854919f,0.196975f,0.854919f,0.13714701f,0.854919f,0.07731801f,0.854919f,0.017489016f,0.898576f,0.914923f,0.898576f,0.974752f,0.898576f,0.855094f,0.898576f,0.795265f,0.898576f,0.73543596f,0.898576f,0.67560697f,0.898576f,0.61577797f,0.898576f,0.555949f,0.898576f,0.49611998f,0.898576f,0.43629098f,0.898576f,0.37646198f,0.898576f,0.316634f,0.898576f,0.256805f,0.898576f,0.196975f,0.898576f,0.13714701f,0.898576f,0.07731801f,0.898576f,0.017489016f,0.942233f,0.914923f,0.942233f,0.974752f,0.942233f,0.855094f,0.942233f,0.795265f,0.942233f,0.73543596f,0.942233f,0.67560697f,0.942233f,0.61577797f,0.942233f,0.555949f,0.942233f,0.49611998f,0.942233f,0.43629098f,0.942233f,0.37646198f,0.942233f,0.316634f,0.942233f,0.256805f,0.942233f,0.196975f,0.942233f,0.13714701f,0.942233f,0.07731801f,0.942233f,0.017489016f,0.98589f,0.49611998f);
    }
    private static void method2(){
        MESH_0.getFaces().ensureCapacity(4224);
        MESH_0.getFaces().addAll(0,0,1,1,2,2,0,0,3,3,1,1,0,0,4,4,3,3,0,0,5,5,4,4,0,0,6,6,5,5,0,0,7,7,6,6,0,0,8,8,7,7,0,0,9,9,8,8,0,0,10,10,9,9,0,0,11,11,10,10,0,0,12,12,11,11,0,0,13,13,12,12,0,0,14,14,13,13,0,0,15,15,14,14,0,0,16,16,15,15,0,0,2,17,16,16,2,2,1,1,17,18,2,2,17,18,18,19,1,1,3,3,19,20,1,1,19,20,17,18,3,3,4,4,20,21,3,3,20,21,19,20,4,4,5,5,21,22,4,4,21,22,20,21,5,5,6,6,22,23,5,5,22,23,21,22,6,6,7,7,23,24,6,6,23,24,22,23,7,7,8,8,24,25,7,7,24,25,23,24,8,8,9,9,25,26,8,8,25,26,24,25,9,9,10,10,26,27,9,9,26,27,25,26,10,10,11,11,27,28,10,10,27,28,26,27,11,11,12,12,28,29,11,11,28,29,27,28,12,12,13,13,29,30,12,12,29,30,28,29,13,13,14,14,30,31,13,13,30,31,29,30,14,14,15,15,31,32,14,14,31,32,30,31,15,15,16,16,32,33,15,15,32,33,31,32,16,16,2,17,18,34,16,16,18,34,32,33,18,19,17,18,33,35,18,19,33,35,34,36,17,18,19,20,35,37,17,18,35,37,33,35,19,20,20,21,36,38,19,20,36,38,35,37,20,21,21,22,37,39,20,21,37,39,36,38,21,22,22,23,38,40,21,22,38,40,37,39,22,23,23,24,39,41,22,23,39,41,38,40,23,24,24,25,40,42,23,24,40,42,39,41,24,25,25,26,41,43,24,25,41,43,40,42,25,26,26,27,42,44,25,26,42,44,41,43,26,27,27,28,43,45,26,27,43,45,42,44,27,28,28,29,44,46,27,28,44,46,43,45,28,29,29,30,45,47,28,29,45,47,44,46,29,30,30,31,46,48,29,30,46,48,45,47,30,31,31,32,47,49,30,31,47,49,46,48,31,32,32,33,48,50,31,32,48,50,47,49,32,33,18,34,34,51,32,33,34,51,48,50,34,36,33,35,49,52,34,36,49,52,50,53,33,35,35,37,51,54,33,35,51,54,49,52,35,37,36,38,52,55,35,37,52,55,51,54,36,38,37,39,53,56,36,38,53,56,52,55,37,39,38,40,54,57,37,39,54,57,53,56,38,40,39,41,55,58,38,40,55,58,54,57,39,41,40,42,56,59,39,41,56,59,55,58,40,42,41,43,57,60,40,42,57,60,56,59,41,43,42,44,58,61,41,43,58,61,57,60,42,44,43,45,59,62,42,44,59,62,58,61,43,45,44,46,60,63,43,45,60,63,59,62,44,46,45,47,61,64,44,46,61,64,60,63,45,47,46,48,62,65,45,47,62,65,61,64,46,48,47,49,63,66,46,48,63,66,62,65,47,49,48,50,64,67,47,49,64,67,63,66,48,50,34,51,50,68,48,50,50,68,64,67,50,53,49,52,65,69,50,53,65,69,66,70,49,52,51,54,67,71,49,52,67,71,65,69,51,54,52,55,68,72,51,54,68,72,67,71,52,55,53,56,69,73,52,55,69,73,68,72,53,56,54,57,70,74,53,56,70,74,69,73,54,57,55,58,71,75,54,57,71,75,70,74,55,58,56,59,72,76,55,58,72,76,71,75,56,59,57,60,73,77,56,59,73,77,72,76,57,60,58,61,74,78,57,60,74,78,73,77,58,61,59,62,75,79,58,61,75,79,74,78,59,62,60,63,76,80,59,62,76,80,75,79,60,63,61,64,77,81,60,63,77,81,76,80,61,64,62,65,78,82,61,64,78,82,77,81,62,65,63,66,79,83,62,65,79,83,78,82,63,66,64,67,80,84,63,66,80,84,79,83,64,67,50,68,66,85,64,67,66,85,80,84,66,70,65,69,81,86,66,70,81,86,82,87,65,69,67,71,83,88,65,69,83,88,81,86,67,71,68,72,84,89,67,71,84,89,83,88,68,72,69,73,85,90,68,72,85,90,84,89,69,73,70,74,86,91,69,73,86,91,85,90,70,74,71,75,87,92,70,74,87,92,86,91,71,75,72,76,88,93,71,75,88,93,87,92,72,76,73,77,89,94,72,76,89,94,88,93,73,77,74,78,90,95,73,77,90,95,89,94,74,78,75,79,91,96,74,78,91,96,90,95,75,79,76,80,92,97,75,79,92,97,91,96,76,80,77,81,93,98,76,80,93,98,92,97,77,81,78,82,94,99,77,81,94,99,93,98,78,82,79,83,95,100,78,82,95,100,94,99,79,83,80,84,96,101,79,83,96,101,95,100,80,84,66,85,82,102,80,84,82,102,96,101,97,103,98,104,99,105,97,103,99,105,100,106,98,104,101,107,102,108,98,104,102,108,99,105,101,107,103,109,104,110,101,107,104,110,102,108,103,109,105,111,106,112,103,109,106,112,104,110,105,111,107,113,108,114,105,111,108,114,106,112,107,113,109,115,110,116,107,113,110,116,108,114,109,115,111,117,112,118,109,115,112,118,110,116,111,117,113,119,114,120,111,117,114,120,112,118,113,119,115,121,116,122,113,119,116,122,114,120,115,121,117,123,118,124,115,121,118,124,116,122,117,123,119,125,120,126,117,123,120,126,118,124,119,125,121,127,122,128,119,125,122,128,120,126,121,127,123,129,124,130,121,127,124,130,122,128,123,129,125,131,126,132,123,129,126,132,124,130,125,131,127,133,128,134,125,131,128,134,126,132,127,133,97,135,100,136,127,133,100,136,128,134,100,106,99,105,129,137,100,106,129,137,130,138,99,105,102,108,131,139,99,105,131,139,129,137,102,108,104,110,132,140,102,108,132,140,131,139,104,110,106,112,133,141,104,110,133,141,132,140,106,112,108,114,134,142,106,112,134,142,133,141,108,114,110,116,135,143,108,114,135,143,134,142,110,116,112,118,136,144,110,116,136,144,135,143,112,118,114,120,137,145,112,118,137,145,136,144,114,120,116,122,138,146,114,120,138,146,137,145,116,122,118,124,139,147,116,122,139,147,138,146,118,124,120,126,140,148,118,124,140,148,139,147,120,126,122,128,141,149,120,126,141,149,140,148,122,128,124,130,142,150,122,128,142,150,141,149,124,130,126,132,143,151,124,130,143,151,142,150,126,132,128,134,144,152,126,132,144,152,143,151,128,134,100,136,130,153,128,134,130,153,144,152,130,138,129,137,145,154,130,138,145,154,146,155,129,137,131,139,147,156,129,137,147,156,145,154,131,139,132,140,148,157,131,139,148,157,147,156,132,140,133,141,149,158,132,140,149,158,148,157,133,141,134,142,150,159,133,141,150,159,149,158,134,142,135,143,151,160,134,142,151,160,150,159,135,143,136,144,152,161,135,143,152,161,151,160,136,144,137,145,153,162,136,144,153,162,152,161,137,145,138,146,154,163,137,145,154,163,153,162,138,146,139,147,155,164,138,146,155,164,154,163,139,147,140,148,156,165,139,147,156,165,155,164,140,148,141,149,157,166,140,148,157,166,156,165,141,149,142,150,158,167,141,149,158,167,157,166,142,150,143,151,159,168,142,150,159,168,158,167,143,151,144,152,160,169,143,151,160,169,159,168,144,152,130,153,146,170,144,152,146,170,160,169,146,155,145,154,161,171,146,155,161,171,162,172,145,154,147,156,163,173,145,154,163,173,161,171,147,156,148,157,164,174,147,156,164,174,163,173,148,157,149,158,165,175,148,157,165,175,164,174,149,158,150,159,166,176,149,158,166,176,165,175,150,159,151,160,167,177,150,159,167,177,166,176,151,160,152,161,168,178,151,160,168,178,167,177,152,161,153,162,169,179,152,161,169,179,168,178,153,162,154,163,170,180,153,162,170,180,169,179,154,163,155,164,171,181,154,163,171,181,170,180,155,164,156,165,172,182,155,164,172,182,171,181,156,165,157,166,173,183,156,165,173,183,172,182,157,166,158,167,174,184,157,166,174,184,173,183,158,167,159,168,175,185,158,167,175,185,174,184,159,168,160,169,176,186,159,168,176,186,175,185,160,169,146,170,162,187,160,169,162,187,176,186,162,172,161,171,177,188,162,172,177,188,178,189,161,171,163,173,179,190,161,171,179,190,177,188,163,173,164,174,180,191,163,173,180,191,179,190,164,174,165,175,181,192,164,174,181,192,180,191,165,175,166,176,182,193,165,175,182,193,181,192,166,176,167,177,183,194,166,176,183,194,182,193,167,177,168,178,184,195,167,177,184,195,183,194,168,178,169,179,185,196,168,178,185,196,184,195,169,179,170,180,186,197,169,179,186,197,185,196,170,180,171,181,187,198,170,180,187,198,186,197,171,181,172,182,188,199,171,181,188,199,187,198,172,182,173,183,189,200,172,182,189,200,188,199,173,183,174,184,190,201,173,183,190,201,189,200,174,184,175,185,191,202,174,184,191,202,190,201,175,185,176,186,192,203,175,185,192,203,191,202,176,186,162,187,178,204,176,186,178,204,192,203,178,189,177,188,193,205,178,189,193,205,194,206,177,188,179,190,195,207,177,188,195,207,193,205,179,190,180,191,196,208,179,190,196,208,195,207,180,191,181,192,197,209,180,191,197,209,196,208,181,192,182,193,198,210,181,192,198,210,197,209,182,193,183,194,199,211,182,193,199,211,198,210,183,194,184,195,200,212,183,194,200,212,199,211,184,195,185,196,201,213,184,195,201,213,200,212,185,196,186,197,202,214,185,196,202,214,201,213,186,197,187,198,203,215,186,197,203,215,202,214,187,198,188,199,204,216,187,198,204,216,203,215,188,199,189,200,205,217,188,199,205,217,204,216,189,200,190,201,206,218,189,200,206,218,205,217,190,201,191,202,207,219,190,201,207,219,206,218,191,202,192,203,208,220,191,202,208,220,207,219,192,203,178,204,194,221,192,203,194,221,208,220,194,206,193,205,209,222,194,206,209,222,210,223,193,205,195,207,211,224,193,205,211,224,209,222,195,207,196,208,212,225,195,207,212,225,211,224,196,208,197,209,213,226,196,208,213,226,212,225,197,209,198,210,214,227,197,209,214,227,213,226,198,210,199,211,215,228,198,210,215,228,214,227,199,211,200,212,216,229,199,211,216,229,215,228,200,212,201,213,217,230,200,212,217,230,216,229,201,213,202,214,218,231,201,213,218,231,217,230,202,214,203,215,219,232,202,214,219,232,218,231,203,215,204,216,220,233,203,215,220,233,219,232,204,216,205,217,221,234,204,216,221,234,220,233,205,217,206,218,222,235,205,217,222,235,221,234,206,218,207,219,223,236,206,218,223,236,222,235,207,219,208,220,224,237,207,219,224,237,223,236,208,220,194,221,210,238,208,220,210,238,224,237,210,223,209,222,225,239,210,223,225,239,226,240,209,222,211,224,227,241,209,222,227,241,225,239,211,224,212,225,228,242,211,224,228,242,227,241,212,225,213,226,229,243,212,225,229,243,228,242,213,226,214,227,230,244,213,226,230,244,229,243,214,227,215,228,231,245,214,227,231,245,230,244,215,228,216,229,232,246,215,228,232,246,231,245,216,229,217,230,233,247,216,229,233,247,232,246,217,230,218,231,234,248,217,230,234,248,233,247,218,231,219,232,235,249,218,231,235,249,234,248,219,232,220,233,236,250,219,232,236,250,235,249,220,233,221,234,237,251,220,233,237,251,236,250,221,234,222,235,238,252,221,234,238,252,237,251,222,235,223,236,239,253,222,235,239,253,238,252,223,236,224,237,240,254,223,236,240,254,239,253,224,237,210,238,226,255,224,237,226,255,240,254,226,240,225,239,241,256,226,240,241,256,242,257,225,239,227,241,243,258,225,239,243,258,241,256,227,241,228,242,244,259,227,241,244,259,243,258,228,242,229,243,245,260,228,242,245,260,244,259,229,243,230,244,246,261,229,243,246,261,245,260,230,244,231,245,247,262,230,244,247,262,246,261,231,245,232,246,248,263,231,245,248,263,247,262,232,246,233,247,249,264,232,246,249,264,248,263,233,247,234,248,250,265,233,247,250,265,249,264,234,248,235,249,251,266,234,248,251,266,250,265,235,249,236,250,252,267,235,249,252,267,251,266,236,250,237,251,253,268,236,250,253,268,252,267,237,251,238,252,254,269,237,251,254,269,253,268,238,252,239,253,255,270,238,252,255,270,254,269,239,253,240,254,256,271,239,253,256,271,255,270,240,254,226,255,242,272,240,254,242,272,256,271,242,257,241,256,257,273,242,257,257,273,258,274,241,256,243,258,259,275,241,256,259,275,257,273,243,258,244,259,260,276,243,258,260,276,259,275,244,259,245,260,261,277,244,259,261,277,260,276,245,260,246,261,262,278,245,260,262,278,261,277,246,261,247,262,263,279,246,261,263,279,262,278,247,262,248,263,264,280,247,262,264,280,263,279,248,263,249,264,265,281,248,263,265,281,264,280,249,264,250,265,266,282,249,264,266,282,265,281,250,265,251,266,267,283,250,265,267,283,266,282,251,266,252,267,268,284,251,266,268,284,267,283,252,267,253,268,269,285,252,267,269,285,268,284,253,268,254,269,270,286,253,268,270,286,269,285,254,269,255,270,271,287,254,269,271,287,270,286,255,270,256,271,272,288,255,270,272,288,271,287,256,271,242,272,258,289,256,271,258,289,272,288,258,274,257,273,273,290,258,274,273,290,274,291,257,273,259,275,275,292,257,273,275,292,273,290,259,275,260,276,276,293,259,275,276,293,275,292,260,276,261,277,277,294,260,276,277,294,276,293,261,277,262,278,278,295,261,277,278,295,277,294,262,278,263,279,279,296,262,278,279,296,278,295,263,279,264,280,280,297,263,279,280,297,279,296,264,280,265,281,281,298,264,280,281,298,280,297,265,281,266,282,282,299,265,281,282,299,281,298,266,282,267,283,283,300,266,282,283,300,282,299,267,283,268,284,284,301,267,283,284,301,283,300,268,284,269,285,285,302,268,284,285,302,284,301,269,285,270,286,286,303,269,285,286,303,285,302,270,286,271,287,287,304,270,286,287,304,286,303,271,287,272,288,288,305,271,287,288,305,287,304,272,288,258,289,274,306,272,288,274,306,288,305,274,291,273,290,289,307,274,291,289,307,290,308,273,290,275,292,291,309,273,290,291,309,289,307,275,292,276,293,292,310,275,292,292,310,291,309,276,293,277,294,293,311,276,293,293,311,292,310,277,294,278,295,294,312,277,294,294,312,293,311,278,295,279,296,295,313,278,295,295,313,294,312,279,296,280,297,296,314,279,296,296,314,295,313,280,297,281,298,297,315,280,297,297,315,296,314,281,298,282,299,298,316,281,298,298,316,297,315,282,299,283,300,299,317,282,299,299,317,298,316,283,300,284,301,300,318,283,300,300,318,299,317,284,301,285,302,301,319,284,301,301,319,300,318,285,302,286,303,302,320,285,302,302,320,301,319,286,303,287,304,303,321,286,303,303,321,302,320,287,304,288,305,304,322,287,304,304,322,303,321,288,305,274,306,290,323,288,305,290,323,304,322,290,308,289,307,305,324,290,308,305,324,306,325,289,307,291,309,307,326,289,307,307,326,305,324,291,309,292,310,308,327,291,309,308,327,307,326,292,310,293,311,309,328,292,310,309,328,308,327,293,311,294,312,310,329,293,311,310,329,309,328,294,312,295,313,311,330,294,312,311,330,310,329,295,313,296,314,312,331,295,313,312,331,311,330,296,314,297,315,313,332,296,314,313,332,312,331,297,315,298,316,314,333,297,315,314,333,313,332,298,316,299,317,315,334,298,316,315,334,314,333,299,317,300,318,316,335,299,317,316,335,315,334,300,318,301,319,317,336,300,318,317,336,316,335,301,319,302,320,318,337,301,319,318,337,317,336,302,320,303,321,319,338,302,320,319,338,318,337,303,321,304,322,320,339,303,321,320,339,319,338,304,322,290,323,306,340,304,322,306,340,320,339,306,325,305,324,321,341,306,325,321,341,322,342,305,324,307,326,323,343,305,324,323,343,321,341,307,326,308,327,324,344,307,326,324,344,323,343,308,327,309,328,325,345,308,327,325,345,324,344,309,328,310,329,326,346,309,328,326,346,325,345,310,329,311,330,327,347,310,329,327,347,326,346,311,330,312,331,328,348,311,330,328,348,327,347,312,331,313,332,329,349,312,331,329,349,328,348,313,332,314,333,330,350,313,332,330,350,329,349,314,333,315,334,331,351,314,333,331,351,330,350,315,334,316,335,332,352,315,334,332,352,331,351,316,335,317,336,333,353,316,335,333,353,332,352,317,336,318,337,334,354,317,336,334,354,333,353,318,337,319,338,335,355,318,337,335,355,334,354,319,338,320,339,336,356,319,338,336,356,335,355,320,339,306,340,322,357,320,339,322,357,336,356,322,342,321,341,337,358,322,342,337,358,338,359,321,341,323,343,339,360,321,341,339,360,337,358,323,343,324,344,340,361,323,343,340,361,339,360,324,344,325,345,341,362,324,344,341,362,340,361,325,345,326,346,342,363,325,345,342,363,341,362,326,346,327,347,343,364,326,346,343,364,342,363,327,347,328,348,344,365,327,347,344,365,343,364,328,348,329,349,345,366,328,348,345,366,344,365,329,349,330,350,346,367,329,349,346,367,345,366,330,350,331,351,347,368,330,350,347,368,346,367,331,351,332,352,348,369,331,351,348,369,347,368,332,352,333,353,349,370,332,352,349,370,348,369,333,353,334,354,350,371,333,353,350,371,349,370,334,354,335,355,351,372,334,354,351,372,350,371,335,355,336,356,352,373,335,355,352,373,351,372,336,356,322,357,338,374,336,356,338,374,352,373,338,359,337,358,353,375,337,358,339,360,353,375,339,360,340,361,353,375,340,361,341,362,353,375,341,362,342,363,353,375,342,363,343,364,353,375,343,364,344,365,353,375,344,365,345,366,353,375,345,366,346,367,353,375,346,367,347,368,353,375,347,368,348,369,353,375,348,369,349,370,353,375,349,370,350,371,353,375,350,371,351,372,353,375,351,372,352,373,353,375,352,373,338,374,353,375,86,91,87,92,109,115,86,91,109,115,107,113,85,90,86,91,107,113,85,90,107,113,105,111,84,89,85,90,105,111,84,89,105,111,103,109,83,88,84,89,103,109,83,88,103,109,101,107,81,86,83,88,101,107,81,86,101,107,98,104,82,87,81,86,98,104,82,87,98,104,97,103,96,101,82,102,97,135,96,101,97,135,127,133,95,100,96,101,127,133,95,100,127,133,125,131,94,99,95,100,125,131,94,99,125,131,123,129,93,98,94,99,123,129,93,98,123,129,121,127,92,97,93,98,121,127,92,97,121,127,119,125,91,96,92,97,119,125,91,96,119,125,117,123,90,95,91,96,117,123,90,95,117,123,115,121,89,94,90,95,115,121,89,94,115,121,113,119,88,93,89,94,113,119,88,93,113,119,111,117,87,92,88,93,111,117,87,92,111,117,109,115);
    }
    private static void method3(){
        MESH_0.getFaceSmoothingGroups().ensureCapacity(704);
        MESH_0.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_2 = MESHVIEWS[1];
        MESHVIEWS[1].setId("hat_knight");
        MESHVIEWS[1].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_1 = new PhongMaterial();
        MATERIAL_1.setDiffuseColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_1.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_1.setSpecularPower(18.0);
        MESHVIEWS[1].setMaterial(MATERIAL_1);
        MESH_1 = new TriangleMesh();
        MESHVIEWS[1].setMesh(MESH_1);
        MESH_1.getPoints().ensureCapacity(1923);
        MESH_1.getPoints().addAll(-1.078799f,50.55808f,11.189185f,-1.007367f,51.813683f,9.718976f,-2.247965f,51.474445f,9.555381f,-2.345215f,50.276535f,11.021511f,-0.992217f,54.990475f,6.715729f,-2.156994f,54.640003f,6.623327f,-2.686778f,49.522667f,10.000462f,-2.588485f,51.026264f,8.669353f,-2.74431f,49.892113f,7.467094f,-2.509439f,47.97831f,8.617033f,-2.513695f,53.656116f,6.159642f,-3.045874f,53.086884f,5.125287f,-2.479615f,47.618008f,8.300406f,-2.877837f,49.020985f,6.671401f,-3.03294f,48.00909f,5.747134f,-2.444972f,47.19947f,7.932615f,-3.511063f,51.348583f,4.34263f,-4.069953f,49.67656f,3.605653f,-2.302379f,46.528694f,7.187422f,-2.895407f,47.301067f,5.203334f,-2.690474f,46.24607f,4.393036f,-2.089906f,45.5292f,6.077041f,-3.818164f,48.057705f,2.859376f,-3.50915f,46.76827f,2.376218f,-1.237618f,46.26453f,4.310635f,-0.961357f,45.51048f,6.025052f,-1.609268f,46.748363f,2.331344f,-1.103587f,56.37261f,5.221219f,-1.230564f,57.758457f,3.09596f,-2.675138f,57.590603f,2.929405f,-2.399103f,56.08611f,4.990077f,-2.774319f,55.62376f,4.069294f,-3.07949f,56.7518f,2.227033f,-3.622073f,55.62624f,1.284552f,-3.223491f,54.77823f,3.396102f,-3.594631f,52.68905f,2.157653f,-3.682273f,53.575214f,0.232878f,-4.154038f,51.90444f,-0.848826f,-3.980025f,50.980206f,1.257611f,-3.913275f,49.314503f,0.51431f,-4.236054f,50.175114f,-1.601733f,-4.10534f,48.43f,-2.055527f,-3.829242f,47.651634f,-0.13534f,-2.345215f,49.71561f,11.963129f,-1.11639f,49.997158f,12.130805f,-2.509439f,46.478764f,10.152497f,-2.894548f,48.250443f,11.364215f,-2.089906f,44.437798f,7.135839f,-2.302379f,44.892303f,8.645402f,-0.961357f,44.419067f,7.083851f,-1.230564f,58.866245f,0.425072f,-2.675138f,58.697147f,-0.078212f,-3.060705f,57.76586f,-0.582188f,-3.578081f,56.516186f,-1.258452f,-3.836215f,54.35962f,-2.262663f,-3.951507f,52.924953f,-3.196098f,-3.94642f,50.8002f,-3.860253f,-3.663846f,49.229115f,-4.21794f,-2.19406f,59.148422f,-2.950183f,-1.009267f,59.31232f,-2.995192f,-3.435877f,59.903286f,-2.687578f,-3.89469f,59.53504f,-1.602989f,-3.59536f,60.112316f,-1.425008f,-3.332816f,60.387035f,-2.592437f,-2.767492f,55.128147f,-4.728123f,-2.899601f,53.657455f,-5.584631f,-2.897801f,49.80456f,-6.588491f,-3.009314f,51.622036f,-6.368595f,-2.675687f,47.077026f,8.82622f,-2.658277f,46.86669f,8.641385f,-1.221535f,46.53527f,8.972359f,-1.22947f,46.745613f,9.157193f,-2.275276f,45.752617f,9.849f,-1.045355f,45.579117f,10.022265f,-2.329516f,46.228733f,10.032395f,-2.690675f,47.258106f,8.985342f,-1.236302f,46.926685f,9.316316f,-1.070169f,46.046227f,10.214653f,-1.237096f,46.266525f,13.18874f,-2.299133f,46.589626f,12.614416f,-2.509439f,44.641006f,12.034281f,-1.155481f,44.641006f,12.034281f,-0.89449f,43.099182f,10.23562f,-2.136932f,43.1067f,10.256502f,-2.089906f,43.160233f,8.333434f,-0.961357f,43.141506f,8.281446f,-0.65136f,58.992252f,-4.453916f,-1.601073f,59.055145f,-4.153494f,-2.494881f,57.31573f,-3.530555f,-2.322514f,58.36584f,-3.198008f,-1.630584f,58.324818f,-4.38391f,-2.000058f,57.359238f,-5.269303f,-2.071621f,55.629208f,-6.268026f,-2.110337f,53.99491f,-7.083231f,-2.267098f,52.03263f,-7.799828f,-1.930571f,50.214478f,-7.981492f,-0.757263f,58.416134f,-5.063226f,-0.811042f,57.34823f,-5.811048f,-0.850981f,55.929035f,-6.791862f,-0.90497f,54.142273f,-7.781026f,-0.931782f,52.23464f,-8.291864f,-0.952037f,50.232956f,-8.588837f,-2.380696f,54.197536f,5.278353f,-2.419012f,54.7905f,4.633721f,-2.590382f,54.50755f,4.589661f,-2.457934f,54.070324f,4.907014f,-2.444972f,45.564564f,9.754426f,-2.444972f,44.203262f,11.57448f,-1.126096f,44.203262f,11.57448f,-1.028298f,44.528652f,11.175721f,-1.8545f,44.528652f,11.175721f,-1.886898f,44.967182f,11.315616f,-0.866565f,44.967182f,11.315616f,-2.168562f,45.76998f,10.499026f,-0.99613f,45.653843f,10.615009f,-2.509439f,45.810482f,10.836789f,-2.752739f,47.751724f,11.823551f,-1.08233f,49.010574f,12.091795f,-2.140062f,48.897507f,11.947387f,-1.947865f,48.46348f,12.163245f,-1.357489f,48.508682f,12.402108f,-2.089906f,43.828224f,7.707254f,-0.961357f,43.809494f,7.655264f,-2.302379f,44.258827f,9.39454f,-2.074509f,45.16862f,10.482024f,-2.444972f,44.915043f,10.622835f,-0.953002f,45.077904f,10.57262f,-2.632749f,55.462124f,5.087624f,-2.526691f,54.76227f,5.837842f,-3.119246f,54.53407f,4.26507f,-2.922176f,55.26396f,4.429463f,-3.024214f,53.83521f,5.047622f,-2.780013f,54.15913f,5.68158f,-2.333695f,54.90029f,4.977349f,-2.302612f,54.53844f,5.317519f,-3.383994f,58.85461f,-0.998216f,-3.90137f,57.598404f,-1.413142f,-2.998427f,59.790775f,-0.688997f,-2.517349f,60.227005f,-2.959746f,-2.81817f,58.388893f,-3.323546f,-2.645803f,59.442104f,-3.115092f,-3.372288f,60.542522f,-1.292371f,-3.256011f,60.74753f,-2.521536f,-1.110952f,48.53478f,13.034978f,-2.205623f,48.45096f,12.592074f,-2.438743f,49.255733f,12.191842f,-1.705419f,47.309185f,0.86885f,0.0f,47.303364f,1.119916f,0.0f,46.731403f,2.293119f,0.0f,46.28025f,4.24044f,0.0f,45.494526f,5.980766f,0.0f,44.403114f,7.039562f,0.0f,43.793545f,7.610975f,0.0f,43.125553f,8.237157f,0.0f,43.092773f,10.217835f,0.0f,44.203262f,11.57448f,0.0f,44.528652f,11.175721f,0.0f,45.000626f,10.649793f,0.0f,45.43132f,10.169862f,0.0f,46.252953f,9.254301f,0.0f,46.463287f,9.439134f,0.0f,46.644363f,9.598258f,0.0f,45.89076f,10.369913f,0.0f,45.554913f,10.713809f,0.0f,44.967182f,11.315616f,0.0f,44.641006f,12.034281f,0.0f,46.244865f,13.156861f,0.0f,48.574013f,13.290824f,0.0f,49.41704f,12.63814f,-0.837388f,49.465378f,12.459598f,0.0f,50.4597f,11.323557f,0.0f,49.898777f,12.265174f,0.0f,51.764328f,9.854467f,0.0f,55.28891f,6.799037f,0.0f,56.61667f,5.418117f,0.0f,57.829952f,3.166903f,-1.360422f,49.29737f,11.914469f,-2.023149f,49.145535f,11.824039f,-4.10534f,46.284904f,-0.739972f,-3.829242f,45.796913f,1.462717f,-3.663846f,46.777954f,-3.541628f,-2.897801f,47.37861f,-6.109754f,-1.930571f,47.37861f,-7.491999f,-1.057296f,47.37861f,-8.331337f,-1.705419f,45.584885f,2.612812f,0.0f,45.58519f,2.898088f,-4.990958f,44.109047f,1.317186f,-4.655299f,43.826004f,3.920455f,-4.454222f,44.395023f,-1.993978f,-3.522923f,44.74342f,-5.029141f,-2.34704f,44.74342f,-6.66276f,-1.468047f,44.74342f,-7.654742f,-2.073318f,43.70302f,5.279707f,0.0f,43.7032f,5.616862f,-6.156551f,42.08561f,2.746045f,-5.192418f,42.08561f,5.439801f,-6.118672f,42.08561f,-0.573642f,-5.312341f,42.08561f,-3.730087f,-3.865028f,42.08561f,-5.850341f,-2.464711f,42.08561f,-6.888525f,-2.553575f,42.08561f,7.014842f,0.0f,42.08561f,7.48503f,-7.35083f,41.616123f,-1.0E-5f,-6.791281f,41.616123f,2.81303f,-5.197821f,41.616123f,5.197811f,-2.81304f,41.616123f,6.791271f,0.0f,41.616123f,7.35082f,0.0f,42.08561f,-7.388824f,0.0f,41.616123f,-7.35084f,-2.81304f,41.616123f,-6.791291f,-5.197821f,41.616123f,-5.197831f,-6.791281f,41.616123f,-2.81305f,-7.85395f,41.264103f,-1.0E-5f,-7.256104f,41.264103f,3.005566f,-5.553581f,41.264103f,5.553571f,-3.005576f,41.264103f,7.256094f,0.0f,41.264103f,7.85394f,0.0f,41.264103f,-7.85396f,-3.005576f,41.264103f,-7.256114f,-5.553581f,41.264103f,-5.553591f,-7.256104f,41.264103f,-3.005586f,-7.85395f,40.716118f,-1.0E-5f,-7.256104f,40.716118f,3.005566f,-5.553581f,40.716118f,5.553571f,-3.005576f,40.716118f,7.256094f,0.0f,40.716118f,7.85394f,0.0f,40.716118f,-7.85396f,-3.005576f,40.716118f,-7.256114f,-5.553581f,40.716118f,-5.553591f,-7.256104f,40.716118f,-3.005586f,-7.301013f,40.32089f,-1.0E-5f,-6.745256f,40.32089f,2.793966f,-5.162596f,40.32089f,5.162585f,-2.793976f,40.32089f,6.745246f,0.0f,40.32089f,7.301003f,0.0f,40.32089f,-7.301023f,-2.793976f,40.32089f,-6.745266f,-5.162596f,40.32089f,-5.162606f,-6.745256f,40.32089f,-2.793987f,-6.703211f,39.92236f,-1.0E-5f,-6.19296f,39.92236f,2.565198f,-4.739886f,39.92236f,4.739876f,-2.565208f,39.92236f,6.19295f,0.0f,39.92236f,6.703201f,0.0f,39.92236f,-6.703221f,-2.565208f,39.92236f,-6.19297f,-4.739886f,39.92236f,-4.739896f,-6.19296f,39.92236f,-2.565218f,-6.387546f,38.571243f,-1.0E-5f,-5.901322f,38.571243f,2.444398f,-4.516678f,38.571243f,4.516668f,-2.444408f,38.571243f,5.901312f,0.0f,38.571243f,6.387536f,0.0f,38.571243f,-6.387556f,-2.444408f,38.571243f,-5.901332f,-4.516678f,38.571243f,-4.516688f,-5.901322f,38.571243f,-2.444418f,-7.97772f,38.16919f,-1.0E-5f,-7.370452f,38.16919f,3.052932f,-5.641099f,38.16919f,5.641089f,-3.052942f,38.16919f,7.370442f,0.0f,38.16919f,7.97771f,0.0f,38.16919f,-7.97773f,-3.052942f,38.16919f,-7.370462f,-5.641099f,38.16919f,-5.641109f,-7.370452f,38.16919f,-3.052952f,-8.266845f,37.815735f,-1.0E-5f,-7.637568f,37.815735f,3.163574f,-5.845539f,37.815735f,5.845529f,-3.163584f,37.815735f,7.637558f,0.0f,37.815735f,8.266835f,0.0f,37.815735f,-8.266855f,-3.163584f,37.815735f,-7.637578f,-5.845539f,37.815735f,-5.845549f,-7.637568f,37.815735f,-3.163594f,-8.127071f,37.27609f,-1.0E-5f,-7.508434f,37.27609f,3.110086f,-5.746709f,37.27609f,5.746699f,-3.110096f,37.27609f,7.508424f,0.0f,37.27609f,8.127061f,0.0f,37.27609f,-8.127081f,-3.110096f,37.27609f,-7.508444f,-5.746709f,37.27609f,-5.746719f,-7.508434f,37.27609f,-3.110106f,-7.3031f,36.844364f,-1.0E-5f,-6.747187f,36.844364f,2.794767f,-5.164073f,36.844364f,5.164063f,-2.794777f,36.844364f,6.747177f,0.0f,36.844364f,7.30309f,0.0f,36.844364f,-7.30311f,-2.794777f,36.844364f,-6.747197f,-5.164073f,36.844364f,-5.164083f,-6.747187f,36.844364f,-2.794787f,-7.929535f,36.736443f,-1.0E-5f,-7.325935f,36.736443f,3.034492f,-5.607028f,36.736443f,5.607018f,-3.034502f,36.736443f,7.325925f,0.0f,36.736443f,7.929525f,0.0f,36.736443f,-7.929545f,-3.034502f,36.736443f,-7.325945f,-5.607028f,36.736443f,-5.607038f,-7.325935f,36.736443f,-3.034512f,-8.748715f,36.196793f,-1.0E-5f,-8.082759f,36.196793f,3.347979f,-6.186274f,36.196793f,6.186264f,-3.347989f,36.196793f,8.082749f,0.0f,36.196793f,8.748705f,0.0f,36.196793f,-8.748725f,-3.347989f,36.196793f,-8.082769f,-6.186274f,36.196793f,-6.186284f,-8.082759f,36.196793f,-3.347999f,-8.768815f,35.0f,-1.0E-5f,-8.10133f,35.0f,3.355671f,-6.200491f,35.0f,6.200481f,-3.355681f,35.0f,8.10132f,0.0f,35.0f,8.768805f,0.0f,35.0f,-8.768825f,-3.355681f,35.0f,-8.10134f,-6.200491f,35.0f,-6.200501f,-8.10133f,35.0f,-3.355691f,-8.681316f,35.0f,-1.0E-5f,-8.020493f,35.0f,3.322187f,-6.13862f,35.0f,6.13861f,-3.322197f,35.0f,8.020483f,-0.0f,35.0f,8.681306f,-0.0f,35.0f,-8.681326f,-3.322197f,35.0f,-8.020503f,-6.13862f,35.0f,-6.13863f,-8.020493f,35.0f,-3.322207f,0.0f,35.0f,-1.0E-5f,-1.230564f,59.054077f,6.413908f,0.0f,59.125572f,6.484851f,0.0f,60.161865f,3.743017f,-1.230564f,60.161865f,3.743017f,0.0f,60.607944f,0.322756f,-1.009267f,60.607944f,0.322756f,0.0f,60.352287f,-1.190595f,-0.65136f,60.287876f,-1.13597f,0.0f,59.056667f,-4.508541f,-0.65136f,58.174362f,-5.71671f,0.0f,58.174362f,-5.71671f,0.0f,57.646572f,-6.368335f,-0.757263f,57.646572f,-6.368335f,0.0f,56.639053f,-7.195712f,-0.811042f,56.639053f,-7.195712f,0.0f,55.299103f,-8.282288f,-0.850981f,55.299103f,-8.282288f,0.0f,53.593307f,-9.40533f,-0.90497f,53.593307f,-9.40533f,0.0f,51.730373f,-10.060701f,-0.931782f,51.730373f,-10.060701f,0.0f,49.7573f,-10.510034f,-0.952037f,49.7573f,-10.510034f,0.0f,46.891617f,-10.471795f,-1.057296f,46.891617f,-10.471795f,0.0f,41.140057f,-9.998912f,-1.468047f,41.140057f,-9.998912f,0.0f,44.74342f,-7.654742f,0.0f,58.992252f,-4.453916f,1.078799f,50.55808f,11.189185f,2.345215f,50.276535f,11.021511f,2.247965f,51.474445f,9.555381f,1.007367f,51.813683f,9.718976f,2.156994f,54.640003f,6.623327f,0.992217f,54.990475f,6.715729f,2.686778f,49.522667f,10.000462f,2.509439f,47.97831f,8.617033f,2.74431f,49.892113f,7.467094f,2.588485f,51.026264f,8.669353f,3.045874f,53.086884f,5.125287f,2.513695f,53.656116f,6.159642f,2.479615f,47.618008f,8.300406f,2.444972f,47.19947f,7.932615f,3.03294f,48.00909f,5.747134f,2.877837f,49.020985f,6.671401f,4.069953f,49.67656f,3.605653f,3.511063f,51.348583f,4.34263f,2.302379f,46.528694f,7.187422f,2.089906f,45.5292f,6.077041f,2.690474f,46.24607f,4.393036f,2.895407f,47.301067f,5.203334f,3.50915f,46.76827f,2.376218f,3.818164f,48.057705f,2.859376f,0.961357f,45.51048f,6.025052f,1.237618f,46.26453f,4.310635f,1.609268f,46.748363f,2.331344f,1.103587f,56.37261f,5.221219f,2.399103f,56.08611f,4.990077f,2.675138f,57.590603f,2.929405f,1.230564f,57.758457f,3.09596f,2.774319f,55.62376f,4.069294f,3.223491f,54.77823f,3.396102f,3.622073f,55.62624f,1.284552f,3.07949f,56.7518f,2.227033f,3.594631f,52.68905f,2.157653f,3.980025f,50.980206f,1.257611f,4.154038f,51.90444f,-0.848826f,3.682273f,53.575214f,0.232878f,3.913275f,49.314503f,0.51431f,3.829242f,47.651634f,-0.13534f,4.10534f,48.43f,-2.055527f,4.236054f,50.175114f,-1.601733f,1.11639f,49.997158f,12.130805f,2.345215f,49.71561f,11.963129f,2.894548f,48.250443f,11.364215f,2.509439f,46.478764f,10.152497f,2.302379f,44.892303f,8.645402f,2.089906f,44.437798f,7.135839f,0.961357f,44.419067f,7.083851f,2.675138f,58.697147f,-0.078212f,1.230564f,58.866245f,0.425072f,3.578081f,56.516186f,-1.258452f,3.060705f,57.76586f,-0.582188f,3.951507f,52.924953f,-3.196098f,3.836215f,54.35962f,-2.262663f,3.663846f,49.229115f,-4.21794f,3.94642f,50.8002f,-3.860253f,2.19406f,59.148422f,-2.950183f,1.009267f,59.31232f,-2.995192f,3.435877f,59.903286f,-2.687578f,3.332816f,60.387035f,-2.592437f,3.59536f,60.112316f,-1.425008f,3.89469f,59.53504f,-1.602989f,2.899601f,53.657455f,-5.584631f,2.767492f,55.128147f,-4.728123f,2.897801f,49.80456f,-6.588491f,3.009314f,51.622036f,-6.368595f,2.675687f,47.077026f,8.82622f,1.22947f,46.745613f,9.157193f,1.221535f,46.53527f,8.972359f,2.658277f,46.86669f,8.641385f,1.045355f,45.579117f,10.022265f,2.275276f,45.752617f,9.849f,2.329516f,46.228733f,10.032395f,1.070169f,46.046227f,10.214653f,1.236302f,46.926685f,9.316316f,2.690675f,47.258106f,8.985342f,1.237096f,46.266525f,13.18874f,1.155481f,44.641006f,12.034281f,2.509439f,44.641006f,12.034281f,2.299133f,46.589626f,12.614416f,0.89449f,43.099182f,10.23562f,0.961357f,43.141506f,8.281446f,2.089906f,43.160233f,8.333434f,2.136932f,43.1067f,10.256502f,1.601073f,59.055145f,-4.153494f,0.65136f,58.992252f,-4.453916f,2.494881f,57.31573f,-3.530555f,2.000058f,57.359238f,-5.269303f,1.630584f,58.324818f,-4.38391f,2.322514f,58.36584f,-3.198008f,2.110337f,53.99491f,-7.083231f,2.071621f,55.629208f,-6.268026f,1.930571f,50.214478f,-7.981492f,2.267098f,52.03263f,-7.799828f,0.811042f,57.34823f,-5.811048f,0.757263f,58.416134f,-5.063226f,0.90497f,54.142273f,-7.781026f,0.850981f,55.929035f,-6.791862f,0.952037f,50.232956f,-8.588837f,0.931782f,52.23464f,-8.291864f,2.380696f,54.197536f,5.278353f,2.457934f,54.070324f,4.907014f,2.590382f,54.50755f,4.589661f,2.419012f,54.7905f,4.633721f,2.444972f,45.564564f,9.754426f,2.444972f,44.203262f,11.57448f,1.8545f,44.528652f,11.175721f,1.028298f,44.528652f,11.175721f,1.126096f,44.203262f,11.57448f,0.866565f,44.967182f,11.315616f,1.886898f,44.967182f,11.315616f,0.99613f,45.653843f,10.615009f,2.168562f,45.76998f,10.499026f,2.509439f,45.810482f,10.836789f,2.752739f,47.751724f,11.823551f,1.08233f,49.010574f,12.091795f,1.357489f,48.508682f,12.402108f,1.947865f,48.46348f,12.163245f,2.140062f,48.897507f,11.947387f,2.089906f,43.828224f,7.707254f,0.961357f,43.809494f,7.655264f,2.302379f,44.258827f,9.39454f,2.074509f,45.16862f,10.482024f,2.444972f,44.915043f,10.622835f,0.953002f,45.077904f,10.57262f,2.526691f,54.76227f,5.837842f,2.632749f,55.462124f,5.087624f,2.922176f,55.26396f,4.429463f,3.119246f,54.53407f,4.26507f,3.024214f,53.83521f,5.047622f,2.780013f,54.15913f,5.68158f,2.302612f,54.53844f,5.317519f,2.333695f,54.90029f,4.977349f,3.90137f,57.598404f,-1.413142f,3.383994f,58.85461f,-0.998216f,2.998427f,59.790775f,-0.688997f,2.517349f,60.227005f,-2.959746f,2.645803f,59.442104f,-3.115092f,2.81817f,58.388893f,-3.323546f,3.372288f,60.542522f,-1.292371f,3.256011f,60.74753f,-2.521536f,1.110952f,48.53478f,13.034978f,2.205623f,48.45096f,12.592074f,2.438743f,49.255733f,12.191842f,1.705419f,47.309185f,0.86885f,0.837388f,49.465378f,12.459598f,1.360422f,49.29737f,11.914469f,2.023149f,49.145535f,11.824039f,3.829242f,45.796913f,1.462717f,4.10534f,46.284904f,-0.739972f,3.663846f,46.777954f,-3.541628f,2.897801f,47.37861f,-6.109754f,1.930571f,47.37861f,-7.491999f,1.057296f,47.37861f,-8.331337f,1.705419f,45.584885f,2.612812f,4.655299f,43.826004f,3.920455f,4.990958f,44.109047f,1.317186f,4.454222f,44.395023f,-1.993978f,3.522923f,44.74342f,-5.029141f,2.34704f,44.74342f,-6.66276f,1.468047f,44.74342f,-7.654742f,2.073318f,43.70302f,5.279707f,5.192418f,42.08561f,5.439801f,6.156551f,42.08561f,2.746045f,6.118672f,42.08561f,-0.573642f,5.312341f,42.08561f,-3.730087f,3.865028f,42.08561f,-5.850341f,2.464711f,42.08561f,-6.888525f,2.553575f,42.08561f,7.014842f,6.791281f,41.616123f,2.81303f,7.35083f,41.616123f,-1.0E-5f,5.197821f,41.616123f,5.197811f,2.81304f,41.616123f,6.791271f,2.81304f,41.616123f,-6.791291f,5.197821f,41.616123f,-5.197831f,6.791281f,41.616123f,-2.81305f,7.256104f,41.264103f,3.005566f,7.85395f,41.264103f,-1.0E-5f,5.553581f,41.264103f,5.553571f,3.005576f,41.264103f,7.256094f,3.005576f,41.264103f,-7.256114f,5.553581f,41.264103f,-5.553591f,7.256104f,41.264103f,-3.005586f,7.256104f,40.716118f,3.005566f,7.85395f,40.716118f,-1.0E-5f,5.553581f,40.716118f,5.553571f,3.005576f,40.716118f,7.256094f,3.005576f,40.716118f,-7.256114f,5.553581f,40.716118f,-5.553591f,7.256104f,40.716118f,-3.005586f,6.745256f,40.32089f,2.793966f,7.301013f,40.32089f,-1.0E-5f,5.162596f,40.32089f,5.162585f,2.793976f,40.32089f,6.745246f,2.793976f,40.32089f,-6.745266f,5.162596f,40.32089f,-5.162606f,6.745256f,40.32089f,-2.793987f,6.19296f,39.92236f,2.565198f,6.703211f,39.92236f,-1.0E-5f,4.739886f,39.92236f,4.739876f,2.565208f,39.92236f,6.19295f,2.565208f,39.92236f,-6.19297f,4.739886f,39.92236f,-4.739896f,6.19296f,39.92236f,-2.565218f,5.901322f,38.571243f,2.444398f,6.387546f,38.571243f,-1.0E-5f,4.516678f,38.571243f,4.516668f,2.444408f,38.571243f,5.901312f,2.444408f,38.571243f,-5.901332f,4.516678f,38.571243f,-4.516688f,5.901322f,38.571243f,-2.444418f,7.370452f,38.16919f,3.052932f,7.97772f,38.16919f,-1.0E-5f,5.641099f,38.16919f,5.641089f,3.052942f,38.16919f,7.370442f,3.052942f,38.16919f,-7.370462f,5.641099f,38.16919f,-5.641109f,7.370452f,38.16919f,-3.052952f,7.637568f,37.815735f,3.163574f,8.266845f,37.815735f,-1.0E-5f,5.845539f,37.815735f,5.845529f,3.163584f,37.815735f,7.637558f,3.163584f,37.815735f,-7.637578f,5.845539f,37.815735f,-5.845549f,7.637568f,37.815735f,-3.163594f,7.508434f,37.27609f,3.110086f,8.127071f,37.27609f,-1.0E-5f,5.746709f,37.27609f,5.746699f,3.110096f,37.27609f,7.508424f,3.110096f,37.27609f,-7.508444f,5.746709f,37.27609f,-5.746719f,7.508434f,37.27609f,-3.110106f,6.747187f,36.844364f,2.794767f,7.3031f,36.844364f,-1.0E-5f,5.164073f,36.844364f,5.164063f,2.794777f,36.844364f,6.747177f,2.794777f,36.844364f,-6.747197f,5.164073f,36.844364f,-5.164083f,6.747187f,36.844364f,-2.794787f,7.325935f,36.736443f,3.034492f,7.929535f,36.736443f,-1.0E-5f,5.607028f,36.736443f,5.607018f,3.034502f,36.736443f,7.325925f,3.034502f,36.736443f,-7.325945f,5.607028f,36.736443f,-5.607038f,7.325935f,36.736443f,-3.034512f,8.082759f,36.196793f,3.347979f,8.748715f,36.196793f,-1.0E-5f,6.186274f,36.196793f,6.186264f,3.347989f,36.196793f,8.082749f,3.347989f,36.196793f,-8.082769f,6.186274f,36.196793f,-6.186284f,8.082759f,36.196793f,-3.347999f,8.10133f,35.0f,3.355671f,8.768815f,35.0f,-1.0E-5f,6.200491f,35.0f,6.200481f,3.355681f,35.0f,8.10132f,3.355681f,35.0f,-8.10134f,6.200491f,35.0f,-6.200501f,8.10133f,35.0f,-3.355691f,8.020493f,35.0f,3.322187f,8.681316f,35.0f,-1.0E-5f,6.13862f,35.0f,6.13861f,3.322197f,35.0f,8.020483f,3.322197f,35.0f,-8.020503f,6.13862f,35.0f,-6.13863f,8.020493f,35.0f,-3.322207f,1.230564f,59.054077f,6.413908f,1.230564f,60.161865f,3.743017f,1.009267f,60.607944f,0.322756f,0.65136f,60.287876f,-1.13597f,0.65136f,58.174362f,-5.71671f,0.757263f,57.646572f,-6.368335f,0.811042f,56.639053f,-7.195712f,0.850981f,55.299103f,-8.282288f,0.90497f,53.593307f,-9.40533f,0.931782f,51.730373f,-10.060701f,0.952037f,49.7573f,-10.510034f,1.057296f,46.891617f,-10.471795f,1.468047f,41.140057f,-9.998912f);
    }
    private static void method4(){
        MESH_1.getTexCoords().ensureCapacity(1114);
        MESH_1.getTexCoords().addAll(0.701508f,0.95787f,0.700401f,0.934602f,0.71963f,0.932198f,0.721138f,0.955381f,0.700166f,0.87637603f,0.71822f,0.875081f,0.127292f,0.627262f,0.150075f,0.648471f,0.132035f,0.66666f,0.102826f,0.6481f,0.196285f,0.69883597f,0.187063f,0.714643f,0.09712f,0.652866f,0.118228f,0.678652f,0.10219f,0.692582f,0.090492f,0.65840304f,0.159824f,0.726097f,0.13363f,0.736868f,0.079809f,0.66969f,0.091008f,0.700734f,0.074346f,0.71288097f,0.063891f,0.686508f,0.108255f,0.747804f,0.088088f,0.754791f,0.361783f,0.24946398f,0.371092f,0.275836f,0.348573f,0.27712f,0.344291f,0.25026202f,0.383782f,0.317747f,0.354333f,0.318434f,0.701892f,0.852682f,0.70386f,0.81921303f,0.726251f,0.816698f,0.721973f,0.849212f,0.225964f,0.73199f,0.242729f,0.760974f,0.224922f,0.775142f,0.212601f,0.74209297f,0.179748f,0.76047397f,0.192733f,0.790643f,0.166424f,0.806756f,0.15292f,0.773758f,0.126821f,0.78463f,0.139336f,0.817752f,0.112119f,0.824107f,0.100802f,0.794051f,0.721138f,0.970189f,0.702091f,0.972678f,0.080185f,0.623726f,0.108108f,0.605636f,0.047389f,0.669679f,0.055018f,0.64646304f,0.344291f,0.233432f,0.361783f,0.23263401f,0.70386f,0.77739704f,0.726251f,0.769664f,0.257353f,0.804897f,0.237726f,0.814892f,0.20392f,0.829616f,0.181295f,0.844828f,0.148146f,0.852991f,0.123552f,0.862336f,0.718795f,0.72498703f,0.70043f,0.724226f,0.304404f,0.838719f,0.299119f,0.82177f,0.308133f,0.819236f,0.311937f,0.837432f,0.214873f,0.868117f,0.191602f,0.886795f,0.137482f,0.89737797f,0.159908f,0.892178f,0.216728f,0.18632f,0.213946f,0.18605f,0.219203f,0.16377997f,0.221985f,0.163903f,0.055411f,0.19127798f,0.036266f,0.185341f,0.033514f,0.16627699f,0.050154f,0.16900802f,0.235747f,0.18095398f,0.219124f,0.18655199f,0.224381f,0.16400898f,0.238642f,0.161434f,0.916524f,0.139525f,0.921308f,0.15598702f,0.890889f,0.15924698f,0.890889f,0.13826f,0.343254f,0.18408298f,0.362512f,0.18376201f,0.361783f,0.21358198f,0.344291f,0.21438003f,0.694882f,0.701747f,0.709603f,0.706377f,0.807721f,0.07102603f,0.824122f,0.06628102f,0.823027f,0.08464098f,0.807721f,0.09798598f,0.22204f,0.892173f,0.1964f,0.904171f,0.165805f,0.910935f,0.137482f,0.916239f,0.715788f,0.689745f,0.710061f,0.70309f,0.696524f,0.692528f,0.697358f,0.681355f,0.837531f,0.16514498f,0.836931f,0.190786f,0.819389f,0.19522798f,0.818848f,0.167261f,0.168655f,0.922217f,0.137482f,0.927692f,0.20644f,0.71201f,0.215627f,0.722787f,0.210901f,0.72449f,0.204278f,0.717372f,0.08561f,0.647291f,0.088941f,0.64450896f,0.065864f,0.629539f,0.068815f,0.628147f,0.008929f,0.187971f,0.008929f,0.16752797f,0.015234f,0.16601199f,0.015234f,0.178819f,0.091808f,0.642113f,0.076264f,0.62549f,0.267383f,0.16275603f,0.267383f,0.183743f,0.25612f,0.17409301f,0.25612f,0.15827799f,0.243156f,0.17845899f,0.244998f,0.16028601f,0.248374f,0.183743f,0.100558f,0.598325f,0.070095f,0.612863f,0.052438f,0.593854f,0.082857f,0.58562f,0.702148f,0.974961f,0.718543f,0.972767f,0.715564f,0.97628f,0.706413f,0.979964f,0.361783f,0.22354299f,0.344291f,0.22434199f,0.045492f,0.63461f,0.038165f,0.660588f,0.028057f,0.650626f,0.027974f,0.620806f,0.026231f,0.18222898f,0.023951f,0.187971f,0.024792f,0.16484499f,0.21171f,0.692033f,0.233485f,0.717901f,0.223951f,0.71786904f,0.212471f,0.704231f,0.21294f,0.73062396f,0.221471f,0.725804f,0.199476f,0.716152f,0.203894f,0.706439f,0.216317f,0.718217f,0.21067f,0.71150804f,0.277213f,0.811845f,0.257587f,0.817787f,0.050086f,0.08108401f,0.060053f,0.10094398f,0.015376f,0.095065f,0.014731f,0.075204015f,0.186925f,0.110597014f,0.189597f,0.09419602f,0.195806f,0.114057004f,0.193134f,0.130458f,0.269095f,0.847696f,0.249235f,0.85040903f,0.040155f,0.058072984f,0.021029f,0.055372f,0.205381f,0.14936602f,0.203783f,0.15689898f,0.951612f,0.13757002f,0.950142f,0.15453702f,0.962457f,0.15815097f,0.939009f,0.16301799f,0.13937f,0.611732f,0.131043f,0.596924f,0.157363f,0.634915f,0.255999f,0.750416f,0.271979f,0.797449f,0.291839f,0.807416f,0.314851f,0.817347f,0.317551f,0.836473f,0.191143f,0.14267999f,0.202593f,0.162512f,0.184934f,0.12282002f,0.836345f,0.06274402f,0.834433f,0.08135301f,0.346844f,0.16376501f,0.367287f,0.16376501f,0.056137f,0.615831f,0.045476f,0.600809f,0.820853f,0.13740098f,0.839961f,0.13455099f,0.388744f,0.35700703f,0.355824f,0.34131402f,0.329389f,0.337421f,0.329389f,0.31901997f,0.329389f,0.27821398f,0.329389f,0.250942f,0.329389f,0.23411298f,0.329389f,0.22502202f,0.329389f,0.21506f,0.329389f,0.18435597f,0.329389f,0.16376501f,0.008929f,0.15007299f,0.015234f,0.15007299f,0.023566f,0.15007299f,0.03117f,0.15007299f,0.045675f,0.15007299f,0.223681f,0.14484602f,0.226463f,0.14484602f,0.228859f,0.14484602f,0.241108f,0.14484602f,0.246567f,0.14484602f,0.25612f,0.14484602f,0.267383f,0.14484602f,0.916176f,0.12035f,0.890889f,0.12035f,0.952319f,0.12035f,0.684786f,0.980765f,0.697766f,0.977979f,0.702006f,0.987256f,0.684786f,0.991205f,0.684786f,0.95999f,0.684786f,0.974798f,0.684786f,0.93672f,0.684786f,0.87755203f,0.684786f,0.855639f,0.684786f,0.821356f,0.249235f,0.877368f,0.835822f,0.21798003f,0.817392f,0.21759999f,0.628229f,0.05604899f,0.625841f,0.06632203f,0.622045f,0.06813401f,0.623854f,0.051738977f,0.124006f,0.593202f,0.237511f,0.183743f,0.037659f,0.187971f,0.722587f,0.973911f,0.718974f,0.980425f,0.638027f,0.051680982f,0.633599f,0.070728004f,0.626562f,0.072178006f,0.629914f,0.047357023f,0.081296f,0.82691f,0.073732f,0.794048f,0.088938f,0.868707f,0.098249f,0.90702f,0.098249f,0.927641f,0.098249f,0.940163f,0.168513f,0.322783f,0.17343f,0.355703f,0.14636f,0.355703f,0.143074f,0.322783f,0.168521f,0.296349f,0.143079f,0.296349f,0.04757f,0.813216f,0.043182f,0.772865f,0.052002f,0.86454f,0.057402f,0.911586f,0.057402f,0.936908f,0.057402f,0.952284f,0.115811f,0.36850703f,0.113905f,0.328485f,0.113907f,0.296349f,0.016206f,0.80674f,0.016206f,0.764986f,0.016206f,0.858196f,0.016206f,0.907122f,0.016206f,0.939986f,0.016206f,0.961033f,0.088834f,0.376832f,0.088834f,0.33593f,0.088834f,0.296349f,0.522918f,0.361234f,0.514027f,0.380333f,0.470424f,0.37166f,0.471462f,0.361821f,0.008929f,0.805702f,0.008929f,0.768737f,0.008929f,0.744038f,0.016206f,0.740573f,0.081557f,0.33995098f,0.081557f,0.296349f,0.386083f,0.259826f,0.39336f,0.259826f,0.39336f,0.303429f,0.386083f,0.29124302f,0.008929f,0.954571f,0.008929f,0.929872f,0.604709f,0.326302f,0.594595f,0.34696102f,0.55763f,0.37166f,0.571844f,0.348736f,0.514027f,0.38813102f,0.46744f,0.378865f,0.427945f,0.352475f,0.433459f,0.34696102f,0.401555f,0.31298f,0.40876f,0.309996f,0.076101f,0.34293598f,0.076101f,0.296349f,0.627967f,0.266393f,0.635765f,0.266393f,0.626499f,0.31298f,0.619294f,0.309996f,0.600109f,0.352475f,0.560614f,0.378865f,0.257908f,0.23857498f,0.249414f,0.23857498f,0.249414f,0.19198698f,0.257908f,0.19198698f,0.076101f,0.40881997f,0.067607f,0.40881997f,0.067607f,0.38243002f,0.076101f,0.38243002f,0.067607f,0.34293598f,0.067607f,0.296349f,0.896691f,0.21521097f,0.905185f,0.21521097f,0.905185f,0.26179802f,0.896691f,0.26179802f,0.257908f,0.35104603f,0.249414f,0.35104603f,0.249414f,0.32465702f,0.257908f,0.32465702f,0.249414f,0.28516197f,0.257908f,0.28516197f,0.243288f,0.23857498f,0.243288f,0.19526702f,0.414308f,0.18193102f,0.40639f,0.185211f,0.381858f,0.14849699f,0.387918f,0.14243698f,0.345144f,0.12396598f,0.348423f,0.116047025f,0.061481f,0.339656f,0.061481f,0.296349f,0.911311f,0.21521097f,0.911311f,0.25851798f,0.683027f,0.15724897f,0.679747f,0.14933097f,0.716461f,0.12479901f,0.722521f,0.13085902f,0.740993f,0.088084996f,0.748911f,0.09136498f,0.243288f,0.281882f,0.237111f,0.23857498f,0.237111f,0.19881302f,0.397829f,0.188757f,0.375306f,0.15504903f,0.341598f,0.13252598f,0.055303f,0.33611f,0.055303f,0.296349f,0.917488f,0.21521097f,0.917488f,0.25497198f,0.676201f,0.14077002f,0.709909f,0.11824697f,0.732432f,0.084538996f,0.237111f,0.278336f,0.213946f,0.23857498f,0.213946f,0.199404f,0.055303f,0.39234102f,0.032138f,0.39091402f,0.032138f,0.36872602f,0.055303f,0.36981797f,0.032138f,0.33551902f,0.032138f,0.296349f,0.940654f,0.21521097f,0.940654f,0.254381f,0.237111f,0.334567f,0.213946f,0.33314002f,0.213946f,0.310952f,0.237111f,0.31204402f,0.213946f,0.277745f,0.326925f,0.487648f,0.352407f,0.487648f,0.342676f,0.53657f,0.319133f,0.526819f,0.314963f,0.578044f,0.296945f,0.560026f,0.27349f,0.60575604f,0.263738f,0.582214f,0.224568f,0.615487f,0.224568f,0.59000504f,0.224568f,0.38529098f,0.224568f,0.35980898f,0.27349f,0.36953998f,0.263738f,0.39308202f,0.314963f,0.39725202f,0.296945f,0.41527098f,0.342676f,0.438726f,0.319133f,0.44847798f,0.35704f,0.487648f,0.346956f,0.538343f,0.31824f,0.58132f,0.275263f,0.610036f,0.224568f,0.62012f,0.224568f,0.35517597f,0.275263f,0.36526f,0.31824f,0.39397597f,0.346956f,0.436953f,0.42475f,0.486108f,0.417028f,0.486108f,0.417028f,0.436271f,0.42475f,0.43541402f,0.417028f,0.39402002f,0.42475f,0.39243698f,0.417028f,0.36579f,0.42475f,0.36372f,0.941161f,0.49915302f,0.933439f,0.49829602f,0.933439f,0.44845802f,0.941161f,0.44845802f,0.008929f,0.29073697f,0.01665f,0.29073697f,0.01665f,0.34057498f,0.008929f,0.34143198f,0.42475f,0.608497f,0.417028f,0.606427f,0.417028f,0.578197f,0.42475f,0.57978f,0.417028f,0.535946f,0.42475f,0.536803f,0.921192f,0.35423702f,0.907989f,0.35423702f,0.89908f,0.309452f,0.911279f,0.304399f,0.873712f,0.27148497f,0.883048f,0.26214898f,0.835745f,0.246117f,0.840798f,0.23391801f,0.79096f,0.23720801f,0.79096f,0.22400498f,0.79096f,0.484469f,0.79096f,0.47126502f,0.835745f,0.46235698f,0.840798f,0.47455603f,0.873712f,0.436988f,0.883048f,0.446325f,0.89908f,0.39902198f,0.911279f,0.404074f,0.691658f,0.528265f,0.701696f,0.528265f,0.692024f,0.576891f,0.682749f,0.57305f,0.664479f,0.618114f,0.657381f,0.61101604f,0.623255f,0.64565897f,0.619414f,0.63638496f,0.574629f,0.655331f,0.574629f,0.645293f,0.574629f,0.411236f,0.574629f,0.40119803f,0.623255f,0.41087002f,0.619414f,0.42014402f,0.664479f,0.438415f,0.657381f,0.445513f,0.692024f,0.47963798f,0.682749f,0.48347998f,0.714823f,0.528265f,0.704151f,0.581914f,0.673761f,0.627397f,0.628279f,0.65778697f,0.574629f,0.668458f,0.574629f,0.388071f,0.628279f,0.39874297f,0.673761f,0.429133f,0.704151f,0.47461498f,0.022904f,0.48145503f,0.008929f,0.48145503f,0.008929f,0.42768198f,0.022904f,0.427805f,0.008929f,0.38209498f,0.022904f,0.38232303f,0.008929f,0.35163498f,0.022904f,0.351933f,0.989966f,0.54605f,0.97599f,0.546173f,0.97599f,0.4924f,0.989966f,0.4924f,0.183f,0.29539102f,0.196975f,0.29539102f,0.196975f,0.349164f,0.183f,0.349041f,0.022904f,0.610977f,0.008929f,0.611274f,0.008929f,0.580814f,0.022904f,0.580587f,0.008929f,0.535228f,0.022904f,0.535105f,0.990113f,0.62308f,0.971258f,0.62308f,0.961997f,0.576522f,0.979417f,0.569306f,0.935625f,0.53705204f,0.948956f,0.52372f,0.896155f,0.510679f,0.90337f,0.49326003f,0.849597f,0.501418f,0.849597f,0.48256397f,0.849597f,0.763595f,0.849597f,0.74474096f,0.896155f,0.73548f,0.90337f,0.752899f,0.935625f,0.70910704f,0.948956f,0.722439f,0.961997f,0.66963696f,0.979417f,0.676853f,0.849597f,0.62308f,0.0f,1.0f,0.0f,0.574422f,1.0f,0.574422f,1.0f,1.0f,0.021974f,0.65750396f,0.981978f,0.719096f,0.963955f,1.0f,0.119828f,0.5f,0.859684f,0.67731f,0.782349f,1.0f,0.10863f,1.0f,0.054315f,0.569925f,0.607991f,0.5f,0.671137f,1.0f,0.038515f,1.0f,0.019258f,0.533154f,0.822983f,0.5f,0.843608f,1.0f,0.064442f,1.0f,0.032221f,0.568537f,0.949972f,0.5f,0.987312f,1.0f,0.008679f,0.520702f,0.991643f,0.538501f,0.983287f,1.0f,0.052096f,1.0f,0.026048f,0.58517003f,0.970229f,0.52588296f,0.019639f,0.51257f,0.981923f,0.551341f,0.963846f,1.0f,0.0f,0.64154196f,1.0f,0.64154196f,0.048949f,1.0f,0.024475f,0.672431f,0.970246f,0.601766f,0.182729f,1.0f,0.091365f,0.714483f,0.76163f,0.5f,0.921629f,1.0f);
    }
    private static void method5(){
        MESH_1.getFaces().ensureCapacity(7656);
        MESH_1.getFaces().addAll(0,0,1,1,2,2,0,0,2,2,3,3,1,1,4,4,5,5,1,1,5,5,2,2,6,6,7,7,8,8,6,6,8,8,9,9,7,7,10,10,11,11,7,7,11,11,8,8,12,12,13,13,14,14,12,12,14,14,15,15,13,13,16,16,17,17,13,13,17,17,14,14,18,18,19,19,20,20,18,18,20,20,21,21,19,19,22,22,23,23,19,19,23,23,20,20,21,24,20,25,24,26,21,24,24,26,25,27,20,25,23,28,26,29,20,25,26,29,24,26,27,30,28,31,29,32,27,30,29,32,30,33,31,34,32,35,33,36,31,34,33,36,34,37,35,38,36,39,37,40,35,38,37,40,38,41,39,42,40,43,41,44,39,42,41,44,42,45,0,0,3,3,43,46,0,0,43,46,44,47,6,6,9,9,45,48,6,6,45,48,46,49,18,18,21,21,47,50,18,18,47,50,48,51,21,24,25,27,49,52,21,24,49,52,47,53,29,32,28,31,50,54,29,32,50,54,51,55,33,36,32,35,52,56,33,36,52,56,53,57,37,40,36,39,54,58,37,40,54,58,55,59,41,44,40,43,56,60,41,44,56,60,57,61,58,62,51,55,50,54,58,62,50,54,59,63,60,64,61,65,62,66,60,64,62,66,63,67,55,59,54,58,64,68,55,59,64,68,65,69,66,70,57,61,56,60,66,70,56,60,67,71,68,72,69,73,70,74,68,72,70,74,71,75,69,76,72,77,73,78,69,76,73,78,70,79,74,80,75,81,76,82,74,80,76,82,77,83,78,84,79,85,80,86,78,84,80,86,81,87,82,88,83,89,84,90,82,88,84,90,85,91,58,62,59,63,86,92,58,62,86,92,87,93,88,94,89,95,90,96,88,94,90,96,91,97,65,69,64,68,92,98,65,69,92,98,93,99,66,70,67,71,94,100,66,70,94,100,95,101,91,102,90,103,96,104,91,102,96,104,97,105,93,106,92,107,98,108,93,106,98,108,99,109,95,101,94,100,100,110,95,101,100,110,101,111,22,22,39,42,42,45,22,22,42,45,23,23,16,16,35,38,38,41,16,16,38,41,17,17,102,112,103,113,104,114,102,112,104,114,105,115,4,4,27,30,30,33,4,4,30,33,5,5,12,12,15,15,69,116,12,12,69,116,68,117,15,15,106,118,72,119,15,15,72,119,69,116,107,120,108,121,109,122,107,120,109,122,110,123,45,48,9,9,75,124,45,48,75,124,74,125,81,126,80,127,111,128,81,126,111,128,112,129,111,128,113,130,114,131,111,128,114,131,112,129,80,127,115,132,113,130,80,127,113,130,111,128,116,133,115,134,80,135,116,133,80,135,79,136,117,137,118,138,119,139,117,137,119,139,120,140,121,141,122,142,85,91,121,141,85,91,84,90,123,143,121,144,84,145,123,143,84,145,83,146,124,147,125,148,107,120,124,147,107,120,110,123,126,149,124,147,110,123,126,149,110,123,109,122,5,150,30,151,127,152,5,150,127,152,128,153,31,34,34,37,129,154,31,34,129,154,130,155,34,37,11,11,131,156,34,37,131,156,129,154,11,11,10,10,132,157,11,11,132,157,131,156,128,153,127,152,133,158,128,153,133,158,134,159,130,155,129,154,104,114,130,155,104,114,103,113,129,154,131,156,105,115,129,154,105,115,104,114,131,156,132,157,102,112,131,156,102,112,105,115,53,57,52,56,135,160,53,57,135,160,136,161,137,162,51,163,58,164,137,162,58,164,138,165,89,166,88,167,139,168,89,166,139,168,140,169,139,170,88,171,53,57,139,170,53,57,136,161,136,161,135,160,62,66,136,161,62,66,61,65,141,172,137,162,138,165,141,172,138,165,142,173,140,169,139,168,60,174,140,169,60,174,63,175,60,64,139,170,136,161,60,64,136,161,61,65,143,176,144,177,79,85,143,176,79,85,78,84,145,178,116,179,79,85,145,178,79,85,144,177,3,180,6,6,46,49,3,180,46,49,43,181,3,180,2,182,7,7,3,180,7,7,6,6,2,182,5,150,10,10,2,182,10,10,7,7,132,157,10,10,5,150,132,157,5,150,128,153,102,112,132,157,128,153,102,112,128,153,134,159,134,159,133,158,103,113,134,159,103,113,102,112,127,152,130,155,103,113,127,152,103,113,133,158,30,151,31,34,130,155,30,151,130,155,127,152,30,151,29,183,32,35,30,151,32,35,31,34,52,56,32,35,29,183,52,56,29,183,51,184,135,160,52,56,51,184,135,160,51,184,137,185,62,66,135,160,137,185,62,66,137,185,141,186,62,66,141,186,142,187,62,66,142,187,63,67,138,188,140,169,63,175,138,188,63,175,142,189,58,190,89,166,140,169,58,190,140,169,138,188,90,96,89,95,58,191,90,96,58,191,87,192,96,104,90,103,87,93,96,104,87,93,86,92,108,193,107,194,83,89,108,193,83,89,82,88,125,195,123,143,83,146,125,195,83,146,107,196,15,15,18,18,48,51,15,15,48,51,106,118,15,15,14,14,19,19,15,15,19,19,18,18,14,14,17,17,22,22,14,14,22,22,19,19,17,17,38,41,39,42,17,17,39,42,22,22,38,41,37,40,40,43,38,41,40,43,39,42,56,60,40,43,37,40,56,60,37,40,55,59,56,60,55,59,65,69,56,60,65,69,67,71,94,100,67,71,65,69,94,100,65,69,93,99,100,197,94,198,93,106,100,197,93,106,99,109,23,28,42,199,146,200,23,28,146,200,26,29,26,29,146,200,147,201,26,29,147,201,148,202,24,26,26,29,148,202,24,26,148,202,149,203,25,27,24,26,149,203,25,27,149,203,150,204,49,52,25,27,150,204,49,52,150,204,151,205,85,91,122,142,152,206,85,91,152,206,153,207,154,208,82,88,85,91,154,208,85,91,153,207,155,209,108,193,82,88,155,209,82,88,154,208,109,122,108,121,155,210,109,122,155,210,156,211,157,212,126,149,109,122,157,212,109,122,156,211,70,79,73,78,158,213,70,79,158,213,159,214,71,75,70,74,159,215,71,75,159,215,160,216,77,83,76,82,161,217,77,83,161,217,162,218,112,129,114,131,163,219,112,129,163,219,164,220,165,221,81,126,112,129,165,221,112,129,164,220,166,222,78,84,81,87,166,222,81,87,165,223,167,224,143,176,78,84,167,224,78,84,166,222,168,225,169,226,143,227,168,225,143,227,167,228,170,229,0,0,44,47,170,229,44,47,171,230,170,229,172,231,1,1,170,229,1,1,0,0,172,231,173,232,4,4,172,231,4,4,1,1,173,232,174,233,27,30,173,232,27,30,4,4,174,233,175,234,28,31,174,233,28,31,27,30,76,82,71,75,160,216,76,82,160,216,161,217,75,81,68,72,71,75,75,81,71,75,76,82,9,9,12,12,68,117,9,9,68,117,75,124,9,9,8,8,13,13,9,9,13,13,12,12,8,8,11,11,16,16,8,8,16,16,13,13,11,11,34,37,35,38,11,11,35,38,16,16,34,37,33,36,36,39,34,37,36,39,35,38,54,58,36,39,33,36,54,58,33,36,53,57,64,68,54,58,53,57,64,68,53,57,88,171,92,98,64,68,88,171,92,98,88,171,91,235,98,108,92,107,91,236,98,108,91,236,97,237,171,230,44,47,169,226,171,230,169,226,168,225,176,238,177,239,118,240,176,238,118,240,117,241,43,181,46,49,116,133,43,181,116,133,145,242,46,49,45,48,115,134,46,49,115,134,116,133,113,130,115,132,45,243,113,130,45,243,74,80,114,131,113,130,74,80,114,131,74,80,77,83,163,219,114,131,77,83,163,219,77,83,162,218,158,213,73,78,126,149,158,213,126,149,157,212,73,78,72,77,124,147,73,78,124,147,126,149,72,77,106,244,125,148,72,77,125,148,124,147,106,118,48,51,123,143,106,118,123,143,125,195,48,51,47,50,121,144,48,51,121,144,123,143,47,53,49,52,122,142,47,53,122,142,121,141,152,206,122,142,49,52,152,206,49,52,151,205,145,245,144,246,119,139,145,245,119,139,118,138,144,246,143,227,120,140,144,246,120,140,119,139,143,227,169,226,117,137,143,227,117,137,120,140,44,247,43,248,177,239,44,247,177,239,176,238,43,248,145,249,118,240,43,248,118,240,177,239,169,250,44,247,176,238,169,250,176,238,117,241,42,45,41,44,178,251,42,45,178,251,179,252,41,44,57,61,180,253,41,44,180,253,178,251,57,61,66,70,181,254,57,61,181,254,180,253,66,70,95,101,182,255,66,70,182,255,181,254,95,101,101,111,183,256,95,101,183,256,182,255,146,257,42,258,179,259,146,257,179,259,184,260,147,261,146,257,184,260,147,261,184,260,185,262,179,252,178,251,186,263,179,252,186,263,187,264,178,251,180,253,188,265,178,251,188,265,186,263,180,253,181,254,189,266,180,253,189,266,188,265,181,254,182,255,190,267,181,254,190,267,189,266,182,255,183,256,191,268,182,255,191,268,190,267,184,260,179,259,187,269,184,260,187,269,192,270,185,262,184,260,192,270,185,262,192,270,193,271,187,264,186,263,194,272,187,264,194,272,195,273,186,263,188,265,196,274,186,263,196,274,194,272,188,265,189,266,197,275,188,265,197,275,196,274,189,266,190,267,198,276,189,266,198,276,197,275,190,267,191,268,199,277,190,267,199,277,198,276,192,270,187,269,195,278,192,270,195,278,200,279,193,271,192,270,200,279,193,271,200,279,201,280,196,281,202,282,203,283,196,281,203,283,194,284,194,272,203,285,204,286,194,272,204,286,195,273,195,273,204,286,205,287,195,273,205,287,200,288,200,279,205,289,206,290,200,279,206,290,201,280,207,291,208,292,209,293,207,291,209,293,199,294,199,277,209,295,210,296,199,277,210,296,198,276,198,297,210,298,211,299,198,297,211,299,197,300,197,300,211,299,202,282,197,300,202,282,196,281,202,282,212,301,213,302,202,282,213,302,203,283,203,283,213,302,214,303,203,283,214,303,204,304,204,304,214,303,215,305,204,304,215,305,205,306,205,289,215,307,216,308,205,289,216,308,206,290,208,309,217,310,218,311,208,309,218,311,209,312,209,312,218,311,219,313,209,312,219,313,210,298,210,298,219,313,220,314,210,298,220,314,211,299,211,299,220,314,212,301,211,299,212,301,202,282,212,315,221,316,222,317,212,315,222,317,213,318,213,319,222,320,223,321,213,319,223,321,214,322,214,322,223,321,224,323,214,322,224,323,215,307,215,307,224,323,225,324,215,307,225,324,216,308,217,325,226,326,227,327,217,325,227,327,218,328,218,329,227,330,228,331,218,329,228,331,219,332,219,332,228,331,229,333,219,332,229,333,220,334,220,334,229,333,221,316,220,334,221,316,212,315,221,316,230,335,231,336,221,316,231,336,222,317,222,337,231,338,232,339,222,337,232,339,223,340,223,340,232,339,233,341,223,340,233,341,224,342,224,323,233,343,234,344,224,323,234,344,225,324,226,326,235,345,236,346,226,326,236,346,227,327,227,347,236,348,237,349,227,347,237,349,228,350,228,350,237,349,238,351,228,350,238,351,229,352,229,333,238,353,230,335,229,333,230,335,221,316,230,335,239,354,240,355,230,335,240,355,231,336,231,338,240,356,241,357,231,338,241,357,232,339,232,339,241,357,242,358,232,339,242,358,233,341,233,343,242,359,243,360,233,343,243,360,234,344,235,345,244,361,245,362,235,345,245,362,236,346,236,348,245,363,246,364,236,348,246,364,237,349,237,349,246,364,247,365,237,349,247,365,238,351,238,353,247,366,239,354,238,353,239,354,230,335,239,354,248,367,249,368,239,354,249,368,240,355,240,369,249,370,250,371,240,369,250,371,241,372,241,372,250,371,251,373,241,372,251,373,242,359,242,359,251,373,252,374,242,359,252,374,243,360,244,361,253,375,254,376,244,361,254,376,245,362,245,377,254,378,255,379,245,377,255,379,246,380,246,380,255,379,256,381,246,380,256,381,247,366,247,366,256,381,248,367,247,366,248,367,239,354,248,382,257,383,258,384,248,382,258,384,249,385,249,385,258,384,259,386,249,385,259,386,250,387,250,387,259,386,260,388,250,387,260,388,251,389,251,389,260,388,261,390,251,389,261,390,252,391,253,392,262,393,263,394,253,392,263,394,254,395,254,395,263,394,264,396,254,395,264,396,255,397,255,397,264,396,265,398,255,397,265,398,256,399,256,399,265,398,257,383,256,399,257,383,248,382,257,383,266,400,267,401,257,383,267,401,258,384,258,384,267,401,268,402,258,384,268,402,259,386,259,386,268,402,269,403,259,386,269,403,260,388,260,388,269,403,270,404,260,388,270,404,261,390,262,393,271,405,272,406,262,393,272,406,263,394,263,394,272,406,273,407,263,394,273,407,264,396,264,396,273,407,274,408,264,396,274,408,265,398,265,398,274,408,266,400,265,398,266,400,257,383,266,409,275,410,276,411,266,409,276,411,267,412,267,412,276,411,277,413,267,412,277,413,268,414,268,414,277,413,278,415,268,414,278,415,269,416,269,417,278,418,279,419,269,417,279,419,270,420,271,421,280,422,281,423,271,421,281,423,272,424,272,425,281,426,282,427,272,425,282,427,273,428,273,428,282,427,283,429,273,428,283,429,274,430,274,430,283,429,275,410,274,430,275,410,266,409,275,431,284,432,285,433,275,431,285,433,276,434,276,434,285,433,286,435,276,434,286,435,277,436,277,436,286,435,287,437,277,436,287,437,278,438,278,438,287,437,288,439,278,438,288,439,279,440,280,441,289,442,290,443,280,441,290,443,281,444,281,444,290,443,291,445,281,444,291,445,282,446,282,446,291,445,292,447,282,446,292,447,283,448,283,448,292,447,284,432,283,448,284,432,275,431,284,449,293,450,294,451,284,449,294,451,285,452,285,452,294,451,295,453,285,452,295,453,286,454,286,454,295,453,296,455,286,454,296,455,287,456,287,456,296,455,297,457,287,456,297,457,288,458,289,459,298,460,299,461,289,459,299,461,290,462,290,462,299,461,300,463,290,462,300,463,291,464,291,464,300,463,301,465,291,464,301,465,292,466,292,466,301,465,293,450,292,466,293,450,284,449,293,450,302,467,303,468,293,450,303,468,294,451,294,451,303,468,304,469,294,451,304,469,295,453,295,453,304,469,305,470,295,453,305,470,296,455,296,455,305,470,306,471,296,455,306,471,297,457,298,460,307,472,308,473,298,460,308,473,299,461,299,461,308,473,309,474,299,461,309,474,300,463,300,463,309,474,310,475,300,463,310,475,301,465,301,465,310,475,302,467,301,465,302,467,293,450,302,476,311,477,312,478,302,476,312,478,303,479,303,479,312,478,313,480,303,479,313,480,304,481,304,481,313,480,314,482,304,481,314,482,305,483,305,484,314,485,315,486,305,484,315,486,306,487,307,488,316,489,317,490,307,488,317,490,308,491,308,492,317,493,318,494,308,492,318,494,309,495,309,495,318,494,319,496,309,495,319,496,310,497,310,497,319,496,311,477,310,497,311,477,302,476,311,498,320,499,321,500,311,498,321,500,312,501,312,501,321,500,322,502,312,501,322,502,313,503,313,503,322,502,323,504,313,503,323,504,314,505,314,505,323,504,324,506,314,505,324,506,315,507,316,508,325,509,326,510,316,508,326,510,317,511,317,511,326,510,327,512,317,511,327,512,318,513,318,513,327,512,328,514,318,513,328,514,319,515,319,515,328,514,320,499,319,515,320,499,311,498,320,499,329,516,321,500,321,500,329,516,322,502,322,502,329,516,323,504,323,504,329,516,324,506,325,509,329,516,326,510,326,510,329,516,327,512,327,512,329,516,328,514,328,514,329,516,320,499,330,517,331,518,332,519,330,517,332,519,333,520,333,517,332,521,334,522,333,517,334,522,335,523,335,517,334,524,336,525,335,517,336,525,337,526,28,517,330,517,333,520,28,517,333,520,50,520,175,518,331,518,330,517,175,518,330,517,28,517,50,517,333,517,335,523,50,517,335,523,59,523,59,517,335,517,337,526,59,517,337,526,86,526,86,526,337,526,336,525,86,526,336,525,338,525,339,527,340,528,341,529,339,527,341,529,342,530,342,531,341,532,343,533,342,531,343,533,344,534,344,535,343,536,345,537,344,535,345,537,346,538,346,517,345,539,347,540,346,517,347,540,348,541,348,542,347,543,349,544,348,542,349,544,350,520,350,517,349,545,351,546,350,517,351,546,352,547,352,517,351,548,353,549,352,517,353,549,354,520,354,550,353,551,355,552,354,550,355,552,356,520,191,553,357,554,207,555,191,553,207,555,199,556,86,527,339,527,342,530,86,527,342,530,96,530,358,528,340,528,339,527,358,528,339,527,86,527,96,531,342,531,344,534,96,531,344,534,97,534,97,535,344,535,346,538,97,535,346,538,98,538,98,517,346,517,348,541,98,517,348,541,99,541,99,542,348,542,350,520,99,542,350,520,100,520,100,517,350,517,352,547,100,517,352,547,101,547,101,517,352,517,354,520,101,517,354,520,183,520,183,550,354,550,356,520,183,550,356,520,191,520,191,520,356,520,355,552,191,520,355,552,357,552,359,0,360,3,361,2,359,0,361,2,362,1,362,1,361,2,363,5,362,1,363,5,364,4,365,6,366,9,367,8,365,6,367,8,368,7,368,7,367,8,369,11,368,7,369,11,370,10,371,12,372,15,373,14,371,12,373,14,374,13,374,13,373,14,375,17,374,13,375,17,376,16,377,18,378,21,379,20,377,18,379,20,380,19,380,19,379,20,381,23,380,19,381,23,382,22,378,24,383,27,384,26,378,24,384,26,379,25,379,25,384,26,385,29,379,25,385,29,381,28,386,30,387,33,388,32,386,30,388,32,389,31,390,34,391,37,392,36,390,34,392,36,393,35,394,38,395,41,396,40,394,38,396,40,397,39,398,42,399,45,400,44,398,42,400,44,401,43,359,0,402,47,403,46,359,0,403,46,360,3,365,6,404,49,405,48,365,6,405,48,366,9,377,18,406,51,407,50,377,18,407,50,378,21,378,24,407,53,408,52,378,24,408,52,383,27,388,32,409,55,410,54,388,32,410,54,389,31,392,36,411,57,412,56,392,36,412,56,393,35,396,40,413,59,414,58,396,40,414,58,397,39,400,44,415,61,416,60,400,44,416,60,401,43,417,62,418,63,410,54,417,62,410,54,409,55,419,64,420,67,421,66,419,64,421,66,422,65,413,59,423,69,424,68,413,59,424,68,414,58,425,70,426,71,416,60,425,70,416,60,415,61,427,72,428,75,429,74,427,72,429,74,430,73,430,76,429,79,431,78,430,76,431,78,432,77,433,80,434,83,435,82,433,80,435,82,436,81,437,84,438,87,439,86,437,84,439,86,440,85,441,88,442,91,443,90,441,88,443,90,444,89,417,62,445,93,446,92,417,62,446,92,418,63,447,94,448,97,449,96,447,94,449,96,450,95,423,69,451,99,452,98,423,69,452,98,424,68,425,70,453,101,454,100,425,70,454,100,426,71,448,102,455,105,456,104,448,102,456,104,449,103,451,106,457,109,458,108,451,106,458,108,452,107,453,101,459,111,460,110,453,101,460,110,454,100,382,22,381,23,399,45,382,22,399,45,398,42,376,16,375,17,395,41,376,16,395,41,394,38,461,112,462,115,463,114,461,112,463,114,464,113,364,4,363,5,387,33,364,4,387,33,386,30,371,12,427,117,430,116,371,12,430,116,372,15,372,15,430,116,432,119,372,15,432,119,465,118,466,120,467,123,468,122,466,120,468,122,469,121,405,48,433,125,436,124,405,48,436,124,366,9,438,126,470,129,471,128,438,126,471,128,439,127,471,128,470,129,472,131,471,128,472,131,473,130,439,127,471,128,473,130,439,127,473,130,474,132,475,133,440,136,439,135,475,133,439,135,474,134,476,137,477,140,478,139,476,137,478,139,479,138,480,141,443,90,442,91,480,141,442,91,481,142,482,143,444,146,443,145,482,143,443,145,480,144,483,147,467,123,466,120,483,147,466,120,484,148,485,149,468,122,467,123,485,149,467,123,483,147,363,150,486,153,487,152,363,150,487,152,387,151,390,34,488,155,489,154,390,34,489,154,391,37,391,37,489,154,490,156,391,37,490,156,369,11,369,11,490,156,491,157,369,11,491,157,370,10,486,153,492,159,493,158,486,153,493,158,487,152,488,155,464,113,463,114,488,155,463,114,489,154,489,154,463,114,462,115,489,154,462,115,490,156,490,156,462,115,461,112,490,156,461,112,491,157,411,57,494,161,495,160,411,57,495,160,412,56,496,162,497,165,417,164,496,162,417,164,409,163,450,166,498,169,499,168,450,166,499,168,447,167,499,170,494,161,411,57,499,170,411,57,447,171,494,161,422,65,421,66,494,161,421,66,495,160,500,172,501,173,497,165,500,172,497,165,496,162,498,169,420,175,419,174,498,169,419,174,499,168,419,64,422,65,494,161,419,64,494,161,499,170,502,176,437,84,440,85,502,176,440,85,503,177,504,178,503,177,440,85,504,178,440,85,475,179,360,180,403,181,404,49,360,180,404,49,365,6,360,180,365,6,368,7,360,180,368,7,361,182,361,182,368,7,370,10,361,182,370,10,363,150,491,157,486,153,363,150,491,157,363,150,370,10,461,112,492,159,486,153,461,112,486,153,491,157,492,159,461,112,464,113,492,159,464,113,493,158,487,152,493,158,464,113,487,152,464,113,488,155,387,151,487,152,488,155,387,151,488,155,390,34,387,151,390,34,393,35,387,151,393,35,388,183,412,56,409,184,388,183,412,56,388,183,393,35,495,160,496,185,409,184,495,160,409,184,412,56,421,66,500,186,496,185,421,66,496,185,495,160,421,66,420,67,501,187,421,66,501,187,500,186,497,188,501,189,420,175,497,188,420,175,498,169,417,190,497,188,498,169,417,190,498,169,450,166,449,96,445,192,417,191,449,96,417,191,450,95,456,104,446,92,445,93,456,104,445,93,449,103,469,193,441,88,444,89,469,193,444,89,466,194,484,195,466,196,444,146,484,195,444,146,482,143,372,15,465,118,406,51,372,15,406,51,377,18,372,15,377,18,380,19,372,15,380,19,373,14,373,14,380,19,382,22,373,14,382,22,375,17,375,17,382,22,398,42,375,17,398,42,395,41,395,41,398,42,401,43,395,41,401,43,396,40,416,60,413,59,396,40,416,60);
    }
    private static void method6(){
        MESH_1.getFaces().addAll(396,40,401,43,416,60,426,71,423,69,416,60,423,69,413,59,454,100,451,99,423,69,454,100,423,69,426,71,460,197,457,109,451,106,460,197,451,106,454,198,381,28,385,29,505,200,381,28,505,200,399,199,385,29,148,202,147,201,385,29,147,201,505,200,384,26,149,203,148,202,384,26,148,202,385,29,383,27,150,204,149,203,383,27,149,203,384,26,408,52,151,205,150,204,408,52,150,204,383,27,442,91,153,207,152,206,442,91,152,206,481,142,154,208,153,207,442,91,154,208,442,91,441,88,155,209,154,208,441,88,155,209,441,88,469,193,468,122,156,211,155,210,468,122,155,210,469,121,157,212,156,211,468,122,157,212,468,122,485,149,429,79,159,214,158,213,429,79,158,213,431,78,428,75,160,216,159,215,428,75,159,215,429,74,434,83,162,218,161,217,434,83,161,217,435,82,470,129,164,220,163,219,470,129,163,219,472,131,165,221,164,220,470,129,165,221,470,129,438,126,166,222,165,223,438,87,166,222,438,87,437,84,167,224,166,222,437,84,167,224,437,84,502,176,168,225,167,228,502,227,168,225,502,227,506,226,170,229,171,230,402,47,170,229,402,47,359,0,170,229,359,0,362,1,170,229,362,1,172,231,172,231,362,1,364,4,172,231,364,4,173,232,173,232,364,4,386,30,173,232,386,30,174,233,174,233,386,30,389,31,174,233,389,31,175,234,435,82,161,217,160,216,435,82,160,216,428,75,436,81,435,82,428,75,436,81,428,75,427,72,366,9,436,124,427,117,366,9,427,117,371,12,366,9,371,12,374,13,366,9,374,13,367,8,367,8,374,13,376,16,367,8,376,16,369,11,369,11,376,16,394,38,369,11,394,38,391,37,391,37,394,38,397,39,391,37,397,39,392,36,414,58,411,57,392,36,414,58,392,36,397,39,424,68,447,171,411,57,424,68,411,57,414,58,452,98,448,235,447,171,452,98,447,171,424,68,458,108,455,237,448,236,458,108,448,236,452,107,171,230,168,225,506,226,171,230,506,226,402,47,507,238,476,241,479,240,507,238,479,240,508,239,403,181,504,242,475,133,403,181,475,133,404,49,404,49,475,133,474,134,404,49,474,134,405,48,473,130,433,80,405,243,473,130,405,243,474,132,472,131,434,83,433,80,472,131,433,80,473,130,163,219,162,218,434,83,163,219,434,83,472,131,158,213,157,212,485,149,158,213,485,149,431,78,431,78,485,149,483,147,431,78,483,147,432,77,432,77,483,147,484,148,432,77,484,148,465,244,465,118,484,195,482,143,465,118,482,143,406,51,406,51,482,143,480,144,406,51,480,144,407,50,407,53,480,141,481,142,407,53,481,142,408,52,152,206,151,205,408,52,152,206,408,52,481,142,504,245,479,138,478,139,504,245,478,139,503,246,503,246,478,139,477,140,503,246,477,140,502,227,502,227,477,140,476,137,502,227,476,137,506,226,402,247,507,238,508,239,402,247,508,239,403,248,403,248,508,239,479,240,403,248,479,240,504,249,506,250,476,241,507,238,506,250,507,238,402,247,399,45,509,252,510,251,399,45,510,251,400,44,400,44,510,251,511,253,400,44,511,253,415,61,415,61,511,253,512,254,415,61,512,254,425,70,425,70,512,254,513,255,425,70,513,255,453,101,453,101,513,255,514,256,453,101,514,256,459,111,505,257,515,260,509,259,505,257,509,259,399,258,147,261,185,262,515,260,147,261,515,260,505,257,509,252,516,264,517,263,509,252,517,263,510,251,510,251,517,263,518,265,510,251,518,265,511,253,511,253,518,265,519,266,511,253,519,266,512,254,512,254,519,266,520,267,512,254,520,267,513,255,513,255,520,267,521,268,513,255,521,268,514,256,515,260,522,270,516,269,515,260,516,269,509,259,185,262,193,271,522,270,185,262,522,270,515,260,516,264,523,273,524,272,516,264,524,272,517,263,517,263,524,272,525,274,517,263,525,274,518,265,518,265,525,274,526,275,518,265,526,275,519,266,519,266,526,275,527,276,519,266,527,276,520,267,520,267,527,276,528,277,520,267,528,277,521,268,522,270,529,279,523,278,522,270,523,278,516,269,193,271,201,280,529,279,193,271,529,279,522,270,525,281,524,284,530,283,525,281,530,283,531,282,524,272,523,273,532,286,524,272,532,286,530,285,523,273,529,288,533,287,523,273,533,287,532,286,529,279,201,280,206,290,529,279,206,290,533,289,207,291,528,294,534,293,207,291,534,293,208,292,528,277,527,276,535,296,528,277,535,296,534,295,527,297,526,300,536,299,527,297,536,299,535,298,526,300,525,281,531,282,526,300,531,282,536,299,531,282,530,283,537,302,531,282,537,302,538,301,530,283,532,304,539,303,530,283,539,303,537,302,532,304,533,306,540,305,532,304,540,305,539,303,533,289,206,290,216,308,533,289,216,308,540,307,208,309,534,312,541,311,208,309,541,311,217,310,534,312,535,298,542,313,534,312,542,313,541,311,535,298,536,299,543,314,535,298,543,314,542,313,536,299,531,282,538,301,536,299,538,301,543,314,538,315,537,318,544,317,538,315,544,317,545,316,537,319,539,322,546,321,537,319,546,321,544,320,539,322,540,307,547,323,539,322,547,323,546,321,540,307,216,308,225,324,540,307,225,324,547,323,217,325,541,328,548,327,217,325,548,327,226,326,541,329,542,332,549,331,541,329,549,331,548,330,542,332,543,334,550,333,542,332,550,333,549,331,543,334,538,315,545,316,543,334,545,316,550,333,545,316,544,317,551,336,545,316,551,336,552,335,544,337,546,340,553,339,544,337,553,339,551,338,546,340,547,342,554,341,546,340,554,341,553,339,547,323,225,324,234,344,547,323,234,344,554,343,226,326,548,327,555,346,226,326,555,346,235,345,548,347,549,350,556,349,548,347,556,349,555,348,549,350,550,352,557,351,549,350,557,351,556,349,550,333,545,316,552,335,550,333,552,335,557,353,552,335,551,336,558,355,552,335,558,355,559,354,551,338,553,339,560,357,551,338,560,357,558,356,553,339,554,341,561,358,553,339,561,358,560,357,554,343,234,344,243,360,554,343,243,360,561,359,235,345,555,346,562,362,235,345,562,362,244,361,555,348,556,349,563,364,555,348,563,364,562,363,556,349,557,351,564,365,556,349,564,365,563,364,557,353,552,335,559,354,557,353,559,354,564,366,559,354,558,355,565,368,559,354,565,368,566,367,558,369,560,372,567,371,558,369,567,371,565,370,560,372,561,359,568,373,560,372,568,373,567,371,561,359,243,360,252,374,561,359,252,374,568,373,244,361,562,362,569,376,244,361,569,376,253,375,562,377,563,380,570,379,562,377,570,379,569,378,563,380,564,366,571,381,563,380,571,381,570,379,564,366,559,354,566,367,564,366,566,367,571,381,566,382,565,385,572,384,566,382,572,384,573,383,565,385,567,387,574,386,565,385,574,386,572,384,567,387,568,389,575,388,567,387,575,388,574,386,568,389,252,391,261,390,568,389,261,390,575,388,253,392,569,395,576,394,253,392,576,394,262,393,569,395,570,397,577,396,569,395,577,396,576,394,570,397,571,399,578,398,570,397,578,398,577,396,571,399,566,382,573,383,571,399,573,383,578,398,573,383,572,384,579,401,573,383,579,401,580,400,572,384,574,386,581,402,572,384,581,402,579,401,574,386,575,388,582,403,574,386,582,403,581,402,575,388,261,390,270,404,575,388,270,404,582,403,262,393,576,394,583,406,262,393,583,406,271,405,576,394,577,396,584,407,576,394,584,407,583,406,577,396,578,398,585,408,577,396,585,408,584,407,578,398,573,383,580,400,578,398,580,400,585,408,580,409,579,412,586,411,580,409,586,411,587,410,579,412,581,414,588,413,579,412,588,413,586,411,581,414,582,416,589,415,581,414,589,415,588,413,582,417,270,420,279,419,582,417,279,419,589,418,271,421,583,424,590,423,271,421,590,423,280,422,583,425,584,428,591,427,583,425,591,427,590,426,584,428,585,430,592,429,584,428,592,429,591,427,585,430,580,409,587,410,585,430,587,410,592,429,587,431,586,434,593,433,587,431,593,433,594,432,586,434,588,436,595,435,586,434,595,435,593,433,588,436,589,438,596,437,588,436,596,437,595,435,589,438,279,440,288,439,589,438,288,439,596,437,280,441,590,444,597,443,280,441,597,443,289,442,590,444,591,446,598,445,590,444,598,445,597,443,591,446,592,448,599,447,591,446,599,447,598,445,592,448,587,431,594,432,592,448,594,432,599,447,594,449,593,452,600,451,594,449,600,451,601,450,593,452,595,454,602,453,593,452,602,453,600,451,595,454,596,456,603,455,595,454,603,455,602,453,596,456,288,458,297,457,596,456,297,457,603,455,289,459,597,462,604,461,289,459,604,461,298,460,597,462,598,464,605,463,597,462,605,463,604,461,598,464,599,466,606,465,598,464,606,465,605,463,599,466,594,449,601,450,599,466,601,450,606,465,601,450,600,451,607,468,601,450,607,468,608,467,600,451,602,453,609,469,600,451,609,469,607,468,602,453,603,455,610,470,602,453,610,470,609,469,603,455,297,457,306,471,603,455,306,471,610,470,298,460,604,461,611,473,298,460,611,473,307,472,604,461,605,463,612,474,604,461,612,474,611,473,605,463,606,465,613,475,605,463,613,475,612,474,606,465,601,450,608,467,606,465,608,467,613,475,608,476,607,479,614,478,608,476,614,478,615,477,607,479,609,481,616,480,607,479,616,480,614,478,609,481,610,483,617,482,609,481,617,482,616,480,610,484,306,487,315,486,610,484,315,486,617,485,307,488,611,491,618,490,307,488,618,490,316,489,611,492,612,495,619,494,611,492,619,494,618,493,612,495,613,497,620,496,612,495,620,496,619,494,613,497,608,476,615,477,613,497,615,477,620,496,615,498,614,501,621,500,615,498,621,500,622,499,614,501,616,503,623,502,614,501,623,502,621,500,616,503,617,505,624,504,616,503,624,504,623,502,617,505,315,507,324,506,617,505,324,506,624,504,316,508,618,511,625,510,316,508,625,510,325,509,618,511,619,513,626,512,618,511,626,512,625,510,619,513,620,515,627,514,619,513,627,514,626,512,620,515,615,498,622,499,620,515,622,499,627,514,622,499,621,500,329,516,621,500,623,502,329,516,623,502,624,504,329,516,624,504,324,506,329,516,325,509,625,510,329,516,625,510,626,512,329,516,626,512,627,514,329,516,627,514,622,499,329,516,628,517,629,520,332,519,628,517,332,519,331,518,629,517,630,523,334,522,629,517,334,522,332,521,630,517,631,526,336,525,630,517,336,525,334,524,389,517,410,520,629,520,389,517,629,520,628,517,175,518,389,517,628,517,175,518,628,517,331,518,410,517,418,523,630,523,410,517,630,523,629,517,418,517,446,526,631,526,418,517,631,526,630,517,446,526,338,525,336,525,446,526,336,525,631,526,632,527,633,530,341,529,632,527,341,529,340,528,633,531,634,534,343,533,633,531,343,533,341,532,634,535,635,538,345,537,634,535,345,537,343,536,635,517,636,541,347,540,635,517,347,540,345,539,636,542,637,520,349,544,636,542,349,544,347,543,637,517,638,547,351,546,637,517,351,546,349,545,638,517,639,520,353,549,638,517,353,549,351,548,639,550,640,520,355,552,639,550,355,552,353,551,521,553,528,556,207,555,521,553,207,555,357,554,446,527,456,530,633,530,446,527,633,530,632,527,358,528,446,527,632,527,358,528,632,527,340,528,456,531,455,534,634,534,456,531,634,534,633,531,455,535,458,538,635,538,455,535,635,538,634,535,458,517,457,541,636,541,458,517,636,541,635,517,457,542,460,520,637,520,457,542,637,520,636,542,460,517,459,547,638,547,460,517,638,547,637,517,459,517,514,520,639,520,459,517,639,520,638,517,514,550,521,520,640,520,514,550,640,520,639,550,521,520,357,552,355,552,521,520,355,552,640,520);
    }
    private static void method7(){
        MESH_1.getFaceSmoothingGroups().ensureCapacity(1276);
        MESH_1.getFaceSmoothingGroups().addAll(128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,16,16,16,16,16,16,1024,1024,2048,2048,1024,1024,1024,1024,16,16,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,512,512,256,256,4,4,256,256,256,256,256,256,256,256,256,256,256,256,256,256,1,1,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,16,16,16,16,16,16,32,32,64,64,32,32,32,32,16,16,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8,8,2,2,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1);
        NODE_3 = MESHVIEWS[2];
        MESHVIEWS[2].setId("hat_queen");
        MESHVIEWS[2].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_2 = new PhongMaterial();
        MATERIAL_2.setDiffuseColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_2.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_2.setSpecularPower(18.0);
        MESHVIEWS[2].setMaterial(MATERIAL_2);
        MESH_2 = new TriangleMesh();
        MESHVIEWS[2].setMesh(MESH_2);
        MESH_2.getPoints().ensureCapacity(1638);
        MESH_2.getPoints().addAll(0.0f,64.04261f,-1.0E-5f,0.976638f,63.763863f,0.404527f,1.057106f,63.763863f,-1.0E-5f,0.747486f,63.763863f,0.747476f,0.404537f,63.763863f,0.976628f,-0.0f,63.763863f,1.057095f,-0.404537f,63.763863f,0.976628f,-0.747486f,63.763863f,0.747476f,-0.976638f,63.763863f,0.404527f,-1.057106f,63.763863f,-1.0E-5f,-0.976638f,63.763863f,-0.404547f,-0.747486f,63.763863f,-0.747496f,-0.404537f,63.763863f,-0.976648f,0.0f,63.763863f,-1.057116f,0.404537f,63.763863f,-0.976648f,0.747486f,63.763863f,-0.747496f,0.976638f,63.763863f,-0.404547f,1.49378f,63.03086f,0.618734f,1.616855f,63.03086f,-1.0E-5f,1.143289f,63.03086f,1.143279f,0.618744f,63.03086f,1.49377f,-0.0f,63.03086f,1.616845f,-0.618744f,63.03086f,1.49377f,-1.143289f,63.03086f,1.143279f,-1.49378f,63.03086f,0.618734f,-1.616855f,63.03086f,-1.0E-5f,-1.49378f,63.03086f,-0.618754f,-1.143289f,63.03086f,-1.143299f,-0.618744f,63.03086f,-1.49379f,0.0f,63.03086f,-1.616865f,0.618744f,63.03086f,-1.49379f,1.143289f,63.03086f,-1.143299f,1.49378f,63.03086f,-0.618754f,1.49378f,62.1055f,0.618734f,1.616855f,62.1055f,-1.0E-5f,1.143289f,62.1055f,1.143279f,0.618744f,62.1055f,1.49377f,-0.0f,62.1055f,1.616845f,-0.618744f,62.1055f,1.49377f,-1.143289f,62.1055f,1.143279f,-1.49378f,62.1055f,0.618734f,-1.616855f,62.1055f,-1.0E-5f,-1.49378f,62.1055f,-0.618754f,-1.143289f,62.1055f,-1.143299f,-0.618744f,62.1055f,-1.49379f,0.0f,62.1055f,-1.616865f,0.618744f,62.1055f,-1.49379f,1.143289f,62.1055f,-1.143299f,1.49378f,62.1055f,-0.618754f,1.304041f,61.302464f,0.540141f,1.411484f,61.302464f,-1.0E-5f,0.99807f,61.302464f,0.99806f,0.540151f,61.302464f,1.304031f,-0.0f,61.302464f,1.411474f,-0.540151f,61.302464f,1.304031f,-0.99807f,61.302464f,0.99806f,-1.304041f,61.302464f,0.540141f,-1.411484f,61.302464f,-1.0E-5f,-1.304041f,61.302464f,-0.540161f,-0.99807f,61.302464f,-0.99808f,-0.540151f,61.302464f,-1.304051f,0.0f,61.302464f,-1.411494f,0.540151f,61.302464f,-1.304051f,0.99807f,61.302464f,-0.99808f,1.304041f,61.302464f,-0.540161f,1.108527f,60.775394f,0.349074f,1.199861f,60.775394f,-1.0E-5f,0.84843f,60.775394f,0.645014f,0.459167f,60.775394f,0.842754f,-0.0f,60.775394f,0.912191f,-0.459167f,60.775394f,0.842754f,-0.84843f,60.775394f,0.645014f,-1.108527f,60.775394f,0.349074f,-1.199861f,60.775394f,-1.0E-5f,-1.108527f,60.775394f,-0.349094f,-0.84843f,60.775394f,-0.645034f,-0.459167f,60.775394f,-0.842774f,0.0f,60.775394f,-0.912211f,0.459167f,60.775394f,-0.842774f,0.84843f,60.775394f,-0.645034f,1.108527f,60.775394f,-0.349094f,2.132857f,60.414413f,0.883448f,2.308588f,60.414413f,-1.0E-5f,1.632418f,60.414413f,1.632408f,0.883458f,60.414413f,2.132847f,-0.0f,60.414413f,2.308578f,-0.883458f,60.414413f,2.132847f,-1.632418f,60.414413f,1.632408f,-2.132857f,60.414413f,0.883448f,-2.308588f,60.414413f,-1.0E-5f,-2.132857f,60.414413f,-0.883469f,-1.632418f,60.414413f,-1.632428f,-0.883458f,60.414413f,-2.132867f,0.0f,60.414413f,-2.308598f,0.883458f,60.414413f,-2.132867f,1.632418f,60.414413f,-1.632428f,2.132857f,60.414413f,-0.883469f,3.622123f,59.305683f,1.500322f,3.920557f,59.305683f,-1.0E-5f,2.772253f,59.305683f,2.772243f,1.500332f,59.305683f,3.622112f,-0.0f,59.305683f,3.920547f,-1.500332f,59.305683f,3.622112f,-2.772253f,59.305683f,2.772243f,-3.622123f,59.305683f,1.500322f,-3.920557f,59.305683f,-1.0E-5f,-3.622123f,59.305683f,-1.500342f,-2.772253f,59.305683f,-2.772263f,-1.500332f,59.305683f,-3.622133f,0.0f,59.305683f,-3.920567f,1.500332f,59.305683f,-3.622133f,2.772253f,59.305683f,-2.772263f,3.622123f,59.305683f,-1.500342f,4.470391f,57.516193f,1.851686f,4.838715f,57.516193f,-1.0E-5f,3.421488f,57.516193f,3.421478f,1.851696f,57.516193f,4.470381f,-0.0f,57.516193f,4.838705f,-1.851696f,57.516193f,4.470381f,-3.421488f,57.516193f,3.421478f,-4.470391f,57.516193f,1.851686f,-4.838715f,57.516193f,-1.0E-5f,-4.470391f,57.516193f,-1.851706f,-3.421488f,57.516193f,-3.421498f,-1.851696f,57.516193f,-4.470401f,0.0f,57.516193f,-4.838725f,1.851696f,57.516193f,-4.470401f,3.421488f,57.516193f,-3.421498f,4.470391f,57.516193f,-1.851706f,4.779859f,55.453876f,1.979873f,5.173683f,55.453876f,-1.0E-5f,3.658346f,55.453876f,3.658336f,1.979883f,55.453876f,4.779849f,-0.0f,55.453876f,5.173673f,-1.979883f,55.453876f,4.779849f,-3.658346f,55.453876f,3.658336f,-4.779859f,55.453876f,1.979873f,-5.173683f,55.453876f,-1.0E-5f,-4.779859f,55.453876f,-1.979893f,-3.658346f,55.453876f,-3.658356f,-1.979883f,55.453876f,-4.779869f,0.0f,55.453876f,-5.173693f,1.979883f,55.453876f,-4.779869f,3.658346f,55.453876f,-3.658356f,4.779859f,55.453876f,-1.979893f,4.742604f,55.276245f,1.964441f,5.133356f,55.276245f,-1.0E-5f,3.629831f,55.276245f,3.629821f,1.964451f,55.276245f,4.742594f,-0.0f,55.276245f,5.133346f,-1.964451f,55.276245f,4.742594f,-3.629831f,55.276245f,3.629821f,-4.742604f,55.276245f,1.964441f,-5.133356f,55.276245f,-1.0E-5f,-4.742604f,55.276245f,-1.964461f,-3.629831f,55.276245f,-3.629841f,-1.964451f,55.276245f,-4.742614f,0.0f,55.276245f,-5.133366f,1.964451f,55.276245f,-4.742614f,3.629831f,55.276245f,-3.629841f,4.742604f,55.276245f,-1.964461f,8.732901f,54.38149f,-1.0E-5f,8.068149f,54.38149f,3.341926f,7.874128f,53.467155f,3.26156f,8.522895f,53.467155f,-1.0E-5f,6.175093f,54.38149f,6.175083f,6.026597f,53.467155f,6.026587f,3.341937f,54.38149f,8.068139f,3.26157f,53.467155f,7.874118f,-0.0f,54.38149f,8.732891f,-0.0f,53.467155f,8.522885f,-3.341937f,54.38149f,8.068139f,-3.26157f,53.467155f,7.874118f,-6.175093f,54.38149f,6.175083f,-6.026597f,53.467155f,6.026587f,-8.068149f,54.38149f,3.341927f,-7.874128f,53.467155f,3.26156f,-8.732901f,54.38149f,-1.0E-5f,-8.522895f,53.467155f,-1.0E-5f,-8.068149f,54.38149f,-3.341946f,-7.874128f,53.467155f,-3.261581f,-6.175093f,54.38149f,-6.175103f,-6.026597f,53.467155f,-6.026607f,-3.341937f,54.38149f,-8.068159f,-3.26157f,53.467155f,-7.874138f,0.0f,54.38149f,-8.732911f,0.0f,53.467155f,-8.522905f,3.341936f,54.38149f,-8.068159f,3.26157f,53.467155f,-7.874138f,6.175093f,54.38149f,-6.175103f,6.026597f,53.467155f,-6.026607f,8.068149f,54.38149f,-3.341947f,7.874128f,53.467155f,-3.261581f,5.371045f,45.644566f,2.22475f,5.813577f,45.644566f,-1.0E-5f,4.11082f,45.644566f,4.11081f,2.22476f,45.644566f,5.371035f,-0.0f,45.644566f,5.813567f,-2.22476f,45.644566f,5.371035f,-4.11082f,45.644566f,4.11081f,-5.371045f,45.644566f,2.22475f,-5.813577f,45.644566f,-1.0E-5f,-5.371045f,45.644566f,-2.22477f,-4.11082f,45.644566f,-4.11083f,-2.22476f,45.644566f,-5.371055f,0.0f,45.644566f,-5.813587f,2.22476f,45.644566f,-5.371055f,4.11082f,45.644566f,-4.11083f,5.371045f,45.644566f,-2.22477f,5.051063f,43.170963f,2.092209f,5.467231f,43.170963f,-1.0E-5f,3.865916f,43.170963f,3.865906f,2.092219f,43.170963f,5.051053f,-0.0f,43.170963f,5.467221f,-2.092219f,43.170963f,5.051053f,-3.865916f,43.170963f,3.865906f,-5.051063f,43.170963f,2.092209f,-5.467231f,43.170963f,-1.0E-5f,-5.051063f,43.170963f,-2.092229f,-3.865916f,43.170963f,-3.865926f,-2.092219f,43.170963f,-5.051074f,0.0f,43.170963f,-5.467241f,2.092219f,43.170963f,-5.051074f,3.865916f,43.170963f,-3.865926f,5.051063f,43.170963f,-2.092229f,5.281597f,42.84199f,2.187699f,5.716759f,42.84199f,-1.0E-5f,4.042359f,42.84199f,4.042349f,2.187709f,42.84199f,5.281587f,-0.0f,42.84199f,5.716749f,-2.187709f,42.84199f,5.281587f,-4.042359f,42.84199f,4.042349f,-5.281597f,42.84199f,2.187699f,-5.716759f,42.84199f,-1.0E-5f,-5.281597f,42.84199f,-2.187719f,-4.042359f,42.84199f,-4.042369f,-2.187709f,42.84199f,-5.281607f,0.0f,42.84199f,-5.716769f,2.187709f,42.84199f,-5.281607f,4.042359f,42.84199f,-4.042369f,5.281597f,42.84199f,-2.187719f,5.772262f,42.44148f,2.390939f,6.247852f,42.44148f,-1.0E-5f,4.417898f,42.44148f,4.417888f,2.390949f,42.44148f,5.772252f,-0.0f,42.44148f,6.247842f,-2.390949f,42.44148f,5.772252f,-4.417898f,42.44148f,4.417888f,-5.772262f,42.44148f,2.390939f,-6.247852f,42.44148f,-1.0E-5f,-5.772262f,42.44148f,-2.390959f,-4.417898f,42.44148f,-4.417908f,-2.390949f,42.44148f,-5.772272f,0.0f,42.44148f,-6.247862f,2.390949f,42.44148f,-5.772272f,4.417898f,42.44148f,-4.417908f,5.772262f,42.44148f,-2.390959f,5.772262f,41.81799f,2.390939f,6.247852f,41.81799f,-1.0E-5f,4.417898f,41.81799f,4.417888f,2.390949f,41.81799f,5.772252f,-0.0f,41.81799f,6.247842f,-2.390949f,41.81799f,5.772252f,-4.417898f,41.81799f,4.417888f,-5.772262f,41.81799f,2.390939f,-6.247852f,41.81799f,-1.0E-5f,-5.772262f,41.81799f,-2.390959f,-4.417898f,41.81799f,-4.417908f,-2.390949f,41.81799f,-5.772272f,0.0f,41.81799f,-6.247862f,2.390949f,41.81799f,-5.772272f,4.417898f,41.81799f,-4.417908f,5.772262f,41.81799f,-2.390959f,5.233013f,41.36831f,2.167575f,5.664173f,41.36831f,-1.0E-5f,4.005175f,41.36831f,4.005165f,2.167585f,41.36831f,5.233003f,-0.0f,41.36831f,5.664163f,-2.167585f,41.36831f,5.233003f,-4.005175f,41.36831f,4.005165f,-5.233013f,41.36831f,2.167575f,-5.664173f,41.36831f,-1.0E-5f,-5.233013f,41.36831f,-2.167595f,-4.005175f,41.36831f,-4.005185f,-2.167585f,41.36831f,-5.233023f,0.0f,41.36831f,-5.664183f,2.167585f,41.36831f,-5.233023f,4.005175f,41.36831f,-4.005185f,5.233013f,41.36831f,-2.167595f,4.650011f,40.914864f,1.926088f,5.033136f,40.914864f,-1.0E-5f,3.558965f,40.914864f,3.558955f,1.926098f,40.914864f,4.650001f,-0.0f,40.914864f,5.033126f,-1.926098f,40.914864f,4.650001f,-3.558965f,40.914864f,3.558955f,-4.650011f,40.914864f,1.926088f,-5.033136f,40.914864f,-1.0E-5f,-4.650011f,40.914864f,-1.926108f,-3.558965f,40.914864f,-3.558975f,-1.926098f,40.914864f,-4.650021f,0.0f,40.914864f,-5.033146f,1.926098f,40.914864f,-4.650021f,3.558965f,40.914864f,-3.558975f,4.650011f,40.914864f,-1.926108f,5.299559f,39.535812f,2.195139f,5.736201f,39.535812f,-1.0E-5f,4.056106f,39.535812f,4.056096f,2.195149f,39.535812f,5.299549f,-0.0f,39.535812f,5.736191f,-2.195149f,39.535812f,5.299549f,-4.056106f,39.535812f,4.056096f,-5.299559f,39.535812f,2.195139f,-5.736201f,39.535812f,-1.0E-5f,-5.299559f,39.535812f,-2.195159f,-4.056106f,39.535812f,-4.056116f,-2.195149f,39.535812f,-5.299569f,0.0f,39.535812f,-5.736211f,2.195149f,39.535812f,-5.299569f,4.056106f,39.535812f,-4.056116f,5.299559f,39.535812f,-2.195159f,7.165766f,39.044273f,2.968147f,7.756169f,39.044273f,-1.0E-5f,5.48444f,39.044273f,5.48443f,2.968157f,39.044273f,7.165756f,-0.0f,39.044273f,7.756159f,-2.968157f,39.044273f,7.165756f,-5.48444f,39.044273f,5.48443f,-7.165766f,39.044273f,2.968147f,-7.756169f,39.044273f,-1.0E-5f,-7.165766f,39.044273f,-2.968167f,-5.48444f,39.044273f,-5.484451f,-2.968157f,39.044273f,-7.165776f,0.0f,39.044273f,-7.756179f,2.968157f,39.044273f,-7.165776f,5.48444f,39.044273f,-5.484451f,7.165766f,39.044273f,-2.968167f,7.505077f,38.61215f,3.108694f,8.123436f,38.61215f,-1.0E-5f,5.744136f,38.61215f,5.744126f,3.108704f,38.61215f,7.505067f,-0.0f,38.61215f,8.123426f,-3.108704f,38.61215f,7.505067f,-5.744136f,38.61215f,5.744126f,-7.505077f,38.61215f,3.108694f,-8.123436f,38.61215f,-1.0E-5f,-7.505077f,38.61215f,-3.108714f,-5.744136f,38.61215f,-5.744146f,-3.108704f,38.61215f,-7.505087f,0.0f,38.61215f,-8.123446f,3.108704f,38.61215f,-7.505087f,5.744136f,38.61215f,-5.744146f,7.505077f,38.61215f,-3.108714f,7.341044f,37.95238f,3.04075f,7.945887f,37.95238f,-1.0E-5f,5.618591f,37.95238f,5.618581f,3.04076f,37.95238f,7.341034f,-0.0f,37.95238f,7.945877f,-3.04076f,37.95238f,7.341034f,-5.618591f,37.95238f,5.618581f,-7.341044f,37.95238f,3.04075f,-7.945887f,37.95238f,-1.0E-5f,-7.341044f,37.95238f,-3.04077f,-5.618591f,37.95238f,-5.618601f,-3.04076f,37.95238f,-7.341054f,0.0f,37.95238f,-7.945897f,3.04076f,37.95238f,-7.341054f,5.618591f,37.95238f,-5.618601f,7.341044f,37.95238f,-3.04077f,6.374042f,37.42457f,2.640205f,6.899213f,37.42457f,-1.0E-5f,4.878481f,37.42457f,4.878471f,2.640215f,37.42457f,6.374032f,-0.0f,37.42457f,6.899203f,-2.640215f,37.42457f,6.374032f,-4.878481f,37.42457f,4.878471f,-6.374042f,37.42457f,2.640205f,-6.899213f,37.42457f,-1.0E-5f,-6.374042f,37.42457f,-2.640225f,-4.878481f,37.42457f,-4.878491f,-2.640215f,37.42457f,-6.374052f,0.0f,37.42457f,-6.899223f,2.640215f,37.42457f,-6.374052f,4.878481f,37.42457f,-4.878491f,6.374042f,37.42457f,-2.640225f,7.109215f,37.292614f,2.944723f,7.694959f,37.292614f,-1.0E-5f,5.441157f,37.292614f,5.441147f,2.944733f,37.292614f,7.109205f,-0.0f,37.292614f,7.694949f,-2.944733f,37.292614f,7.109205f,-5.441157f,37.292614f,5.441147f,-7.109215f,37.292614f,2.944723f,-7.694959f,37.292614f,-1.0E-5f,-7.109215f,37.292614f,-2.944743f,-5.441157f,37.292614f,-5.441167f,-2.944733f,37.292614f,-7.109225f,0.0f,37.292614f,-7.694969f,2.944733f,37.292614f,-7.109225f,5.441157f,37.292614f,-5.441167f,7.109215f,37.292614f,-2.944743f,8.070593f,36.632854f,3.34294f,8.735548f,36.632854f,-1.0E-5f,6.176965f,36.632854f,6.176955f,3.34295f,36.632854f,8.070583f,-0.0f,36.632854f,8.735538f,-3.34295f,36.632854f,8.070583f,-6.176965f,36.632854f,6.176955f,-8.070593f,36.632854f,3.34294f,-8.735548f,36.632854f,-1.0E-5f,-8.070593f,36.632854f,-3.34296f,-6.176965f,36.632854f,-6.176975f,-3.34295f,36.632854f,-8.070603f,0.0f,36.632854f,-8.735558f,3.34295f,36.632854f,-8.070603f,6.176965f,36.632854f,-6.176975f,8.070593f,36.632854f,-3.34296f,8.094185f,35.00001f,3.352711f,8.761082f,35.00001f,-1.0E-5f,6.195021f,35.00001f,6.195011f,3.352721f,35.00001f,8.094175f,-0.0f,35.00001f,8.761072f,-3.352721f,35.00001f,8.094175f,-6.195021f,35.00001f,6.195011f,-8.094185f,35.00001f,3.352711f,-8.761082f,35.00001f,-1.0E-5f,-8.094185f,35.00001f,-3.352731f,-6.195021f,35.00001f,-6.195031f,-3.352721f,35.00001f,-8.094195f,0.0f,35.00001f,-8.761092f,3.352721f,35.00001f,-8.094195f,6.195021f,35.00001f,-6.195031f,8.094185f,35.00001f,-3.352731f,7.992383f,34.999992f,3.310543f,8.650893f,34.999992f,-1.0E-5f,6.117106f,34.999992f,6.117095f,3.310553f,34.999992f,7.992373f,-0.0f,34.999992f,8.650883f,-3.310553f,34.999992f,7.992373f,-6.117106f,34.999992f,6.117095f,-7.992383f,34.999992f,3.310543f,-8.650893f,34.999992f,-1.0E-5f,-7.992383f,34.999992f,-3.310563f,-6.117106f,34.999992f,-6.117116f,-3.310553f,34.999992f,-7.992393f,0.0f,34.999992f,-8.650903f,3.310553f,34.999992f,-7.992393f,6.117106f,34.999992f,-6.117116f,7.992383f,34.999992f,-3.310563f,0.0f,34.999992f,-1.0E-5f,-0.0f,55.32802f,5.234932f,1.918539f,55.32799f,4.853333f,3.247242f,54.573544f,8.146733f,-0.0f,54.573544f,8.792649f,-1.918539f,55.32799f,4.853333f,-3.247242f,54.573544f,8.146733f,-0.489896f,60.30751f,10.217569f,-0.40129f,60.4327f,10.003667f,-0.0f,60.437298f,10.079601f,0.40129f,60.4327f,10.003667f,0.489896f,60.30751f,10.217569f,-0.0f,60.30751f,10.31501f,3.701662f,55.32802f,3.701652f,4.788443f,55.32799f,2.075209f,8.056763f,54.573544f,3.46446f,6.217349f,54.573544f,6.217339f,2.075219f,55.32799f,4.788433f,3.46447f,54.573544f,8.056753f,6.880856f,60.30751f,7.573663f,6.792254f,60.4327f,7.359756f,7.129705f,60.437298f,7.129695f,7.359766f,60.4327f,6.792244f,7.573673f,60.30751f,6.880846f,7.296163f,60.30751f,7.296153f,5.234942f,55.32802f,-1.0E-5f,4.853343f,55.32799f,-1.918549f,8.146743f,54.573544f,-3.247252f,8.792659f,54.573544f,-1.0E-5f,4.853343f,55.32799f,1.918529f,8.146743f,54.573544f,3.247232f,10.217579f,60.30751f,0.489886f,10.003677f,60.4327f,0.40128f,10.079611f,60.437298f,-1.0E-5f,10.003677f,60.4327f,-0.4013f,10.217579f,60.30751f,-0.489906f,10.31502f,60.30751f,-1.0E-5f,3.701662f,55.32802f,-3.701673f,2.075219f,55.32799f,-4.788453f,3.46447f,54.573544f,-8.056773f,6.217349f,54.573544f,-6.217359f,4.788443f,55.32799f,-2.075229f,8.056763f,54.573544f,-3.464481f,7.573673f,60.30751f,-6.880866f,7.359766f,60.4327f,-6.792264f,7.129705f,60.437298f,-7.129715f,6.792254f,60.4327f,-7.359776f,6.880856f,60.30751f,-7.573683f,7.296163f,60.30751f,-7.296173f,0.0f,55.32802f,-5.234952f,-1.918539f,55.32799f,-4.853353f,-3.247242f,54.573544f,-8.146753f,0.0f,54.573544f,-8.792669f,1.918539f,55.32799f,-4.853353f,3.247242f,54.573544f,-8.146753f,0.489896f,60.30751f,-10.217589f,0.40129f,60.4327f,-10.003687f,0.0f,60.437298f,-10.079621f,-0.40129f,60.4327f,-10.003687f,-0.489896f,60.30751f,-10.217589f,0.0f,60.30751f,-10.31503f,-3.701662f,55.32802f,-3.701673f,-4.788443f,55.32799f,-2.075229f,-8.056763f,54.573544f,-3.464481f,-6.217349f,54.573544f,-6.217359f,-2.075219f,55.32799f,-4.788453f,-3.46447f,54.573544f,-8.056773f,-6.880856f,60.30751f,-7.573683f,-6.792254f,60.4327f,-7.359776f,-7.129705f,60.437298f,-7.129715f,-7.359766f,60.4327f,-6.792264f,-7.573673f,60.30751f,-6.880866f,-7.296163f,60.30751f,-7.296173f,-5.234942f,55.32802f,-1.0E-5f,-4.853343f,55.32799f,1.918529f,-8.146743f,54.573544f,3.247232f,-8.792659f,54.573544f,-1.0E-5f,-4.853343f,55.32799f,-1.918549f,-8.146743f,54.573544f,-3.247252f,-10.217579f,60.30751f,-0.489906f,-10.003677f,60.4327f,-0.4013f,-10.079611f,60.437298f,-1.0E-5f,-10.003677f,60.4327f,0.40128f,-10.217579f,60.30751f,0.489886f,-10.31502f,60.30751f,-1.0E-5f,-3.701662f,55.32802f,3.701652f,-2.075219f,55.32799f,4.788433f,-3.46447f,54.573544f,8.056753f,-6.217349f,54.573544f,6.217339f,-4.788443f,55.32799f,2.075209f,-8.056763f,54.573544f,3.46446f,-7.573673f,60.30751f,6.880846f,-7.359766f,60.4327f,6.792244f,-7.129705f,60.437298f,7.129695f,-6.792254f,60.4327f,7.359756f,-6.880856f,60.30751f,7.573663f,-7.296163f,60.30751f,7.296153f);
    }
    private static void method8(){
        MESH_2.getTexCoords().ensureCapacity(1686);
        MESH_2.getTexCoords().addAll(0.389033f,0.05574298f,0.40401f,0.061945975f,0.405243f,0.05574298f,0.400495f,0.06720501f,0.395236f,0.070719f,0.389033f,0.071953f,0.382829f,0.070719f,0.37757f,0.06720501f,0.374056f,0.061945975f,0.372822f,0.05574298f,0.374056f,0.04953903f,0.37757f,0.044279993f,0.382829f,0.040766f,0.389033f,0.039532006f,0.395236f,0.040766f,0.400495f,0.044279993f,0.40401f,0.04953903f,0.860774f,0.049561024f,0.860774f,0.043357015f,0.850345f,0.040072978f,0.850345f,0.049561024f,0.860774f,0.038097978f,0.850345f,0.032028973f,0.363322f,0.07070303f,0.363322f,0.06544399f,0.352894f,0.06872898f,0.352894f,0.07677299f,0.363322f,0.059239984f,0.352894f,0.059239984f,0.363322f,0.053036988f,0.352894f,0.049751997f,0.363322f,0.04777801f,0.352894f,0.041707993f,0.949812f,0.07263702f,0.949812f,0.067377985f,0.939384f,0.070662975f,0.939384f,0.07870698f,0.949812f,0.061173975f,0.939384f,0.061173975f,0.949812f,0.05497098f,0.939384f,0.05168599f,0.949812f,0.049712002f,0.939384f,0.043641984f,0.130871f,0.056267023f,0.130871f,0.061526f,0.1413f,0.05824101f,0.1413f,0.050197005f,0.130871f,0.067729f,0.1413f,0.067729f,0.130871f,0.073933005f,0.1413f,0.077217996f,0.130871f,0.07919198f,0.1413f,0.085262f,0.860774f,0.06102401f,0.860774f,0.055764973f,0.850345f,0.05904901f,0.850345f,0.067093015f,0.83718f,0.040072978f,0.83718f,0.049561024f,0.83718f,0.032028973f,0.339728f,0.06872898f,0.339728f,0.07677299f,0.339728f,0.059239984f,0.339728f,0.049751997f,0.339728f,0.041707993f,0.926218f,0.070662975f,0.926218f,0.07870698f,0.926218f,0.061173975f,0.926218f,0.05168599f,0.926218f,0.043641984f,0.154466f,0.05824101f,0.154466f,0.050197005f,0.154466f,0.067729f,0.154466f,0.077217996f,0.154466f,0.085262f,0.83718f,0.05904901f,0.83718f,0.067093015f,0.825755f,0.041278005f,0.825755f,0.049561024f,0.825755f,0.03425598f,0.328303f,0.067524016f,0.328303f,0.07454598f,0.328303f,0.059239984f,0.328303f,0.050957024f,0.328303f,0.043935f,0.914793f,0.06945801f,0.914793f,0.07647997f,0.914793f,0.061173975f,0.914793f,0.052891016f,0.914793f,0.045868993f,0.165891f,0.059445977f,0.165891f,0.052424014f,0.165891f,0.067729f,0.165891f,0.07601303f,0.165891f,0.08303499f,0.825755f,0.057843983f,0.825755f,0.06486702f,0.265135f,0.06125599f,0.263487f,0.052972972f,0.605095f,0.069281995f,0.605095f,0.07463598f,0.258795f,0.04595101f,0.605095f,0.064743996f,0.251773f,0.04125899f,0.008929f,0.08773297f,0.008929f,0.09227097f,0.24349f,0.039610982f,0.008929f,0.08238f,0.235206f,0.04125899f,0.008929f,0.07702601f,0.228184f,0.04595101f,0.008929f,0.07248801f,0.223492f,0.052972972f,0.053447f,0.07805401f,0.053447f,0.082593024f,0.221844f,0.06125599f,0.053447f,0.07270098f,0.223492f,0.069540024f,0.053447f,0.067348f,0.228184f,0.07656199f,0.053447f,0.062810004f,0.235206f,0.081254005f,0.621463f,0.09536898f,0.621463f,0.09083098f,0.24349f,0.082901f,0.621463f,0.100722015f,0.251773f,0.081254005f,0.621463f,0.106076f,0.258795f,0.07656199f,0.621463f,0.110614f,0.263487f,0.069540024f,0.605095f,0.079989016f,0.605095f,0.084527016f,0.409716f,0.201352f,0.404363f,0.20028698f,0.396169f,0.22007102f,0.409716f,0.22276598f,0.399825f,0.19725502f,0.384683f,0.21239698f,0.396793f,0.19271702f,0.377009f,0.20091099f,0.395728f,0.18736303f,0.374314f,0.18736303f,0.396793f,0.18201f,0.377009f,0.17381603f,0.399825f,0.177472f,0.384683f,0.16232997f,0.404363f,0.17444003f,0.396169f,0.154656f,0.409716f,0.17337501f,0.409716f,0.15196103f,0.41507f,0.17444003f,0.423264f,0.154656f,0.419608f,0.177472f,0.43475f,0.16232997f,0.42264f,0.18201f,0.442424f,0.17381603f,0.423705f,0.18736303f,0.445119f,0.18736303f,0.42264f,0.19271702f,0.442424f,0.20091099f,0.419608f,0.19725502f,0.43475f,0.21239698f,0.41507f,0.20028698f,0.423264f,0.22007102f,0.386709f,0.24290901f,0.409716f,0.24748498f,0.367204f,0.22987598f,0.354171f,0.21037102f,0.349595f,0.18736303f,0.354171f,0.164356f,0.367204f,0.14485103f,0.386709f,0.131818f,0.409716f,0.12724203f,0.432724f,0.131818f,0.452229f,0.14485103f,0.465262f,0.164356f,0.469838f,0.18736303f,0.465262f,0.21037102f,0.452229f,0.22987598f,0.432724f,0.24290901f,0.108249f,0.19597399f,0.108249f,0.172966f,0.082789f,0.16757798f,0.082789f,0.19597399f,0.108249f,0.15346098f,0.082789f,0.14350599f,0.174059f,0.22880799f,0.174059f,0.20930302f,0.148599f,0.214692f,0.148599f,0.23876399f,0.174059f,0.18629599f,0.148599f,0.18629599f,0.174059f,0.163288f,0.148599f,0.15789998f,0.174059f,0.14378297f,0.148599f,0.13382697f,0.599892f,0.23267901f,0.599892f,0.213175f,0.574433f,0.21856302f,0.574433f,0.24263501f,0.599892f,0.19016701f,0.574433f,0.19016701f,0.599892f,0.16715902f,0.574433f,0.161771f,0.599892f,0.147654f,0.574433f,0.137698f,0.630258f,0.151725f,0.630258f,0.17123002f,0.655718f,0.165842f,0.655718f,0.14176899f,0.630258f,0.194237f,0.655718f,0.194237f,0.630258f,0.21724498f,0.655718f,0.222633f,0.630258f,0.23675f,0.655718f,0.24670601f,0.108249f,0.23848599f,0.108249f,0.21898198f,0.082789f,0.22437f,0.082789f,0.24844301f,0.053447f,0.16561198f,0.053447f,0.19597399f,0.053447f,0.13987303f,0.119258f,0.21665698f,0.119258f,0.24239701f,0.119258f,0.18629599f,0.119258f,0.15593398f,0.119258f,0.13019502f,0.545091f,0.220528f,0.545091f,0.24626797f,0.545091f,0.19016701f,0.545091f,0.159805f,0.545091f,0.13406599f,0.685059f,0.163876f,0.685059f,0.13813698f,0.685059f,0.194237f,0.685059f,0.224599f,0.685059f,0.25033802f,0.053447f,0.226336f,0.053447f,0.25207502f,0.906978f,0.51835096f,0.900939f,0.548712f,0.928987f,0.56033003f,0.937337f,0.51835096f,0.88374f,0.57445097f,0.905208f,0.595919f,0.858001f,0.59165f,0.869619f,0.619698f,0.82764f,0.59768903f,0.82764f,0.628048f,0.797278f,0.59165f,0.78566f,0.619698f,0.771539f,0.57445097f,0.750072f,0.595919f,0.754341f,0.548712f,0.726292f,0.56033003f,0.748301f,0.51835096f,0.717942f,0.51835096f,0.754341f,0.487989f,0.726292f,0.476371f,0.771539f,0.46225f,0.750072f,0.44078302f,0.797278f,0.44505203f,0.78566f,0.41700298f,0.82764f,0.439012f,0.82764f,0.40865302f,0.858001f,0.44505203f,0.869619f,0.41700298f,0.88374f,0.46225f,0.905208f,0.44078302f,0.900939f,0.487989f,0.928987f,0.476371f,0.554196f,0.567684f,0.502948f,0.567684f,0.50418f,0.580692f,0.554196f,0.580692f,0.459501f,0.567684f,0.461779f,0.580692f,0.958589f,0.734145f,0.915143f,0.734145f,0.91391f,0.747154f,0.956312f,0.747154f,0.863894f,0.734145f,0.863894f,0.747154f,0.812646f,0.734145f,0.813878f,0.747154f,0.769199f,0.734145f,0.771476f,0.747154f,0.377907f,0.567684f,0.33446f,0.567684f,0.333228f,0.580692f,0.375629f,0.580692f,0.283211f,0.567684f,0.283211f,0.580692f,0.231963f,0.567684f,0.233195f,0.580692f,0.188516f,0.567684f,0.190794f,0.580692f,0.594994f,0.889044f,0.638441f,0.889044f,0.639673f,0.876035f,0.597271f,0.876035f,0.689689f,0.889044f,0.689689f,0.876035f,0.740938f,0.889044f,0.739705f,0.876035f,0.784384f,0.889044f,0.782107f,0.876035f,0.648892f,0.567684f,0.605445f,0.567684f,0.604213f,0.580692f,0.646614f,0.580692f,0.52008f,0.69198704f,0.554196f,0.69198704f,0.491157f,0.69198704f,0.898011f,0.858449f,0.926934f,0.858449f,0.863894f,0.858449f,0.829777f,0.858449f,0.800855f,0.858449f,0.317328f,0.691988f,0.346251f,0.691988f,0.283211f,0.691988f,0.249095f,0.691988f,0.220172f,0.691988f,0.655573f,0.76474f,0.62665f,0.76474f,0.689689f,0.76474f,0.723806f,0.76474f,0.752729f,0.76474f,0.588313f,0.69198704f,0.617236f,0.69198704f,0.522112f,0.72718f,0.554196f,0.72718f,0.494913f,0.72718f,0.895978f,0.893642f,0.923178f,0.893642f,0.863894f,0.893642f,0.83181f,0.893642f,0.80461f,0.893642f,0.315296f,0.72718096f,0.342495f,0.72718096f,0.283211f,0.72718096f,0.251127f,0.72718096f,0.223928f,0.72718096f,0.657605f,0.729547f,0.630405f,0.729547f,0.689689f,0.729547f,0.721773f,0.729547f,0.748973f,0.729547f,0.586281f,0.72718f,0.61348f,0.72718f,0.520648f,0.731861f,0.554196f,0.731861f,0.492207f,0.731861f,0.897443f,0.898322f,0.925884f,0.898322f,0.863894f,0.898322f,0.830346f,0.898322f,0.801905f,0.898322f,0.31676f,0.731861f,0.345201f,0.731861f,0.283211f,0.731861f,0.249663f,0.731861f,0.221222f,0.731861f,0.656141f,0.72486603f,0.6277f,0.72486603f,0.689689f,0.72486603f,0.723238f,0.72486603f,0.751679f,0.72486603f,0.587745f,0.731861f,0.616186f,0.731861f,0.693728f,0.342211f,0.687055f,0.37576002f,0.694579f,0.37887698f,0.701872f,0.342211f,0.668051f,0.40420097f,0.67381f,0.40995997f,0.63961f,0.42320502f,0.642726f,0.43072897f,0.606061f,0.429878f,0.606061f,0.43802202f,0.572513f,0.42320502f,0.569396f,0.43072897f,0.544072f,0.40420097f,0.538313f,0.40995997f,0.525068f,0.37576002f,0.517544f,0.37887698f,0.518395f,0.342211f,0.51025f,0.342211f,0.525068f,0.308663f,0.517544f,0.305546f,0.544072f,0.280222f,0.538313f,0.274463f,0.572513f,0.261218f,0.569396f,0.253694f,0.606061f,0.25454497f,0.606061f,0.2464f,0.63961f,0.261218f,0.642726f,0.253694f,0.668051f,0.280222f,0.67381f,0.274463f,0.687055f,0.308663f,0.694579f,0.305546f,0.284912f,0.21551102f,0.284912f,0.178846f,0.276041f,0.178846f,0.276041f,0.21551102f,0.284912f,0.14776301f,0.276041f,0.14776301f,0.488151f,0.27358198f,0.488151f,0.24249798f,0.479281f,0.24249798f,0.479281f,0.27358198f,0.488151f,0.20583302f,0.479281f,0.20583302f,0.488151f,0.169168f,0.479281f,0.169168f,0.488151f,0.13808501f,0.479281f,0.13808501f,0.042962f,0.27164602f,0.042962f,0.24056298f,0.034091f,0.24056298f,0.034091f,0.27164602f,0.042962f,0.20389801f,0.034091f,0.20389801f,0.042962f,0.16723299f,0.034091f,0.16723299f,0.042962f,0.13614899f,0.034091f,0.13614899f,0.694133f,0.149535f,0.694133f,0.18061799f,0.703004f,0.18061799f,0.703004f,0.149535f,0.694133f,0.21728301f,0.703004f,0.21728301f,0.694133f,0.25394797f,0.703004f,0.25394797f,0.694133f,0.28503197f,0.703004f,0.28503197f,0.284912f,0.28326f,0.284912f,0.252177f,0.276041f,0.252177f,0.276041f,0.28326f,0.955437f,0.310948f,0.948144f,0.27428198f,0.939874f,0.277708f,0.946486f,0.310948f,0.927375f,0.24319899f,0.921046f,0.24952799f,0.896291f,0.22242999f,0.892866f,0.230699f,0.859626f,0.215137f,0.859626f,0.22408801f,0.822961f,0.22242999f,0.826386f,0.230699f,0.791878f,0.24319899f,0.798207f,0.24952799f,0.771109f,0.27428198f,0.779378f,0.277708f,0.763815f,0.310948f,0.772766f,0.310948f,0.771109f,0.34761298f,0.779378f,0.34418702f,0.791878f,0.37869602f,0.798207f,0.37236702f,0.822961f,0.39946502f,0.826386f,0.391196f,0.859626f,0.406758f,0.859626f,0.39780802f,0.896291f,0.39946502f,0.892866f,0.391196f,0.927375f,0.37869602f,0.921046f,0.37236702f,0.948144f,0.34761298f,0.939874f,0.34418702f,0.930934f,0.281411f,0.936809f,0.310948f,0.914203f,0.25637102f,0.889163f,0.23964f,0.859626f,0.233764f,0.83009f,0.23964f,0.80505f,0.25637102f,0.788318f,0.281411f,0.782443f,0.310948f,0.788318f,0.34048402f,0.80505f,0.365524f,0.83009f,0.38225597f,0.859626f,0.38813102f,0.889163f,0.38225597f,0.914203f,0.365524f,0.930934f,0.34048402f,0.975061f,0.20002198f,0.975061f,0.17048502f,0.955441f,0.16636002f,0.955441f,0.20002198f,0.975061f,0.14544499f,0.955441f,0.13782197f,0.313082f,0.26040602f,0.313082f,0.23536599f,0.293462f,0.239492f,0.293462f,0.26803f,0.313082f,0.20582998f,0.293462f,0.20582998f,0.313082f,0.17629302f,0.293462f,0.172167f,0.313082f,0.15125299f,0.293462f,0.14362901f,0.537613f,0.26234198f,0.537613f,0.237302f,0.517993f,0.24142802f,0.517993f,0.269965f,0.537613f,0.20776498f,0.517993f,0.20776498f,0.537613f,0.17822802f,0.517993f,0.17410201f,0.537613f,0.15318799f,0.517993f,0.14556497f,0.198617f,0.14916098f,0.198617f,0.17420101f,0.218237f,0.170075f,0.218237f,0.14153802f,0.198617f,0.20373797f,0.218237f,0.20373797f,0.198617f,0.233275f,0.218237f,0.23740101f,0.198617f,0.25831503f,0.218237f,0.265939f,0.975061f,0.25459898f,0.975061f,0.229559f,0.955441f,0.23368502f,0.955441f,0.262223f,0.473269f,0.37124598f,0.466573f,0.404908f,0.495191f,0.416762f,0.504245f,0.37124598f,0.447505f,0.433446f,0.469408f,0.45534903f,0.418967f,0.452514f,0.430821f,0.48113298f,0.385304f,0.45920998f,0.385304f,0.49018598f,0.351642f,0.452514f,0.339788f,0.48113298f,0.323104f,0.433446f,0.3012f,0.45534903f,0.304036f,0.404908f,0.275417f,0.416762f,0.29734f,0.37124598f,0.266363f,0.37124598f,0.304036f,0.337583f,0.275417f,0.325729f,0.323104f,0.30904502f,0.3012f,0.28714198f,0.351642f,0.289977f,0.339788f,0.26135802f,0.385304f,0.28328103f,0.385304f,0.25230497f,0.418967f,0.289977f,0.430821f,0.26135802f,0.447505f,0.30904502f,0.469408f,0.28714198f,0.466573f,0.337583f,0.495191f,0.325729f,0.266413f,0.23814303f,0.266413f,0.192626f,0.260265f,0.190471f,0.260265f,0.23814303f,0.473391f,0.459332f,0.500395f,0.418917f,0.432976f,0.486336f,0.024463f,0.26430398f,0.024463f,0.21878701f,0.018315f,0.21878701f,0.018315f,0.266459f,0.024463f,0.17326999f,0.018315f,0.17111498f,0.297218f,0.459332f,0.337632f,0.486336f,0.270214f,0.418917f,0.5103f,0.258497f,0.5103f,0.21297997f,0.504152f,0.21297997f,0.504152f,0.260652f,0.5103f,0.167463f,0.504152f,0.165308f,0.297218f,0.28315902f,0.270214f,0.323574f,0.337632f,0.256155f,0.227651f,0.15300697f,0.227651f,0.19852298f,0.233799f,0.19852298f,0.233799f,0.15085101f,0.227651f,0.24404001f,0.233799f,0.24619502f,0.473391f,0.28315902f,0.432976f,0.256155f,0.500395f,0.323574f,0.266413f,0.28366f,0.260265f,0.285815f,0.250879f,0.191513f,0.250879f,0.23814303f,0.260265f,0.15005702f,0.250879f,0.15198201f,0.018315f,0.30687302f,0.008929f,0.26541698f,0.008929f,0.30494797f,0.008929f,0.21878701f,0.008929f,0.17215699f,0.018315f,0.130701f,0.008929f,0.132626f,0.504152f,0.30106598f,0.494766f,0.25961f,0.494766f,0.299141f,0.494766f,0.21297997f,0.494766f,0.16635f,0.504152f,0.12489402f,0.494766f,0.12681901f,0.233799f,0.110436976f,0.243186f,0.15189302f,0.243186f,0.11236203f,0.243186f,0.19852298f,0.243186f,0.24515301f,0.233799f,0.28661f,0.243186f,0.284684f,0.260265f,0.32622898f,0.250879f,0.284773f,0.250879f,0.32430398f,0.252629f,0.37288702f,0.243354f,0.326257f,0.228525f,0.33240002f,0.236578f,0.37288702f,0.21694f,0.286726f,0.20559f,0.29807597f,0.177409f,0.26031202f,0.171266f,0.275141f,0.130779f,0.251037f,0.130779f,0.267088f,0.084149f,0.26031202f,0.090291f,0.275141f,0.044618f,0.286726f,0.055967f,0.29807597f,0.018204f,0.326257f,0.033033f,0.33240002f,0.008929f,0.37288702f,0.024979f,0.37288702f,0.018204f,0.41951698f,0.033033f,0.41337502f,0.044618f,0.45904797f,0.055967f,0.447699f,0.084149f,0.485462f,0.090291f,0.47063297f,0.130779f,0.49473703f,0.130779f,0.478687f,0.177409f,0.485462f,0.171266f,0.47063297f,0.21694f,0.45904797f,0.20559f,0.447699f,0.243354f,0.41951698f,0.228525f,0.41337502f,0.525479f,0.855145f,0.517425f,0.895633f,0.528699f,0.900303f,0.537681f,0.855145f,0.494491f,0.92995703f,0.503119f,0.938586f,0.460167f,0.952891f,0.464837f,0.964165f,0.419679f,0.960945f,0.419679f,0.973148f,0.379192f,0.952891f,0.374522f,0.964165f,0.344868f,0.92995703f,0.336239f,0.938586f,0.321933f,0.895633f,0.310659f,0.900303f,0.31388f,0.855145f,0.301677f,0.855145f,0.321933f,0.814658f,0.310659f,0.809988f,0.344868f,0.780334f,0.336239f,0.77170503f,0.379192f,0.75739896f,0.374522f,0.746126f,0.419679f,0.749346f,0.419679f,0.73714304f,0.460167f,0.75739896f,0.464837f,0.746126f,0.494491f,0.780334f,0.503119f,0.77170503f,0.517425f,0.814658f,0.528699f,0.809988f,0.543442f,0.90641f,0.553639f,0.855145f,0.514403f,0.949869f,0.470943f,0.978908f,0.419679f,0.989105f,0.368415f,0.978908f,0.324955f,0.949869f,0.295917f,0.90641f,0.28572f,0.855145f,0.295917f,0.803881f,0.324955f,0.760422f,0.368415f,0.73138297f,0.419679f,0.72118604f,0.470943f,0.73138297f,0.514403f,0.760422f,0.543442f,0.803881f,0.753706f,0.29640502f,0.753706f,0.24514103f,0.736717f,0.244991f,0.736717f,0.29640502f,0.753706f,0.20168197f,0.736717f,0.20140499f,0.98598f,0.656306f,0.98598f,0.612846f,0.96899f,0.612996f,0.96899f,0.656583f,0.98598f,0.56158197f,0.96899f,0.56158197f,0.98598f,0.51031804f,0.96899f,0.51016796f,0.98598f,0.46685803f,0.96899f,0.466581f,0.984044f,0.458875f,0.984044f,0.415415f,0.967054f,0.415565f,0.967054f,0.45915198f,0.984044f,0.364151f,0.967054f,0.364151f,0.984044f,0.312887f,0.967054f,0.312737f,0.984044f,0.269427f,0.967054f,0.26915002f,0.711554f,0.18683499f,0.711554f,0.23029399f,0.728543f,0.23014498f,0.728543f,0.18655801f,0.711554f,0.281559f,0.728543f,0.281559f,0.711554f,0.33282298f,0.728543f,0.332972f,0.711554f,0.37628198f,0.728543f,0.37655902f,0.753706f,0.39112902f,0.753706f,0.347669f,0.736717f,0.34781897f,0.736717f,0.391406f,0.277631f,0.85678697f,0.267404f,0.805373f,0.246229f,0.814144f,0.254711f,0.85678697f,0.23828f,0.761786f,0.222074f,0.77799296f,0.194694f,0.73266304f,0.185923f,0.753838f,0.14328f,0.722436f,0.14328f,0.74535596f,0.091866f,0.73266304f,0.100637f,0.753838f,0.048279f,0.761786f,0.064486f,0.77799296f,0.019155f,0.805373f,0.04033f,0.814144f,0.008929f,0.85678697f,0.031848f,0.85678697f,0.019155f,0.908201f,0.04033f,0.89943f,0.048279f,0.951788f,0.064486f,0.93558097f,0.091866f,0.980911f,0.100637f,0.959736f,0.14328f,0.991138f,0.14328f,0.968219f,0.194694f,0.980911f,0.185923f,0.959736f,0.23828f,0.951788f,0.222074f,0.93558097f,0.267404f,0.908201f,0.246229f,0.89943f,0.14328f,0.85678697f,0.797449f,0.04776001f,0.755469f,0.04776001f,0.755469f,0.050437987f,0.796423f,0.050437987f,0.913891f,0.731543f,0.863894f,0.731543f,0.925095f,0.22508198f,0.947473f,0.21857202f,0.945697f,0.21589398f,0.923866f,0.22248f,0.713489f,0.04776001f,0.714515f,0.050437987f,0.744459f,0.187603f,0.766837f,0.19411302f,0.768066f,0.19151098f,0.746235f,0.18492502f,0.813898f,0.731543f,0.808535f,0.10584301f,0.804704f,0.09674698f,0.748283f,0.13861603f,0.755469f,0.13861603f,0.762655f,0.13861603f,0.887228f,0.127716f,0.883397f,0.13681197f,0.872667f,0.645876f,0.863894f,0.645876f,0.855121f,0.645876f,0.0f,1.0f,1.0f,1.0f,0.908062f,0.47866f,0.090445f,0.48935503f,0.909555f,0.48935002f,0.091938f,0.478666f,0.908061f,0.47865897f,0.090442f,0.48935997f,0.909558f,0.489349f,0.091939f,0.47867697f,0.908062f,0.478683f,0.090445f,0.489429f,0.909555f,0.489429f,0.091938f,0.478683f,0.908061f,0.47867697f,0.090442f,0.489349f,0.909558f,0.48935997f,0.091939f,0.47865897f,0.908062f,0.478666f,0.090445f,0.48935002f,0.909555f,0.48935503f,0.091938f,0.47866f,0.908061f,0.47866398f,0.090442f,0.489352f,0.909558f,0.489354f,0.091939f,0.478662f,0.908062f,0.478662f,0.090445f,0.489353f,0.909555f,0.489353f,0.091938f,0.478662f,0.908061f,0.478662f,0.090442f,0.489354f,0.909558f,0.489352f,0.091939f,0.47866398f);
    }
    private static void method9(){
        MESH_2.getFaces().ensureCapacity(6528);
        MESH_2.getFaces().addAll(0,0,1,1,2,2,0,0,3,3,1,1,0,0,4,4,3,3,0,0,5,5,4,4,0,0,6,6,5,5,0,0,7,7,6,6,0,0,8,8,7,7,0,0,9,9,8,8,0,0,10,10,9,9,0,0,11,11,10,10,0,0,12,12,11,11,0,0,13,13,12,12,0,0,14,14,13,13,0,0,15,15,14,14,0,0,16,16,15,15,0,0,2,2,16,16,2,17,1,18,17,19,2,17,17,19,18,20,1,18,3,21,19,22,1,18,19,22,17,19,3,23,4,24,20,25,3,23,20,25,19,26,4,24,5,27,21,28,4,24,21,28,20,25,5,27,6,29,22,30,5,27,22,30,21,28,6,29,7,31,23,32,6,29,23,32,22,30,7,33,8,34,24,35,7,33,24,35,23,36,8,34,9,37,25,38,8,34,25,38,24,35,9,37,10,39,26,40,9,37,26,40,25,38,10,39,11,41,27,42,10,39,27,42,26,40,11,43,12,44,28,45,11,43,28,45,27,46,12,44,13,47,29,48,12,44,29,48,28,45,13,47,14,49,30,50,13,47,30,50,29,48,14,49,15,51,31,52,14,49,31,52,30,50,15,53,16,54,32,55,15,53,32,55,31,56,16,54,2,17,18,20,16,54,18,20,32,55,18,20,17,19,33,57,18,20,33,57,34,58,17,19,19,22,35,59,17,19,35,59,33,57,19,26,20,25,36,60,19,26,36,60,35,61,20,25,21,28,37,62,20,25,37,62,36,60,21,28,22,30,38,63,21,28,38,63,37,62,22,30,23,32,39,64,22,30,39,64,38,63,23,36,24,35,40,65,23,36,40,65,39,66,24,35,25,38,41,67,24,35,41,67,40,65,25,38,26,40,42,68,25,38,42,68,41,67,26,40,27,42,43,69,26,40,43,69,42,68,27,46,28,45,44,70,27,46,44,70,43,71,28,45,29,48,45,72,28,45,45,72,44,70,29,48,30,50,46,73,29,48,46,73,45,72,30,50,31,52,47,74,30,50,47,74,46,73,31,56,32,55,48,75,31,56,48,75,47,76,32,55,18,20,34,58,32,55,34,58,48,75,34,58,33,57,49,77,34,58,49,77,50,78,33,57,35,59,51,79,33,57,51,79,49,77,35,61,36,60,52,80,35,61,52,80,51,81,36,60,37,62,53,82,36,60,53,82,52,80,37,62,38,63,54,83,37,62,54,83,53,82,38,63,39,64,55,84,38,63,55,84,54,83,39,66,40,65,56,85,39,66,56,85,55,86,40,65,41,67,57,87,40,65,57,87,56,85,41,67,42,68,58,88,41,67,58,88,57,87,42,68,43,69,59,89,42,68,59,89,58,88,43,71,44,70,60,90,43,71,60,90,59,91,44,70,45,72,61,92,44,70,61,92,60,90,45,72,46,73,62,93,45,72,62,93,61,92,46,73,47,74,63,94,46,73,63,94,62,93,47,76,48,75,64,95,47,76,64,95,63,96,48,75,34,58,50,78,48,75,50,78,64,95,50,97,49,98,65,99,50,97,65,99,66,100,49,98,51,101,67,102,49,98,67,102,65,99,51,101,52,103,68,104,51,101,68,104,67,105,52,103,53,106,69,107,52,103,69,107,68,104,53,106,54,108,70,109,53,106,70,109,69,107,54,108,55,110,71,111,54,108,71,111,70,109,55,110,56,112,72,113,55,110,72,113,71,114,56,112,57,115,73,116,56,112,73,116,72,113,57,115,58,117,74,118,57,115,74,118,73,116,58,117,59,119,75,120,58,117,75,120,74,118,59,119,60,121,76,122,59,119,76,122,75,123,60,121,61,124,77,125,60,121,77,125,76,122,61,124,62,126,78,127,61,124,78,127,77,125,62,126,63,128,79,129,62,126,79,129,78,127,63,128,64,130,80,131,63,128,80,131,79,132,64,130,50,97,66,100,64,130,66,100,80,131,66,133,65,134,81,135,66,133,81,135,82,136,65,134,67,137,83,138,65,134,83,138,81,135,67,137,68,139,84,140,67,137,84,140,83,138,68,139,69,141,85,142,68,139,85,142,84,140,69,141,70,143,86,144,69,141,86,144,85,142,70,143,71,145,87,146,70,143,87,146,86,144,71,145,72,147,88,148,71,145,88,148,87,146,72,147,73,149,89,150,72,147,89,150,88,148,73,149,74,151,90,152,73,149,90,152,89,150,74,151,75,153,91,154,74,151,91,154,90,152,75,153,76,155,92,156,75,153,92,156,91,154,76,155,77,157,93,158,76,155,93,158,92,156,77,157,78,159,94,160,77,157,94,160,93,158,78,159,79,161,95,162,78,159,95,162,94,160,79,161,80,163,96,164,79,161,96,164,95,162,80,163,66,133,82,136,80,163,82,136,96,164,82,136,81,135,97,165,82,136,97,165,98,166,81,135,83,138,99,167,81,135,99,167,97,165,83,138,84,140,100,168,83,138,100,168,99,167,84,140,85,142,101,169,84,140,101,169,100,168,85,142,86,144,102,170,85,142,102,170,101,169,86,144,87,146,103,171,86,144,103,171,102,170,87,146,88,148,104,172,87,146,104,172,103,171,88,148,89,150,105,173,88,148,105,173,104,172,89,150,90,152,106,174,89,150,106,174,105,173,90,152,91,154,107,175,90,152,107,175,106,174,91,154,92,156,108,176,91,154,108,176,107,175,92,156,93,158,109,177,92,156,109,177,108,176,93,158,94,160,110,178,93,158,110,178,109,177,94,160,95,162,111,179,94,160,111,179,110,178,95,162,96,164,112,180,95,162,112,180,111,179,96,164,82,136,98,166,96,164,98,166,112,180,98,181,97,182,113,183,98,181,113,183,114,184,97,182,99,185,115,186,97,182,115,186,113,183,99,187,100,188,116,189,99,187,116,189,115,190,100,188,101,191,117,192,100,188,117,192,116,189,101,191,102,193,118,194,101,191,118,194,117,192,102,193,103,195,119,196,102,193,119,196,118,194,103,197,104,198,120,199,103,197,120,199,119,200,104,198,105,201,121,202,104,198,121,202,120,199,105,201,106,203,122,204,105,201,122,204,121,202,106,203,107,205,123,206,106,203,123,206,122,204,107,207,108,208,124,209,107,207,124,209,123,210,108,208,109,211,125,212,108,208,125,212,124,209,109,211,110,213,126,214,109,211,126,214,125,212,110,213,111,215,127,216,110,213,127,216,126,214,111,217,112,218,128,219,111,217,128,219,127,220,112,218,98,181,114,184,112,218,114,184,128,219,114,184,113,183,129,221,114,184,129,221,130,222,113,183,115,186,131,223,113,183,131,223,129,221,115,190,116,189,132,224,115,190,132,224,131,225,116,189,117,192,133,226,116,189,133,226,132,224,117,192,118,194,134,227,117,192,134,227,133,226,118,194,119,196,135,228,118,194,135,228,134,227,119,200,120,199,136,229,119,200,136,229,135,230,120,199,121,202,137,231,120,199,137,231,136,229,121,202,122,204,138,232,121,202,138,232,137,231,122,204,123,206,139,233,122,204,139,233,138,232,123,210,124,209,140,234,123,210,140,234,139,235,124,209,125,212,141,236,124,209,141,236,140,234,125,212,126,214,142,237,125,212,142,237,141,236,126,214,127,216,143,238,126,214,143,238,142,237,127,220,128,219,144,239,127,220,144,239,143,240,128,219,114,184,130,222,128,219,130,222,144,239,130,241,129,242,145,243,130,241,145,243,146,244,129,242,131,245,147,246,129,242,147,246,145,243,131,245,132,247,148,248,131,245,148,248,147,246,132,247,133,249,149,250,132,247,149,250,148,248,133,249,134,251,150,252,133,249,150,252,149,250,134,251,135,253,151,254,134,251,151,254,150,252,135,253,136,255,152,256,135,253,152,256,151,254,136,255,137,257,153,258,136,255,153,258,152,256,137,257,138,259,154,260,137,257,154,260,153,258,138,259,139,261,155,262,138,259,155,262,154,260,139,261,140,263,156,264,139,261,156,264,155,262,140,263,141,265,157,266,140,263,157,266,156,264,141,265,142,267,158,268,141,265,158,268,157,266,142,267,143,269,159,270,142,267,159,270,158,268,143,269,144,271,160,272,143,269,160,272,159,270,144,271,130,241,146,244,144,271,146,244,160,272,161,273,162,274,163,275,161,273,163,275,164,276,162,274,165,277,166,278,162,274,166,278,163,275,165,279,167,280,168,281,165,279,168,281,166,282,167,280,169,283,170,284,167,280,170,284,168,281,169,283,171,285,172,286,169,283,172,286,170,284,171,285,173,287,174,288,171,285,174,288,172,286,173,289,175,290,176,291,173,289,176,291,174,292,175,290,177,293,178,294,175,290,178,294,176,291,177,293,179,295,180,296,177,293,180,296,178,294,179,295,181,297,182,298,179,295,182,298,180,296,181,299,183,300,184,301,181,299,184,301,182,302,183,300,185,303,186,304,183,300,186,304,184,301,185,303,187,305,188,306,185,303,188,306,186,304,187,305,189,307,190,308,187,305,190,308,188,306,189,309,191,310,192,311,189,309,192,311,190,312,191,310,161,273,164,276,191,310,164,276,192,311,164,276,163,275,193,313,164,276,193,313,194,314,163,275,166,278,195,315,163,275,195,315,193,313,166,282,168,281,196,316,166,282,196,316,195,317,168,281,170,284,197,318,168,281,197,318,196,316,170,284,172,286,198,319,170,284,198,319,197,318,172,286,174,288,199,320,172,286,199,320,198,319,174,292,176,291,200,321,174,292,200,321,199,322,176,291,178,294,201,323,176,291,201,323,200,321,178,294,180,296,202,324,178,294,202,324,201,323,180,296,182,298,203,325,180,296,203,325,202,324,182,302,184,301,204,326,182,302,204,326,203,327,184,301,186,304,205,328,184,301,205,328,204,326,186,304,188,306,206,329,186,304,206,329,205,328,188,306,190,308,207,330,188,306,207,330,206,329,190,312,192,311,208,331,190,312,208,331,207,332,192,311,164,276,194,314,192,311,194,314,208,331,194,314,193,313,209,333,194,314,209,333,210,334,193,313,195,315,211,335,193,313,211,335,209,333,195,317,196,316,212,336,195,317,212,336,211,337,196,316,197,318,213,338,196,316,213,338,212,336,197,318,198,319,214,339,197,318,214,339,213,338,198,319,199,320,215,340,198,319,215,340,214,339,199,322,200,321,216,341,199,322,216,341,215,342,200,321,201,323,217,343,200,321,217,343,216,341,201,323,202,324,218,344,201,323,218,344,217,343,202,324,203,325,219,345,202,324,219,345,218,344,203,327,204,326,220,346,203,327,220,346,219,347,204,326,205,328,221,348,204,326,221,348,220,346,205,328,206,329,222,349,205,328,222,349,221,348,206,329,207,330,223,350,206,329,223,350,222,349,207,332,208,331,224,351,207,332,224,351,223,352,208,331,194,314,210,334,208,331,210,334,224,351,210,334,209,333,225,353,210,334,225,353,226,354,209,333,211,335,227,355,209,333,227,355,225,353,211,337,212,336,228,356,211,337,228,356,227,357,212,336,213,338,229,358,212,336,229,358,228,356,213,338,214,339,230,359,213,338,230,359,229,358,214,339,215,340,231,360,214,339,231,360,230,359,215,342,216,341,232,361,215,342,232,361,231,362,216,341,217,343,233,363,216,341,233,363,232,361,217,343,218,344,234,364,217,343,234,364,233,363,218,344,219,345,235,365,218,344,235,365,234,364,219,347,220,346,236,366,219,347,236,366,235,367,220,346,221,348,237,368,220,346,237,368,236,366,221,348,222,349,238,369,221,348,238,369,237,368,222,349,223,350,239,370,222,349,239,370,238,369,223,352,224,351,240,371,223,352,240,371,239,372,224,351,210,334,226,354,224,351,226,354,240,371,226,373,225,374,241,375,226,373,241,375,242,376,225,374,227,377,243,378,225,374,243,378,241,375,227,377,228,379,244,380,227,377,244,380,243,378,228,379,229,381,245,382,228,379,245,382,244,380,229,381,230,383,246,384,229,381,246,384,245,382,230,383,231,385,247,386,230,383,247,386,246,384,231,385,232,387,248,388,231,385,248,388,247,386,232,387,233,389,249,390,232,387,249,390,248,388,233,389,234,391,250,392,233,389,250,392,249,390,234,391,235,393,251,394,234,391,251,394,250,392,235,393,236,395,252,396,235,393,252,396,251,394,236,395,237,397,253,398,236,395,253,398,252,396,237,397,238,399,254,400,237,397,254,400,253,398,238,399,239,401,255,402,238,399,255,402,254,400,239,401,240,403,256,404,239,401,256,404,255,402,240,403,226,373,242,376,240,403,242,376,256,404,242,405,241,406,257,407,242,405,257,407,258,408,241,406,243,409,259,410,241,406,259,410,257,407,243,411,244,412,260,413,243,411,260,413,259,414,244,412,245,415,261,416,244,412,261,416,260,413,245,415,246,417,262,418,245,415,262,418,261,416,246,417,247,419,263,420,246,417,263,420,262,418,247,421,248,422,264,423,247,421,264,423,263,424,248,422,249,425,265,426,248,422,265,426,264,423,249,425,250,427,266,428,249,425,266,428,265,426,250,427,251,429,267,430,250,427,267,430,266,428,251,431,252,432,268,433,251,431,268,433,267,434,252,432,253,435,269,436,252,432,269,436,268,433,253,435,254,437,270,438,253,435,270,438,269,436,254,437,255,439,271,440,254,437,271,440,270,438,255,441,256,442,272,443,255,441,272,443,271,444,256,442,242,405,258,408,256,442,258,408,272,443,258,445,257,446,273,447,258,445,273,447,274,448,257,446,259,449,275,450,257,446,275,450,273,447,259,449,260,451,276,452,259,449,276,452,275,450,260,451,261,453,277,454,260,451,277,454,276,452,261,453,262,455,278,456,261,453,278,456,277,454,262,455,263,457,279,458,262,455,279,458,278,456,263,457,264,459,280,460,263,457,280,460,279,458,264,459,265,461,281,462,264,459,281,462,280,460,265,461,266,463,282,464,265,461,282,464,281,462,266,463,267,465,283,466,266,463,283,466,282,464,267,465,268,467,284,468,267,465,284,468,283,466,268,467,269,469,285,470,268,467,285,470,284,468,269,469,270,471,286,472,269,469,286,472,285,470,270,471,271,473,287,474,270,471,287,474,286,472,271,473,272,475,288,476,271,473,288,476,287,474,272,475,258,445,274,448,272,475,274,448,288,476,274,448,273,447,289,477,274,448,289,477,290,478,273,447,275,450,291,479,273,447,291,479,289,477,275,450,276,452,292,480,275,450,292,480,291,479,276,452,277,454,293,481,276,452,293,481,292,480,277,454,278,456,294,482,277,454,294,482,293,481,278,456,279,458,295,483,278,456,295,483,294,482,279,458,280,460,296,484,279,458,296,484,295,483,280,460,281,462,297,485,280,460,297,485,296,484,281,462,282,464,298,486,281,462,298,486,297,485,282,464,283,466,299,487,282,464,299,487,298,486,283,466,284,468,300,488,283,466,300,488,299,487,284,468,285,470,301,489,284,468,301,489,300,488,285,470,286,472,302,490,285,470,302,490,301,489,286,472,287,474,303,491,286,472,303,491,302,490,287,474,288,476,304,492,287,474,304,492,303,491,288,476,274,448,290,478,288,476,290,478,304,492,290,493,289,494,305,495,290,493,305,495,306,496,289,494,291,497,307,498,289,494,307,498,305,495,291,499,292,500,308,501,291,499,308,501,307,502,292,500,293,503,309,504,292,500,309,504,308,501,293,503,294,505,310,506,293,503,310,506,309,504,294,505,295,507,311,508,294,505,311,508,310,506,295,509,296,510,312,511,295,509,312,511,311,512,296,510,297,513,313,514,296,510,313,514,312,511,297,513,298,515,314,516,297,513,314,516,313,514,298,515,299,517,315,518,298,515,315,518,314,516,299,519,300,520,316,521,299,519,316,521,315,522,300,520,301,523,317,524,300,520,317,524,316,521,301,523,302,525,318,526,301,523,318,526,317,524,302,525,303,527,319,528,302,525,319,528,318,526,303,529,304,530,320,531,303,529,320,531,319,532,304,530,290,493,306,496,304,530,306,496,320,531,306,533,305,534,321,535,306,533,321,535,322,536,305,534,307,537,323,538,305,534,323,538,321,535,307,537,308,539,324,540,307,537,324,540,323,538,308,539,309,541,325,542,308,539,325,542,324,540,309,541,310,543,326,544,309,541,326,544,325,542,310,543,311,545,327,546,310,543,327,546,326,544,311,545,312,547,328,548,311,545,328,548,327,546,312,547,313,549,329,550,312,547,329,550,328,548,313,549,314,551,330,552,313,549,330,552,329,550,314,551,315,553,331,554,314,551,331,554,330,552,315,553,316,555,332,556,315,553,332,556,331,554,316,555,317,557,333,558,316,555,333,558,332,556,317,557,318,559,334,560,317,557,334,560,333,558,318,559,319,561,335,562,318,559,335,562,334,560,319,561,320,563,336,564,319,561,336,564,335,562,320,563,306,533,322,536,320,563,322,536,336,564,322,565,321,566,337,567,322,565,337,567,338,568,321,535,323,538,339,569,321,535,339,569,337,570,323,538,324,540,340,571,323,538,340,571,339,569,324,572,325,573,341,574,324,572,341,574,340,575,325,573,326,576,342,577,325,573,342,577,341,574,326,544,327,546,343,578,326,544,343,578,342,579,327,546,328,548,344,580,327,546,344,580,343,578,328,581,329,582,345,583,328,581,345,583,344,584,329,582,330,585,346,586,329,582,346,586,345,583,330,552,331,554,347,587,330,552,347,587,346,588,331,554,332,556,348,589,331,554,348,589,347,587,332,590,333,591,349,592,332,590,349,592,348,593,333,591,334,594,350,595,333,591,350,595,349,592,334,560,335,562,351,596,334,560,351,596,350,597,335,562,336,564,352,598,335,562,352,598,351,596,336,599,322,565,338,568,336,599,338,568,352,600,338,568,337,567,353,601,338,568,353,601,354,602,337,567,339,603,355,604,337,567,355,604,353,601,339,605,340,575,356,606,339,605,356,606,355,607,340,575,341,574,357,608,340,575,357,608,356,606,341,574,342,577,358,609,341,574,358,609,357,608,342,577,343,610,359,611,342,577,359,611,358,609,343,612,344,584,360,613,343,612,360,613,359,614,344,584,345,583,361,615,344,584,361,615,360,613,345,583,346,586,362,616,345,583,362,616,361,615,346,586,347,617,363,618,346,586,363,618,362,616,347,619,348,593,364,620,347,619,364,620,363,621,348,593,349,592,365,622,348,593,365,622,364,620,349,592,350,595,366,623,349,592,366,623,365,622,350,595,351,624,367,625,350,595,367,625,366,623,351,626,352,600,368,627,351,626,368,627,367,628,352,600,338,568,354,602,352,600,354,602,368,627,354,629,353,630,369,631,354,629,369,631,370,632,353,630,355,633,371,634,353,630,371,634,369,631,355,633,356,635,372,636,355,633,372,636,371,634,356,635,357,637,373,638,356,635,373,638,372,636,357,637,358,639,374,640,357,637,374,640,373,638,358,639,359,641,375,642,358,639,375,642,374,640,359,641,360,643,376,644,359,641,376,644,375,642,360,643,361,645,377,646,360,643,377,646,376,644,361,645,362,647,378,648,361,645,378,648,377,646,362,647,363,649,379,650,362,647,379,650,378,648,363,649,364,651,380,652,363,649,380,652,379,650,364,651,365,653,381,654,364,651,381,654,380,652,365,653,366,655,382,656,365,653,382,656,381,654,366,655,367,657,383,658,366,655,383,658,382,656,367,657,368,659,384,660,367,657,384,660,383,658,368,659,354,629,370,632,368,659,370,632,384,660,370,661,369,662,385,663,370,661,385,663,386,664,369,662,371,665,387,666,369,662,387,666,385,663,371,665,372,667,388,668,371,665,388,668,387,666,372,667,373,669,389,670,372,667,389,670,388,668,373,669,374,671,390,672,373,669,390,672,389,670,374,671,375,673,391,674,374,671,391,674,390,672,375,673,376,675,392,676,375,673,392,676,391,674,376,675,377,677,393,678,376,675,393,678,392,676,377,677,378,679,394,680,377,677,394,680,393,678,378,679,379,681,395,682,378,679,395,682,394,680,379,681,380,683,396,684,379,681,396,684,395,682,380,683,381,685,397,686,380,683,397,686,396,684,381,685,382,687,398,688,381,685,398,688,397,686,382,687,383,689,399,690,382,687,399,690,398,688,383,689,384,691,400,692,383,689,400,692,399,690,384,691,370,661,386,664,384,691,386,664,400,692,386,664,385,663,401,693,386,664,401,693,402,694,385,663,387,666,403,695,385,663,403,695,401,693,387,666,388,668,404,696,387,666,404,696,403,695,388,668,389,670,405,697,388,668,405,697,404,696,389,670,390,672,406,698,389,670,406,698,405,697,390,672,391,674,407,699,390,672,407,699,406,698,391,674,392,676,408,700,391,674,408,700,407,699,392,676,393,678,409,701,392,676,409,701,408,700,393,678,394,680,410,702,393,678,410,702,409,701,394,680,395,682,411,703,394,680,411,703,410,702,395,682,396,684,412,704,395,682,412,704,411,703,396,684,397,686,413,705,396,684,413,705,412,704,397,686,398,688,414,706,397,686,414,706,413,705,398,688,399,690,415,707,398,688,415,707,414,706,399,690,400,692,416,708,399,690,416,708,415,707,400,692,386,664,402,694,400,692,402,694,416,708,402,709,401,710,417,711,402,709,417,711,418,712,401,710,403,713,419,714,401,710,419,714,417,711,403,715,404,716,420,717,403,715,420,717,419,718,404,716,405,719,421,720,404,716,421,720,420,717,405,719,406,721,422,722,405,719,422,722,421,720,406,721,407,723,423,724,406,721,423,724,422,722,407,725,408,726,424,727,407,725,424,727,423,728,408,726,409,729,425,730,408,726,425,730,424,727,409,729,410,731,426,732,409,729,426,732,425,730,410,731,411,733,427,734,410,731,427,734,426,732,411,735,412,736,428,737,411,735,428,737,427,738,412,736,413,739,429,740,412,736,429,740,428,737,413,739,414,741,430,742,413,739,430,742,429,740,414,741,415,743,431,744,414,741,431,744,430,742,415,745,416,746,432,747,415,745,432,747,431,748,416,746,402,709,418,712,416,746,418,712,432,747,418,749,417,750,433,751,418,749,433,751,434,752,417,750,419,753,435,754,417,750,435,754,433,751,419,753,420,755,436,756,419,753,436,756,435,754,420,755,421,757,437,758,420,755,437,758,436,756,421,757,422,759,438,760,421,757,438,760,437,758,422,759,423,761,439,762,422,759,439,762,438,760,423,761,424,763,440,764,423,761,440,764,439,762,424,763,425,765,441,766,424,763,441,766,440,764,425,765,426,767,442,768,425,765);
    }
    private static void method10(){
        MESH_2.getFaces().addAll(442,768,441,766,426,767,427,769,443,770,426,767,443,770,442,768,427,769,428,771,444,772,427,769,444,772,443,770,428,771,429,773,445,774,428,771,445,774,444,772,429,773,430,775,446,776,429,773,446,776,445,774,430,775,431,777,447,778,430,775,447,778,446,776,431,777,432,779,448,780,431,777,448,780,447,778,432,779,418,749,434,752,432,779,434,752,448,780,434,752,433,751,449,781,433,751,435,754,449,781,435,754,436,756,449,781,436,756,437,758,449,781,437,758,438,760,449,781,438,760,439,762,449,781,439,762,440,764,449,781,440,764,441,766,449,781,441,766,442,768,449,781,442,768,443,770,449,781,443,770,444,772,449,781,444,772,445,774,449,781,445,774,446,776,449,781,446,776,447,778,449,781,447,778,448,780,449,781,448,780,434,752,449,781,148,782,149,783,450,784,148,782,450,784,451,785,169,283,167,280,452,786,169,283,452,786,453,787,167,788,148,789,451,790,167,788,451,790,452,791,149,783,150,792,454,793,149,783,454,793,450,784,150,794,171,795,455,796,150,794,455,796,454,797,171,285,169,283,453,787,171,285,453,787,455,798,454,797,455,796,456,799,454,797,456,799,457,800,450,784,454,793,457,801,450,784,457,801,458,802,451,785,450,784,458,802,451,785,458,802,459,803,452,791,451,790,459,804,452,791,459,804,460,805,453,787,452,786,460,806,453,787,460,806,461,807,455,798,453,787,461,807,455,798,461,807,456,808,145,782,147,783,462,784,145,782,462,784,463,785,165,283,162,280,464,786,165,283,464,786,465,787,162,788,145,789,463,790,162,788,463,790,464,791,147,783,148,792,466,793,147,783,466,793,462,784,148,794,167,795,467,796,148,794,467,796,466,797,167,285,165,283,465,787,167,285,465,787,467,798,466,797,467,796,468,799,466,797,468,799,469,800,462,784,466,793,469,801,462,784,469,801,470,802,463,785,462,784,470,802,463,785,470,802,471,803,464,791,463,790,471,804,464,791,471,804,472,805,465,787,464,786,472,806,465,787,472,806,473,807,467,798,465,787,473,807,467,798,473,807,468,808,160,782,146,783,474,784,160,782,474,784,475,785,161,283,191,280,476,786,161,283,476,786,477,787,191,788,160,789,475,790,191,788,475,790,476,791,146,783,145,792,478,793,146,783,478,793,474,784,145,794,162,795,479,796,145,794,479,796,478,797,162,285,161,283,477,787,162,285,477,787,479,798,478,797,479,796,480,799,478,797,480,799,481,800,474,784,478,793,481,801,474,784,481,801,482,802,475,785,474,784,482,802,475,785,482,802,483,803,476,791,475,790,483,804,476,791,483,804,484,805,477,787,476,786,484,806,477,787,484,806,485,807,479,798,477,787,485,807,479,798,485,807,480,808,158,782,159,783,486,784,158,782,486,784,487,785,189,283,187,280,488,786,189,283,488,786,489,787,187,788,158,789,487,790,187,788,487,790,488,791,159,783,160,792,490,793,159,783,490,793,486,784,160,794,191,795,491,796,160,794,491,796,490,797,191,285,189,283,489,787,191,285,489,787,491,798,490,797,491,796,492,799,490,797,492,799,493,800,486,784,490,793,493,801,486,784,493,801,494,802,487,785,486,784,494,802,487,785,494,802,495,803,488,791,487,790,495,804,488,791,495,804,496,805,489,787,488,786,496,806,489,787,496,806,497,807,491,798,489,787,497,807,491,798,497,807,492,808,156,782,157,783,498,784,156,782,498,784,499,785,185,283,183,280,500,786,185,283,500,786,501,787,183,788,156,789,499,790,183,788,499,790,500,791,157,783,158,792,502,793,157,783,502,793,498,784,158,794,187,795,503,796,158,794,503,796,502,797,187,285,185,283,501,787,187,285,501,787,503,798,502,797,503,796,504,799,502,797,504,799,505,800,498,784,502,793,505,801,498,784,505,801,506,802,499,785,498,784,506,802,499,785,506,802,507,803,500,791,499,790,507,804,500,791,507,804,508,805,501,787,500,786,508,806,501,787,508,806,509,807,503,798,501,787,509,807,503,798,509,807,504,808,154,782,155,783,510,784,154,782,510,784,511,785,181,283,179,280,512,786,181,283,512,786,513,787,179,788,154,789,511,790,179,788,511,790,512,791,155,783,156,792,514,793,155,783,514,793,510,784,156,794,183,795,515,796,156,794,515,796,514,797,183,285,181,283,513,787,183,285,513,787,515,798,514,797,515,796,516,799,514,797,516,799,517,800,510,784,514,793,517,801,510,784,517,801,518,802,511,785,510,784,518,802,511,785,518,802,519,803,512,791,511,790,519,804,512,791,519,804,520,805,513,787,512,786,520,806,513,787,520,806,521,807,515,798,513,787,521,807,515,798,521,807,516,808,152,782,153,783,522,784,152,782,522,784,523,785,177,283,175,280,524,786,177,283,524,786,525,787,175,788,152,789,523,790,175,788,523,790,524,791,153,783,154,792,526,793,153,783,526,793,522,784,154,794,179,795,527,796,154,794,527,796,526,797,179,285,177,283,525,787,179,285,525,787,527,798,526,797,527,796,528,799,526,797,528,799,529,800,522,784,526,793,529,801,522,784,529,801,530,802,523,785,522,784,530,802,523,785,530,802,531,803,524,791,523,790,531,804,524,791,531,804,532,805,525,787,524,786,532,806,525,787,532,806,533,807,527,798,525,787,533,807,527,798,533,807,528,808,150,782,151,783,534,784,150,782,534,784,535,785,173,283,171,280,536,786,173,283,536,786,537,787,171,788,150,789,535,790,171,788,535,790,536,791,151,783,152,792,538,793,151,783,538,793,534,784,152,794,175,795,539,796,152,794,539,796,538,797,175,285,173,283,537,787,175,285,537,787,539,798,538,797,539,796,540,799,538,797,540,799,541,800,534,784,538,793,541,801,534,784,541,801,542,802,535,785,534,784,542,802,535,785,542,802,543,803,536,791,535,790,543,804,536,791,543,804,544,805,537,787,536,786,544,806,537,787,544,806,545,807,539,798,537,787,545,807,539,798,545,807,540,808,480,809,485,810,482,811,480,809,482,811,481,812,485,809,484,810,483,813,485,809,483,813,482,814,492,809,497,810,494,815,492,809,494,815,493,816,497,809,496,810,495,817,497,809,495,817,494,818,504,809,509,810,506,819,504,809,506,819,505,820,509,809,508,810,507,821,509,809,507,821,506,822,516,809,521,810,518,823,516,809,518,823,517,824,521,809,520,810,519,825,521,809,519,825,518,826,528,809,533,810,530,827,528,809,530,827,529,828,533,809,532,810,531,829,533,809,531,829,530,830,540,809,545,810,542,831,540,809,542,831,541,832,545,809,544,810,543,833,545,809,543,833,542,834,456,809,461,810,458,835,456,809,458,835,457,836,461,809,460,810,459,837,461,809,459,837,458,838,468,809,473,810,470,839,468,809,470,839,469,840,473,809,472,810,471,841,473,809,471,841,470,842);
    }
    private static void method11(){
        MESH_2.getFaceSmoothingGroups().ensureCapacity(1088);
        MESH_2.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_4 = MESHVIEWS[3];
        MESHVIEWS[3].setId("duke_model duke_model_L_hand_geo");
        MESHVIEWS[3].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_3 = new PhongMaterial();
        MATERIAL_3.setDiffuseColor(new Color(0.10000000149011612,0.10000000149011612,0.10000000149011612,1.0));
        MATERIAL_3.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_3.setSpecularPower(18.0);
        MESHVIEWS[3].setMaterial(MATERIAL_3);
        MESH_3 = new TriangleMesh();
        MESHVIEWS[3].setMesh(MESH_3);
        MESH_3.getPoints().ensureCapacity(1518);
        MESH_3.getPoints().addAll(14.840014f,9.727172f,5.480483f,14.714002f,10.370733f,5.073911f,15.24349f,10.698246f,5.285507f,15.385925f,10.011369f,5.696162f,14.553314f,11.049072f,4.836394f,15.010588f,11.19842f,5.062962f,14.106885f,10.394827f,4.963819f,14.10457f,10.911924f,4.758967f,14.205095f,9.795568f,5.46886f,14.942195f,8.81497f,6.6181f,14.880169f,9.188728f,6.040625f,15.434514f,9.464626f,6.241079f,15.446903f,9.109193f,6.841007f,14.221903f,9.259824f,6.092281f,14.29114f,8.852762f,6.632314f,13.28987f,11.499298f,5.30024f,13.640811f,10.824997f,5.037102f,13.726384f,10.253226f,5.7389f,13.39291f,10.929332f,6.156673f,13.766105f,11.342379f,4.61377f,13.349626f,12.053653f,4.537805f,13.347809f,10.379986f,6.906123f,13.715884f,9.72302f,6.428809f,13.737676f,9.269411f,6.926898f,13.35387f,9.90103f,7.493621f,14.014281f,10.563292f,6.052856f,14.309275f,10.241606f,5.79015f,14.129547f,10.478518f,5.400133f,13.883666f,10.681196f,5.667067f,14.316651f,9.741006f,5.510819f,14.142791f,9.982098f,5.242212f,14.201382f,9.825802f,6.16354f,14.207795f,9.533875f,5.870177f,13.980239f,10.133109f,6.32204f,15.561429f,9.688524f,7.25786f,15.628729f,10.042342f,6.660811f,15.503883f,10.830856f,7.233699f,15.34237f,10.373034f,7.851305f,15.597524f,10.611452f,6.038238f,15.491402f,11.417933f,6.520419f,15.476689f,11.322991f,5.516752f,15.414178f,12.146297f,5.861511f,15.126961f,11.808055f,5.095936f,15.164721f,12.72007f,5.190826f,14.409096f,11.742296f,4.714154f,14.338062f,12.217845f,4.636336f,12.608108f,12.937028f,6.245266f,13.028058f,12.255843f,5.759655f,13.193691f,11.652886f,6.588226f,12.829437f,12.325551f,6.995967f,12.871549f,12.743517f,5.107688f,12.55265f,13.607409f,5.70139f,12.748524f,11.656393f,7.833488f,13.103562f,11.032379f,7.380117f,13.016712f,10.614415f,7.943746f,12.698661f,11.247104f,8.47051f,13.283531f,12.496137f,6.764081f,13.728395f,12.107264f,6.414841f,13.587087f,12.436845f,5.864048f,13.177373f,12.64475f,6.283576f,13.795959f,11.478735f,6.06549f,13.618167f,11.818185f,5.6892f,13.492382f,11.538021f,6.965528f,13.584198f,11.134299f,6.548977f,13.19217f,11.979727f,7.137233f,15.07923f,11.342861f,8.454005f,15.100944f,11.739211f,7.89366f,14.50141f,12.642738f,8.550111f,14.45731f,12.140499f,9.134847f,15.084041f,12.321181f,7.156353f,14.468433f,13.235128f,7.80491f,15.056589f,13.069551f,6.413685f,14.482725f,13.951536f,6.997591f,14.9889f,13.672674f,5.814034f,14.355767f,14.557162f,6.261866f,14.78685f,14.345553f,4.768682f,14.042016f,13.959619f,4.457337f,13.621224f,14.63942f,5.046606f,14.292386f,14.724349f,5.108918f,13.261318f,13.695244f,4.312811f,13.16102f,14.265494f,4.785897f,14.332102f,13.433908f,4.080129f,13.710857f,13.343205f,4.062852f,14.865911f,13.77213f,4.361532f,11.218284f,13.983182f,6.679869f,11.782582f,13.385212f,6.586931f,12.000944f,12.848987f,7.342271f,11.318865f,13.477762f,7.362365f,11.850652f,13.936348f,6.12804f,11.387926f,14.539739f,6.435626f,11.623271f,12.806679f,8.669216f,12.048114f,12.228304f,8.249002f,12.033933f,11.944366f,8.805819f,11.761873f,12.546629f,9.242993f,12.081916f,13.827306f,7.757749f,12.459513f,13.471437f,7.375353f,12.354517f,13.798204f,6.909413f,11.991417f,13.985411f,7.345126f,12.546293f,12.943053f,7.008465f,12.407557f,13.254406f,6.659646f,12.273678f,12.972185f,7.856788f,12.403617f,12.640647f,7.53932f,12.00138f,13.391957f,8.012446f,13.089722f,13.306792f,9.822409f,13.841473f,12.92391f,9.571718f,13.786815f,13.416874f,9.112552f,12.977757f,13.779904f,9.376306f,13.737586f,14.073709f,8.325011f,12.486512f,14.339677f,8.8173f,13.771479f,14.65104f,7.437587f,12.730024f,14.948394f,8.174091f,13.532016f,14.895092f,6.654144f,12.726178f,15.230611f,7.508216f,12.662759f,14.548241f,6.184039f,12.07196f,15.02597f,6.80994f,13.298635f,14.361363f,5.967104f,9.178309f,11.761805f,8.6854f,8.966531f,11.579129f,7.99234f,9.606024f,11.677694f,7.919186f,9.665478f,11.823706f,8.462228f,8.953578f,11.748052f,7.259557f,9.486874f,11.818079f,7.370376f,8.525855f,11.832173f,8.025773f,8.646385f,11.951749f,7.412974f,8.774408f,11.973109f,8.582599f,12.094865f,13.450195f,9.136758f,12.255165f,13.090899f,9.647351f,11.703697f,13.837987f,8.319236f,13.935314f,9.496403f,6.443453f,13.664927f,9.215423f,6.631521f,13.406465f,9.617298f,6.95645f,13.676171f,9.913961f,6.782459f,14.222027f,8.856144f,6.455757f,13.857964f,8.60896f,6.542285f,14.064621f,9.357138f,6.92721f,14.509434f,8.84644f,6.763534f,13.680355f,9.914116f,7.401875f,13.208237f,9.427111f,7.455325f,13.630733f,9.693233f,7.480587f,14.018122f,9.696681f,7.893326f,13.765162f,9.151364f,8.011478f,14.638066f,9.597552f,8.293406f,13.172928f,8.926472f,7.778007f,13.403203f,8.397035f,7.574369f,14.045575f,8.6056f,7.848742f,15.00202f,9.05552f,7.828522f,15.104664f,8.644597f,7.32664f,14.29843f,8.282531f,7.334668f,13.698915f,8.072186f,7.135011f,14.350163f,8.40876f,6.811602f,13.859891f,8.185347f,6.750567f,14.898301f,8.591899f,6.934175f,14.046345f,9.586393f,6.45775f,13.749985f,9.676596f,6.104468f,13.371836f,10.115699f,6.405448f,13.683989f,9.992778f,6.774773f,14.027468f,8.978784f,6.08774f,13.814586f,9.131828f,5.666701f,13.809129f,9.212639f,6.770548f,13.845984f,8.624859f,6.502723f,13.517259f,9.610084f,7.085517f,12.739223f,10.129782f,6.316398f,12.967893f,9.837871f,6.812367f,13.007309f,9.452662f,7.27447f,12.409795f,9.355972f,6.619648f,12.643244f,8.984871f,7.258602f,12.276735f,9.811763f,5.981274f,12.435174f,9.254416f,5.548091f,12.521516f,8.781413f,6.245732f,12.789018f,8.451222f,6.959119f,13.014454f,8.408083f,5.924808f,13.189826f,8.107921f,6.612487f,12.927958f,8.802556f,5.254854f,13.599969f,8.529945f,5.89112f,13.468534f,8.801064f,5.339617f,13.590833f,8.21121f,6.455204f,13.657842f,9.968284f,6.610862f,13.946114f,9.475999f,6.440295f,14.132453f,9.189868f,5.928224f,13.623922f,9.499029f,6.230826f,13.790588f,9.109254f,5.714697f,13.29343f,9.986622f,6.460533f,13.388289f,10.474845f,6.191201f,12.909873f,10.336334f,6.125817f,13.2957f,10.688167f,5.554577f,12.708061f,10.375288f,5.546165f,13.538302f,10.300763f,5.074241f,12.936566f,9.918459f,5.054423f,13.882863f,9.707155f,4.935453f,13.339899f,9.354157f,4.859644f,14.096128f,9.301911f,5.323357f,13.662539f,9.070685f,5.170907f,13.17792f,11.09029f,7.452457f,12.775188f,10.692114f,7.651547f,12.435822f,11.029671f,8.172621f,12.926398f,11.379721f,8.033213f,13.482572f,10.494416f,7.282038f,13.048559f,10.081751f,7.400142f,13.363013f,10.846684f,7.936779f,14.028832f,10.470726f,7.402067f,13.293893f,11.622127f,8.342777f,12.852366f,11.164893f,8.856032f,12.186567f,10.852868f,8.766579f,12.165634f,10.322889f,9.072667f,12.994252f,10.606301f,9.387384f,12.979262f,11.180023f,8.97277f,13.910879f,11.321263f,9.592169f,12.511216f,9.600885f,8.730193f,13.39044f,9.864555f,9.093694f,14.495553f,10.551765f,9.069259f,14.759934f,9.791849f,8.376876f,13.733497f,9.429235f,8.389717f,12.922786f,9.151699f,8.118057f,13.715985f,9.789967f,7.690132f,13.099829f,9.440144f,7.615173f,13.626649f,9.564135f,7.838963f,12.540987f,11.695846f,7.807059f,12.47749f,11.071266f,8.273096f,12.982263f,10.664708f,7.847085f,13.213717f,11.15337f,7.34881f,12.876581f,11.307091f,6.821111f,12.201468f,11.994349f,7.278948f,13.446944f,10.373334f,6.826046f,13.186931f,10.500218f,6.206873f,13.191285f,10.015239f,7.467036f,11.746206f,11.556309f,7.868696f,11.882823f,10.933558f,8.513965f,11.245646f,10.977728f,7.605872f,11.542134f,10.418518f,8.467357f,11.508926f,12.020368f,7.190181f,11.115355f,11.564214f,6.752412f,11.455652f,10.203052f,7.090709f,11.799257f,9.693024f,8.030935f,12.10516f,9.665945f,6.640069f,12.35213f,9.210462f,7.548554f,11.99136f,10.185197f,5.757599f,11.361354f,10.812062f,6.172942f,12.898697f,9.424183f,7.364058f,12.9232f,9.800098f,6.570808f,12.749919f,10.104938f,5.812259f,12.790026f,11.864609f,7.487621f,13.228808f,11.113705f,7.2479f,13.540044f,10.61991f,6.591508f,12.766237f,11.032817f,6.947636f,13.102603f,10.363958f,6.23373f,12.216778f,11.847136f,7.339745f,12.472231f,12.459269f,7.024938f,11.767253f,12.277639f,7.004877f,12.405159f,12.638287f,6.257094f,11.591975f,12.239841f,6.30222f,12.718589f,12.142183f,5.581366f,11.8799f,11.638819f,5.611887f,13.159562f,11.388983f,5.322266f,12.392555f,10.884059f,5.259988f,13.475169f,10.796618f,5.804298f,12.891525f,10.385005f,5.572721f,12.172396f,12.469337f,8.507062f,11.846248f,12.127869f,8.758375f,11.458816f,12.501248f,9.316125f,11.878665f,12.838346f,9.117803f,12.508716f,11.829802f,8.279085f,12.149723f,11.513816f,8.429986f,12.815991f,11.46639f,8.5617f,12.367906f,12.205315f,8.875846f,12.482345f,12.318355f,8.73185f,12.672626f,11.084375f,8.707966f,12.129195f,12.73505f,9.376163f,12.212203f,12.866279f,9.215675f,11.8246f,12.657146f,9.771406f,11.229721f,12.374418f,9.763205f,11.224933f,11.883656f,9.937222f,11.987068f,12.111543f,10.175654f,12.330806f,12.887535f,9.920364f,12.410655f,13.042027f,9.798446f,12.783403f,12.666977f,10.242859f,12.87569f,12.837108f,10.176122f,13.297626f,12.07752f,10.078113f,13.405264f,12.24299f,10.04468f,13.680589f,11.349083f,9.637229f,13.92382f,11.453535f,9.610663f,11.879795f,10.68749f,9.185107f,12.65598f,10.93347f,9.518278f,12.342822f,11.387253f,10.038374f,11.510381f,11.165251f,9.675847f,12.126901f,10.91868f,8.671037f,12.690588f,11.199419f,8.774011f,13.187556f,11.226891f,9.113855f,13.109157f,11.274986f,8.964149f,11.413835f,13.101982f,8.748218f,11.370651f,12.52167f,9.305346f,11.910159f,12.128817f,8.8431f,12.154402f,12.6682f,8.343925f,11.812944f,12.846198f,7.820639f,11.119846f,13.417866f,8.145453f,12.488932f,12.006277f,7.875256f,12.178707f,12.179061f,7.32647f,12.200395f,11.513612f,8.443246f,10.377233f,12.565498f,8.610415f,10.712733f,11.971872f,9.483888f,10.918369f,12.434308f,9.536864f,10.746597f,13.040915f,8.834154f,10.534218f,13.542266f,8.103178f,10.243077f,13.214615f,7.738173f,10.530181f,11.756506f,8.08502f,10.913107f,11.239494f,9.09267f,11.089181f,11.175555f,7.624214f,11.362742f,10.729457f,8.639061f,11.010288f,11.769911f,6.661581f,10.454618f,12.440419f,7.10939f,11.937985f,11.383793f,7.594789f,11.904872f,10.933988f,8.398912f,11.7516f,11.753241f,6.839444f,11.695622f,13.374891f,8.299809f,12.100338f,12.672606f,8.199935f,12.393808f,12.197235f,7.703283f,11.732812f,12.709287f,7.907053f,12.079806f,12.097359f,7.407454f,11.185057f,13.411151f,8.104239f,11.35871f,14.04241f,7.344789f,11.410273f,13.902724f,7.960946f,10.769772f,13.779593f,7.88717f,10.626291f,13.704707f,7.35939f,11.655362f,13.580242f,6.612843f,10.904764f,13.074298f,6.646445f,12.063268f,12.891151f,6.277624f,11.392568f,12.352151f,6.253383f,12.345421f,12.350139f,6.851811f,11.877115f,12.002024f,6.685286f,13.467257f,12.401975f,4.375129f,14.329585f,12.43014f,4.44529f,14.986913f,12.957687f,4.874166f,14.34183f,12.57717f,4.368989f,14.860431f,13.02849f,4.705418f,13.62976f,12.590533f,4.370255f,14.983001f,13.905897f,5.512516f,14.447413f,14.615617f,5.975967f,14.857125f,13.906203f,5.321323f,14.402719f,14.584066f,5.798775f,13.509699f,14.42783f,5.880124f,12.77694f,13.740601f,5.425559f,13.568055f,14.435878f,5.719766f,12.926861f,13.823015f,5.30307f,12.856268f,12.952054f,4.812891f,13.052765f,13.106835f,4.767416f,13.04543f,13.890489f,5.226743f,13.126748f,13.229186f,4.751779f,13.645818f,12.759499f,4.401879f,13.045873f,13.288732f,4.682993f,13.593635f,12.789257f,4.317245f,12.984027f,13.998934f,5.180954f,14.332576f,12.792797f,4.41457f,14.829362f,13.244419f,4.727483f,14.374959f,12.876423f,4.358776f,14.946786f,13.390747f,4.702648f,14.808203f,13.965272f,5.232186f,14.34931f,14.494534f,5.611822f,14.90329f,14.093993f,5.187443f,14.373751f,14.586557f,5.540183f,13.574047f,14.50635f,5.511727f,13.602352f,14.401673f,5.569402f,13.05917f,13.466558f,4.489369f,13.022335f,13.367319f,4.590199f,12.964164f,14.08801f,5.092386f,13.000072f,14.151969f,4.972646f,13.580464f,12.861551f,4.221137f,13.602505f,12.986546f,4.136798f,14.386393f,13.085318f,4.183407f,14.391207f,12.965116f,4.271276f,14.986042f,13.494135f,4.621445f,14.962541f,13.586073f,4.518641f,14.381948f,14.668208f,5.441731f,14.934264f,14.188533f,5.098008f,14.912964f,14.244741f,4.975875f,14.376251f,14.699007f,5.307142f,13.564807f,14.590939f,5.417213f,13.582096f,14.627235f,5.283564f,13.118928f,13.573236f,4.388976f,13.048656f,14.197858f,4.84487f,13.642459f,13.135638f,4.060047f,14.383033f,13.228852f,4.103449f,14.933438f,13.678952f,4.414659f,14.385464f,14.688498f,5.164114f,14.890993f,14.275517f,4.846924f,13.61539f,14.62383f,5.137939f,11.258174f,13.725381f,7.29381f,11.164147f,13.766695f,7.16194f,11.099854f,14.358845f,6.743355f,11.164289f,14.249103f,6.773456f,11.176254f,14.949874f,6.809571f,11.290357f,14.817311f,6.696446f,11.818824f,15.16226f,8.287333f,12.251156f,15.234647f,7.97301f,11.786503f,15.188072f,7.222611f,11.511719f,15.241476f,7.476627f,11.600195f,13.988922f,8.837423f,12.01688f,14.217976f,8.826469f,12.282736f,14.830253f,8.568655f,11.810155f,14.640806f,8.784497f,11.293497f,13.703572f,8.078274f,11.520097f,13.835932f,8.194737f,9.079352f,13.967767f,7.122897f,9.398772f,14.371281f,7.112033f,9.779924f,13.942075f,6.833457f,9.59418f,13.683931f,6.777901f,9.297572f,14.006904f,8.791206f,9.561266f,14.432486f,8.677542f,9.340002f,14.548039f,7.893608f,8.995862f,14.086535f,7.977872f,10.493153f,13.38131f,8.673193f,10.41915f,13.526315f,8.716632f,10.020268f,13.984728f,8.963335f,9.938408f,13.695561f,9.011397f,10.221182f,13.523533f,7.087324f,10.460194f,13.378776f,7.903171f,10.536723f,13.292967f,7.81141f,10.195069f,13.403006f,6.991254f,8.651701f,12.384029f,7.088022f,9.244069f,12.265759f,6.794632f,9.89654f,12.155773f,7.060354f,9.577244f,13.002914f,6.635556f,10.307051f,12.856074f,6.895413f,8.905622f,13.160632f,6.992455f,8.775029f,12.426569f,8.852962f,8.496401f,12.44628f,7.989672f,8.710265f,13.245979f,7.95776f,9.006583f,13.220659f,8.878714f,9.484426f,12.298901f,9.031199f,9.810025f,13.046431f,9.102653f,10.133716f,12.162956f,8.650331f,10.555245f,12.861319f,8.709805f,10.232086f,12.118382f,7.836162f,10.676983f,12.803379f,7.780434f,11.153101f,12.043646f,6.383017f,10.615446f,12.762645f,6.812884f,11.783104f,11.852136f,6.700758f,12.101208f,12.120481f,7.321825f,11.724723f,12.785909f,7.827201f,11.083392f,13.448428f,8.093742f,10.575648f,13.700733f,7.961272f,10.359731f,13.488562f,7.501824f,11.585931f,10.680435f,8.938923f,11.181643f,11.169557f,9.406235f,11.970534f,10.891983f,8.568621f,12.122571f,11.467956f,8.476253f,11.829104f,12.072063f,8.842792f,11.373774f,12.450517f,9.350188f,11.040195f,12.349613f,9.680422f,10.93922f,11.884306f,9.732687f,12.10606f,10.516853f,5.429058f,11.530363f,11.22951f,5.817145f,12.753537f,10.20308f,5.608038f,13.088339f,10.387109f,6.137536f,12.752189f,11.165764f,6.821602f,12.12574f,11.959133f,7.266476f,11.551583f,12.190374f,7.048452f,11.265743f,11.925771f,6.460759f,12.590978f,9.136749f,7.870504f,12.113944f,9.596775f,8.409058f,12.941642f,9.387001f,7.539176f,13.055155f,9.995122f,7.489748f,12.820741f,10.608791f,7.796916f,12.409624f,10.969461f,8.257125f,11.993033f,10.81858f,8.666811f,11.813612f,10.30982f,8.794572f,13.054286f,9.06013f,4.969791f,12.592813f,9.582963f,5.219769f,13.499859f,8.914149f,5.181223f,13.73852f,9.10689f,5.636347f,13.60911f,9.590158f,6.131251f,13.242913f,10.065757f,6.406227f,12.727835f,10.25024f,6.181664f,12.391852f,10.1054f,5.700569f,13.396016f,8.053215f,6.914681f,13.058883f,8.380939f,7.295577f,13.663702f,8.154147f,6.651869f,13.782543f,8.559132f,6.574718f,13.673023f,9.143561f,6.750892f,13.409984f,9.537354f,7.063226f,13.068196f,9.370365f,7.394608f,12.875289f,8.899314f,7.540293f,10.231219f,14.158009f,8.918922f,10.442082f,13.601989f,8.753806f,10.46269f,13.405393f,7.983573f,10.326028f,13.566925f,7.167955f,10.065125f,14.085325f,6.866642f,9.845757f,14.621885f,7.078372f,9.833652f,14.837949f,7.801967f,9.978806f,14.695865f,8.570944f,10.876812f,14.889091f,8.499307f,10.737199f,15.078335f,7.686958f,10.612178f,14.863878f,6.938164f,10.631931f,14.261778f,6.738467f,10.718916f,13.664256f,7.076576f,10.795602f,13.463535f,7.941229f,10.857684f,13.666512f,8.742318f,10.900873f,14.280082f,8.889728f,14.628736f,10.684709f,8.998754f,14.847176f,9.777052f,8.30765f,15.155878f,9.135541f,7.746572f,15.229307f,8.732432f,7.217828f,14.995706f,8.704303f,6.819295f,14.589513f,8.988777f,6.662667f,14.145198f,9.523367f,6.859736f,13.355108f,9.715376f,7.717401f,13.462265f,10.981384f,7.831714f,13.795625f,9.672357f,7.791275f);
    }
    private static void method12(){
        MESH_3.getTexCoords().ensureCapacity(2);
        MESH_3.getTexCoords().addAll(0.0f,0.0f);
    }
    private static void method13(){
        MESH_3.getFaces().ensureCapacity(6048);
        MESH_3.getFaces().addAll(0,0,1,0,2,0,0,0,2,0,3,0,2,0,1,0,4,0,2,0,4,0,5,0,4,0,1,0,6,0,4,0,6,0,7,0,6,0,1,0,0,0,6,0,0,0,8,0,9,0,10,0,11,0,9,0,11,0,12,0,11,0,10,0,0,0,11,0,0,0,3,0,0,0,10,0,13,0,0,0,13,0,8,0,13,0,10,0,9,0,13,0,9,0,14,0,15,0,16,0,17,0,15,0,17,0,18,0,17,0,16,0,6,0,17,0,6,0,8,0,6,0,16,0,19,0,6,0,19,0,7,0,19,0,16,0,15,0,19,0,15,0,20,0,21,0,22,0,23,0,21,0,23,0,24,0,23,0,22,0,13,0,23,0,13,0,14,0,13,0,22,0,17,0,13,0,17,0,8,0,17,0,22,0,21,0,17,0,21,0,18,0,25,0,26,0,27,0,25,0,27,0,28,0,27,0,26,0,29,0,27,0,29,0,30,0,29,0,26,0,31,0,29,0,31,0,32,0,31,0,26,0,25,0,31,0,25,0,33,0,34,0,35,0,36,0,34,0,36,0,37,0,36,0,35,0,38,0,36,0,38,0,39,0,38,0,35,0,11,0,38,0,11,0,3,0,11,0,35,0,34,0,11,0,34,0,12,0,38,0,40,0,41,0,38,0,41,0,39,0,41,0,40,0,42,0,41,0,42,0,43,0,42,0,40,0,2,0,42,0,2,0,5,0,2,0,40,0,38,0,2,0,38,0,3,0,42,0,44,0,45,0,42,0,45,0,43,0,45,0,44,0,19,0,45,0,19,0,20,0,19,0,44,0,4,0,19,0,4,0,7,0,4,0,44,0,42,0,4,0,42,0,5,0,46,0,47,0,48,0,46,0,48,0,49,0,48,0,47,0,15,0,48,0,15,0,18,0,15,0,47,0,50,0,15,0,50,0,20,0,50,0,47,0,46,0,50,0,46,0,51,0,52,0,53,0,54,0,52,0,54,0,55,0,54,0,53,0,21,0,54,0,21,0,24,0,21,0,53,0,48,0,21,0,48,0,18,0,48,0,53,0,52,0,48,0,52,0,49,0,56,0,57,0,58,0,56,0,58,0,59,0,58,0,57,0,60,0,58,0,60,0,61,0,60,0,57,0,62,0,60,0,62,0,63,0,62,0,57,0,56,0,62,0,56,0,64,0,65,0,66,0,67,0,65,0,67,0,68,0,67,0,66,0,69,0,67,0,69,0,70,0,69,0,66,0,36,0,69,0,36,0,39,0,36,0,66,0,65,0,36,0,65,0,37,0,69,0,71,0,72,0,69,0,72,0,70,0,72,0,71,0,73,0,72,0,73,0,74,0,73,0,71,0,41,0,73,0,41,0,43,0,41,0,71,0,69,0,41,0,69,0,39,0,75,0,76,0,77,0,75,0,77,0,78,0,77,0,76,0,79,0,77,0,79,0,80,0,79,0,76,0,81,0,79,0,81,0,82,0,81,0,76,0,75,0,81,0,75,0,83,0,84,0,85,0,86,0,84,0,86,0,87,0,86,0,85,0,46,0,86,0,46,0,49,0,46,0,85,0,88,0,46,0,88,0,51,0,88,0,85,0,84,0,88,0,84,0,89,0,90,0,91,0,92,0,90,0,92,0,93,0,92,0,91,0,52,0,92,0,52,0,55,0,52,0,91,0,86,0,52,0,86,0,49,0,86,0,91,0,90,0,86,0,90,0,87,0,94,0,95,0,96,0,94,0,96,0,97,0,96,0,95,0,98,0,96,0,98,0,99,0,98,0,95,0,100,0,98,0,100,0,101,0,100,0,95,0,94,0,100,0,94,0,102,0,103,0,104,0,105,0,103,0,105,0,106,0,106,0,105,0,107,0,106,0,107,0,108,0,107,0,105,0,67,0,107,0,67,0,70,0,67,0,105,0,104,0,67,0,104,0,68,0,107,0,109,0,110,0,107,0,110,0,108,0,110,0,109,0,111,0,110,0,111,0,112,0,111,0,109,0,72,0,111,0,72,0,74,0,72,0,109,0,107,0,72,0,107,0,70,0,111,0,113,0,114,0,111,0,114,0,112,0,114,0,113,0,88,0,114,0,88,0,89,0,88,0,113,0,115,0,88,0,115,0,51,0,115,0,113,0,111,0,115,0,111,0,74,0,116,0,117,0,118,0,116,0,118,0,119,0,118,0,117,0,120,0,118,0,120,0,121,0,120,0,117,0,122,0,120,0,122,0,123,0,122,0,117,0,116,0,122,0,116,0,124,0,106,0,125,0,126,0,106,0,126,0,103,0,126,0,125,0,90,0,126,0,90,0,93,0,90,0,125,0,127,0,90,0,127,0,87,0,127,0,125,0,106,0,127,0,106,0,108,0,128,0,129,0,130,0,128,0,130,0,131,0,132,0,133,0,129,0,132,0,129,0,128,0,132,0,128,0,134,0,132,0,134,0,135,0,134,0,128,0,131,0,134,0,131,0,136,0,131,0,130,0,137,0,131,0,137,0,138,0,131,0,138,0,139,0,131,0,139,0,136,0,139,0,138,0,140,0,139,0,140,0,141,0,138,0,137,0,142,0,138,0,142,0,140,0,140,0,142,0,143,0,140,0,143,0,144,0,140,0,144,0,145,0,140,0,145,0,141,0,146,0,145,0,144,0,146,0,144,0,147,0,148,0,147,0,144,0,148,0,144,0,143,0,149,0,150,0,133,0,149,0,133,0,132,0,147,0,148,0,150,0,147,0,150,0,149,0,147,0,149,0,151,0,147,0,151,0,146,0,151,0,149,0,132,0,151,0,132,0,135,0,152,0,153,0,154,0,152,0,154,0,155,0,156,0,157,0,153,0,156,0,153,0,152,0,152,0,158,0,159,0,152,0,159,0,156,0,155,0,160,0,158,0,155,0,158,0,152,0,155,0,154,0,161,0,155,0,161,0,162,0,162,0,163,0,160,0,162,0,160,0,155,0,164,0,165,0,163,0,164,0,163,0,162,0,162,0,161,0,166,0,162,0,166,0,164,0,164,0,166,0,167,0,164,0,167,0,168,0,165,0,164,0,168,0,165,0,168,0,169,0,170,0,171,0,169,0,170,0,169,0,168,0,172,0,170,0,168,0,172,0,168,0,167,0,173,0,174,0,157,0,173,0,157,0,156,0,170,0,172,0,174,0,170,0,174,0,173,0,173,0,175,0,171,0,173,0,171,0,170,0,156,0,159,0,175,0,156,0,175,0,173,0,176,0,177,0,31,0,176,0,31,0,33,0,31,0,177,0,178,0,31,0,178,0,32,0,177,0,179,0,180,0,177,0,180,0,178,0,176,0,181,0,179,0,176,0,179,0,177,0,25,0,182,0,176,0,25,0,176,0,33,0,182,0,183,0,181,0,182,0,181,0,176,0,184,0,185,0,183,0,184,0,183,0,182,0,184,0,182,0,25,0,184,0,25,0,28,0,27,0,186,0,184,0,27,0,184,0,28,0,185,0,184,0,186,0,185,0,186,0,187,0,188,0,189,0,187,0,188,0,187,0,186,0,188,0,186,0,27,0,188,0,27,0,30,0,178,0,190,0,29,0,178,0,29,0,32,0,29,0,190,0,188,0,29,0,188,0,30,0,190,0,191,0,189,0,190,0,189,0,188,0,178,0,180,0,191,0,178,0,191,0,190,0,192,0,193,0,194,0,192,0,194,0,195,0,196,0,197,0,193,0,196,0,193,0,192,0,196,0,192,0,198,0,196,0,198,0,199,0,198,0,192,0,195,0,198,0,195,0,200,0,201,0,202,0,203,0,201,0,203,0,204,0,195,0,194,0,202,0,195,0,202,0,201,0,195,0,201,0,205,0,195,0,205,0,200,0,205,0,201,0,204,0,205,0,204,0,206,0,204,0,203,0,207,0,204,0,207,0,208,0,204,0,208,0,209,0,204,0,209,0,206,0,210,0,209,0,208,0,210,0,208,0,211,0,212,0,211,0,208,0,212,0,208,0,207,0,213,0,214,0,197,0,213,0,197,0,196,0,211,0,212,0,214,0,211,0,214,0,213,0,211,0,213,0,215,0,211,0,215,0,210,0,215,0,213,0,196,0,215,0,196,0,199,0,216,0,217,0,218,0,216,0,218,0,219,0,219,0,220,0,221,0,219,0,221,0,216,0,222,0,223,0,220,0,222,0,220,0,219,0,219,0,218,0,224,0,219,0,224,0,222,0,225,0,226,0,217,0,225,0,217,0,216,0,227,0,228,0,226,0,227,0,226,0,225,0,225,0,229,0,230,0,225,0,230,0,227,0,216,0,221,0,229,0,216,0,229,0,225,0,228,0,227,0,231,0,228,0,231,0,232,0,233,0,234,0,232,0,233,0,232,0,231,0,235,0,233,0,231,0,235,0,231,0,236,0,227,0,230,0,236,0,227,0,236,0,231,0,222,0,224,0,237,0,222,0,237,0,238,0,238,0,239,0,223,0,238,0,223,0,222,0,233,0,235,0,239,0,233,0,239,0,238,0,238,0,237,0,234,0,238,0,234,0,233,0,240,0,241,0,62,0,240,0,62,0,64,0,62,0,241,0,242,0,62,0,242,0,63,0,241,0,243,0,244,0,241,0,244,0,242,0,240,0,245,0,243,0,240,0,243,0,241,0,56,0,246,0,240,0,56,0,240,0,64,0,246,0,247,0,245,0,246,0,245,0,240,0,248,0,249,0,247,0,248,0,247,0,246,0,248,0,246,0,56,0,248,0,56,0,59,0,58,0,250,0,248,0,58,0,248,0,59,0,249,0,248,0,250,0,249,0,250,0,251,0,252,0,253,0,251,0,252,0,251,0,250,0,252,0,250,0,58,0,252,0,58,0,61,0,60,0,254,0,252,0,60,0,252,0,61,0,254,0,255,0,253,0,254,0,253,0,252,0,242,0,244,0,255,0,242,0,255,0,254,0,242,0,254,0,60,0,242,0,60,0,63,0,256,0,257,0,258,0,256,0,258,0,259,0,260,0,261,0,257,0,260,0,257,0,256,0,262,0,263,0,264,0,262,0,264,0,265,0,264,0,263,0,266,0,264,0,266,0,267,0,268,0,269,0,270,0,268,0,270,0,271,0,259,0,258,0,269,0,259,0,269,0,268,0,266,0,272,0,273,0,266,0,273,0,267,0,273,0,272,0,274,0,273,0,274,0,275,0,274,0,276,0,277,0,274,0,277,0,275,0,277,0,276,0,278,0,277,0,278,0,279,0,280,0,281,0,282,0,280,0,282,0,283,0,271,0,270,0,283,0,271,0,283,0,282,0,281,0,280,0,284,0,281,0,284,0,285,0,278,0,286,0,287,0,278,0,287,0,279,0,287,0,286,0,262,0,287,0,262,0,265,0,285,0,284,0,261,0,285,0,261,0,260,0,288,0,289,0,290,0,288,0,290,0,291,0,291,0,292,0,293,0,291,0,293,0,288,0,294,0,295,0,292,0,294,0,292,0,291,0,291,0,290,0,296,0,291,0,296,0,294,0,297,0,298,0,299,0,297,0,299,0,300,0,300,0,301,0,302,0,300,0,302,0,297,0,288,0,293,0,301,0,288,0,301,0,300,0,300,0,299,0,289,0,300,0,289,0,288,0,298,0,297,0,303,0,298,0,303,0,304,0,305,0,306,0,304,0,305,0,304,0,303,0,307,0,305,0,303,0,307,0,303,0,308,0,297,0,302,0,308,0,297,0,308,0,303,0,309,0,310,0,306,0,309,0,306,0,305,0,294,0,296,0,310,0,294,0,310,0,309,0,309,0,311,0,295,0,309,0,295,0,294,0,305,0,307,0,311,0,305,0,311,0,309,0,312,0,313,0,100,0,312,0,100,0,102,0,100,0,313,0,314,0,100,0,314,0,101,0,313,0,315,0,316,0,313,0,316,0,314,0,312,0,317,0,315,0,312,0,315,0,313,0,318,0,319,0,94,0,318,0,94,0,97,0,94,0,319,0,312,0,94,0,312,0,102,0,319,0,320,0,317,0,319,0,317,0,312,0,318,0,321,0,320,0,318,0,320,0,319,0,96,0,322,0,318,0,96,0,318,0,97,0,321,0,318,0,322,0,321,0,322,0,323,0,324,0,325,0,323,0,324,0,323,0,322,0,324,0,322,0,96,0,324,0,96,0,99,0,98,0,326,0,324,0,98,0,324,0,99,0,326,0,327,0,325,0,326,0,325,0,324,0,314,0,316,0,327,0,314,0,327,0,326,0,314,0,326,0,98,0,314,0,98,0,101,0,328,0,329,0,45,0,328,0,45,0,20,0,45,0,329,0,330,0,45,0,330,0,43,0,330,0,329,0,331,0,330,0,331,0,332,0,331,0,329,0,328,0,331,0,328,0,333,0,73,0,334,0,335,0,73,0,335,0,74,0,335,0,334,0,336,0,335,0,336,0,337,0,336,0,334,0,330,0,336,0,330,0,332,0,330,0,334,0,73,0,330,0,73,0,43,0,335,0,338,0,115,0,335,0,115,0,74,0,115,0,338,0,339,0,115,0,339,0,51,0,339,0,338,0,340,0,339,0,340,0,341,0,340,0,338,0,335,0,340,0,335,0,337,0,339,0,342,0,50,0,339,0,50,0,51,0,50,0,342,0,328,0,50,0,328,0,20,0,328,0,342,0,343,0,328,0,343,0,333,0,343,0,342,0,339,0,343,0,339,0,341,0,344,0,345,0,343,0,344,0,343,0,341,0,343,0,345,0,346,0,343,0,346,0,333,0,346,0,345,0,347,0,346,0,347,0,348,0,347,0,345,0,344,0,347,0,344,0,349,0,346,0,350,0,331,0,346,0,331,0,333,0,331,0,350,0,351,0,331,0,351,0,332,0,351,0,350,0,352,0,351,0,352,0,353,0,352,0,350,0,346,0,352,0,346,0,348,0,336,0,354,0,355,0,336,0,355,0,337,0,355,0,354,0,356,0,355,0,356,0,357,0,356,0,354,0,351,0,356,0,351,0,353,0,351,0,354,0,336,0,351,0,336,0,332,0,358,0,359,0,355,0,358,0,355,0,357,0,355,0,359,0,340,0,355,0,340,0,337,0,340,0,359,0,344,0,340,0,344,0,341,0,344,0,359,0,358,0,344,0,358,0,349,0,360,0,361,0,362,0,360,0,362,0,363,0,362,0,361,0,347,0,362,0,347,0,349,0,347,0,361,0,364,0,347,0,364,0,348,0,364,0,361,0,360,0,364,0,360,0,365,0,366,0,367,0,364,0,366,0,364,0,365,0,364,0,367,0,352,0,364,0,352,0,348,0,352,0,367,0,368,0,352,0,368,0,353,0,368,0,367,0,366,0,368,0,366,0,369,0,370,0,371,0,372,0,370,0,372,0,373,0,372,0,371,0,368,0,372,0,368,0,369,0,368,0,371,0,356,0,368,0,356,0,353,0,356,0,371,0,370,0,356,0,370,0,357,0,370,0,374,0,358,0,370,0,358,0,357,0,358,0,374,0,362,0,358,0,362,0,349,0,362,0,374,0,375,0,362,0,375,0,363,0,375,0,374,0,370,0,375,0,370,0,373,0,79,0,376,0,377,0,79,0,377,0,80,0,377,0,376,0,360,0,377,0,360,0,363,0,360,0,376,0,378,0,360,0,378,0,365,0,378,0,376,0,79,0,378,0,79,0,82,0,81,0,379,0,378,0,81,0,378,0,82,0,378,0,379,0,366,0,378,0,366,0,365,0,366,0,379,0,380,0,366,0,380,0,369,0,380,0,379,0,81,0,380,0,81,0,83,0,381,0,382,0,75,0,381,0,75,0,78,0,75,0,382,0,380,0,75,0,380,0,83,0,380,0,382,0,372,0,380,0,372,0,369,0,372,0,382,0,381,0,372,0,381,0,373,0,381,0,383,0,375,0,381,0,375,0,373,0,375,0,383,0,377,0,375,0,377,0,363,0,377,0,383,0,77,0,377,0,77,0,80,0,77,0,383,0,381,0,77,0,381,0,78,0,384,0,385,0,386,0,384,0,386,0,387,0,388,0,389,0,387,0,388,0,387,0,386,0,390,0,391,0,392,0,390,0,392,0,393,0,388,0,393,0,392,0,388,0,392,0,389,0,394,0,395,0,396,0,394,0,396,0,397,0,390,0,397,0,396,0,390,0,396,0,391,0,398,0,399,0,395,0,398,0,395,0,394,0,384,0,399,0,398,0,384,0,398,0,385,0,400,0,401,0,402,0,400,0,402,0,403,0,404,0,405,0,406,0,404,0,406,0,407,0,408,0,409,0,410,0,408,0,410,0,411,0,412,0,413,0,414,0,412,0,414,0,415,0,416,0,417,0,120,0,416,0,120,0,123,0,120,0,417,0,418,0,120,0,418,0,121,0,418,0,417,0,419,0,418,0,419,0,420,0,419,0,417,0,416,0,419,0,416,0,421,0,422,0,423,0,122,0,422,0,122,0,124,0,122,0,423,0,416,0,122,0,416,0,123,0,416,0,423,0,424,0,416,0,424,0,421,0,424,0,423,0,422,0,424,0,422,0,425,0,116,0,426,0,422,0,116,0,422,0,124,0,422,0,426,0,427,0,422,0,427,0,425,0,427,0,426,0,428,0,427,0,428,0,429,0,428,0,426,0,116,0,428,0,116,0,119,0,118,0,430,0,428,0,118,0,428,0,119,0,428,0,430,0,431,0,428,0,431,0,429,0,431,0,430,0,418,0,431,0,418,0,420,0,418,0,430,0,118,0,418,0,118,0,121,0,325,0,432,0,433,0,325,0,433,0,323,0,327,0,434,0,432,0,327,0,432,0,325,0,316,0,435,0,434,0,316,0,434,0,327,0,315,0,436,0,435,0,315,0,435,0,316,0,317,0,437,0,436,0,317,0,436,0,315,0,320,0,438,0,437,0,320,0,437,0,317,0,321,0,439,0,438,0,321,0,438,0,320,0,433,0,439,0,321,0,433,0,321,0,323,0,302,0,439,0,433,0,302,0,433,0,308,0,301,0,438,0,439,0,301,0,439,0,302,0,293,0,437,0,438,0,293,0,438,0,301,0,292,0,436,0,437,0,292,0,437,0,293,0,295,0,435,0,436,0,295,0,436,0,292,0,311,0,434,0,435,0,311,0,435,0,295,0,307,0,432,0,434,0,307,0,434,0,311,0,433,0,432,0,307,0,433,0,307,0,308,0,306,0,440,0,441,0,306,0,441,0,304,0,310,0,442,0,440,0,310,0,440,0,306,0,296,0,443,0,442,0,296,0,442,0,310,0,290,0,444,0,443,0,290,0,443,0,296,0,289,0,445,0,444,0,289,0,444,0,290,0,299,0,446,0,445,0,299,0,445,0,289,0,298,0,447,0,446,0,298,0,446,0,299,0,441,0,447,0,298,0,441,0,298,0,304,0,270,0,447,0,441,0,270,0,441,0,283,0,269,0,446,0,447,0,269,0,447,0,270,0,258,0,445,0,446,0,258,0,446,0,269,0,257,0,444,0,445,0,257,0,445,0,258,0,261,0,443,0,444,0,261,0,444,0,257,0,284,0,442,0,443,0,284,0,443,0,261,0,280,0,440,0,442,0,280,0,442,0,284,0,441,0,440,0,280,0,441,0,280,0,283,0,253,0,448,0,449,0,253,0,449,0,251,0,255,0,450,0,448,0,255,0,448,0,253,0,244,0,451,0,450,0,244,0,450,0,255,0,243,0,452,0,451,0,243,0,451,0,244,0,245,0,453,0,452,0,245,0,452,0,243,0,247,0,454,0,453,0,247,0,453,0,245,0,249,0,455,0,454,0,249,0,454,0,247,0,449,0,455,0,249,0,449,0,249,0,251,0,230,0,455,0,449,0,230,0,449,0,236,0,229,0,454,0,455,0,229,0,455,0,230,0,221,0,453,0,454,0,221,0,454,0,229,0,220,0,452,0,453,0,220,0,453,0,221,0,223,0,451,0,452,0,223,0,452,0,220,0,239,0,450,0,451,0,239,0,451,0,223,0,235,0,448,0,450,0,235,0,450,0,239,0,449,0,448,0,235,0,449,0,235,0,236,0,234,0,456,0,457,0,234,0,457,0,232,0,237,0,458,0,456,0,237,0,456,0,234,0,224,0,459,0,458,0,224,0,458,0,237,0,218,0,460,0,459,0,218,0,459,0,224,0,217,0,461,0,460,0,217,0,460,0,218,0,226,0,462,0,461,0,226,0,461,0,217,0,228,0,463,0,462,0,228,0,462,0,226,0,457,0,463,0,228,0,457,0,228,0,232,0,203,0,463,0,457,0,203,0,457,0,207,0,202,0,462,0,463,0,202,0,463,0,203,0,194,0,461,0,462,0,194,0,462,0,202,0,193,0,460,0,461,0,193,0,461,0,194,0,197,0,459,0,460,0,197,0,460,0,193,0,214,0,458,0,459,0,214,0,459,0,197,0,212,0,456,0,458,0,212,0,458,0,214,0,457,0,456,0,212,0,457,0,212,0,207,0,189,0,464,0,465,0,189,0,465,0,187,0,191,0,466,0,464,0,191,0,464,0,189,0,180,0,467,0,466,0,180,0,466,0,191,0,179,0,468,0,467,0,179,0,467,0,180,0,181,0,469,0,468,0,181,0,468,0,179,0,183,0,470,0,469,0,183,0,469,0,181,0,185,0,471,0,470,0,185,0,470,0,183,0,465,0,471,0,185,0,465,0,185,0,187,0,166,0,471,0,465,0,166,0,465,0,167,0,161,0,470,0,471,0,161,0,471,0,166,0,154,0,469,0,470,0,154,0,470,0,161,0,153,0,468,0,469,0,153,0,469,0,154,0,157,0,467,0,468,0,157,0,468,0,153,0,174,0,466,0,467,0,174,0,467,0,157,0,172,0,464,0,466,0,172,0,466,0,174,0,465,0,464,0,172,0,465,0,172,0,167,0,171,0,472,0,473,0,171,0,473,0,169,0,175,0,474,0,472,0,175,0,472,0,171,0,159,0,475,0,474,0,159,0,474,0,175,0,158,0,476,0,475,0,158,0,475,0,159,0,160,0,477,0,476,0,160,0,476,0,158,0,163,0,478,0,477,0,163,0,477,0,160,0,165,0,479,0,478,0,165,0,478,0,163,0,473,0,479,0,165,0,473,0,165,0,169,0,142,0,479,0,473,0,142,0,473,0,143,0,137,0,478,0,479,0,137,0,479,0,142,0,130,0,477,0,478,0,130,0,478,0,137,0,129,0,476,0,477,0,129,0,477,0,130,0,133,0,475,0,476,0,133,0);
    }
    private static void method14(){
        MESH_3.getFaces().addAll(476,0,129,0,150,0,474,0,475,0,150,0,475,0,133,0,148,0,472,0,474,0,148,0,474,0,150,0,473,0,472,0,148,0,473,0,148,0,143,0,404,0,411,0,410,0,404,0,410,0,405,0,400,0,407,0,406,0,400,0,406,0,401,0,412,0,415,0,403,0,412,0,403,0,402,0,414,0,413,0,409,0,414,0,409,0,408,0,480,0,410,0,409,0,480,0,409,0,481,0,413,0,482,0,481,0,413,0,481,0,409,0,482,0,413,0,412,0,482,0,412,0,483,0,402,0,484,0,483,0,402,0,483,0,412,0,484,0,402,0,401,0,484,0,401,0,485,0,406,0,486,0,485,0,406,0,485,0,401,0,486,0,406,0,405,0,486,0,405,0,487,0,410,0,480,0,487,0,410,0,487,0,405,0,384,0,387,0,84,0,384,0,84,0,87,0,84,0,387,0,389,0,84,0,389,0,89,0,392,0,114,0,89,0,392,0,89,0,389,0,114,0,392,0,391,0,114,0,391,0,112,0,396,0,110,0,112,0,396,0,112,0,391,0,110,0,396,0,395,0,110,0,395,0,108,0,399,0,127,0,108,0,399,0,108,0,395,0,127,0,399,0,384,0,127,0,384,0,87,0,429,0,408,0,411,0,429,0,411,0,427,0,425,0,427,0,411,0,425,0,411,0,404,0,425,0,404,0,407,0,425,0,407,0,424,0,421,0,424,0,407,0,421,0,407,0,400,0,421,0,400,0,403,0,421,0,403,0,419,0,415,0,420,0,419,0,415,0,419,0,403,0,414,0,431,0,420,0,414,0,420,0,415,0,429,0,431,0,414,0,429,0,414,0,408,0,487,0,488,0,489,0,487,0,489,0,486,0,486,0,489,0,490,0,486,0,490,0,485,0,485,0,490,0,491,0,485,0,491,0,484,0,484,0,491,0,492,0,484,0,492,0,483,0,483,0,492,0,493,0,483,0,493,0,482,0,482,0,493,0,494,0,482,0,494,0,481,0,481,0,494,0,495,0,481,0,495,0,480,0,488,0,487,0,480,0,488,0,480,0,495,0,494,0,394,0,397,0,494,0,397,0,495,0,488,0,495,0,397,0,488,0,397,0,390,0,488,0,390,0,393,0,488,0,393,0,489,0,490,0,489,0,393,0,490,0,393,0,388,0,490,0,388,0,386,0,490,0,386,0,491,0,385,0,492,0,491,0,385,0,491,0,386,0,398,0,493,0,492,0,398,0,492,0,385,0,494,0,493,0,398,0,494,0,398,0,394,0,68,0,104,0,277,0,68,0,277,0,279,0,496,0,65,0,68,0,496,0,68,0,279,0,37,0,65,0,496,0,37,0,496,0,497,0,498,0,34,0,37,0,498,0,37,0,497,0,12,0,34,0,498,0,12,0,498,0,499,0,500,0,9,0,12,0,500,0,12,0,499,0,14,0,9,0,500,0,14,0,500,0,501,0,502,0,23,0,14,0,502,0,14,0,501,0,24,0,23,0,502,0,24,0,502,0,503,0,504,0,54,0,24,0,504,0,24,0,503,0,55,0,54,0,504,0,55,0,504,0,265,0,264,0,92,0,55,0,264,0,55,0,265,0,93,0,92,0,264,0,93,0,264,0,267,0,273,0,126,0,93,0,273,0,93,0,267,0,103,0,126,0,273,0,103,0,273,0,275,0,277,0,104,0,103,0,277,0,103,0,275,0,271,0,282,0,276,0,271,0,276,0,274,0,278,0,276,0,282,0,278,0,282,0,281,0,281,0,285,0,286,0,281,0,286,0,278,0,262,0,286,0,285,0,262,0,285,0,260,0,260,0,256,0,263,0,260,0,263,0,262,0,266,0,263,0,256,0,266,0,256,0,259,0,259,0,268,0,272,0,259,0,272,0,266,0,274,0,272,0,268,0,274,0,268,0,271,0,206,0,209,0,496,0,206,0,496,0,279,0,287,0,205,0,206,0,287,0,206,0,279,0,200,0,205,0,287,0,200,0,287,0,265,0,504,0,198,0,200,0,504,0,200,0,265,0,199,0,198,0,504,0,199,0,504,0,503,0,505,0,215,0,199,0,505,0,199,0,503,0,210,0,215,0,505,0,210,0,505,0,497,0,496,0,209,0,210,0,496,0,210,0,497,0,141,0,145,0,498,0,141,0,498,0,497,0,505,0,139,0,141,0,505,0,141,0,497,0,136,0,139,0,505,0,136,0,505,0,503,0,502,0,134,0,136,0,502,0,136,0,503,0,135,0,134,0,502,0,135,0,502,0,501,0,500,0,151,0,135,0,500,0,135,0,501,0,146,0,151,0,500,0,146,0,500,0,499,0,498,0,145,0,146,0,498,0,146,0,499,0);
    }
    private static void method15(){
        MESH_3.getFaceSmoothingGroups().ensureCapacity(1008);
        MESH_3.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_5 = MESHVIEWS[4];
        MESHVIEWS[4].setId("hat_king");
        MESHVIEWS[4].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_4 = new PhongMaterial();
        MATERIAL_4.setDiffuseColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_4.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_4.setSpecularPower(18.0);
        MESHVIEWS[4].setMaterial(MATERIAL_4);
        MESH_4 = new TriangleMesh();
        MESHVIEWS[4].setMesh(MESH_4);
        MESH_4.getPoints().ensureCapacity(2142);
        MESH_4.getPoints().addAll(0.627315f,60.540787f,1.197984f,1.264677f,60.54158f,1.141672f,1.262527f,61.179596f,1.197984f,0.620535f,61.184597f,1.207295f,1.262402f,61.805206f,1.213349f,0.620468f,61.805126f,1.215084f,0.0f,61.805088f,1.216057f,0.0f,61.184273f,1.215084f,0.0f,60.540188f,1.213349f,1.262527f,62.42899f,1.197984f,1.264677f,63.06028f,1.141672f,0.627315f,63.057465f,1.197984f,0.620535f,62.42329f,1.207295f,0.0f,63.05707f,1.213349f,0.0f,62.42309f,1.215084f,-0.627315f,63.057465f,1.197984f,-1.264677f,63.06028f,1.141672f,-1.262527f,62.42899f,1.197984f,-0.620535f,62.42329f,1.207295f,-1.262402f,61.805206f,1.213349f,-0.620468f,61.805126f,1.215084f,-1.262527f,61.179596f,1.197984f,-1.264677f,60.54158f,1.141672f,-0.627315f,60.540787f,1.197984f,-0.620535f,61.184597f,1.207295f,0.876588f,66.0039f,1.078593f,1.591834f,65.924934f,1.017797f,1.700058f,66.0039f,0.556786f,0.901444f,66.109055f,0.566252f,1.731969f,66.02795f,-1.0E-5f,0.917934f,66.13715f,-1.0E-5f,-0.0f,66.16833f,-1.0E-5f,-0.0f,66.13715f,0.575718f,-0.0f,66.02795f,1.097102f,1.700058f,66.0039f,-0.556806f,1.591834f,65.924934f,-1.017817f,0.876588f,66.0039f,-1.078613f,0.901444f,66.109055f,-0.566272f,-0.0f,66.02795f,-1.097122f,0.0f,66.13715f,-0.575738f,-0.876588f,66.0039f,-1.078613f,-1.591834f,65.924934f,-1.017817f,-1.700058f,66.0039f,-0.556806f,-0.901444f,66.109055f,-0.566272f,-1.731969f,66.02795f,-1.0E-5f,-0.917934f,66.13715f,-1.0E-5f,-1.700058f,66.0039f,0.556786f,-1.591834f,65.924934f,1.017797f,-0.876588f,66.0039f,1.078593f,-0.901444f,66.109055f,0.566252f,0.627315f,63.057465f,-1.198004f,1.264677f,63.06028f,-1.141692f,1.262527f,62.42899f,-1.198004f,0.620535f,62.42329f,-1.207315f,1.262402f,61.805206f,-1.213369f,0.620468f,61.805126f,-1.215104f,0.0f,61.805088f,-1.216077f,0.0f,62.42309f,-1.215104f,0.0f,63.05707f,-1.213369f,1.262527f,61.179596f,-1.198004f,1.264677f,60.54158f,-1.141692f,0.627315f,60.540787f,-1.198004f,0.620535f,61.184597f,-1.207315f,0.0f,60.540188f,-1.213369f,0.0f,61.184273f,-1.215104f,-0.627315f,60.540787f,-1.198004f,-1.264677f,60.54158f,-1.141692f,-1.262527f,61.179596f,-1.198004f,-0.620535f,61.184597f,-1.207315f,-1.262402f,61.805206f,-1.213369f,-0.620468f,61.805126f,-1.215104f,-1.262527f,62.42899f,-1.198004f,-1.264677f,63.06028f,-1.141692f,-0.627315f,63.057465f,-1.198004f,-0.620535f,62.42329f,-1.207315f,4.412835f,60.200813f,-0.556806f,4.328201f,60.30175f,-1.017817f,4.412835f,60.97796f,-1.078613f,4.52555f,60.95546f,-0.566272f,4.438602f,61.80543f,-1.097122f,4.55567f,61.80542f,-0.575738f,4.589085f,61.80542f,-1.0E-5f,4.55567f,60.940052f,-1.0E-5f,4.438602f,60.170963f,-1.0E-5f,4.412835f,62.632885f,-1.078613f,4.328201f,63.309082f,-1.017817f,4.412835f,63.41004f,-0.556806f,4.52555f,62.655384f,-0.566272f,4.438602f,63.439884f,-1.0E-5f,4.55567f,62.67081f,-1.0E-5f,4.412835f,63.410027f,0.556786f,4.328201f,63.309082f,1.017797f,4.412835f,62.632885f,1.078593f,4.52555f,62.655384f,0.566252f,4.438602f,61.80543f,1.097102f,4.55567f,61.80542f,0.575718f,4.412835f,60.97796f,1.078593f,4.328201f,60.30175f,1.017797f,4.412835f,60.200813f,0.556786f,4.52555f,60.95546f,0.566252f,-4.412835f,60.200813f,0.556786f,-4.328201f,60.30175f,1.017797f,-4.412835f,60.97796f,1.078593f,-4.52555f,60.95546f,0.566252f,-4.438602f,61.80543f,1.097102f,-4.55567f,61.80542f,0.575718f,-4.589085f,61.80542f,-1.0E-5f,-4.55567f,60.940052f,-1.0E-5f,-4.438602f,60.170963f,-1.0E-5f,-4.412835f,62.632885f,1.078593f,-4.328201f,63.309082f,1.017797f,-4.412835f,63.41004f,0.556786f,-4.52555f,62.655384f,0.566252f,-4.438602f,63.439884f,-1.0E-5f,-4.55567f,62.67081f,-1.0E-5f,-4.412835f,63.410027f,-0.556806f,-4.328201f,63.309082f,-1.017817f,-4.412835f,62.632885f,-1.078613f,-4.52555f,62.655384f,-0.566272f,-4.438602f,61.80543f,-1.097122f,-4.55567f,61.80542f,-0.575738f,-4.412835f,60.97796f,-1.078613f,-4.328201f,60.30175f,-1.017817f,-4.412835f,60.200813f,-0.556806f,-4.52555f,60.95546f,-0.566272f,1.375736f,60.431656f,-0.587963f,2.078237f,60.52093f,-1.11129f,2.096045f,60.4187f,-0.583581f,2.906295f,60.419502f,-1.100098f,2.908603f,60.312294f,-0.577469f,2.910416f,60.28162f,-1.0E-5f,2.111867f,60.38775f,-1.0E-5f,1.406395f,60.401363f,-1.0E-5f,3.6996f,60.208725f,-0.566272f,3.686422f,60.321205f,-1.078613f,3.712777f,60.177986f,-1.0E-5f,3.686422f,60.321205f,1.078593f,3.699599f,60.208725f,0.566252f,2.906295f,60.419502f,1.100078f,2.908604f,60.312294f,0.577449f,2.078237f,60.52093f,1.11127f,1.375736f,60.431656f,0.587943f,2.096045f,60.4187f,0.583561f,2.078237f,63.08765f,-1.11129f,2.076184f,62.47829f,-1.192102f,2.906295f,63.191128f,-1.100098f,2.906618f,62.532703f,-1.184468f,2.907437f,61.805393f,-1.208366f,2.076117f,61.805313f,-1.212061f,3.6996f,62.584564f,-1.15958f,3.686422f,63.28964f,-1.078613f,3.712777f,61.80542f,-1.181216f,3.699599f,61.026276f,-1.15958f,2.906618f,61.078033f,-1.184468f,2.076184f,61.131416f,-1.192102f,1.375736f,63.166595f,0.587943f,2.078237f,63.08765f,1.11127f,2.096045f,63.189175f,0.583561f,2.906295f,63.191128f,1.100078f,2.908603f,63.298264f,0.577449f,2.910416f,63.32888f,-1.0E-5f,2.111867f,63.219604f,-1.0E-5f,1.406395f,63.195885f,-1.0E-5f,3.6996f,63.402122f,0.566252f,3.686422f,63.28964f,1.078593f,3.712777f,63.432865f,-1.0E-5f,3.699599f,63.402126f,-0.566272f,2.908604f,63.298264f,-0.577469f,1.375736f,63.166595f,-0.587963f,2.096045f,63.189175f,-0.583581f,2.076184f,61.131397f,1.192082f,2.906618f,61.078022f,1.184448f,2.907437f,61.805393f,1.208346f,2.076117f,61.805305f,1.212041f,3.6996f,61.026276f,1.15956f,3.712777f,61.80542f,1.181196f,3.699599f,62.584564f,1.15956f,2.906618f,62.532703f,1.184448f,2.076184f,62.47829f,1.192082f,-1.375736f,60.431656f,0.587943f,-2.078237f,60.52093f,1.11127f,-2.096045f,60.4187f,0.583561f,-2.906295f,60.419502f,1.100078f,-2.908603f,60.312294f,0.577449f,-2.910416f,60.28162f,-1.0E-5f,-2.111867f,60.38775f,-1.0E-5f,-1.406395f,60.401363f,-1.0E-5f,-3.6996f,60.208725f,0.566252f,-3.686422f,60.321205f,1.078593f,-3.712777f,60.177986f,-1.0E-5f,-3.686422f,60.321205f,-1.078613f,-3.699599f,60.208725f,-0.566272f,-2.906295f,60.419502f,-1.100098f,-2.908604f,60.312294f,-0.577469f,-2.078237f,60.52093f,-1.11129f,-1.375736f,60.431656f,-0.587963f,-2.096045f,60.4187f,-0.583581f,-2.078237f,63.08765f,1.11127f,-2.076184f,62.47829f,1.192082f,-2.906295f,63.191128f,1.100078f,-2.906618f,62.532703f,1.184448f,-2.907437f,61.805393f,1.208346f,-2.076117f,61.805313f,1.212041f,-3.6996f,62.584564f,1.15956f,-3.686422f,63.28964f,1.078593f,-3.712777f,61.80542f,1.181196f,-3.699599f,61.026276f,1.15956f,-2.906618f,61.078033f,1.184448f,-2.076184f,61.131416f,1.192082f,-1.375736f,63.166595f,-0.587963f,-2.078237f,63.08765f,-1.11129f,-2.096045f,63.189175f,-0.583581f,-2.906295f,63.191128f,-1.100098f,-2.908603f,63.298264f,-0.577469f,-2.910416f,63.32888f,-1.0E-5f,-2.111867f,63.219604f,-1.0E-5f,-1.406395f,63.195885f,-1.0E-5f,-3.6996f,63.402122f,-0.566272f,-3.686422f,63.28964f,-1.078613f,-3.712777f,63.432865f,-1.0E-5f,-3.699599f,63.402126f,0.566252f,-2.908604f,63.298264f,0.577449f,-1.375736f,63.166595f,0.587943f,-2.096045f,63.189175f,0.583561f,-2.076184f,61.131397f,-1.192102f,-2.906618f,61.078022f,-1.184468f,-2.907437f,61.805393f,-1.208366f,-2.076117f,61.805305f,-1.212061f,-3.6996f,61.026276f,-1.15958f,-3.712777f,61.80542f,-1.181216f,-3.699599f,62.584564f,-1.15958f,-2.906618f,62.532703f,-1.184468f,-2.076184f,62.47829f,-1.192102f,1.310539f,63.82424f,1.11127f,0.687671f,63.822117f,1.192082f,1.437264f,64.59825f,1.100078f,0.754324f,64.59854f,1.184448f,0.0f,64.59928f,1.208346f,0.0f,63.821926f,1.212041f,0.817778f,65.33851f,1.15956f,1.557825f,65.32622f,1.078593f,0.0f,65.35079f,1.181196f,-1.557825f,65.32622f,1.078593f,-0.817778f,65.33849f,1.15956f,-1.437264f,64.59825f,1.100078f,-0.754324f,64.59854f,1.184448f,-1.310539f,63.82424f,1.11127f,-0.687671f,63.822117f,1.192082f,1.310539f,63.82424f,-1.11129f,1.41498f,63.841267f,-0.583581f,1.437264f,64.59825f,-1.100098f,1.548437f,64.60044f,-0.577469f,1.580248f,64.602165f,-1.0E-5f,1.446691f,63.856377f,-1.0E-5f,1.676029f,65.33851f,-0.566272f,1.557825f,65.32622f,-1.078613f,1.708408f,65.35079f,-1.0E-5f,1.676029f,65.33849f,0.566252f,1.548437f,64.60044f,0.577449f,1.41498f,63.841267f,0.583561f,-1.310539f,63.82424f,-1.11129f,-0.687671f,63.822117f,-1.192102f,-1.437264f,64.59825f,-1.100098f,-0.754324f,64.59854f,-1.184468f,0.0f,64.59928f,-1.208366f,0.0f,63.821926f,-1.212061f,-0.817778f,65.33851f,-1.15958f,-1.557825f,65.32622f,-1.078613f,0.0f,65.35079f,-1.181216f,0.817778f,65.33849f,-1.15958f,0.754324f,64.59854f,-1.184468f,0.687671f,63.822117f,-1.192102f,-1.41498f,63.841267f,0.583561f,-1.548437f,64.60044f,0.577449f,-1.580248f,64.602165f,-1.0E-5f,-1.446691f,63.856377f,-1.0E-5f,-1.676029f,65.33851f,0.566252f,-1.708408f,65.35079f,-1.0E-5f,-1.676029f,65.33849f,-0.566272f,-1.548437f,64.60044f,-0.577469f,-1.41498f,63.841267f,-0.583581f,1.310539f,59.71166f,-1.11129f,0.687671f,59.713238f,-1.192102f,1.437264f,58.86789f,-1.100098f,0.754324f,58.867504f,-1.184468f,0.0f,58.866642f,-1.208366f,0.0f,59.71292f,-1.212061f,0.876588f,57.36344f,-1.078613f,0.817778f,58.05984f,-1.15958f,1.557825f,58.07327f,-1.078613f,1.591834f,57.363335f,-1.017817f,-0.0f,57.363434f,-1.097122f,0.0f,58.046425f,-1.181216f,-1.591834f,57.363335f,-1.017817f,-1.557825f,58.07327f,-1.078613f,-0.817778f,58.05984f,-1.15958f,-0.876588f,57.36344f,-1.078613f,-1.437264f,58.867878f,-1.100098f,-0.754324f,58.867504f,-1.184468f,-1.310539f,59.71166f,-1.11129f,-0.687671f,59.713257f,-1.192102f,1.310539f,59.71166f,1.11127f,1.41498f,59.694107f,0.583561f,1.437264f,58.86789f,1.100078f,1.548437f,58.865597f,0.577449f,1.580248f,58.863773f,-1.0E-5f,1.446691f,59.678463f,-1.0E-5f,1.700058f,57.36344f,0.556786f,1.676029f,58.05984f,0.566252f,1.557825f,58.07327f,1.078593f,1.591834f,57.363335f,1.017797f,1.731969f,57.363434f,-1.0E-5f,1.708408f,58.046425f,-1.0E-5f,1.676029f,58.05984f,-0.566272f,1.700058f,57.36344f,-0.556806f,1.548437f,58.865597f,-0.577469f,1.41498f,59.694107f,-0.583581f,-1.310539f,59.71166f,1.11127f,-0.687671f,59.713238f,1.192082f,-1.437264f,58.86789f,1.100078f,-0.754324f,58.867504f,1.184448f,0.0f,58.866642f,1.208346f,0.0f,59.71292f,1.212041f,-0.876588f,57.363384f,1.078593f,-0.817778f,58.05984f,1.15956f,-1.557825f,58.07327f,1.078593f,-1.591834f,57.363335f,1.017797f,-0.0f,57.363434f,1.097102f,0.0f,58.046425f,1.181196f,0.817778f,58.05984f,1.15956f,0.876588f,57.363384f,1.078593f,0.754324f,58.867504f,1.184448f,0.687671f,59.713257f,1.192082f,-1.41498f,59.694107f,-0.583581f,-1.548437f,58.865597f,-0.577469f,-1.580248f,58.863773f,-1.0E-5f,-1.446691f,59.678463f,-1.0E-5f,-1.700058f,57.363384f,-0.556806f,-1.676029f,58.05984f,-0.566272f,-1.731969f,57.363434f,-1.0E-5f,-1.708408f,58.046425f,-1.0E-5f,-1.676029f,58.05984f,0.566252f,-1.700058f,57.363384f,0.556786f,-1.548437f,58.865597f,0.577449f,-1.41498f,59.694107f,0.583561f,6.036999f,56.85225f,-1.0E-5f,5.577459f,56.85225f,2.310249f,7.711711f,56.18663f,3.194285f,8.347095f,56.18663f,-1.0E-5f,4.268803f,56.85225f,4.268793f,5.902288f,56.18663f,5.902277f,2.310259f,56.85225f,5.577449f,3.194295f,56.18663f,7.711701f,-0.0f,56.85225f,6.036989f,-0.0f,56.18663f,8.347085f,-2.310259f,56.85225f,5.577449f,-3.194295f,56.18663f,7.711701f,-4.268803f,56.85225f,4.268793f,-5.902288f,56.18663f,5.902277f,-5.577459f,56.85225f,2.310249f,-7.711711f,56.18663f,3.194285f,-6.036999f,56.85225f,-1.0E-5f,-8.347095f,56.18663f,-1.0E-5f,-5.577459f,56.85225f,-2.310269f,-7.711711f,56.18663f,-3.194305f,-4.268803f,56.85225f,-4.268813f,-5.902288f,56.18663f,-5.902298f,-2.310259f,56.85225f,-5.57747f,-3.194295f,56.18663f,-7.711721f,0.0f,56.85225f,-6.037009f,0.0f,56.18663f,-8.347105f,2.310259f,56.85225f,-5.57747f,3.194295f,56.18663f,-7.711721f,4.268803f,56.85225f,-4.268813f,5.902288f,56.18663f,-5.902298f,5.577459f,56.85225f,-2.310269f,7.711711f,56.18663f,-3.194305f,8.814345f,55.591362f,3.651012f,9.540579f,55.591362f,-1.0E-5f,6.746209f,55.591362f,6.746199f,3.651022f,55.591362f,8.814335f,-0.0f,55.591362f,9.540569f,-3.651022f,55.591362f,8.814335f,-6.746209f,55.591362f,6.746199f,-8.814345f,55.591362f,3.651012f,-9.540579f,55.591362f,-1.0E-5f,-8.814345f,55.591362f,-3.651032f,-6.746209f,55.591362f,-6.746219f,-3.651022f,55.591362f,-8.814355f,0.0f,55.591362f,-9.540589f,3.651022f,55.591362f,-8.814355f,6.746209f,55.591362f,-6.746219f,8.814345f,55.591362f,-3.651032f,9.342524f,55.348663f,3.86979f,10.112274f,55.348663f,-1.0E-5f,7.150458f,55.348663f,7.150448f,3.8698f,55.348663f,9.342514f,-0.0f,55.348663f,10.112264f,-3.8698f,55.348663f,9.342514f,-7.150458f,55.348663f,7.150448f,-9.342524f,55.348663f,3.86979f,-10.112274f,55.348663f,-1.0E-5f,-9.342524f,55.348663f,-3.86981f,-7.150458f,55.348663f,-7.150468f,-3.8698f,55.348663f,-9.342534f,0.0f,55.348663f,-10.112284f,3.8698f,55.348663f,-9.342534f,7.150458f,55.348663f,-7.150468f,9.342524f,55.348663f,-3.86981f,9.188059f,54.70145f,3.805808f,9.945083f,54.70145f,-1.0E-5f,7.032235f,54.70145f,7.032225f,3.805818f,54.70145f,9.188049f,-0.0f,54.70145f,9.945073f,-3.805818f,54.70145f,9.188049f,-7.032235f,54.70145f,7.032225f,-9.188059f,54.70145f,3.805808f,-9.945083f,54.70145f,-1.0E-5f,-9.188059f,54.70145f,-3.805828f,-7.032235f,54.70145f,-7.032245f,-3.805818f,54.70145f,-9.188069f,0.0f,54.70145f,-9.945093f,3.805818f,54.70145f,-9.188069f,7.032235f,54.70145f,-7.032245f,9.188059f,54.70145f,-3.805828f,6.267295f,46.232803f,2.595988f,6.78367f,46.232803f,-1.0E-5f,4.796779f,46.232803f,4.796769f,2.595998f,46.232803f,6.267284f,-0.0f,46.232803f,6.78366f,-2.595998f,46.232803f,6.267284f,-4.796779f,46.232803f,4.796769f,-6.267295f,46.232803f,2.595988f,-6.78367f,46.232803f,-1.0E-5f,-6.267295f,46.232803f,-2.596008f,-4.796779f,46.232803f,-4.796789f,-2.595998f,46.232803f,-6.267305f,0.0f,46.232803f,-6.78368f,2.595998f,46.232803f,-6.267305f,4.796779f,46.232803f,-4.796789f,6.267295f,46.232803f,-2.596008f,5.893919f,43.55491f,2.441331f,6.379531f,43.55491f,-1.0E-5f,4.511009f,43.55491f,4.510999f,2.441341f,43.55491f,5.893909f,-0.0f,43.55491f,6.379521f,-2.441341f,43.55491f,5.893909f,-4.511009f,43.55491f,4.510999f,-5.893919f,43.55491f,2.441331f,-6.379531f,43.55491f,-1.0E-5f,-5.893919f,43.55491f,-2.441351f,-4.511009f,43.55491f,-4.511019f,-2.441341f,43.55491f,-5.893929f,0.0f,43.55491f,-6.379541f,2.441341f,43.55491f,-5.893929f,4.511009f,43.55491f,-4.511019f,5.893919f,43.55491f,-2.441351f,6.162919f,43.198772f,2.552755f,6.670697f,43.198772f,-1.0E-5f,4.716895f,43.198772f,4.716885f,2.552765f,43.198772f,6.162909f,-0.0f,43.198772f,6.670687f,-2.552765f,43.198772f,6.162909f,-4.716895f,43.198772f,4.716885f,-6.162919f,43.198772f,2.552755f,-6.670697f,43.198772f,-1.0E-5f,-6.162919f,43.198772f,-2.552775f,-4.716895f,43.198772f,-4.716905f,-2.552765f,43.198772f,-6.16293f,0.0f,43.198772f,-6.670707f,2.552765f,43.198772f,-6.16293f,4.716895f,43.198772f,-4.716905f,6.162919f,43.198772f,-2.552775f,6.735461f,42.76518f,2.789909f,7.290411f,42.76518f,-1.0E-5f,5.155099f,42.76518f,5.155089f,2.789919f,42.76518f,6.735451f,-0.0f,42.76518f,7.290401f,-2.789919f,42.76518f,6.735451f,-5.155099f,42.76518f,5.155089f,-6.735461f,42.76518f,2.789909f,-7.290411f,42.76518f,-1.0E-5f,-6.735461f,42.76518f,-2.789929f,-5.155099f,42.76518f,-5.155109f,-2.789919f,42.76518f,-6.735471f,0.0f,42.76518f,-7.290421f,2.789919f,42.76518f,-6.735471f,5.155099f,42.76518f,-5.155109f,6.735461f,42.76518f,-2.789929f,6.735461f,42.0902f,2.789909f,7.290411f,42.0902f,-1.0E-5f,5.155099f,42.0902f,5.155089f,2.789919f,42.0902f,6.735451f,-0.0f,42.0902f,7.290401f,-2.789919f,42.0902f,6.735451f,-5.155099f,42.0902f,5.155089f,-6.735461f,42.0902f,2.789909f,-7.290411f,42.0902f,-1.0E-5f,-6.735461f,42.0902f,-2.789929f,-5.155099f,42.0902f,-5.155109f,-2.789919f,42.0902f,-6.735471f,0.0f,42.0902f,-7.290421f,2.789919f,42.0902f,-6.735471f,5.155099f,42.0902f,-5.155109f,6.735461f,42.0902f,-2.789929f,6.106229f,41.60338f,2.529273f,6.609335f,41.60338f,-1.0E-5f,4.673506f,41.60338f,4.673496f,2.529283f,41.60338f,6.106219f,-0.0f,41.60338f,6.609325f,-2.529283f,41.60338f,6.106219f,-4.673506f,41.60338f,4.673496f,-6.106229f,41.60338f,2.529273f,-6.609335f,41.60338f,-1.0E-5f,-6.106229f,41.60338f,-2.529293f,-4.673506f,41.60338f,-4.673516f,-2.529283f,41.60338f,-6.106239f,0.0f,41.60338f,-6.609345f,2.529283f,41.60338f,-6.106239f,4.673506f,41.60338f,-4.673516f,6.106229f,41.60338f,-2.529293f,5.425944f,41.112488f,2.24749f,5.872999f,41.112488f,-1.0E-5f,4.152837f,41.112488f,4.152827f,2.2475f,41.112488f,5.425934f,-0.0f,41.112488f,5.872989f,-2.2475f,41.112488f,5.425934f,-4.152837f,41.112488f,4.152827f,-5.425944f,41.112488f,2.24749f,-5.872999f,41.112488f,-1.0E-5f,-5.425944f,41.112488f,-2.24751f,-4.152837f,41.112488f,-4.152848f,-2.2475f,41.112488f,-5.425954f,0.0f,41.112488f,-5.873009f,2.2475f,41.112488f,-5.425954f,4.152837f,41.112488f,-4.152848f,5.425944f,41.112488f,-2.24751f,5.312562f,39.271645f,2.200525f,5.750277f,39.271645f,-1.0E-5f,4.066059f,39.271645f,4.066049f,2.200535f,39.271645f,5.312552f,-0.0f,39.271645f,5.750267f,-2.200535f,39.271645f,5.312552f,-4.066059f,39.271645f,4.066049f,-5.312562f,39.271645f,2.200525f,-5.750277f,39.271645f,-1.0E-5f,-5.312562f,39.271645f,-2.200546f,-4.066059f,39.271645f,-4.06607f,-2.200535f,39.271645f,-5.312572f,0.0f,39.271645f,-5.750287f,2.200535f,39.271645f,-5.312572f,4.066059f,39.271645f,-4.06607f,5.312562f,39.271645f,-2.200546f,7.183349f,38.814495f,2.97543f,7.775201f,38.814495f,-1.0E-5f,5.497897f,38.814495f,5.497887f,2.97544f,38.814495f,7.183339f,-0.0f,38.814495f,7.775191f,-2.97544f,38.814495f,7.183339f,-5.497897f,38.814495f,5.497887f,-7.183349f,38.814495f,2.97543f,-7.775201f,38.814495f,-1.0E-5f,-7.183349f,38.814495f,-2.97545f,-5.497897f,38.814495f,-5.497907f,-2.97544f,38.814495f,-7.183359f,0.0f,38.814495f,-7.775211f,2.97544f,38.814495f,-7.183359f,5.497897f,38.814495f,-5.497907f,7.183349f,38.814495f,-2.97545f,7.523492f,38.41259f,3.116323f,8.14337f,38.41259f,-1.0E-5f,5.758232f,38.41259f,5.758222f,3.116333f,38.41259f,7.523482f,-0.0f,38.41259f,8.14336f,-3.116333f,38.41259f,7.523482f,-5.758232f,38.41259f,5.758222f,-7.523492f,38.41259f,3.116323f,-8.14337f,38.41259f,-1.0E-5f,-7.523492f,38.41259f,-3.116343f,-5.758232f,38.41259f,-5.758242f,-3.116333f,38.41259f,-7.523502f,0.0f,38.41259f,-8.14338f,3.116333f,38.41259f,-7.523502f,5.758232f,38.41259f,-5.758242f,7.523492f,38.41259f,-3.116343f,7.359056f,37.798977f,3.048211f,7.965384f,37.798977f,-1.0E-5f,5.632378f,37.798977f,5.632368f,3.048221f,37.798977f,7.359046f,-0.0f,37.798977f,7.965374f,-3.048221f,37.798977f,7.359046f,-5.632378f,37.798977f,5.632368f,-7.359056f,37.798977f,3.048211f,-7.965384f,37.798977f,-1.0E-5f,-7.359056f,37.798977f,-3.048231f,-5.632378f,37.798977f,-5.632388f,-3.048221f,37.798977f,-7.359066f,0.0f,37.798977f,-7.965394f,3.048221f,37.798977f,-7.359066f,5.632378f,37.798977f,-5.632388f,7.359056f,37.798977f,-3.048231f,6.389682f,37.308083f,2.646683f,6.916142f,37.308083f,-1.0E-5f,4.890451f,37.308083f,4.890441f,2.646693f,37.308083f,6.389672f,-0.0f,37.308083f,6.916132f,-2.646693f,37.308083f,6.389672f,-4.890451f,37.308083f,4.890441f,-6.389682f,37.308083f,2.646683f,-6.916142f,37.308083f,-1.0E-5f,-6.389682f,37.308083f,-2.646703f,-4.890451f,37.308083f,-4.890461f,-2.646693f,37.308083f,-6.389692f,0.0f,37.308083f,-6.916152f,2.646693f,37.308083f,-6.389692f,4.890451f,37.308083f,-4.890461f,6.389682f,37.308083f,-2.646703f,7.126658f,37.18536f,2.951948f,7.71384f,37.18536f,-1.0E-5f,5.454508f,37.18536f,5.454498f,2.951958f,37.18536f,7.126648f,-0.0f,37.18536f,7.71383f,-2.951958f,37.18536f,7.126648f,-5.454508f,37.18536f,5.454498f,-7.126658f,37.18536f,2.951948f,-7.71384f,37.18536f,-1.0E-5f,-7.126658f,37.18536f,-2.951968f,-5.454508f,37.18536f,-5.454518f,-2.951958f,37.18536f,-7.126668f,0.0f,37.18536f,-7.71385f,2.951958f,37.18536f,-7.126668f,5.454508f,37.18536f,-5.454518f,7.126658f,37.18536f,-2.951968f,8.090397f,36.57175f,3.351142f,8.756982f,36.57175f,-1.0E-5f,6.192122f,36.57175f,6.192112f,3.351152f,36.57175f,8.090387f,-0.0f,36.57175f,8.756972f,-3.351152f,36.57175f,8.090387f,-6.192122f,36.57175f,6.192112f,-8.090397f,36.57175f,3.351142f,-8.756982f,36.57175f,-1.0E-5f,-8.090397f,36.57175f,-3.351162f,-6.192122f,36.57175f,-6.192132f,-3.351152f,36.57175f,-8.090407f,0.0f,36.57175f,-8.756992f,3.351152f,36.57175f,-8.090407f,6.192122f,36.57175f,-6.192132f,8.090397f,36.57175f,-3.351162f,8.114046f,35.000004f,3.360938f,8.78258f,35.000004f,-1.0E-5f,6.210222f,35.000004f,6.210212f,3.360948f,35.000004f,8.114036f,-0.0f,35.000004f,8.78257f,-3.360948f,35.000004f,8.114036f,-6.210222f,35.000004f,6.210212f,-8.114046f,35.000004f,3.360938f,-8.78258f,35.000004f,-1.0E-5f,-8.114046f,35.000004f,-3.360958f,-6.210222f,35.000004f,-6.210232f,-3.360948f,35.000004f,-8.114056f,0.0f,35.000004f,-8.78259f,3.360948f,35.000004f,-8.114056f,6.210222f,35.000004f,-6.210232f,8.114046f,35.000004f,-3.360958f,8.020056f,34.999996f,3.322006f,8.680846f,34.999996f,-1.0E-5f,6.138286f,34.999996f,6.138276f,3.322016f,34.999996f,8.020046f,-0.0f,34.999996f,8.680836f,-3.322016f,34.999996f,8.020046f,-6.138286f,34.999996f,6.138276f,-8.020056f,34.999996f,3.322006f,-8.680846f,34.999996f,-1.0E-5f,-8.020056f,34.999996f,-3.322026f,-6.138286f,34.999996f,-6.138296f,-3.322016f,34.999996f,-8.020066f,0.0f,34.999996f,-8.680856f,3.322016f,34.999996f,-8.020066f,6.138286f,34.999996f,-6.138296f,8.020056f,34.999996f,-3.322026f,0.0f,34.999992f,-1.0E-5f,-2.104286f,57.18969f,-2.104296f,-1.138831f,57.18969f,-2.749392f,-2.749382f,57.18969f,-1.138841f,-2.97591f,57.18969f,-1.0E-5f,-2.749382f,57.18969f,1.138821f,-2.104286f,57.18969f,2.104276f,-1.138831f,57.18969f,2.749372f,-0.0f,57.18969f,2.9759f,1.138831f,57.18969f,2.749372f,2.104286f,57.18969f,2.104276f,2.749382f,57.18969f,1.138821f,2.97591f,57.18969f,-1.0E-5f,2.749382f,57.18969f,-1.138841f,2.104286f,57.18969f,-2.104296f,1.138831f,57.18969f,-2.749392f,0.0f,57.18969f,-2.97592f,-1.783654f,57.239674f,-1.783664f,-0.965307f,57.239674f,-2.330467f,-2.330456f,57.239674f,-0.965317f,-2.522468f,57.239674f,-1.0E-5f,-2.330456f,57.239674f,0.965297f,-1.783654f,57.239674f,1.783644f,-0.965307f,57.239674f,2.330446f,-0.0f,57.239674f,2.522458f,0.965307f,57.239674f,2.330446f,1.783654f,57.239674f,1.783644f,2.330456f,57.239674f,0.965297f,2.522468f,57.239674f,-1.0E-5f,2.330456f,57.239674f,-0.965317f,1.783654f,57.239674f,-1.783664f,0.965307f,57.239674f,-2.330467f,0.0f,57.239674f,-2.522478f);
    }
    private static void method16(){
        MESH_4.getTexCoords().ensureCapacity(1868);
        MESH_4.getTexCoords().addAll(0.180569f,0.776049f,0.182079f,0.808388f,0.214502f,0.810257f,0.214692f,0.775837f,0.247825f,0.81074f,0.247821f,0.77609503f,0.247818f,0.742641f,0.214484f,0.742641f,0.180179f,0.742641f,0.281145f,0.810257f,0.313573f,0.808388f,0.314767f,0.776049f,0.280905f,0.775837f,0.315076f,0.742641f,0.28107f,0.742641f,0.314767f,0.709234f,0.313573f,0.676895f,0.281145f,0.675026f,0.280905f,0.709446f,0.247825f,0.674542f,0.247821f,0.709188f,0.214502f,0.675026f,0.182079f,0.676895f,0.180569f,0.709234f,0.214692f,0.709446f,0.718059f,0.43297702f,0.718059f,0.485938f,0.750933f,0.485938f,0.750933f,0.43297702f,0.783806f,0.485938f,0.783806f,0.43297702f,0.783806f,0.38001603f,0.750933f,0.38001603f,0.718059f,0.38001603f,0.816679f,0.485938f,0.849553f,0.485938f,0.849553f,0.43297702f,0.816679f,0.43297702f,0.849553f,0.38001603f,0.816679f,0.38001603f,0.849553f,0.32705402f,0.849553f,0.27409297f,0.816679f,0.27409297f,0.816679f,0.32705402f,0.783806f,0.27409297f,0.783806f,0.32705402f,0.750933f,0.27409297f,0.718059f,0.27409297f,0.718059f,0.32705402f,0.750933f,0.32705402f,0.65283f,0.776049f,0.654025f,0.808388f,0.686452f,0.810257f,0.686692f,0.775837f,0.719773f,0.81074f,0.719777f,0.77609503f,0.719779f,0.742641f,0.686527f,0.742641f,0.652521f,0.742641f,0.753096f,0.810257f,0.785518f,0.808388f,0.787028f,0.776049f,0.752905f,0.775837f,0.787419f,0.742641f,0.753113f,0.742641f,0.787028f,0.709234f,0.785518f,0.676895f,0.753096f,0.675026f,0.752905f,0.709446f,0.719773f,0.674542f,0.719777f,0.709188f,0.686452f,0.675026f,0.654025f,0.676895f,0.65283f,0.709234f,0.686692f,0.709446f,0.67516f,0.485938f,0.708034f,0.485938f,0.708034f,0.43606198f,0.67516f,0.43606198f,0.708034f,0.386186f,0.67516f,0.386186f,0.642287f,0.386186f,0.642287f,0.43606198f,0.642287f,0.485938f,0.708034f,0.33631003f,0.708034f,0.286434f,0.67516f,0.286434f,0.67516f,0.33631003f,0.642287f,0.286434f,0.642287f,0.33631003f,0.609414f,0.286434f,0.57654f,0.286434f,0.57654f,0.33631003f,0.609414f,0.33631003f,0.57654f,0.386186f,0.609414f,0.386186f,0.57654f,0.43606198f,0.57654f,0.485938f,0.609414f,0.485938f,0.609414f,0.43606198f,0.533641f,0.485938f,0.566515f,0.485938f,0.566515f,0.43606198f,0.533641f,0.43606198f,0.566515f,0.386186f,0.533641f,0.386186f,0.500768f,0.386186f,0.500768f,0.43606198f,0.500768f,0.485938f,0.566515f,0.33631003f,0.566515f,0.286434f,0.533641f,0.286434f,0.533641f,0.33631003f,0.500768f,0.286434f,0.500768f,0.33631003f,0.467895f,0.286434f,0.435022f,0.286434f,0.435022f,0.33631003f,0.467895f,0.33631003f,0.435022f,0.386186f,0.467895f,0.386186f,0.435022f,0.43606198f,0.435022f,0.485938f,0.467895f,0.485938f,0.467895f,0.43606198f,0.184857f,0.302885f,0.151983f,0.302885f,0.151983f,0.348648f,0.184857f,0.348648f,0.151983f,0.39441198f,0.184857f,0.39441198f,0.21773f,0.39441198f,0.21773f,0.348648f,0.21773f,0.302885f,0.184857f,0.485938f,0.184857f,0.440175f,0.151983f,0.440175f,0.151983f,0.485938f,0.21773f,0.485938f,0.21773f,0.440175f,0.283477f,0.485938f,0.283477f,0.440175f,0.250603f,0.440175f,0.250603f,0.485938f,0.283477f,0.39441198f,0.250603f,0.39441198f,0.283477f,0.348648f,0.283477f,0.302885f,0.250603f,0.302885f,0.250603f,0.348648f,0.645523f,0.854151f,0.682647f,0.854474f,0.637022f,0.899915f,0.678397f,0.899947f,0.719771f,0.899963f,0.719771f,0.85473096f,0.669895f,0.991441f,0.674146f,0.945678f,0.628521f,0.945678f,0.620019f,0.991441f,0.719771f,0.991441f,0.719771f,0.945678f,0.819523f,0.991441f,0.811022f,0.945678f,0.765397f,0.945678f,0.769647f,0.991441f,0.802521f,0.899915f,0.761146f,0.899947f,0.794019f,0.854151f,0.756895f,0.854474f,0.041802f,0.111927986f,0.008929f,0.111927986f,0.008929f,0.15769202f,0.041802f,0.15769202f,0.008929f,0.20345497f,0.041802f,0.20345497f,0.074675f,0.20345497f,0.074675f,0.15769202f,0.074675f,0.111927986f,0.041802f,0.29498202f,0.041802f,0.24921799f,0.008929f,0.24921799f,0.008929f,0.29498202f,0.074675f,0.29498202f,0.074675f,0.24921799f,0.140422f,0.29498202f,0.140422f,0.24921799f,0.107548f,0.24921799f,0.107548f,0.29498202f,0.140422f,0.20345497f,0.107548f,0.20345497f,0.140422f,0.15769202f,0.140422f,0.111927986f,0.107548f,0.111927986f,0.107548f,0.15769202f,0.173578f,0.854151f,0.210702f,0.854474f,0.165077f,0.899915f,0.206451f,0.899947f,0.247826f,0.899963f,0.247826f,0.85473096f,0.19795f,0.991441f,0.202201f,0.945678f,0.156575f,0.945678f,0.148074f,0.991441f,0.247826f,0.991441f,0.247826f,0.945678f,0.347578f,0.991441f,0.339077f,0.945678f,0.293451f,0.945678f,0.297702f,0.991441f,0.330575f,0.899915f,0.289201f,0.899947f,0.322074f,0.854151f,0.28495f,0.854474f,0.109084f,0.485938f,0.141958f,0.485938f,0.141958f,0.440175f,0.109084f,0.440175f,0.141958f,0.39441198f,0.109084f,0.39441198f,0.076211f,0.39441198f,0.076211f,0.440175f,0.076211f,0.485938f,0.109084f,0.348648f,0.141958f,0.348648f,0.141958f,0.302885f,0.109084f,0.302885f,0.076211f,0.348648f,0.076211f,0.302885f,0.010464f,0.348648f,0.043338f,0.348648f,0.043338f,0.302885f,0.010464f,0.302885f,0.010464f,0.39441198f,0.043338f,0.39441198f,0.010464f,0.440175f,0.010464f,0.485938f,0.043338f,0.485938f,0.043338f,0.440175f,0.322074f,0.631131f,0.28495f,0.630809f,0.330575f,0.58536804f,0.289201f,0.58533597f,0.247826f,0.58532f,0.247826f,0.630551f,0.293451f,0.539605f,0.339077f,0.539605f,0.347578f,0.493842f,0.297702f,0.493842f,0.247826f,0.539605f,0.247826f,0.493842f,0.156575f,0.539605f,0.202201f,0.539605f,0.19795f,0.493842f,0.148074f,0.493842f,0.165077f,0.58536804f,0.206451f,0.58533597f,0.173578f,0.631131f,0.210702f,0.630809f,0.392122f,0.485938f,0.424996f,0.485938f,0.424996f,0.440175f,0.392122f,0.440175f,0.424996f,0.39441198f,0.392122f,0.39441198f,0.359249f,0.39441198f,0.359249f,0.440175f,0.359249f,0.485938f,0.392122f,0.348648f,0.424996f,0.348648f,0.424996f,0.302885f,0.392122f,0.302885f,0.359249f,0.348648f,0.359249f,0.302885f,0.293503f,0.302885f,0.293503f,0.348648f,0.326376f,0.348648f,0.326376f,0.302885f,0.293503f,0.39441198f,0.326376f,0.39441198f,0.293503f,0.440175f,0.293503f,0.485938f,0.326376f,0.485938f,0.326376f,0.440175f,0.794019f,0.631131f,0.756895f,0.630809f,0.802521f,0.58536804f,0.761146f,0.58533597f,0.719771f,0.58532f,0.719771f,0.630551f,0.765397f,0.539605f,0.811022f,0.539605f,0.819523f,0.493842f,0.769647f,0.493842f,0.719771f,0.539605f,0.719771f,0.493842f,0.628521f,0.539605f,0.674146f,0.539605f,0.669895f,0.493842f,0.620019f,0.493842f,0.637022f,0.58536804f,0.678397f,0.58533597f,0.645523f,0.631131f,0.682647f,0.630809f,0.354685f,0.818432f,0.354891f,0.780537f,0.395797f,0.828476f,0.395817f,0.785559f,0.395828f,0.742641f,0.355056f,0.742641f,0.436909f,0.790581f,0.436909f,0.83852f,0.478021f,0.848564f,0.478021f,0.79560304f,0.436909f,0.742641f,0.478021f,0.742641f,0.436909f,0.64676297f,0.436909f,0.694702f,0.478021f,0.68968f,0.478021f,0.636719f,0.395797f,0.656807f,0.395817f,0.69972396f,0.354685f,0.66685104f,0.354891f,0.704746f,0.536099f,0.27853101f,0.568972f,0.27853101f,0.568972f,0.23741901f,0.536099f,0.23741901f,0.568972f,0.196307f,0.536099f,0.196307f,0.503226f,0.196307f,0.503226f,0.23741901f,0.503226f,0.27853101f,0.536099f,0.155195f,0.568972f,0.155195f,0.568972f,0.11408299f,0.536099f,0.11408299f,0.503226f,0.155195f,0.503226f,0.11408299f,0.437479f,0.11408299f,0.437479f,0.155195f,0.470352f,0.155195f,0.470352f,0.11408299f,0.437479f,0.196307f,0.470352f,0.196307f,0.437479f,0.23741901f,0.437479f,0.27853101f,0.470352f,0.27853101f,0.470352f,0.23741901f,0.612913f,0.66685104f,0.612707f,0.704746f,0.571801f,0.656807f,0.57178f,0.69972396f,0.57177f,0.742641f,0.612542f,0.742641f,0.530689f,0.694702f,0.530689f,0.64676297f,0.489577f,0.636719f,0.489577f,0.68968f,0.530689f,0.742641f,0.489577f,0.742641f,0.530689f,0.83852f,0.530689f,0.790581f,0.489577f,0.79560304f,0.489577f,0.848564f,0.571801f,0.828476f,0.57178f,0.785559f,0.612913f,0.818432f,0.612707f,0.780537f,0.678885f,0.26619f,0.711758f,0.26619f,0.711758f,0.22507799f,0.678885f,0.22507799f,0.711758f,0.18396598f,0.678885f,0.18396598f,0.646012f,0.18396598f,0.646012f,0.22507799f,0.646012f,0.26619f,0.678885f,0.14285398f,0.711758f,0.14285398f,0.711758f,0.10174203f,0.678885f,0.10174203f,0.646012f,0.14285398f,0.646012f,0.10174203f,0.580265f,0.14285398f,0.613138f,0.14285398f,0.613138f,0.10174203f,0.580265f,0.10174203f,0.580265f,0.18396598f,0.613138f,0.18396598f,0.580265f,0.22507799f,0.580265f,0.26619f,0.613138f,0.26619f,0.613138f,0.22507799f,0.828806f,0.818432f,0.829066f,0.780537f,0.872094f,0.828476f,0.87212f,0.785559f,0.872133f,0.742641f,0.829274f,0.742641f,0.958669f,0.79560304f,0.915381f,0.790581f,0.915381f,0.83852f,0.958669f,0.848564f,0.958669f,0.742641f,0.915381f,0.742641f,0.958669f,0.636719f,0.915381f,0.64676297f,0.915381f,0.694702f,0.958669f,0.68968f,0.872094f,0.656807f,0.87212f,0.69972396f,0.828806f,0.66685104f,0.829066f,0.704746f,0.184781f,0.121831f,0.151907f,0.121831f,0.151907f,0.16511798f,0.184781f,0.16511798f,0.151907f,0.20840597f,0.184781f,0.20840597f,0.217654f,0.20840597f,0.217654f,0.16511798f,0.217654f,0.121831f,0.184781f,0.29498202f,0.184781f,0.25169402f,0.151907f,0.25169402f,0.151907f,0.29498202f,0.217654f,0.29498202f,0.217654f,0.25169402f,0.2834f,0.29498202f,0.2834f,0.25169402f,0.250527f,0.25169402f,0.250527f,0.29498202f,0.2834f,0.20840597f,0.250527f,0.20840597f,0.2834f,0.16511798f,0.2834f,0.121831f,0.250527f,0.121831f,0.250527f,0.16511798f,0.138792f,0.66685104f,0.138531f,0.704746f,0.095504f,0.656807f,0.095478f,0.69972396f,0.095465f,0.742641f,0.138323f,0.742641f,0.008929f,0.68968f,0.052216f,0.694702f,0.052216f,0.64676297f,0.008929f,0.636719f,0.008929f,0.742641f,0.052216f,0.742641f,0.008929f,0.848564f,0.052216f,0.83852f,0.052216f,0.790581f,0.008929f,0.79560304f,0.095504f,0.828476f,0.095478f,0.785559f,0.138792f,0.818432f,0.138531f,0.780537f,0.327567f,0.10538f,0.294693f,0.10538f,0.294693f,0.14866799f,0.327567f,0.14866799f,0.294693f,0.19195497f,0.327567f,0.19195497f,0.36044f,0.19195497f,0.36044f,0.14866799f,0.36044f,0.10538f,0.327567f,0.27853101f,0.327567f,0.23524302f,0.294693f,0.23524302f,0.294693f,0.27853101f,0.36044f,0.27853101f,0.36044f,0.23524302f,0.426186f,0.27853101f,0.426186f,0.23524302f,0.393313f,0.23524302f,0.393313f,0.27853101f,0.426186f,0.19195497f,0.393313f,0.19195497f,0.426186f,0.14866799f,0.426186f,0.10538f,0.393313f,0.10538f,0.393313f,0.14866799f,0.253864f,0.99157f,0.253864f,0.930018f,0.289029f,0.930018f,0.289029f,0.99157f,0.253864f,0.868465f,0.289029f,0.868465f,0.253864f,0.806912f,0.289029f,0.806912f,0.253864f,0.74536f,0.289029f,0.74536f,0.253864f,0.683807f,0.289029f,0.683807f,0.253864f,0.62225497f,0.289029f,0.62225497f,0.253864f,0.56070197f,0.289029f,0.56070197f,0.253864f,0.49914998f,0.289029f,0.49914998f,0.253864f,0.43759698f,0.289029f,0.43759698f,0.253864f,0.376045f,0.289029f,0.376045f,0.253864f,0.314492f,0.289029f,0.314492f,0.253864f,0.25294f,0.289029f,0.25294f,0.253864f,0.191387f,0.289029f,0.191387f,0.253864f,0.129834f,0.289029f,0.129834f,0.253864f,0.06828201f,0.289029f,0.06828201f,0.253864f,0.006729007f,0.289029f,0.006729007f,0.324192f,0.930018f,0.324192f,0.99157f,0.324192f,0.868465f,0.324192f,0.806912f,0.324192f,0.74536f,0.324192f,0.683807f,0.324192f,0.62225497f,0.324192f,0.56070197f,0.324192f,0.49914998f,0.324192f,0.43759698f,0.324192f,0.376045f,0.324192f,0.314492f,0.324192f,0.25294f,0.324192f,0.191387f,0.324192f,0.129834f,0.324192f,0.06828201f,0.324192f,0.006729007f,0.359358f,0.930018f,0.359358f,0.99157f,0.359358f,0.868465f,0.359358f,0.806912f,0.359358f,0.74536f,0.359358f,0.683807f,0.359358f,0.62225497f,0.359358f,0.56070197f,0.359358f,0.49914998f,0.359358f,0.43759698f,0.359358f,0.376045f,0.359358f,0.314492f,0.359358f,0.25294f,0.359358f,0.191387f,0.359358f,0.129834f,0.359358f,0.06828201f,0.359358f,0.006729007f,0.394521f,0.930018f,0.394521f,0.99157f,0.394521f,0.868465f,0.394521f,0.806912f,0.394521f,0.74536f,0.394521f,0.683807f,0.394521f,0.62225497f,0.394521f,0.56070197f,0.394521f,0.49914998f,0.394521f,0.43759698f,0.394521f,0.376045f,0.394521f,0.314492f,0.394521f,0.25294f,0.394521f,0.191387f,0.394521f,0.129834f,0.394521f,0.06828201f,0.394521f,0.006729007f,0.429687f,0.930018f,0.429687f,0.99157f,0.429687f,0.868465f,0.429687f,0.806912f,0.429687f,0.74536f,0.429687f,0.683807f,0.429687f,0.62225497f,0.429687f,0.56070197f,0.429687f,0.49914998f,0.429687f,0.43759698f,0.429687f,0.376045f,0.429687f,0.314492f,0.429687f,0.25294f,0.429687f,0.191387f,0.429687f,0.129834f,0.429687f,0.06828201f,0.429687f,0.006729007f,0.464851f,0.930018f,0.464851f,0.99157f,0.464851f,0.868465f,0.464851f,0.806912f,0.464851f,0.74536f,0.464851f,0.683807f,0.464851f,0.62225497f,0.464851f,0.56070197f,0.464851f,0.49914998f,0.464851f,0.43759698f,0.464851f,0.376045f,0.464851f,0.314492f,0.464851f,0.25294f,0.464851f,0.191387f,0.464851f,0.129834f,0.464851f,0.06828201f,0.464851f,0.006729007f,0.500016f,0.930018f,0.500016f,0.99157f,0.500016f,0.868465f,0.500016f,0.806912f,0.500016f,0.74536f,0.500016f,0.683807f,0.500016f,0.62225497f,0.500016f,0.56070197f,0.500016f,0.49914998f,0.500016f,0.43759698f,0.500016f,0.376045f,0.500016f,0.314492f,0.500016f,0.25294f,0.500016f,0.191387f,0.500016f,0.129834f,0.500016f,0.06828201f,0.500016f,0.006729007f,0.535181f,0.930018f,0.535181f,0.99157f,0.535181f,0.868465f,0.535181f,0.806912f,0.535181f,0.74536f,0.535181f,0.683807f,0.535181f,0.62225497f,0.535181f,0.56070197f,0.535181f,0.49914998f,0.535181f,0.43759698f,0.535181f,0.376045f,0.535181f,0.314492f,0.535181f,0.25294f,0.535181f,0.191387f,0.535181f,0.129834f,0.535181f,0.06828201f,0.535181f,0.006729007f,0.570345f,0.930018f,0.570345f,0.99157f,0.570345f,0.868465f,0.570345f,0.806912f,0.570345f,0.74536f,0.570345f,0.683807f,0.570345f,0.62225497f,0.570345f,0.56070197f,0.570345f,0.49914998f,0.570345f,0.43759698f,0.570345f,0.376045f,0.570345f,0.314492f,0.570345f,0.25294f,0.570345f,0.191387f,0.570345f,0.129834f,0.570345f,0.06828201f,0.570345f,0.006729007f,0.605509f,0.930018f,0.605509f,0.99157f,0.605509f,0.868465f,0.605509f,0.806912f,0.605509f,0.74536f,0.605509f,0.683807f,0.605509f,0.62225497f,0.605509f,0.56070197f,0.605509f,0.49914998f,0.605509f,0.43759698f,0.605509f,0.376045f,0.605509f,0.314492f,0.605509f,0.25294f,0.605509f,0.191387f,0.605509f,0.129834f,0.605509f,0.06828201f,0.605509f,0.006729007f,0.640675f,0.930018f,0.640675f,0.99157f,0.640675f,0.868465f,0.640675f,0.806912f,0.640675f,0.74536f,0.640675f,0.683807f,0.640675f,0.62225497f,0.640675f,0.56070197f,0.640675f,0.49914998f,0.640675f,0.43759698f,0.640675f,0.376045f,0.640675f,0.314492f,0.640675f,0.25294f,0.640675f,0.191387f,0.640675f,0.129834f,0.640675f,0.06828201f,0.640675f,0.006729007f,0.67584f,0.930018f,0.67584f,0.99157f,0.67584f,0.868465f,0.67584f,0.806912f,0.67584f,0.74536f,0.67584f,0.683807f,0.67584f,0.62225497f,0.67584f,0.56070197f,0.67584f,0.49914998f,0.67584f,0.43759698f,0.67584f,0.376045f,0.67584f,0.314492f,0.67584f,0.25294f,0.67584f,0.191387f,0.67584f,0.129834f,0.67584f,0.06828201f,0.67584f,0.006729007f,0.711006f,0.930018f,0.711006f,0.99157f,0.711006f,0.868465f,0.711006f,0.806912f,0.711006f,0.74536f,0.711006f,0.683807f,0.711006f,0.62225497f,0.711006f,0.56070197f,0.711006f,0.49914998f,0.711006f,0.43759698f,0.711006f,0.376045f,0.711006f,0.314492f,0.711006f,0.25294f,0.711006f,0.191387f,0.711006f,0.129834f,0.711006f,0.06828201f,0.711006f,0.006729007f,0.74617f,0.930018f,0.74617f,0.99157f,0.74617f,0.868465f,0.74617f,0.806912f,0.74617f,0.74536f,0.74617f,0.683807f,0.74617f,0.62225497f,0.74617f,0.56070197f,0.74617f,0.49914998f,0.74617f,0.43759698f,0.74617f,0.376045f,0.74617f,0.314492f,0.74617f,0.25294f,0.74617f,0.191387f,0.74617f,0.129834f,0.74617f,0.06828201f,0.74617f,0.006729007f,0.781332f,0.930018f,0.781332f,0.99157f,0.781332f,0.868465f,0.781332f,0.806912f,0.781332f,0.74536f,0.781332f,0.683807f,0.781332f,0.62225497f,0.781332f,0.56070197f,0.781332f,0.49914998f,0.781332f,0.43759698f,0.781332f,0.376045f,0.781332f,0.314492f,0.781332f,0.25294f,0.781332f,0.191387f,0.781332f,0.129834f,0.781332f,0.06828201f,0.781332f,0.006729007f,0.816498f,0.930018f,0.816498f,0.99157f,0.816498f,0.868465f,0.816498f,0.806912f,0.816498f,0.74536f,0.816498f,0.683807f,0.816498f,0.62225497f,0.816498f,0.56070197f,0.816498f,0.49914998f,0.816498f,0.43759698f,0.816498f,0.376045f,0.816498f,0.314492f,0.816498f,0.25294f,0.816498f,0.191387f,0.816498f,0.129834f,0.816498f,0.06828201f,0.816498f,0.006729007f,0.851664f,0.930018f,0.851664f,0.99157f,0.851664f,0.868465f,0.851664f,0.806912f,0.851664f,0.74536f,0.851664f,0.683807f,0.851664f,0.62225497f,0.851664f,0.56070197f,0.851664f,0.49914998f,0.851664f,0.43759698f,0.851664f,0.376045f,0.851664f,0.314492f,0.851664f,0.25294f,0.851664f,0.191387f,0.851664f,0.129834f,0.851664f,0.06828201f,0.851664f,0.006729007f,0.886827f,0.930018f,0.886827f,0.99157f,0.886827f,0.868465f,0.886827f,0.806912f,0.886827f,0.74536f,0.886827f,0.683807f,0.886827f,0.62225497f,0.886827f,0.56070197f,0.886827f,0.49914998f,0.886827f,0.43759698f,0.886827f,0.376045f,0.886827f,0.314492f,0.886827f,0.25294f,0.886827f,0.191387f,0.886827f,0.129834f,0.886827f,0.06828201f,0.886827f,0.006729007f,0.921989f,0.930018f,0.921989f,0.99157f,0.921989f,0.868465f,0.921989f,0.806912f,0.921989f,0.74536f,0.921989f,0.683807f,0.921989f,0.62225497f,0.921989f,0.56070197f,0.921989f,0.49914998f,0.921989f,0.43759698f,0.921989f,0.376045f,0.921989f,0.314492f,0.921989f,0.25294f,0.921989f,0.191387f,0.921989f,0.129834f,0.921989f,0.06828201f,0.921989f,0.006729007f,0.957155f,0.930018f,0.957155f,0.99157f,0.957155f,0.868465f,0.957155f,0.806912f,0.957155f,0.74536f,0.957155f,0.683807f,0.957155f,0.62225497f,0.957155f,0.56070197f,0.957155f,0.49914998f,0.957155f,0.43759698f,0.957155f,0.376045f,0.957155f,0.314492f,0.957155f,0.25294f,0.957155f,0.191387f,0.957155f,0.129834f,0.957155f,0.06828201f,0.957155f,0.006729007f,0.992321f,0.49914998f,0.232217f,0.376045f,0.232217f,0.314492f,0.232217f,0.43759698f,0.232217f,0.49914998f,0.232217f,0.56070197f,0.232217f,0.62225497f,0.232217f,0.683807f,0.232217f,0.74536f,0.232217f,0.806912f,0.232217f,0.868465f,0.232217f,0.930018f,0.232217f,0.99157f,0.232217f,0.06828201f,0.232217f,0.006729007f,0.232217f,0.129834f,0.232217f,0.191387f,0.232217f,0.25294f,0.22901f,0.376045f,0.22901f,0.314492f,0.22901f,0.43759698f,0.22901f,0.49914998f,0.22901f,0.56070197f,0.22901f,0.62225497f,0.22901f,0.683807f,0.22901f,0.74536f,0.22901f,0.806912f,0.22901f,0.868465f,0.22901f,0.930018f,0.22901f,0.99157f,0.22901f,0.06828201f,0.22901f,0.006729007f,0.22901f,0.129834f,0.22901f,0.191387f,0.22901f,0.25294f,0.026278f,1.0f,0.396399f,1.0f,0.40911f,0.0f,0.0f,0.042542994f,0.055943f,1.0f,0.373263f,1.0f,0.380928f,0.0f,0.0f,0.13120002f,0.0f,1.0f,0.3547f,1.0f,0.880473f,0.0f,0.190122f,0.14948499f,0.024151f,1.0f,0.323042f,1.0f,0.522373f,0.0f,0.0f,0.0027959943f,0.199822f,1.0f,0.499449f,1.0f,0.52366f,0.0f,0.0f,0.054042995f,0.597149f,1.0f,1.0f,1.0f,0.784068f,0.636062f,0.0f,0.926759f,0.008469f,0.0f,0.355965f,0.0f,0.417153f,0.963972f,0.014282f,0.0f,0.431906f,0.0f,0.461617f,0.986676f,0.029711f,0.0f,0.447335f,0.0f,0.461617f,1.0f,0.0f,0.986676f,0.061188f,0.0f,0.408683f,0.0f,0.417153f,1.0f,0.0f,0.963972f,0.402771f,1.0f,1.0f,0.92590797f,0.216088f,0.63526f,0.024321f,1.0f,0.323983f,1.0f,0.523721f,0.05402398f,0.0f,0.0f,0.199216f,1.0f,0.498096f,1.0f,0.522353f,0.0028539896f,0.526036f,1.0f,0.880794f,1.0f,0.690465f,0.14946198f,0.007666f,1.0f,0.324985f,1.0f,0.380928f,0.13120002f,0.012711f,1.0f,0.382832f,1.0f,0.40911f,0.042542994f);
    }
    private static void method17(){
        MESH_4.getFaces().ensureCapacity(8544);
        MESH_4.getFaces().addAll(0,0,1,1,2,2,0,0,2,2,3,3,2,2,4,4,5,5,2,2,5,5,3,3,5,5,6,6,7,7,5,5,7,7,3,3,7,7,8,8,0,0,7,7,0,0,3,3,9,9,10,10,11,11,9,9,11,11,12,12,11,11,13,13,14,14,11,11,14,14,12,12,14,14,6,6,5,5,14,14,5,5,12,12,5,5,4,4,9,9,5,5,9,9,12,12,15,15,16,16,17,17,15,15,17,17,18,18,17,17,19,19,20,20,17,17,20,20,18,18,20,20,6,6,14,14,20,20,14,14,18,18,14,14,13,13,15,15,14,14,15,15,18,18,21,21,22,22,23,23,21,21,23,23,24,24,23,23,8,8,7,7,23,23,7,7,24,24,7,7,6,6,20,20,7,7,20,20,24,24,20,20,19,19,21,21,20,20,21,21,24,24,25,25,26,26,27,27,25,25,27,27,28,28,27,27,29,29,30,30,27,27,30,30,28,28,30,30,31,31,32,32,30,30,32,32,28,28,32,32,33,33,25,25,32,32,25,25,28,28,34,34,35,35,36,36,34,34,36,36,37,37,36,36,38,38,39,39,36,36,39,39,37,37,39,39,31,31,30,30,39,39,30,30,37,37,30,30,29,29,34,34,30,30,34,34,37,37,40,40,41,41,42,42,40,40,42,42,43,43,42,42,44,44,45,45,42,42,45,45,43,43,45,45,31,31,39,39,45,45,39,39,43,43,39,39,38,38,40,40,39,39,40,40,43,43,46,46,47,47,48,48,46,46,48,48,49,49,48,48,33,33,32,32,48,48,32,32,49,49,32,32,31,31,45,45,32,32,45,45,49,49,45,45,44,44,46,46,45,45,46,46,49,49,50,50,51,51,52,52,50,50,52,52,53,53,52,52,54,54,55,55,52,52,55,55,53,53,55,55,56,56,57,57,55,55,57,57,53,53,57,57,58,58,50,50,57,57,50,50,53,53,59,59,60,60,61,61,59,59,61,61,62,62,61,61,63,63,64,64,61,61,64,64,62,62,64,64,56,56,55,55,64,64,55,55,62,62,55,55,54,54,59,59,55,55,59,59,62,62,65,65,66,66,67,67,65,65,67,67,68,68,67,67,69,69,70,70,67,67,70,70,68,68,70,70,56,56,64,64,70,70,64,64,68,68,64,64,63,63,65,65,64,64,65,65,68,68,71,71,72,72,73,73,71,71,73,73,74,74,73,73,58,58,57,57,73,73,57,57,74,74,57,57,56,56,70,70,57,57,70,70,74,74,70,70,69,69,71,71,70,70,71,71,74,74,75,75,76,76,77,77,75,75,77,77,78,78,77,77,79,79,80,80,77,77,80,80,78,78,80,80,81,81,82,82,80,80,82,82,78,78,82,82,83,83,75,75,82,82,75,75,78,78,84,84,85,85,86,86,84,84,86,86,87,87,86,86,88,88,89,89,86,86,89,89,87,87,89,89,81,81,80,80,89,89,80,80,87,87,80,80,79,79,84,84,80,80,84,84,87,87,90,90,91,91,92,92,90,90,92,92,93,93,92,92,94,94,95,95,92,92,95,95,93,93,95,95,81,81,89,89,95,95,89,89,93,93,89,89,88,88,90,90,89,89,90,90,93,93,96,96,97,97,98,98,96,96,98,98,99,99,98,98,83,83,82,82,98,98,82,82,99,99,82,82,81,81,95,95,82,82,95,95,99,99,95,95,94,94,96,96,95,95,96,96,99,99,100,100,101,101,102,102,100,100,102,102,103,103,102,102,104,104,105,105,102,102,105,105,103,103,105,105,106,106,107,107,105,105,107,107,103,103,107,107,108,108,100,100,107,107,100,100,103,103,109,109,110,110,111,111,109,109,111,111,112,112,111,111,113,113,114,114,111,111,114,114,112,112,114,114,106,106,105,105,114,114,105,105,112,112,105,105,104,104,109,109,105,105,109,109,112,112,115,115,116,116,117,117,115,115,117,117,118,118,117,117,119,119,120,120,117,117,120,120,118,118,120,120,106,106,114,114,120,120,114,114,118,118,114,114,113,113,115,115,114,114,115,115,118,118,121,121,122,122,123,123,121,121,123,123,124,124,123,123,108,108,107,107,123,123,107,107,124,124,107,107,106,106,120,120,107,107,120,120,124,124,120,120,119,119,121,121,120,120,121,121,124,124,125,125,60,126,126,127,125,125,126,127,127,128,126,127,128,129,129,130,126,127,129,130,127,128,129,130,130,131,131,132,129,130,131,132,127,128,131,132,132,133,125,125,131,132,125,125,127,128,75,134,133,135,134,136,75,134,134,136,76,137,83,138,135,139,133,135,83,138,133,135,75,134,135,139,130,131,129,130,135,139,129,130,133,135,129,130,128,129,134,136,129,130,134,136,133,135,97,140,136,141,137,142,97,140,137,142,98,143,136,141,138,144,139,145,136,141,139,145,137,142,139,145,130,131,135,139,139,145,135,139,137,142,98,143,137,142,135,139,98,143,135,139,83,138,140,146,1,147,141,148,140,146,141,148,142,149,141,148,132,133,131,132,141,148,131,132,142,149,131,132,130,131,139,145,131,132,139,145,142,149,139,145,138,144,140,146,139,145,140,146,142,149,52,52,51,51,143,150,52,52,143,150,144,151,143,150,145,152,146,153,143,150,146,153,144,151,146,153,147,154,148,155,146,153,148,155,144,151,148,155,54,54,52,52,148,155,52,52,144,151,84,156,149,157,150,158,84,156,150,158,85,159,79,160,151,161,149,157,79,160,149,157,84,156,151,161,147,154,146,153,151,161,146,153,149,157,146,153,145,152,150,158,146,153,150,158,149,157,76,162,134,163,152,164,76,162,152,164,77,165,134,163,128,166,153,167,134,163,153,167,152,164,153,167,147,154,151,161,153,167,151,161,152,164,77,165,152,164,151,161,77,165,151,161,79,160,126,168,60,60,59,59,126,168,59,59,154,169,59,59,54,54,148,155,59,59,148,155,154,169,148,155,147,154,153,167,148,155,153,167,154,169,153,167,128,166,126,168,153,167,126,168,154,169,155,170,10,171,156,172,155,170,156,172,157,173,156,172,158,174,159,175,156,172,159,175,157,173,159,175,160,176,161,177,159,175,161,177,157,173,161,177,162,178,155,170,161,177,155,170,157,173,90,179,163,180,164,181,90,179,164,181,91,182,88,183,165,184,163,180,88,183,163,180,90,179,165,184,160,176,159,175,165,184,159,175,163,180,159,175,158,174,164,181,159,175,164,181,163,180,85,185,150,186,166,187,85,185,166,187,86,188,150,186,145,189,167,190,150,186,167,190,166,187,167,190,160,176,165,184,167,190,165,184,166,187,86,188,166,187,165,184,86,188,165,184,88,183,143,191,51,192,168,193,143,191,168,193,169,194,168,193,162,178,161,177,168,193,161,177,169,194,161,177,160,176,167,190,161,177,167,190,169,194,167,190,145,189,143,191,167,190,143,191,169,194,2,2,1,1,140,195,2,2,140,195,170,196,140,195,138,197,171,198,140,195,171,198,170,196,171,198,172,199,173,200,171,198,173,200,170,196,173,200,4,4,2,2,173,200,2,2,170,196,96,201,174,202,136,203,96,201,136,203,97,204,94,205,175,206,174,202,94,205,174,202,96,201,175,206,172,199,171,198,175,206,171,198,174,202,171,198,138,197,136,203,171,198,136,203,174,202,91,207,164,208,176,209,91,207,176,209,92,210,164,208,158,211,177,212,164,208,177,212,176,209,177,212,172,199,175,206,177,212,175,206,176,209,92,210,176,209,175,206,92,210,175,206,94,205,156,213,10,10,9,9,156,213,9,9,178,214,9,9,4,4,173,200,9,9,173,200,178,214,173,200,172,199,177,212,173,200,177,212,178,214,177,212,158,211,156,213,177,212,156,213,178,214,179,215,22,216,180,217,179,215,180,217,181,218,180,217,182,219,183,220,180,217,183,220,181,218,183,220,184,221,185,222,183,220,185,222,181,218,185,222,186,223,179,215,185,222,179,215,181,218,187,224,188,225,101,226,187,224,101,226,100,227,189,228,187,224,100,227,189,228,100,227,108,229,189,228,184,221,183,220,189,228,183,220,187,224,183,220,182,219,188,225,183,220,188,225,187,224,190,230,191,231,123,232,190,230,123,232,122,233,190,230,192,234,193,235,190,230,193,235,191,231,193,235,184,221,189,228,193,235,189,228,191,231,191,231,189,228,108,229,191,231,108,229,123,232,194,236,66,237,195,238,194,236,195,238,196,239,195,238,186,223,185,222,195,238,185,222,196,239,185,222,184,221,193,235,185,222,193,235,196,239,193,235,192,234,194,236,193,235,194,236,196,239,17,17,16,16,197,240,17,17,197,240,198,241,197,240,199,242,200,243,197,240,200,243,198,241,200,243,201,244,202,245,200,243,202,245,198,241,202,245,19,19,17,17,202,245,17,17,198,241,203,246,204,247,110,248,203,246,110,248,109,249,205,250,203,246,109,249,205,250,109,249,104,251,205,250,201,244,200,243,205,250,200,243,203,246,200,243,199,242,204,247,200,243,204,247,203,246,188,252,206,253,102,254,188,252,102,254,101,255,188,252,182,256,207,257,188,252,207,257,206,253,207,257,201,244,205,250,207,257,205,250,206,253,206,253,205,250,104,251,206,253,104,251,102,254,180,258,22,22,21,21,180,258,21,21,208,259,21,21,19,19,202,245,21,21,202,245,208,259,202,245,201,244,207,257,202,245,207,257,208,259,207,257,182,256,180,258,207,257,180,258,208,259,209,260,72,261,210,262,209,260,210,262,211,263,210,262,212,264,213,265,210,262,213,265,211,263,213,265,214,266,215,267,213,265,215,267,211,263,215,267,216,268,209,260,215,267,209,260,211,263,217,269,218,270,116,271,217,269,116,271,115,272,219,273,217,269,115,272,219,273,115,272,113,274,219,273,214,266,213,265,219,273,213,265,217,269,213,265,212,264,218,270,213,265,218,270,217,269,110,275,204,276,220,277,110,275,220,277,111,278,204,276,199,279,221,280,204,276,221,280,220,277,221,280,214,266,219,273,221,280,219,273,220,277,220,277,219,273,113,274,220,277,113,274,111,278,197,281,16,282,222,283,197,281,222,283,223,284,222,283,216,268,215,267,222,283,215,267,223,284,215,267,214,266,221,280,215,267,221,280,223,284,221,280,199,279,197,281,221,280,197,281,223,284,67,67,66,66,194,285,67,67,194,285,224,286,194,285,192,287,225,288,194,285,225,288,224,286,225,288,226,289,227,290,225,288,227,290,224,286,227,290,69,69,67,67,227,290,67,67,224,286,228,291,190,292,122,293,228,291,122,293,121,294,229,295,228,291,121,294,229,295,121,294,119,296,229,295,226,289,225,288,229,295,225,288,228,291,225,288,192,287,190,292,225,288,190,292,228,291,218,297,230,298,117,299,218,297,117,299,116,300,218,297,212,301,231,302,218,297,231,302,230,298,231,302,226,289,229,295,231,302,229,295,230,298,230,298,229,295,119,296,230,298,119,296,117,299,210,303,72,72,71,71,210,303,71,71,232,304,71,71,69,69,227,290,71,71,227,290,232,304,227,290,226,289,231,302,227,290,231,302,232,304,231,302,212,301,210,303,231,302,210,303,232,304,11,11,10,10,233,305,11,11,233,305,234,306,233,305,235,307,236,308,233,305,236,308,234,306,236,308,237,309,238,310,236,308,238,310,234,306,238,310,13,13,11,11,238,310,11,11,234,306,239,311,240,312,26,313,239,311,26,313,25,314,241,315,239,311,25,314,241,315,25,314,33,316,241,315,237,309,236,308,241,315,236,308,239,311,236,308,235,307,240,312,236,308,240,312,239,311,242,317,243,318,48,319,242,317,48,319,47,320,242,317,244,321,245,322,242,317,245,322,243,318,245,322,237,309,241,315,245,322,241,315,243,318,243,318,241,315,33,316,243,318,33,316,48,319,246,323,16,16,15,15,246,323,15,15,247,324,15,15,13,13,238,310,15,15,238,310,247,324,238,310,237,309,245,322,238,310,245,322,247,324,245,322,244,321,246,323,245,322,246,323,247,324,168,325,51,326,248,327,168,325,248,327,249,328,248,327,250,329,251,330,248,327,251,330,249,328,251,330,252,331,253,332,251,330,253,332,249,328,253,332,162,333,168,325,253,332,168,325,249,328,254,334,255,335,35,336,254,334,35,336,34,337,256,338,254,334,34,337,256,338,34,337,29,339,256,338,252,331,251,330,256,338,251,330,254,334,251,330,250,329,255,335,251,330,255,335,254,334,26,340,240,341,257,342,26,340,257,342,27,343,240,341,235,344,258,345,240,341,258,345,257,342,258,345,252,331,256,338,258,345,256,338,257,342,257,342,256,338,29,339,257,342,29,339,27,343,233,346,10,347,155,348,233,346,155,348,259,349,155,348,162,333,253,332,155,348,253,332,259,349,253,332,252,331,258,345,253,332,258,345,259,349,258,345,235,344,233,346,258,345,233,346,259,349,73,73,72,72,260,350,73,73,260,350,261,351,260,350,262,352,263,353,260,350,263,353,261,351,263,353,264,354,265,355,263,353,265,355,261,351,265,355,58,58,73,73,265,355,73,73,261,351,266,356,267,357,41,358,266,356,41,358,40,359,268,360,266,356,40,359,268,360,40,359,38,361,268,360,264,354,263,353,268,360,263,353,266,356,263,353,262,352,267,357,263,353,267,357,266,356,255,362,269,363,36,364,255,362,36,364,35,365,255,362,250,366,270,367,255,362,270,367,269,363,270,367,264,354,268,360,270,367,268,360,269,363,269,363,268,360,38,361,269,363,38,361,36,364,248,368,51,51,50,50,248,368,50,50,271,369,50,50,58,58,265,355,50,50,265,355,271,369,265,355,264,354,270,367,265,355,270,367,271,369,270,367,250,366,248,368,270,367,248,368,271,369,222,370,16,371,246,372,222,370,246,372,272,373,246,372,244,374,273,375,246,372,273,375,272,373,273,375,274,376,275,377,273,375,275,377,272,373,275,377,216,378,222,370,275,377,222,370,272,373,276,379,242,380,47,381,276,379,47,381,46,382,277,383,276,379,46,382,277,383,46,382,44,384,277,383,274,376,273,375,277,383,273,375,276,379,273,375,244,374,242,380,273,375,242,380,276,379,267,385,278,386,42,387,267,385,42,387,41,388,267,385,262,389,279,390,267,385,279,390,278,386,279,390,274,376,277,383,279,390,277,383,278,386,278,386,277,383,44,384,278,386,44,384,42,387,260,391,72,392,209,393,260,391,209,393,280,394,209,393,216,378,275,377,209,393,275,377,280,394,275,377,274,376,279,390,275,377,279,390,280,394,279,390,262,389,260,391,279,390,260,391,280,394,61,61,60,60,281,395,61,61,281,395,282,396,281,395,283,397,284,398,281,395,284,398,282,396,284,398,285,399,286,400,284,398,286,400,282,396,286,400,63,63,61,61,286,400,61,61,282,396,287,401,288,402,289,403,287,401,289,403,290,404,291,405,292,406,288,402,291,405,288,402,287,401,292,406,285,399,284,398,292,406,284,398,288,402,284,398,283,397,289,403,284,398,289,403,288,402,293,407,294,408,295,409,293,407,295,409,296,410,294,408,297,411,298,412,294,408,298,412,295,409,298,412,285,399,292,406,298,412,292,406,295,409,296,410,295,409,292,406,296,410,292,406,291,405,299,413,66,66,65,65,299,413,65,65,300,414,65,65,63,63,286,400,65,65,286,400,300,414,286,400,285,399,298,412,286,400,298,412,300,414,298,412,297,411,299,413,298,412,299,413,300,414,141,415,1,416,301,417,141,415,301,417,302,418,301,417,303,419,304,420,301,417,304,420,302,418,304,420,305,421,306,422,304,420,306,422,302,418,306,422,132,423,141,415,306,422,141,415,302,418,307,424,308,425,309,426,307,424,309,426,310,427,311,428,312,429,308,425,311,428,308,425,307,424,312,429,305,421,304,420,312,429,304,420,308,425,304,420,303,419,309,426,304,420,309,426,308,425,290,430,289,431,313,432,290,430,313,432,314,433,289,431,283,434,315,435,289,431,315,435,313,432,315,435,305,421,312,429,315,435,312,429,313,432,314,433,313,432,312,429,314,433,312,429,311,428,281,436,60,437,125,438,281,436,125,438,316,439,125,438,132,423,306,422,125,438,306,422,316,439,306,422,305,421,315,435,306,422,315,435,316,439,315,435,283,434,281,436,315,435,281,436,316,439,23,23,22,22,317,440,23,23,317,440,318,441,317,440,319,442,320,443,317,440,320,443,318,441,320,443,321,444,322,445,320,443,322,445,318,441,322,445,8,8,23,23,322,445,23,23,318,441,323,446,324,447,325,448,323,446,325,448,326,449,327,450,328,451,324,447,327,450,324,447,323,446,328,451,321,444,320,443,328,451,320,443,324,447,320,443,319,442,325,448,320,443,325,448,324,447,310,452,309,453,329,454,310,452,329,454,330,455,309,453,303,456,331,457,309,453,331,457,329,454,331,457,321,444,328,451,331,457,328,451,329,454,330,455,329,454,328,451,330,455,328,451,327,450,301,458,1,1,0,0,301,458,0,0,332,459,0,0,8,8,322,445,0,0,322,445,332,459,322,445,321,444,331,457,322,445,331,457,332,459,331,457,303,456,301,458,331,457,301,458,332,459,195,460,66,461,299,462,195,460,299,462,333,463,299,462,297,464,334,465,299,462,334,465,333,463,334,465,335,466,336,467,334,465,336,467,333,463,336,467,186,468,195,460,336,467,195,460,333,463,337,469,338,470,294,471,337,469,294,471,293,472,339,473,340,474,338,470,339,473,338,470,337,469,340,474,335,466,334,465,340,474,334,465,338,470,334,465,297,464,294,471,334,465,294,471,338,470,326,475,325,476,341,477,326,475,341,477,342,478,325,476,319,479,343,480,325,476,343,480,341,477,343,480,335,466,340,474,343,480,340,474,341,477,342,478,341,477,340,474,342,478,340,474,339,473,317,481,22,482,179,483,317,481,179,483,344,484,179,483,186,468,336,467,179,483,336,467,344,484,336,467,335,466,343,480,336,467,343,480,344,484,343,480,319,479,317,481,343,480,317,481,344,484,345,485,346,486,347,487,345,485,347,487,348,488,346,486,349,489,350,490,346,486,350,490,347,487,349,489,351,491,352,492,349,489,352,492,350,490,351,491,353,493,354,494,351,491,354,494,352,492,353,493,355,495,356,496,353,493,356,496,354,494,355,495,357,497,358,498,355,495,358,498,356,496,357,497,359,499,360,500,357,497,360,500,358,498,359,499,361,501,362,502,359,499,362,502,360,500,361,501,363,503,364,504,361,501,364,504,362,502,363,503,365,505,366,506,363,503,366,506,364,504,365,505,367,507,368,508,365,505,368,508,366,506,367,507,369,509,370,510,367,507,370,510,368,508,369,509,371,511,372,512,369,509,372,512,370,510,371,511,373,513,374,514,371,511,374,514,372,512,373,513,375,515,376,516,373,513,376,516,374,514,375,515,345,517,348,518,375,515,348,518,376,516,348,488,347,487,377,519,348,488,377,519,378,520,347,487,350,490,379,521,347,487,379,521,377,519,350,490,352,492,380,522,350,490,380,522,379,521,352,492,354,494,381,523,352,492,381,523,380,522,354,494,356,496,382,524,354,494,382,524,381,523,356,496,358,498,383,525,356,496,383,525,382,524,358,498,360,500,384,526,358,498,384,526,383,525,360,500,362,502,385,527,360,500,385,527,384,526,362,502,364,504,386,528,362,502,386,528,385,527,364,504,366,506,387,529,364,504,387,529,386,528,366,506,368,508,388,530,366,506,388,530,387,529,368,508,370,510,389,531,368,508,389,531,388,530,370,510,372,512,390,532,370,510,390,532,389,531,372,512,374,514,391,533,372,512,391,533,390,532,374,514,376,516,392,534,374,514,392,534,391,533,376,516,348,518,378,535,376,516,378,535,392,534,378,520,377,519,393,536,378,520,393,536,394,537,377,519,379,521,395,538,377,519,395,538,393,536,379,521,380,522,396,539,379,521,396,539,395,538,380,522,381,523,397,540,380,522,397,540,396,539,381,523,382,524,398,541,381,523,398,541,397,540,382,524,383,525,399,542,382,524,399,542,398,541,383,525,384,526,400,543,383,525,400,543,399,542,384,526,385,527,401,544,384,526,401,544,400,543,385,527,386,528,402,545,385,527,402,545,401,544,386,528,387,529,403,546,386,528,403,546,402,545,387,529,388,530,404,547,387,529,404,547,403,546,388,530,389,531,405,548,388,530,405,548,404,547,389,531,390,532,406,549,389,531,406,549,405,548,390,532,391,533,407,550,390,532,407,550,406,549,391,533,392,534,408,551,391,533,408,551,407,550,392,534,378,535,394,552,392,534,394,552,408,551,394,537,393,536,409,553,394,537,409,553,410,554,393,536,395,538,411,555,393,536,411,555,409,553,395,538,396,539,412,556,395,538,412,556,411,555,396,539,397,540,413,557,396,539,413,557,412,556,397,540,398,541,414,558,397,540,414,558,413,557,398,541,399,542,415,559,398,541,415,559,414,558,399,542,400,543,416,560,399,542,416,560,415,559,400,543,401,544,417,561,400,543,417,561,416,560,401,544,402,545,418,562,401,544,418,562,417,561,402,545,403,546,419,563,402,545,419,563,418,562,403,546,404,547,420,564,403,546,420,564,419,563,404,547,405,548,421,565,404,547,421,565,420,564,405,548,406,549,422,566,405,548,422,566,421,565,406,549,407,550,423,567,406,549,423,567,422,566,407,550,408,551,424,568,407,550,424,568,423,567,408,551,394,552,410,569,408,551,410,569,424,568,410,554,409,553,425,570,410,554,425,570,426,571,409,553,411,555,427,572,409,553,427,572,425,570,411,555,412,556,428,573,411,555,428,573,427,572,412,556,413,557,429,574,412,556,429,574,428,573,413,557,414,558,430,575,413,557,430,575,429,574,414,558,415,559,431,576,414,558,431,576,430,575,415,559,416,560,432,577,415,559,432,577,431,576,416,560,417,561,433,578,416,560,433,578,432,577,417,561,418,562,434,579,417,561,434,579,433,578,418,562,419,563,435,580,418,562,435,580,434,579,419,563,420,564,436,581,419,563,436,581,435,580,420,564,421,565,437,582,420,564,437,582,436,581,421,565,422,566,438,583,421,565,438,583,437,582,422,566,423,567,439,584,422,566,439,584,438,583,423,567,424,568,440,585,423,567,440,585,439,584,424,568,410,569,426,586,424,568,426,586,440,585,426,571,425,570,441,587,426,571);
    }
    private static void method18(){
        MESH_4.getFaces().addAll(441,587,442,588,425,570,427,572,443,589,425,570,443,589,441,587,427,572,428,573,444,590,427,572,444,590,443,589,428,573,429,574,445,591,428,573,445,591,444,590,429,574,430,575,446,592,429,574,446,592,445,591,430,575,431,576,447,593,430,575,447,593,446,592,431,576,432,577,448,594,431,576,448,594,447,593,432,577,433,578,449,595,432,577,449,595,448,594,433,578,434,579,450,596,433,578,450,596,449,595,434,579,435,580,451,597,434,579,451,597,450,596,435,580,436,581,452,598,435,580,452,598,451,597,436,581,437,582,453,599,436,581,453,599,452,598,437,582,438,583,454,600,437,582,454,600,453,599,438,583,439,584,455,601,438,583,455,601,454,600,439,584,440,585,456,602,439,584,456,602,455,601,440,585,426,586,442,603,440,585,442,603,456,602,442,588,441,587,457,604,442,588,457,604,458,605,441,587,443,589,459,606,441,587,459,606,457,604,443,589,444,590,460,607,443,589,460,607,459,606,444,590,445,591,461,608,444,590,461,608,460,607,445,591,446,592,462,609,445,591,462,609,461,608,446,592,447,593,463,610,446,592,463,610,462,609,447,593,448,594,464,611,447,593,464,611,463,610,448,594,449,595,465,612,448,594,465,612,464,611,449,595,450,596,466,613,449,595,466,613,465,612,450,596,451,597,467,614,450,596,467,614,466,613,451,597,452,598,468,615,451,597,468,615,467,614,452,598,453,599,469,616,452,598,469,616,468,615,453,599,454,600,470,617,453,599,470,617,469,616,454,600,455,601,471,618,454,600,471,618,470,617,455,601,456,602,472,619,455,601,472,619,471,618,456,602,442,603,458,620,456,602,458,620,472,619,458,605,457,604,473,621,458,605,473,621,474,622,457,604,459,606,475,623,457,604,475,623,473,621,459,606,460,607,476,624,459,606,476,624,475,623,460,607,461,608,477,625,460,607,477,625,476,624,461,608,462,609,478,626,461,608,478,626,477,625,462,609,463,610,479,627,462,609,479,627,478,626,463,610,464,611,480,628,463,610,480,628,479,627,464,611,465,612,481,629,464,611,481,629,480,628,465,612,466,613,482,630,465,612,482,630,481,629,466,613,467,614,483,631,466,613,483,631,482,630,467,614,468,615,484,632,467,614,484,632,483,631,468,615,469,616,485,633,468,615,485,633,484,632,469,616,470,617,486,634,469,616,486,634,485,633,470,617,471,618,487,635,470,617,487,635,486,634,471,618,472,619,488,636,471,618,488,636,487,635,472,619,458,620,474,637,472,619,474,637,488,636,474,622,473,621,489,638,474,622,489,638,490,639,473,621,475,623,491,640,473,621,491,640,489,638,475,623,476,624,492,641,475,623,492,641,491,640,476,624,477,625,493,642,476,624,493,642,492,641,477,625,478,626,494,643,477,625,494,643,493,642,478,626,479,627,495,644,478,626,495,644,494,643,479,627,480,628,496,645,479,627,496,645,495,644,480,628,481,629,497,646,480,628,497,646,496,645,481,629,482,630,498,647,481,629,498,647,497,646,482,630,483,631,499,648,482,630,499,648,498,647,483,631,484,632,500,649,483,631,500,649,499,648,484,632,485,633,501,650,484,632,501,650,500,649,485,633,486,634,502,651,485,633,502,651,501,650,486,634,487,635,503,652,486,634,503,652,502,651,487,635,488,636,504,653,487,635,504,653,503,652,488,636,474,637,490,654,488,636,490,654,504,653,490,639,489,638,505,655,490,639,505,655,506,656,489,638,491,640,507,657,489,638,507,657,505,655,491,640,492,641,508,658,491,640,508,658,507,657,492,641,493,642,509,659,492,641,509,659,508,658,493,642,494,643,510,660,493,642,510,660,509,659,494,643,495,644,511,661,494,643,511,661,510,660,495,644,496,645,512,662,495,644,512,662,511,661,496,645,497,646,513,663,496,645,513,663,512,662,497,646,498,647,514,664,497,646,514,664,513,663,498,647,499,648,515,665,498,647,515,665,514,664,499,648,500,649,516,666,499,648,516,666,515,665,500,649,501,650,517,667,500,649,517,667,516,666,501,650,502,651,518,668,501,650,518,668,517,667,502,651,503,652,519,669,502,651,519,669,518,668,503,652,504,653,520,670,503,652,520,670,519,669,504,653,490,654,506,671,504,653,506,671,520,670,506,656,505,655,521,672,506,656,521,672,522,673,505,655,507,657,523,674,505,655,523,674,521,672,507,657,508,658,524,675,507,657,524,675,523,674,508,658,509,659,525,676,508,658,525,676,524,675,509,659,510,660,526,677,509,659,526,677,525,676,510,660,511,661,527,678,510,660,527,678,526,677,511,661,512,662,528,679,511,661,528,679,527,678,512,662,513,663,529,680,512,662,529,680,528,679,513,663,514,664,530,681,513,663,530,681,529,680,514,664,515,665,531,682,514,664,531,682,530,681,515,665,516,666,532,683,515,665,532,683,531,682,516,666,517,667,533,684,516,666,533,684,532,683,517,667,518,668,534,685,517,667,534,685,533,684,518,668,519,669,535,686,518,668,535,686,534,685,519,669,520,670,536,687,519,669,536,687,535,686,520,670,506,671,522,688,520,670,522,688,536,687,522,673,521,672,537,689,522,673,537,689,538,690,521,672,523,674,539,691,521,672,539,691,537,689,523,674,524,675,540,692,523,674,540,692,539,691,524,675,525,676,541,693,524,675,541,693,540,692,525,676,526,677,542,694,525,676,542,694,541,693,526,677,527,678,543,695,526,677,543,695,542,694,527,678,528,679,544,696,527,678,544,696,543,695,528,679,529,680,545,697,528,679,545,697,544,696,529,680,530,681,546,698,529,680,546,698,545,697,530,681,531,682,547,699,530,681,547,699,546,698,531,682,532,683,548,700,531,682,548,700,547,699,532,683,533,684,549,701,532,683,549,701,548,700,533,684,534,685,550,702,533,684,550,702,549,701,534,685,535,686,551,703,534,685,551,703,550,702,535,686,536,687,552,704,535,686,552,704,551,703,536,687,522,688,538,705,536,687,538,705,552,704,538,690,537,689,553,706,538,690,553,706,554,707,537,689,539,691,555,708,537,689,555,708,553,706,539,691,540,692,556,709,539,691,556,709,555,708,540,692,541,693,557,710,540,692,557,710,556,709,541,693,542,694,558,711,541,693,558,711,557,710,542,694,543,695,559,712,542,694,559,712,558,711,543,695,544,696,560,713,543,695,560,713,559,712,544,696,545,697,561,714,544,696,561,714,560,713,545,697,546,698,562,715,545,697,562,715,561,714,546,698,547,699,563,716,546,698,563,716,562,715,547,699,548,700,564,717,547,699,564,717,563,716,548,700,549,701,565,718,548,700,565,718,564,717,549,701,550,702,566,719,549,701,566,719,565,718,550,702,551,703,567,720,550,702,567,720,566,719,551,703,552,704,568,721,551,703,568,721,567,720,552,704,538,705,554,722,552,704,554,722,568,721,554,707,553,706,569,723,554,707,569,723,570,724,553,706,555,708,571,725,553,706,571,725,569,723,555,708,556,709,572,726,555,708,572,726,571,725,556,709,557,710,573,727,556,709,573,727,572,726,557,710,558,711,574,728,557,710,574,728,573,727,558,711,559,712,575,729,558,711,575,729,574,728,559,712,560,713,576,730,559,712,576,730,575,729,560,713,561,714,577,731,560,713,577,731,576,730,561,714,562,715,578,732,561,714,578,732,577,731,562,715,563,716,579,733,562,715,579,733,578,732,563,716,564,717,580,734,563,716,580,734,579,733,564,717,565,718,581,735,564,717,581,735,580,734,565,718,566,719,582,736,565,718,582,736,581,735,566,719,567,720,583,737,566,719,583,737,582,736,567,720,568,721,584,738,567,720,584,738,583,737,568,721,554,722,570,739,568,721,570,739,584,738,570,724,569,723,585,740,570,724,585,740,586,741,569,723,571,725,587,742,569,723,587,742,585,740,571,725,572,726,588,743,571,725,588,743,587,742,572,726,573,727,589,744,572,726,589,744,588,743,573,727,574,728,590,745,573,727,590,745,589,744,574,728,575,729,591,746,574,728,591,746,590,745,575,729,576,730,592,747,575,729,592,747,591,746,576,730,577,731,593,748,576,730,593,748,592,747,577,731,578,732,594,749,577,731,594,749,593,748,578,732,579,733,595,750,578,732,595,750,594,749,579,733,580,734,596,751,579,733,596,751,595,750,580,734,581,735,597,752,580,734,597,752,596,751,581,735,582,736,598,753,581,735,598,753,597,752,582,736,583,737,599,754,582,736,599,754,598,753,583,737,584,738,600,755,583,737,600,755,599,754,584,738,570,739,586,756,584,738,586,756,600,755,586,741,585,740,601,757,586,741,601,757,602,758,585,740,587,742,603,759,585,740,603,759,601,757,587,742,588,743,604,760,587,742,604,760,603,759,588,743,589,744,605,761,588,743,605,761,604,760,589,744,590,745,606,762,589,744,606,762,605,761,590,745,591,746,607,763,590,745,607,763,606,762,591,746,592,747,608,764,591,746,608,764,607,763,592,747,593,748,609,765,592,747,609,765,608,764,593,748,594,749,610,766,593,748,610,766,609,765,594,749,595,750,611,767,594,749,611,767,610,766,595,750,596,751,612,768,595,750,612,768,611,767,596,751,597,752,613,769,596,751,613,769,612,768,597,752,598,753,614,770,597,752,614,770,613,769,598,753,599,754,615,771,598,753,615,771,614,770,599,754,600,755,616,772,599,754,616,772,615,771,600,755,586,756,602,773,600,755,602,773,616,772,602,758,601,757,617,774,602,758,617,774,618,775,601,757,603,759,619,776,601,757,619,776,617,774,603,759,604,760,620,777,603,759,620,777,619,776,604,760,605,761,621,778,604,760,621,778,620,777,605,761,606,762,622,779,605,761,622,779,621,778,606,762,607,763,623,780,606,762,623,780,622,779,607,763,608,764,624,781,607,763,624,781,623,780,608,764,609,765,625,782,608,764,625,782,624,781,609,765,610,766,626,783,609,765,626,783,625,782,610,766,611,767,627,784,610,766,627,784,626,783,611,767,612,768,628,785,611,767,628,785,627,784,612,768,613,769,629,786,612,768,629,786,628,785,613,769,614,770,630,787,613,769,630,787,629,786,614,770,615,771,631,788,614,770,631,788,630,787,615,771,616,772,632,789,615,771,632,789,631,788,616,772,602,773,618,790,616,772,618,790,632,789,618,775,617,774,633,791,618,775,633,791,634,792,617,774,619,776,635,793,617,774,635,793,633,791,619,776,620,777,636,794,619,776,636,794,635,793,620,777,621,778,637,795,620,777,637,795,636,794,621,778,622,779,638,796,621,778,638,796,637,795,622,779,623,780,639,797,622,779,639,797,638,796,623,780,624,781,640,798,623,780,640,798,639,797,624,781,625,782,641,799,624,781,641,799,640,798,625,782,626,783,642,800,625,782,642,800,641,799,626,783,627,784,643,801,626,783,643,801,642,800,627,784,628,785,644,802,627,784,644,802,643,801,628,785,629,786,645,803,628,785,645,803,644,802,629,786,630,787,646,804,629,786,646,804,645,803,630,787,631,788,647,805,630,787,647,805,646,804,631,788,632,789,648,806,631,788,648,806,647,805,632,789,618,790,634,807,632,789,634,807,648,806,634,792,633,791,649,808,634,792,649,808,650,809,633,791,635,793,651,810,633,791,651,810,649,808,635,793,636,794,652,811,635,793,652,811,651,810,636,794,637,795,653,812,636,794,653,812,652,811,637,795,638,796,654,813,637,795,654,813,653,812,638,796,639,797,655,814,638,796,655,814,654,813,639,797,640,798,656,815,639,797,656,815,655,814,640,798,641,799,657,816,640,798,657,816,656,815,641,799,642,800,658,817,641,799,658,817,657,816,642,800,643,801,659,818,642,800,659,818,658,817,643,801,644,802,660,819,643,801,660,819,659,818,644,802,645,803,661,820,644,802,661,820,660,819,645,803,646,804,662,821,645,803,662,821,661,820,646,804,647,805,663,822,646,804,663,822,662,821,647,805,648,806,664,823,647,805,664,823,663,822,648,806,634,807,650,824,648,806,650,824,664,823,650,809,649,808,665,825,650,809,665,825,666,826,649,808,651,810,667,827,649,808,667,827,665,825,651,810,652,811,668,828,651,810,668,828,667,827,652,811,653,812,669,829,652,811,669,829,668,828,653,812,654,813,670,830,653,812,670,830,669,829,654,813,655,814,671,831,654,813,671,831,670,830,655,814,656,815,672,832,655,814,672,832,671,831,656,815,657,816,673,833,656,815,673,833,672,832,657,816,658,817,674,834,657,816,674,834,673,833,658,817,659,818,675,835,658,817,675,835,674,834,659,818,660,819,676,836,659,818,676,836,675,835,660,819,661,820,677,837,660,819,677,837,676,836,661,820,662,821,678,838,661,820,678,838,677,837,662,821,663,822,679,839,662,821,679,839,678,838,663,822,664,823,680,840,663,822,680,840,679,839,664,823,650,824,666,841,664,823,666,841,680,840,666,826,665,825,681,842,665,825,667,827,681,842,667,827,668,828,681,842,668,828,669,829,681,842,669,829,670,830,681,842,670,830,671,831,681,842,671,831,672,832,681,842,672,832,673,833,681,842,673,833,674,834,681,842,674,834,675,835,681,842,675,835,676,836,681,842,676,836,677,837,681,842,677,837,678,838,681,842,678,838,679,839,681,842,679,839,680,840,681,842,680,840,666,841,681,842,682,843,683,844,367,507,682,843,367,507,365,505,684,845,682,843,365,505,684,845,365,505,363,503,685,846,684,845,363,503,685,846,363,503,361,501,686,847,685,846,361,501,686,847,361,501,359,499,687,848,686,847,359,499,687,848,359,499,357,497,688,849,687,848,357,497,688,849,357,497,355,495,689,850,688,849,355,495,689,850,355,495,353,493,690,851,689,850,353,493,690,851,353,493,351,491,691,852,690,851,351,491,691,852,351,491,349,489,692,853,691,852,349,489,692,853,349,489,346,486,693,854,692,853,346,486,693,854,346,486,345,485,694,855,693,856,345,517,694,855,345,517,375,515,695,857,694,855,375,515,695,857,375,515,373,513,696,858,695,857,373,513,696,858,373,513,371,511,697,859,696,858,371,511,697,859,371,511,369,509,683,844,697,859,369,509,683,844,369,509,367,507,698,860,699,861,683,844,698,860,683,844,682,843,700,862,698,860,682,843,700,862,682,843,684,845,701,863,700,862,684,845,701,863,684,845,685,846,702,864,701,863,685,846,702,864,685,846,686,847,703,865,702,864,686,847,703,865,686,847,687,848,704,866,703,865,687,848,704,866,687,848,688,849,705,867,704,866,688,849,705,867,688,849,689,850,706,868,705,867,689,850,706,868,689,850,690,851,707,869,706,868,690,851,707,869,690,851,691,852,708,870,707,869,691,852,708,870,691,852,692,853,709,871,708,870,692,853,709,871,692,853,693,854,710,872,709,873,693,856,710,872,693,856,694,855,711,874,710,872,694,855,711,874,694,855,695,857,712,875,711,874,695,857,712,875,695,857,696,858,713,876,712,875,696,858,713,876,696,858,697,859,699,861,713,876,697,859,699,861,697,859,683,844,296,877,291,878,713,879,296,877,713,879,699,880,293,881,296,882,699,883,293,881,699,883,698,884,337,885,293,886,698,887,337,885,698,887,700,888,339,889,337,890,700,891,339,889,700,891,701,892,342,893,339,894,701,895,342,893,701,895,702,896,326,897,342,898,702,899,326,897,702,899,703,900,323,901,326,902,703,903,323,901,703,903,704,885,327,904,323,905,704,906,327,904,704,906,705,885,330,907,327,908,705,909,330,907,705,909,706,910,310,911,330,912,706,913,310,911,706,913,707,914,307,885,310,915,707,916,307,885,707,916,708,917,311,918,307,919,708,920,311,918,708,920,709,921,314,922,311,923,709,924,314,922,709,924,710,921,290,925,314,926,710,927,290,925,710,927,711,921,287,928,290,929,711,930,287,928,711,930,712,921,291,931,287,932,712,933,291,931,712,933,713,921);
    }
    private static void method19(){
        MESH_4.getFaceSmoothingGroups().ensureCapacity(1424);
        MESH_4.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_6 = MESHVIEWS[5];
        MESHVIEWS[5].setId("duke_model duke_model_L_arm_geo");
        MESHVIEWS[5].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_5 = new PhongMaterial();
        MATERIAL_5.setDiffuseColor(new Color(0.10000000149011612,0.10000000149011612,0.10000000149011612,1.0));
        MATERIAL_5.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_5.setSpecularPower(18.0);
        MESHVIEWS[5].setMaterial(MATERIAL_5);
        MESH_5 = new TriangleMesh();
        MESHVIEWS[5].setMesh(MESH_5);
        MESH_5.getPoints().ensureCapacity(687);
        MESH_5.getPoints().addAll(14.235777f,14.369329f,5.385171f,14.223873f,16.14184f,3.984848f,13.722689f,16.130304f,4.009975f,13.773911f,14.351593f,5.399909f,14.140902f,17.974392f,2.60661f,13.599316f,17.960289f,2.631804f,14.642575f,16.014214f,3.801873f,14.596214f,17.831135f,2.40233f,14.601828f,14.207283f,5.165618f,13.303344f,15.969023f,3.851965f,13.453427f,14.195689f,5.240627f,13.049988f,15.703076f,3.557635f,13.219374f,13.998021f,5.02538f,13.132764f,17.781883f,2.457252f,12.841761f,17.488796f,2.133765f,13.046727f,15.377665f,3.173735f,13.267813f,13.68905f,4.656916f,13.263541f,15.106142f,2.836473f,13.479673f,13.44532f,4.352844f,12.82689f,17.13069f,1.712196f,13.068538f,16.829836f,1.338392f,13.670457f,15.001938f,2.682031f,13.767998f,13.371631f,4.243595f,14.133305f,15.043611f,2.695491f,14.150274f,13.368511f,4.210387f,13.54729f,16.708632f,1.158331f,14.088071f,16.746443f,1.161187f,14.511471f,13.525162f,4.367405f,14.517708f,15.209616f,2.86175f,14.764461f,15.460825f,3.139221f,14.74206f,13.758296f,4.624789f,14.516004f,16.922752f,1.336249f,14.773704f,17.199198f,1.642663f,14.74797f,14.020745f,4.934134f,14.814453f,15.758142f,3.486295f,14.803789f,17.537354f,2.039506f,12.801616f,20.833612f,1.497602f,13.36426f,21.159353f,1.371279f,12.423027f,22.936205f,1.482117f,11.752642f,22.550873f,1.665084f,13.793303f,21.38079f,0.960995f,12.9457f,23.203316f,0.951436f,11.116345f,22.147146f,1.396314f,12.296791f,20.512989f,1.280707f,11.936288f,20.2572f,0.8134f,10.640818f,21.809534f,0.777443f,10.452744f,21.622559f,-0.08979f,11.80671f,20.126026f,0.188481f,11.901452f,20.129396f,-0.432337f,10.605289f,21.644823f,-0.893277f,11.151668f,21.934973f,-1.320792f,12.36381f,20.375923f,-0.782516f,12.90521f,20.689333f,-0.904451f,11.868189f,22.35722f,-1.395262f,13.740223f,21.23962f,-0.313289f,13.386796f,20.991919f,-0.73572f,12.53126f,22.77584f,-1.139582f,13.001359f,23.103397f,-0.600018f,13.897184f,21.388401f,0.325881f,13.138995f,23.25247f,0.177194f,14.165707f,19.433289f,1.354172f,13.599437f,19.345455f,1.4027f,14.149896f,19.746096f,1.194069f,13.562367f,19.576937f,1.272543f,14.633766f,19.371634f,1.104481f,14.589266f,19.769384f,0.894855f,14.401006f,20.20107f,0.821227f,13.970112f,20.066187f,1.194216f,13.408012f,19.807133f,1.295256f,12.816847f,18.84989f,0.885649f,13.121342f,19.13559f,1.231821f,13.083701f,19.338554f,1.110202f,12.780017f,19.07098f,0.745449f,12.642425f,19.304518f,0.765668f,12.944579f,19.53947f,1.137676f,12.771316f,18.534529f,0.408282f,13.009612f,18.31257f,-0.016328f,12.717345f,18.814196f,0.216654f,12.913467f,18.677166f,-0.244906f,12.571966f,19.147264f,0.223585f,12.690399f,19.083464f,-0.332558f,13.479944f,18.256613f,-0.257872f,14.04269f,18.357965f,-0.284139f,13.394172f,18.701147f,-0.566563f,13.952749f,18.866987f,-0.629881f,13.149544f,19.243608f,-0.638015f,13.657765f,19.473663f,-0.747922f,14.390529f,19.08784f,-0.475035f,14.481567f,18.557474f,-0.116572f,14.753945f,18.82565f,0.212771f,14.676561f,19.342167f,-0.126296f,14.078999f,19.715971f,-0.609029f,14.377918f,19.946873f,-0.247852f,14.817277f,19.133072f,0.671913f,14.779873f,19.608412f,0.392034f,14.519127f,20.142664f,0.309043f,11.275308f,24.939901f,1.692519f,10.411295f,24.447096f,1.972842f,9.575194f,23.921263f,1.674043f,8.951264f,23.478739f,0.867283f,8.723714f,23.235832f,-0.376298f,8.948597f,23.271366f,-1.52922f,9.682064f,23.664228f,-2.063988f,10.653788f,24.24344f,-2.088438f,11.593538f,24.838087f,-1.710381f,12.240868f,25.286835f,-0.994164f,12.33528f,25.428314f,-0.004233f,11.979241f,25.300123f,0.98337f,9.9683f,25.24826f,1.963637f,9.103435f,24.70428f,1.654725f,8.457762f,24.246328f,0.820251f,8.221982f,23.994785f,-0.466304f,8.454087f,24.031252f,-1.659096f,9.212196f,24.43742f,-2.212162f,10.217024f,25.036509f,-2.237371f,11.189255f,25.651722f,-1.846637f,11.859223f,26.1161f,-1.106111f,11.957234f,26.262669f,-0.081986f,11.589382f,26.130322f,0.939857f,10.861695f,25.757908f,1.67356f,8.856237f,25.36603f,1.371173f,8.287347f,24.962576f,0.635978f,8.079598f,24.740967f,-0.497522f,8.284115f,24.773083f,-1.548393f,8.952077f,25.130836f,-2.035642f,9.837402f,25.658554f,-2.057866f,10.693978f,26.20054f,-1.713613f,11.284246f,26.609676f,-1.061175f,11.370597f,26.738806f,-0.158899f,11.046503f,26.622227f,0.741361f,10.405365f,26.294184f,1.387767f,9.618216f,25.845234f,1.643323f,8.788446f,25.88945f,0.919859f,8.359358f,25.585314f,0.365407f,8.202634f,25.418251f,-0.489449f,8.356937f,25.442377f,-1.28194f,8.86092f,25.711788f,-1.649376f,9.528811f,26.109354f,-1.666099f,10.174882f,26.517962f,-1.406474f,10.620024f,26.826504f,-0.914444f,10.68516f,26.923895f,-0.233979f,10.440691f,26.83606f,0.444948f,9.957002f,26.588917f,0.932414f,9.36322f,26.250654f,1.125135f,8.844769f,26.264355f,0.409512f,8.578331f,26.08212f,0.068392f,8.480377f,25.982191f,-0.457135f,8.577504f,25.993149f,-0.94381f,8.896266f,26.143536f,-1.168287f,9.316034f,26.37224f,-1.177222f,9.716159f,26.618135f,-1.017245f,9.989711f,26.807713f,-0.714889f,10.029802f,26.867476f,-0.296716f,9.877589f,26.81678f,0.120201f,9.574306f,26.675049f,0.418875f,9.202511f,26.47873f,0.536306f,8.97643f,26.466417f,-0.044749f,8.863114f,26.388916f,-0.189811f,8.821486f,26.346434f,-0.413308f,8.862767f,26.351078f,-0.620267f,8.998321f,26.415035f,-0.715736f,9.176844f,26.512299f,-0.719525f,9.34699f,26.616863f,-0.651497f,9.46333f,26.697483f,-0.522913f,9.480358f,26.722887f,-0.345096f,9.415656f,26.701351f,-0.16778f,9.286677f,26.641068f,-0.040762f,9.128581f,26.557589f,0.009172f,9.12708f,26.520363f,-0.371063f,9.12683f,26.520193f,-0.371378f,9.126747f,26.520103f,-0.371875f,9.126824f,26.520105f,-0.372322f,9.127124f,26.520245f,-0.372546f,9.127504f,26.520458f,-0.372558f,9.127882f,26.520683f,-0.372403f,9.128127f,26.520853f,-0.372128f,9.128169f,26.520912f,-0.371724f,9.128034f,26.520876f,-0.371336f,9.127759f,26.520742f,-0.371044f,9.127414f,26.520557f,-0.370939f,14.198573f,14.121805f,5.451347f,14.51286f,13.969126f,5.275216f,14.638113f,13.807333f,5.07881f,14.63285f,13.585483f,4.811574f,14.435601f,13.383466f,4.593313f,14.125811f,13.258348f,4.451273f,13.797732f,13.273242f,4.469345f,13.550244f,13.346535f,4.554213f,13.368679f,13.558139f,4.812057f,13.327524f,13.817856f,5.131534f,13.527797f,13.988702f,5.314421f,13.802629f,14.114703f,5.45711f,14.150258f,13.927188f,5.425649f,14.394878f,13.808341f,5.288571f,14.492363f,13.68242f,5.135697f,14.488271f,13.50975f,4.927703f,14.334752f,13.352508f,4.75783f,14.093634f,13.255129f,4.647269f,13.838284f,13.266722f,4.661344f,13.645649f,13.323779f,4.727395f,13.504334f,13.488468f,4.92807f,13.472304f,13.690613f,5.176739f,13.628186f,13.823583f,5.319088f,13.842093f,13.921656f,5.430141f,14.082928f,13.705788f,5.345705f,14.229937f,13.634373f,5.263324f,14.288514f,13.558695f,5.171449f,14.286051f,13.454926f,5.046448f,14.193796f,13.360428f,4.944365f,14.048899f,13.301912f,4.877925f,13.895439f,13.308879f,4.886375f,13.779672f,13.343163f,4.926076f,13.694748f,13.442134f,5.046673f,13.675497f,13.563616f,5.196114f,13.769184f,13.643533f,5.281661f,13.897727f,13.702479f,5.348396f,14.018418f,13.553156f,5.216431f,14.071296f,13.527466f,5.186806f,14.092362f,13.500238f,5.153756f,14.091478f,13.462912f,5.108787f,14.058292f,13.428919f,5.07207f,14.006178f,13.407873f,5.048166f,13.950974f,13.410378f,5.051211f,13.909327f,13.422709f,5.06549f,13.878783f,13.458314f,5.108871f,13.871852f,13.502015f,5.162625f,13.905555f,13.530766f,5.193398f,13.951796f,13.551969f,5.217406f,13.982183f,13.469604f,5.141926f);
    }
    private static void method20(){
        MESH_5.getTexCoords().ensureCapacity(2);
        MESH_5.getTexCoords().addAll(0.0f,0.0f);
    }
    private static void method21(){
        MESH_5.getFaces().ensureCapacity(2664);
        MESH_5.getFaces().addAll(0,0,1,0,2,0,0,0,2,0,3,0,2,0,1,0,4,0,2,0,4,0,5,0,4,0,1,0,6,0,4,0,6,0,7,0,6,0,1,0,0,0,6,0,0,0,8,0,2,0,9,0,10,0,2,0,10,0,3,0,10,0,9,0,11,0,10,0,11,0,12,0,11,0,9,0,13,0,11,0,13,0,14,0,13,0,9,0,2,0,13,0,2,0,5,0,11,0,15,0,16,0,11,0,16,0,12,0,16,0,15,0,17,0,16,0,17,0,18,0,17,0,15,0,19,0,17,0,19,0,20,0,19,0,15,0,11,0,19,0,11,0,14,0,17,0,21,0,22,0,17,0,22,0,18,0,22,0,21,0,23,0,22,0,23,0,24,0,23,0,21,0,25,0,23,0,25,0,26,0,25,0,21,0,17,0,25,0,17,0,20,0,27,0,28,0,29,0,27,0,29,0,30,0,29,0,28,0,31,0,29,0,31,0,32,0,31,0,28,0,23,0,31,0,23,0,26,0,23,0,28,0,27,0,23,0,27,0,24,0,33,0,34,0,6,0,33,0,6,0,8,0,6,0,34,0,35,0,6,0,35,0,7,0,35,0,34,0,29,0,35,0,29,0,32,0,29,0,34,0,33,0,29,0,33,0,30,0,36,0,37,0,38,0,36,0,38,0,39,0,38,0,37,0,40,0,38,0,40,0,41,0,42,0,43,0,36,0,42,0,36,0,39,0,44,0,43,0,42,0,44,0,42,0,45,0,46,0,47,0,44,0,46,0,44,0,45,0,48,0,47,0,46,0,48,0,46,0,49,0,50,0,51,0,48,0,50,0,48,0,49,0,52,0,51,0,50,0,52,0,50,0,53,0,54,0,55,0,56,0,54,0,56,0,57,0,56,0,55,0,52,0,56,0,52,0,53,0,40,0,58,0,59,0,40,0,59,0,41,0,59,0,58,0,54,0,59,0,54,0,57,0,4,0,60,0,61,0,4,0,61,0,5,0,61,0,60,0,62,0,61,0,62,0,63,0,62,0,60,0,64,0,62,0,64,0,65,0,64,0,60,0,4,0,64,0,4,0,7,0,66,0,67,0,62,0,66,0,62,0,65,0,62,0,67,0,68,0,62,0,68,0,63,0,36,0,68,0,67,0,36,0,67,0,37,0,37,0,67,0,66,0,37,0,66,0,40,0,69,0,70,0,71,0,69,0,71,0,72,0,71,0,70,0,61,0,71,0,61,0,63,0,61,0,70,0,13,0,61,0,13,0,5,0,13,0,70,0,69,0,13,0,69,0,14,0,44,0,73,0,74,0,44,0,74,0,43,0,43,0,74,0,68,0,43,0,68,0,36,0,68,0,74,0,71,0,68,0,71,0,63,0,71,0,74,0,73,0,71,0,73,0,72,0,69,0,75,0,19,0,69,0,19,0,14,0,19,0,75,0,76,0,19,0,76,0,20,0,76,0,75,0,77,0,76,0,77,0,78,0,77,0,75,0,69,0,77,0,69,0,72,0,77,0,79,0,80,0,77,0,80,0,78,0,48,0,80,0,79,0,48,0,79,0,47,0,47,0,79,0,73,0,47,0,73,0,44,0,73,0,79,0,77,0,73,0,77,0,72,0,76,0,81,0,25,0,76,0,25,0,20,0,25,0,81,0,82,0,25,0,82,0,26,0,82,0,81,0,83,0,82,0,83,0,84,0,83,0,81,0,76,0,83,0,76,0,78,0,80,0,85,0,83,0,80,0,83,0,78,0,83,0,85,0,86,0,83,0,86,0,84,0,52,0,86,0,85,0,52,0,85,0,51,0,51,0,85,0,80,0,51,0,80,0,48,0,87,0,88,0,82,0,87,0,82,0,84,0,82,0,88,0,31,0,82,0,31,0,26,0,31,0,88,0,89,0,31,0,89,0,32,0,89,0,88,0,87,0,89,0,87,0,90,0,87,0,91,0,92,0,87,0,92,0,90,0,54,0,92,0,91,0,54,0,91,0,55,0,55,0,91,0,86,0,55,0,86,0,52,0,86,0,91,0,87,0,86,0,87,0,84,0,35,0,93,0,64,0,35,0,64,0,7,0,64,0,93,0,94,0,64,0,94,0,65,0,94,0,93,0,89,0,94,0,89,0,90,0,89,0,93,0,35,0,89,0,35,0,32,0,94,0,95,0,66,0,94,0,66,0,65,0,40,0,66,0,95,0,40,0,95,0,58,0,58,0,95,0,92,0,58,0,92,0,54,0,92,0,95,0,94,0,92,0,94,0,90,0,38,0,96,0,97,0,38,0,97,0,39,0,98,0,42,0,39,0,98,0,39,0,97,0,42,0,98,0,99,0,42,0,99,0,45,0,100,0,46,0,45,0,100,0,45,0,99,0,46,0,100,0,101,0,46,0,101,0,49,0,102,0,50,0,49,0,102,0,49,0,101,0,50,0,102,0,103,0,50,0,103,0,53,0,104,0,56,0,53,0,104,0,53,0,103,0,56,0,104,0,105,0,56,0,105,0,57,0,106,0,59,0,57,0,106,0,57,0,105,0,59,0,106,0,107,0,59,0,107,0,41,0,96,0,38,0,41,0,96,0,41,0,107,0,97,0,108,0,109,0,97,0,109,0,98,0,98,0,109,0,110,0,98,0,110,0,99,0,99,0,110,0,111,0,99,0,111,0,100,0,100,0,111,0,112,0,100,0,112,0,101,0,101,0,112,0,113,0,101,0,113,0,102,0,102,0,113,0,114,0,102,0,114,0,103,0,103,0,114,0,115,0,103,0,115,0,104,0,104,0,115,0,116,0,104,0,116,0,105,0,105,0,116,0,117,0,105,0,117,0,106,0,106,0,117,0,118,0,106,0,118,0,107,0,107,0,118,0,119,0,107,0,119,0,96,0,96,0,119,0,108,0,96,0,108,0,97,0,109,0,120,0,121,0,109,0,121,0,110,0,110,0,121,0,122,0,110,0,122,0,111,0,111,0,122,0,123,0,111,0,123,0,112,0,112,0,123,0,124,0,112,0,124,0,113,0,113,0,124,0,125,0,113,0,125,0,114,0,114,0,125,0,126,0,114,0,126,0,115,0,115,0,126,0,127,0,115,0,127,0,116,0,116,0,127,0,128,0,116,0,128,0,117,0,117,0,128,0,129,0,117,0,129,0,118,0,118,0,129,0,130,0,118,0,130,0,119,0,119,0,130,0,131,0,119,0,131,0,108,0,108,0,131,0,120,0,108,0,120,0,109,0,120,0,132,0,133,0,120,0,133,0,121,0,121,0,133,0,134,0,121,0,134,0,122,0,122,0,134,0,135,0,122,0,135,0,123,0,123,0,135,0,136,0,123,0,136,0,124,0,124,0,136,0,137,0,124,0,137,0,125,0,125,0,137,0,138,0,125,0,138,0,126,0,126,0,138,0,139,0,126,0,139,0,127,0,127,0,139,0,140,0,127,0,140,0,128,0,128,0,140,0,141,0,128,0,141,0,129,0,129,0,141,0,142,0,129,0,142,0,130,0,130,0,142,0,143,0,130,0,143,0,131,0,131,0,143,0,132,0,131,0,132,0,120,0,132,0,144,0,145,0,132,0,145,0,133,0,133,0,145,0,146,0,133,0,146,0,134,0,134,0,146,0,147,0,134,0,147,0,135,0,135,0,147,0,148,0,135,0,148,0,136,0,136,0,148,0,149,0,136,0,149,0,137,0,137,0,149,0,150,0,137,0,150,0,138,0,138,0,150,0,151,0,138,0,151,0,139,0,139,0,151,0,152,0,139,0,152,0,140,0,140,0,152,0,153,0,140,0,153,0,141,0,141,0,153,0,154,0,141,0,154,0,142,0,142,0,154,0,155,0,142,0,155,0,143,0,143,0,155,0,144,0,143,0,144,0,132,0,144,0,156,0,157,0,144,0,157,0,145,0,145,0,157,0,158,0,145,0,158,0,146,0,146,0,158,0,159,0,146,0,159,0,147,0,147,0,159,0,160,0,147,0,160,0,148,0,148,0,160,0,161,0,148,0,161,0,149,0,149,0,161,0,162,0,149,0,162,0,150,0,150,0,162,0,163,0,150,0,163,0,151,0,151,0,163,0,164,0,151,0,164,0,152,0,152,0,164,0,165,0,152,0,165,0,153,0,153,0,165,0,166,0,153,0,166,0,154,0,154,0,166,0,167,0,154,0,167,0,155,0,155,0,167,0,156,0,155,0,156,0,144,0,156,0,168,0,169,0,156,0,169,0,157,0,157,0,169,0,170,0,157,0,170,0,158,0,158,0,170,0,171,0,158,0,171,0,159,0,159,0,171,0,172,0,159,0,172,0,160,0,160,0,172,0,173,0,160,0,173,0,161,0,161,0,173,0,174,0,161,0,174,0,162,0,162,0,174,0,175,0,162,0,175,0,163,0,163,0,175,0,176,0,163,0,176,0,164,0,164,0,176,0,177,0,164,0,177,0,165,0,165,0,177,0,178,0,165,0,178,0,166,0,166,0,178,0,179,0,166,0,179,0,167,0,167,0,179,0,168,0,167,0,168,0,156,0,0,0,180,0,181,0,0,0,181,0,8,0,8,0,181,0,182,0,8,0,182,0,33,0,33,0,182,0,183,0,33,0,183,0,30,0,30,0,183,0,184,0,30,0,184,0,27,0,27,0,184,0,185,0,27,0,185,0,24,0,24,0,185,0,186,0,24,0,186,0,22,0,22,0,186,0,187,0,22,0,187,0,18,0,18,0,187,0,188,0,18,0,188,0,16,0,16,0,188,0,189,0,16,0,189,0,12,0,12,0,189,0,190,0,12,0,190,0,10,0,10,0,190,0,191,0,10,0,191,0,3,0,3,0,191,0,180,0,3,0,180,0,0,0,180,0,192,0,193,0,180,0,193,0,181,0,181,0,193,0,194,0,181,0,194,0,182,0,182,0,194,0,195,0,182,0,195,0,183,0,183,0,195,0,196,0,183,0,196,0,184,0,184,0,196,0,197,0,184,0,197,0,185,0,185,0,197,0,198,0,185,0,198,0,186,0,186,0,198,0,199,0,186,0,199,0,187,0,187,0,199,0,200,0,187,0,200,0,188,0,188,0,200,0,201,0,188,0,201,0,189,0,189,0,201,0,202,0,189,0,202,0,190,0,190,0,202,0,203,0,190,0,203,0,191,0,191,0,203,0,192,0,191,0,192,0,180,0,192,0,204,0,205,0,192,0,205,0,193,0,193,0,205,0,206,0,193,0,206,0,194,0,194,0,206,0,207,0,194,0,207,0,195,0,195,0,207,0,208,0,195,0,208,0,196,0,196,0,208,0,209,0,196,0,209,0,197,0,197,0,209,0,210,0,197,0,210,0,198,0,198,0,210,0,211,0,198,0,211,0,199,0,199,0,211,0,212,0,199,0,212,0,200,0,200,0,212,0,213,0,200,0,213,0,201,0,201,0,213,0,214,0,201,0,214,0,202,0,202,0,214,0,215,0,202,0,215,0,203,0,203,0,215,0,204,0,203,0,204,0,192,0,204,0,216,0,217,0,204,0,217,0,205,0,205,0,217,0,218,0,205,0,218,0,206,0,206,0,218,0,219,0,206,0,219,0,207,0,207,0,219,0,220,0,207,0,220,0,208,0,208,0,220,0,221,0,208,0,221,0,209,0,209,0,221,0,222,0,209,0,222,0,210,0,210,0,222,0,223,0,210,0,223,0,211,0,211,0,223,0,224,0,211,0,224,0,212,0,212,0,224,0,225,0,212,0,225,0,213,0,213,0,225,0,226,0,213,0,226,0,214,0,214,0,226,0,227,0,214,0,227,0,215,0,215,0,227,0,216,0,215,0,216,0,204,0,216,0,228,0,217,0,217,0,228,0,218,0,218,0,228,0,219,0,219,0,228,0,220,0,220,0,228,0,221,0,221,0,228,0,222,0,222,0,228,0,223,0,223,0,228,0,224,0,224,0,228,0,225,0,225,0,228,0,226,0,226,0,228,0,227,0,227,0,228,0,216,0);
    }
    private static void method22(){
        MESH_5.getFaceSmoothingGroups().ensureCapacity(444);
        MESH_5.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_7 = MESHVIEWS[6];
        MESHVIEWS[6].setId("duke_model duke_model_R_hand_geo");
        MESHVIEWS[6].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_6 = new PhongMaterial();
        MATERIAL_6.setDiffuseColor(new Color(0.10000000149011612,0.10000000149011612,0.10000000149011612,1.0));
        MATERIAL_6.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_6.setSpecularPower(18.0);
        MESHVIEWS[6].setMaterial(MATERIAL_6);
        MESH_6 = new TriangleMesh();
        MESHVIEWS[6].setMesh(MESH_6);
        MESH_6.getPoints().ensureCapacity(1518);
        MESH_6.getPoints().addAll(-14.323475f,9.646244f,5.421777f,-14.922297f,9.850746f,5.579554f,-14.835655f,10.553572f,5.180486f,-14.247437f,10.303872f,5.025424f,-14.652959f,11.082679f,4.978962f,-14.159016f,10.999554f,4.800507f,-13.690138f,10.926289f,4.769495f,-13.64152f,10.412415f,4.976688f,-13.706176f,9.801818f,5.473492f,-14.412313f,8.720744f,6.549732f,-14.97265f,8.94082f,6.718768f,-14.949325f,9.298739f,6.120647f,-14.344867f,9.103516f,5.978805f,-13.711291f,9.264546f,6.095804f,-13.777479f,8.848058f,6.628986f,-13.022951f,11.616829f,5.385722f,-13.131701f,11.032118f,6.231443f,-13.324874f,10.319348f,5.787031f,-13.249112f,10.90235f,5.093394f,-13.401562f,11.400396f,4.656014f,-13.081885f,12.162921f,4.617284f,-13.086594f,10.489052f,6.985455f,-13.085363f,10.00976f,7.572709f,-13.31932f,9.335134f,6.97474f,-13.310526f,9.790872f,6.478198f,-13.682946f,10.584542f,6.068194f,-13.531808f,10.722062f,5.696656f,-13.719255f,10.489216f,5.407803f,-13.902761f,10.227016f,5.779448f,-13.647835f,9.996846f,5.252825f,-13.812791f,9.732167f,5.504295f,-13.712992f,9.539561f,5.874207f,-13.776481f,9.827515f,6.164682f,-13.616979f,10.161323f,6.342435f,-15.207422f,9.495834f,7.117954f,-15.145784f,10.199885f,7.725596f,-15.306182f,10.635297f,7.091708f,-15.26268f,9.841119f,6.514705f,-15.303399f,11.223436f,6.3792f,-15.248075f,10.413419f,5.894449f,-15.261814f,11.960072f,5.726301f,-15.174995f,11.138458f,5.382772f,-15.027978f,12.567491f,5.080061f,-14.855192f,11.670133f,4.995821f,-14.088379f,12.18823f,4.61491f,-14.100455f,11.706895f,4.688524f,-12.644821f,13.128346f,6.384358f,-12.853767f,12.486915f,7.113296f,-13.078751f,11.773228f,6.675751f,-12.915686f,12.399068f,5.863805f,-12.763411f,12.908238f,5.227457f,-12.628221f,13.803744f,5.844127f,-12.765658f,11.829523f,7.959366f,-12.723928f,11.426611f,8.60102f,-12.896961f,10.759733f,8.049417f,-12.983705f,11.165613f,7.477008f,-13.301469f,12.594826f,6.835643f,-13.16916f,12.76004f,6.367199f,-13.501987f,12.500442f,5.910114f,-13.650975f,12.15065f,6.446224f,-13.429546f,11.884661f,5.737359f,-13.595594f,11.521273f,6.096257f,-13.387891f,11.20604f,6.60096f,-13.395054f,11.615656f,7.021793f,-13.177547f,12.093403f,7.219685f,-15.081078f,11.192536f,8.344879f,-14.646913f,12.063697f,9.079138f,-14.701063f,12.559096f,8.489432f,-15.100984f,11.585989f,7.782429f,-14.675615f,13.155554f,7.747187f,-15.090726f,12.16985f,7.046495f,-14.707645f,13.868737f,6.937525f,-15.092536f,12.920005f,6.305124f,-14.59238f,14.491226f,6.214052f,-15.048985f,13.530872f,5.7111f,-14.837935f,14.232511f,4.686642f,-14.437261f,14.673624f,5.072155f,-13.757971f,14.682711f,5.07815f,-14.019445f,13.955412f,4.454371f,-13.226671f,14.377812f,4.867592f,-13.199172f,13.802494f,4.390824f,-13.568346f,13.393458f,4.099453f,-14.194729f,13.397304f,4.053625f,-14.795694f,13.656525f,4.27763f,-11.463655f,14.353486f,6.949008f,-11.561437f,13.834256f,7.62147f,-12.144575f,13.117401f,7.537376f,-11.927687f,13.683928f,6.804052f,-12.024849f,14.22356f,6.336803f,-11.683201f,14.882948f,6.685079f,-11.899856f,13.118423f,8.895803f,-12.058095f,12.837708f,9.454565f,-12.199014f,12.206694f,8.996502f,-12.196317f,12.489832f,8.439105f,-12.401171f,14.072117f,7.935842f,-12.292419f,14.244094f,7.533298f,-12.580554f,14.01155f,7.064645f,-12.685631f,13.670157f,7.519959f,-12.532574f,13.467399f,6.814621f,-12.661264f,13.137428f,7.149914f,-12.532197f,12.85394f,7.694514f,-12.481871f,13.198029f,8.0211f,-12.287225f,13.650308f,8.200377f,-13.52967f,13.40298f,9.892384f,-13.439944f,13.890134f,9.456483f,-14.160447f,13.420618f,9.115363f,-14.192276f,12.921633f,9.570155f,-12.977147f,14.516322f,8.945737f,-14.123643f,14.083442f,8.332173f,-13.236623f,15.090022f,8.277087f,-14.147718f,14.656738f,7.441817f,-13.204974f,15.37471f,7.613008f,-13.866836f,14.937015f,6.684694f,-12.46197f,15.267341f,6.985404f,-12.915213f,14.71693f,6.306691f,-13.494126f,14.445481f,6.028311f,-9.34796f,12.42142f,9.164776f,-9.814112f,12.416952f,8.893384f,-9.68082f,12.284359f,8.360091f,-9.044452f,12.274618f,8.497779f,-9.527715f,12.443698f,7.825052f,-8.981453f,12.448828f,7.768837f,-8.722335f,12.691951f,7.9509f,-8.648585f,12.5859f,8.573524f,-8.968879f,12.687234f,9.101578f,-12.659965f,13.305734f,9.80353f,-12.500408f,13.687299f,9.309115f,-12.086486f,14.131136f,8.532319f,-13.49692f,9.535998f,6.472345f,-13.333341f,9.982986f,6.832732f,-13.044092f,9.725262f,7.034977f,-13.210582f,9.293802f,6.688554f,-13.692161f,8.862187f,6.460271f,-13.308f,8.667118f,6.584627f,-14.004887f,8.810704f,6.737678f,-13.653634f,9.376823f,6.94162f,-13.399664f,9.978234f,7.448566f,-13.328167f,9.765782f,7.53342f,-12.872589f,9.560814f,7.552554f,-13.751763f,9.712771f,7.905124f,-14.389068f,9.526115f,8.241611f,-13.439037f,9.206836f,8.051905f,-12.801007f,9.067616f,7.880642f,-13.623555f,8.628704f,7.865652f,-12.934273f,8.51287f,7.658617f,-14.626073f,8.942245f,7.746331f,-14.620014f,8.524598f,7.239563f,-13.776419f,8.277389f,7.331056f,-13.13662f,8.153348f,7.194066f,-13.792312f,8.39891f,6.804569f,-13.272264f,8.245858f,6.794619f,-14.369992f,8.503674f,6.870183f,-13.62029f,9.609771f,6.474712f,-13.351263f,10.060111f,6.82367f,-13.023574f,10.227577f,6.486691f,-13.305249f,9.742538f,6.152335f,-13.480556f,9.013204f,6.112724f,-13.249647f,9.197145f,5.714113f,-13.29447f,8.684843f,6.546317f,-13.366289f,9.270189f,6.812374f,-13.16527f,9.701947f,7.152274f,-12.628059f,10.005404f,6.934065f,-12.393265f,10.329583f,6.461519f,-12.660035f,9.615202f,7.392575f,-11.992209f,9.606627f,6.801737f,-12.235073f,9.202341f,7.416617f,-11.85997f,10.080889f,6.176763f,-11.985329f,9.02477f,6.422517f,-11.895548f,9.510035f,5.733766f,-12.274874f,8.655773f,7.107748f,-12.387195f,8.589145f,6.056334f,-12.587532f,8.262801f,6.725028f,-12.289188f,8.996463f,5.395693f,-12.977561f,8.629144f,5.963169f,-12.830122f,8.919678f,5.425753f,-12.981126f,8.310772f,6.527553f,-13.305543f,10.040624f,6.663317f,-13.504409f,9.514424f,6.46811f,-13.597041f,9.208873f,5.941929f,-13.227646f,9.177774f,5.764398f,-13.169131f,9.583226f,6.291916f,-12.933956f,10.1102f,6.550235f,-13.067825f,10.5825f,6.269314f,-12.570761f,10.511899f,6.25329f,-12.942153f,10.811016f,5.643731f,-12.319093f,10.582424f,5.696575f,-13.07941f,10.397168f,5.144181f,-12.431719f,10.101846f,5.187578f,-13.322925f,9.762619f,4.975648f,-12.731569f,9.48859f,4.957232f,-13.515997f,9.329087f,5.342999f,-13.041543f,9.161076f,5.236497f,-13.072251f,11.212104f,7.541225f,-12.922748f,11.529453f,8.142264f,-12.405007f,11.249629f,8.332637f,-12.640404f,10.872058f,7.782492f,-13.272952f,10.581048f,7.345244f,-12.80015f,10.231543f,7.50918f,-13.819965f,10.481266f,7.40995f,-13.269581f,10.941913f,8.006145f,-13.349433f,11.716589f,8.411635f,-12.902738f,11.321173f,8.969841f,-13.01869f,10.74463f,9.488152f,-12.131485f,10.5807f,9.260185f,-12.194624f,11.104826f,8.949844f,-13.041585f,11.317819f,9.073115f,-14.041216f,11.324632f,9.594794f,-13.277043f,9.957316f,9.161354f,-12.337807f,9.820273f,8.889795f,-14.45843f,10.485383f,9.021208f,-14.544368f,9.701079f,8.311106f,-13.484198f,9.483691f,8.429547f,-12.619772f,9.322804f,8.242579f,-13.44655f,9.848263f,7.732752f,-12.783581f,9.58752f,7.722456f,-13.342306f,9.636003f,7.891273f,-12.564008f,11.897501f,7.953605f,-13.105855f,11.270468f,7.433922f,-12.860292f,10.814986f,7.956361f,-12.461913f,11.28442f,8.428055f,-12.217695f,12.243767f,7.460153f,-12.74192f,11.473013f,6.941653f,-13.175347f,10.469357f,6.895846f,-12.874506f,10.635304f,6.305011f,-12.938313f,10.145534f,7.561794f,-11.767816f,11.868724f,8.095715f,-11.881143f,11.228544f,8.728377f,-11.168254f,11.366733f,7.888536f,-11.469596f,10.765873f,8.719818f,-11.035226f,11.971567f,7.048363f,-11.530017f,12.365875f,7.441198f,-11.578841f,10.014873f,8.264865f,-11.216372f,10.574085f,7.360317f,-11.736842f,9.955527f,6.850498f,-12.008451f,9.463913f,7.73279f,-11.607856f,10.491699f,5.980278f,-11.115461f,11.196704f,6.452392f,-12.554443f,9.97581f,6.698505f,-12.557995f,9.601324f,7.492852f,-12.34966f,10.306987f,5.959048f,-12.80059f,12.032525f,7.60948f,-13.105064f,11.229877f,7.332164f,-13.277562f,10.702406f,6.651305f,-12.77526f,10.511859f,6.341091f,-12.607973f,11.215782f,7.080472f,-12.218515f,12.095466f,7.520072f,-12.523194f,12.668621f,7.176902f,-11.801474f,12.586299f,7.229035f,-12.404746f,12.860555f,6.418442f,-11.552989f,12.578002f,6.547812f,-12.577146f,12.330629f,5.71814f,-11.684291f,11.947794f,5.836274f,-12.881516f,11.525538f,5.42134f,-12.049754f,11.131902f,5.43996f,-13.159014f,10.891884f,5.873372f,-12.503817f,10.566499f,5.704488f,-12.377983f,12.709569f,8.681674f,-12.200903f,13.111357f,9.316229f,-11.76052f,12.834114f,9.558088f,-12.034642f,12.414679f,8.966877f,-12.598075f,12.031299f,8.425554f,-12.21581f,11.766885f,8.613974f,-12.878992f,11.626935f,8.678425f,-12.699629f,11.267386f,8.841022f,-12.685089f,12.515628f,8.875258f,-12.571167f,12.418486f,9.030806f,-12.543233f,13.092234f,9.379924f,-12.459424f,12.972618f,9.548849f,-12.188221f,12.934803f,9.973208f,-12.313485f,12.369167f,10.362903f,-11.507085f,12.250447f,10.203835f,-11.562159f,12.737043f,10.026789f,-12.821579f,13.234787f,9.938578f,-12.733793f,13.091967f,10.068974f,-13.28938f,12.964926f,10.26907f,-13.181638f,12.808722f,10.345924f,-13.715855f,12.304251f,10.08927f,-13.590285f,12.155016f,10.134499f,-14.074099f,11.453735f,9.610935f,-13.822667f,11.383739f,9.662491f,-11.911469f,10.980539f,9.398142f,-11.662797f,11.501329f,9.920145f,-12.550117f,11.603638f,10.19566f,-12.743726f,11.114574f,9.649931f,-12.739844f,11.378384f,8.90411f,-12.135273f,11.178946f,8.860251f,-13.181828f,11.393972f,9.050835f,-13.267438f,11.334526f,9.192139f,-11.742133f,13.439185f,8.993445f,-12.371261f,12.910047f,8.519873f,-12.106215f,12.406151f,9.044783f,-11.675353f,12.86656f,9.55611f,-11.435595f,13.796876f,8.421054f,-12.006875f,13.137184f,8.032286f,-12.562324f,12.211533f,8.024618f,-12.22543f,12.429368f,7.508563f,-12.267f,11.759547f,8.622116f,-10.632783f,13.052098f,8.964186f,-11.084894f,13.470325f,9.146375f,-11.240893f,12.840931f,9.83248f,-10.969046f,12.411736f,9.803656f,-10.502726f,13.719609f,8.105307f,-10.871524f,14.001316f,8.436931f,-11.025965f,11.661447f,9.399425f,-10.618912f,12.233424f,8.431757f,-11.043125f,11.584023f,7.921219f,-11.352946f,11.097343f,8.906533f,-10.950871f,12.190294f,6.96724f,-10.541012f,12.928021f,7.463887f,-11.905277f,11.673147f,7.805253f,-11.891259f,11.226655f,8.611735f,-11.696842f,12.070082f,7.069876f,-12.012459f,13.673657f,8.517102f,-12.304132f,12.922891f,8.382005f,-12.477712f,12.415004f,7.86173f,-12.124818f,12.361556f,7.599634f,-11.91767f,13.012063f,8.127262f,-11.494776f,13.781502f,8.373545f,-11.676859f,14.387995f,7.596098f,-11.770229f,14.238219f,8.204925f,-11.114721f,14.205314f,8.196705f,-10.910002f,14.154669f,7.686537f,-11.831772f,13.894389f,6.841312f,-11.025658f,13.496821f,6.953656f,-12.104777f,13.157896f,6.471652f,-11.367009f,12.71695f,6.518655f,-12.365666f,12.579077f,7.018373f,-11.839413f,12.300201f,6.902154f,-13.229594f,12.49277f,4.441186f,-14.090183f,12.400988f,4.424201f,-14.853828f,12.829611f,4.781204f,-14.722046f,12.918393f,4.625519f,-14.114908f,12.545445f,4.346031f,-13.415279f,12.657088f,4.418701f,-14.662048f,14.53845f,5.919994f,-15.04513f,13.764774f,5.410075f,-14.595857f,14.51462f,5.74841f,-14.901949f,13.783812f,5.232491f,-13.702539f,14.482744f,5.920113f,-12.839923f,13.906583f,5.546243f,-12.986732f,13.96834f,5.408745f,-13.745048f,14.483771f,5.754653f,-12.747575f,13.118942f,4.934234f,-12.95801f,13.245394f,4.868176f,-13.105218f,14.019309f,5.320428f,-13.046246f,13.356451f,4.844334f,-13.45763f,12.821987f,4.447371f,-13.401829f,12.859263f,4.368199f,-12.967881f,13.427083f,4.783602f,-13.055108f,14.135518f,5.28028f,-14.140169f,12.759958f,4.390801f,-14.723494f,13.136384f,4.649082f,-14.856922f,13.265248f,4.611558f,-14.187884f,12.837311f,4.33045f,-14.512085f,14.434638f,5.568396f,-14.852958f,13.849697f,5.148307f,-14.541692f,14.522898f,5.494023f,-14.959945f,13.964351f,5.093343f,-13.7398f,14.554191f,5.546576f,-13.759014f,14.446206f,5.601848f,-12.986118f,13.602715f,4.588383f,-13.071151f,14.286319f,5.070348f,-13.038955f,14.227101f,5.193533f,-12.946234f,13.508816f,4.693093f,-13.389194f,12.933354f,4.273396f,-13.419717f,13.054689f,4.186398f,-14.210412f,13.043841f,4.153364f,-14.207366f,12.923516f,4.241143f,-14.901736f,13.362783f,4.526103f,-14.880964f,13.457804f,4.425539f,-14.551167f,14.603318f,5.394677f,-14.536296f,14.63555f,5.261128f,-14.969068f,14.11379f,4.880825f,-14.99455f,14.054324f,5.00059f,-13.732898f,14.639904f,5.452879f,-13.741529f,14.674396f,5.317919f,-13.112532f,14.325945f,4.938022f,-13.04966f,13.700808f,4.481753f,-13.471983f,13.197361f,4.104983f,-14.218911f,13.187018f,4.073146f,-14.854685f,13.554539f,4.324358f,-14.529557f,14.624868f,5.117976f,-14.938724f,14.148209f,4.754519f,-13.759238f,14.667439f,5.169714f,-11.52898f,14.088364f,7.557636f,-11.456608f,14.623659f,7.045691f,-11.405266f,14.741466f,7.021455f,-11.428805f,14.1432f,7.435597f,-11.568882f,15.315784f,7.075531f,-11.651624f,15.169515f,6.952441f,-12.379752f,15.426985f,8.479777f,-12.006701f,15.553552f,7.703474f,-12.244555f,15.464456f,7.42352f,-12.784168f,15.441115f,8.123121f,-12.057405f,14.291308f,9.05723f,-12.349063f,14.908271f,8.978932f,-12.819204f,15.032084f,8.715398f,-12.498521f,14.46064f,9.002879f,-11.639545f,14.056401f,8.334729f,-11.892801f,14.155351f,8.426913f,-9.398474f,14.630757f,7.604719f,-9.831859f,14.280909f,7.211761f,-10.056147f,14.510509f,7.246575f,-9.767894f,14.986318f,7.559011f,-9.786422f,14.627694f,9.242369f,-9.41848f,14.753944f,8.462905f,-9.812902f,15.164033f,8.341281f,-10.093662f,15.01353f,9.099823f,-10.86611f,13.843699f,9.00927f,-10.396915f,14.229237f,9.399265f,-10.51273f,14.504642f,9.341202f,-10.817616f,13.997234f,9.058902f,-10.458562f,14.033232f,7.457768f,-10.406511f,13.918143f,7.365655f,-10.810291f,13.756209f,8.148107f,-10.755978f,13.851129f,8.246483f,-8.754689f,13.121608f,7.624042f,-9.29254f,12.924655f,7.273485f,-9.9469f,12.723689f,7.473107f,-10.431603f,13.361667f,7.262885f,-9.706727f,13.609779f,7.076607f,-9.102616f,13.856312f,7.498034f,-9.059314f,13.134355f,9.367335f,-8.700817f,13.198421f,8.536272f,-9.018862f,13.96109f,8.477456f,-9.399804f,13.88862f,9.364153f,-9.758535f,12.908621f,9.474324f,-10.189841f,13.603456f,9.507493f,-10.859072f,13.319873f,9.043101f,-10.341244f,12.686907f,9.031141f,-10.350251f,12.634857f,8.21154f,-10.877687f,13.252162f,8.106631f,-10.714234f,13.22699f,7.150483f,-11.101443f,12.443604f,6.673835f,-11.727622f,12.16464f,6.928039f,-12.140505f,12.382096f,7.512131f,-11.912274f,13.089623f,8.048095f,-11.398705f,13.832544f,8.373052f,-10.919995f,14.153524f,8.290476f,-10.631791f,13.976449f,7.856527f,-11.312394f,11.552895f,9.684901f,-11.59621f,11.015869f,9.182785f,-11.967213f,11.174813f,8.774263f,-12.187346f,11.724875f,8.66307f,-12.018496f,12.36117f,9.052994f,-11.673117f,12.795366f,9.60089f,-11.363658f,12.73923f,9.963649f,-11.205105f,12.29199f,10.029041f,-11.303944f,11.589282f,6.078482f,-11.733707f,10.806626f,5.639538f,-12.346272f,10.40513f,5.754785f,-12.754757f,10.537414f,6.246686f,-12.59986f,11.350254f,6.95559f,-12.13695f,12.219463f,7.455564f,-11.5813f,12.52936f,7.294686f,-11.204077f,12.310917f,6.740532f,-11.913564f,9.873384f,8.610176f,-12.265923f,9.355618f,8.029672f,-12.612748f,9.557312f,7.663064f,-12.803679f,10.144238f,7.598237f,-12.688374f,10.782254f,7.923094f,-12.379364f,11.193059f,8.419727f,-11.989183f,11.098343f,8.870221f,-11.754912f,10.618383f,9.018907f,-12.063281f,9.81593f,5.388968f,-12.420606f,9.236094f,5.097574f,-12.860683f,9.028456f,5.264209f,-13.168178f,9.183174f,5.691709f,-13.157161f,9.676219f,6.193716f,-12.889694f,10.195931f,6.500742f,-12.385136f,10.451401f,6.327753f,-11.985764f,10.357755f,5.883852f,-12.564818f,8.546492f,7.415908f,-12.813451f,8.177988f,7.005384f,-13.064761f,8.242788f,6.716321f,-13.230082f,8.62799f,6.624797f,-13.220638f,9.220701f,6.806988f,-13.047257f,9.644876f,7.141397f,-12.720692f,9.524417f,7.506585f,-12.480144f,9.083543f,7.674194f,-10.740087f,14.647411f,9.274617f,-10.85442f,14.068751f,9.093052f,-10.770207f,13.876583f,8.326035f,-10.575977f,14.061152f,7.527155f,-10.360303f,14.61273f,7.249948f,-10.239581f,15.172967f,7.478879f,-10.330178f,15.383566f,8.198504f,-10.530779f,15.217411f,8.949993f,-11.242143f,15.497561f,7.991661f,-11.435122f,15.285163f,8.787187f,-11.014128f,15.307684f,7.260725f,-10.930318f,14.710042f,7.064268f,-10.967391f,14.103884f,7.396101f,-11.102034f,13.888451f,8.250065f,-11.271701f,14.075294f,9.039433f,-11.413861f,14.67596f,9.177466f,-14.60095f,10.599133f,8.936757f,-14.621336f,9.67487f,8.233549f,-14.780499f,9.000804f,7.648788f,-14.74404f,8.595122f,7.118174f,-14.469964f,8.602336f,6.745319f,-14.093333f,8.941309f,6.628287f,-13.749226f,9.530787f,6.865235f,-13.083394f,9.824157f,7.796526f,-13.375441f,11.062334f,7.890705f,-13.518962f,9.720157f,7.826107f);
    }
    private static void method23(){
        MESH_6.getTexCoords().ensureCapacity(2);
        MESH_6.getTexCoords().addAll(0.0f,0.0f);
    }
    private static void method24(){
        MESH_6.getFaces().ensureCapacity(6048);
        MESH_6.getFaces().addAll(0,0,1,0,2,0,0,0,2,0,3,0,2,0,4,0,5,0,2,0,5,0,3,0,5,0,6,0,7,0,5,0,7,0,3,0,7,0,8,0,0,0,7,0,0,0,3,0,9,0,10,0,11,0,9,0,11,0,12,0,11,0,1,0,0,0,11,0,0,0,12,0,0,0,8,0,13,0,0,0,13,0,12,0,13,0,14,0,9,0,13,0,9,0,12,0,15,0,16,0,17,0,15,0,17,0,18,0,17,0,8,0,7,0,17,0,7,0,18,0,7,0,6,0,19,0,7,0,19,0,18,0,19,0,20,0,15,0,19,0,15,0,18,0,21,0,22,0,23,0,21,0,23,0,24,0,23,0,14,0,13,0,23,0,13,0,24,0,13,0,8,0,17,0,13,0,17,0,24,0,17,0,16,0,21,0,17,0,21,0,24,0,25,0,26,0,27,0,25,0,27,0,28,0,27,0,29,0,30,0,27,0,30,0,28,0,30,0,31,0,32,0,30,0,32,0,28,0,32,0,33,0,25,0,32,0,25,0,28,0,34,0,35,0,36,0,34,0,36,0,37,0,36,0,38,0,39,0,36,0,39,0,37,0,39,0,1,0,11,0,39,0,11,0,37,0,11,0,10,0,34,0,11,0,34,0,37,0,39,0,38,0,40,0,39,0,40,0,41,0,40,0,42,0,43,0,40,0,43,0,41,0,43,0,4,0,2,0,43,0,2,0,41,0,2,0,1,0,39,0,2,0,39,0,41,0,43,0,42,0,44,0,43,0,44,0,45,0,44,0,20,0,19,0,44,0,19,0,45,0,19,0,6,0,5,0,19,0,5,0,45,0,5,0,4,0,43,0,5,0,43,0,45,0,46,0,47,0,48,0,46,0,48,0,49,0,48,0,16,0,15,0,48,0,15,0,49,0,15,0,20,0,50,0,15,0,50,0,49,0,50,0,51,0,46,0,50,0,46,0,49,0,52,0,53,0,54,0,52,0,54,0,55,0,54,0,22,0,21,0,54,0,21,0,55,0,21,0,16,0,48,0,21,0,48,0,55,0,48,0,47,0,52,0,48,0,52,0,55,0,56,0,57,0,58,0,56,0,58,0,59,0,58,0,60,0,61,0,58,0,61,0,59,0,61,0,62,0,63,0,61,0,63,0,59,0,63,0,64,0,56,0,63,0,56,0,59,0,65,0,66,0,67,0,65,0,67,0,68,0,67,0,69,0,70,0,67,0,70,0,68,0,70,0,38,0,36,0,70,0,36,0,68,0,36,0,35,0,65,0,36,0,65,0,68,0,70,0,69,0,71,0,70,0,71,0,72,0,71,0,73,0,74,0,71,0,74,0,72,0,74,0,42,0,40,0,74,0,40,0,72,0,40,0,38,0,70,0,40,0,70,0,72,0,75,0,76,0,77,0,75,0,77,0,78,0,77,0,79,0,80,0,77,0,80,0,78,0,80,0,81,0,82,0,80,0,82,0,78,0,82,0,83,0,75,0,82,0,75,0,78,0,84,0,85,0,86,0,84,0,86,0,87,0,86,0,47,0,46,0,86,0,46,0,87,0,46,0,51,0,88,0,46,0,88,0,87,0,88,0,89,0,84,0,88,0,84,0,87,0,90,0,91,0,92,0,90,0,92,0,93,0,92,0,53,0,52,0,92,0,52,0,93,0,52,0,47,0,86,0,52,0,86,0,93,0,86,0,85,0,90,0,86,0,90,0,93,0,94,0,95,0,96,0,94,0,96,0,97,0,96,0,98,0,99,0,96,0,99,0,97,0,99,0,100,0,101,0,99,0,101,0,97,0,101,0,102,0,94,0,101,0,94,0,97,0,103,0,104,0,105,0,103,0,105,0,106,0,104,0,107,0,108,0,104,0,108,0,105,0,108,0,69,0,67,0,108,0,67,0,105,0,67,0,66,0,106,0,67,0,106,0,105,0,108,0,107,0,109,0,108,0,109,0,110,0,109,0,111,0,112,0,109,0,112,0,110,0,112,0,73,0,71,0,112,0,71,0,110,0,71,0,69,0,108,0,71,0,108,0,110,0,112,0,111,0,113,0,112,0,113,0,114,0,113,0,89,0,88,0,113,0,88,0,114,0,88,0,51,0,115,0,88,0,115,0,114,0,115,0,73,0,112,0,115,0,112,0,114,0,116,0,117,0,118,0,116,0,118,0,119,0,118,0,120,0,121,0,118,0,121,0,119,0,121,0,122,0,123,0,121,0,123,0,119,0,123,0,124,0,116,0,123,0,116,0,119,0,104,0,103,0,125,0,104,0,125,0,126,0,125,0,91,0,90,0,125,0,90,0,126,0,90,0,85,0,127,0,90,0,127,0,126,0,127,0,107,0,104,0,127,0,104,0,126,0,128,0,129,0,130,0,128,0,130,0,131,0,132,0,128,0,131,0,132,0,131,0,133,0,132,0,134,0,135,0,132,0,135,0,128,0,135,0,136,0,129,0,135,0,129,0,128,0,129,0,137,0,138,0,129,0,138,0,130,0,129,0,136,0,139,0,129,0,139,0,137,0,139,0,140,0,141,0,139,0,141,0,137,0,137,0,141,0,142,0,137,0,142,0,138,0,141,0,143,0,144,0,141,0,144,0,142,0,141,0,140,0,145,0,141,0,145,0,143,0,146,0,147,0,143,0,146,0,143,0,145,0,148,0,144,0,143,0,148,0,143,0,147,0,149,0,132,0,133,0,149,0,133,0,150,0,147,0,149,0,150,0,147,0,150,0,148,0,147,0,146,0,151,0,147,0,151,0,149,0,151,0,134,0,132,0,151,0,132,0,149,0,152,0,153,0,154,0,152,0,154,0,155,0,156,0,152,0,155,0,156,0,155,0,157,0,152,0,156,0,158,0,152,0,158,0,159,0,153,0,152,0,159,0,153,0,159,0,160,0,153,0,161,0,162,0,153,0,162,0,154,0,161,0,153,0,160,0,161,0,160,0,163,0,164,0,161,0,163,0,164,0,163,0,165,0,161,0,164,0,166,0,161,0,166,0,162,0,164,0,167,0,168,0,164,0,168,0,166,0,165,0,169,0,167,0,165,0,167,0,164,0,170,0,167,0,169,0,170,0,169,0,171,0,172,0,168,0,167,0,172,0,167,0,170,0,173,0,156,0,157,0,173,0,157,0,174,0,170,0,173,0,174,0,170,0,174,0,172,0,173,0,170,0,171,0,173,0,171,0,175,0,156,0,173,0,175,0,156,0,175,0,158,0,176,0,33,0,32,0,176,0,32,0,177,0,32,0,31,0,178,0,32,0,178,0,177,0,177,0,178,0,179,0,177,0,179,0,180,0,176,0,177,0,180,0,176,0,180,0,181,0,25,0,33,0,176,0,25,0,176,0,182,0,182,0,176,0,181,0,182,0,181,0,183,0,184,0,182,0,183,0,184,0,183,0,185,0,184,0,26,0,25,0,184,0,25,0,182,0,27,0,26,0,184,0,27,0,184,0,186,0,185,0,187,0,186,0,185,0,186,0,184,0,188,0,186,0,187,0,188,0,187,0,189,0,188,0,29,0,27,0,188,0,27,0,186,0,178,0,31,0,30,0,178,0,30,0,190,0,30,0,29,0,188,0,30,0,188,0,190,0,190,0,188,0,189,0,190,0,189,0,191,0,178,0,190,0,191,0,178,0,191,0,179,0,192,0,193,0,194,0,192,0,194,0,195,0,196,0,192,0,195,0,196,0,195,0,197,0,196,0,198,0,199,0,196,0,199,0,192,0,199,0,200,0,193,0,199,0,193,0,192,0,201,0,202,0,203,0,201,0,203,0,204,0,193,0,201,0,204,0,193,0,204,0,194,0,193,0,200,0,205,0,193,0,205,0,201,0,205,0,206,0,202,0,205,0,202,0,201,0,202,0,207,0,208,0,202,0,208,0,203,0,202,0,206,0,209,0,202,0,209,0,207,0,210,0,211,0,207,0,210,0,207,0,209,0,212,0,208,0,207,0,212,0,207,0,211,0,213,0,196,0,197,0,213,0,197,0,214,0,211,0,213,0,214,0,211,0,214,0,212,0,211,0,210,0,215,0,211,0,215,0,213,0,215,0,198,0,196,0,215,0,196,0,213,0,216,0,217,0,218,0,216,0,218,0,219,0,217,0,216,0,220,0,217,0,220,0,221,0,222,0,217,0,221,0,222,0,221,0,223,0,217,0,222,0,224,0,217,0,224,0,218,0,225,0,216,0,219,0,225,0,219,0,226,0,227,0,225,0,226,0,227,0,226,0,228,0,225,0,227,0,229,0,225,0,229,0,230,0,216,0,225,0,230,0,216,0,230,0,220,0,228,0,231,0,232,0,228,0,232,0,227,0,233,0,232,0,231,0,233,0,231,0,234,0,235,0,236,0,232,0,235,0,232,0,233,0,227,0,232,0,236,0,227,0,236,0,229,0,222,0,237,0,238,0,222,0,238,0,224,0,237,0,222,0,223,0,237,0,223,0,239,0,233,0,237,0,239,0,233,0,239,0,235,0,237,0,233,0,234,0,237,0,234,0,238,0,240,0,64,0,63,0,240,0,63,0,241,0,63,0,62,0,242,0,63,0,242,0,241,0,241,0,242,0,243,0,241,0,243,0,244,0,240,0,241,0,244,0,240,0,244,0,245,0,56,0,64,0,240,0,56,0,240,0,246,0,246,0,240,0,245,0,246,0,245,0,247,0,248,0,246,0,247,0,248,0,247,0,249,0,248,0,57,0,56,0,248,0,56,0,246,0,58,0,57,0,248,0,58,0,248,0,250,0,249,0,251,0,250,0,249,0,250,0,248,0,252,0,250,0,251,0,252,0,251,0,253,0,252,0,60,0,58,0,252,0,58,0,250,0,61,0,60,0,252,0,61,0,252,0,254,0,254,0,252,0,253,0,254,0,253,0,255,0,242,0,254,0,255,0,242,0,255,0,243,0,242,0,62,0,61,0,242,0,61,0,254,0,256,0,257,0,258,0,256,0,258,0,259,0,260,0,256,0,259,0,260,0,259,0,261,0,262,0,263,0,264,0,262,0,264,0,265,0,264,0,266,0,267,0,264,0,267,0,265,0,268,0,269,0,270,0,268,0,270,0,271,0,257,0,268,0,271,0,257,0,271,0,258,0,267,0,266,0,272,0,267,0,272,0,273,0,272,0,274,0,275,0,272,0,275,0,273,0,275,0,274,0,276,0,275,0,276,0,277,0,276,0,278,0,279,0,276,0,279,0,277,0,280,0,281,0,282,0,280,0,282,0,283,0,269,0,282,0,281,0,269,0,281,0,270,0,283,0,284,0,285,0,283,0,285,0,280,0,279,0,278,0,286,0,279,0,286,0,287,0,286,0,263,0,262,0,286,0,262,0,287,0,284,0,260,0,261,0,284,0,261,0,285,0,288,0,289,0,290,0,288,0,290,0,291,0,289,0,288,0,292,0,289,0,292,0,293,0,294,0,289,0,293,0,294,0,293,0,295,0,289,0,294,0,296,0,289,0,296,0,290,0,297,0,298,0,299,0,297,0,299,0,300,0,298,0,297,0,301,0,298,0,301,0,302,0,288,0,298,0,302,0,288,0,302,0,292,0,298,0,288,0,291,0,298,0,291,0,299,0,300,0,303,0,304,0,300,0,304,0,297,0,305,0,304,0,303,0,305,0,303,0,306,0,307,0,308,0,304,0,307,0,304,0,305,0,297,0,304,0,308,0,297,0,308,0,301,0,309,0,305,0,306,0,309,0,306,0,310,0,294,0,309,0,310,0,294,0,310,0,296,0,309,0,294,0,295,0,309,0,295,0,311,0,305,0,309,0,311,0,305,0,311,0,307,0,312,0,102,0,101,0,312,0,101,0,313,0,101,0,100,0,314,0,101,0,314,0,313,0,313,0,314,0,315,0,313,0,315,0,316,0,312,0,313,0,316,0,312,0,316,0,317,0,318,0,95,0,94,0,318,0,94,0,319,0,94,0,102,0,312,0,94,0,312,0,319,0,319,0,312,0,317,0,319,0,317,0,320,0,318,0,319,0,320,0,318,0,320,0,321,0,96,0,95,0,318,0,96,0,318,0,322,0,321,0,323,0,322,0,321,0,322,0,318,0,324,0,322,0,323,0,324,0,323,0,325,0,324,0,98,0,96,0,324,0,96,0,322,0,99,0,98,0,324,0,99,0,324,0,326,0,326,0,324,0,325,0,326,0,325,0,327,0,314,0,326,0,327,0,314,0,327,0,315,0,314,0,100,0,99,0,314,0,99,0,326,0,328,0,20,0,44,0,328,0,44,0,329,0,44,0,42,0,330,0,44,0,330,0,329,0,330,0,331,0,332,0,330,0,332,0,329,0,332,0,333,0,328,0,332,0,328,0,329,0,74,0,73,0,334,0,74,0,334,0,335,0,334,0,336,0,337,0,334,0,337,0,335,0,337,0,331,0,330,0,337,0,330,0,335,0,330,0,42,0,74,0,330,0,74,0,335,0,334,0,73,0,115,0,334,0,115,0,338,0,115,0,51,0,339,0,115,0,339,0,338,0,339,0,340,0,341,0,339,0,341,0,338,0,341,0,336,0,334,0,341,0,334,0,338,0,339,0,51,0,50,0,339,0,50,0,342,0,50,0,20,0,328,0,50,0,328,0,342,0,328,0,333,0,343,0,328,0,343,0,342,0,343,0,340,0,339,0,343,0,339,0,342,0,344,0,340,0,343,0,344,0,343,0,345,0,343,0,333,0,346,0,343,0,346,0,345,0,346,0,347,0,348,0,346,0,348,0,345,0,348,0,349,0,344,0,348,0,344,0,345,0,346,0,333,0,332,0,346,0,332,0,350,0,332,0,331,0,351,0,332,0,351,0,350,0,351,0,352,0,353,0,351,0,353,0,350,0,353,0,347,0,346,0,353,0,346,0,350,0,337,0,336,0,354,0,337,0,354,0,355,0,354,0,356,0,357,0,354,0,357,0,355,0,357,0,352,0,351,0,357,0,351,0,355,0,351,0,331,0,337,0,351,0,337,0,355,0,358,0,356,0,354,0,358,0,354,0,359,0,354,0,336,0,341,0,354,0,341,0,359,0,341,0,340,0,344,0,341,0,344,0,359,0,344,0,349,0,358,0,344,0,358,0,359,0,360,0,361,0,362,0,360,0,362,0,363,0,362,0,349,0,348,0,362,0,348,0,363,0,348,0,347,0,364,0,348,0,364,0,363,0,364,0,365,0,360,0,364,0,360,0,363,0,366,0,365,0,364,0,366,0,364,0,367,0,364,0,347,0,353,0,364,0,353,0,367,0,353,0,352,0,368,0,353,0,368,0,367,0,368,0,369,0,366,0,368,0,366,0,367,0,370,0,371,0,372,0,370,0,372,0,373,0,372,0,369,0,368,0,372,0,368,0,373,0,368,0,352,0,357,0,368,0,357,0,373,0,357,0,356,0,370,0,357,0,370,0,373,0,370,0,356,0,358,0,370,0,358,0,374,0,358,0,349,0,362,0,358,0,362,0,374,0,362,0,361,0,375,0,362,0,375,0,374,0,375,0,371,0,370,0,375,0,370,0,374,0,80,0,79,0,376,0,80,0,376,0,377,0,376,0,361,0,360,0,376,0,360,0,377,0,360,0,365,0,378,0,360,0,378,0,377,0,378,0,81,0,80,0,378,0,80,0,377,0,82,0,81,0,378,0,82,0,378,0,379,0,378,0,365,0,366,0,378,0,366,0,379,0,366,0,369,0,380,0,366,0,380,0,379,0,380,0,83,0,82,0,380,0,82,0,379,0,381,0,76,0,75,0,381,0,75,0,382,0,75,0,83,0,380,0,75,0,380,0,382,0,380,0,369,0,372,0,380,0,372,0,382,0,372,0,371,0,381,0,372,0,381,0,382,0,381,0,371,0,375,0,381,0,375,0,383,0,375,0,361,0,376,0,375,0,376,0,383,0,376,0,79,0,77,0,376,0,77,0,383,0,77,0,76,0,381,0,77,0,381,0,383,0,384,0,385,0,386,0,384,0,386,0,387,0,388,0,386,0,385,0,388,0,385,0,389,0,390,0,391,0,392,0,390,0,392,0,393,0,388,0,389,0,392,0,388,0,392,0,391,0,394,0,395,0,396,0,394,0,396,0,397,0,390,0,393,0,396,0,390,0,396,0,395,0,398,0,394,0,397,0,398,0,397,0,399,0,384,0,387,0,398,0,384,0,398,0,399,0,400,0,401,0,402,0,400,0,402,0,403,0,404,0,405,0,406,0,404,0,406,0,407,0,408,0,409,0,410,0,408,0,410,0,411,0,412,0,413,0,414,0,412,0,414,0,415,0,416,0,122,0,121,0,416,0,121,0,417,0,121,0,120,0,418,0,121,0,418,0,417,0,418,0,419,0,420,0,418,0,420,0,417,0,420,0,421,0,416,0,420,0,416,0,417,0,422,0,124,0,123,0,422,0,123,0,423,0,123,0,122,0,416,0,123,0,416,0,423,0,416,0,421,0,424,0,416,0,424,0,423,0,424,0,425,0,422,0,424,0,422,0,423,0,116,0,124,0,422,0,116,0,422,0,426,0,422,0,425,0,427,0,422,0,427,0,426,0,427,0,428,0,429,0,427,0,429,0,426,0,429,0,117,0,116,0,429,0,116,0,426,0,118,0,117,0,429,0,118,0,429,0,430,0,429,0,428,0,431,0,429,0,431,0,430,0,431,0,419,0,418,0,431,0,418,0,430,0,418,0,120,0,118,0,418,0,118,0,430,0,325,0,323,0,432,0,325,0,432,0,433,0,327,0,325,0,433,0,327,0,433,0,434,0,315,0,327,0,434,0,315,0,434,0,435,0,316,0,315,0,435,0,316,0,435,0,436,0,317,0,316,0,436,0,317,0,436,0,437,0,320,0,317,0,437,0,320,0,437,0,438,0,321,0,320,0,438,0,321,0,438,0,439,0,432,0,323,0,321,0,432,0,321,0,439,0,301,0,308,0,432,0,301,0,432,0,439,0,302,0,301,0,439,0,302,0,439,0,438,0,292,0,302,0,438,0,292,0,438,0,437,0,293,0,292,0,437,0,293,0,437,0,436,0,295,0,293,0,436,0,295,0,436,0,435,0,311,0,295,0,435,0,311,0,435,0,434,0,307,0,311,0,434,0,307,0,434,0,433,0,432,0,308,0,307,0,432,0,307,0,433,0,306,0,303,0,440,0,306,0,440,0,441,0,310,0,306,0,441,0,310,0,441,0,442,0,296,0,310,0,442,0,296,0,442,0,443,0,290,0,296,0,443,0,290,0,443,0,444,0,291,0,290,0,444,0,291,0,444,0,445,0,299,0,291,0,445,0,299,0,445,0,446,0,300,0,299,0,446,0,300,0,446,0,447,0,440,0,303,0,300,0,440,0,300,0,447,0,270,0,281,0,440,0,270,0,440,0,447,0,271,0,270,0,447,0,271,0,447,0,446,0,258,0,271,0,446,0,258,0,446,0,445,0,259,0,258,0,445,0,259,0,445,0,444,0,261,0,259,0,444,0,261,0,444,0,443,0,285,0,261,0,443,0,285,0,443,0,442,0,280,0,285,0,442,0,280,0,442,0,441,0,440,0,281,0,280,0,440,0,280,0,441,0,253,0,251,0,448,0,253,0,448,0,449,0,255,0,253,0,449,0,255,0,449,0,450,0,243,0,255,0,450,0,243,0,450,0,451,0,244,0,243,0,451,0,244,0,451,0,452,0,245,0,244,0,452,0,245,0,452,0,453,0,247,0,245,0,453,0,247,0,453,0,454,0,249,0,247,0,454,0,249,0,454,0,455,0,448,0,251,0,249,0,448,0,249,0,455,0,229,0,236,0,448,0,229,0,448,0,455,0,230,0,229,0,455,0,230,0,455,0,454,0,220,0,230,0,454,0,220,0,454,0,453,0,221,0,220,0,453,0,221,0,453,0,452,0,223,0,221,0,452,0,223,0,452,0,451,0,239,0,223,0,451,0,239,0,451,0,450,0,235,0,239,0,450,0,235,0,450,0,449,0,448,0,236,0,235,0,448,0,235,0,449,0,234,0,231,0,456,0,234,0,456,0,457,0,238,0,234,0,457,0,238,0,457,0,458,0,224,0,238,0,458,0,224,0,458,0,459,0,218,0,224,0,459,0,218,0,459,0,460,0,219,0,218,0,460,0,219,0,460,0,461,0,226,0,219,0,461,0,226,0,461,0,462,0,228,0,226,0,462,0,228,0,462,0,463,0,456,0,231,0,228,0,456,0,228,0,463,0,203,0,208,0,456,0,203,0,456,0,463,0,204,0,203,0,463,0,204,0,463,0,462,0,194,0,204,0,462,0,194,0,462,0,461,0,195,0,194,0,461,0,195,0,461,0,460,0,197,0,195,0,460,0,197,0,460,0,459,0,214,0,197,0,459,0,214,0,459,0,458,0,212,0,214,0,458,0,212,0,458,0,457,0,456,0,208,0,212,0,456,0,212,0,457,0,189,0,187,0,464,0,189,0,464,0,465,0,191,0,189,0,465,0,191,0,465,0,466,0,179,0,191,0,466,0,179,0,466,0,467,0,180,0,179,0,467,0,180,0,467,0,468,0,181,0,180,0,468,0,181,0,468,0,469,0,183,0,181,0,469,0,183,0,469,0,470,0,185,0,183,0,470,0,185,0,470,0,471,0,464,0,187,0,185,0,464,0,185,0,471,0,166,0,168,0,464,0,166,0,464,0,471,0,162,0,166,0,471,0,162,0,471,0,470,0,154,0,162,0,470,0,154,0,470,0,469,0,155,0,154,0,469,0,155,0,469,0,468,0,157,0,155,0,468,0,157,0,468,0,467,0,174,0,157,0,467,0,174,0,467,0,466,0,172,0,174,0,466,0,172,0,466,0,465,0,464,0,168,0,172,0,464,0,172,0,465,0,171,0,169,0,472,0,171,0,472,0,473,0,175,0,171,0,473,0,175,0,473,0,474,0,158,0,175,0,474,0,158,0,474,0,475,0,159,0,158,0,475,0,159,0,475,0,476,0,160,0,159,0,476,0,160,0,476,0,477,0,163,0,160,0,477,0,163,0,477,0,478,0,165,0,163,0,478,0,165,0,478,0,479,0,472,0,169,0,165,0,472,0,165,0,479,0,142,0,144,0,472,0,142,0,472,0,479,0,138,0,142,0,479,0,138,0,479,0,478,0,130,0,138,0,478,0,130,0,478,0,477,0,131,0,130,0,477,0,131,0,477,0,476,0,133,0,131,0,476,0,133,0);
    }
    private static void method25(){
        MESH_6.getFaces().addAll(476,0,475,0,150,0,133,0,475,0,150,0,475,0,474,0,148,0,150,0,474,0,148,0,474,0,473,0,472,0,144,0,148,0,472,0,148,0,473,0,404,0,407,0,410,0,404,0,410,0,409,0,400,0,403,0,406,0,400,0,406,0,405,0,412,0,402,0,401,0,412,0,401,0,413,0,414,0,408,0,411,0,414,0,411,0,415,0,480,0,481,0,411,0,480,0,411,0,410,0,415,0,411,0,481,0,415,0,481,0,482,0,482,0,483,0,412,0,482,0,412,0,415,0,402,0,412,0,483,0,402,0,483,0,484,0,484,0,485,0,403,0,484,0,403,0,402,0,406,0,403,0,485,0,406,0,485,0,486,0,486,0,487,0,407,0,486,0,407,0,406,0,410,0,407,0,487,0,410,0,487,0,480,0,384,0,85,0,84,0,384,0,84,0,385,0,84,0,89,0,389,0,84,0,389,0,385,0,392,0,389,0,89,0,392,0,89,0,113,0,113,0,111,0,393,0,113,0,393,0,392,0,396,0,393,0,111,0,396,0,111,0,109,0,109,0,107,0,397,0,109,0,397,0,396,0,399,0,397,0,107,0,399,0,107,0,127,0,127,0,85,0,384,0,127,0,384,0,399,0,428,0,427,0,409,0,428,0,409,0,408,0,425,0,404,0,409,0,425,0,409,0,427,0,425,0,424,0,405,0,425,0,405,0,404,0,421,0,400,0,405,0,421,0,405,0,424,0,421,0,420,0,401,0,421,0,401,0,400,0,413,0,401,0,420,0,413,0,420,0,419,0,414,0,413,0,419,0,414,0,419,0,431,0,428,0,408,0,414,0,428,0,414,0,431,0,487,0,486,0,488,0,487,0,488,0,489,0,486,0,485,0,490,0,486,0,490,0,488,0,485,0,484,0,491,0,485,0,491,0,490,0,484,0,483,0,492,0,484,0,492,0,491,0,483,0,482,0,493,0,483,0,493,0,492,0,482,0,481,0,494,0,482,0,494,0,493,0,481,0,480,0,495,0,481,0,495,0,494,0,489,0,495,0,480,0,489,0,480,0,487,0,494,0,495,0,395,0,494,0,395,0,394,0,489,0,390,0,395,0,489,0,395,0,495,0,489,0,488,0,391,0,489,0,391,0,390,0,490,0,388,0,391,0,490,0,391,0,488,0,490,0,491,0,386,0,490,0,386,0,388,0,387,0,386,0,491,0,387,0,491,0,492,0,398,0,387,0,492,0,398,0,492,0,493,0,494,0,394,0,398,0,494,0,398,0,493,0,66,0,278,0,276,0,66,0,276,0,106,0,496,0,278,0,66,0,496,0,66,0,65,0,35,0,497,0,496,0,35,0,496,0,65,0,498,0,497,0,35,0,498,0,35,0,34,0,10,0,499,0,498,0,10,0,498,0,34,0,500,0,499,0,10,0,500,0,10,0,9,0,14,0,501,0,500,0,14,0,500,0,9,0,502,0,501,0,14,0,502,0,14,0,23,0,22,0,503,0,502,0,22,0,502,0,23,0,504,0,503,0,22,0,504,0,22,0,54,0,53,0,263,0,504,0,53,0,504,0,54,0,264,0,263,0,53,0,264,0,53,0,92,0,91,0,266,0,264,0,91,0,264,0,92,0,272,0,266,0,91,0,272,0,91,0,125,0,103,0,274,0,272,0,103,0,272,0,125,0,276,0,274,0,103,0,276,0,103,0,106,0,269,0,275,0,277,0,269,0,277,0,282,0,279,0,283,0,282,0,279,0,282,0,277,0,283,0,279,0,287,0,283,0,287,0,284,0,262,0,260,0,284,0,262,0,284,0,287,0,260,0,262,0,265,0,260,0,265,0,256,0,267,0,257,0,256,0,267,0,256,0,265,0,257,0,267,0,273,0,257,0,273,0,268,0,275,0,269,0,268,0,275,0,268,0,273,0,206,0,278,0,496,0,206,0,496,0,209,0,286,0,278,0,206,0,286,0,206,0,205,0,200,0,263,0,286,0,200,0,286,0,205,0,504,0,263,0,200,0,504,0,200,0,199,0,198,0,503,0,504,0,198,0,504,0,199,0,505,0,503,0,198,0,505,0,198,0,215,0,210,0,497,0,505,0,210,0,505,0,215,0,496,0,497,0,210,0,496,0,210,0,209,0,140,0,497,0,498,0,140,0,498,0,145,0,505,0,497,0,140,0,505,0,140,0,139,0,136,0,503,0,505,0,136,0,505,0,139,0,502,0,503,0,136,0,502,0,136,0,135,0,134,0,501,0,502,0,134,0,502,0,135,0,500,0,501,0,134,0,500,0,134,0,151,0,146,0,499,0,500,0,146,0,500,0,151,0,498,0,499,0,146,0,498,0,146,0,145,0);
    }
    private static void method26(){
        MESH_6.getFaceSmoothingGroups().ensureCapacity(1008);
        MESH_6.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_8 = MESHVIEWS[7];
        MESHVIEWS[7].setId("hat_bishop");
        MESHVIEWS[7].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_7 = new PhongMaterial();
        MATERIAL_7.setDiffuseColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_7.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_7.setSpecularPower(18.0);
        MESHVIEWS[7].setMaterial(MATERIAL_7);
        MESH_7 = new TriangleMesh();
        MESHVIEWS[7].setMesh(MESH_7);
        MESH_7.getPoints().ensureCapacity(1302);
        MESH_7.getPoints().addAll(0.0f,60.91851f,-1.0E-5f,1.268996f,60.78305f,0.525625f,1.373551f,60.78305f,-1.0E-5f,0.971247f,60.78305f,0.971237f,0.525635f,60.78305f,1.268985f,-0.0f,60.78305f,1.373541f,-0.525635f,60.78305f,1.268985f,-0.971247f,60.78305f,0.971237f,-1.268996f,60.78305f,0.525625f,-1.373551f,60.78305f,-1.0E-5f,-1.268996f,60.78305f,-0.525645f,-0.971247f,60.78305f,-0.971257f,-0.525635f,60.78305f,-1.269006f,0.0f,60.78305f,-1.373561f,0.525635f,60.78305f,-1.269006f,0.971247f,60.78305f,-0.971257f,1.268996f,60.78305f,-0.525645f,1.940943f,60.426865f,0.803955f,2.100862f,60.426865f,-1.0E-5f,1.485533f,60.426865f,1.485523f,0.803965f,60.426865f,1.940933f,-0.0f,60.426865f,2.100852f,-0.803965f,60.426865f,1.940933f,-1.485533f,60.426865f,1.485523f,-1.940943f,60.426865f,0.803955f,-2.100862f,60.426865f,-1.0E-5f,-1.940943f,60.426865f,-0.803975f,-1.485533f,60.426865f,-1.485543f,-0.803965f,60.426865f,-1.940953f,0.0f,60.426865f,-2.100873f,0.803965f,60.426865f,-1.940953f,1.485533f,60.426865f,-1.485543f,1.940943f,60.426865f,-0.803975f,1.940943f,59.97722f,0.803955f,2.100862f,59.97722f,-1.0E-5f,1.485533f,59.97722f,1.485523f,0.803965f,59.97722f,1.940933f,-0.0f,59.97722f,2.100852f,-0.803965f,59.97722f,1.940933f,-1.485533f,59.97722f,1.485523f,-1.940943f,59.97722f,0.803955f,-2.100862f,59.97722f,-1.0E-5f,-1.940943f,59.97722f,-0.803975f,-1.485533f,59.97722f,-1.485543f,-0.803965f,59.97722f,-1.940953f,0.0f,59.97722f,-2.100873f,0.803965f,59.97722f,-1.940953f,1.485533f,59.97722f,-1.485543f,1.940943f,59.97722f,-0.803975f,1.694406f,59.587006f,0.701836f,1.834012f,59.587006f,-1.0E-5f,1.296843f,59.587006f,1.296833f,0.701846f,59.587006f,1.694396f,-0.0f,59.587006f,1.834002f,-0.701846f,59.587006f,1.694396f,-1.296843f,59.587006f,1.296833f,-1.694406f,59.587006f,0.701836f,-1.834012f,59.587006f,-1.0E-5f,-1.694406f,59.587006f,-0.701856f,-1.296843f,59.587006f,-1.296853f,-0.701846f,59.587006f,-1.694416f,0.0f,59.587006f,-1.834022f,0.701846f,59.587006f,-1.694416f,1.296843f,59.587006f,-1.296853f,1.694406f,59.587006f,-0.701856f,1.265028f,58.994217f,0.523983f,1.369258f,58.994217f,-1.0E-5f,0.968211f,58.994217f,0.968201f,0.523993f,58.994217f,1.265018f,-0.0f,58.994217f,1.369248f,-0.523993f,58.994217f,1.265018f,-0.968211f,58.994217f,0.968201f,-1.265028f,58.994217f,0.523983f,-1.369258f,58.994217f,-1.0E-5f,-1.265028f,58.994217f,-0.524003f,-0.968211f,58.994217f,-0.968221f,-0.523993f,58.994217f,-1.265038f,0.0f,58.994217f,-1.369268f,0.523993f,58.994217f,-1.265038f,0.968211f,58.994217f,-0.968221f,1.265028f,58.994217f,-0.524003f,1.274262f,58.64756f,0.527806f,1.379251f,58.64756f,-1.0E-5f,0.975278f,58.64756f,0.975268f,0.527817f,58.64756f,1.274252f,-0.0f,58.64756f,1.379241f,-0.527817f,58.64756f,1.274252f,-0.975278f,58.64756f,0.975268f,-1.274262f,58.64756f,0.527806f,-1.379251f,58.64756f,-1.0E-5f,-1.274262f,58.64756f,-0.527827f,-0.975278f,58.64756f,-0.975288f,-0.527817f,58.64756f,-1.274272f,0.0f,58.64756f,-1.379261f,0.527817f,58.64756f,-1.274272f,0.975278f,58.64756f,-0.975288f,1.274262f,58.64756f,-0.527827f,2.072072f,58.213608f,0.85827f,2.242794f,58.213608f,-1.0E-5f,1.585895f,58.213608f,1.585885f,0.85828f,58.213608f,2.072062f,-0.0f,58.213608f,2.242784f,-0.85828f,58.213608f,2.072062f,-1.585895f,58.213608f,1.585885f,-2.072072f,58.213608f,0.85827f,-2.242794f,58.213608f,-1.0E-5f,-2.072072f,58.213608f,-0.85829f,-1.585895f,58.213608f,-1.585905f,-0.85828f,58.213608f,-2.072082f,0.0f,58.213608f,-2.242804f,0.85828f,58.213608f,-2.072082f,1.585895f,58.213608f,-1.585905f,2.072072f,58.213608f,-0.85829f,3.518837f,57.026108f,1.45754f,3.808762f,57.026108f,-1.0E-5f,2.693201f,57.026108f,2.693191f,1.45755f,57.026108f,3.518827f,-0.0f,57.026108f,3.808752f,-1.45755f,57.026108f,3.518827f,-2.693201f,57.026108f,2.693191f,-3.518837f,57.026108f,1.45754f,-3.808762f,57.026108f,-1.0E-5f,-3.518837f,57.026108f,-1.45756f,-2.693201f,57.026108f,-2.693211f,-1.45755f,57.026108f,-3.518847f,0.0f,57.026108f,-3.808772f,1.45755f,57.026108f,-3.518847f,2.693201f,57.026108f,-2.693211f,3.518837f,57.026108f,-1.45756f,5.16151f,55.100624f,2.137958f,5.586779f,55.100624f,-1.0E-5f,3.95045f,55.100624f,3.95044f,2.137968f,55.100624f,5.1615f,-0.0f,55.100624f,5.586769f,-2.137968f,55.100624f,5.1615f,-3.95045f,55.100624f,3.95044f,-5.16151f,55.100624f,2.137958f,-5.586779f,55.100624f,-1.0E-5f,-5.16151f,55.100624f,-2.137978f,-3.95045f,55.100624f,-3.95046f,-2.137968f,55.100624f,-5.161521f,0.0f,55.100624f,-5.586789f,2.137968f,55.100624f,-5.161521f,3.95045f,55.100624f,-3.95046f,5.16151f,55.100624f,-2.137978f,6.342018f,52.484306f,2.62694f,6.864551f,52.484306f,-1.0E-5f,4.853971f,52.484306f,4.853961f,2.62695f,52.484306f,6.342008f,-0.0f,52.484306f,6.864541f,-2.62695f,52.484306f,6.342008f,-4.853971f,52.484306f,4.853961f,-6.342018f,52.484306f,2.62694f,-6.864551f,52.484306f,-1.0E-5f,-6.342018f,52.484306f,-2.62696f,-4.853971f,52.484306f,-4.853981f,-2.62695f,52.484306f,-6.342028f,0.0f,52.484306f,-6.864561f,2.62695f,52.484306f,-6.342028f,4.853971f,52.484306f,-4.853981f,6.342018f,52.484306f,-2.62696f,6.788586f,49.466896f,2.811914f,7.347912f,49.466896f,-1.0E-5f,5.195758f,49.466896f,5.195748f,2.811924f,49.466896f,6.788576f,-0.0f,49.466896f,7.347902f,-2.811924f,49.466896f,6.788576f,-5.195758f,49.466896f,5.195748f,-6.788586f,49.466896f,2.811914f,-7.347912f,49.466896f,-1.0E-5f,-6.788586f,49.466896f,-2.811934f,-5.195758f,49.466896f,-5.195768f,-2.811924f,49.466896f,-6.788596f,0.0f,49.466896f,-7.347922f,2.811924f,49.466896f,-6.788596f,5.195758f,49.466896f,-5.195768f,6.788586f,49.466896f,-2.811934f,6.509923f,46.132526f,2.696488f,7.04629f,46.132526f,-1.0E-5f,4.98248f,46.132526f,4.982469f,2.696498f,46.132526f,6.509913f,-0.0f,46.132526f,7.04628f,-2.696498f,46.132526f,6.509913f,-4.98248f,46.132526f,4.982469f,-6.509923f,46.132526f,2.696488f,-7.04629f,46.132526f,-1.0E-5f,-6.509923f,46.132526f,-2.696508f,-4.98248f,46.132526f,-4.98249f,-2.696498f,46.132526f,-6.509933f,0.0f,46.132526f,-7.0463f,2.696498f,46.132526f,-6.509933f,4.98248f,46.132526f,-4.98249f,6.509923f,46.132526f,-2.696508f,5.314022f,42.589066f,2.20113f,5.751855f,42.589066f,-1.0E-5f,4.067176f,42.589066f,4.067166f,2.20114f,42.589066f,5.314012f,-0.0f,42.589066f,5.751844f,-2.20114f,42.589066f,5.314012f,-4.067176f,42.589066f,4.067166f,-5.314022f,42.589066f,2.20113f,-5.751855f,42.589066f,-1.0E-5f,-5.314022f,42.589066f,-2.20115f,-4.067176f,42.589066f,-4.067186f,-2.20114f,42.589066f,-5.314032f,0.0f,42.589066f,-5.751865f,2.20114f,42.589066f,-5.314032f,4.067176f,42.589066f,-4.067186f,5.314022f,42.589066f,-2.20115f,5.556557f,42.26797f,2.301591f,6.014374f,42.26797f,-1.0E-5f,4.252804f,42.26797f,4.252794f,2.301601f,42.26797f,5.556547f,-0.0f,42.26797f,6.014364f,-2.301601f,42.26797f,5.556547f,-4.252804f,42.26797f,4.252794f,-5.556557f,42.26797f,2.301591f,-6.014374f,42.26797f,-1.0E-5f,-5.556557f,42.26797f,-2.301611f,-4.252804f,42.26797f,-4.252814f,-2.301601f,42.26797f,-5.556567f,0.0f,42.26797f,-6.014384f,2.301601f,42.26797f,-5.556567f,4.252804f,42.26797f,-4.252814f,5.556557f,42.26797f,-2.301611f,6.072766f,41.877037f,2.515412f,6.573114f,41.877037f,-1.0E-5f,4.647894f,41.877037f,4.647884f,2.515422f,41.877037f,6.072756f,-0.0f,41.877037f,6.573104f,-2.515422f,41.877037f,6.072756f,-4.647894f,41.877037f,4.647884f,-6.072766f,41.877037f,2.515412f,-6.573114f,41.877037f,-1.0E-5f,-6.072766f,41.877037f,-2.515432f,-4.647894f,41.877037f,-4.647904f,-2.515422f,41.877037f,-6.072776f,0.0f,41.877037f,-6.573124f,2.515422f,41.877037f,-6.072776f,4.647894f,41.877037f,-4.647904f,6.072766f,41.877037f,-2.515432f,6.072766f,41.26847f,2.515412f,6.573114f,41.26847f,-1.0E-5f,4.647894f,41.26847f,4.647884f,2.515422f,41.26847f,6.072756f,-0.0f,41.26847f,6.573104f,-2.515422f,41.26847f,6.072756f,-4.647894f,41.26847f,4.647884f,-6.072766f,41.26847f,2.515412f,-6.573114f,41.26847f,-1.0E-5f,-6.072766f,41.26847f,-2.515432f,-4.647894f,41.26847f,-4.647904f,-2.515422f,41.26847f,-6.072776f,0.0f,41.26847f,-6.573124f,2.515422f,41.26847f,-6.072776f,4.647894f,41.26847f,-4.647904f,6.072766f,41.26847f,-2.515432f,5.505444f,40.829548f,2.280419f,5.95905f,40.829548f,-1.0E-5f,4.213684f,40.829548f,4.213674f,2.280429f,40.829548f,5.505434f,-0.0f,40.829548f,5.95904f,-2.280429f,40.829548f,5.505434f,-4.213684f,40.829548f,4.213674f,-5.505444f,40.829548f,2.280419f,-5.95905f,40.829548f,-1.0E-5f,-5.505444f,40.829548f,-2.280439f,-4.213684f,40.829548f,-4.213695f,-2.280429f,40.829548f,-5.505454f,0.0f,40.829548f,-5.95906f,2.280429f,40.829548f,-5.505454f,4.213684f,40.829548f,-4.213695f,5.505444f,40.829548f,-2.280439f,4.892091f,40.386948f,2.02636f,5.295161f,40.386948f,-1.0E-5f,3.744244f,40.386948f,3.744234f,2.02637f,40.386948f,4.892081f,-0.0f,40.386948f,5.295151f,-2.02637f,40.386948f,4.892081f,-3.744244f,40.386948f,3.744234f,-4.892091f,40.386948f,2.02636f,-5.295161f,40.386948f,-1.0E-5f,-4.892091f,40.386948f,-2.02638f,-3.744244f,40.386948f,-3.744254f,-2.02637f,40.386948f,-4.892101f,0.0f,40.386948f,-5.295171f,2.02637f,40.386948f,-4.892101f,3.744244f,40.386948f,-3.744254f,4.892091f,40.386948f,-2.02638f,5.288283f,38.926216f,2.190469f,5.723997f,38.926216f,-1.0E-5f,4.047477f,38.926216f,4.047467f,2.190479f,38.926216f,5.288273f,-0.0f,38.926216f,5.723987f,-2.190479f,38.926216f,5.288273f,-4.047477f,38.926216f,4.047467f,-5.288283f,38.926216f,2.190469f,-5.723997f,38.926216f,-1.0E-5f,-5.288283f,38.926216f,-2.190489f,-4.047477f,38.926216f,-4.047487f,-2.190479f,38.926216f,-5.288293f,0.0f,38.926216f,-5.724007f,2.190479f,38.926216f,-5.288293f,4.047477f,38.926216f,-4.047487f,5.288283f,38.926216f,-2.190489f,7.150521f,38.471146f,2.961832f,7.739667f,38.471146f,-1.0E-5f,5.472772f,38.471146f,5.472762f,2.961842f,38.471146f,7.150511f,-0.0f,38.471146f,7.739657f,-2.961842f,38.471146f,7.150511f,-5.472772f,38.471146f,5.472762f,-7.150521f,38.471146f,2.961832f,-7.739667f,38.471146f,-1.0E-5f,-7.150521f,38.471146f,-2.961852f,-5.472772f,38.471146f,-5.472782f,-2.961842f,38.471146f,-7.150531f,0.0f,38.471146f,-7.739677f,2.961842f,38.471146f,-7.150531f,5.472772f,38.471146f,-5.472782f,7.150521f,38.471146f,-2.961852f,7.489109f,38.071117f,3.10208f,8.106152f,38.071117f,-1.0E-5f,5.731916f,38.071117f,5.731906f,3.102091f,38.071117f,7.489099f,-0.0f,38.071117f,8.106142f,-3.102091f,38.071117f,7.489099f,-5.731916f,38.071117f,5.731906f,-7.489109f,38.071117f,3.10208f,-8.106152f,38.071117f,-1.0E-5f,-7.489109f,38.071117f,-3.102101f,-5.731916f,38.071117f,-5.731926f,-3.102091f,38.071117f,-7.489119f,0.0f,38.071117f,-8.106162f,3.102091f,38.071117f,-7.489119f,5.731916f,38.071117f,-5.731926f,7.489109f,38.071117f,-3.102101f,7.325424f,37.46029f,3.03428f,7.928982f,37.46029f,-1.0E-5f,5.606637f,37.46029f,5.606627f,3.03429f,37.46029f,7.325414f,-0.0f,37.46029f,7.928972f,-3.03429f,37.46029f,7.325414f,-5.606637f,37.46029f,5.606627f,-7.325424f,37.46029f,3.03428f,-7.928982f,37.46029f,-1.0E-5f,-7.325424f,37.46029f,-3.0343f,-5.606637f,37.46029f,-5.606647f,-3.03429f,37.46029f,-7.325434f,0.0f,37.46029f,-7.928992f,3.03429f,37.46029f,-7.325434f,5.606637f,37.46029f,-5.606647f,7.325424f,37.46029f,-3.0343f,6.360481f,36.97164f,2.634587f,6.884533f,36.97164f,-1.0E-5f,4.868101f,36.97164f,4.868091f,2.634597f,36.97164f,6.360471f,-0.0f,36.97164f,6.884523f,-2.634597f,36.97164f,6.360471f,-4.868101f,36.97164f,4.868091f,-6.360481f,36.97164f,2.634587f,-6.884533f,36.97164f,-1.0E-5f,-6.360481f,36.97164f,-2.634607f,-4.868101f,36.97164f,-4.868111f,-2.634597f,36.97164f,-6.360491f,0.0f,36.97164f,-6.884543f,2.634597f,36.97164f,-6.360491f,4.868101f,36.97164f,-4.868111f,6.360481f,36.97164f,-2.634607f,7.094089f,36.849487f,2.938458f,7.678587f,36.849487f,-1.0E-5f,5.429581f,36.849487f,5.429571f,2.938468f,36.849487f,7.094079f,-0.0f,36.849487f,7.678577f,-2.938468f,36.849487f,7.094079f,-5.429581f,36.849487f,5.429571f,-7.094089f,36.849487f,2.938458f,-7.678587f,36.849487f,-1.0E-5f,-7.094089f,36.849487f,-2.938478f,-5.429581f,36.849487f,-5.429591f,-2.938468f,36.849487f,-7.094099f,0.0f,36.849487f,-7.678597f,2.938468f,36.849487f,-7.094099f,5.429581f,36.849487f,-5.429591f,7.094089f,36.849487f,-2.938478f,8.053424f,36.238655f,3.335827f,8.716962f,36.238655f,-1.0E-5f,6.163823f,36.238655f,6.163813f,3.335837f,36.238655f,8.053414f,-0.0f,36.238655f,8.716952f,-3.335837f,36.238655f,8.053414f,-6.163823f,36.238655f,6.163813f,-8.053424f,36.238655f,3.335827f,-8.716962f,36.238655f,-1.0E-5f,-8.053424f,36.238655f,-3.335847f,-6.163823f,36.238655f,-6.163833f,-3.335837f,36.238655f,-8.053434f,0.0f,36.238655f,-8.716972f,3.335837f,36.238655f,-8.053434f,6.163823f,36.238655f,-6.163833f,8.053424f,36.238655f,-3.335847f,8.221797f,34.91826f,3.40557f,8.899209f,34.91826f,-1.0E-5f,6.292691f,34.91826f,6.292681f,3.40558f,34.91826f,8.221787f,-0.0f,34.91826f,8.899199f,-3.40558f,34.91826f,8.221787f,-6.292691f,34.91826f,6.292681f,-8.221797f,34.91826f,3.40557f,-8.899209f,34.91826f,-1.0E-5f,-8.221797f,34.91826f,-3.40559f,-6.292691f,34.91826f,-6.292701f,-3.40558f,34.91826f,-8.221807f,0.0f,34.91826f,-8.899219f,3.40558f,34.91826f,-8.221807f,6.292691f,34.91826f,-6.292701f,8.221797f,34.91826f,-3.40559f,8.06066f,34.91826f,3.338825f,8.724794f,34.91826f,-1.0E-5f,6.169362f,34.91826f,6.169352f,3.338835f,34.91826f,8.06065f,-0.0f,34.91826f,8.724784f,-3.338835f,34.91826f,8.06065f,-6.169362f,34.91826f,6.169352f,-8.06066f,34.91826f,3.338825f,-8.724794f,34.91826f,-1.0E-5f,-8.06066f,34.91826f,-3.338845f,-6.169362f,34.91826f,-6.169372f,-3.338835f,34.91826f,-8.06067f,-0.0f,34.91826f,-8.724804f,3.338835f,34.91826f,-8.06067f,6.169362f,34.91826f,-6.169372f,8.06066f,34.91826f,-3.338845f,-0.0f,34.91826f,-1.0E-5f);
    }
    private static void method27(){
        MESH_7.getTexCoords().ensureCapacity(922);
        MESH_7.getTexCoords().addAll(0.012377f,0.498904f,0.047104f,0.92502f,0.047104f,0.985894f,0.047104f,0.864147f,0.047104f,0.803273f,0.047104f,0.742399f,0.047104f,0.681525f,0.047104f,0.62065196f,0.047104f,0.559778f,0.047104f,0.498904f,0.047104f,0.43803f,0.047104f,0.37715697f,0.047104f,0.316283f,0.047104f,0.255409f,0.047104f,0.19453597f,0.047104f,0.13366199f,0.047104f,0.07278901f,0.047104f,0.011915028f,0.081831f,0.92502f,0.081831f,0.985894f,0.081831f,0.864147f,0.081831f,0.803273f,0.081831f,0.742399f,0.081831f,0.681525f,0.081831f,0.62065196f,0.081831f,0.559778f,0.081831f,0.498904f,0.081831f,0.43803f,0.081831f,0.37715697f,0.081831f,0.316283f,0.081831f,0.255409f,0.081831f,0.19453597f,0.081831f,0.13366199f,0.081831f,0.07278901f,0.081831f,0.011915028f,0.116558f,0.92502f,0.116558f,0.985894f,0.116558f,0.864147f,0.116558f,0.803273f,0.116558f,0.742399f,0.116558f,0.681525f,0.116558f,0.62065196f,0.116558f,0.559778f,0.116558f,0.498904f,0.116558f,0.43803f,0.116558f,0.37715697f,0.116558f,0.316283f,0.116558f,0.255409f,0.116558f,0.19453597f,0.116558f,0.13366199f,0.116558f,0.07278901f,0.116558f,0.011915028f,0.151284f,0.92502f,0.151284f,0.985894f,0.151284f,0.864147f,0.151284f,0.803273f,0.151284f,0.742399f,0.151284f,0.681525f,0.151284f,0.62065196f,0.151284f,0.559778f,0.151284f,0.498904f,0.151284f,0.43803f,0.151284f,0.37715697f,0.151284f,0.316283f,0.151284f,0.255409f,0.151284f,0.19453597f,0.151284f,0.13366199f,0.151284f,0.07278901f,0.151284f,0.011915028f,0.186011f,0.92502f,0.186011f,0.985894f,0.186011f,0.864147f,0.186011f,0.803273f,0.186011f,0.742399f,0.186011f,0.681525f,0.186011f,0.62065196f,0.186011f,0.559778f,0.186011f,0.498904f,0.186011f,0.43803f,0.186011f,0.37715697f,0.186011f,0.316283f,0.186011f,0.255409f,0.186011f,0.19453597f,0.186011f,0.13366199f,0.186011f,0.07278901f,0.186011f,0.011915028f,0.220738f,0.92502f,0.220738f,0.985894f,0.220738f,0.864147f,0.220738f,0.803273f,0.220738f,0.742399f,0.220738f,0.681525f,0.220738f,0.62065196f,0.220738f,0.559778f,0.220738f,0.498904f,0.220738f,0.43803f,0.220738f,0.37715697f,0.220738f,0.316283f,0.220738f,0.255409f,0.220738f,0.19453597f,0.220738f,0.13366199f,0.220738f,0.07278901f,0.220738f,0.011915028f,0.232814f,0.92502f,0.232814f,0.985894f,0.232814f,0.864147f,0.232814f,0.803273f,0.232814f,0.742399f,0.232814f,0.681525f,0.232814f,0.62065196f,0.232814f,0.559778f,0.232814f,0.498904f,0.232814f,0.43803f,0.232814f,0.37715697f,0.232814f,0.316283f,0.232814f,0.255409f,0.232814f,0.19453597f,0.232814f,0.13366199f,0.232814f,0.07278901f,0.232814f,0.011915028f,0.241377f,0.92502f,0.241377f,0.985894f,0.241377f,0.864147f,0.241377f,0.803273f,0.241377f,0.742399f,0.241377f,0.681525f,0.241377f,0.62065196f,0.241377f,0.559778f,0.241377f,0.498904f,0.241377f,0.43803f,0.241377f,0.37715697f,0.241377f,0.316283f,0.241377f,0.255409f,0.241377f,0.19453597f,0.241377f,0.13366199f,0.241377f,0.07278901f,0.241377f,0.011915028f,0.247946f,0.92502f,0.247946f,0.985894f,0.247946f,0.864147f,0.247946f,0.803273f,0.247946f,0.742399f,0.247946f,0.681525f,0.247946f,0.62065196f,0.247946f,0.559778f,0.247946f,0.498904f,0.247946f,0.43803f,0.247946f,0.37715697f,0.247946f,0.316283f,0.247946f,0.255409f,0.247946f,0.19453597f,0.247946f,0.13366199f,0.247946f,0.07278901f,0.247946f,0.011915028f,0.255466f,0.92502f,0.255466f,0.985894f,0.255466f,0.864147f,0.255466f,0.803273f,0.255466f,0.742399f,0.255466f,0.681525f,0.255466f,0.62065196f,0.255466f,0.559778f,0.255466f,0.498904f,0.255466f,0.43803f,0.255466f,0.37715697f,0.255466f,0.316283f,0.255466f,0.255409f,0.255466f,0.19453597f,0.255466f,0.13366199f,0.255466f,0.07278901f,0.255466f,0.011915028f,0.394373f,0.92502f,0.394373f,0.985894f,0.394373f,0.864147f,0.394373f,0.803273f,0.394373f,0.742399f,0.394373f,0.681525f,0.394373f,0.62065196f,0.394373f,0.559778f,0.394373f,0.498904f,0.394373f,0.43803f,0.394373f,0.37715697f,0.394373f,0.316283f,0.394373f,0.255409f,0.394373f,0.19453597f,0.394373f,0.13366199f,0.394373f,0.07278901f,0.394373f,0.011915028f,0.4291f,0.92502f,0.4291f,0.985894f,0.4291f,0.864147f,0.4291f,0.803273f,0.4291f,0.742399f,0.4291f,0.681525f,0.4291f,0.62065196f,0.4291f,0.559778f,0.4291f,0.498904f,0.4291f,0.43803f,0.4291f,0.37715697f,0.4291f,0.316283f,0.4291f,0.255409f,0.4291f,0.19453597f,0.4291f,0.13366199f,0.4291f,0.07278901f,0.4291f,0.011915028f,0.463828f,0.92502f,0.463828f,0.985894f,0.463828f,0.864147f,0.463828f,0.803273f,0.463828f,0.742399f,0.463828f,0.681525f,0.463828f,0.62065196f,0.463828f,0.559778f,0.463828f,0.498904f,0.463828f,0.43803f,0.463828f,0.37715697f,0.463828f,0.316283f,0.463828f,0.255409f,0.463828f,0.19453597f,0.463828f,0.13366199f,0.463828f,0.07278901f,0.463828f,0.011915028f,0.498554f,0.92502f,0.498554f,0.985894f,0.498554f,0.864147f,0.498554f,0.803273f,0.498554f,0.742399f,0.498554f,0.681525f,0.498554f,0.62065196f,0.498554f,0.559778f,0.498554f,0.498904f,0.498554f,0.43803f,0.498554f,0.37715697f,0.498554f,0.316283f,0.498554f,0.255409f,0.498554f,0.19453597f,0.498554f,0.13366199f,0.498554f,0.07278901f,0.498554f,0.011915028f,0.533281f,0.92502f,0.533281f,0.985894f,0.533281f,0.864147f,0.533281f,0.803273f,0.533281f,0.742399f,0.533281f,0.681525f,0.533281f,0.62065196f,0.533281f,0.559778f,0.533281f,0.498904f,0.533281f,0.43803f,0.533281f,0.37715697f,0.533281f,0.316283f,0.533281f,0.255409f,0.533281f,0.19453597f,0.533281f,0.13366199f,0.533281f,0.07278901f,0.533281f,0.011915028f,0.568007f,0.92502f,0.568007f,0.985894f,0.568007f,0.864147f,0.568007f,0.803273f,0.568007f,0.742399f,0.568007f,0.681525f,0.568007f,0.62065196f,0.568007f,0.559778f,0.568007f,0.498904f,0.568007f,0.43803f,0.568007f,0.37715697f,0.568007f,0.316283f,0.568007f,0.255409f,0.568007f,0.19453597f,0.568007f,0.13366199f,0.568007f,0.07278901f,0.568007f,0.011915028f,0.602734f,0.92502f,0.602734f,0.985894f,0.602734f,0.864147f,0.602734f,0.803273f,0.602734f,0.742399f,0.602734f,0.681525f,0.602734f,0.62065196f,0.602734f,0.559778f,0.602734f,0.498904f,0.602734f,0.43803f,0.602734f,0.37715697f,0.602734f,0.316283f,0.602734f,0.255409f,0.602734f,0.19453597f,0.602734f,0.13366199f,0.602734f,0.07278901f,0.602734f,0.011915028f,0.637463f,0.92502f,0.637463f,0.985894f,0.637463f,0.864147f,0.637463f,0.803273f,0.637463f,0.742399f,0.637463f,0.681525f,0.637463f,0.62065196f,0.637463f,0.559778f,0.637463f,0.498904f,0.637463f,0.43803f,0.637463f,0.37715697f,0.637463f,0.316283f,0.637463f,0.255409f,0.637463f,0.19453597f,0.637463f,0.13366199f,0.637463f,0.07278901f,0.637463f,0.011915028f,0.672188f,0.92502f,0.672188f,0.985894f,0.672188f,0.864147f,0.672188f,0.803273f,0.672188f,0.742399f,0.672188f,0.681525f,0.672188f,0.62065196f,0.672188f,0.559778f,0.672188f,0.498904f,0.672188f,0.43803f,0.672188f,0.37715697f,0.672188f,0.316283f,0.672188f,0.255409f,0.672188f,0.19453597f,0.672188f,0.13366199f,0.672188f,0.07278901f,0.672188f,0.011915028f,0.706917f,0.92502f,0.706917f,0.985894f,0.706917f,0.864147f,0.706917f,0.803273f,0.706917f,0.742399f,0.706917f,0.681525f,0.706917f,0.62065196f,0.706917f,0.559778f,0.706917f,0.498904f,0.706917f,0.43803f,0.706917f,0.37715697f,0.706917f,0.316283f,0.706917f,0.255409f,0.706917f,0.19453597f,0.706917f,0.13366199f,0.706917f,0.07278901f,0.706917f,0.011915028f,0.741642f,0.92502f,0.741642f,0.985894f,0.741642f,0.864147f,0.741642f,0.803273f,0.741642f,0.742399f,0.741642f,0.681525f,0.741642f,0.62065196f,0.741642f,0.559778f,0.741642f,0.498904f,0.741642f,0.43803f,0.741642f,0.37715697f,0.741642f,0.316283f,0.741642f,0.255409f,0.741642f,0.19453597f,0.741642f,0.13366199f,0.741642f,0.07278901f,0.741642f,0.011915028f,0.776369f,0.92502f,0.776369f,0.985894f,0.776369f,0.864147f,0.776369f,0.803273f,0.776369f,0.742399f,0.776369f,0.681525f,0.776369f,0.62065196f,0.776369f,0.559778f,0.776369f,0.498904f,0.776369f,0.43803f,0.776369f,0.37715697f,0.776369f,0.316283f,0.776369f,0.255409f,0.776369f,0.19453597f,0.776369f,0.13366199f,0.776369f,0.07278901f,0.776369f,0.011915028f,0.811096f,0.92502f,0.811096f,0.985894f,0.811096f,0.864147f,0.811096f,0.803273f,0.811096f,0.742399f,0.811096f,0.681525f,0.811096f,0.62065196f,0.811096f,0.559778f,0.811096f,0.498904f,0.811096f,0.43803f,0.811096f,0.37715697f,0.811096f,0.316283f,0.811096f,0.255409f,0.811096f,0.19453597f,0.811096f,0.13366199f,0.811096f,0.07278901f,0.811096f,0.011915028f,0.845823f,0.92502f,0.845823f,0.985894f,0.845823f,0.864147f,0.845823f,0.803273f,0.845823f,0.742399f,0.845823f,0.681525f,0.845823f,0.62065196f,0.845823f,0.559778f,0.845823f,0.498904f,0.845823f,0.43803f,0.845823f,0.37715697f,0.845823f,0.316283f,0.845823f,0.255409f,0.845823f,0.19453597f,0.845823f,0.13366199f,0.845823f,0.07278901f,0.845823f,0.011915028f,0.880548f,0.92502f,0.880548f,0.985894f,0.880548f,0.864147f,0.880548f,0.803273f,0.880548f,0.742399f,0.880548f,0.681525f,0.880548f,0.62065196f,0.880548f,0.559778f,0.880548f,0.498904f,0.880548f,0.43803f,0.880548f,0.37715697f,0.880548f,0.316283f,0.880548f,0.255409f,0.880548f,0.19453597f,0.880548f,0.13366199f,0.880548f,0.07278901f,0.880548f,0.011915028f,0.915274f,0.92502f,0.915274f,0.985894f,0.915274f,0.864147f,0.915274f,0.803273f,0.915274f,0.742399f,0.915274f,0.681525f,0.915274f,0.62065196f,0.915274f,0.559778f,0.915274f,0.498904f,0.915274f,0.43803f,0.915274f,0.37715697f,0.915274f,0.316283f,0.915274f,0.255409f,0.915274f,0.19453597f,0.915274f,0.13366199f,0.915274f,0.07278901f,0.915274f,0.011915028f,0.950005f,0.92502f,0.950005f,0.985894f,0.950005f,0.864147f,0.950005f,0.803273f,0.950005f,0.742399f,0.950005f,0.681525f,0.950005f,0.62065196f,0.950005f,0.559778f,0.950005f,0.498904f,0.950005f,0.43803f,0.950005f,0.37715697f,0.950005f,0.316283f,0.950005f,0.255409f,0.950005f,0.19453597f,0.950005f,0.13366199f,0.950005f,0.07278901f,0.950005f,0.011915028f,0.98473f,0.498904f);
    }
    private static void method28(){
        MESH_7.getFaces().ensureCapacity(5184);
        MESH_7.getFaces().addAll(0,0,1,1,2,2,0,0,3,3,1,1,0,0,4,4,3,3,0,0,5,5,4,4,0,0,6,6,5,5,0,0,7,7,6,6,0,0,8,8,7,7,0,0,9,9,8,8,0,0,10,10,9,9,0,0,11,11,10,10,0,0,12,12,11,11,0,0,13,13,12,12,0,0,14,14,13,13,0,0,15,15,14,14,0,0,16,16,15,15,0,0,2,17,16,16,2,2,1,1,17,18,2,2,17,18,18,19,1,1,3,3,19,20,1,1,19,20,17,18,3,3,4,4,20,21,3,3,20,21,19,20,4,4,5,5,21,22,4,4,21,22,20,21,5,5,6,6,22,23,5,5,22,23,21,22,6,6,7,7,23,24,6,6,23,24,22,23,7,7,8,8,24,25,7,7,24,25,23,24,8,8,9,9,25,26,8,8,25,26,24,25,9,9,10,10,26,27,9,9,26,27,25,26,10,10,11,11,27,28,10,10,27,28,26,27,11,11,12,12,28,29,11,11,28,29,27,28,12,12,13,13,29,30,12,12,29,30,28,29,13,13,14,14,30,31,13,13,30,31,29,30,14,14,15,15,31,32,14,14,31,32,30,31,15,15,16,16,32,33,15,15,32,33,31,32,16,16,2,17,18,34,16,16,18,34,32,33,18,19,17,18,33,35,18,19,33,35,34,36,17,18,19,20,35,37,17,18,35,37,33,35,19,20,20,21,36,38,19,20,36,38,35,37,20,21,21,22,37,39,20,21,37,39,36,38,21,22,22,23,38,40,21,22,38,40,37,39,22,23,23,24,39,41,22,23,39,41,38,40,23,24,24,25,40,42,23,24,40,42,39,41,24,25,25,26,41,43,24,25,41,43,40,42,25,26,26,27,42,44,25,26,42,44,41,43,26,27,27,28,43,45,26,27,43,45,42,44,27,28,28,29,44,46,27,28,44,46,43,45,28,29,29,30,45,47,28,29,45,47,44,46,29,30,30,31,46,48,29,30,46,48,45,47,30,31,31,32,47,49,30,31,47,49,46,48,31,32,32,33,48,50,31,32,48,50,47,49,32,33,18,34,34,51,32,33,34,51,48,50,34,36,33,35,49,52,34,36,49,52,50,53,33,35,35,37,51,54,33,35,51,54,49,52,35,37,36,38,52,55,35,37,52,55,51,54,36,38,37,39,53,56,36,38,53,56,52,55,37,39,38,40,54,57,37,39,54,57,53,56,38,40,39,41,55,58,38,40,55,58,54,57,39,41,40,42,56,59,39,41,56,59,55,58,40,42,41,43,57,60,40,42,57,60,56,59,41,43,42,44,58,61,41,43,58,61,57,60,42,44,43,45,59,62,42,44,59,62,58,61,43,45,44,46,60,63,43,45,60,63,59,62,44,46,45,47,61,64,44,46,61,64,60,63,45,47,46,48,62,65,45,47,62,65,61,64,46,48,47,49,63,66,46,48,63,66,62,65,47,49,48,50,64,67,47,49,64,67,63,66,48,50,34,51,50,68,48,50,50,68,64,67,50,53,49,52,65,69,50,53,65,69,66,70,49,52,51,54,67,71,49,52,67,71,65,69,51,54,52,55,68,72,51,54,68,72,67,71,52,55,53,56,69,73,52,55,69,73,68,72,53,56,54,57,70,74,53,56,70,74,69,73,54,57,55,58,71,75,54,57,71,75,70,74,55,58,56,59,72,76,55,58,72,76,71,75,56,59,57,60,73,77,56,59,73,77,72,76,57,60,58,61,74,78,57,60,74,78,73,77,58,61,59,62,75,79,58,61,75,79,74,78,59,62,60,63,76,80,59,62,76,80,75,79,60,63,61,64,77,81,60,63,77,81,76,80,61,64,62,65,78,82,61,64,78,82,77,81,62,65,63,66,79,83,62,65,79,83,78,82,63,66,64,67,80,84,63,66,80,84,79,83,64,67,50,68,66,85,64,67,66,85,80,84,66,70,65,69,81,86,66,70,81,86,82,87,65,69,67,71,83,88,65,69,83,88,81,86,67,71,68,72,84,89,67,71,84,89,83,88,68,72,69,73,85,90,68,72,85,90,84,89,69,73,70,74,86,91,69,73,86,91,85,90,70,74,71,75,87,92,70,74,87,92,86,91,71,75,72,76,88,93,71,75,88,93,87,92,72,76,73,77,89,94,72,76,89,94,88,93,73,77,74,78,90,95,73,77,90,95,89,94,74,78,75,79,91,96,74,78,91,96,90,95,75,79,76,80,92,97,75,79,92,97,91,96,76,80,77,81,93,98,76,80,93,98,92,97,77,81,78,82,94,99,77,81,94,99,93,98,78,82,79,83,95,100,78,82,95,100,94,99,79,83,80,84,96,101,79,83,96,101,95,100,80,84,66,85,82,102,80,84,82,102,96,101,82,87,81,86,97,103,82,87,97,103,98,104,81,86,83,88,99,105,81,86,99,105,97,103,83,88,84,89,100,106,83,88,100,106,99,105,84,89,85,90,101,107,84,89,101,107,100,106,85,90,86,91,102,108,85,90,102,108,101,107,86,91,87,92,103,109,86,91,103,109,102,108,87,92,88,93,104,110,87,92,104,110,103,109,88,93,89,94,105,111,88,93,105,111,104,110,89,94,90,95,106,112,89,94,106,112,105,111,90,95,91,96,107,113,90,95,107,113,106,112,91,96,92,97,108,114,91,96,108,114,107,113,92,97,93,98,109,115,92,97,109,115,108,114,93,98,94,99,110,116,93,98,110,116,109,115,94,99,95,100,111,117,94,99,111,117,110,116,95,100,96,101,112,118,95,100,112,118,111,117,96,101,82,102,98,119,96,101,98,119,112,118,98,104,97,103,113,120,98,104,113,120,114,121,97,103,99,105,115,122,97,103,115,122,113,120,99,105,100,106,116,123,99,105,116,123,115,122,100,106,101,107,117,124,100,106,117,124,116,123,101,107,102,108,118,125,101,107,118,125,117,124,102,108,103,109,119,126,102,108,119,126,118,125,103,109,104,110,120,127,103,109,120,127,119,126,104,110,105,111,121,128,104,110,121,128,120,127,105,111,106,112,122,129,105,111,122,129,121,128,106,112,107,113,123,130,106,112,123,130,122,129,107,113,108,114,124,131,107,113,124,131,123,130,108,114,109,115,125,132,108,114,125,132,124,131,109,115,110,116,126,133,109,115,126,133,125,132,110,116,111,117,127,134,110,116,127,134,126,133,111,117,112,118,128,135,111,117,128,135,127,134,112,118,98,119,114,136,112,118,114,136,128,135,114,121,113,120,129,137,114,121,129,137,130,138,113,120,115,122,131,139,113,120,131,139,129,137,115,122,116,123,132,140,115,122,132,140,131,139,116,123,117,124,133,141,116,123,133,141,132,140,117,124,118,125,134,142,117,124,134,142,133,141,118,125,119,126,135,143,118,125,135,143,134,142,119,126,120,127,136,144,119,126,136,144,135,143,120,127,121,128,137,145,120,127,137,145,136,144,121,128,122,129,138,146,121,128,138,146,137,145,122,129,123,130,139,147,122,129,139,147,138,146,123,130,124,131,140,148,123,130,140,148,139,147,124,131,125,132,141,149,124,131,141,149,140,148,125,132,126,133,142,150,125,132,142,150,141,149,126,133,127,134,143,151,126,133,143,151,142,150,127,134,128,135,144,152,127,134,144,152,143,151,128,135,114,136,130,153,128,135,130,153,144,152,130,138,129,137,145,154,130,138,145,154,146,155,129,137,131,139,147,156,129,137,147,156,145,154,131,139,132,140,148,157,131,139,148,157,147,156,132,140,133,141,149,158,132,140,149,158,148,157,133,141,134,142,150,159,133,141,150,159,149,158,134,142,135,143,151,160,134,142,151,160,150,159,135,143,136,144,152,161,135,143,152,161,151,160,136,144,137,145,153,162,136,144,153,162,152,161,137,145,138,146,154,163,137,145,154,163,153,162,138,146,139,147,155,164,138,146,155,164,154,163,139,147,140,148,156,165,139,147,156,165,155,164,140,148,141,149,157,166,140,148,157,166,156,165,141,149,142,150,158,167,141,149,158,167,157,166,142,150,143,151,159,168,142,150,159,168,158,167,143,151,144,152,160,169,143,151,160,169,159,168,144,152,130,153,146,170,144,152,146,170,160,169,146,155,145,154,161,171,146,155,161,171,162,172,145,154,147,156,163,173,145,154,163,173,161,171,147,156,148,157,164,174,147,156,164,174,163,173,148,157,149,158,165,175,148,157,165,175,164,174,149,158,150,159,166,176,149,158,166,176,165,175,150,159,151,160,167,177,150,159,167,177,166,176,151,160,152,161,168,178,151,160,168,178,167,177,152,161,153,162,169,179,152,161,169,179,168,178,153,162,154,163,170,180,153,162,170,180,169,179,154,163,155,164,171,181,154,163,171,181,170,180,155,164,156,165,172,182,155,164,172,182,171,181,156,165,157,166,173,183,156,165,173,183,172,182,157,166,158,167,174,184,157,166,174,184,173,183,158,167,159,168,175,185,158,167,175,185,174,184,159,168,160,169,176,186,159,168,176,186,175,185,160,169,146,170,162,187,160,169,162,187,176,186,162,172,161,171,177,188,162,172,177,188,178,189,161,171,163,173,179,190,161,171,179,190,177,188,163,173,164,174,180,191,163,173,180,191,179,190,164,174,165,175,181,192,164,174,181,192,180,191,165,175,166,176,182,193,165,175,182,193,181,192,166,176,167,177,183,194,166,176,183,194,182,193,167,177,168,178,184,195,167,177,184,195,183,194,168,178,169,179,185,196,168,178,185,196,184,195,169,179,170,180,186,197,169,179,186,197,185,196,170,180,171,181,187,198,170,180,187,198,186,197,171,181,172,182,188,199,171,181,188,199,187,198,172,182,173,183,189,200,172,182,189,200,188,199,173,183,174,184,190,201,173,183,190,201,189,200,174,184,175,185,191,202,174,184,191,202,190,201,175,185,176,186,192,203,175,185,192,203,191,202,176,186,162,187,178,204,176,186,178,204,192,203,178,189,177,188,193,205,178,189,193,205,194,206,177,188,179,190,195,207,177,188,195,207,193,205,179,190,180,191,196,208,179,190,196,208,195,207,180,191,181,192,197,209,180,191,197,209,196,208,181,192,182,193,198,210,181,192,198,210,197,209,182,193,183,194,199,211,182,193,199,211,198,210,183,194,184,195,200,212,183,194,200,212,199,211,184,195,185,196,201,213,184,195,201,213,200,212,185,196,186,197,202,214,185,196,202,214,201,213,186,197,187,198,203,215,186,197,203,215,202,214,187,198,188,199,204,216,187,198,204,216,203,215,188,199,189,200,205,217,188,199,205,217,204,216,189,200,190,201,206,218,189,200,206,218,205,217,190,201,191,202,207,219,190,201,207,219,206,218,191,202,192,203,208,220,191,202,208,220,207,219,192,203,178,204,194,221,192,203,194,221,208,220,194,206,193,205,209,222,194,206,209,222,210,223,193,205,195,207,211,224,193,205,211,224,209,222,195,207,196,208,212,225,195,207,212,225,211,224,196,208,197,209,213,226,196,208,213,226,212,225,197,209,198,210,214,227,197,209,214,227,213,226,198,210,199,211,215,228,198,210,215,228,214,227,199,211,200,212,216,229,199,211,216,229,215,228,200,212,201,213,217,230,200,212,217,230,216,229,201,213,202,214,218,231,201,213,218,231,217,230,202,214,203,215,219,232,202,214,219,232,218,231,203,215,204,216,220,233,203,215,220,233,219,232,204,216,205,217,221,234,204,216,221,234,220,233,205,217,206,218,222,235,205,217,222,235,221,234,206,218,207,219,223,236,206,218,223,236,222,235,207,219,208,220,224,237,207,219,224,237,223,236,208,220,194,221,210,238,208,220,210,238,224,237,210,223,209,222,225,239,210,223,225,239,226,240,209,222,211,224,227,241,209,222,227,241,225,239,211,224,212,225,228,242,211,224,228,242,227,241,212,225,213,226,229,243,212,225,229,243,228,242,213,226,214,227,230,244,213,226,230,244,229,243,214,227,215,228,231,245,214,227,231,245,230,244,215,228,216,229,232,246,215,228,232,246,231,245,216,229,217,230,233,247,216,229,233,247,232,246,217,230,218,231,234,248,217,230,234,248,233,247,218,231,219,232,235,249,218,231,235,249,234,248,219,232,220,233,236,250,219,232,236,250,235,249,220,233,221,234,237,251,220,233,237,251,236,250,221,234,222,235,238,252,221,234,238,252,237,251,222,235,223,236,239,253,222,235,239,253,238,252,223,236,224,237,240,254,223,236,240,254,239,253,224,237,210,238,226,255,224,237,226,255,240,254,226,240,225,239,241,256,226,240,241,256,242,257,225,239,227,241,243,258,225,239,243,258,241,256,227,241,228,242,244,259,227,241,244,259,243,258,228,242,229,243,245,260,228,242,245,260,244,259,229,243,230,244,246,261,229,243,246,261,245,260,230,244,231,245,247,262,230,244,247,262,246,261,231,245,232,246,248,263,231,245,248,263,247,262,232,246,233,247,249,264,232,246,249,264,248,263,233,247,234,248,250,265,233,247,250,265,249,264,234,248,235,249,251,266,234,248,251,266,250,265,235,249,236,250,252,267,235,249,252,267,251,266,236,250,237,251,253,268,236,250,253,268,252,267,237,251,238,252,254,269,237,251,254,269,253,268,238,252,239,253,255,270,238,252,255,270,254,269,239,253,240,254,256,271,239,253,256,271,255,270,240,254,226,255,242,272,240,254,242,272,256,271,242,257,241,256,257,273,242,257,257,273,258,274,241,256,243,258,259,275,241,256,259,275,257,273,243,258,244,259,260,276,243,258,260,276,259,275,244,259,245,260,261,277,244,259,261,277,260,276,245,260,246,261,262,278,245,260,262,278,261,277,246,261,247,262,263,279,246,261,263,279,262,278,247,262,248,263,264,280,247,262,264,280,263,279,248,263,249,264,265,281,248,263,265,281,264,280,249,264,250,265,266,282,249,264,266,282,265,281,250,265,251,266,267,283,250,265,267,283,266,282,251,266,252,267,268,284,251,266,268,284,267,283,252,267,253,268,269,285,252,267,269,285,268,284,253,268,254,269,270,286,253,268,270,286,269,285,254,269,255,270,271,287,254,269,271,287,270,286,255,270,256,271,272,288,255,270,272,288,271,287,256,271,242,272,258,289,256,271,258,289,272,288,258,274,257,273,273,290,258,274,273,290,274,291,257,273,259,275,275,292,257,273,275,292,273,290,259,275,260,276,276,293,259,275,276,293,275,292,260,276,261,277,277,294,260,276,277,294,276,293,261,277,262,278,278,295,261,277,278,295,277,294,262,278,263,279,279,296,262,278,279,296,278,295,263,279,264,280,280,297,263,279,280,297,279,296,264,280,265,281,281,298,264,280,281,298,280,297,265,281,266,282,282,299,265,281,282,299,281,298,266,282,267,283,283,300,266,282,283,300,282,299,267,283,268,284,284,301,267,283,284,301,283,300,268,284,269,285,285,302,268,284,285,302,284,301,269,285,270,286,286,303,269,285,286,303,285,302,270,286,271,287,287,304,270,286,287,304,286,303,271,287,272,288,288,305,271,287,288,305,287,304,272,288,258,289,274,306,272,288,274,306,288,305,274,291,273,290,289,307,274,291,289,307,290,308,273,290,275,292,291,309,273,290,291,309,289,307,275,292,276,293,292,310,275,292,292,310,291,309,276,293,277,294,293,311,276,293,293,311,292,310,277,294,278,295,294,312,277,294,294,312,293,311,278,295,279,296,295,313,278,295,295,313,294,312,279,296,280,297,296,314,279,296,296,314,295,313,280,297,281,298,297,315,280,297,297,315,296,314,281,298,282,299,298,316,281,298,298,316,297,315,282,299,283,300,299,317,282,299,299,317,298,316,283,300,284,301,300,318,283,300,300,318,299,317,284,301,285,302,301,319,284,301,301,319,300,318,285,302,286,303,302,320,285,302,302,320,301,319,286,303,287,304,303,321,286,303,303,321,302,320,287,304,288,305,304,322,287,304,304,322,303,321,288,305,274,306,290,323,288,305,290,323,304,322,290,308,289,307,305,324,290,308,305,324,306,325,289,307,291,309,307,326,289,307,307,326,305,324,291,309,292,310,308,327,291,309,308,327,307,326,292,310,293,311,309,328,292,310,309,328,308,327,293,311,294,312,310,329,293,311,310,329,309,328,294,312,295,313,311,330,294,312,311,330,310,329,295,313,296,314,312,331,295,313,312,331,311,330,296,314,297,315,313,332,296,314,313,332,312,331,297,315,298,316,314,333,297,315,314,333,313,332,298,316,299,317,315,334,298,316,315,334,314,333,299,317,300,318,316,335,299,317,316,335,315,334,300,318,301,319,317,336,300,318,317,336,316,335,301,319,302,320,318,337,301,319,318,337,317,336,302,320,303,321,319,338,302,320,319,338,318,337,303,321,304,322,320,339,303,321,320,339,319,338,304,322,290,323,306,340,304,322,306,340,320,339,306,325,305,324,321,341,306,325,321,341,322,342,305,324,307,326,323,343,305,324,323,343,321,341,307,326,308,327,324,344,307,326,324,344,323,343,308,327,309,328,325,345,308,327,325,345,324,344,309,328,310,329,326,346,309,328,326,346,325,345,310,329,311,330,327,347,310,329,327,347,326,346,311,330,312,331,328,348,311,330,328,348,327,347,312,331,313,332,329,349,312,331,329,349,328,348,313,332,314,333,330,350,313,332,330,350,329,349,314,333,315,334,331,351,314,333,331,351,330,350,315,334,316,335,332,352,315,334,332,352,331,351,316,335,317,336,333,353,316,335,333,353,332,352,317,336,318,337,334,354,317,336,334,354,333,353,318,337,319,338,335,355,318,337,335,355,334,354,319,338,320,339,336,356,319,338,336,356,335,355,320,339,306,340,322,357,320,339,322,357,336,356,322,342,321,341,337,358,322,342,337,358,338,359,321,341,323,343,339,360,321,341,339,360,337,358,323,343,324,344,340,361,323,343,340,361,339,360,324,344,325,345,341,362,324,344,341,362,340,361,325,345,326,346,342,363,325,345,342,363,341,362,326,346,327,347,343,364,326,346,343,364,342,363,327,347,328,348,344,365,327,347,344,365,343,364,328,348,329,349,345,366,328,348,345,366,344,365,329,349,330,350,346,367,329,349,346,367,345,366,330,350,331,351,347,368,330,350,347,368,346,367,331,351,332,352,348,369,331,351,348,369,347,368,332,352,333,353,349,370,332,352,349,370,348,369,333,353,334,354,350,371,333,353,350,371,349,370,334,354,335,355,351,372,334,354,351,372,350,371,335,355,336,356,352,373,335,355,352,373,351,372,336,356,322,357,338,374,336,356,338,374,352,373,338,359,337,358,353,375,338,359,353,375,354,376,337,358,339,360,355,377,337,358,355,377,353,375,339,360,340,361,356,378,339,360,356,378,355,377,340,361,341,362,357,379,340,361,357,379,356,378,341,362,342,363,358,380,341,362,358,380,357,379,342,363,343,364,359,381,342,363,359,381,358,380,343,364,344,365,360,382,343,364,360,382,359,381,344,365,345,366,361,383,344,365,361,383,360,382,345,366,346,367,362,384,345,366,362,384,361,383,346,367,347,368,363,385,346,367,363,385,362,384,347,368,348,369,364,386,347,368,364,386,363,385,348,369,349,370,365,387,348,369,365,387,364,386,349,370,350,371,366,388,349,370,366,388,365,387,350,371,351,372,367,389,350,371,367,389,366,388,351,372,352,373,368,390,351,372,368,390,367,389,352,373,338,374,354,391,352,373,354,391,368,390,354,376,353,375,369,392,354,376,369,392,370,393,353,375,355,377,371,394,353,375,371,394,369,392,355,377,356,378,372,395,355,377,372,395,371,394,356,378,357,379,373,396,356,378,373,396,372,395,357,379,358,380,374,397,357,379,374,397,373,396,358,380,359,381,375,398,358,380,375,398,374,397,359,381,360,382,376,399,359,381,376,399,375,398,360,382,361,383,377,400,360,382,377,400,376,399,361,383,362,384,378,401,361,383,378,401,377,400,362,384,363,385,379,402,362,384,379,402,378,401,363,385,364,386,380,403,363,385,380,403,379,402,364,386,365,387,381,404,364,386,381,404,380,403,365,387,366,388,382,405,365,387,382,405,381,404,366,388,367,389,383,406,366,388,383,406,382,405,367,389,368,390,384,407,367,389,384,407,383,406,368,390,354,391,370,408,368,390,370,408,384,407,370,393,369,392,385,409,370,393,385,409,386,410,369,392,371,394,387,411,369,392,387,411,385,409,371,394,372,395,388,412,371,394,388,412,387,411,372,395,373,396,389,413,372,395,389,413,388,412,373,396,374,397,390,414,373,396,390,414,389,413,374,397,375,398,391,415,374,397,391,415,390,414,375,398,376,399,392,416,375,398,392,416,391,415,376,399,377,400,393,417,376,399,393,417,392,416,377,400,378,401,394,418,377,400,394,418,393,417,378,401,379,402,395,419,378,401,395,419,394,418,379,402,380,403,396,420,379,402,396,420,395,419,380,403,381,404,397,421,380,403,397,421,396,420,381,404,382,405,398,422,381,404,398,422,397,421,382,405,383,406,399,423,382,405,399,423,398,422,383,406,384,407,400,424,383,406,400,424,399,423,384,407,370,408,386,425,384,407,386,425,400,424,386,410,385,409,401,426,386,410,401,426,402,427,385,409,387,411,403,428,385,409,403,428,401,426,387,411,388,412,404,429,387,411,404,429,403,428,388,412,389,413,405,430,388,412,405,430,404,429,389,413,390,414,406,431,389,413,406,431,405,430,390,414,391,415,407,432,390,414,407,432,406,431,391,415,392,416,408,433,391,415,408,433,407,432,392,416,393,417,409,434,392,416,409,434,408,433,393,417,394,418,410,435,393,417,410,435,409,434,394,418,395,419,411,436,394,418,411,436,410,435,395,419,396,420,412,437,395,419,412,437,411,436,396,420,397,421,413,438,396,420,413,438,412,437,397,421,398,422,414,439,397,421,414,439,413,438,398,422,399,423,415,440,398,422,415,440,414,439,399,423,400,424,416,441,399,423,416,441,415,440,400,424,386,425,402,442,400,424,402,442,416,441,402,427,401,426,417,443,402,427,417,443,418,444,401,426,403,428,419,445,401,426,419,445,417,443,403,428,404,429,420,446,403,428,420,446,419,445,404,429,405,430,421,447,404,429,421,447,420,446,405,430,406,431,422,448,405,430,422,448,421,447,406,431,407,432,423,449,406,431,423,449,422,448,407,432,408,433,424,450,407,432,424,450,423,449,408,433,409,434,425,451,408,433,425,451,424,450,409,434,410,435,426,452,409,434);
    }
    private static void method29(){
        MESH_7.getFaces().addAll(426,452,425,451,410,435,411,436,427,453,410,435,427,453,426,452,411,436,412,437,428,454,411,436,428,454,427,453,412,437,413,438,429,455,412,437,429,455,428,454,413,438,414,439,430,456,413,438,430,456,429,455,414,439,415,440,431,457,414,439,431,457,430,456,415,440,416,441,432,458,415,440,432,458,431,457,416,441,402,442,418,459,416,441,418,459,432,458,418,444,417,443,433,460,417,443,419,445,433,460,419,445,420,446,433,460,420,446,421,447,433,460,421,447,422,448,433,460,422,448,423,449,433,460,423,449,424,450,433,460,424,450,425,451,433,460,425,451,426,452,433,460,426,452,427,453,433,460,427,453,428,454,433,460,428,454,429,455,433,460,429,455,430,456,433,460,430,456,431,457,433,460,431,457,432,458,433,460,432,458,418,459,433,460);
    }
    private static void method30(){
        MESH_7.getFaceSmoothingGroups().ensureCapacity(864);
        MESH_7.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_9 = MESHVIEWS[8];
        MESHVIEWS[8].setId("duke_model duke_model_R_arm_geo");
        MESHVIEWS[8].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_8 = new PhongMaterial();
        MATERIAL_8.setDiffuseColor(new Color(0.10000000149011612,0.10000000149011612,0.10000000149011612,1.0));
        MATERIAL_8.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_8.setSpecularPower(18.0);
        MESHVIEWS[8].setMaterial(MATERIAL_8);
        MESH_8 = new TriangleMesh();
        MESHVIEWS[8].setMesh(MESH_8);
        MESH_8.getPoints().ensureCapacity(687);
        MESH_8.getPoints().addAll(-14.23585f,14.369265f,5.385233f,-13.773984f,14.351528f,5.399971f,-13.722763f,16.130238f,4.010039f,-14.223948f,16.141773f,3.984912f,-13.599391f,17.960226f,2.631867f,-14.140978f,17.974327f,2.606673f,-14.596291f,17.83107f,2.402393f,-14.64265f,16.014147f,3.801937f,-14.601901f,14.207218f,5.16568f,-13.453501f,14.195624f,5.240689f,-13.303418f,15.968957f,3.852029f,-13.219448f,13.997956f,5.025441f,-13.050063f,15.703011f,3.557698f,-12.841836f,17.488731f,2.133827f,-13.132839f,17.78182f,2.457314f,-13.267886f,13.688985f,4.656977f,-13.046803f,15.377599f,3.173798f,-13.479747f,13.445255f,4.352905f,-13.263617f,15.106076f,2.836536f,-13.068613f,16.829773f,1.338455f,-12.826966f,17.130627f,1.712259f,-13.768071f,13.371567f,4.243657f,-13.670531f,15.001872f,2.682095f,-14.150348f,13.368446f,4.210449f,-14.133379f,15.043545f,2.695554f,-14.088146f,16.74638f,1.16125f,-13.547365f,16.708567f,1.158394f,-14.511544f,13.525097f,4.367466f,-14.742134f,13.758231f,4.624851f,-14.764535f,15.460758f,3.139285f,-14.517783f,15.20955f,2.861814f,-14.773779f,17.199135f,1.642726f,-14.516079f,16.92269f,1.336311f,-14.748044f,14.02068f,4.934196f,-14.814528f,15.758076f,3.486359f,-14.803864f,17.537289f,2.039569f,-12.801689f,20.833551f,1.497667f,-11.752717f,22.550814f,1.665146f,-12.423103f,22.936146f,1.482179f,-13.364333f,21.159292f,1.371344f,-12.945776f,23.203255f,0.951499f,-13.793377f,21.380728f,0.96106f,-11.11642f,22.147087f,1.396375f,-12.296864f,20.51293f,1.280771f,-11.936361f,20.257141f,0.813465f,-10.640893f,21.809475f,0.777504f,-10.452821f,21.6225f,-0.089729f,-11.806785f,20.125965f,0.188546f,-11.901526f,20.129335f,-0.432273f,-10.605367f,21.644762f,-0.893216f,-11.151746f,21.934912f,-1.320731f,-12.363885f,20.37586f,-0.782452f,-12.905287f,20.68927f,-0.904386f,-11.868268f,22.357159f,-1.3952f,-13.740299f,21.239557f,-0.313224f,-13.001438f,23.103334f,-0.599956f,-12.53134f,22.775778f,-1.13952f,-13.386872f,20.991856f,-0.735655f,-13.139072f,23.252407f,0.177257f,-13.89726f,21.388338f,0.325947f,-13.599512f,19.345392f,1.402765f,-14.165782f,19.433224f,1.354238f,-13.562442f,19.576874f,1.272609f,-14.149971f,19.74603f,1.194136f,-14.58934f,19.76932f,0.894921f,-14.633842f,19.371569f,1.104547f,-14.40108f,20.201008f,0.821294f,-13.970185f,20.066124f,1.194282f,-13.408086f,19.80707f,1.295323f,-12.816922f,18.849825f,0.885714f,-12.780091f,19.070917f,0.745514f,-13.083775f,19.338491f,1.110268f,-13.121417f,19.135525f,1.231885f,-12.944653f,19.539408f,1.137742f,-12.642498f,19.304455f,0.765734f,-12.771391f,18.534466f,0.408347f,-13.009687f,18.312508f,-0.016264f,-12.913543f,18.677103f,-0.244841f,-12.71742f,18.814133f,0.216719f,-12.690474f,19.0834f,-0.332492f,-12.572041f,19.147202f,0.223651f,-13.480021f,18.256548f,-0.257807f,-14.042766f,18.3579f,-0.284075f,-13.952825f,18.866922f,-0.629815f,-13.394247f,18.701082f,-0.566497f,-13.149618f,19.243546f,-0.637948f,-13.657841f,19.473598f,-0.747855f,-14.390605f,19.087774f,-0.474968f,-14.481644f,18.55741f,-0.116507f,-14.754021f,18.825584f,0.212836f,-14.676638f,19.342102f,-0.12623f,-14.377994f,19.946808f,-0.247785f,-14.079074f,19.715906f,-0.608962f,-14.817353f,19.133007f,0.671978f,-14.779948f,19.608349f,0.3921f,-14.519201f,20.142601f,0.30911f,-10.411372f,24.44704f,1.9729f,-11.275386f,24.939844f,1.692577f,-9.575271f,23.921206f,1.674101f,-8.951342f,23.478682f,0.867339f,-8.723793f,23.235775f,-0.376241f,-8.948677f,23.271307f,-1.529163f,-9.682146f,23.66417f,-2.06393f,-10.65387f,24.24338f,-2.088379f,-11.593621f,24.838024f,-1.710322f,-12.240949f,25.286772f,-0.994104f,-12.335361f,25.428253f,-0.004174f,-11.979321f,25.300064f,0.983429f,-9.103513f,24.704226f,1.654781f,-9.968377f,25.248203f,1.963693f,-8.45784f,24.246273f,0.820307f,-8.222062f,23.994728f,-0.466249f,-8.454168f,24.031195f,-1.65904f,-9.212279f,24.43736f,-2.212106f,-10.217107f,25.036448f,-2.237315f,-11.189339f,25.651659f,-1.84658f,-11.859306f,26.116037f,-1.106053f,-11.957315f,26.262608f,-0.081929f,-11.589462f,26.130262f,0.939915f,-10.861774f,25.75785f,1.673616f,-8.287426f,24.96252f,0.636032f,-8.856317f,25.365974f,1.371227f,-8.079679f,24.740911f,-0.497468f,-8.284197f,24.773024f,-1.548339f,-8.95216f,25.130777f,-2.035587f,-9.837486f,25.658493f,-2.057811f,-10.694062f,26.20048f,-1.713557f,-11.284329f,26.609615f,-1.061119f,-11.370679f,26.738747f,-0.158843f,-11.046584f,26.622168f,0.741417f,-10.405445f,26.294127f,1.387823f,-9.618295f,25.845177f,1.643378f,-8.359439f,25.585258f,0.365461f,-8.788527f,25.889395f,0.919913f,-8.202715f,25.418194f,-0.489396f,-8.357019f,25.442318f,-1.281886f,-8.861003f,25.71173f,-1.649322f,-9.528895f,26.109295f,-1.666044f,-10.174966f,26.5179f,-1.406419f,-10.620108f,26.826445f,-0.914389f,-10.685243f,26.923836f,-0.233924f,-10.440773f,26.836f,0.445003f,-9.957083f,26.58886f,0.932469f,-9.3633f,26.250597f,1.125189f,-8.578412f,26.082064f,0.068445f,-8.844851f,26.264297f,0.409566f,-8.480459f,25.982136f,-0.457081f,-8.577587f,25.993092f,-0.943757f,-8.89635f,26.143476f,-1.168233f,-9.316118f,26.37218f,-1.177168f,-9.716243f,26.618076f,-1.017191f,-9.989795f,26.807653f,-0.714835f,-10.029885f,26.867416f,-0.296662f,-9.877671f,26.816723f,0.120255f,-9.574389f,26.674992f,0.418929f,-9.202592f,26.478672f,0.53636f,-8.863196f,26.388859f,-0.189757f,-8.976512f,26.46636f,-0.044695f,-8.821568f,26.346376f,-0.413255f,-8.862849f,26.35102f,-0.620214f,-8.998404f,26.414978f,-0.715682f,-9.176927f,26.512241f,-0.719471f,-9.347073f,26.616804f,-0.651443f,-9.463413f,26.697426f,-0.522859f,-9.480441f,26.722828f,-0.345042f,-9.415739f,26.701294f,-0.167726f,-9.286759f,26.64101f,-0.040709f,-9.128663f,26.557531f,0.009226f,-9.126912f,26.520136f,-0.371325f,-9.127162f,26.520306f,-0.37101f,-9.12683f,26.520044f,-0.371821f,-9.126907f,26.520048f,-0.372269f,-9.127207f,26.520187f,-0.372492f,-9.127587f,26.520401f,-0.372504f,-9.127965f,26.520626f,-0.372349f,-9.128209f,26.520796f,-0.372075f,-9.128252f,26.520855f,-0.37167f,-9.128117f,26.520819f,-0.371283f,-9.127842f,26.520685f,-0.370991f,-9.127497f,26.5205f,-0.370886f,-14.512934f,13.969061f,5.275278f,-14.198647f,14.12174f,5.451408f,-14.638186f,13.807268f,5.078872f,-14.632923f,13.585418f,4.811635f,-14.435675f,13.383401f,4.593375f,-14.125884f,13.258284f,4.451334f,-13.797807f,13.273177f,4.469407f,-13.550318f,13.346471f,4.554274f,-13.368752f,13.558074f,4.812119f,-13.327599f,13.817791f,5.131596f,-13.52787f,13.988637f,5.314483f,-13.802702f,14.114639f,5.457172f,-14.394952f,13.808276f,5.288633f,-14.150331f,13.927123f,5.425711f,-14.492436f,13.682355f,5.135759f,-14.488344f,13.509686f,4.927764f,-14.334826f,13.352443f,4.757892f,-14.093707f,13.255064f,4.647331f,-13.838357f,13.266657f,4.661406f,-13.645722f,13.323714f,4.727456f,-13.504408f,13.488404f,4.928132f,-13.472378f,13.690548f,5.176801f,-13.62826f,13.823519f,5.319149f,-13.842166f,13.921591f,5.430202f,-14.23001f,13.634308f,5.263386f,-14.083001f,13.705723f,5.345767f,-14.288588f,13.55863f,5.171511f,-14.286124f,13.454861f,5.04651f,-14.19387f,13.360363f,4.944427f,-14.048972f,13.301847f,4.877987f,-13.895513f,13.308814f,4.886437f,-13.779745f,13.343099f,4.926138f,-13.694821f,13.44207f,5.046735f,-13.67557f,13.563551f,5.196175f,-13.769258f,13.643468f,5.281722f,-13.8978f,13.702415f,5.348457f,-14.071369f,13.527401f,5.186867f,-14.018492f,13.553091f,5.216492f,-14.092436f,13.500175f,5.153817f,-14.091552f,13.462847f,5.108849f,-14.058366f,13.428854f,5.072132f,-14.006251f,13.407808f,5.048228f,-13.951047f,13.410314f,5.051273f,-13.9094f,13.422644f,5.065551f,-13.878857f,13.458249f,5.108933f,-13.871925f,13.50195f,5.162687f,-13.905628f,13.530701f,5.193459f,-13.951869f,13.551904f,5.217467f,-13.982257f,13.46954f,5.141988f);
    }
    private static void method31(){
        MESH_8.getTexCoords().ensureCapacity(2);
        MESH_8.getTexCoords().addAll(0.0f,0.0f);
    }
    private static void method32(){
        MESH_8.getFaces().ensureCapacity(2664);
        MESH_8.getFaces().addAll(0,0,1,0,2,0,0,0,2,0,3,0,2,0,4,0,5,0,2,0,5,0,3,0,5,0,6,0,7,0,5,0,7,0,3,0,7,0,8,0,0,0,7,0,0,0,3,0,2,0,1,0,9,0,2,0,9,0,10,0,9,0,11,0,12,0,9,0,12,0,10,0,12,0,13,0,14,0,12,0,14,0,10,0,14,0,4,0,2,0,14,0,2,0,10,0,12,0,11,0,15,0,12,0,15,0,16,0,15,0,17,0,18,0,15,0,18,0,16,0,18,0,19,0,20,0,18,0,20,0,16,0,20,0,13,0,12,0,20,0,12,0,16,0,18,0,17,0,21,0,18,0,21,0,22,0,21,0,23,0,24,0,21,0,24,0,22,0,24,0,25,0,26,0,24,0,26,0,22,0,26,0,19,0,18,0,26,0,18,0,22,0,27,0,28,0,29,0,27,0,29,0,30,0,29,0,31,0,32,0,29,0,32,0,30,0,32,0,25,0,24,0,32,0,24,0,30,0,24,0,23,0,27,0,24,0,27,0,30,0,33,0,8,0,7,0,33,0,7,0,34,0,7,0,6,0,35,0,7,0,35,0,34,0,35,0,31,0,29,0,35,0,29,0,34,0,29,0,28,0,33,0,29,0,33,0,34,0,36,0,37,0,38,0,36,0,38,0,39,0,38,0,40,0,41,0,38,0,41,0,39,0,42,0,37,0,36,0,42,0,36,0,43,0,44,0,45,0,42,0,44,0,42,0,43,0,46,0,45,0,44,0,46,0,44,0,47,0,48,0,49,0,46,0,48,0,46,0,47,0,50,0,49,0,48,0,50,0,48,0,51,0,52,0,53,0,50,0,52,0,50,0,51,0,54,0,55,0,56,0,54,0,56,0,57,0,56,0,53,0,52,0,56,0,52,0,57,0,41,0,40,0,58,0,41,0,58,0,59,0,58,0,55,0,54,0,58,0,54,0,59,0,5,0,4,0,60,0,5,0,60,0,61,0,60,0,62,0,63,0,60,0,63,0,61,0,63,0,64,0,65,0,63,0,65,0,61,0,65,0,6,0,5,0,65,0,5,0,61,0,66,0,64,0,63,0,66,0,63,0,67,0,63,0,62,0,68,0,63,0,68,0,67,0,36,0,39,0,67,0,36,0,67,0,68,0,39,0,41,0,66,0,39,0,66,0,67,0,69,0,70,0,71,0,69,0,71,0,72,0,71,0,62,0,60,0,71,0,60,0,72,0,60,0,4,0,14,0,60,0,14,0,72,0,14,0,13,0,69,0,14,0,69,0,72,0,44,0,43,0,73,0,44,0,73,0,74,0,43,0,36,0,68,0,43,0,68,0,73,0,68,0,62,0,71,0,68,0,71,0,73,0,71,0,70,0,74,0,71,0,74,0,73,0,69,0,13,0,20,0,69,0,20,0,75,0,20,0,19,0,76,0,20,0,76,0,75,0,76,0,77,0,78,0,76,0,78,0,75,0,78,0,70,0,69,0,78,0,69,0,75,0,78,0,77,0,79,0,78,0,79,0,80,0,48,0,47,0,80,0,48,0,80,0,79,0,47,0,44,0,74,0,47,0,74,0,80,0,74,0,70,0,78,0,74,0,78,0,80,0,76,0,19,0,26,0,76,0,26,0,81,0,26,0,25,0,82,0,26,0,82,0,81,0,82,0,83,0,84,0,82,0,84,0,81,0,84,0,77,0,76,0,84,0,76,0,81,0,79,0,77,0,84,0,79,0,84,0,85,0,84,0,83,0,86,0,84,0,86,0,85,0,52,0,51,0,85,0,52,0,85,0,86,0,51,0,48,0,79,0,51,0,79,0,85,0,87,0,83,0,82,0,87,0,82,0,88,0,82,0,25,0,32,0,82,0,32,0,88,0,32,0,31,0,89,0,32,0,89,0,88,0,89,0,90,0,87,0,89,0,87,0,88,0,87,0,90,0,91,0,87,0,91,0,92,0,54,0,57,0,92,0,54,0,92,0,91,0,57,0,52,0,86,0,57,0,86,0,92,0,86,0,83,0,87,0,86,0,87,0,92,0,35,0,6,0,65,0,35,0,65,0,93,0,65,0,64,0,94,0,65,0,94,0,93,0,94,0,90,0,89,0,94,0,89,0,93,0,89,0,31,0,35,0,89,0,35,0,93,0,94,0,64,0,66,0,94,0,66,0,95,0,41,0,59,0,95,0,41,0,95,0,66,0,59,0,54,0,91,0,59,0,91,0,95,0,91,0,90,0,94,0,91,0,94,0,95,0,38,0,37,0,96,0,38,0,96,0,97,0,98,0,96,0,37,0,98,0,37,0,42,0,42,0,45,0,99,0,42,0,99,0,98,0,100,0,99,0,45,0,100,0,45,0,46,0,46,0,49,0,101,0,46,0,101,0,100,0,102,0,101,0,49,0,102,0,49,0,50,0,50,0,53,0,103,0,50,0,103,0,102,0,104,0,103,0,53,0,104,0,53,0,56,0,56,0,55,0,105,0,56,0,105,0,104,0,106,0,105,0,55,0,106,0,55,0,58,0,58,0,40,0,107,0,58,0,107,0,106,0,97,0,107,0,40,0,97,0,40,0,38,0,96,0,98,0,108,0,96,0,108,0,109,0,98,0,99,0,110,0,98,0,110,0,108,0,99,0,100,0,111,0,99,0,111,0,110,0,100,0,101,0,112,0,100,0,112,0,111,0,101,0,102,0,113,0,101,0,113,0,112,0,102,0,103,0,114,0,102,0,114,0,113,0,103,0,104,0,115,0,103,0,115,0,114,0,104,0,105,0,116,0,104,0,116,0,115,0,105,0,106,0,117,0,105,0,117,0,116,0,106,0,107,0,118,0,106,0,118,0,117,0,107,0,97,0,119,0,107,0,119,0,118,0,97,0,96,0,109,0,97,0,109,0,119,0,108,0,110,0,120,0,108,0,120,0,121,0,110,0,111,0,122,0,110,0,122,0,120,0,111,0,112,0,123,0,111,0,123,0,122,0,112,0,113,0,124,0,112,0,124,0,123,0,113,0,114,0,125,0,113,0,125,0,124,0,114,0,115,0,126,0,114,0,126,0,125,0,115,0,116,0,127,0,115,0,127,0,126,0,116,0,117,0,128,0,116,0,128,0,127,0,117,0,118,0,129,0,117,0,129,0,128,0,118,0,119,0,130,0,118,0,130,0,129,0,119,0,109,0,131,0,119,0,131,0,130,0,109,0,108,0,121,0,109,0,121,0,131,0,121,0,120,0,132,0,121,0,132,0,133,0,120,0,122,0,134,0,120,0,134,0,132,0,122,0,123,0,135,0,122,0,135,0,134,0,123,0,124,0,136,0,123,0,136,0,135,0,124,0,125,0,137,0,124,0,137,0,136,0,125,0,126,0,138,0,125,0,138,0,137,0,126,0,127,0,139,0,126,0,139,0,138,0,127,0,128,0,140,0,127,0,140,0,139,0,128,0,129,0,141,0,128,0,141,0,140,0,129,0,130,0,142,0,129,0,142,0,141,0,130,0,131,0,143,0,130,0,143,0,142,0,131,0,121,0,133,0,131,0,133,0,143,0,133,0,132,0,144,0,133,0,144,0,145,0,132,0,134,0,146,0,132,0,146,0,144,0,134,0,135,0,147,0,134,0,147,0,146,0,135,0,136,0,148,0,135,0,148,0,147,0,136,0,137,0,149,0,136,0,149,0,148,0,137,0,138,0,150,0,137,0,150,0,149,0,138,0,139,0,151,0,138,0,151,0,150,0,139,0,140,0,152,0,139,0,152,0,151,0,140,0,141,0,153,0,140,0,153,0,152,0,141,0,142,0,154,0,141,0,154,0,153,0,142,0,143,0,155,0,142,0,155,0,154,0,143,0,133,0,145,0,143,0,145,0,155,0,145,0,144,0,156,0,145,0,156,0,157,0,144,0,146,0,158,0,144,0,158,0,156,0,146,0,147,0,159,0,146,0,159,0,158,0,147,0,148,0,160,0,147,0,160,0,159,0,148,0,149,0,161,0,148,0,161,0,160,0,149,0,150,0,162,0,149,0,162,0,161,0,150,0,151,0,163,0,150,0,163,0,162,0,151,0,152,0,164,0,151,0,164,0,163,0,152,0,153,0,165,0,152,0,165,0,164,0,153,0,154,0,166,0,153,0,166,0,165,0,154,0,155,0,167,0,154,0,167,0,166,0,155,0,145,0,157,0,155,0,157,0,167,0,157,0,156,0,168,0,157,0,168,0,169,0,156,0,158,0,170,0,156,0,170,0,168,0,158,0,159,0,171,0,158,0,171,0,170,0,159,0,160,0,172,0,159,0,172,0,171,0,160,0,161,0,173,0,160,0,173,0,172,0,161,0,162,0,174,0,161,0,174,0,173,0,162,0,163,0,175,0,162,0,175,0,174,0,163,0,164,0,176,0,163,0,176,0,175,0,164,0,165,0,177,0,164,0,177,0,176,0,165,0,166,0,178,0,165,0,178,0,177,0,166,0,167,0,179,0,166,0,179,0,178,0,167,0,157,0,169,0,167,0,169,0,179,0,0,0,8,0,180,0,0,0,180,0,181,0,8,0,33,0,182,0,8,0,182,0,180,0,33,0,28,0,183,0,33,0,183,0,182,0,28,0,27,0,184,0,28,0,184,0,183,0,27,0,23,0,185,0,27,0,185,0,184,0,23,0,21,0,186,0,23,0,186,0,185,0,21,0,17,0,187,0,21,0,187,0,186,0,17,0,15,0,188,0,17,0,188,0,187,0,15,0,11,0,189,0,15,0,189,0,188,0,11,0,9,0,190,0,11,0,190,0,189,0,9,0,1,0,191,0,9,0,191,0,190,0,1,0,0,0,181,0,1,0,181,0,191,0,181,0,180,0,192,0,181,0,192,0,193,0,180,0,182,0,194,0,180,0,194,0,192,0,182,0,183,0,195,0,182,0,195,0,194,0,183,0,184,0,196,0,183,0,196,0,195,0,184,0,185,0,197,0,184,0,197,0,196,0,185,0,186,0,198,0,185,0,198,0,197,0,186,0,187,0,199,0,186,0,199,0,198,0,187,0,188,0,200,0,187,0,200,0,199,0,188,0,189,0,201,0,188,0,201,0,200,0,189,0,190,0,202,0,189,0,202,0,201,0,190,0,191,0,203,0,190,0,203,0,202,0,191,0,181,0,193,0,191,0,193,0,203,0,193,0,192,0,204,0,193,0,204,0,205,0,192,0,194,0,206,0,192,0,206,0,204,0,194,0,195,0,207,0,194,0,207,0,206,0,195,0,196,0,208,0,195,0,208,0,207,0,196,0,197,0,209,0,196,0,209,0,208,0,197,0,198,0,210,0,197,0,210,0,209,0,198,0,199,0,211,0,198,0,211,0,210,0,199,0,200,0,212,0,199,0,212,0,211,0,200,0,201,0,213,0,200,0,213,0,212,0,201,0,202,0,214,0,201,0,214,0,213,0,202,0,203,0,215,0,202,0,215,0,214,0,203,0,193,0,205,0,203,0,205,0,215,0,205,0,204,0,216,0,205,0,216,0,217,0,204,0,206,0,218,0,204,0,218,0,216,0,206,0,207,0,219,0,206,0,219,0,218,0,207,0,208,0,220,0,207,0,220,0,219,0,208,0,209,0,221,0,208,0,221,0,220,0,209,0,210,0,222,0,209,0,222,0,221,0,210,0,211,0,223,0,210,0,223,0,222,0,211,0,212,0,224,0,211,0,224,0,223,0,212,0,213,0,225,0,212,0,225,0,224,0,213,0,214,0,226,0,213,0,226,0,225,0,214,0,215,0,227,0,214,0,227,0,226,0,215,0,205,0,217,0,215,0,217,0,227,0,217,0,216,0,228,0,216,0,218,0,228,0,218,0,219,0,228,0,219,0,220,0,228,0,220,0,221,0,228,0,221,0,222,0,228,0,222,0,223,0,228,0,223,0,224,0,228,0,224,0,225,0,228,0,225,0,226,0,228,0,226,0,227,0,228,0,227,0,217,0,228,0);
    }
    private static void method33(){
        MESH_8.getFaceSmoothingGroups().ensureCapacity(444);
        MESH_8.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_10 = MESHVIEWS[9];
        MESHVIEWS[9].setId("duke_model_C_body_geo duke_model");
        MESHVIEWS[9].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_9 = new PhongMaterial();
        MATERIAL_9.setDiffuseColor(new Color(1.0,1.0,1.0,1.0));
        MATERIAL_9.setSpecularColor(new Color(0.30000001192092896,0.30000001192092896,0.30000001192092896,1.0));
        MATERIAL_9.setSpecularPower(18.0);
//        try {
//            MATERIAL_9.setDiffuseMap(new Image(animation_w0260_dukeModelOnlyWithHatsFromOBJ.class.getResource("duke.png").toExternalForm()));
//        } catch (NullPointerException npe) {
//            System.err.println("Could not load texture resource [file:/C:/Users/akouznet/Downloads/duke.png]");
//        }
        MESHVIEWS[9].setMaterial(MATERIAL_9);
        MESH_9 = new TriangleMesh();
        MESHVIEWS[9].setMesh(MESH_9);
        MESH_9.getPoints().ensureCapacity(1218);
        MESH_9.getPoints().addAll(-1.628112f,4.164378f,-0.024577f,-2.018989f,4.942907f,3.873342f,-2.493252f,4.658029f,3.763582f,-2.172938f,3.997996f,-0.019559f,-1.071197f,4.225419f,-0.01835f,-1.534096f,5.117754f,3.928331f,-0.516562f,4.266075f,-0.021509f,-0.828311f,5.234589f,4.051122f,0.0f,4.267379f,-0.023166f,-0.0f,5.28787f,4.096457f,-3.007383f,4.247312f,3.57667f,-2.582207f,3.782792f,-0.017608f,-3.760648f,6.599398f,6.698839f,-4.572696f,5.980083f,6.421286f,-2.929501f,7.124539f,6.910573f,-1.768443f,7.664931f,7.277528f,-0.0f,7.956361f,7.501918f,-5.377826f,5.168409f,6.116439f,-7.379607f,8.538465f,8.117033f,-8.111305f,6.966508f,7.52307f,-5.991323f,9.986269f,8.612513f,-3.410969f,10.76228f,9.112534f,-0.0f,11.078089f,9.37482f,-8.535336f,5.632864f,6.876461f,-10.804709f,9.975031f,6.630442f,-11.179598f,7.6646f,6.271002f,-9.991465f,13.975878f,6.903179f,-5.178312f,13.975878f,8.956665f,-0.0f,13.975878f,9.63216f,-11.247897f,5.900383f,5.602089f,-13.513108f,10.781528f,3.636511f,-13.623084f,8.096781f,3.417039f,-13.013666f,13.975879f,3.667012f,-13.348441f,6.042044f,3.033324f,-14.582585f,11.007886f,-0.145222f,-14.518975f,8.247715f,-0.088039f,-14.130058f,13.975878f,-0.195122f,-14.181593f,6.117208f,-0.024098f,-13.522253f,10.877657f,-3.841413f,-13.556228f,8.004675f,-3.469829f,-13.013666f,13.975879f,-4.056481f,-13.369616f,6.026838f,-3.03366f,-10.856113f,9.937916f,-6.882669f,-11.102138f,7.516631f,-6.184947f,-9.991465f,13.97588f,-7.420423f,-11.245812f,5.870711f,-5.502692f,-7.139445f,8.398675f,-8.207531f,-7.877504f,6.870759f,-7.359677f,-5.664347f,9.7912f,-9.133938f,-5.136829f,13.964672f,-9.624153f,-2.853124f,10.36042f,-9.50687f,0.0f,13.975879f,-10.435618f,0.0f,10.496817f,-9.854702f,-8.311455f,5.574765f,-6.637329f,-3.584146f,6.609049f,-6.984475f,-4.680812f,6.099086f,-6.587937f,-2.612667f,6.996575f,-7.239134f,-1.321616f,7.169203f,-7.554626f,0.0f,7.271255f,-7.756039f,-5.419877f,5.293289f,-6.017237f,-1.860425f,5.10615f,-3.627067f,-2.522808f,4.790426f,-3.499375f,-1.227948f,5.186575f,-3.710674f,-0.626337f,5.226047f,-3.733434f,0.0f,5.245757f,-3.746626f,-3.130812f,4.31886f,-3.175679f,-3.613801f,3.796648f,3.439221f,-3.093173f,3.464926f,-0.00465f,-5.894441f,4.369013f,5.781394f,-8.649549f,4.564885f,6.318233f,-11.095512f,4.564885f,5.050339f,-13.02508f,4.564886f,2.761696f,-13.749427f,4.564887f,0.010864f,-13.064539f,4.564887f,-2.736017f,-11.115627f,4.564888f,-4.946893f,-8.480307f,4.564888f,-6.021614f,-5.833358f,4.506552f,-5.586577f,-3.671637f,3.781376f,-2.852032f,-6.173932f,0.913642f,1.917572f,-6.860009f,0.30574f,1.421604f,-6.418896f,0.238205f,0.077524f,-5.567446f,0.846322f,0.077823f,-7.497485f,0.942373f,3.144127f,-7.793294f,0.308045f,2.229826f,-8.833736f,0.961305f,3.36773f,-8.865375f,0.308045f,2.455462f,-10.367541f,0.961305f,2.729098f,-9.966031f,0.308045f,2.039791f,-11.421041f,0.961306f,1.668231f,-10.634125f,0.308046f,1.210797f,-11.86235f,0.961307f,0.087159f,-10.866642f,0.308046f,0.117399f,-11.441079f,0.961308f,-1.48208f,-10.557436f,0.308047f,-0.99587f,-10.390433f,0.961308f,-2.619106f,-9.910273f,0.308047f,-1.728359f,-8.866447f,0.961308f,-3.042313f,-8.821115f,0.308047f,-1.996675f,-7.581069f,0.961308f,-2.882186f,-7.968712f,0.308047f,-1.816038f,-6.147985f,0.910029f,-1.514917f,-6.919909f,0.306496f,-1.075331f,-8.883642f,1.74819f,4.361621f,-7.084824f,1.756497f,4.123075f,-10.671911f,1.748191f,3.457148f,-11.997192f,1.748191f,2.018806f,-12.580175f,1.748192f,0.058566f,-12.080249f,1.748193f,-1.892173f,-10.712187f,1.748194f,-3.375173f,-8.842921f,1.748194f,-4.023289f,-7.133464f,1.74755f,-3.873537f,-5.524142f,1.588572f,-1.825865f,-4.981051f,1.475376f,0.060289f,-5.456656f,1.592795f,2.388485f,-7.523867f,0.010241f,0.962647f,-7.222685f,-0.002755f,0.134365f,-8.178144f,0.01024f,1.319758f,-8.846548f,0.004224f,1.407363f,-9.309073f,0.010241f,1.190113f,-9.712889f,0.010241f,0.719692f,-9.877069f,0.010241f,0.138102f,-9.698915f,0.010241f,-0.503333f,-9.309073f,0.010242f,-0.920056f,-8.75908f,0.010242f,-1.105459f,-8.189791f,0.010242f,-1.043384f,-7.515884f,-1.58E-4f,-0.647545f,-8.562192f,-0.001169f,0.148926f,-6.230072f,3.713394f,-5.167017f,-8.594647f,3.752717f,-5.514761f,-4.147243f,3.174722f,-2.641176f,-3.610885f,2.93291f,0.004464f,-4.054913f,3.224677f,3.180876f,-6.268159f,3.636044f,5.468157f,-8.752368f,3.752713f,5.824991f,-11.017075f,3.752713f,4.638721f,-12.777573f,3.752714f,2.566605f,-13.471678f,3.752715f,0.020138f,-12.799612f,3.752716f,-2.507513f,-11.029964f,3.752717f,-4.548654f,-6.737925f,2.705036f,-4.547523f,-8.73807f,2.717931f,-4.78371f,-4.824572f,2.38246f,-2.244647f,-4.332394f,2.190832f,0.043227f,-4.804232f,2.398582f,2.815067f,-6.702075f,2.70682f,4.915085f,-8.858919f,2.717927f,5.110661f,-10.876069f,2.717927f,4.052261f,-12.407895f,2.717928f,2.291623f,-13.052989f,2.717929f,0.036228f,-12.432177f,2.71793f,-2.191841f,-10.890397f,2.717931f,-3.973868f,0.0f,18.740412f,-9.800287f,-4.953994f,18.740412f,-8.925467f,-9.182492f,18.740414f,-6.711084f,-8.269455f,23.174034f,-5.984834f,-4.461407f,23.174034f,-7.942548f,-11.959996f,18.740412f,-3.60177f,-12.986001f,18.740414f,-0.045763f,-11.694774f,23.174036f,0.010301f,-10.770786f,23.174034f,-3.195237f,-11.959996f,18.740414f,3.510473f,-9.182492f,18.740414f,6.519069f,-8.269455f,23.174036f,5.943022f,-10.770786f,23.174036f,3.215839f,-4.953994f,18.740414f,8.434689f,-0.0f,18.740412f,9.134629f,-0.0f,23.174034f,8.359555f,-4.461407f,23.174034f,7.713495f,-2.263149f,37.335625f,-3.924251f,0.0f,37.335625f,-4.16661f,0.0f,33.21384f,-5.6227f,-2.968919f,33.21384f,-5.17805f,-5.50305f,33.21384f,-3.974333f,-4.101953f,37.335625f,-2.94581f,-5.463727f,37.335625f,-1.624618f,-7.167606f,33.21384f,-2.141787f,-7.782489f,33.21384f,0.005174f,-5.801038f,37.335625f,0.001471f,-5.463726f,37.33563f,1.627559f,-7.167605f,33.21384f,2.152134f,-5.503049f,33.21384f,3.98468f,-4.101953f,37.335625f,2.948751f,-2.263149f,37.33563f,3.927192f,-2.968919f,33.21384f,5.188397f,-0.0f,33.21384f,5.633048f,-0.0f,37.335625f,4.169551f,-9.165555f,28.29999f,2.765027f,-7.03701f,28.29999f,5.121488f,-9.951836f,28.29999f,0.001837f,-9.165556f,28.29999f,-2.761353f,-7.03701f,28.29999f,-5.13231f,-3.796497f,28.29999f,-6.718801f,0.0f,28.29999f,-7.31593f,-3.796497f,28.29999f,6.66449f,-0.0f,28.29999f,7.232626f,-2.54028f,41.333614f,-1.823581f,-1.401535f,41.333614f,-2.429515f,0.0f,41.333614f,-2.579605f,-3.5925f,41.333614f,0.001627f,-3.383606f,41.333614f,-1.005386f,-2.54028f,41.333614f,1.826835f,-3.383605f,41.333614f,1.00864f,-0.0f,41.333614f,2.582859f,-1.401535f,41.333614f,2.43277f,-0.467883f,46.026814f,-0.334551f,-0.258143f,46.026814f,-0.446155f,0.0f,46.026814f,-0.473799f,-0.661687f,46.026814f,0.001626f,-0.623213f,46.026814f,-0.183851f,-0.467883f,46.026814f,0.337804f,-0.623213f,46.026814f,0.187103f,-0.0f,46.026814f,0.477051f,-0.258143f,46.026814f,0.449409f,-0.0f,46.947384f,0.001625f,0.0f,23.174036f,-8.713435f,1.628112f,4.164378f,-0.024577f,2.172938f,3.997996f,-0.019559f,2.493252f,4.658029f,3.763582f,2.018989f,4.942907f,3.873342f,1.071197f,4.225419f,-0.01835f,1.534096f,5.117754f,3.928331f,0.516562f,4.266075f,-0.021509f,0.828311f,5.234589f,4.051122f,2.582207f,3.782792f,-0.017608f,3.007383f,4.247312f,3.57667f,4.572696f,5.980083f,6.421286f,3.760648f,6.599398f,6.698839f,2.929501f,7.124539f,6.910573f,1.768443f,7.664931f,7.277528f,5.377826f,5.168409f,6.116439f,8.111305f,6.966508f,7.52307f,7.379607f,8.538465f,8.117033f,5.991323f,9.986269f,8.612513f,3.410969f,10.76228f,9.112534f,8.535336f,5.632864f,6.876461f,11.179598f,7.6646f,6.271002f,10.804709f,9.975031f,6.630442f,9.991465f,13.975878f,6.903179f,5.178312f,13.975878f,8.956665f,11.247897f,5.900383f,5.602089f,13.623084f,8.096781f,3.417039f,13.513108f,10.781528f,3.636511f,13.013666f,13.975879f,3.667012f,13.348441f,6.042044f,3.033324f,14.518975f,8.247715f,-0.088039f,14.582585f,11.007886f,-0.145222f,14.130058f,13.975878f,-0.195122f,14.181593f,6.117208f,-0.024098f,13.556228f,8.004675f,-3.469829f,13.522253f,10.877657f,-3.841413f,13.013666f,13.975879f,-4.056481f,13.369616f,6.026838f,-3.03366f,11.102138f,7.516631f,-6.184947f,10.856113f,9.937916f,-6.882669f,9.991465f,13.97588f,-7.420423f,11.245812f,5.870711f,-5.502692f,7.877504f,6.870759f,-7.359677f,7.139445f,8.398675f,-8.207531f,5.664347f,9.7912f,-9.133938f,5.136829f,13.964672f,-9.624153f,2.853124f,10.36042f,-9.50687f,8.311455f,5.574765f,-6.637329f,4.680812f,6.099086f,-6.587937f,3.584146f,6.609049f,-6.984475f,2.612667f,6.996575f,-7.239134f,1.321616f,7.169203f,-7.554626f,5.419877f,5.293289f,-6.017237f,2.522808f,4.790426f,-3.499375f,1.860425f,5.10615f,-3.627067f,1.227948f,5.186575f,-3.710674f,0.626337f,5.226047f,-3.733434f,3.130812f,4.31886f,-3.175679f,3.093173f,3.464926f,-0.00465f,3.613801f,3.796648f,3.439221f,5.894441f,4.369013f,5.781394f,8.649549f,4.564885f,6.318233f,11.095512f,4.564885f,5.050339f,13.02508f,4.564886f,2.761696f,13.749427f,4.564887f,0.010864f,13.064539f,4.564887f,-2.736017f,11.115627f,4.564888f,-4.946893f,8.480307f,4.564888f,-6.021614f,5.833358f,4.506552f,-5.586577f,3.671637f,3.781376f,-2.852032f,6.173932f,0.913637f,1.917572f,5.567446f,0.846317f,0.077823f,6.418896f,0.238199f,0.077524f,6.860009f,0.305734f,1.421604f,7.497485f,0.942368f,3.144127f,7.793294f,0.308039f,2.229826f,8.833736f,0.9613f,3.36773f,8.865375f,0.308039f,2.455462f,10.367541f,0.961301f,2.729098f,9.966031f,0.308039f,2.039791f,11.421041f,0.961301f,1.668232f,10.634124f,0.308039f,1.210797f,11.86235f,0.961302f,0.087159f,10.866642f,0.30804f,0.117399f,11.441079f,0.961303f,-1.48208f,10.557436f,0.30804f,-0.99587f,10.390433f,0.961303f,-2.619106f,9.910273f,0.308041f,-1.728359f,8.866447f,0.961303f,-3.042313f,8.821115f,0.308041f,-1.996675f,7.581069f,0.961303f,-2.882186f,7.968712f,0.308041f,-1.816038f,6.147985f,0.910024f,-1.514917f,6.919909f,0.30649f,-1.075331f,8.883642f,1.748187f,4.361621f,7.084824f,1.756494f,4.123075f,10.671911f,1.748188f,3.457148f,11.997192f,1.748188f,2.018806f,12.580175f,1.748189f,0.058566f,12.080249f,1.74819f,-1.892173f,10.712187f,1.748191f,-3.375173f,8.842921f,1.748191f,-4.023289f,7.133464f,1.747546f,-3.873537f,5.524142f,1.588569f,-1.825865f,4.981051f,1.475372f,0.060289f,5.456656f,1.592792f,2.388485f,7.222685f,-0.002763f,0.134365f,7.523867f,0.010233f,0.962647f,8.178144f,0.010233f,1.319758f,8.846547f,0.004216f,1.407363f,9.309073f,0.010233f,1.190113f,9.712889f,0.010233f,0.719692f,9.877069f,0.010233f,0.138102f,9.698915f,0.010233f,-0.503333f,9.309073f,0.010234f,-0.920056f,8.75908f,0.010234f,-1.105459f,8.189791f,0.010234f,-1.043384f,7.515884f,-1.66E-4f,-0.647545f,8.562192f,-0.001177f,0.148926f,6.230072f,3.713394f,-5.167017f,8.594647f,3.752717f,-5.514761f,4.147243f,3.174722f,-2.641176f,3.610885f,2.93291f,0.004464f,4.054913f,3.224677f,3.180876f,6.268159f,3.636044f,5.468157f,8.752368f,3.752713f,5.824991f,11.017075f,3.752713f,4.638721f,12.777573f,3.752714f,2.566605f,13.471678f,3.752715f,0.020138f,12.799612f,3.752716f,-2.507513f,11.029964f,3.752717f,-4.548654f,6.737925f,2.705034f,-4.547523f,8.73807f,2.71793f,-4.78371f,4.824572f,2.382459f,-2.244647f,4.332394f,2.190831f,0.043227f,4.804232f,2.39858f,2.815067f,6.702075f,2.706818f,4.915085f,8.858919f,2.717925f,5.110661f,10.876069f,2.717926f,4.052261f,12.407895f,2.717926f,2.291623f,13.052989f,2.717927f,0.036228f,12.432178f,2.717928f,-2.191841f,10.890397f,2.717929f,-3.973868f,4.953994f,18.740412f,-8.925467f,9.182492f,18.740414f,-6.711084f,8.269455f,23.174034f,-5.984834f,4.461407f,23.174034f,-7.942548f,11.959996f,18.740412f,-3.60177f,12.986001f,18.740414f,-0.045763f,11.694774f,23.174036f,0.010301f,10.770786f,23.174034f,-3.195237f,11.959996f,18.740414f,3.510473f,9.182492f,18.740414f,6.519069f,8.269455f,23.174036f,5.943022f,10.770786f,23.174036f,3.215839f,4.953994f,18.740414f,8.434689f,4.461407f,23.174034f,7.713495f,2.263149f,37.335625f,-3.924251f,2.968919f,33.21384f,-5.17805f,5.50305f,33.21384f,-3.974333f,4.101953f,37.335625f,-2.94581f,5.463727f,37.335625f,-1.624618f,7.167606f,33.21384f,-2.141787f,7.782489f,33.21384f,0.005174f,5.801038f,37.335625f,0.001471f,5.463726f,37.33563f,1.627559f,7.167605f,33.21384f,2.152134f,5.503049f,33.21384f,3.98468f,4.101953f,37.335625f,2.948751f,2.263149f,37.33563f,3.927192f,2.968919f,33.21384f,5.188397f,9.165555f,28.29999f,2.765027f,7.03701f,28.29999f,5.121488f,9.951836f,28.29999f,0.001837f,9.165556f,28.29999f,-2.761353f,7.03701f,28.29999f,-5.13231f,3.796497f,28.29999f,-6.718801f,3.796497f,28.29999f,6.66449f,1.401535f,41.333614f,-2.429515f,2.54028f,41.333614f,-1.823581f,3.383606f,41.333614f,-1.005386f,3.5925f,41.333614f,0.001627f,3.383605f,41.333614f,1.00864f,2.54028f,41.333614f,1.826835f,1.401535f,41.333614f,2.43277f,0.258143f,46.026814f,-0.446155f,0.467883f,46.026814f,-0.334551f,0.623213f,46.026814f,-0.183851f,0.661687f,46.026814f,0.001626f,0.623213f,46.026814f,0.187103f,0.467883f,46.026814f,0.337804f,0.258143f,46.026814f,0.449409f);
    }
    private static void method34(){
        MESH_9.getTexCoords().ensureCapacity(708);
        MESH_9.getTexCoords().addAll(0.445277f,0.903091f,0.432139f,0.886837f,0.416199f,0.892785f,0.426965f,0.906564f,0.463996f,0.901816f,0.448437f,0.883187f,0.482638f,0.900968f,0.472159f,0.88074803f,0.5f,0.90094f,0.5f,0.879636f,0.398918f,0.901359f,0.413209f,0.911057f,0.3736f,0.852255f,0.346306f,0.865184f,0.401536f,0.841292f,0.44056f,0.83001f,0.5f,0.823926f,0.319244f,0.88213f,0.251962f,0.811773f,0.227369f,0.844591f,0.298624f,0.781547f,0.385353f,0.765347f,0.5f,0.758754f,0.213116f,0.872433f,0.13684f,0.78178203f,0.124239f,0.830017f,0.164174f,0.69825697f,0.32595f,0.69825697f,0.5f,0.69825697f,0.121944f,0.866848f,0.045807f,0.76494503f,0.042111f,0.820994f,0.062594f,0.698256f,0.051342f,0.863891f,0.009861f,0.760219f,0.011999f,0.817843f,0.025071f,0.69825697f,0.023338f,0.862322f,0.0455f,0.762938f,0.044358f,0.822917f,0.05063f,0.864208f,0.135112f,0.782557f,0.126843f,0.833106f,0.164174f,0.698256f,0.122014f,0.867468f,0.260034f,0.814692f,0.235227f,0.84659f,0.309614f,0.78562f,0.327345f,0.698491f,0.404103f,0.773736f,0.5f,0.698256f,0.5f,0.770889f,0.220641f,0.873646f,0.379532f,0.852053f,0.342672f,0.8627f,0.412185f,0.843963f,0.455579f,0.840359f,0.5f,0.838229f,0.317831f,0.879523f,0.437469f,0.883429f,0.415205f,0.89002097f,0.458727f,0.88175f,0.478948f,0.880926f,0.499995f,0.880515f,0.394769f,0.899866f,0.378536f,0.91076803f,0.396034f,0.917693f,0.30188f,0.898818f,0.209278f,0.894729f,0.127066f,0.894729f,0.06221f,0.894729f,0.037864f,0.894729f,0.060884f,0.894729f,0.12639f,0.894729f,0.214966f,0.894729f,0.303933f,0.895947f,0.376592f,0.911087f,0.292486f,0.970956f,0.269426f,0.983647f,0.284253f,0.985057f,0.312871f,0.972362f,0.248f,0.970356f,0.238057f,0.983599f,0.203087f,0.969961f,0.202023f,0.983599f,0.151534f,0.969961f,0.165029f,0.983599f,0.116124f,0.969961f,0.142573f,0.983599f,0.101291f,0.969961f,0.134758f,0.983599f,0.115451f,0.969961f,0.145151f,0.983599f,0.150764f,0.969961f,0.166903f,0.983599f,0.201987f,0.969961f,0.203511f,0.983599f,0.245191f,0.969961f,0.232161f,0.983599f,0.293358f,0.971032f,0.267413f,0.983632f,0.201409f,0.953533f,0.26187f,0.95336f,0.141303f,0.953533f,0.096759f,0.953533f,0.077164f,0.953533f,0.093967f,0.953533f,0.13995f,0.953533f,0.202778f,0.953533f,0.260235f,0.953547f,0.314327f,0.956866f,0.33258f,0.959229f,0.316595f,0.956778f,0.247113f,0.989817f,0.257236f,0.990088f,0.225122f,0.989817f,0.202656f,0.989942f,0.18711f,0.989817f,0.173537f,0.989817f,0.168019f,0.989817f,0.174007f,0.989817f,0.205596f,0.989817f,0.224731f,0.989817f,0.247382f,0.990034f,0.212214f,0.990055f,0.290599f,0.912506f,0.211123f,0.911685f,0.360606f,0.923752f,0.378633f,0.9288f,0.363709f,0.922709f,0.289319f,0.91412103f,0.205822f,0.911685f,0.129702f,0.911685f,0.070529f,0.911685f,0.0472f,0.911685f,0.069789f,0.911685f,0.129269f,0.911685f,0.27353f,0.933557f,0.206302f,0.933288f,0.33784f,0.940292f,0.354383f,0.944292f,0.338524f,0.939955f,0.274735f,0.93352f,0.20224f,0.933288f,0.134441f,0.933288f,0.082955f,0.933288f,0.061272f,0.933288f,0.082139f,0.933288f,0.13396f,0.933288f,0.5f,0.598788f,0.33349f,0.598788f,0.191365f,0.598788f,0.222053f,0.506227f,0.350046f,0.506227f,0.098009f,0.598788f,0.063524f,0.598788f,0.106924f,0.506227f,0.13798f,0.506227f,0.5f,0.506227f,0.423933f,0.210576f,0.5f,0.210576f,0.5f,0.29662699f,0.400211f,0.29662699f,0.315035f,0.29662699f,0.362128f,0.210576f,0.316357f,0.210576f,0.259088f,0.29662699f,0.238421f,0.29662699f,0.30502f,0.210576f,0.191934f,0.39921302f,0.263477f,0.39921302f,0.165506f,0.39921302f,0.372395f,0.39921302f,0.5f,0.39921302f,0.414618f,0.12711102f,0.452893f,0.12711102f,0.5f,0.12711102f,0.379251f,0.12711102f,0.386273f,0.12711102f,0.484274f,0.029130995f,0.491323f,0.029130995f,0.5f,0.029130995f,0.47776f,0.029130995f,0.479053f,0.029130995f,0.5f,0.009912014f,0.554723f,0.903091f,0.573035f,0.906564f,0.583801f,0.892785f,0.567861f,0.886837f,0.536004f,0.901816f,0.551563f,0.883187f,0.517362f,0.900968f,0.527841f,0.88074803f,0.586791f,0.911057f,0.601082f,0.901359f,0.653694f,0.865184f,0.6264f,0.852255f,0.598464f,0.841292f,0.55944f,0.83001f,0.680756f,0.88213f,0.772631f,0.844591f,0.748038f,0.811773f,0.701376f,0.781547f,0.614647f,0.765347f,0.786884f,0.872433f,0.875761f,0.830017f,0.86316f,0.78178203f,0.835826f,0.69825697f,0.67405f,0.69825697f,0.878056f,0.866848f,0.957889f,0.820994f,0.954193f,0.76494503f,0.937406f,0.698256f,0.948658f,0.863891f,0.988001f,0.817843f,0.990139f,0.760219f,0.974929f,0.69825697f,0.976661f,0.862322f,0.955642f,0.822917f,0.9545f,0.762938f,0.94937f,0.864208f,0.873157f,0.833106f,0.864888f,0.782557f,0.835826f,0.698256f,0.877986f,0.867468f,0.764773f,0.84659f,0.739966f,0.814692f,0.690386f,0.78562f,0.672655f,0.698491f,0.595897f,0.773736f,0.779359f,0.873646f,0.657328f,0.8627f,0.620468f,0.852053f,0.587815f,0.843963f,0.544421f,0.840359f,0.682169f,0.879523f,0.584795f,0.89002097f,0.562531f,0.883429f,0.541273f,0.88175f,0.521052f,0.880926f,0.500005f,0.880515f,0.605231f,0.899866f,0.603966f,0.917693f,0.621464f,0.91076803f,0.69812f,0.898818f,0.790722f,0.894729f,0.872934f,0.894729f,0.93779f,0.894729f,0.962136f,0.894729f,0.939116f,0.894729f,0.87361f,0.894729f,0.785034f,0.894729f,0.696067f,0.895947f,0.623408f,0.911087f,0.707514f,0.970956f,0.687129f,0.972362f,0.715747f,0.985057f,0.730574f,0.983647f,0.752f,0.970356f,0.761943f,0.983599f,0.796913f,0.969961f,0.797977f,0.983599f,0.848466f,0.969961f,0.834971f,0.983599f,0.883876f,0.969961f,0.857427f,0.983599f,0.898709f,0.969961f,0.865242f,0.983599f,0.884549f,0.969961f,0.854849f,0.983599f,0.849236f,0.969961f,0.833097f,0.983599f,0.798013f,0.969961f,0.796489f,0.983599f,0.754809f,0.969961f,0.767839f,0.983599f,0.706642f,0.971032f,0.732587f,0.983632f,0.798591f,0.953533f,0.73813f,0.95336f,0.858697f,0.953533f,0.903241f,0.953533f,0.922836f,0.953533f,0.906033f,0.953533f,0.86005f,0.953533f,0.797222f,0.953533f,0.739765f,0.953547f,0.685673f,0.956866f,0.66742f,0.959229f,0.683405f,0.956778f,0.742764f,0.990088f,0.752887f,0.989817f,0.774878f,0.989817f,0.797344f,0.989942f,0.81289f,0.989817f,0.826463f,0.989817f,0.831981f,0.989817f,0.825993f,0.989817f,0.794404f,0.989817f,0.775269f,0.989817f,0.752619f,0.990034f,0.787786f,0.990055f,0.709401f,0.912506f,0.788877f,0.911685f,0.639394f,0.923752f,0.621367f,0.9288f,0.636291f,0.922709f,0.710681f,0.91412103f,0.794178f,0.911685f,0.870298f,0.911685f,0.929471f,0.911685f,0.9528f,0.911685f,0.930211f,0.911685f,0.870731f,0.911685f,0.72647f,0.933557f,0.793698f,0.933288f,0.66216f,0.940292f,0.645617f,0.944292f,0.661476f,0.939955f,0.725265f,0.93352f,0.79776f,0.933288f,0.865559f,0.933288f,0.917045f,0.933288f,0.938728f,0.933288f,0.917861f,0.933288f,0.86604f,0.933288f,0.66651f,0.598788f,0.808635f,0.598788f,0.777947f,0.506227f,0.649954f,0.506227f,0.901991f,0.598788f,0.936476f,0.598788f,0.893076f,0.506227f,0.86202f,0.506227f,0.576067f,0.210576f,0.599789f,0.29662699f,0.684965f,0.29662699f,0.637872f,0.210576f,0.683643f,0.210576f,0.740912f,0.29662699f,0.76158f,0.29662699f,0.69498f,0.210576f,0.808066f,0.39921302f,0.736523f,0.39921302f,0.834494f,0.39921302f,0.627605f,0.39921302f,0.547107f,0.12711102f,0.585382f,0.12711102f,0.613727f,0.12711102f,0.620749f,0.12711102f,0.508677f,0.029130995f,0.515726f,0.029130995f,0.520947f,0.029130995f,0.52224f,0.029130995f);
    }
    private static void method35(){
        MESH_9.getFaces().ensureCapacity(4848);
        MESH_9.getFaces().addAll(0,0,1,1,2,2,0,0,2,2,3,3,4,4,5,5,1,1,4,4,1,1,0,0,6,6,7,7,5,5,6,6,5,5,4,4,8,8,9,9,7,7,8,8,7,7,6,6,3,3,2,2,10,10,3,3,10,10,11,11,1,1,12,12,13,13,1,1,13,13,2,2,5,5,14,14,12,12,5,5,12,12,1,1,7,7,15,15,14,14,7,7,14,14,5,5,9,9,16,16,15,15,9,9,15,15,7,7,2,2,13,13,17,17,2,2,17,17,10,10,12,12,18,18,19,19,12,12,19,19,13,13,14,14,20,20,18,18,14,14,18,18,12,12,15,15,21,21,20,20,15,15,20,20,14,14,16,16,22,22,21,21,16,16,21,21,15,15,13,13,19,19,23,23,13,13,23,23,17,17,18,18,24,24,25,25,18,18,25,25,19,19,20,20,26,26,24,24,20,20,24,24,18,18,21,21,27,27,26,26,21,21,26,26,20,20,22,22,28,28,27,27,22,22,27,27,21,21,19,19,25,25,29,29,19,19,29,29,23,23,24,24,30,30,31,31,24,24,31,31,25,25,26,26,32,32,30,30,26,26,30,30,24,24,25,25,31,31,33,33,25,25,33,33,29,29,30,30,34,34,35,35,30,30,35,35,31,31,32,32,36,36,34,34,32,32,34,34,30,30,31,31,35,35,37,37,31,31,37,37,33,33,34,34,38,38,39,39,34,34,39,39,35,35,36,36,40,32,38,38,36,36,38,38,34,34,35,35,39,39,41,40,35,35,41,40,37,37,38,38,42,41,43,42,38,38,43,42,39,39,40,32,44,43,42,41,40,32,42,41,38,38,39,39,43,42,45,44,39,39,45,44,41,40,42,41,46,45,47,46,42,41,47,46,43,42,44,43,48,47,46,45,44,43,46,45,42,41,49,48,50,49,48,47,49,48,48,47,44,43,51,50,52,51,50,49,51,50,50,49,49,48,43,42,47,46,53,52,43,42,53,52,45,44,46,45,54,53,55,54,46,45,55,54,47,46,48,47,56,55,54,53,48,47,54,53,46,45,50,49,57,56,56,55,50,49,56,55,48,47,52,51,58,57,57,56,52,51,57,56,50,49,47,46,55,54,59,58,47,46,59,58,53,52,54,53,60,59,61,60,54,53,61,60,55,54,56,55,62,61,60,59,56,55,60,59,54,53,57,56,63,62,62,61,57,56,62,61,56,55,58,57,64,63,63,62,58,57,63,62,57,56,55,54,61,60,65,64,55,54,65,64,59,58,60,59,0,0,3,3,60,59,3,3,61,60,62,61,4,4,0,0,62,61,0,0,60,59,63,62,6,6,4,4,63,62,4,4,62,61,64,63,8,8,6,6,64,63,6,6,63,62,61,60,3,3,11,11,61,60,11,11,65,64,10,10,66,65,67,66,10,10,67,66,11,11,17,17,68,67,66,65,17,17,66,65,10,10,23,23,69,68,68,67,23,23,68,67,17,17,29,29,70,69,69,68,29,29,69,68,23,23,33,33,71,70,70,69,33,33,70,69,29,29,37,37,72,71,71,70,37,37,71,70,33,33,41,40,73,72,72,71,41,40,72,71,37,37,45,44,74,73,73,72,45,44,73,72,41,40,53,52,75,74,74,73,53,52,74,73,45,44,59,58,76,75,75,74,59,58,75,74,53,52,65,64,77,76,76,75,65,64,76,75,59,58,11,11,67,66,77,76,11,11,77,76,65,64,78,77,79,78,80,79,78,77,80,79,81,80,82,81,83,82,79,78,82,81,79,78,78,77,84,83,85,84,83,82,84,83,83,82,82,81,86,85,87,86,85,84,86,85,85,84,84,83,88,87,89,88,87,86,88,87,87,86,86,85,90,89,91,90,89,88,90,89,89,88,88,87,92,91,93,92,91,90,92,91,91,90,90,89,94,93,95,94,93,92,94,93,93,92,92,91,96,95,97,96,95,94,96,95,95,94,94,93,98,97,99,98,97,96,98,97,97,96,96,95,100,99,101,100,99,98,100,99,99,98,98,97,81,80,80,79,101,100,81,80,101,100,100,99,102,101,84,83,82,81,102,101,82,81,103,102,104,103,86,85,84,83,104,103,84,83,102,101,105,104,88,87,86,85,105,104,86,85,104,103,106,105,90,89,88,87,106,105,88,87,105,104,107,106,92,91,90,89,107,106,90,89,106,105,108,107,94,93,92,91,108,107,92,91,107,106,109,108,96,95,94,93,109,108,94,93,108,107,110,109,98,97,96,95,110,109,96,95,109,108,111,110,100,99,98,97,111,110,98,97,110,109,112,111,81,80,100,99,112,111,100,99,111,110,113,112,78,77,81,80,113,112,81,80,112,111,103,102,82,81,78,77,103,102,78,77,113,112,79,78,114,113,115,114,79,78,115,114,80,79,83,82,116,115,114,113,83,82,114,113,79,78,85,84,117,116,116,115,85,84,116,115,83,82,87,86,118,117,117,116,87,86,117,116,85,84,89,88,119,118,118,117,89,88,118,117,87,86,91,90,120,119,119,118,91,90,119,118,89,88,93,92,121,120,120,119,93,92,120,119,91,90,95,94,122,117,121,120,95,94,121,120,93,92,97,96,123,121,122,117,97,96,122,117,95,94,99,98,124,122,123,121,99,98,123,121,97,96,101,100,125,123,124,122,101,100,124,122,99,98,80,79,115,114,125,123,80,79,125,123,101,100,114,113,126,124,115,114,116,115,126,124,114,113,117,116,126,124,116,115,118,117,126,124,117,116,119,118,126,124,118,117,120,119,126,124,119,118,121,120,126,124,120,119,122,117,126,124,121,120,123,121,126,124,122,117,124,122,126,124,123,121,125,123,126,124,124,122,115,114,126,124,125,123,127,125,128,126,75,74,127,125,75,74,76,75,129,127,127,125,76,75,129,127,76,75,77,76,130,128,129,127,77,76,130,128,77,76,67,66,131,129,130,128,67,66,131,129,67,66,66,65,132,130,131,129,66,65,132,130,66,65,68,67,133,131,132,130,68,67,133,131,68,67,69,68,134,132,133,131,69,68,134,132,69,68,70,69,135,133,134,132,70,69,135,133,70,69,71,70,136,134,135,133,71,70,136,134,71,70,72,71,137,135,136,134,72,71,137,135,72,71,73,72,138,136,137,135,73,72,138,136,73,72,74,73,138,136,74,73,75,74,138,136,75,74,128,126,139,137,140,138,128,126,139,137,128,126,127,125,141,139,139,137,127,125,141,139,127,125,129,127,142,140,141,139,129,127,142,140,129,127,130,128,143,141,142,140,130,128,143,141,130,128,131,129,144,142,143,141,131,129,144,142,131,129,132,130,145,143,144,142,132,130,145,143,132,130,133,131,146,144,145,143,133,131,146,144,133,131,134,132,147,145,146,144,134,132,147,145,134,132,135,133,148,146,147,145,135,133,148,146,135,133,136,134,149,147,148,146,136,134,149,147,136,134,137,135,150,148,149,147,137,135,150,148,137,135,138,136,140,138,150,148,138,136,140,138,138,136,128,126,146,144,104,103,102,101,146,144,102,101,145,143,147,145,105,104,104,103,147,145,104,103,146,144,148,146,106,105,105,104,148,146,105,104,147,145,149,147,107,106,106,105,149,147,106,105,148,146,150,148,108,107,107,106,150,148,107,106,149,147,140,138,109,108,108,107,140,138,108,107,150,148,139,137,110,109,109,108,139,137,109,108,140,138,141,139,111,110,110,109,141,139,110,109,139,137,142,140,112,111,111,110,142,140,111,110,141,139,143,141,113,112,112,111,143,141,112,111,142,140,144,142,103,102,113,112,144,142,113,112,143,141,145,143,102,101,103,102,145,143,103,102,144,142,151,149,51,50,49,48,151,149,49,48,152,150,49,48,44,43,153,151,49,48,153,151,152,150,154,152,155,153,152,150,154,152,152,150,153,151,153,151,44,43,40,32,153,151,40,32,156,154,40,32,36,36,157,155,40,32,157,155,156,154,158,156,159,157,156,154,158,156,156,154,157,155,157,155,36,36,32,32,157,155,32,32,160,154,32,32,26,26,161,151,32,32,161,151,160,154,162,152,163,157,160,154,162,152,160,154,161,151,161,151,26,26,27,27,161,151,27,27,164,150,27,27,28,28,165,149,27,27,165,149,164,150,166,158,167,153,164,150,166,158,164,150,165,149,168,159,169,160,170,161,168,159,170,161,171,162,172,163,173,164,168,159,172,163,168,159,171,162,174,165,173,164,172,163,174,165,172,163,175,166,176,167,177,168,174,165,176,167,174,165,175,166,178,165,177,168,176,167,178,165,176,167,179,166,180,163,181,164,178,165,180,163,178,165,179,166,182,159,181,164,180,163,182,159,180,163,183,162,184,161,185,160,182,159,184,161,182,159,183,162,186,169,187,170,180,163,186,169,180,163,179,166,176,167,188,171,186,169,176,167,186,169,179,166,189,169,188,171,176,167,189,169,176,167,175,166,172,163,190,170,189,169,172,163,189,169,175,166,191,172,190,170,172,163,191,172,172,163,171,162,170,161,192,173,191,172,170,161,191,172,171,162,193,172,194,173,184,161,193,172,184,161,183,162,180,163,187,170,193,172,180,163,193,172,183,162,168,159,173,164,195,174,168,159,195,174,196,175,169,160,168,159,196,175,169,160,196,175,197,176,174,165,177,168,198,177,174,165,198,177,199,178,173,164,174,165,199,178,173,164,199,178,195,174,178,165,181,164,200,174,178,165,200,174,201,178,177,168,178,165,201,178,177,168,201,178,198,177,182,159,185,160,202,176,182,159,202,176,203,175,181,164,182,159,203,175,181,164,203,175,200,174,196,175,195,174,204,179,196,175,204,179,205,180,197,176,196,175,205,180,197,176,205,180,206,181,199,178,198,177,207,182,199,178,207,182,208,183,195,174,199,178,208,183,195,174,208,183,204,179,201,178,200,174,209,179,201,178,209,179,210,183,198,177,201,178,210,183,198,177,210,183,207,182,203,175,202,176,211,181,203,175,211,181,212,180,200,174,203,175,212,180,200,174,212,180,209,179,205,180,204,179,213,184,206,181,205,180,213,184,208,183,207,182,213,184,204,179,208,183,213,184,210,183,209,179,213,184,207,182,210,183,213,184,212,180,211,181,213,184,209,179,212,180,213,184,186,169,163,157,162,152,186,169,162,152,187,170,188,171,158,156,163,157,188,171,163,157,186,169,189,169,159,157,158,156,189,169,158,156,188,171,190,170,154,152,159,157,190,170,159,157,189,169,191,172,155,153,154,152,191,172,154,152,190,170,192,173,214,158,155,153,192,173,155,153,191,172,193,172,167,153,166,158,193,172,166,158,194,173,187,170,162,152,167,153,187,170,167,153,193,172,162,152,161,151,164,150,162,152,164,150,167,153,158,156,157,155,160,154,158,156,160,154,163,157,154,152,153,151,156,154,154,152,156,154,159,157,214,158,151,149,152,150,214,158,152,150,155,153,215,185,216,186,217,187,215,185,217,187,218,188,219,189,215,185,218,188,219,189,218,188,220,190,221,191,219,189,220,190,221,191,220,190,222,192,8,8,221,191,222,192,8,8,222,192,9,9,216,186,223,193,224,194,216,186,224,194,217,187,218,188,217,187,225,195,218,188,225,195,226,196,220,190,218,188,226,196,220,190,226,196,227,197,222,192,220,190,227,197,222,192,227,197,228,198,9,9,222,192,228,198,9,9,228,198,16,16,217,187,224,194,229,199,217,187,229,199,225,195,226,196,225,195,230,200,226,196,230,200,231,201,227,197,226,196,231,201,227,197,231,201,232,202,228,198,227,197,232,202,228,198,232,202,233,203,16,16,228,198,233,203,16,16,233,203,22,22,225,195,229,199,234,204,225,195,234,204,230,200,231,201,230,200,235,205,231,201,235,205,236,206,232,202,231,201,236,206,232,202,236,206,237,207,233,203,232,202,237,207,233,203,237,207,238,208,22,22,233,203,238,208,22,22,238,208,28,28,230,200,234,204,239,209,230,200,239,209,235,205,236,206,235,205,240,210,236,206,240,210,241,211,237,207,236,206,241,211,237,207,241,211,242,212,235,205,239,209,243,213,235,205,243,213,240,210,241,211,240,210,244,214,241,211,244,214,245,215,242,212,241,211,245,215,242,212,245,215,246,216,240,210,243,213,247,217,240,210,247,217,244,214,245,215,244,214,248,218,245,215,248,218,249,219,246,216,245,215,249,219,246,216,249,219,250,212,244,214,247,217,251,220,244,214,251,220,248,218,249,219,248,218,252,221,249,219,252,221,253,222,250,212,249,219,253,222,250,212,253,222,254,223,248,218,251,220,255,224,248,218,255,224,252,221,253,222,252,221,256,225,253,222,256,225,257,226,254,223,253,222,257,226,254,223,257,226,258,227,259,228,254,223,258,227,259,228,258,227,260,229,51,50,259,228,260,229,51,50,260,229,52,51,252,221,255,224,261,230,252,221,261,230,256,225,257,226,256,225,262,231,257,226,262,231,263,232,258,227,257,226,263,232,258,227,263,232,264,233,260,229,258,227,264,233,260,229,264,233,265,234,52,51,260,229,265,234,52,51,265,234,58,57,256,225,261,230,266,235,256,225,266,235,262,231,263,232,262,231,267,236,263,232,267,236,268,237,264,233,263,232,268,237,264,233,268,237,269,238,265,234,264,233,269,238,265,234,269,238,270,239,58,57,265,234,270,239,58,57,270,239,64,240,262,231,266,235,271,241,262,231,271,241,267,236,268,237,267,236,216,186,268,237,216,186,215,185,269,238,268,237,215,185,269,238,215,185,219,189,270,239,269,238,219,189,270,239,219,189,221,191,64,240,270,239,221,191,64,240,221,191,8,8,267,236,271,241,223,193,267,236,223,193,216,186,224,194,223,193,272,242,224,194,272,242,273,243,229,199,224,194,273,243,229,199,273,243,274,244,234,204,229,199,274,244,234,204,274,244,275,245,239,209,234,204,275,245,239,209,275,245,276,246,243,213,239,209,276,246,243,213,276,246,277,247,247,217,243,213,277,247,247,217,277,247,278,248,251,220,247,217,278,248,251,220,278,248,279,249,255,224,251,220,279,249,255,224,279,249,280,250,261,230,255,224,280,250,261,230,280,250,281,251,266,235,261,230,281,251,266,235,281,251,282,252,271,241,266,235,282,252,271,241,282,252,283,253,223,193,271,241,283,253,223,193,283,253,272,242,284,254,285,255,286,256,284,254,286,256,287,257,288,258,284,254,287,257,288,258,287,257,289,259,290,260,288,258,289,259,290,260,289,259,291,261,292,262,290,260,291,261,292,262,291,261,293,263,294,264,292,262,293,263,294,264,293,263,295,265,296,266,294,264,295,265,296,266,295,265,297,267,298,268,296,266,297,267,298,268,297,267,299,269,300,270,298,268,299,269,300,270,299,269,301,271,302,272,300,270,301,271,302,272,301,271,303,273,304,274,302,272,303,273,304,274,303,273,305,275,306,276,304,274,305,275,306,276,305,275,307,277,285,255,306,276,307,277,285,255,307,277,286,256,308,278,309,279,288,258,308,278,288,258,290,260,310,280,308,278,290,260,310,280,290,260,292,262,311,281,310,280,292,262,311,281,292,262,294,264,312,282,311,281,294,264,312,282,294,264,296,266,313,283,312,282,296,266,313,283,296,266,298,268,314,284,313,283,298,268,314,284,298,268,300,270,315,285,314,284,300,270,315,285,300,270,302,272,316,286,315,285,302,272,316,286,302,272,304,274,317,287,316,286,304,274,317,287,304,274,306,276,318,288,317,287,306,276,318,288,306,276,285,255,319,289,318,288,285,255,319,289,285,255,284,254,309,279,319,289,284,254,309,279,284,254,288,258,287,257,286,256,320,290,287,257,320,290,321,291,289,259,287,257,321,291,289,259,321,291,322,292,291,261,289,259,322,292,291,261,322,292,323,293,293,263,291,261,323,293,293,263,323,293,324,294,295,265,293,263,324,294,295,265,324,294,325,295,297,267,295,265,325,295,297,267,325,295,326,296,299,269,297,267,326,296,299,269,326,296,327,297,301,271,299,269,327,297,301,271,327,297,328,294,303,273,301,271,328,294,303,273,328,294,329,298,305,275,303,273,329,298,305,275,329,298,330,299,307,277,305,275,330,299,307,277,330,299,331,300,286,256,307,277,331,300,286,256,331,300,320,290,321,291,320,290,332,301,322,292,321,291,332,301,323,293,322,292,332,301,324,294,323,293,332,301,325,295,324,294,332,301,326,296,325,295,332,301,327,297,326,296,332,301,328,294,327,297,332,301,329,298,328,294,332,301,330,299,329,298,332,301,331,300,330,299,332,301,320,290,331,300,332,301,333,302,282,252,281,251,333,302,281,251,334,303,335,304,283,253,282,252,335,304,282,252,333,302,336,305,272,242,283,253,336,305,283,253,335,304,337,306,273,243,272,242,337,306,272,242,336,305,338,307,274,244,273,243,338,307,273,243,337,306,339,308,275,245,274,244,339,308,274,244,338,307,340,309,276,246,275,245,340,309,275,245,339,308,341,310,277,247,276,246,341,310,276,246,340,309,342,311,278,248,277,247,342,311,277,247,341,310,343,312,279,249,278,248,343,312,278,248,342,311,344,313,280,250,279,249,344,313,279,249,343,312,344,313,334,303,281,251,344,313,281,251,280,250,345,314,333,302,334,303,345,314,334,303,346,315,347,316,335,304,333,302,347,316,333,302,345,314,348,317,336,305,335,304,348,317,335,304,347,316,349,318,337,306,336,305,349,318,336,305,348,317,350,319,338,307,337,306,350,319,337,306,349,318,351,320,339,308,338,307,351,320,338,307,350,319,352,321,340,309,339,308,352,321,339,308,351,320,353,322,341,310,340,309,353,322,340,309,352,321,354,323,342,311,341,310,354,323,341,310,353,322,355,324,343,312,342,311,355,324,342,311,354,323,356,325,344,313,343,312,356,325,343,312,355,324,346,315,334,303,344,313,346,315,344,313,356,325,352,321,351,320,308,278,352,321,308,278,310,280,353,322,352,321,310,280,353,322,310,280,311,281,354,323,353,322,311,281,354,323,311,281,312,282,355,324,354,323,312,282,355,324,312,282,313,283,356,325,355,324,313,283,356,325,313,283,314,284,346,315,356,325,314,284,346,315,314,284,315,285,345,314,346,315,315,285,345,314,315,285,316,286,347,316,345,314,316,286,347,316,316,286,317,287,348,317,347,316,317,287,348,317,317,287,318,288,349,318,348,317,318,288,349,318,318,288,319,289,350,319,349,318,319,289,350,319,319,289,309,279,351,320,350,319,309,279,351,320,309,279,308,278,151,149,357,326,259,228,151,149,259,228,51,50,259,228,357,326,358,327,259,228,358,327,254,223,359,328,358,327,357,326,359,328,357,326,360,329,358,327,361,330,250,212,358,327,250,212,254,223,250,212,361,330,362,331,250,212,362,331,246,216,363,332,362,331,361,330,363,332,361,330,364,333,362,331,365,330,242,212,362,331,242,212,246,216,242,212,365,330,366,327,242,212,366,327,237,207,367,328,366,327,365,330,367,328,365,330,368,333,366,327,369,326,238,208,366,327,238,208,237,207,238,208,369,326,165,149,238,208,165,149,28,28,166,158,165,149,369,326,166,158,369,326,370,329,371,334,372,335,170,161,371,334,170,161,169,160,373,336,372,335,371,334,373,336,371,334,374,337,375,338,376,339,373,336,375,338,373,336,374,337,377,340,376,339,375,338,377,340,375,338,378,341,379,338,380,339,377,340,379,338,377,340,378,341,381,336,380,339,379,338,381,336,379,338,382,337,383,334,384,335,381,336,383,334,381,336,382,337,184,161,384,335,383,334,184,161,383,334,185,160,385,342,380,339,381,336,385,342,381,336,386,343,377,340,380,339,385,342,377,340,385,342,387,344,388,342,376,339,377,340,388,342,377,340,387,344,373,336,376,339,388,342,373,336,388,342,389,343,390,345,372,335,373,336,390,345,373,336,389,343,170,161,372,335,390,345,170,161,390,345,192,173,391,345,384,335,184,161,391,345,184,161,194,173,381,336,384,335,391,345,381,336,391,345,386,343,371,334,392,346,393,347,371,334,393,347,374,337,169,160,197,176,392,346,169,160,392,346,371,334,375,338,394,348,395,349,375,338,395,349,378,341,374,337,393,347,394,348,374,337,394,348,375,338,379,338,396,348,397,347,379,338,397,347,382,337,378,341,395,349,396,348,378,341,396,348,379,338,383,334,398,346,202,176,383,334,202,176,185,160,382,337,397,347,398,346,382,337,398,346,383,334,392,346,399,350,400,351,392,346,400,351,393,347,197,176,206,181,399,350,197,176,399,350,392,346,394,348,401,352,402,353,394,348,402,353,395,349,393,347,400,351,401,352,393,347,401,352,394,348,396,348,403,352,404,351,396,348,404,351,397,347,395,349,402,353,403,352,395,349,403,352,396,348,398,346,405,350,211,181,398,346,211,181,202,176,397,347,404,351,405,350,397,347,405,350,398,346,399,350,213,184,400,351,206,181,213,184,399,350,401,352,213,184,402,353,400,351,213,184,401,352,403,352,213,184,404,351,402,353,213,184,403,352,405,350,213,184,211,181,404,351,213,184,405,350,385,342,386,343,367,328,385,342,367,328,368,333,387,344,385,342,368,333,387,344,368,333,363,332,388,342,387,344,363,332,388,342,363,332,364,333,389,343,388,342,364,333,389,343,364,333,359,328,390,345,389,343,359,328,390,345,359,328,360,329,192,173,390,345,360,329,192,173,360,329,214,158,391,345,194,173,166,158,391,345,166,158,370,329,386,343,391,345,370,329,386,343,370,329,367,328,367,328,370,329,369,326,367,328,369,326,366,327,363,332,368,333,365,330,363,332,365,330,362,331,359,328,364,333,361,330,359,328,361,330,358,327,214,158,360,329,357,326,214,158,357,326,151,149);
    }
    private static void method36(){
        MESH_9.getFaceSmoothingGroups().ensureCapacity(808);
        MESH_9.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_11 = MESHVIEWS[10];
        MESHVIEWS[10].setId("hat_rook");
        MESHVIEWS[10].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_10 = new PhongMaterial();
        MATERIAL_10.setDiffuseColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_10.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_10.setSpecularPower(18.0);
        MESHVIEWS[10].setMaterial(MATERIAL_10);
        MESH_10 = new TriangleMesh();
        MESHVIEWS[10].setMesh(MESH_10);
        MESH_10.getPoints().ensureCapacity(1470);
        MESH_10.getPoints().addAll(0.0f,55.44031f,-1.0E-5f,5.630109f,55.40617f,2.332058f,6.093987f,55.40617f,-1.0E-5f,4.309099f,55.40617f,4.309089f,2.332068f,55.40617f,5.630099f,-0.0f,55.40617f,6.093977f,-2.332068f,55.40617f,5.630099f,-4.309099f,55.40617f,4.309089f,-5.630109f,55.40617f,2.332058f,-6.093987f,55.40617f,-1.0E-5f,-5.630109f,55.40617f,-2.332078f,-4.309099f,55.40617f,-4.309109f,-2.332068f,55.40617f,-5.630119f,0.0f,55.40617f,-6.093997f,2.332068f,55.40617f,-5.630119f,4.309099f,55.40617f,-4.309109f,5.630109f,55.40617f,-2.332078f,5.738491f,57.017715f,2.376951f,6.211298f,57.017715f,-1.0E-5f,4.392051f,57.017715f,4.392041f,2.376961f,57.017715f,5.738481f,-0.0f,57.017715f,6.211288f,-2.376961f,57.017715f,5.738481f,-4.392051f,57.017715f,4.392041f,-5.738491f,57.017715f,2.376951f,-6.211298f,57.017715f,-1.0E-5f,-5.738491f,57.017715f,-2.376971f,-4.392051f,57.017715f,-4.392061f,-2.376961f,57.017715f,-5.738501f,0.0f,57.017715f,-6.211308f,2.376961f,57.017715f,-5.738501f,4.392051f,57.017715f,-4.392061f,5.738491f,57.017715f,-2.376971f,6.211298f,60.07222f,-1.0E-5f,5.738491f,60.07222f,2.376951f,7.672104f,60.018845f,3.17788f,8.304225f,60.018845f,-1.0E-5f,5.871974f,56.96434f,5.871964f,7.672104f,56.96434f,3.17788f,3.17789f,56.96434f,7.672094f,2.376961f,60.07222f,5.738481f,-0.0f,60.07222f,6.211288f,-0.0f,60.018845f,8.304215f,3.17789f,60.018845f,7.672094f,-2.376961f,60.07222f,5.738481f,-3.17789f,60.018845f,7.672094f,-5.871974f,56.96434f,5.871964f,-3.17789f,56.96434f,7.672094f,-7.672104f,56.96434f,3.17788f,-5.738491f,60.07222f,2.376951f,-6.211298f,60.07222f,-1.0E-5f,-8.304225f,60.018845f,-1.0E-5f,-7.672104f,60.018845f,3.17788f,-5.738491f,60.07222f,-2.376971f,-7.672104f,60.018845f,-3.1779f,-5.871974f,56.96434f,-5.871984f,-7.672104f,56.96434f,-3.1779f,-3.17789f,56.96434f,-7.672114f,-2.376961f,60.07222f,-5.738501f,0.0f,60.07222f,-6.211308f,0.0f,60.018845f,-8.304235f,-3.17789f,60.018845f,-7.672114f,2.376961f,60.07222f,-5.738501f,3.17789f,60.018845f,-7.672114f,5.871974f,56.96434f,-5.871984f,3.17789f,56.96434f,-7.672114f,7.672104f,56.96434f,-3.1779f,5.738491f,60.07222f,-2.376971f,7.672104f,60.018845f,-3.1779f,8.304225f,56.96434f,-1.0E-5f,7.752471f,55.837585f,3.211168f,8.391214f,55.837585f,-1.0E-5f,5.933484f,55.837585f,5.933474f,3.211178f,55.837585f,7.752461f,-0.0f,56.96434f,8.304215f,-0.0f,55.837585f,8.391204f,-3.211178f,55.837585f,7.752461f,-5.933484f,55.837585f,5.933474f,-7.752471f,55.837585f,3.211168f,-8.304225f,56.96434f,-1.0E-5f,-8.391214f,55.837585f,-1.0E-5f,-7.752471f,55.837585f,-3.211188f,-5.933484f,55.837585f,-5.933494f,-3.211178f,55.837585f,-7.752481f,0.0f,56.96434f,-8.304235f,0.0f,55.837585f,-8.391224f,3.211178f,55.837585f,-7.752481f,5.933484f,55.837585f,-5.933494f,7.752471f,55.837585f,-3.211188f,7.021299f,54.461994f,2.908307f,7.599799f,54.461994f,-1.0E-5f,5.37387f,54.461994f,5.37386f,2.908317f,54.461994f,7.021288f,-0.0f,54.461994f,7.599789f,-2.908317f,54.461994f,7.021288f,-5.37387f,54.461994f,5.37386f,-7.021299f,54.461994f,2.908307f,-7.599799f,54.461994f,-1.0E-5f,-7.021299f,54.461994f,-2.908327f,-5.37387f,54.461994f,-5.37388f,-2.908317f,54.461994f,-7.021309f,0.0f,54.461994f,-7.599809f,2.908317f,54.461994f,-7.021309f,5.37387f,54.461994f,-5.37388f,7.021299f,54.461994f,-2.908327f,7.570809f,53.669537f,3.135922f,8.194584f,53.669537f,-1.0E-5f,5.794446f,53.669537f,5.794436f,3.135932f,53.669537f,7.570799f,-0.0f,53.669537f,8.194574f,-3.135932f,53.669537f,7.570799f,-5.794446f,53.669537f,5.794436f,-7.570809f,53.669537f,3.135922f,-8.194584f,53.669537f,-1.0E-5f,-7.570809f,53.669537f,-3.135942f,-5.794446f,53.669537f,-5.794456f,-3.135932f,53.669537f,-7.570819f,0.0f,53.669537f,-8.194594f,3.135932f,53.669537f,-7.570819f,5.794446f,53.669537f,-5.794456f,7.570809f,53.669537f,-3.135942f,6.77769f,52.49442f,2.807401f,7.336119f,52.49442f,-1.0E-5f,5.18742f,52.49442f,5.18741f,2.807411f,52.49442f,6.77768f,-0.0f,52.49442f,7.336109f,-2.807411f,52.49442f,6.77768f,-5.18742f,52.49442f,5.18741f,-6.77769f,52.49442f,2.807401f,-7.336119f,52.49442f,-1.0E-5f,-6.77769f,52.49442f,-2.807421f,-5.18742f,52.49442f,-5.18743f,-2.807411f,52.49442f,-6.7777f,0.0f,52.49442f,-7.336129f,2.807411f,52.49442f,-6.7777f,5.18742f,52.49442f,-5.18743f,6.77769f,52.49442f,-2.807421f,6.155256f,52.305367f,2.549581f,6.662401f,52.305367f,-1.0E-5f,4.711029f,52.305367f,4.711019f,2.549591f,52.305367f,6.155246f,-0.0f,52.305367f,6.662391f,-2.549591f,52.305367f,6.155246f,-4.711029f,52.305367f,4.711019f,-6.155256f,52.305367f,2.549581f,-6.662401f,52.305367f,-1.0E-5f,-6.155256f,52.305367f,-2.549601f,-4.711029f,52.305367f,-4.711039f,-2.549591f,52.305367f,-6.155266f,0.0f,52.305367f,-6.662411f,2.549591f,52.305367f,-6.155266f,4.711029f,52.305367f,-4.711039f,6.155256f,52.305367f,-2.549601f,6.174329f,51.532604f,2.557481f,6.683045f,51.532604f,-1.0E-5f,4.725627f,51.532604f,4.725617f,2.557491f,51.532604f,6.174319f,-0.0f,51.532604f,6.683035f,-2.557491f,51.532604f,6.174319f,-4.725627f,51.532604f,4.725617f,-6.174329f,51.532604f,2.557481f,-6.683045f,51.532604f,-1.0E-5f,-6.174329f,51.532604f,-2.557501f,-4.725627f,51.532604f,-4.725637f,-2.557491f,51.532604f,-6.174339f,0.0f,51.532604f,-6.683055f,2.557491f,51.532604f,-6.174339f,4.725627f,51.532604f,-4.725637f,6.174329f,51.532604f,-2.557501f,5.735608f,51.44137f,2.375756f,6.208178f,51.44137f,-1.0E-5f,4.389844f,51.44137f,4.389834f,2.375766f,51.44137f,5.735598f,-0.0f,51.44137f,6.208168f,-2.375766f,51.44137f,5.735598f,-4.389844f,51.44137f,4.389834f,-5.735608f,51.44137f,2.375756f,-6.208178f,51.44137f,-1.0E-5f,-5.735608f,51.44137f,-2.375777f,-4.389844f,51.44137f,-4.389854f,-2.375766f,51.44137f,-5.735618f,0.0f,51.44137f,-6.208188f,2.375766f,51.44137f,-5.735618f,4.389844f,51.44137f,-4.389854f,5.735608f,51.44137f,-2.375777f,5.997982f,50.80148f,2.484435f,6.492169f,50.80148f,-1.0E-5f,4.590657f,50.80148f,4.590647f,2.484445f,50.80148f,5.997972f,-0.0f,50.80148f,6.492159f,-2.484445f,50.80148f,5.997972f,-4.590657f,50.80148f,4.590647f,-5.997982f,50.80148f,2.484435f,-6.492169f,50.80148f,-1.0E-5f,-5.997982f,50.80148f,-2.484455f,-4.590657f,50.80148f,-4.590667f,-2.484445f,50.80148f,-5.997992f,0.0f,50.80148f,-6.492179f,2.484445f,50.80148f,-5.997992f,4.590657f,50.80148f,-4.590667f,5.997982f,50.80148f,-2.484455f,6.344638f,44.047367f,2.628025f,6.867386f,44.047367f,-1.0E-5f,4.855975f,44.047367f,4.855965f,2.628035f,44.047367f,6.344628f,-0.0f,44.047367f,6.867376f,-2.628035f,44.047367f,6.344628f,-4.855975f,44.047367f,4.855965f,-6.344638f,44.047367f,2.628025f,-6.867386f,44.047367f,-1.0E-5f,-6.344638f,44.047367f,-2.628045f,-4.855975f,44.047367f,-4.855985f,-2.628035f,44.047367f,-6.344648f,0.0f,44.047367f,-6.867396f,2.628035f,44.047367f,-6.344648f,4.855975f,44.047367f,-4.855985f,6.344638f,44.047367f,-2.628045f,6.555445f,43.304848f,2.715344f,7.095563f,43.304848f,-1.0E-5f,5.01732f,43.304848f,5.01731f,2.715354f,43.304848f,6.555435f,-0.0f,43.304848f,7.095553f,-2.715354f,43.304848f,6.555435f,-5.01732f,43.304848f,5.01731f,-6.555445f,43.304848f,2.715344f,-7.095563f,43.304848f,-1.0E-5f,-6.555445f,43.304848f,-2.715364f,-5.01732f,43.304848f,-5.017331f,-2.715354f,43.304848f,-6.555455f,0.0f,43.304848f,-7.095573f,2.715354f,43.304848f,-6.555455f,5.01732f,43.304848f,-5.017331f,6.555445f,43.304848f,-2.715364f,7.004126f,42.851223f,2.901194f,7.581211f,42.851223f,-1.0E-5f,5.360726f,42.851223f,5.360716f,2.901204f,42.851223f,7.004116f,-0.0f,42.851223f,7.581201f,-2.901204f,42.851223f,7.004116f,-5.360726f,42.851223f,5.360716f,-7.004126f,42.851223f,2.901194f,-7.581211f,42.851223f,-1.0E-5f,-7.004126f,42.851223f,-2.901214f,-5.360726f,42.851223f,-5.360736f,-2.901204f,42.851223f,-7.004136f,0.0f,42.851223f,-7.581221f,2.901204f,42.851223f,-7.004136f,5.360726f,42.851223f,-5.360736f,7.004126f,42.851223f,-2.901214f,7.004126f,42.14508f,2.901194f,7.581211f,42.14508f,-1.0E-5f,5.360726f,42.14508f,5.360716f,2.901204f,42.14508f,7.004116f,-0.0f,42.14508f,7.581201f,-2.901204f,42.14508f,7.004116f,-5.360726f,42.14508f,5.360716f,-7.004126f,42.14508f,2.901194f,-7.581211f,42.14508f,-1.0E-5f,-7.004126f,42.14508f,-2.901214f,-5.360726f,42.14508f,-5.360736f,-2.901204f,42.14508f,-7.004136f,0.0f,42.14508f,-7.581221f,2.901204f,42.14508f,-7.004136f,5.360726f,42.14508f,-5.360736f,7.004126f,42.14508f,-2.901214f,6.511019f,41.635773f,2.696942f,7.047476f,41.635773f,-1.0E-5f,4.983318f,41.635773f,4.983308f,2.696952f,41.635773f,6.511008f,-0.0f,41.635773f,7.047466f,-2.696952f,41.635773f,6.511008f,-4.983318f,41.635773f,4.983308f,-6.511019f,41.635773f,2.696942f,-7.047476f,41.635773f,-1.0E-5f,-6.511019f,41.635773f,-2.696962f,-4.983318f,41.635773f,-4.983328f,-2.696952f,41.635773f,-6.511029f,0.0f,41.635773f,-7.047486f,2.696952f,41.635773f,-6.511029f,4.983318f,41.635773f,-4.983328f,6.511019f,41.635773f,-2.696962f,5.977902f,41.12221f,2.476118f,6.470434f,41.12221f,-1.0E-5f,4.575288f,41.12221f,4.575278f,2.476128f,41.12221f,5.977892f,-0.0f,41.12221f,6.470424f,-2.476128f,41.12221f,5.977892f,-4.575288f,41.12221f,4.575278f,-5.977902f,41.12221f,2.476118f,-6.470434f,41.12221f,-1.0E-5f,-5.977902f,41.12221f,-2.476138f,-4.575288f,41.12221f,-4.575298f,-2.476128f,41.12221f,-5.977912f,0.0f,41.12221f,-6.470444f,2.476128f,41.12221f,-5.977912f,4.575288f,41.12221f,-4.575298f,5.977902f,41.12221f,-2.476138f,5.889048f,39.566307f,2.439314f,6.374261f,39.566307f,-1.0E-5f,4.507283f,39.566307f,4.507273f,2.439324f,39.566307f,5.889038f,-0.0f,39.566307f,6.374251f,-2.439324f,39.566307f,5.889038f,-4.507283f,39.566307f,4.507273f,-5.889048f,39.566307f,2.439314f,-6.374261f,39.566307f,-1.0E-5f,-5.889048f,39.566307f,-2.439334f,-4.507283f,39.566307f,-4.507293f,-2.439324f,39.566307f,-5.889058f,0.0f,39.566307f,-6.374271f,2.439324f,39.566307f,-5.889058f,4.507283f,39.566307f,-4.507293f,5.889048f,39.566307f,-2.439334f,7.355121f,39.08803f,3.046581f,7.961126f,39.08803f,-1.0E-5f,5.629366f,39.08803f,5.629356f,3.046591f,39.08803f,7.355111f,-0.0f,39.08803f,7.961116f,-3.046591f,39.08803f,7.355111f,-5.629366f,39.08803f,5.629356f,-7.355121f,39.08803f,3.046581f,-7.961126f,39.08803f,-1.0E-5f,-7.355121f,39.08803f,-3.046601f,-5.629366f,39.08803f,-5.629376f,-3.046591f,39.08803f,-7.355131f,0.0f,39.08803f,-7.961136f,3.046591f,39.08803f,-7.355131f,5.629366f,39.08803f,-5.629376f,7.355121f,39.08803f,-3.046601f,7.62168f,38.667576f,3.156993f,8.249647f,38.667576f,-1.0E-5f,5.833381f,38.667576f,5.833371f,3.157003f,38.667576f,7.62167f,-0.0f,38.667576f,8.249637f,-3.157003f,38.667576f,7.62167f,-5.833381f,38.667576f,5.833371f,-7.62168f,38.667576f,3.156993f,-8.249647f,38.667576f,-1.0E-5f,-7.62168f,38.667576f,-3.157013f,-5.833381f,38.667576f,-5.833391f,-3.157003f,38.667576f,-7.62169f,0.0f,38.667576f,-8.249657f,3.157003f,38.667576f,-7.62169f,5.833381f,38.667576f,-5.833391f,7.62168f,38.667576f,-3.157013f,7.492817f,38.025623f,3.103616f,8.110166f,38.025623f,-1.0E-5f,5.734754f,38.025623f,5.734744f,3.103626f,38.025623f,7.492807f,-0.0f,38.025623f,8.110156f,-3.103626f,38.025623f,7.492807f,-5.734754f,38.025623f,5.734744f,-7.492817f,38.025623f,3.103616f,-8.110166f,38.025623f,-1.0E-5f,-7.492817f,38.025623f,-3.103636f,-5.734754f,38.025623f,-5.734764f,-3.103626f,38.025623f,-7.492827f,0.0f,38.025623f,-8.110176f,3.103626f,38.025623f,-7.492827f,5.734754f,38.025623f,-5.734764f,7.492817f,38.025623f,-3.103636f,6.733151f,37.512062f,2.788953f,7.28791f,37.512062f,-1.0E-5f,5.15333f,37.512062f,5.15332f,2.788963f,37.512062f,6.733141f,-0.0f,37.512062f,7.2879f,-2.788963f,37.512062f,6.733141f,-5.15333f,37.512062f,5.15332f,-6.733151f,37.512062f,2.788953f,-7.28791f,37.512062f,-1.0E-5f,-6.733151f,37.512062f,-2.788973f,-5.15333f,37.512062f,-5.153341f,-2.788963f,37.512062f,-6.733161f,0.0f,37.512062f,-7.28792f,2.788963f,37.512062f,-6.733161f,5.15333f,37.512062f,-5.153341f,6.733151f,37.512062f,-2.788973f,7.310694f,37.38367f,3.028179f,7.913039f,37.38367f,-1.0E-5f,5.595364f,37.38367f,5.595354f,3.028189f,37.38367f,7.310684f,-0.0f,37.38367f,7.913029f,-3.028189f,37.38367f,7.310684f,-5.595364f,37.38367f,5.595354f,-7.310694f,37.38367f,3.028179f,-7.913039f,37.38367f,-1.0E-5f,-7.310694f,37.38367f,-3.028199f,-5.595364f,37.38367f,-5.595374f,-3.028189f,37.38367f,-7.310704f,0.0f,37.38367f,-7.913049f,3.028189f,37.38367f,-7.310704f,5.595364f,37.38367f,-5.595374f,7.310694f,37.38367f,-3.028199f,8.065944f,36.74172f,3.341013f,8.730515f,36.74172f,-1.0E-5f,6.173406f,36.74172f,6.173396f,3.341024f,36.74172f,8.065934f,-0.0f,36.74172f,8.730505f,-3.341024f,36.74172f,8.065934f,-6.173406f,36.74172f,6.173396f,-8.065944f,36.74172f,3.341013f,-8.730515f,36.74172f,-1.0E-5f,-8.065944f,36.74172f,-3.341034f,-6.173406f,36.74172f,-6.173416f,-3.341024f,36.74172f,-8.065954f,0.0f,36.74172f,-8.730525f,3.341024f,36.74172f,-8.065954f,6.173406f,36.74172f,-6.173416f,8.065944f,36.74172f,-3.341034f,8.084477f,35.0f,3.34869f,8.750575f,35.0f,-1.0E-5f,6.187591f,35.0f,6.187581f,3.3487f,35.0f,8.084467f,-0.0f,35.0f,8.750565f,-3.3487f,35.0f,8.084467f,-6.187591f,35.0f,6.187581f,-8.084477f,35.0f,3.34869f,-8.750575f,35.0f,-1.0E-5f,-8.084477f,35.0f,-3.34871f,-6.187591f,35.0f,-6.187601f,-3.3487f,35.0f,-8.084487f,0.0f,35.0f,-8.750585f,3.3487f,35.0f,-8.084487f,6.187591f,35.0f,-6.187601f,8.084477f,35.0f,-3.34871f,7.980057f,35.0f,3.305438f,8.637551f,35.0f,-1.0E-5f,6.107671f,35.0f,6.107661f,3.305448f,35.0f,7.980047f,-0.0f,35.0f,8.637541f,-3.305448f,35.0f,7.980047f,-6.107671f,35.0f,6.107661f,-7.980057f,35.0f,3.305438f,-8.637551f,35.0f,-1.0E-5f,-7.980057f,35.0f,-3.305458f,-6.107671f,35.0f,-6.107681f,-3.305448f,35.0f,-7.980067f,0.0f,35.0f,-8.637561f,3.305448f,35.0f,-7.980067f,6.107671f,35.0f,-6.107681f,7.980057f,35.0f,-3.305458f,0.0f,35.0f,-1.0E-5f,5.738491f,57.04796f,2.376951f,6.211298f,57.04796f,-1.0E-5f,7.672104f,56.994583f,3.17788f,8.304225f,56.994583f,-1.0E-5f,5.738491f,57.04796f,-2.376971f,7.672104f,56.994583f,-3.1779f,-0.0f,57.04796f,6.211288f,2.376961f,57.04796f,5.738481f,3.17789f,56.994583f,7.672094f,-0.0f,56.994583f,8.304215f,-2.376961f,57.04796f,5.738481f,-3.17789f,56.994583f,7.672094f,-6.211298f,57.04796f,-1.0E-5f,-5.738491f,57.04796f,2.376951f,-7.672104f,56.994583f,3.17788f,-8.304225f,56.994583f,-1.0E-5f,-5.738491f,57.04796f,-2.376971f,-7.672104f,56.994583f,-3.1779f,0.0f,57.04796f,-6.211308f,-2.376961f,57.04796f,-5.738501f,-3.17789f,56.994583f,-7.672114f,0.0f,56.994583f,-8.304235f,2.376961f,57.04796f,-5.738501f,3.17789f,56.994583f,-7.672114f,0.0f,59.9883f,-8.304235f,-3.17789f,59.9883f,-7.672114f,3.17789f,59.9883f,-7.672114f,2.376961f,60.041676f,-5.738501f,0.0f,60.041676f,-6.211308f,-2.376961f,60.041676f,-5.738501f,-5.738491f,60.041676f,-2.376971f,-7.672104f,59.9883f,-3.1779f,-6.211298f,60.041676f,-1.0E-5f,-5.738491f,60.041676f,2.376951f,-7.672104f,59.9883f,3.17788f,-8.304225f,59.9883f,-1.0E-5f,-2.376961f,60.041676f,5.738481f,-3.17789f,59.9883f,7.672094f,-0.0f,60.041676f,6.211288f,2.376961f,60.041676f,5.738481f,3.17789f,59.9883f,7.672094f,-0.0f,59.9883f,8.304215f,5.738491f,60.041676f,2.376951f,7.672104f,59.9883f,3.17788f,6.211298f,60.041676f,-1.0E-5f,5.738491f,60.041676f,-2.376971f,7.672104f,59.9883f,-3.1779f,8.304225f,59.9883f,-1.0E-5f);
    }
    private static void method37(){
        MESH_10.getTexCoords().ensureCapacity(1860);
        MESH_10.getTexCoords().addAll(0.418444f,0.394823f,0.502792f,0.429761f,0.509741f,0.394823f,0.483001f,0.45937902f,0.453382f,0.47917002f,0.418444f,0.48612f,0.383506f,0.47917002f,0.353888f,0.45937902f,0.334097f,0.429761f,0.327147f,0.394823f,0.334097f,0.35988498f,0.353888f,0.330266f,0.383506f,0.310475f,0.418444f,0.30352598f,0.453382f,0.310475f,0.483001f,0.330266f,0.502792f,0.35988498f,0.064049f,0.21961898f,0.064049f,0.254556f,0.085587f,0.255229f,0.085587f,0.21961898f,0.064049f,0.28417498f,0.085587f,0.28541797f,0.143807f,0.13928503f,0.143807f,0.10966599f,0.122269f,0.11033797f,0.122269f,0.14052701f,0.143807f,0.07472801f,0.122269f,0.07472801f,0.143807f,0.039789975f,0.122269f,0.039117992f,0.143807f,0.010170996f,0.122269f,0.008929014f,0.153823f,0.010170996f,0.153823f,0.039789975f,0.175361f,0.039117992f,0.175361f,0.008929014f,0.153823f,0.07472801f,0.175361f,0.07472801f,0.153823f,0.10966599f,0.175361f,0.11033797f,0.153823f,0.13928503f,0.175361f,0.14052701f,0.008878f,0.015662014f,0.008878f,0.04527998f,0.030416f,0.044607997f,0.030416f,0.014419019f,0.008878f,0.08021802f,0.030416f,0.08021802f,0.008878f,0.115155995f,0.030416f,0.11582899f,0.008878f,0.14477497f,0.030416f,0.14601803f,0.064049f,0.15506202f,0.064049f,0.184681f,0.085587f,0.184008f,0.085587f,0.15381902f,0.233283f,0.09291798f,0.2262f,0.128528f,0.255168f,0.14052701f,0.264639f,0.09291798f,0.503614f,0.108621f,0.473425f,0.088449f,0.451254f,0.11062002f,0.491615f,0.13758898f,0.453254f,0.058260024f,0.424285f,0.070258975f,0.363681f,0.12559003f,0.356598f,0.089980006f,0.325243f,0.089980006f,0.334713f,0.13758898f,0.363681f,0.054368973f,0.334713f,0.04237002f,0.542773f,0.13758898f,0.562944f,0.1074f,0.540773f,0.08522898f,0.513804f,0.12559003f,0.593133f,0.087228f,0.581134f,0.058260024f,0.31416f,0.13152498f,0.307077f,0.09591502f,0.275721f,0.09591502f,0.285191f,0.14352399f,0.31416f,0.060305f,0.285191f,0.048304975f,0.603324f,0.092638016f,0.633513f,0.112810016f,0.655684f,0.090638995f,0.615323f,0.06366998f,0.653684f,0.142999f,0.682653f,0.13099998f,0.374764f,0.054368973f,0.381847f,0.089980006f,0.413202f,0.089980006f,0.403732f,0.04237002f,0.374764f,0.12559003f,0.403732f,0.13758898f,0.743204f,0.06366998f,0.723032f,0.09385902f,0.745203f,0.11602998f,0.772172f,0.07566899f,0.692843f,0.11403102f,0.704842f,0.142999f,0.2262f,0.057307005f,0.255168f,0.045307994f,0.802104f,0.40503198f,0.802104f,0.357423f,0.787045f,0.356924f,0.787045f,0.40503198f,0.802104f,0.31706202f,0.787045f,0.31614f,0.581164f,0.485799f,0.581164f,0.44543803f,0.566105f,0.44593698f,0.566105f,0.48672098f,0.581164f,0.39782798f,0.566105f,0.39782798f,0.581164f,0.350219f,0.566105f,0.34972f,0.581164f,0.309857f,0.566105f,0.308936f,0.691634f,0.485799f,0.691634f,0.44543803f,0.676575f,0.44593698f,0.676575f,0.48672098f,0.691634f,0.39782798f,0.676575f,0.39782798f,0.691634f,0.350219f,0.676575f,0.34972f,0.691634f,0.309857f,0.676575f,0.308936f,0.893658f,0.31706202f,0.893658f,0.357423f,0.908717f,0.356924f,0.908717f,0.31614f,0.893658f,0.40503198f,0.908717f,0.40503198f,0.893658f,0.45264202f,0.908717f,0.45314097f,0.893658f,0.493003f,0.908717f,0.49392498f,0.802104f,0.493003f,0.802104f,0.45264202f,0.787045f,0.45314097f,0.787045f,0.49392498f,0.768661f,0.361462f,0.768661f,0.40503198f,0.768661f,0.324524f,0.54772f,0.44139898f,0.54772f,0.478337f,0.54772f,0.39782798f,0.54772f,0.354257f,0.54772f,0.31732f,0.65819f,0.44139898f,0.65819f,0.478337f,0.65819f,0.39782798f,0.65819f,0.354257f,0.65819f,0.31732f,0.927102f,0.361462f,0.927102f,0.324524f,0.927102f,0.40503198f,0.927102f,0.44860297f,0.927102f,0.485541f,0.768661f,0.44860297f,0.768661f,0.485541f,0.758069f,0.35805202f,0.758069f,0.40503198f,0.758069f,0.318223f,0.537128f,0.44480902f,0.537128f,0.48463798f,0.537128f,0.39782798f,0.537128f,0.350847f,0.537128f,0.311019f,0.647599f,0.44480902f,0.647599f,0.48463798f,0.647599f,0.39782798f,0.647599f,0.350847f,0.647599f,0.311019f,0.937693f,0.35805202f,0.937693f,0.318223f,0.937693f,0.40503198f,0.937693f,0.45201302f,0.937693f,0.49184197f,0.758069f,0.45201302f,0.758069f,0.49184197f,0.742364f,0.36297297f,0.742364f,0.40503198f,0.742364f,0.327317f,0.521423f,0.439888f,0.521423f,0.47554398f,0.521423f,0.39782798f,0.521423f,0.35576898f,0.521423f,0.320113f,0.631894f,0.439888f,0.631894f,0.47554398f,0.631894f,0.39782798f,0.631894f,0.35576898f,0.631894f,0.320113f,0.953398f,0.36297297f,0.953398f,0.327317f,0.953398f,0.40503198f,0.953398f,0.447092f,0.953398f,0.48274797f,0.742364f,0.447092f,0.742364f,0.48274797f,0.25582f,0.611171f,0.247453f,0.569112f,0.238128f,0.57297397f,0.245726f,0.611171f,0.223629f,0.53345597f,0.216492f,0.540593f,0.187973f,0.50963104f,0.18411f,0.518956f,0.145914f,0.501265f,0.145914f,0.511358f,0.103854f,0.50963104f,0.107717f,0.518956f,0.068198f,0.53345597f,0.075335f,0.540593f,0.044374f,0.569112f,0.053699f,0.57297397f,0.036008f,0.611171f,0.046101f,0.611171f,0.044374f,0.65323f,0.053699f,0.649367f,0.068198f,0.688886f,0.075335f,0.681749f,0.103854f,0.712711f,0.107717f,0.703386f,0.145914f,0.72107697f,0.145914f,0.71098304f,0.187973f,0.712711f,0.18411f,0.703386f,0.223629f,0.688886f,0.216492f,0.681749f,0.247453f,0.65323f,0.238128f,0.649367f,0.349851f,0.22492701f,0.349851f,0.18673098f,0.339523f,0.18661201f,0.339523f,0.22492701f,0.349851f,0.15434903f,0.339523f,0.154131f,0.329627f,0.292701f,0.329627f,0.26032f,0.319299f,0.26043802f,0.319299f,0.29292f,0.329627f,0.22212303f,0.319299f,0.22212303f,0.329627f,0.18392599f,0.319299f,0.18380803f,0.329627f,0.15154499f,0.319299f,0.151326f,0.309402f,0.292701f,0.309402f,0.26032f,0.299074f,0.26043802f,0.299074f,0.29292f,0.309402f,0.22212303f,0.299074f,0.22212303f,0.309402f,0.18392599f,0.299074f,0.18380803f,0.309402f,0.15154499f,0.299074f,0.151326f,0.278849f,0.15154499f,0.278849f,0.18392599f,0.289177f,0.18380803f,0.289177f,0.151326f,0.278849f,0.22212303f,0.289177f,0.22212303f,0.278849f,0.26032f,0.289177f,0.26043802f,0.278849f,0.292701f,0.289177f,0.29292f,0.349851f,0.295506f,0.349851f,0.263124f,0.339523f,0.263242f,0.339523f,0.29572397f,0.209122f,0.393341f,0.2015f,0.355026f,0.194928f,0.357749f,0.202008f,0.393341f,0.179797f,0.322545f,0.174766f,0.32757503f,0.147315f,0.30084097f,0.144592f,0.307414f,0.109f,0.29321998f,0.109f,0.30033398f,0.070685f,0.30084097f,0.073407f,0.307414f,0.038203f,0.322545f,0.043233f,0.32757503f,0.016499f,0.355026f,0.023072f,0.357749f,0.008878f,0.393341f,0.015992f,0.393341f,0.016499f,0.431656f,0.023072f,0.42893398f,0.038203f,0.46413797f,0.043233f,0.459108f,0.070685f,0.485842f,0.073407f,0.47926903f,0.109f,0.49346298f,0.109f,0.486349f,0.147315f,0.485842f,0.144592f,0.47926903f,0.179797f,0.46413797f,0.174766f,0.459108f,0.2015f,0.431656f,0.194928f,0.42893398f,0.804639f,0.225968f,0.804639f,0.19037497f,0.796087f,0.18874699f,0.796087f,0.225968f,0.804639f,0.16020101f,0.796087f,0.157193f,0.690942f,0.29173398f,0.690942f,0.26156002f,0.68239f,0.263188f,0.68239f,0.294742f,0.690942f,0.225968f,0.68239f,0.225968f,0.690942f,0.19037497f,0.68239f,0.18874699f,0.690942f,0.16020101f,0.68239f,0.157193f,0.577245f,0.28632402f,0.577245f,0.25615f,0.568693f,0.257778f,0.568693f,0.28933197f,0.577245f,0.22055697f,0.568693f,0.22055697f,0.577245f,0.18496501f,0.568693f,0.18333697f,0.577245f,0.154791f,0.568693f,0.15178299f,0.359748f,0.154791f,0.359748f,0.18496501f,0.3683f,0.18333697f,0.3683f,0.15178299f,0.359748f,0.22055799f,0.3683f,0.22055799f,0.359748f,0.25615f,0.3683f,0.257778f,0.359748f,0.28632402f,0.3683f,0.28933197f,0.804639f,0.29173398f,0.804639f,0.26156002f,0.796087f,0.263188f,0.796087f,0.294742f,0.705819f,0.18659598f,0.705819f,0.225968f,0.705819f,0.15321797f,0.592121f,0.26533902f,0.592121f,0.29871702f,0.592121f,0.225968f,0.592121f,0.18659598f,0.592121f,0.15321797f,0.478425f,0.259929f,0.478425f,0.293307f,0.478425f,0.22055697f,0.478425f,0.18118602f,0.478425f,0.14780802f,0.458569f,0.18118602f,0.458569f,0.14780802f,0.458569f,0.22055799f,0.458569f,0.259929f,0.458569f,0.293307f,0.705819f,0.26533902f,0.705819f,0.29871702f,0.700839f,0.185287f,0.700839f,0.225968f,0.700839f,0.150801f,0.587142f,0.26664698f,0.587142f,0.301134f,0.587142f,0.225968f,0.587142f,0.185287f,0.587142f,0.150801f,0.473445f,0.26123703f,0.473445f,0.29572397f,0.473445f,0.22055697f,0.473445f,0.17987698f,0.473445f,0.14539099f,0.463548f,0.17987698f,0.463548f,0.14539099f,0.463548f,0.22055799f,0.463548f,0.26123798f,0.463548f,0.29572397f,0.700839f,0.26664698f,0.700839f,0.301134f,0.722648f,0.6081f,0.714556f,0.64878f,0.721278f,0.651564f,0.729924f,0.6081f,0.691513f,0.683267f,0.696658f,0.688412f,0.657026f,0.70631003f,0.659811f,0.713032f,0.616346f,0.71440196f,0.616346f,0.721678f,0.575666f,0.70631003f,0.572882f,0.713032f,0.541179f,0.683267f,0.536035f,0.688412f,0.518136f,0.64878f,0.511414f,0.651564f,0.510044f,0.6081f,0.502768f,0.6081f,0.518136f,0.56742f,0.511414f,0.564636f,0.541179f,0.532933f,0.536035f,0.52778804f,0.575666f,0.50988996f,0.572882f,0.503168f,0.616346f,0.50179803f,0.616346f,0.49452198f,0.657026f,0.50988996f,0.659811f,0.503168f,0.691513f,0.532933f,0.696658f,0.52778804f,0.714556f,0.56742f,0.721278f,0.564636f,0.881976f,0.22802699f,0.881976f,0.18456298f,0.872539f,0.18456298f,0.872539f,0.22802699f,0.881976f,0.14771497f,0.872539f,0.14771497f,0.862642f,0.308339f,0.862642f,0.271491f,0.853204f,0.271491f,0.853204f,0.308339f,0.862642f,0.22802699f,0.853204f,0.22802699f,0.862642f,0.18456298f,0.853204f,0.18456298f,0.862642f,0.14771497f,0.853204f,0.14771497f,0.843308f,0.308339f,0.843308f,0.271491f,0.83387f,0.271491f,0.83387f,0.308339f,0.843308f,0.22802699f,0.83387f,0.22802699f,0.843308f,0.18456298f,0.83387f,0.18456298f,0.843308f,0.14771497f,0.83387f,0.14771497f,0.814536f,0.14771497f,0.814536f,0.18456298f,0.823974f,0.18456298f,0.823974f,0.14771497f,0.814536f,0.22802699f,0.823974f,0.22802699f,0.814536f,0.271491f,0.823974f,0.271491f,0.814536f,0.308339f,0.823974f,0.308339f,0.881976f,0.308339f,0.881976f,0.271491f,0.872539f,0.271491f,0.872539f,0.308339f,0.492872f,0.607499f,0.484226f,0.564035f,0.476839f,0.56709504f,0.484876f,0.607499f,0.459606f,0.527187f,0.453951f,0.53284204f,0.422758f,0.502567f,0.419698f,0.509954f,0.379294f,0.49392098f,0.379294f,0.501917f,0.33583f,0.502567f,0.33889f,0.509954f,0.298982f,0.527187f,0.304636f,0.53284204f,0.274362f,0.564035f,0.281749f,0.56709504f,0.265716f,0.607499f,0.273712f,0.607499f,0.274362f,0.650963f,0.281749f,0.64790297f,0.298982f,0.687811f,0.304636f,0.68215704f,0.33583f,0.712431f,0.33889f,0.70504403f,0.379294f,0.72107697f,0.379294f,0.713081f,0.422758f,0.712431f,0.419698f,0.70504403f,0.459606f,0.687811f,0.453951f,0.68215704f,0.484226f,0.650963f,0.476839f,0.64790297f,0.468852f,0.570403f,0.476231f,0.607499f,0.447839f,0.538954f,0.41639f,0.517941f,0.379294f,0.510562f,0.342198f,0.517941f,0.310749f,0.538954f,0.289736f,0.570403f,0.282357f,0.607499f,0.289736f,0.644595f,0.310749f,0.676044f,0.342198f,0.697057f,0.379294f,0.704436f,0.41639f,0.697057f,0.447839f,0.676044f,0.468852f,0.644595f,0.268953f,0.22437501f,0.268953f,0.18727899f,0.243214f,0.18782997f,0.243214f,0.22437501f,0.268953f,0.15583098f,0.243214f,0.15684903f,0.197682f,0.28541797f,0.197682f,0.25397003f,0.171943f,0.25341803f,0.171943f,0.28439897f,0.197682f,0.21687299f,0.171943f,0.21687299f,0.197682f,0.17977703f,0.171943f,0.18032902f,0.197682f,0.14832902f,0.171943f,0.14934802f,0.162046f,0.28541797f,0.162046f,0.25397003f,0.136307f,0.25341803f,0.136307f,0.28439897f,0.162046f,0.21687299f,0.136307f,0.21687299f,0.162046f,0.17977703f,0.136307f,0.18032902f,0.162046f,0.14832902f,0.136307f,0.14934802f,0.207578f,0.14832902f,0.207578f,0.17977703f,0.233317f,0.18032902f,0.233317f,0.14934802f,0.207578f,0.21687299f,0.233317f,0.21687299f,0.207578f,0.253969f,0.233317f,0.25341803f,0.207578f,0.28541797f,0.233317f,0.28439897f,0.268953f,0.29292f,0.268953f,0.26147097f,0.243214f,0.26092f,0.243214f,0.291901f,0.954586f,0.620996f,0.947317f,0.65754104f,0.969281f,0.666638f,0.97836f,0.620996f,0.926616f,0.688522f,0.943426f,0.70533204f,0.895635f,0.70922196f,0.904732f,0.73118603f,0.85909f,0.716492f,0.85909f,0.740265f,0.822545f,0.70922196f,0.813448f,0.73118603f,0.791564f,0.688522f,0.774754f,0.70533204f,0.770863f,0.65754104f,0.748899f,0.666638f,0.763594f,0.620996f,0.739821f,0.620996f,0.770863f,0.58445096f,0.748899f,0.575353f,0.791564f,0.55347f,0.774754f,0.53665996f,0.822545f,0.53276896f,0.813448f,0.510805f,0.85909f,0.5255f,0.85909f,0.50172603f,0.895635f,0.53276896f,0.904732f,0.510805f,0.926616f,0.55347f,0.943426f,0.53665996f,0.947317f,0.58445096f,0.969281f,0.575353f,0.978359f,0.406532f,0.978359f,0.36088997f,0.97274f,0.359236f,0.97274f,0.406532f,0.978359f,0.322196f,0.97274f,0.319139f,0.954264f,0.305282f,0.954264f,0.26658797f,0.948644f,0.268242f,0.948644f,0.308339f,0.954264f,0.22094601f,0.948644f,0.22094601f,0.954264f,0.17530298f,0.948644f,0.17364901f,0.954264f,0.13660997f,0.948644f,0.13355303f,0.930168f,0.305282f,0.930168f,0.26658797f,0.924549f,0.268242f,0.924549f,0.308339f,0.930168f,0.22094601f,0.924549f,0.22094601f,0.930168f,0.17530298f,0.924549f,0.17364901f,0.930168f,0.13660997f,0.924549f,0.13355303f,0.891873f,0.13660997f,0.891873f,0.175304f,0.897493f,0.17364901f,0.897493f,0.13355303f,0.891873f,0.22094601f,0.897493f,0.22094601f,0.891873f,0.26658797f,0.897493f,0.268243f,0.891873f,0.305282f,0.897493f,0.308339f,0.978359f,0.49086797f,0.978359f,0.45217502f,0.97274f,0.453829f,0.97274f,0.49392498f,0.96416f,0.360035f,0.96416f,0.406532f,0.96416f,0.32061702f,0.940065f,0.267443f,0.940065f,0.30686098f,0.940065f,0.22094601f,0.940065f,0.17444903f,0.940065f,0.13503098f,0.915969f,0.267443f,0.915969f,0.30686098f,0.915969f,0.22094601f,0.915969f,0.17444903f,0.915969f,0.13503098f,0.906072f,0.17444903f,0.906072f,0.13503098f,0.906072f,0.22094601f,0.906072f,0.267443f,0.906072f,0.30686098f,0.96416f,0.45302898f,0.96416f,0.49244702f,0.796807f,0.869569f,0.787558f,0.823072f,0.776177f,0.82778597f,0.784488f,0.869569f,0.76122f,0.783654f,0.752509f,0.792365f,0.721802f,0.757316f,0.717087f,0.768697f,0.675305f,0.748067f,0.675305f,0.76038504f,0.628808f,0.757316f,0.633522f,0.768697f,0.58939f,0.783654f,0.5981f,0.792365f,0.563051f,0.823072f,0.574432f,0.82778597f,0.553802f,0.869569f,0.566121f,0.869569f,0.563051f,0.916066f,0.574432f,0.911352f,0.58939f,0.955484f,0.5981f,0.946774f,0.628808f,0.981823f,0.633522f,0.970442f,0.675305f,0.991071f,0.675305f,0.978753f,0.721802f,0.981823f,0.717087f,0.970442f,0.76122f,0.955484f,0.752509f,0.946774f,0.787558f,0.916066f,0.776177f,0.911352f,0.521415f,0.86027503f,0.513104f,0.902058f,0.521756f,0.90564203f,0.53078f,0.86027503f,0.489436f,0.93748f,0.496058f,0.944102f,0.454014f,0.961148f,0.457598f,0.9698f,0.412231f,0.969459f,0.412231f,0.978824f,0.370449f,0.961148f,0.366865f,0.9698f,0.335027f,0.93748f,0.328405f,0.944102f,0.311359f,0.902058f,0.302706f,0.90564203f,0.303048f,0.86027503f,0.293682f,0.86027503f,0.311359f,0.818493f,0.302706f,0.814909f,0.335027f,0.783071f,0.328405f,0.77644897f,0.370449f,0.759403f,0.366865f,0.75075f,0.412231f,0.751092f,0.412231f,0.74172604f,0.454014f,0.759403f,0.457598f,0.75075f,0.489436f,0.783071f,0.496058f,0.77644897f,0.513104f,0.818493f,0.521756f,0.814909f,0.533071f,0.910329f,0.543027f,0.86027503f,0.504718f,0.952762f,0.462285f,0.981115f,0.412231f,0.991071f,0.362178f,0.981115f,0.319745f,0.952762f,0.291392f,0.910329f,0.281435f,0.86027503f,0.291392f,0.810222f,0.319745f,0.767789f,0.362178f,0.73943603f,0.412231f,0.729479f,0.462285f,0.73943603f,0.504718f,0.767789f,0.533071f,0.810222f,0.236015f,0.400764f,0.236015f,0.350711f,0.220486f,0.350596f,0.220486f,0.400764f,0.236015f,0.308277f,0.220486f,0.308065f,0.26268f,0.48590702f,0.26268f,0.443474f,0.247151f,0.44358897f,0.247151f,0.48612f,0.26268f,0.393421f,0.247151f,0.393421f,0.26268f,0.34336698f,0.247151f,0.343252f,0.26268f,0.30093402f,0.247151f,0.300721f,0.289345f,0.48590702f,0.289345f,0.443474f,0.273817f,0.44358897f,0.273817f,0.48612f,0.289345f,0.393421f,0.273817f,0.393421f,0.289345f,0.34336698f,0.273817f,0.343252f,0.289345f,0.30093402f,0.273817f,0.300721f,0.300482f,0.30093402f,0.300482f,0.34336698f,0.316011f,0.343252f,0.316011f,0.300721f,0.300482f,0.393421f,0.316011f,0.393421f,0.300482f,0.443474f,0.316011f,0.44358897f,0.300482f,0.48590702f,0.316011f,0.48612f,0.236015f,0.49325103f,0.236015f,0.450818f,0.220486f,0.45093298f,0.220486f,0.49346298f,0.271071f,0.859975f,0.261092f,0.809806f,0.244841f,0.816538f,0.253481f,0.859975f,0.232674f,0.767276f,0.220235f,0.779714f,0.190143f,0.73885703f,0.183411f,0.755109f,0.139975f,0.728878f,0.139975f,0.746469f,0.089806f,0.73885703f,0.096538f,0.755109f,0.047275f,0.767276f,0.059714f,0.779714f,0.018857f,0.809806f,0.035108f,0.816538f,0.008878f,0.859975f,0.026468f,0.859975f,0.018857f,0.910143f,0.035108f,0.903412f,0.047275f,0.95267403f,0.059714f,0.940236f,0.089806f,0.981092f,0.096538f,0.964841f,0.139975f,0.991071f,0.139975f,0.973481f,0.190143f,0.981092f,0.183411f,0.964841f,0.232674f,0.95267403f,0.220235f,0.940236f,0.261092f,0.910143f,0.244841f,0.903412f,0.139975f,0.859975f,0.085991f,0.255229f,0.085991f,0.21961898f,0.782362f,0.13920099f,0.81133f,0.13991398f,0.81133f,0.13950998f,0.782362f,0.13879597f,0.802509f,0.40503198f,0.802509f,0.357423f,0.085991f,0.184008f,0.802509f,0.45264202f,0.851328f,0.09837699f,0.82236f,0.09908998f,0.82236f,0.09949499f,0.851328f,0.09878099f,0.121865f,0.07472801f,0.121865f,0.11033797f,0.581568f,0.44543803f,0.581568f,0.39782798f,0.862358f,0.12575197f,0.891326f,0.12503803f,0.891326f,0.12463403f,0.862358f,0.12534797f,0.121865f,0.039117992f,0.902356f,0.12503803f,0.931324f,0.12575197f,0.931324f,0.12534702f,0.902356f,0.12463403f,0.581568f,0.350219f,0.175765f,0.07472801f,0.175765f,0.039117992f,0.692038f,0.44543803f,0.692038f,0.39782798f,0.942354f,0.12575197f,0.971322f,0.12503803f,0.971322f,0.12463403f,0.942354f,0.12534702f,0.175765f,0.11033797f,0.978359f,0.035589993f,0.949391f,0.034877002f,0.949391f,0.035281003f,0.978359f,0.035993993f,0.692038f,0.350219f,0.03082f,0.08021802f,0.03082f,0.044607997f,0.893254f,0.357423f,0.893254f,0.40503198f,0.910526f,0.076412976f,0.939494f,0.075699985f,0.939494f,0.075295985f,0.910526f,0.076008976f,0.03082f,0.11582899f,0.871661f,0.075699985f,0.900629f,0.076412976f,0.900629f,0.076008976f,0.871661f,0.075295985f,0.893254f,0.45264202f,0.853243f,0.40503198f,0.853243f,0.357423f,0.852835f,0.357423f,0.852835f,0.40503198f,0.853243f,0.45264202f,0.852835f,0.45264202f,0.871661f,0.035284996f,0.900629f,0.035997987f,0.900629f,0.035589993f,0.871661f,0.034877002f,0.070832f,0.08021802f,0.070832f,0.11582899f,0.07124f,0.11582899f,0.07124f,0.08021802f,0.070832f,0.044607997f,0.07124f,0.044607997f,0.910526f,0.035997987f,0.939494f,0.035284996f,0.939494f,0.034877002f,0.910526f,0.035589993f,0.978359f,0.07600498f,0.949391f,0.07529199f,0.949391f,0.075699985f,0.978359f,0.076412976f,0.215776f,0.07472801f,0.215776f,0.11033797f,0.216185f,0.11033797f,0.216185f,0.07472801f,0.215776f,0.039117992f,0.216185f,0.039117992f,0.942354f,0.08533698f,0.971322f,0.08462298f,0.971322f,0.084214985f,0.942354f,0.084927976f,0.732049f,0.39782798f,0.732049f,0.44543803f,0.732457f,0.44543803f,0.732457f,0.39782798f,0.732049f,0.350219f,0.732457f,0.350219f,0.902356f,0.08462298f,0.931324f,0.08533698f,0.931324f,0.084927976f,0.902356f,0.084214985f,0.081854f,0.07472801f,0.081854f,0.039117992f,0.081446f,0.039117992f,0.081446f,0.07472801f,0.081854f,0.11033797f,0.081446f,0.11033797f,0.862358f,0.08533698f,0.891326f,0.08462298f,0.891326f,0.084214985f,0.862358f,0.084927976f,0.621579f,0.39782798f,0.621579f,0.44543803f,0.621987f,0.44543803f,0.621987f,0.39782798f,0.621579f,0.350219f,0.621987f,0.350219f,0.782362f,0.09878498f,0.81133f,0.09949899f,0.81133f,0.09909099f,0.782362f,0.09837699f,0.126002f,0.21961898f,0.126002f,0.255229f,0.126411f,0.255229f,0.126411f,0.21961898f,0.126002f,0.184008f,0.126411f,0.184008f,0.851328f,0.13879198f,0.82236f,0.13950598f,0.82236f,0.13991398f,0.851328f,0.13919997f,0.84252f,0.40503198f,0.84252f,0.45264202f,0.842928f,0.45264202f,0.842928f,0.40503198f,0.84252f,0.357423f,0.842928f,0.357423f);
    }
    private static void method38(){
        MESH_10.getFaces().ensureCapacity(5856);
        MESH_10.getFaces().addAll(0,0,1,1,2,2,0,0,3,3,1,1,0,0,4,4,3,3,0,0,5,5,4,4,0,0,6,6,5,5,0,0,7,7,6,6,0,0,8,8,7,7,0,0,9,9,8,8,0,0,10,10,9,9,0,0,11,11,10,10,0,0,12,12,11,11,0,0,13,13,12,12,0,0,14,14,13,13,0,0,15,15,14,14,0,0,16,16,15,15,0,0,2,2,16,16,2,17,1,18,17,19,2,17,17,19,18,20,1,18,3,21,19,22,1,18,19,22,17,19,3,23,4,24,20,25,3,23,20,25,19,26,4,24,5,27,21,28,4,24,21,28,20,25,5,27,6,29,22,30,5,27,22,30,21,28,6,29,7,31,23,32,6,29,23,32,22,30,7,33,8,34,24,35,7,33,24,35,23,36,8,34,9,37,25,38,8,34,25,38,24,35,9,37,10,39,26,40,9,37,26,40,25,38,10,39,11,41,27,42,10,39,27,42,26,40,11,43,12,44,28,45,11,43,28,45,27,46,12,44,13,47,29,48,12,44,29,48,28,45,13,47,14,49,30,50,13,47,30,50,29,48,14,49,15,51,31,52,14,49,31,52,30,50,15,53,16,54,32,55,15,53,32,55,31,56,16,54,2,17,18,20,16,54,18,20,32,55,33,57,34,58,35,59,33,57,35,59,36,60,17,61,19,62,37,63,17,61,37,63,38,64,19,62,20,65,39,66,19,62,39,66,37,63,40,67,41,68,42,69,40,67,42,69,43,70,41,68,44,71,45,72,41,68,45,72,42,69,22,73,23,74,46,75,22,73,46,75,47,76,23,74,24,77,48,78,23,74,48,78,46,75,49,79,50,80,51,81,49,79,51,81,52,82,50,80,53,83,54,84,50,80,54,84,51,81,26,85,27,86,55,87,26,85,55,87,56,88,27,86,28,89,57,90,27,86,57,90,55,87,58,91,59,92,60,93,58,91,60,93,61,94,59,92,62,95,63,96,59,92,63,96,60,93,30,97,31,98,64,99,30,97,64,99,65,100,31,98,32,101,66,102,31,98,66,102,64,99,67,103,33,57,36,60,67,103,36,60,68,104,69,105,38,106,70,107,69,105,70,107,71,108,38,106,37,109,72,110,38,106,72,110,70,107,37,111,39,112,73,113,37,111,73,113,72,114,39,112,74,115,75,116,39,112,75,116,73,113,74,115,47,117,76,118,74,115,76,118,75,116,47,117,46,119,77,120,47,117,77,120,76,118,46,121,48,122,78,123,46,121,78,123,77,124,48,122,79,125,80,126,48,122,80,126,78,123,79,125,56,127,81,128,79,125,81,128,80,126,56,127,55,129,82,130,56,127,82,130,81,128,55,131,57,132,83,133,55,131,83,133,82,134,57,132,84,135,85,136,57,132,85,136,83,133,84,135,65,137,86,138,84,135,86,138,85,136,65,137,64,139,87,140,65,137,87,140,86,138,64,141,66,142,88,143,64,141,88,143,87,144,66,142,69,105,71,108,66,142,71,108,88,143,71,108,70,107,89,145,71,108,89,145,90,146,70,107,72,110,91,147,70,107,91,147,89,145,72,114,73,113,92,148,72,114,92,148,91,149,73,113,75,116,93,150,73,113,93,150,92,148,75,116,76,118,94,151,75,116,94,151,93,150,76,118,77,120,95,152,76,118,95,152,94,151,77,124,78,123,96,153,77,124,96,153,95,154,78,123,80,126,97,155,78,123,97,155,96,153,80,126,81,128,98,156,80,126,98,156,97,155,81,128,82,130,99,157,81,128,99,157,98,156,82,134,83,133,100,158,82,134,100,158,99,159,83,133,85,136,101,160,83,133,101,160,100,158,85,136,86,138,102,161,85,136,102,161,101,160,86,138,87,140,103,162,86,138,103,162,102,161,87,144,88,143,104,163,87,144,104,163,103,164,88,143,71,108,90,146,88,143,90,146,104,163,90,146,89,145,105,165,90,146,105,165,106,166,89,145,91,147,107,167,89,145,107,167,105,165,91,149,92,148,108,168,91,149,108,168,107,169,92,148,93,150,109,170,92,148,109,170,108,168,93,150,94,151,110,171,93,150,110,171,109,170,94,151,95,152,111,172,94,151,111,172,110,171,95,154,96,153,112,173,95,154,112,173,111,174,96,153,97,155,113,175,96,153,113,175,112,173,97,155,98,156,114,176,97,155,114,176,113,175,98,156,99,157,115,177,98,156,115,177,114,176,99,159,100,158,116,178,99,159,116,178,115,179,100,158,101,160,117,180,100,158,117,180,116,178,101,160,102,161,118,181,101,160,118,181,117,180,102,161,103,162,119,182,102,161,119,182,118,181,103,164,104,163,120,183,103,164,120,183,119,184,104,163,90,146,106,166,104,163,106,166,120,183,106,166,105,165,121,185,106,166,121,185,122,186,105,165,107,167,123,187,105,165,123,187,121,185,107,169,108,168,124,188,107,169,124,188,123,189,108,168,109,170,125,190,108,168,125,190,124,188,109,170,110,171,126,191,109,170,126,191,125,190,110,171,111,172,127,192,110,171,127,192,126,191,111,174,112,173,128,193,111,174,128,193,127,194,112,173,113,175,129,195,112,173,129,195,128,193,113,175,114,176,130,196,113,175,130,196,129,195,114,176,115,177,131,197,114,176,131,197,130,196,115,179,116,178,132,198,115,179,132,198,131,199,116,178,117,180,133,200,116,178,133,200,132,198,117,180,118,181,134,201,117,180,134,201,133,200,118,181,119,182,135,202,118,181,135,202,134,201,119,184,120,183,136,203,119,184,136,203,135,204,120,183,106,166,122,186,120,183,122,186,136,203,122,205,121,206,137,207,122,205,137,207,138,208,121,206,123,209,139,210,121,206,139,210,137,207,123,209,124,211,140,212,123,209,140,212,139,210,124,211,125,213,141,214,124,211,141,214,140,212,125,213,126,215,142,216,125,213,142,216,141,214,126,215,127,217,143,218,126,215,143,218,142,216,127,217,128,219,144,220,127,217,144,220,143,218,128,219,129,221,145,222,128,219,145,222,144,220,129,221,130,223,146,224,129,221,146,224,145,222,130,223,131,225,147,226,130,223,147,226,146,224,131,225,132,227,148,228,131,225,148,228,147,226,132,227,133,229,149,230,132,227,149,230,148,228,133,229,134,231,150,232,133,229,150,232,149,230,134,231,135,233,151,234,134,231,151,234,150,232,135,233,136,235,152,236,135,233,152,236,151,234,136,235,122,205,138,208,136,235,138,208,152,236,138,237,137,238,153,239,138,237,153,239,154,240,137,238,139,241,155,242,137,238,155,242,153,239,139,243,140,244,156,245,139,243,156,245,155,246,140,244,141,247,157,248,140,244,157,248,156,245,141,247,142,249,158,250,141,247,158,250,157,248,142,249,143,251,159,252,142,249,159,252,158,250,143,253,144,254,160,255,143,253,160,255,159,256,144,254,145,257,161,258,144,254,161,258,160,255,145,257,146,259,162,260,145,257,162,260,161,258,146,259,147,261,163,262,146,259,163,262,162,260,147,263,148,264,164,265,147,263,164,265,163,266,148,264,149,267,165,268,148,264,165,268,164,265,149,267,150,269,166,270,149,267,166,270,165,268,150,269,151,271,167,272,150,269,167,272,166,270,151,273,152,274,168,275,151,273,168,275,167,276,152,274,138,237,154,240,152,274,154,240,168,275,154,277,153,278,169,279,154,277,169,279,170,280,153,278,155,281,171,282,153,278,171,282,169,279,155,281,156,283,172,284,155,281,172,284,171,282,156,283,157,285,173,286,156,283,173,286,172,284,157,285,158,287,174,288,157,285,174,288,173,286,158,287,159,289,175,290,158,287,175,290,174,288,159,289,160,291,176,292,159,289,176,292,175,290,160,291,161,293,177,294,160,291,177,294,176,292,161,293,162,295,178,296,161,293,178,296,177,294,162,295,163,297,179,298,162,295,179,298,178,296,163,297,164,299,180,300,163,297,180,300,179,298,164,299,165,301,181,302,164,299,181,302,180,300,165,301,166,303,182,304,165,301,182,304,181,302,166,303,167,305,183,306,166,303,183,306,182,304,167,305,168,307,184,308,167,305,184,308,183,306,168,307,154,277,170,280,168,307,170,280,184,308,170,309,169,310,185,311,170,309,185,311,186,312,169,310,171,313,187,314,169,310,187,314,185,311,171,315,172,316,188,317,171,315,188,317,187,318,172,316,173,319,189,320,172,316,189,320,188,317,173,319,174,321,190,322,173,319,190,322,189,320,174,321,175,323,191,324,174,321,191,324,190,322,175,325,176,326,192,327,175,325,192,327,191,328,176,326,177,329,193,330,176,326,193,330,192,327,177,329,178,331,194,332,177,329,194,332,193,330,178,331,179,333,195,334,178,331,195,334,194,332,179,335,180,336,196,337,179,335,196,337,195,338,180,336,181,339,197,340,180,336,197,340,196,337,181,339,182,341,198,342,181,339,198,342,197,340,182,341,183,343,199,344,182,341,199,344,198,342,183,345,184,346,200,347,183,345,200,347,199,348,184,346,170,309,186,312,184,346,186,312,200,347,186,312,185,311,201,349,186,312,201,349,202,350,185,311,187,314,203,351,185,311,203,351,201,349,187,318,188,317,204,352,187,318,204,352,203,353,188,317,189,320,205,354,188,317,205,354,204,352,189,320,190,322,206,355,189,320,206,355,205,354,190,322,191,324,207,356,190,322,207,356,206,355,191,328,192,327,208,357,191,328,208,357,207,358,192,327,193,330,209,359,192,327,209,359,208,357,193,330,194,332,210,360,193,330,210,360,209,359,194,332,195,334,211,361,194,332,211,361,210,360,195,338,196,337,212,362,195,338,212,362,211,363,196,337,197,340,213,364,196,337,213,364,212,362,197,340,198,342,214,365,197,340,214,365,213,364,198,342,199,344,215,366,198,342,215,366,214,365,199,348,200,347,216,367,199,348,216,367,215,368,200,347,186,312,202,350,200,347,202,350,216,367,202,350,201,349,217,369,202,350,217,369,218,370,201,349,203,351,219,371,201,349,219,371,217,369,203,353,204,352,220,372,203,353,220,372,219,373,204,352,205,354,221,374,204,352,221,374,220,372,205,354,206,355,222,375,205,354,222,375,221,374,206,355,207,356,223,376,206,355,223,376,222,375,207,358,208,357,224,377,207,358,224,377,223,378,208,357,209,359,225,379,208,357,225,379,224,377,209,359,210,360,226,380,209,359,226,380,225,379,210,360,211,361,227,381,210,360,227,381,226,380,211,363,212,362,228,382,211,363,228,382,227,383,212,362,213,364,229,384,212,362,229,384,228,382,213,364,214,365,230,385,213,364,230,385,229,384,214,365,215,366,231,386,214,365,231,386,230,385,215,368,216,367,232,387,215,368,232,387,231,388,216,367,202,350,218,370,216,367,218,370,232,387,218,389,217,390,233,391,218,389,233,391,234,392,217,390,219,393,235,394,217,390,235,394,233,391,219,393,220,395,236,396,219,393,236,396,235,394,220,395,221,397,237,398,220,395,237,398,236,396,221,397,222,399,238,400,221,397,238,400,237,398,222,399,223,401,239,402,222,399,239,402,238,400,223,401,224,403,240,404,223,401,240,404,239,402,224,403,225,405,241,406,224,403,241,406,240,404,225,405,226,407,242,408,225,405,242,408,241,406,226,407,227,409,243,410,226,407,243,410,242,408,227,409,228,411,244,412,227,409,244,412,243,410,228,411,229,413,245,414,228,411,245,414,244,412,229,413,230,415,246,416,229,413,246,416,245,414,230,415,231,417,247,418,230,415,247,418,246,416,231,417,232,419,248,420,231,417,248,420,247,418,232,419,218,389,234,392,232,419,234,392,248,420,234,421,233,422,249,423,234,421,249,423,250,424,233,422,235,425,251,426,233,422,251,426,249,423,235,427,236,428,252,429,235,427,252,429,251,430,236,428,237,431,253,432,236,428,253,432,252,429,237,431,238,433,254,434,237,431,254,434,253,432,238,433,239,435,255,436,238,433,255,436,254,434,239,437,240,438,256,439,239,437,256,439,255,440,240,438,241,441,257,442,240,438,257,442,256,439,241,441,242,443,258,444,241,441,258,444,257,442,242,443,243,445,259,446,242,443,259,446,258,444,243,447,244,448,260,449,243,447,260,449,259,450,244,448,245,451,261,452,244,448,261,452,260,449,245,451,246,453,262,454,245,451,262,454,261,452,246,453,247,455,263,456,246,453,263,456,262,454,247,457,248,458,264,459,247,457,264,459,263,460,248,458,234,421,250,424,248,458,250,424,264,459,250,461,249,462,265,463,250,461,265,463,266,464,249,462,251,465,267,466,249,462,267,466,265,463,251,465,252,467,268,468,251,465,268,468,267,466,252,467,253,469,269,470,252,467,269,470,268,468,253,469,254,471,270,472,253,469,270,472,269,470,254,471,255,473,271,474,254,471,271,474,270,472,255,473,256,475,272,476,255,473,272,476,271,474,256,475,257,477,273,478,256,475,273,478,272,476,257,477,258,479,274,480,257,477,274,480,273,478,258,479,259,481,275,482,258,479,275,482,274,480,259,481,260,483,276,484,259,481,276,484,275,482,260,483,261,485,277,486,260,483,277,486,276,484,261,485,262,487,278,488,261,485,278,488,277,486,262,487,263,489,279,490,262,487,279,490,278,488,263,489,264,491,280,492,263,489,280,492,279,490,264,491,250,461,266,464,264,491,266,464,280,492,266,464,265,463,281,493,266,464,281,493,282,494,265,463,267,466,283,495,265,463,283,495,281,493,267,466,268,468,284,496,267,466,284,496,283,495,268,468,269,470,285,497,268,468,285,497,284,496,269,470,270,472,286,498,269,470,286,498,285,497,270,472,271,474,287,499,270,472,287,499,286,498,271,474,272,476,288,500,271,474,288,500,287,499,272,476,273,478,289,501,272,476,289,501,288,500,273,478,274,480,290,502,273,478,290,502,289,501,274,480,275,482,291,503,274,480,291,503,290,502,275,482,276,484,292,504,275,482,292,504,291,503,276,484,277,486,293,505,276,484,293,505,292,504,277,486,278,488,294,506,277,486,294,506,293,505,278,488,279,490,295,507,278,488,295,507,294,506,279,490,280,492,296,508,279,490,296,508,295,507,280,492,266,464,282,494,280,492,282,494,296,508,282,509,281,510,297,511,282,509,297,511,298,512,281,510,283,513,299,514,281,510,299,514,297,511,283,515,284,516,300,517,283,515,300,517,299,518,284,516,285,519,301,520,284,516,301,520,300,517,285,519,286,521,302,522,285,519,302,522,301,520,286,521,287,523,303,524,286,521,303,524,302,522,287,525,288,526,304,527,287,525,304,527,303,528,288,526,289,529,305,530,288,526,305,530,304,527,289,529,290,531,306,532,289,529,306,532,305,530,290,531,291,533,307,534,290,531,307,534,306,532,291,535,292,536,308,537,291,535,308,537,307,538,292,536,293,539,309,540,292,536,309,540,308,537,293,539,294,541,310,542,293,539,310,542,309,540,294,541,295,543,311,544,294,541,311,544,310,542,295,545,296,546,312,547,295,545,312,547,311,548,296,546,282,509,298,512,296,546,298,512,312,547,298,549,297,550,313,551,298,549,313,551,314,552,297,550,299,553,315,554,297,550,315,554,313,551,299,553,300,555,316,556,299,553,316,556,315,554,300,555,301,557,317,558,300,555,317,558,316,556,301,557,302,559,318,560,301,557,318,560,317,558,302,559,303,561,319,562,302,559,319,562,318,560,303,561,304,563,320,564,303,561,320,564,319,562,304,563,305,565,321,566,304,563,321,566,320,564,305,565,306,567,322,568,305,565,322,568,321,566,306,567,307,569,323,570,306,567,323,570,322,568,307,569,308,571,324,572,307,569,324,572,323,570,308,571,309,573,325,574,308,571,325,574,324,572,309,573,310,575,326,576,309,573,326,576,325,574,310,575,311,577,327,578,310,575,327,578,326,576,311,577,312,579,328,580,311,577,328,580,327,578,312,579,298,549,314,552,312,579,314,552,328,580,314,581,313,582,329,583,314,581,329,583,330,584,313,582,315,585,331,586,313,582,331,586,329,583,315,587,316,588,332,589,315,587,332,589,331,590,316,588,317,591,333,592,316,588,333,592,332,589,317,591,318,593,334,594,317,591,334,594,333,592,318,593,319,595,335,596,318,593,335,596,334,594,319,597,320,598,336,599,319,597,336,599,335,600,320,598,321,601,337,602,320,598,337,602,336,599,321,601,322,603,338,604,321,601,338,604,337,602,322,603,323,605,339,606,322,603,339,606,338,604,323,607,324,608,340,609,323,607,340,609,339,610,324,608,325,611,341,612,324,608,341,612,340,609,325,611,326,613,342,614,325,611,342,614,341,612,326,613,327,615,343,616,326,613,343,616,342,614,327,617,328,618,344,619,327,617,344,619,343,620,328,618,314,581,330,584,328,618,330,584,344,619,330,584,329,583,345,621,330,584,345,621,346,622,329,583,331,586,347,623,329,583,347,623,345,621,331,590,332,589,348,624,331,590,348,624,347,625,332,589,333,592,349,626,332,589,349,626,348,624,333,592,334,594,350,627,333,592,350,627,349,626,334,594,335,596,351,628,334,594,351,628,350,627,335,600,336,599,352,629,335,600,352,629,351,630,336,599,337,602,353,631,336,599,353,631,352,629,337,602,338,604,354,632,337,602,354,632,353,631,338,604,339,606,355,633,338,604,355,633,354,632,339,610,340,609,356,634,339,610,356,634,355,635,340,609,341,612,357,636,340,609,357,636,356,634,341,612,342,614,358,637,341,612,358,637,357,636,342,614,343,616,359,638,342,614,359,638,358,637,343,620,344,619,360,639,343,620,360,639,359,640,344,619,330,584,346,622,344,619,346,622,360,639,346,641,345,642,361,643,346,641,361,643,362,644,345,642,347,645,363,646,345,642,363,646,361,643,347,645,348,647,364,648,347,645,364,648,363,646,348,647,349,649,365,650,348,647,365,650,364,648,349,649,350,651,366,652,349,649,366,652,365,650,350,651,351,653,367,654,350,651,367,654,366,652,351,653,352,655,368,656,351,653,368,656,367,654,352,655,353,657,369,658,352,655,369,658,368,656,353,657,354,659,370,660,353,657,370,660,369,658,354,659,355,661,371,662,354,659,371,662,370,660,355,661,356,663,372,664,355,661,372,664,371,662,356,663,357,665,373,666,356,663,373,666,372,664,357,665,358,667,374,668,357,665,374,668,373,666,358,667,359,669,375,670,358,667,375,670,374,668,359,669,360,671,376,672,359,669,376,672,375,670,360,671,346,641,362,644,360,671,362,644,376,672,362,673,361,674,377,675,362,673,377,675,378,676,361,674,363,677,379,678,361,674,379,678,377,675,363,677,364,679,380,680,363,677,380,680,379,678,364,679,365,681,381,682,364,679,381,682,380,680,365,681,366,683,382,684,365,681,382,684,381,682,366,683,367,685,383,686,366,683,383,686,382,684,367,685,368,687,384,688,367,685,384,688,383,686,368,687,369,689,385,690,368,687,385,690,384,688,369,689,370,691,386,692,369,689,386,692,385,690,370,691,371,693,387,694,370,691,387,694,386,692,371,693,372,695,388,696,371,693,388,696,387,694,372,695,373,697,389,698,372,695,389,698,388,696,373,697,374,699,390,700,373,697,390,700,389,698,374,699,375,701,391,702,374,699,391,702,390,700,375,701,376,703,392,704,375,701,392,704,391,702,376,703,362,673,378,676,376,703,378,676,392,704,378,676,377,675,393,705,378,676,393,705,394,706,377,675,379,678,395,707,377,675,395,707,393,705,379,678,380,680,396,708,379,678,396,708,395,707,380,680,381,682,397,709,380,680,397,709,396,708,381,682,382,684,398,710,381,682,398,710,397,709,382,684,383,686,399,711,382,684,399,711,398,710,383,686,384,688,400,712,383,686,400,712,399,711,384,688,385,690,401,713,384,688,401,713,400,712,385,690,386,692,402,714,385,690,402,714,401,713,386,692,387,694,403,715,386,692,403,715,402,714,387,694,388,696,404,716,387,694,404,716,403,715,388,696,389,698,405,717,388,696,405,717,404,716,389,698,390,700,406,718,389,698,406,718,405,717,390,700,391,702,407,719,390,700,407,719,406,718,391,702,392,704,408,720,391,702,408,720,407,719,392,704,378,676,394,706,392,704,394,706,408,720,394,721,393,722,409,723,394,721,409,723,410,724,393,722,395,725,411,726,393,722,411,726,409,723,395,727,396,728,412,729,395,727,412,729,411,730,396,728,397,731,413,732,396,728,413,732,412,729,397,731,398,733,414,734,397,731,414,734,413,732,398,733,399,735,415,736,398,733,415,736,414,734,399,737,400,738,416,739,399,737,416,739,415,740,400,738,401,741,417,742,400,738,417,742,416,739,401,741,402,743,418,744,401,741,418,744,417,742,402,743,403,745,419,746,402,743,419,746,418,744,403,747,404,748,420,749,403,747,420,749,419,750,404,748,405,751,421,752,404,748,421,752,420,749,405,751,406,753,422,754,405,751,422,754,421,752,406,753,407,755,423,756,406,753,423,756,422,754,407,757,408,758,424,759,407,757,424,759,423,760,408,758,394,721,410,724,408,758,410,724,424,759,410,761,409,762,425,763,410,761,425,763,426,764,409,762,411,765,427,766,409,762,427,766,425,763,411,765,412,767,428,768,411,765,428,768,427,766,412,767,413,769,429,770,412,767,429,770,428,768,413,769,414,771,430,772,413,769,430,772,429,770,414,771,415,773,431,774,414,771,431,774,430,772,415,773,416,775,432,776,415,773,432,776,431,774,416,775,417,777,433,778,416,775,433,778,432,776,417,777,418,779,434,780,417,777,434,780,433,778,418,779,419,781,435,782,418,779,435,782,434,780,419,781,420,783,436,784,419,781,436,784,435,782,420,783,421,785,437,786,420,783,437,786,436,784,421,785,422,787,438,788,421,785,438,788,437,786,422,787,423,789,439,790,422,787,439,790,438,788,423,789,424,791,440,792,423,789,440,792,439,790,424,791,410,761,426,764,424,791,426,764,440,792,426,764,425,763,441,793,425,763,427,766,441,793,427,766,428,768,441,793,428,768,429,770,441,793,429,770,430,772,441,793,430,772,431,774,441,793,431,774,432,776,441,793,432,776,433,778,441,793,433,778,434,780,441,793,434,780,435,782,441,793,435,782,436,784,441,793,436,784,437,786,441,793,437,786,438,788,441,793,438,788,439,790,441,793,439,790,440,792,441,793,440,792,426,764,441,793,18,20,17,19,442,794,18,20);
    }
    private static void method39(){
        MESH_10.getFaces().addAll(442,794,443,795,17,796,38,797,444,798,17,796,444,798,442,799,38,106,69,105,445,800,38,106,445,800,444,801,32,55,18,20,443,795,32,55,443,795,446,802,69,105,66,142,447,803,69,105,447,803,445,800,66,804,32,805,446,806,66,804,446,806,447,807,20,25,21,28,448,808,20,25,448,808,449,809,74,115,39,112,450,810,74,115,450,810,451,811,39,812,20,813,449,814,39,812,449,814,450,815,21,28,22,30,452,816,21,28,452,816,448,808,22,817,47,818,453,819,22,817,453,819,452,820,47,117,74,115,451,811,47,117,451,811,453,821,24,35,25,38,454,822,24,35,454,822,455,823,79,125,48,122,456,824,79,125,456,824,457,825,48,826,24,827,455,828,48,826,455,828,456,829,25,38,26,40,458,830,25,38,458,830,454,822,26,831,56,832,459,833,26,831,459,833,458,834,56,127,79,125,457,825,56,127,457,825,459,835,28,45,29,48,460,836,28,45,460,836,461,837,84,135,57,132,462,838,84,135,462,838,463,839,57,840,28,841,461,842,57,840,461,842,462,843,29,48,30,50,464,844,29,48,464,844,460,836,30,845,65,846,465,847,30,845,465,847,464,848,65,137,84,135,463,839,65,137,463,839,465,849,466,850,467,851,61,852,466,850,61,852,60,853,468,854,466,850,60,853,468,854,60,853,63,855,469,856,468,857,63,858,469,856,63,858,62,859,470,860,469,861,62,862,470,860,62,862,59,863,471,864,470,860,59,863,471,864,59,863,58,865,467,866,471,867,58,868,467,866,58,868,61,869,472,870,473,871,54,872,472,870,54,872,53,873,474,874,472,875,53,876,474,874,53,876,50,877,475,878,474,874,50,877,475,878,50,877,49,879,476,880,475,881,49,882,476,880,49,882,52,883,477,884,476,885,52,886,477,884,52,886,51,887,473,888,477,884,51,887,473,888,51,887,54,889,478,890,479,891,45,892,478,890,45,892,44,893,480,894,478,895,44,896,480,894,44,896,41,897,481,898,480,894,41,897,481,898,41,897,40,899,482,900,481,901,40,902,482,900,40,902,43,903,483,904,482,905,43,906,483,904,43,906,42,907,479,908,483,904,42,907,479,908,42,907,45,909,484,910,485,911,35,912,484,910,35,912,34,913,486,914,484,915,34,916,486,914,34,916,33,917,487,918,486,914,33,917,487,918,33,917,67,919,488,920,487,921,67,922,488,920,67,922,68,923,489,924,488,925,68,926,489,924,68,926,36,927,485,928,489,924,36,927,485,928,36,927,35,929,463,839,462,838,467,851,463,839,467,851,466,850,465,849,463,839,466,850,465,849,466,850,468,854,464,848,465,847,468,857,464,848,468,857,469,856,460,836,464,844,469,861,460,836,469,861,470,860,461,837,460,836,470,860,461,837,470,860,471,864,462,843,461,842,471,867,462,843,471,867,467,866,458,834,459,833,473,871,458,834,473,871,472,870,454,822,458,830,472,875,454,822,472,875,474,874,455,823,454,822,474,874,455,823,474,874,475,878,456,829,455,828,475,881,456,829,475,881,476,880,457,825,456,824,476,885,457,825,476,885,477,884,459,835,457,825,477,884,459,835,477,884,473,888,452,820,453,819,479,891,452,820,479,891,478,890,448,808,452,816,478,895,448,808,478,895,480,894,449,809,448,808,480,894,449,809,480,894,481,898,450,815,449,814,481,901,450,815,481,901,482,900,451,811,450,810,482,905,451,811,482,905,483,904,453,821,451,811,483,904,453,821,483,904,479,908,442,799,444,798,485,911,442,799,485,911,484,910,443,795,442,794,484,915,443,795,484,915,486,914,446,802,443,795,486,914,446,802,486,914,487,918,447,807,446,806,487,921,447,807,487,921,488,920,445,800,447,803,488,925,445,800,488,925,489,924,444,801,445,800,489,924,444,801,489,924,485,928);
    }
    private static void method40(){
        MESH_10.getFaceSmoothingGroups().ensureCapacity(976);
        MESH_10.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_12 = MESHVIEWS[11];
        MESHVIEWS[11].setId("duke_model duke_model_C_nose_geo");
        MESHVIEWS[11].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_11 = new PhongMaterial();
        MATERIAL_11.setDiffuseColor(new Color(1.0,0.25,0.25,1.0));
        MATERIAL_11.setSpecularColor(new Color(0.5,0.5,0.5,1.0));
        MATERIAL_11.setSpecularPower(18.0);
        MESHVIEWS[11].setMaterial(MATERIAL_11);
        MESH_11 = new TriangleMesh();
        MESHVIEWS[11].setMesh(MESH_11);
        MESH_11.getPoints().ensureCapacity(726);
        MESH_11.getPoints().addAll(0.0f,33.054165f,8.912951f,0.0f,33.268856f,10.328204f,1.345987f,33.054165f,9.890871f,0.958333f,32.982597f,9.009175f,2.733562f,32.45571f,9.440027f,1.4375f,32.612213f,8.349661f,0.0f,32.45571f,7.453969f,2.803437f,31.724577f,7.905839f,3.863175f,31.418396f,9.072991f,3.547083f,31.300331f,8.168041f,4.647746f,30.248575f,8.818066f,3.863175f,30.543728f,7.657731f,2.733562f,30.679348f,6.565776f,1.4375f,31.724577f,6.913423f,1.345987f,30.543728f,5.828886f,0.958333f,31.300331f,6.2872f,0.0f,30.248575f,5.44128f,0.0f,31.418396f,6.266225f,1.916667f,32.073578f,7.690142f,0.831867f,33.054165f,11.473169f,1.550617f,32.982597f,10.832034f,1.689436f,32.45571f,12.653513f,2.325925f,32.612213f,11.083948f,3.170121f,31.724577f,12.245879f,2.387571f,31.418396f,13.614418f,3.15055f,31.300331f,13.034152f,2.87246f,30.248575f,14.281814f,3.733558f,30.543728f,13.177077f,4.422998f,30.679348f,11.76532f,3.691863f,31.724577f,10.640127f,4.695041f,30.543728f,10.21795f,4.139367f,31.300331f,9.9909f,3.101233f,32.073578f,11.335859f,-0.831867f,33.054165f,11.473169f,0.0f,32.982597f,11.958618f,-1.689436f,32.45571f,12.653513f,0.0f,32.612213f,12.773828f,-0.844196f,31.724577f,13.935763f,-2.387571f,31.418396f,13.614418f,-1.599933f,31.300331f,14.160743f,-2.87246f,30.248575f,14.281814f,-1.555704f,30.543728f,14.759383f,-0.0f,30.679348f,14.978821f,0.844196f,31.724577f,13.935763f,1.555704f,30.543728f,14.759383f,1.599933f,31.300331f,14.160743f,0.0f,32.073578f,13.589035f,-1.345987f,33.054165f,9.890871f,-2.733562f,32.45571f,9.440027f,-2.325925f,32.612213f,11.083948f,-1.550617f,32.982597f,10.832034f,-3.691863f,31.724577f,10.640127f,-3.863175f,31.418396f,9.072991f,-4.139367f,31.300331f,9.9909f,-4.647746f,30.248575f,8.818066f,-4.695041f,30.543728f,10.21795f,-4.422998f,30.679348f,11.76532f,-3.170121f,31.724577f,12.245879f,-3.733558f,30.543728f,13.177077f,-3.15055f,31.300331f,13.034152f,-3.101233f,32.073578f,11.335859f,-1.4375f,32.612213f,8.349661f,-0.958333f,32.982597f,9.009175f,-1.4375f,31.724577f,6.913423f,-0.958333f,31.300331f,6.2872f,-1.345987f,30.543728f,5.828886f,-2.733562f,30.679348f,6.565776f,-2.803437f,31.724577f,7.905839f,-3.863175f,30.543728f,7.657731f,-3.547083f,31.300331f,8.168041f,-1.916667f,32.073578f,7.690142f,2.325925f,22.997997f,9.572473f,2.733562f,23.154497f,11.216393f,1.345987f,22.556053f,10.765542f,1.550617f,22.627617f,9.824383f,0.0f,22.341366f,10.328203f,0.831867f,22.556053f,9.183246f,1.689436f,23.154497f,8.002912f,3.733558f,25.066502f,7.479337f,4.422998f,24.93088f,8.891086f,3.170121f,23.885641f,8.410537f,3.15055f,24.309893f,7.622266f,2.387571f,24.191824f,7.042006f,2.87246f,25.361654f,6.374608f,4.695041f,25.0665f,10.438461f,4.647746f,25.361654f,11.838352f,3.863175f,24.191818f,11.583428f,4.139367f,24.309889f,10.665516f,3.691863f,23.88564f,10.016288f,3.101233f,23.536634f,9.320558f,1.4375f,22.997997f,12.306749f,0.0f,23.154497f,13.202435f,0.0f,22.556053f,11.743454f,0.958333f,22.627617f,11.647233f,3.863175f,25.0665f,12.998683f,2.733562f,24.93088f,14.09063f,2.803437f,23.88564f,12.750573f,3.547083f,24.309889f,12.488375f,1.345987f,25.0665f,14.827524f,0.0f,25.361654f,15.215137f,0.0f,24.191818f,14.390184f,0.958333f,24.309889f,14.369207f,1.4375f,23.88564f,13.742981f,1.916667f,23.536634f,12.966267f,-1.4375f,22.997997f,12.306749f,-2.733562f,23.154497f,11.216393f,-1.345987f,22.556053f,10.76554f,-0.958333f,22.627617f,11.647233f,-1.345987f,25.0665f,14.827524f,-2.733562f,24.93088f,14.09063f,-1.4375f,23.88564f,13.742981f,-0.958333f,24.309889f,14.369207f,-3.863175f,25.0665f,12.998683f,-4.647746f,25.361654f,11.838354f,-3.863175f,24.191818f,11.583428f,-3.547083f,24.309889f,12.488375f,-2.803437f,23.88564f,12.750573f,-1.916667f,23.536634f,12.966267f,-2.325925f,22.997997f,9.572473f,-1.689436f,23.154497f,8.002912f,-0.831867f,22.556053f,9.183246f,-1.550617f,22.627617f,9.824383f,-4.695041f,25.0665f,10.438461f,-4.422998f,24.93088f,8.891086f,-3.691863f,23.88564f,10.016288f,-4.139367f,24.309889f,10.665516f,-3.733558f,25.066502f,7.479337f,-2.87246f,25.361654f,6.374608f,-2.387571f,24.191824f,7.042006f,-3.15055f,24.309893f,7.622266f,-3.170121f,23.885641f,8.410537f,-3.101233f,23.536634f,9.320558f,0.0f,22.997997f,7.882598f,0.0f,22.627617f,8.6978f,-1.555704f,25.066502f,5.897039f,-0.0f,24.93088f,5.677602f,-0.844196f,23.885641f,6.720662f,-1.599933f,24.309893f,6.495683f,1.555704f,25.066502f,5.897039f,1.599933f,24.309893f,6.495683f,0.844196f,23.885641f,6.720662f,0.0f,23.536634f,7.067391f,2.325925f,29.278967f,5.69061f,1.550617f,29.669926f,5.471992f,1.689436f,27.805117f,5.128659f,0.831867f,29.128475f,5.121258f,4.695041f,29.128475f,7.928024f,4.139367f,29.669926f,7.352833f,4.422998f,27.805117f,7.114717f,3.691863f,29.278967f,6.683027f,3.170121f,27.842733f,5.964912f,3.733558f,26.481754f,6.604664f,3.15055f,26.947956f,5.99185f,2.387571f,26.481754f,5.626743f,3.101233f,28.812763f,6.059725f,5.129363f,29.278967f,11.107191f,5.0977f,29.669926f,10.302276f,5.467124f,27.805117f,10.328201f,5.209162f,29.128475f,9.510322f,3.733558f,29.128475f,14.051754f,4.108883f,29.669926f,13.345532f,4.422998f,27.805117f,13.5417f,4.607621f,29.278967f,12.712948f,5.129363f,27.842733f,11.994834f,4.695041f,26.481754f,12.728395f,5.0977f,26.947956f,11.984549f,5.209162f,26.481754f,11.146089f,5.0179f,28.812763f,11.958614f,0.844196f,29.278967f,15.447237f,1.599933f,29.669926f,15.168391f,1.689436f,27.805117f,15.527746f,2.387571f,29.128475f,15.02967f,-2.387571f,29.128475f,15.02967f,-1.599933f,29.669926f,15.168391f,-1.689436f,27.805117f,15.527746f,-0.844196f,29.278967f,15.447237f,0.0f,27.842733f,15.721531f,-0.831867f,26.481754f,15.535151f,0.0f,26.947956f,15.688242f,0.831867f,26.481754f,15.535151f,0.0f,28.812763f,15.604334f,-4.607621f,29.278967f,12.712948f,-4.108883f,29.669926f,13.345532f,-4.422998f,27.805117f,13.5417f,-3.733558f,29.128475f,14.051754f,-5.209162f,29.128475f,9.510322f,-5.0977f,29.669926f,10.302276f,-5.467124f,27.805117f,10.328201f,-5.129362f,29.278967f,11.107191f,-5.129362f,27.842733f,11.994834f,-5.209162f,26.481754f,11.146089f,-5.0977f,26.947956f,11.984549f,-4.695041f,26.481754f,12.728395f,-5.0179f,28.812763f,11.958614f,-3.691863f,29.278967f,6.683027f,-4.139367f,29.669926f,7.352833f,-4.422998f,27.805117f,7.114717f,-4.695041f,29.128475f,7.928024f,-0.831867f,29.128475f,5.121258f,-1.550617f,29.669926f,5.471992f,-1.689436f,27.805117f,5.128659f,-2.325925f,29.278967f,5.69061f,-3.170121f,27.842733f,5.964912f,-2.387571f,26.481754f,5.626743f,-3.15055f,26.947956f,5.99185f,-3.733558f,26.481754f,6.604664f,-3.101233f,28.812763f,6.059725f,5.0977f,25.940306f,10.354133f,5.129363f,26.33126f,9.549212f,4.607621f,26.33126f,7.943462f,4.108883f,25.940306f,7.310884f,5.0977f,28.662271f,8.671865f,5.129363f,27.767488f,8.661576f,5.0179f,26.797464f,8.697791f,1.550617f,25.940306f,15.184417f,2.325925f,26.33126f,14.965794f,3.691863f,26.33126f,13.973385f,4.139367f,25.940306f,13.303584f,3.15055f,28.662271f,14.664565f,3.170121f,27.767488f,14.691498f,3.101233f,26.797464f,14.596683f,-4.139367f,25.940306f,13.303584f,-3.691863f,26.33126f,13.973385f,-2.325925f,26.33126f,14.965794f,-1.550617f,25.940306f,15.184417f,-3.170121f,27.767488f,14.691498f,-3.15055f,28.662271f,14.664565f,-3.101233f,26.797464f,14.596683f,-4.108883f,25.940306f,7.310884f,-4.607621f,26.33126f,7.943462f,-5.129362f,26.33126f,9.549212f,-5.0977f,25.940306f,10.354133f,-5.129362f,27.767488f,8.661576f,-5.0977f,28.662271f,8.671865f,-5.0179f,26.797464f,8.697791f,1.599933f,25.940306f,5.488024f,0.844196f,26.33126f,5.209175f,-0.844196f,26.33126f,5.209175f,-1.599933f,25.940306f,5.488024f,0.0f,27.767488f,4.934873f,0.0f,28.662271f,4.968167f,0.0f,26.797462f,5.052075f);
    }
    private static void method41(){
        MESH_11.getTexCoords().ensureCapacity(2);
        MESH_11.getTexCoords().addAll(0.0f,0.0f);
    }
    private static void method42(){
        MESH_11.getFaces().ensureCapacity(2880);
        MESH_11.getFaces().addAll(0,0,1,0,2,0,0,0,2,0,3,0,2,0,4,0,5,0,2,0,5,0,3,0,5,0,6,0,0,0,5,0,0,0,3,0,7,0,4,0,8,0,7,0,8,0,9,0,8,0,10,0,11,0,8,0,11,0,9,0,11,0,12,0,7,0,11,0,7,0,9,0,13,0,12,0,14,0,13,0,14,0,15,0,14,0,16,0,17,0,14,0,17,0,15,0,17,0,6,0,13,0,17,0,13,0,15,0,5,0,4,0,7,0,5,0,7,0,18,0,7,0,12,0,13,0,7,0,13,0,18,0,13,0,6,0,5,0,13,0,5,0,18,0,2,0,1,0,19,0,2,0,19,0,20,0,19,0,21,0,22,0,19,0,22,0,20,0,22,0,4,0,2,0,22,0,2,0,20,0,23,0,21,0,24,0,23,0,24,0,25,0,24,0,26,0,27,0,24,0,27,0,25,0,27,0,28,0,23,0,27,0,23,0,25,0,29,0,28,0,30,0,29,0,30,0,31,0,30,0,10,0,8,0,30,0,8,0,31,0,8,0,4,0,29,0,8,0,29,0,31,0,22,0,21,0,23,0,22,0,23,0,32,0,23,0,28,0,29,0,23,0,29,0,32,0,29,0,4,0,22,0,29,0,22,0,32,0,19,0,1,0,33,0,19,0,33,0,34,0,33,0,35,0,36,0,33,0,36,0,34,0,36,0,21,0,19,0,36,0,19,0,34,0,37,0,35,0,38,0,37,0,38,0,39,0,38,0,40,0,41,0,38,0,41,0,39,0,41,0,42,0,37,0,41,0,37,0,39,0,43,0,42,0,44,0,43,0,44,0,45,0,44,0,26,0,24,0,44,0,24,0,45,0,24,0,21,0,43,0,24,0,43,0,45,0,36,0,35,0,37,0,36,0,37,0,46,0,37,0,42,0,43,0,37,0,43,0,46,0,43,0,21,0,36,0,43,0,36,0,46,0,47,0,48,0,49,0,47,0,49,0,50,0,49,0,35,0,33,0,49,0,33,0,50,0,33,0,1,0,47,0,33,0,47,0,50,0,51,0,48,0,52,0,51,0,52,0,53,0,52,0,54,0,55,0,52,0,55,0,53,0,55,0,56,0,51,0,55,0,51,0,53,0,57,0,56,0,58,0,57,0,58,0,59,0,58,0,40,0,38,0,58,0,38,0,59,0,38,0,35,0,57,0,38,0,57,0,59,0,49,0,48,0,51,0,49,0,51,0,60,0,51,0,56,0,57,0,51,0,57,0,60,0,57,0,35,0,49,0,57,0,49,0,60,0,0,0,6,0,61,0,0,0,61,0,62,0,61,0,48,0,47,0,61,0,47,0,62,0,47,0,1,0,0,0,47,0,0,0,62,0,63,0,6,0,17,0,63,0,17,0,64,0,17,0,16,0,65,0,17,0,65,0,64,0,65,0,66,0,63,0,65,0,63,0,64,0,67,0,66,0,68,0,67,0,68,0,69,0,68,0,54,0,52,0,68,0,52,0,69,0,52,0,48,0,67,0,52,0,67,0,69,0,61,0,6,0,63,0,61,0,63,0,70,0,63,0,66,0,67,0,63,0,67,0,70,0,67,0,48,0,61,0,67,0,61,0,70,0,71,0,72,0,73,0,71,0,73,0,74,0,73,0,75,0,76,0,73,0,76,0,74,0,76,0,77,0,71,0,76,0,71,0,74,0,78,0,79,0,80,0,78,0,80,0,81,0,80,0,77,0,82,0,80,0,82,0,81,0,82,0,83,0,78,0,82,0,78,0,81,0,84,0,85,0,86,0,84,0,86,0,87,0,86,0,72,0,88,0,86,0,88,0,87,0,88,0,79,0,84,0,88,0,84,0,87,0,80,0,79,0,88,0,80,0,88,0,89,0,88,0,72,0,71,0,88,0,71,0,89,0,71,0,77,0,80,0,71,0,80,0,89,0,90,0,91,0,92,0,90,0,92,0,93,0,92,0,75,0,73,0,92,0,73,0,93,0,73,0,72,0,90,0,73,0,90,0,93,0,94,0,95,0,96,0,94,0,96,0,97,0,96,0,72,0,86,0,96,0,86,0,97,0,86,0,85,0,94,0,86,0,94,0,97,0,98,0,99,0,100,0,98,0,100,0,101,0,100,0,91,0,102,0,100,0,102,0,101,0,102,0,95,0,98,0,102,0,98,0,101,0,96,0,95,0,102,0,96,0,102,0,103,0,102,0,91,0,90,0,102,0,90,0,103,0,90,0,72,0,96,0,90,0,96,0,103,0,104,0,105,0,106,0,104,0,106,0,107,0,106,0,75,0,92,0,106,0,92,0,107,0,92,0,91,0,104,0,92,0,104,0,107,0,108,0,109,0,110,0,108,0,110,0,111,0,110,0,91,0,100,0,110,0,100,0,111,0,100,0,99,0,108,0,100,0,108,0,111,0,112,0,113,0,114,0,112,0,114,0,115,0,114,0,105,0,116,0,114,0,116,0,115,0,116,0,109,0,112,0,116,0,112,0,115,0,116,0,105,0,104,0,116,0,104,0,117,0,104,0,91,0,110,0,104,0,110,0,117,0,110,0,109,0,116,0,110,0,116,0,117,0,118,0,119,0,120,0,118,0,120,0,121,0,120,0,75,0,106,0,120,0,106,0,121,0,106,0,105,0,118,0,106,0,118,0,121,0,122,0,123,0,124,0,122,0,124,0,125,0,124,0,105,0,114,0,124,0,114,0,125,0,114,0,113,0,122,0,114,0,122,0,125,0,126,0,127,0,128,0,126,0,128,0,129,0,128,0,119,0,130,0,128,0,130,0,129,0,130,0,123,0,126,0,130,0,126,0,129,0,130,0,119,0,118,0,130,0,118,0,131,0,118,0,105,0,124,0,118,0,124,0,131,0,124,0,123,0,130,0,124,0,130,0,131,0,132,0,77,0,76,0,132,0,76,0,133,0,76,0,75,0,120,0,76,0,120,0,133,0,120,0,119,0,132,0,120,0,132,0,133,0,134,0,135,0,136,0,134,0,136,0,137,0,136,0,119,0,128,0,136,0,128,0,137,0,128,0,127,0,134,0,128,0,134,0,137,0,138,0,83,0,82,0,138,0,82,0,139,0,82,0,77,0,140,0,82,0,140,0,139,0,140,0,135,0,138,0,140,0,138,0,139,0,136,0,135,0,140,0,136,0,140,0,141,0,140,0,77,0,132,0,140,0,132,0,141,0,132,0,119,0,136,0,132,0,136,0,141,0,14,0,12,0,142,0,14,0,142,0,143,0,142,0,144,0,145,0,142,0,145,0,143,0,145,0,16,0,14,0,145,0,14,0,143,0,11,0,10,0,146,0,11,0,146,0,147,0,146,0,148,0,149,0,146,0,149,0,147,0,149,0,12,0,11,0,149,0,11,0,147,0,150,0,148,0,151,0,150,0,151,0,152,0,151,0,83,0,153,0,151,0,153,0,152,0,153,0,144,0,150,0,153,0,150,0,152,0,142,0,12,0,149,0,142,0,149,0,154,0,149,0,148,0,150,0,149,0,150,0,154,0,150,0,144,0,142,0,150,0,142,0,154,0,30,0,28,0,155,0,30,0,155,0,156,0,155,0,157,0,158,0,155,0,158,0,156,0,158,0,10,0,30,0,158,0,30,0,156,0,27,0,26,0,159,0,27,0,159,0,160,0,159,0,161,0,162,0,159,0,162,0,160,0,162,0,28,0,27,0,162,0,27,0,160,0,163,0,161,0,164,0,163,0,164,0,165,0,164,0,85,0,166,0,164,0,166,0,165,0,166,0,157,0,163,0,166,0,163,0,165,0,155,0,28,0,162,0,155,0,162,0,167,0,162,0,161,0,163,0,162,0,163,0,167,0,163,0,157,0,155,0,163,0,155,0,167,0,44,0,42,0,168,0,44,0,168,0,169,0,168,0,170,0,171,0,168,0,171,0,169,0,171,0,26,0,44,0,171,0,44,0,169,0,41,0,40,0,172,0,41,0,172,0,173,0,172,0,174,0,175,0,172,0,175,0,173,0,175,0,42,0,41,0,175,0,41,0,173,0,176,0,174,0,177,0,176,0,177,0,178,0,177,0,99,0,179,0,177,0,179,0,178,0,179,0,170,0,176,0,179,0,176,0,178,0,175,0,174,0,176,0,175,0,176,0,180,0,176,0,170,0,168,0,176,0,168,0,180,0,168,0,42,0,175,0,168,0,175,0,180,0,58,0,56,0,181,0,58,0,181,0,182,0,181,0,183,0,184,0,181,0,184,0,182,0,184,0,40,0,58,0,184,0,58,0,182,0,55,0,54,0,185,0,55,0,185,0,186,0,185,0,187,0,188,0,185,0,188,0,186,0,188,0,56,0,55,0,188,0,55,0,186,0,189,0,187,0,190,0,189,0,190,0,191,0,190,0,113,0,192,0,190,0,192,0,191,0,192,0,183,0,189,0,192,0,189,0,191,0,188,0,187,0,189,0,188,0,189,0,193,0,189,0,183,0,181,0,189,0,181,0,193,0,181,0,56,0,188,0,181,0,188,0,193,0,68,0,66,0,194,0,68,0,194,0,195,0,194,0,196,0,197,0,194,0,197,0,195,0,197,0,54,0,68,0,197,0,68,0,195,0,65,0,16,0,198,0,65,0,198,0,199,0,198,0,200,0,201,0,198,0,201,0,199,0,201,0,66,0,65,0,201,0,65,0,199,0,202,0,200,0,203,0,202,0,203,0,204,0,203,0,127,0,205,0,203,0,205,0,204,0,205,0,196,0,202,0,205,0,202,0,204,0,201,0,200,0,202,0,201,0,202,0,206,0,202,0,196,0,194,0,202,0,194,0,206,0,194,0,66,0,201,0,194,0,201,0,206,0,166,0,85,0,84,0,166,0,84,0,207,0,84,0,79,0,208,0,84,0,208,0,207,0,208,0,157,0,166,0,208,0,166,0,207,0,151,0,148,0,209,0,151,0,209,0,210,0,209,0,79,0,78,0,209,0,78,0,210,0,78,0,83,0,151,0,78,0,151,0,210,0,146,0,10,0,158,0,146,0,158,0,211,0,158,0,157,0,212,0,158,0,212,0,211,0,212,0,148,0,146,0,212,0,146,0,211,0,212,0,157,0,208,0,212,0,208,0,213,0,208,0,79,0,209,0,208,0,209,0,213,0,209,0,148,0,212,0,209,0,212,0,213,0,179,0,99,0,98,0,179,0,98,0,214,0,98,0,95,0,215,0,98,0,215,0,214,0,215,0,170,0,179,0,215,0,179,0,214,0,164,0,161,0,216,0,164,0,216,0,217,0,216,0,95,0,94,0,216,0,94,0,217,0,94,0,85,0,164,0,94,0,164,0,217,0,159,0,26,0,171,0,159,0,171,0,218,0,171,0,170,0,219,0,171,0,219,0,218,0,219,0,161,0,159,0,219,0,159,0,218,0,219,0,170,0,215,0,219,0,215,0,220,0,215,0,95,0,216,0,215,0,216,0,220,0,216,0,161,0,219,0,216,0,219,0,220,0,192,0,113,0,112,0,192,0,112,0,221,0,112,0,109,0,222,0,112,0,222,0,221,0,222,0,183,0,192,0,222,0,192,0,221,0,177,0,174,0,223,0,177,0,223,0,224,0,223,0,109,0,108,0,223,0,108,0,224,0,108,0,99,0,177,0,108,0,177,0,224,0,184,0,183,0,225,0,184,0,225,0,226,0,225,0,174,0,172,0,225,0,172,0,226,0,172,0,40,0,184,0,172,0,184,0,226,0,225,0,183,0,222,0,225,0,222,0,227,0,222,0,109,0,223,0,222,0,223,0,227,0,223,0,174,0,225,0,223,0,225,0,227,0,205,0,127,0,126,0,205,0,126,0,228,0,126,0,123,0,229,0,126,0,229,0,228,0,229,0,196,0,205,0,229,0,205,0,228,0,190,0,187,0,230,0,190,0,230,0,231,0,230,0,123,0,122,0,230,0,122,0,231,0,122,0,113,0,190,0,122,0,190,0,231,0,197,0,196,0,232,0,197,0,232,0,233,0,232,0,187,0,185,0,232,0,185,0,233,0,185,0,54,0,197,0,185,0,197,0,233,0,232,0,196,0,229,0,232,0,229,0,234,0,229,0,123,0,230,0,229,0,230,0,234,0,230,0,187,0,232,0,230,0,232,0,234,0,153,0,83,0,138,0,153,0,138,0,235,0,138,0,135,0,236,0,138,0,236,0,235,0,236,0,144,0,153,0,236,0,153,0,235,0,203,0,200,0,237,0,203,0,237,0,238,0,237,0,135,0,134,0,237,0,134,0,238,0,134,0,127,0,203,0,134,0,203,0,238,0,145,0,144,0,239,0,145,0,239,0,240,0,239,0,200,0,198,0,239,0,198,0,240,0,198,0,16,0,145,0,198,0,145,0,240,0,239,0,144,0,236,0,239,0,236,0,241,0,236,0,135,0,237,0,236,0,237,0,241,0,237,0,200,0,239,0,237,0,239,0,241,0);
    }
    private static void method43(){
        MESH_11.getFaceSmoothingGroups().ensureCapacity(480);
        MESH_11.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_0 = new Group(NODE_1,NODE_2,NODE_3,NODE_4,NODE_5,NODE_6,NODE_7,NODE_8,NODE_9,NODE_10,NODE_11,NODE_12);
    }
    private static void method44(){
    }
    static {
        method0();
        method1();
        method2();
        method3();
        method4();
        method5();
        method6();
        method7();
        method8();
        method9();
        method10();
        method11();
        method12();
        method13();
        method14();
        method15();
        method16();
        method17();
        method18();
        method19();
        method20();
        method21();
        method22();
        method23();
        method24();
        method25();
        method26();
        method27();
        method28();
        method29();
        method30();
        method31();
        method32();
        method33();
        method34();
        method35();
        method36();
        method37();
        method38();
        method39();
        method40();
        method41();
        method42();
        method43();
        method44();
        // ======== TIMELINE CODE ===============
        // ======== SET PUBLIC VARS ===============
        Map<String,MeshView> meshViewMap = new HashMap<String,MeshView>();
        for (MeshView meshView: MESHVIEWS) meshViewMap.put(meshView.getId(),meshView);
        MESHVIEW_MAP = Collections.unmodifiableMap(meshViewMap);
        ROOT = NODE_0;
    }
}
