# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 137-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53400);
 script_bugtraq_id(5352);
 script_cve_id("CVE-2002-0658");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 137-1 (mm)";
 script_name(name);

 desc = "The remote host is missing an update to mm
announced via advisory DSA 137-1.

Marcus Meissner and Sebastian Krahmer discovered and fixed a temporary
file vulnerability in the mm shared memory library.  This problem can
be exploited to gain root access to a machine running Apache which is
linked against this library, if shell access to the user ``www-data''
is already available (which could easily be triggered through PHP).

This problem has been fixed in the upstream version 1.2.0 of mm, which
will be uploaded to the unstable Debian distribution while this
advisory is released.  Fixed packages for potato (Debian 2.2) and
woody (Debian 3.0) are linked below.

We recommend that you upgrade your libmm packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20137-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 137-1 (mm)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmm10", ver:"1.0.11-1.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmm10-dev", ver:"1.0.11-1.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmm11", ver:"1.1.3-6.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmm11-dev", ver:"1.1.3-6.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
