# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 736-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53983);
 script_cve_id("CVE-2005-1266");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 736-1 (spamassassin)";
 script_name(name);

 desc = "The remote host is missing an update to spamassassin
announced via advisory DSA 736-1.

A vulnerability was recently found in the way that SpamAssassin parses
certain email headers. This vulnerability could cause SpamAssassin to
consume a large number of CPU cycles when processing messages containing
these headers, leading to a potential denial of service (DOS) attack.

The version of SpamAssassin in the old stable distribution (woody) is
not vulnerable.

For the stable distribution (sarge), this problem has been fixed in
version 3.0.3-2. Note that packages are not yet ready for certain
architectures; these will be released as they become available.

For the unstable distribution (sid), this problem has been fixed in
version 3.0.4-1.

We recommend that you upgrade your sarge or sid spamassassin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20736-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 736-1 (spamassassin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"spamassassin", ver:"3.0.3-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spamc", ver:"3.0.3-2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
