###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-066.nasl 5261 2009-11-12 00:52:09Z nov $
#
# Microsoft Windows Active Directory Denial of Service Vulnerability (973309)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901048);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1928");
  script_bugtraq_id(36918);
  script_name("Microsoft Windows Active Directory Denial of Service Vulnerability (973309)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-066.

  Vulnerability Insight:
  This issue is caused by an error in implementations of Active Directory
  Application Mode (ADAM) and Active Directory Lightweight Directory Service
  (AD LDS) when processing malformed LDAP or LDAPS requests.

  Impact:
  Successful exploitation will let the attacker crash the server which may result
  in Denial of Service.

  Impact Level: System/Application.

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2K3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-066.mspx

  References:
  http://support.microsoft.com/kb/973037
  http://support.microsoft.com/kb/973039
  http://www.vupen.com/english/advisories/2009/3192
  http://www.microsoft.com/technet/security/bulletin/ms09-066.mspx

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adamdsa.dll and Ntdsa.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Active Directory
if((hotfix_missing(name:"973037") == 1) &&
   registry_key_exists(key:"SYSTEM\CurrentControlSet\Services\NTDS\Performance"))
{
  dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(dllPath != NULL)
  {
    # Get the version of Active Directory
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
    ntdsaFile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                             string:dllPath + "\Ntdsa.dll");
    ntdsaVer = GetVer(file:ntdsaFile, share:share);
    if(ntdsaVer != NULL)
    {
      # Windows 2K
      if(hotfix_check_sp(win2k:5) > 0)
      {
        # Check for Ntdsa.dll version < 5.0.2195.7313
        if(version_is_less(version:ntdsaVer, test_version:"5.0.2195.7313"))
        {
          security_hole(0);
          exit(0);
        }
      }
      # Windows 2K3
      else if(hotfix_check_sp(win2003:3) > 0)
      {
        SP = get_kb_item("SMB/Win2003/ServicePack");
        if("Service Pack 2" >< SP)
        {
          # Check for Ntdsa.dll version < 5.2.3790.4568
          if(version_is_less(version:ntdsaVer, test_version:"5.2.3790.4568")){
            security_hole(0);
          }
          exit(0);
        }
        security_hole(0);
      }
    }
  }
}

# Active Directory Application Mode
if((hotfix_missing(name:"973039") == 1) &&
   registry_key_exists(key:"SYSTEM\CurrentControlSet\Services\ADAM\Linkage"))
{
  dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(dllPath != NULL)
  {
    # Get the version of Active Directory Application Mode
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
    adamdsaFile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                              string:dllPath - "system32" + "ADAM\Adamdsa.dll");
    adamdsaVer = GetVer(file:adamdsaFile, share:share);
    if(adamdsaVer != NULL)
    {
      # Windows XP/2K3
      if(hotfix_check_sp(xp:4, win2003:3) > 0)
      {
        XPSP = get_kb_item("SMB/WinXP/ServicePack");
        k3SP = get_kb_item("SMB/Win2003/ServicePack");
        if(XPSP =~ "Service Pack (2|3)" || ("Service Pack 2" >< k3SP))
        {
          # Check for Adamdsa.dll version < 1.1.3790.4569
          if(version_is_less(version:adamdsaVer, test_version:"1.1.3790.4569")){
            security_hole(0);
          }
          exit(0);
        }
        security_hole(0);
      }
    }
  }
}
