###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_viplay_detect.nasl 2376 2009-05-25 13:36:29Z may $
#
# URUWorks ViPlay Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900360);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("URUWorks ViPlay Version Detection");
  desc = "
  Overview: This script is detects the installed version of ViPlay Media
  Player and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of ViPlay Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

viplayKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:viplayKey)){
    exit(0);
}

foreach item (registry_enum_keys(key:viplayKey))
{
  viplayName = registry_get_sz(key:viplayKey + item, item:"DisplayName");
  if("URUSoft ViPlay" >< viplayName)
  {
    viplayPath = registry_get_sz(key:viplayKey + item, item:"UninstallString");
    viplayPath = ereg_replace(pattern:'"', string:viplayPath, replace:"");
  }

  if(viplayPath != NULL)
  {
    foreach viplay (make_list("ViPlay.exe", "ViPlay3.exe", "ViPlay4.exe"))
    {
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:viplayPath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                          string:viplayPath - "uninstall.exe" + viplay);
      viplayVer = GetVer(file:file, share:share);
      if(viplayVer != NULL){
        set_kb_item(name:"ViPlay/MediaPlayer/Ver", value:viplayVer);
        security_note(data:"ViPlay Media Player version " + viplayVer +
                           " was detected on the host");
      }
    }
  }
}
