# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-761-2 (php5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64148);
 script_cve_id("CVE-2008-5814", "CVE-2009-1271", "CVE-2009-0798", "CVE-2009-1313");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-761-2 (php5)";
 script_name(name);

 desc = "The remote host is missing an update to php5
announced via advisory USN-761-2.

Details follow:

USN-761-1 fixed vulnerabilities in PHP.
This update provides the corresponding updates for Ubuntu 9.04.

Original advisory details:

 It was discovered that PHP did not sanitize certain error messages when
 display_errors is enabled, which could result in browsers becoming
 vulnerable to cross-site scripting attacks when processing the output.
 With cross-site scripting vulnerabilities, if a user were tricked into
 viewing server output during a crafted server request, a remote attacker
 could exploit this to modify the contents, or steal confidential data
 (such as passwords), within the same domain. (CVE-2008-5814)
 
 It was discovered that PHP did not properly handle certain malformed
 strings when being parsed by the json_decode function. A remote attacker
 could exploit this flaw and cause the PHP server to crash, resulting in a
 denial of service. This issue only affected Ubuntu 8.04 and 8.10.
 (CVE-2009-1271)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.04:
  libapache2-mod-php5             5.2.6.dfsg.1-3ubuntu4.1
  php5-cgi                        5.2.6.dfsg.1-3ubuntu4.1
  php5-cli                        5.2.6.dfsg.1-3ubuntu4.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-761-2

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-761-2 (php5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dbg", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5filter", ver:"5.2.6.dfsg.1-3ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acpid", ver:"1.0.4-1ubuntu11.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acpid", ver:"1.0.4-5ubuntu9.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acpid", ver:"1.0.6-9ubuntu4.8.10.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acpid", ver:"1.0.6-9ubuntu4.9.04.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-venkman", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dom-inspector", ver:"1.9.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-venkman", ver:"1.9.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0", ver:"3.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dev", ver:"1.9.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.10+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abrowser", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-venkman", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dom-inspector", ver:"1.9.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-venkman", ver:"1.9.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abrowser-3.0-branding", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-branding", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dev", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0", ver:"3.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dev", ver:"1.9.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.10+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abrowser", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-venkman", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dom-inspector", ver:"1.9.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-venkman", ver:"1.9.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abrowser-3.0-branding", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-branding", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dev", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-gnome-support", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0", ver:"3.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dev", ver:"1.9.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.10+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
