/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment Boilerplate plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <pgm/pgm.h>
#include "pgmbpviewport.h"

GST_DEBUG_CATEGORY (pgm_bp_debug);
#define GST_CAT_DEFAULT pgm_bp_debug

static gboolean
pgm_bp_init (GTypeModule *module)
{
  GST_DEBUG_CATEGORY_INIT (pgm_bp_debug, "pgm_bp", 0,
                           "Pigment boilerplate viewport");

  pgm_bp_viewport_register (module);

  return TRUE;
}

static gboolean
pgm_bp_shutdown (GTypeModule *module)
{
  return TRUE;
}

PGM_PLUGIN_DEFINE
(
  (PgmPluginInitFunc) pgm_bp_init,
  (PgmPluginShutdownFunc) pgm_bp_shutdown,
  (PgmPluginCreateFunc) pgm_bp_viewport_new,
  "boilerplate", VERSION,
  "A boilerplate viewport used for tests", "LGPL",
  "https://code.fluendo.com/pigment/trac",
  "Loïc Molinari <loic@fluendo.com>"
)
