# Mandatory perl modules :

sub test_PerlModules_Mandatory()
{
	if ( eval( 'require 5.006_000' ) )
	{
		my_print('green','perl',"You have perl v5.6.0 or newer");
	}
	else
	{
		my_print('red','perl',"Your perl version is too old, you need at least perl v5.6.0 ; Make 'perl -V' to knew exactly which version you have");
	}

	if ( eval( 'require Socket' ) )
	{
		my_print('green','Socket',"Network routines, name resolution ok");
	}
	else
	{
		my_print('red','Socket',"Socket module is mandatory");
	}

	if ( eval( 'require CGI' ) )
	{
		my_print('green','CGI',"You have the CGI module");
	}
	else
	{
		my_print('red','CGI',"You have to install the CGI module");
	}

	if ( eval( 'require DBI' ) )
	{
		my_print('green','DBI',"You have generic DB access module");

		my $db_mysql = eval( 'require DBD::mysql' );
		my $db_pgsql = eval( 'require DBD::Pg' );

		if ( $db_mysql or $db_pgsql )
		{
			my_print('green','&nbsp;+ DBD',"You have, at least, one specific DB access module");
		}
		else
		{
			my_print('red','&nbsp;+ DBD',"Both DBD::mysql and DBD::Pg are missing. you need at least one to access to prelude DB");
		}
	}
	else
	{
		my_print('red','DBI',"Generic database access module : DBI is not installed");
	}

	if ( eval( 'require Date::Calc' ) )
	{
		my_print('green','Date::Calc',"Date manipulations");
	}
	else
	{
		my_print('red','Date::Calc',"Date manipulations");
	}
}

# Optionnal perl modules :

sub test_PerlModules_Optionnal()
{
	if ( eval( 'require Geo::IP' ) )
	{
		my_print('green','Geo::IP',"Country look-up for an IP address");
	}
	else
	{
		my_print('orange','Geo::IP',"Country look-up for an IP address");
	}

	if ( $conf{'default_backend'} eq 'GD' )
	{
		if ( eval( 'require GD' ) )
		{
			my_print('green','GD',"PNG Image generation");
		}
		else
		{
			my_print('orange','GD',"PNG Image generation");
		}

		if ( eval( 'require GD::Text' ) )
		{
			my_print('green','&nbsp;+ GD::Text',"Text inside PNG generated images");
		}
		else
		{
			my_print('orange','&nbsp;+ GD::Text',"Text inside PNG generated images");
		}

		if ( eval( 'require GD::Graph' ) )
		{
			my_print('green','&nbsp;+ GD::Graph',"2D Graph generator");
		}
		else
		{
			my_print('orange','&nbsp;+ GD::Graph',"2D Graph generator");
		}

		if ( eval( 'require GD::Graph3d' ) )
		{
			my_print('green','&nbsp;&nbsp;+ GD::Graph3d',"3D Graph generator");
		}
		else
		{
			my_print('orange','&nbsp;&nbsp;+ GD::Graph3d',"3D Graph generator");
		}
	}

	if ( $conf{'default_backend'} eq 'PS' )
	{
		if ( -f $conf{'gs_path'} )
		{
			my_print('green',"Ghostscript","Ghostscript (postscript generation tool) has been found");
		}
		else
		{
			my_print('red',"Ghostscript","Ghostscript (postscript generation tool) has not been found in $conf{'gs_path'}");
		}

		if ( eval( 'require PDF::API2' ) )
		{
			my_print('green',"PDF::API2","PDF::API2 (PDF report generation) has been found");
		}
		else
		{
			my_print('orange',"PDF::API2","PDF::API2 (PDF report generation) has not been found");
		}
	}
}

# Write permissions :

sub test_write_permissions($)
{
	my $path = shift;

	local *TEMP;
	if ( open( TEMP, '>'.$path.'/generated/_tempfile' ) )
	{
		my_print('green','generated/ directory perms',"generated/ sub-dir is writable by this webserver");
		close( TEMP );
		unlink $path.'/generated/_tempfile';
	}
	else
	{
		my_print('red','generated/ directory perms',"generated/ sub-dir is not writable by this webserver : $! . Do chown -R apacheuser.apachegrp generated/");
	}

	if ( open( TEMP, $path.'/Profiles/admin.user' ) )
	{
		my_print('green','Profiles/ directory perms',"Profiles/ sub-dir is readable by this webserver");
		close( TEMP );
	}
	else
	{
		my_print('red','Profiles/ directory perms',"Profiles/ sub-dir is not readable by this webserver : $! . Do chown -R apacheuser.apachegrp Profiles/");
	}
}

sub test_db_access()
{
	if ( my $dbh = DB_Open() )
	{
		my_print('green','DB access configuration','this script could have access to prelude DB');
	}
	else
	{
	  my $db_mysql=eval('require DBD::mysql');
	  my $db_pgsql=eval('require DBD::Pg');

	  if ($db_mysql or $db_pgsql)
	  {
	    my_print('red','DB access configuration','this script could have not access to prelude DB (might be a Functions/config.pl misconfiguration)');
	  }
	  else
	  {
	    my_print('red','DB access configuration','this script could have not access to prelude DB (that is normal, DBI or DBD is missing)');
	  }
	}
}

sub test_password_protection()
{
	if ( $::ENV{'REMOTE_USER'} )
	{
		my_print('green','password-protection','piwi directory is password protected. look at Docs/user_file_format.txt to create profiles with privilege separation');
	}
	else
	{
		my_print('orange','password-protection','piwi directory is not password protected. look at Docs/user_file_format.txt and modify Profiles/guest.user accordingly');
	}
}

1;
