
# CMSIS: framework for [PlatformIO](https://platformio.org)

The ARM Cortex Microcontroller Software Interface Standard (CMSIS) is a vendor-independent hardware abstraction layer for the Cortex-M processor series and specifies debugger interfaces. The CMSIS enables consistent and simple software interfaces to the processor for interface peripherals, real-time operating systems, and middleware. It simplifies software re-use, reducing the learning curve for new microcontroller developers and cutting the time-to-market for devices.

* [Home](https://platformio.org/frameworks/cmsis) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/cmsis.html)

# Examples

- [ST STM32](https://github.com/platformio/platform-ststm32)
  * [arduino-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-internal-libs)
  * [arduino-mxchip-azureiot](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-azureiot)
  * [arduino-mxchip-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-filesystem)
  * [arduino-mxchip-sensors](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-sensors)
  * [arduino-mxchip-wifiscan](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-wifiscan)
  * [cmsis-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/cmsis-blink)
  * [libopencm3-1bitsy](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-1bitsy)
  * [libopencm3-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-blink)
  * [mbed-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-blink)
  * [mbed-custom-target](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-custom-target)
  * [mbed-dsp](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-events)
  * [mbed-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-filesystem)
  * [mbed-rtos](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos)
  * [mbed-rtos-ethernet](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet)
  * [mbed-rtos-ethernet-tls](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet-tls)
  * [mbed-rtos-mesh-minimal](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-mesh-minimal)
  * [mbed-rtos-semaphore](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-semaphore)
  * [mbed-serial](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-serial)
  * [spl-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/spl-blink)
  * [stm32cube-hal-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-blink)
  * [stm32cube-ll-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-ll-blink)
  * [zephyr-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-blink)
  * [zephyr-cpp-synchronization](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-cpp-synchronization)
  * [zephyr-drivers-can](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-drivers-can)
  * [zephyr-net-https-client](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-net-https-client)
  * [zephyr-subsys-usb-hid-mouse](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-subsys-usb-hid-mouse)

