% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWeights.R
\name{plotTopWeights}
\alias{plotTopWeights}
\title{Plot top weights}
\usage{
plotTopWeights(object, view, factor, nfeatures = 10, abs = TRUE,
  scale = TRUE, sign = "both")
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{view}{character vector with the view name, or numeric vector with the index of the view to use.}

\item{factor}{character vector with the factor name, or numeric vector with the index of the factor to use.}

\item{nfeatures}{number of top features to display.
Default is 10.}

\item{abs}{logical indicating whether to use the absolute value of the weights.
Default is TRUE.}

\item{scale}{logical indicating whether to scale all loadings from 0 to 1.
Default is TRUE.}

\item{sign}{can be 'positive', 'negative' or 'both' to show only positive,
 negative or all weigths, respectively.
Default is 'both'.}
}
\value{
Returns a \code{ggplot2} object
}
\description{
Plot top weights for a given latent factor in a given view.
}
\details{
The weights, or the loadings, provide the mapping between the high-dimensional space (the genes) and the low-dimensional space (the factors). \cr
They define a score for each gene on each factor, such that genes with no association with the factor are expected to 
have values close to zero, whereas genes with strong association with the factor are expected to have large absolute values. \cr
The sign of the loading indicates the direction of the effect: A positive loading indicates that the feature is more active 
in the cells with positive factor values, while a negative loading indicates that the feature is more active in the cells with negative factor values.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
plotTopWeights(MOFA_CLL, view="Mutations", factor=1, nfeatures=3)
plotTopWeights(MOFA_CLL, view="Mutations", factor=1, nfeatures=3, sign = "positive")
plotTopWeights(MOFA_CLL, view="Mutations", factor=1, nfeatures=3, sign = "negative")

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
plotTopWeights(MOFA_scMT, view="RNA expression", factor=1)
}
