% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpmeans.R
\name{dpmeans}
\alias{dpmeans}
\title{DP-means Algorithm for Clustering Euclidean Data}
\usage{
dpmeans(
  data,
  lambda = 1,
  maxiter = 1234,
  abstol = 1e-06,
  permute.order = FALSE
)
}
\arguments{
\item{data}{an \eqn{(n\times p)} data matrix for each row being an observation.}

\item{lambda}{a threshold to define a new cluster.}

\item{maxiter}{maximum number of iterations.}

\item{abstol}{stopping criterion}

\item{permute.order}{a logical; \code{TRUE} if random order for permutation is used, \code{FALSE} otherwise.}
}
\value{
a named list containing
\describe{
\item{cluster}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{centers}{a list containing information for out-of-sample prediction.}
}
}
\description{
DP-means is a nonparametric clustering method motivated by DP mixture model in that 
the number of clusters is determined by a parameter \eqn{\lambda}. The larger 
the \eqn{\lambda} value is, the smaller the number of clusters is attained. 
In addition to the original paper, we added an option to randomly permute 
an order of updating for each observation's membership as a common 
heuristic in the literature of cluster analysis.
}
\examples{
## define data matrix of two clusters
x1  = matrix(rnorm(50*3,mean= 2), ncol=3)
x2  = matrix(rnorm(50*3,mean=-2), ncol=3)
X   = rbind(x1,x2)
lab = c(rep(1,50),rep(2,50))

## run dpmeans with several lambda values
solA <- dpmeans(X, lambda= 5)$cluster
solB <- dpmeans(X, lambda=10)$cluster
solC <- dpmeans(X, lambda=20)$cluster

## visualize the results
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,4), pty="s")
plot(X,col=lab,  pch=19, cex=.8, main="True", xlab="x", ylab="y")
plot(X,col=solA, pch=19, cex=.8, main="dpmeans lbd=5", xlab="x", ylab="y")
plot(X,col=solB, pch=19, cex=.8, main="dpmeans lbd=10", xlab="x", ylab="y")
plot(X,col=solC, pch=19, cex=.8, main="dpmeans lbd=20", xlab="x", ylab="y")
par(opar)

\donttest{
## let's find variations by permuting orders of update
## used setting : lambda=20, we will 8 runs
sol8 <- list()
for (i in 1:8){
  sol8[[i]] = dpmeans(X, lambda=20, permute.order=TRUE)$cluster
}

## let's visualize
vpar <- par(no.readonly=TRUE)
par(mfrow=c(2,4), pty="s")
for (i in 1:8){
  pm = paste("permute no.",i,sep="")
  plot(X,col=sol8[[i]], pch=19, cex=.8, main=pm, xlab="x", ylab="y")
}
par(vpar)
}

}
\references{
\insertRef{kulis_revisiting_2012}{maotai}
}
