% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimony.R
\name{CI}
\alias{CI}
\alias{RI}
\title{Consistency Index and Retention Index}
\usage{
CI(tree, data, cost = NULL, sitewise = FALSE)

RI(tree, data, cost = NULL, sitewise = FALSE)
}
\arguments{
\item{tree}{tree to start the nni search from.}

\item{data}{A object of class phyDat containing sequences.}

\item{cost}{A cost matrix for the transitions between two states.}

\item{sitewise}{return CI/RI for alignment or sitewise}
}
\description{
\code{CI} and \code{RI} compute the Consistency Index (CI) and Retention
Index (RI).
}
\details{
The Consistency Index is defined as minimum number of changes
divided by the number of changes required on the tree (parsimony score). The
Consistency Index is equal to one if there is no homoplasy.
And the Retention Index is defined as
\deqn{RI = \frac{MaxChanges - ObsChanges}{MaxChanges - MinChanges}}{RI = (MaxChanges - ObsChanges) / (MaxChanges - MinChanges)}
}
\seealso{
\code{\link{parsimony}}, \code{\link{pratchet}},
\code{\link{fitch}}, \code{\link{sankoff}}, \code{\link{bab}},
\code{\link{ancestral.pars}}
}
