% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse.R
\name{format_glimpse}
\alias{format_glimpse}
\title{Format a vector for horizontal printing}
\usage{
format_glimpse(x, ...)
}
\arguments{
\item{x}{A vector.}

\item{...}{Arguments passed to methods.}
}
\value{
A character vector of the same length as \code{x}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This generic provides the logic for printing vectors in \code{\link[=glimpse]{glimpse()}}.

The output strives to be as unambiguous as possible,
without compromising on readability.
In a list, to distinguish between vectors and nested lists,
the latter are surrounded by \verb{[]} brackets.
Empty lists are shown as \verb{[]}.
Vectors inside lists, of length not equal to one,
are surrounded by \verb{<>} angle brackets.
Empty vectors are shown as \verb{<>}.
}
\examples{
format_glimpse(1:3)

# Lists use [], vectors inside lists use <>
format_glimpse(list(1:3))
format_glimpse(list(1, 2:3))
format_glimpse(list(list(1), list(2:3)))
format_glimpse(list(as.list(1), as.list(2:3)))
format_glimpse(list(character()))
format_glimpse(list(NULL))

# Character strings are always quoted
writeLines(format_glimpse(letters[1:3]))
writeLines(format_glimpse(c("A", "B, C")))

# Factors are quoted only when needed
writeLines(format_glimpse(factor(letters[1:3])))
writeLines(format_glimpse(factor(c("A", "B, C"))))
}
