# crack P1 / P2
# comparaison
#   uniforme de pas h 
#   adapte avec hmin = coef^2 et phi=u pour P1
#   adapte avec hmin = coef^4 et phi=grad u pour P2
#
# representation des erreurs L2, Linf et H1
# en fct de n_elt
#
# format adapt.dat:
# coef niter n_node n_elt hmin hmax err_l2 err_infty err_h1
#  1     2     3     4     5    6    7       8        9

# format uniform.dat:
# i n_node n_elt h err_l2 err_infty err_h1
# 1   2      3   4   5       6        7

set logscale
set size square

set xlabel "n_dof"
set title "erreur H1"
plot \
	"crack-adapt-P1.dat" u 3:9 w lp, \
     	"crack-uniform-P1.dat" u 2:7 w lp, \
	"crack-adapt-P2.dat" u (($3)+($4)):9 w lp, \
     	"crack-uniform-P2.dat" u (($2)+($3)):7 w lp, \
     	0.1*x**(-0.25)
pause -1 "<retour>"

set title "erreur L2"
plot \
	"crack-adapt-P1.dat" u 3:7 w lp, \
     	"crack-uniform-P1.dat" u 2:5 w lp, \
	"crack-adapt-P2.dat" u (($3)+($4)):7 w lp, \
     	"crack-uniform-P2.dat" u (($2)+($3)):5 w lp, \
     	0.1*x**(-3./4)
pause -1 "<retour>"

set title "erreur Linf"
plot \
	"crack-adapt-P1.dat" u 3:8 w lp, \
     	"crack-uniform-P1.dat" u 2:6 w lp, \
	"crack-adapt-P2.dat" u (($3)+($4)):8 w lp, \
     	"crack-uniform-P2.dat" u (($2)+($3)):6 w lp, \
     	0.1*x**(-0.25)
pause -1 "<retour>"


