/**********************************************************
 * Version $Id: MLB_Interface.cpp 2359 2014-12-27 12:46:46Z reklov_w $
 *********************************************************/

///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    Module Library:                    //
//                       io_virtual                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   MLB_Interface.cpp                   //
//                                                       //
//                 Copyright (C) 2003 by                 //
//                      Olaf Conrad                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation; version 2 of the License.   //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not,       //
// write to the Free Software Foundation, Inc.,          //
// 51 Franklin Street, 5th Floor, Boston, MA 02110-1301, //
// USA.                                                  //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Goettingen               //
//                Goldschmidtstr. 5                      //
//                37077 Goettingen                       //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------


///////////////////////////////////////////////////////////
//														 //
//			The Module Link Library Interface			 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
// 1. Include the appropriate SAGA-API header...

#include "MLB_Interface.h"


//---------------------------------------------------------
// 2. Place general module library informations here...

CSG_String Get_Info(int i)
{
	switch( i )
	{
	case MLB_INFO_Name:	default:
		return( _TL("Virtual") );

	case MLB_INFO_Category:
		return( _TL("Import/Export") );

	case MLB_INFO_Author:
		return( SG_T("SAGA User Group Associaton (c) 2014") );

	case MLB_INFO_Description:
		return( _TL("Tools for the handling of virtual datasets.") );

	case MLB_INFO_Version:
		return( SG_T("1.0") );

	case MLB_INFO_Menu_Path:
		return( _TL("File|Virtual") );
	}
}


//---------------------------------------------------------
// 3. Include the headers of your modules here...

#include "pc_create_spcvf.h"
#include "pc_get_subset_spcvf.h"
#include "pc_tileshape_from_spcvf.h"
#include "pc_get_grid_spcvf.h"
#include "pc_remove_overlap_from_spcvf.h"


//---------------------------------------------------------
// 4. Allow your modules to be created here...

CSG_Module *		Create_Module(int i)
{
	switch( i )
	{
	case 0:		return( new CPointCloud_Create_SPCVF );
	case 1:		return( new CPointCloud_Get_Subset_SPCVF );
	case 2:		return( new CPointCloud_Create_Tileshape_From_SPCVF );
	case 3:		return( new CPointCloud_Get_Subset_SPCVF_Interactive );
	case 4:		return( new CPointCloud_Get_Grid_SPCVF );
	case 5:		return( new CPointCloud_Get_Grid_SPCVF_Interactive );
	case 6:		return( new CPointCloud_Remove_Overlap_From_SPCVF );
	}

	return( NULL );
}


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
//{{AFX_SAGA

	MLB_INTERFACE

//}}AFX_SAGA
