// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __xxlib_h__
#define __xxlib_h__

#include <tcl.h>
#include <tk.h>

// direct X11 to Tk

char* XImageData(XImage* ximage);

extern "C" {

  // available in blt/src/bltMacOSX.c
  void XPutImage(Display* display, Drawable d, GC gc, XImage* image,
		 int src_x, int src_y, int dest_x, int dest_y,
		 unsigned int width, unsigned int height);
  void XFreePixmap(Display*, Pixmap);

  // New Routines
  void XDrawString(Display* display, Drawable drawable, GC gc, 
		   int x, int y, _Xconst char* str, int length);

  Pixmap XCreatePixmap(Display* display, Drawable drawable, 
		       unsigned int width, unsigned int height,
		       unsigned int depth);

  void XSetClipRectangles(Display* display, GC gc, int clip_x_origin,
			  int  clip_y_origin, XRectangle* r,
			  int  n, int  ordering);

  // Redefined Routines
  XImage *XXGetImage(Display *display, Drawable drawable, int x, int y,
		     unsigned int width, unsigned int height,
		     unsigned long plane_mask, int format);

  Bool XXQueryPointer(Display* display, Window w, 
		      Window* root_return, Window* child_return, 
		      int* root_x_return, int* root_y_return, 
		      int* win_x_return, int* win_y_return, 
		      unsigned int* mask_return);

  void XXWarpPointer(Display* display, Window src_w, Window dest_w,
		     int src_x, int src_y,
		     unsigned int src_width, unsigned int src_height,
		     int dest_x, int dest_y);
}

#endif
