/* tracker-utils.c generated by valac 0.22.1, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))



#define secs_per_day ((60 * 60) * 24)
gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void uri_launch (const gchar* uri);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col);
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	const gchar* uri = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = model;
	_tmp1_ = path;
	gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = model;
	_tmp4_ = iter;
	_tmp5_ = col;
	gtk_tree_model_get (_tmp3_, &_tmp4_, _tmp5_, &uri, -1);
	_tmp6_ = g_strdup (uri);
	result = _tmp6_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void uri_launch (const gchar* uri) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = string_index_of (_tmp0_, "://", 0);
	if (_tmp1_ < 1) {
		gchar** command = NULL;
		const gchar* _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint command_length1 = 0;
		gint _command_size_ = 0;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		GPid child_pid = 0;
		gchar** argv = NULL;
		gchar** _tmp7_ = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GPid _tmp22_ = 0;
		_tmp2_ = uri;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
		command = _tmp4_;
		command_length1 = _vala_array_length (_tmp3_);
		_command_size_ = command_length1;
		_tmp5_ = command;
		_tmp5__length1 = command_length1;
		_tmp6_ = _tmp5_[0];
		g_debug ("tracker-utils.vala:39: Attempting to spawn_async() '%s'", _tmp6_);
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		argv = _tmp7_;
		argv_length1 = 1;
		_argv_size_ = argv_length1;
		_tmp8_ = argv;
		_tmp8__length1 = argv_length1;
		_tmp9_ = command;
		_tmp9__length1 = command_length1;
		_tmp10_ = _tmp9_[0];
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp8_[0]);
		_tmp8_[0] = _tmp11_;
		_tmp12_ = _tmp8_[0];
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			GPid _tmp14_ = 0;
			_tmp13_ = argv;
			_tmp13__length1 = argv_length1;
			g_spawn_async ("/usr/bin", _tmp13_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp14_, &_inner_error_);
			child_pid = _tmp14_;
			if (_inner_error_ != NULL) {
				goto __catch22_g_error;
			}
		}
		goto __finally22;
		__catch22_g_error:
		{
			GError* e = NULL;
			gchar** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			const gchar* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			GError* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = command;
			_tmp15__length1 = command_length1;
			_tmp16_ = _tmp15_[0];
			_tmp17_ = e;
			_tmp18_ = _tmp17_->code;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->code;
			_tmp21_ = g_strerror (_tmp20_);
			g_warning ("tracker-utils.vala:53: Could not launch '%s', %d->%s", _tmp16_, _tmp18_, _tmp21_);
			_g_error_free0 (e);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		__finally22:
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp22_ = child_pid;
		g_debug ("tracker-utils.vala:57: Launched application with PID:%d", (gint) _tmp22_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	{
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = uri;
		g_debug ("tracker-utils.vala:62: Attempting to launch application for uri:'%s'", _tmp23_);
		_tmp24_ = uri;
		g_app_info_launch_default_for_uri (_tmp24_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strconcat ("Could not launch application: ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		g_warning ("tracker-utils.vala:65: %s", _tmp28_);
		_g_free0 (_tmp28_);
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* uri = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = model;
	_tmp1_ = path;
	_tmp2_ = col;
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
	uri = _tmp3_;
	g_debug ("tracker-utils.vala:71: Selected uri:'%s'", uri);
	uri_launch (uri);
	_g_free0 (uri);
}


void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* uri = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	GFile* f = NULL;
	GFile* _tmp4_ = NULL;
	GFile* p = NULL;
	GFile* _tmp5_ = NULL;
	gchar* parent_uri = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = model;
	_tmp1_ = path;
	_tmp2_ = col;
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
	uri = _tmp3_;
	g_debug ("tracker-utils.vala:78: Selected uri:'%s'", uri);
	_tmp4_ = g_file_new_for_uri (uri);
	f = _tmp4_;
	_tmp5_ = g_file_get_parent (f);
	p = _tmp5_;
	_tmp6_ = g_file_get_uri (p);
	parent_uri = _tmp6_;
	g_debug ("tracker-utils.vala:84: Parent uri:'%s'", parent_uri);
	uri_launch (parent_uri);
	_g_free0 (parent_uri);
	_g_object_unref0 (p);
	_g_object_unref0 (f);
	_g_free0 (uri);
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp2_ = format;
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	buffer = (g_free (buffer), NULL);
	return result;
}


gchar* tracker_time_format_from_iso8601 (const gchar* s) {
	gchar* result = NULL;
	struct tm t = {0};
	const gchar* _tmp0_ = NULL;
	GTimeVal tv_now = {0};
	GTimeVal tv_then = {0};
	const gchar* _tmp1_ = NULL;
	glong diff_sec = 0L;
	GTimeVal _tmp2_ = {0};
	glong _tmp3_ = 0L;
	GTimeVal _tmp4_ = {0};
	glong _tmp5_ = 0L;
	glong diff_days = 0L;
	glong _tmp6_ = 0L;
	glong diff_days_abs = 0L;
	glong _tmp7_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp9_ = 0L;
	glong _tmp12_ = 0L;
	g_return_val_if_fail (s != NULL, NULL);
	memset (&t, 0, sizeof (struct tm));
	_tmp0_ = s;
	strptime (_tmp0_, "%FT%T", &t);
	g_get_current_time (&tv_now);
	g_get_current_time (&tv_now);
	g_get_current_time (&tv_then);
	_tmp1_ = s;
	g_time_val_from_iso8601 (_tmp1_, &tv_then);
	_tmp2_ = tv_now;
	_tmp3_ = _tmp2_.tv_sec;
	_tmp4_ = tv_then;
	_tmp5_ = _tmp4_.tv_sec;
	diff_sec = _tmp3_ - _tmp5_;
	_tmp6_ = diff_sec;
	diff_days = _tmp6_ / secs_per_day;
	_tmp7_ = diff_days;
	_tmp8_ = labs (_tmp7_);
	diff_days_abs = _tmp8_;
	_tmp9_ = diff_days_abs;
	if (_tmp9_ > ((glong) 7)) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = _ ("%x");
		_tmp11_ = g_time_format (&t, _tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = diff_days_abs;
	if (_tmp12_ == ((glong) 0)) {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp13_ = _ ("Today");
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		return result;
	} else {
		gboolean future = FALSE;
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		future = FALSE;
		_tmp15_ = diff_days;
		if (_tmp15_ < ((glong) 0)) {
			future = TRUE;
		}
		_tmp16_ = diff_days;
		if (_tmp16_ <= ((glong) 1)) {
			gboolean _tmp17_ = FALSE;
			_tmp17_ = future;
			if (_tmp17_) {
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp18_ = _ ("Tomorrow");
				_tmp19_ = g_strdup (_tmp18_);
				result = _tmp19_;
				return result;
			} else {
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				_tmp20_ = _ ("Yesterday");
				_tmp21_ = g_strdup (_tmp20_);
				result = _tmp21_;
				return result;
			}
		} else {
			gboolean _tmp22_ = FALSE;
			_tmp22_ = future;
			if (_tmp22_) {
				glong _tmp23_ = 0L;
				const gchar* _tmp24_ = NULL;
				glong _tmp25_ = 0L;
				gchar* _tmp26_ = NULL;
				_tmp23_ = diff_days_abs;
				_tmp24_ = ngettext ("%ld day from now", "%ld days from now", (gulong) _tmp23_);
				_tmp25_ = diff_days_abs;
				_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_);
				result = _tmp26_;
				return result;
			} else {
				glong _tmp27_ = 0L;
				const gchar* _tmp28_ = NULL;
				glong _tmp29_ = 0L;
				gchar* _tmp30_ = NULL;
				_tmp27_ = diff_days_abs;
				_tmp28_ = ngettext ("%ld day ago", "%ld days ago", (gulong) _tmp27_);
				_tmp29_ = diff_days_abs;
				_tmp30_ = g_strdup_printf (_tmp28_, _tmp29_);
				result = _tmp30_;
				return result;
			}
		}
	}
}


gchar* tracker_time_format_from_seconds (const gchar* seconds_str) {
	gchar* result = NULL;
	gdouble seconds = 0.0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble total = 0.0;
	gint d = 0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GString* output = NULL;
	GString* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp18_ = 0;
	gint _tmp23_ = 0;
	const gchar* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	GString* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GString* _tmp38_ = NULL;
	gssize _tmp39_ = 0L;
	gchar* str = NULL;
	GString* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	g_return_val_if_fail (seconds_str != NULL, NULL);
	_tmp0_ = seconds_str;
	_tmp1_ = atoi (_tmp0_);
	seconds = (gdouble) _tmp1_;
	_tmp2_ = seconds;
	if (_tmp2_ == 0.0) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = _ ("Less than one second");
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = seconds;
	total = _tmp5_;
	_tmp6_ = total;
	s = ((gint) _tmp6_) % 60;
	_tmp7_ = total;
	total = _tmp7_ / 60;
	_tmp8_ = total;
	m = ((gint) _tmp8_) % 60;
	_tmp9_ = total;
	total = _tmp9_ / 60;
	_tmp10_ = total;
	h = ((gint) _tmp10_) % 24;
	_tmp11_ = total;
	d = ((gint) _tmp11_) / 24;
	_tmp12_ = g_string_new ("");
	output = _tmp12_;
	_tmp13_ = d;
	if (_tmp13_ > 0) {
		GString* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp14_ = output;
		_tmp15_ = d;
		_tmp16_ = g_strdup_printf (" %dd", _tmp15_);
		_tmp17_ = _tmp16_;
		g_string_append (_tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
	}
	_tmp18_ = h;
	if (_tmp18_ > 0) {
		GString* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp19_ = output;
		_tmp20_ = h;
		_tmp21_ = g_strdup_printf (" %.2d", _tmp20_);
		_tmp22_ = _tmp21_;
		g_string_append (_tmp19_, _tmp22_);
		_g_free0 (_tmp22_);
	}
	_tmp23_ = m;
	if (_tmp23_ > 0) {
		const gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		GString* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp25_ = h;
		if (_tmp25_ > 0) {
			_tmp24_ = ":";
		} else {
			_tmp24_ = "";
		}
		_tmp26_ = output;
		_tmp27_ = _tmp24_;
		_tmp28_ = m;
		_tmp29_ = g_strdup_printf ("%s%.2d", _tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		g_string_append (_tmp26_, _tmp30_);
		_g_free0 (_tmp30_);
	}
	_tmp32_ = m;
	if (_tmp32_ > 0) {
		_tmp31_ = ":";
	} else {
		_tmp31_ = "0:";
	}
	_tmp33_ = output;
	_tmp34_ = _tmp31_;
	_tmp35_ = s;
	_tmp36_ = g_strdup_printf ("%s%.2d", _tmp34_, _tmp35_);
	_tmp37_ = _tmp36_;
	g_string_append (_tmp33_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = output;
	_tmp39_ = _tmp38_->len;
	if (_tmp39_ < ((gssize) 1)) {
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		_tmp40_ = _ ("Less than one second");
		_tmp41_ = g_strdup (_tmp40_);
		result = _tmp41_;
		_g_string_free0 (output);
		return result;
	}
	_tmp42_ = output;
	_tmp43_ = _tmp42_->str;
	_tmp44_ = g_strdup (_tmp43_);
	str = _tmp44_;
	_tmp45_ = str;
	_tmp46_ = g_strchug (_tmp45_);
	_tmp47_ = g_strdup (_tmp46_);
	result = _tmp47_;
	_g_free0 (str);
	_g_string_free0 (output);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image) {
	GdkPixbuf* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	gpointer _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GdkPixbuf* _tmp51_ = NULL;
	GtkIconTheme* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	GdkPixbuf* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (theme != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = NULL;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GDK_TYPE_PIXBUF) ? ((GdkPixbuf*) _tmp2_) : NULL);
	pixbuf = _tmp3_;
	_tmp4_ = is_image;
	if (_tmp4_) {
		GdkPixbuf* _tmp17_ = NULL;
		{
			GdkPixbuf* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			GdkPixbuf* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_ = NULL;
			_tmp6_ = file;
			_tmp7_ = g_file_get_path (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = size;
			_tmp10_ = size;
			_tmp11_ = gdk_pixbuf_new_from_file_at_size (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp8_);
			_tmp5_ = _tmp12_;
			if (_inner_error_ != NULL) {
				goto __catch24_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp5_;
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			_tmp15_ = g_strconcat ("Error loading icon pixbuf: ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			g_warning ("tracker-utils.vala:188: %s", _tmp16_);
			_g_free0 (_tmp16_);
			_g_error_free0 (e);
		}
		__finally24:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = pixbuf;
		if (_tmp17_ != NULL) {
			result = pixbuf;
			_g_object_unref0 (file);
			return result;
		}
	}
	_tmp18_ = file;
	_tmp19_ = g_file_query_exists (_tmp18_, NULL);
	if (_tmp19_) {
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp20_ = NULL;
			GFileInfo* _tmp21_ = NULL;
			GFileInfo* _tmp22_ = NULL;
			_tmp20_ = file;
			_tmp21_ = g_file_query_info (_tmp20_, "standard::icon", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp21_;
			if (_inner_error_ != NULL) {
				goto __catch25_g_error;
			}
			_tmp22_ = file_info;
			if (_tmp22_ != NULL) {
				GIcon* icon = NULL;
				GFileInfo* _tmp23_ = NULL;
				GIcon* _tmp24_ = NULL;
				GIcon* _tmp25_ = NULL;
				_tmp23_ = file_info;
				_tmp24_ = g_file_info_get_icon (_tmp23_);
				_tmp25_ = _g_object_ref0 (_tmp24_);
				icon = _tmp25_;
				{
					GIcon* _tmp26_ = NULL;
					_tmp26_ = icon;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, g_file_icon_get_type ())) {
						GdkPixbuf* _tmp27_ = NULL;
						GIcon* _tmp28_ = NULL;
						GFile* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						GdkPixbuf* _tmp32_ = NULL;
						GdkPixbuf* _tmp33_ = NULL;
						_tmp28_ = icon;
						_tmp29_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, g_file_icon_get_type (), GFileIcon));
						_tmp30_ = g_file_get_path (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = gdk_pixbuf_new_from_file (_tmp31_, &_inner_error_);
						_tmp33_ = _tmp32_;
						_g_free0 (_tmp31_);
						_tmp27_ = _tmp33_;
						if (_inner_error_ != NULL) {
							goto __catch26_g_error;
						}
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp27_;
					} else {
						GIcon* _tmp34_ = NULL;
						_tmp34_ = icon;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, g_themed_icon_get_type ())) {
							GdkPixbuf* _tmp35_ = NULL;
							GtkIconTheme* _tmp36_ = NULL;
							GIcon* _tmp37_ = NULL;
							gchar** _tmp38_ = NULL;
							gchar** _tmp39_ = NULL;
							const gchar* _tmp40_ = NULL;
							gint _tmp41_ = 0;
							GdkPixbuf* _tmp42_ = NULL;
							_tmp36_ = theme;
							_tmp37_ = icon;
							_tmp39_ = _tmp38_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, g_themed_icon_get_type (), GThemedIcon));
							_tmp40_ = _tmp39_[0];
							_tmp41_ = size;
							_tmp42_ = gtk_icon_theme_load_icon (_tmp36_, _tmp40_, _tmp41_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
							_tmp35_ = _tmp42_;
							if (_inner_error_ != NULL) {
								goto __catch26_g_error;
							}
							_g_object_unref0 (pixbuf);
							pixbuf = _tmp35_;
						}
					}
				}
				goto __finally26;
				__catch26_g_error:
				{
					GError* e = NULL;
					GError* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp43_ = e;
					_tmp44_ = _tmp43_->message;
					_tmp45_ = g_strconcat ("Error loading icon pixbuf: ", _tmp44_, NULL);
					_tmp46_ = _tmp45_;
					g_warning ("tracker-utils.vala:212: %s", _tmp46_);
					_g_free0 (_tmp46_);
					_g_error_free0 (e);
				}
				__finally26:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (icon);
					_g_object_unref0 (file_info);
					goto __catch25_g_error;
				}
				_g_object_unref0 (icon);
			}
			_g_object_unref0 (file_info);
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError* e = NULL;
			GError* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp47_ = e;
			_tmp48_ = _tmp47_->message;
			_tmp49_ = g_strconcat ("Error looking up file for pixbuf: ", _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			g_warning ("tracker-utils.vala:216: %s", _tmp50_);
			_g_free0 (_tmp50_);
			_g_error_free0 (e);
		}
		__finally25:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp51_ = pixbuf;
	if (_tmp51_ != NULL) {
		result = pixbuf;
		_g_object_unref0 (file);
		return result;
	}
	_tmp52_ = theme;
	_tmp53_ = size;
	_tmp54_ = tracker_pixbuf_new_from_name (_tmp52_, "text-x-generic", _tmp53_);
	result = _tmp54_;
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (file);
	return result;
}


GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	gpointer _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (theme != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GDK_TYPE_PIXBUF) ? ((GdkPixbuf*) _tmp0_) : NULL);
	pixbuf = _tmp1_;
	{
		GdkPixbuf* _tmp2_ = NULL;
		GtkIconTheme* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GdkPixbuf* _tmp6_ = NULL;
		_tmp3_ = theme;
		_tmp4_ = name;
		_tmp5_ = size;
		_tmp6_ = gtk_icon_theme_load_icon (_tmp3_, _tmp4_, _tmp5_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
		_tmp2_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp2_;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = name;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("tracker-utils.vala:234: Could not load default icon pixbuf from theme " \
"for '%s': %s", _tmp7_, _tmp9_);
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = pixbuf;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



